#line 6 "ncx.m4"
/* Do not edit this file. It is produced from the corresponding .m4 source */
#line 8
/*
 *  Copyright (C) 2014, Northwestern University and Argonne National Laboratory
 *  See COPYRIGHT notice in top-level directory.
 */
/* $Id: ncx.m4 2601 2016-11-07 04:54:42Z wkliao $ */

#ifdef __GNUC__
#pragma GCC diagnostic ignored "-Wunused-parameter"
#endif

#line 22

#line 26


#line 34


#line 35
#if HAVE_CONFIG_H
#line 35
#include <config.h>
#line 35
#endif
#line 42
#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>


#line 48
#pragma GCC diagnostic ignored "-Wdeprecated"
#line 48
#include "ncx.h"
#line 48
#include "nc3dispatch.h"
#line 54

#line 72




#ifdef HAVE_INTTYPES_H
#include <inttypes.h> /* uint16_t, uint32_t, uint64_t */
#elif defined(HAVE_STDINT_H)
#include <stdint.h>   /* uint16_t, uint32_t, uint64_t */
#endif

#line 103

#line 121

/*
 * The only error code returned from subroutines in this file is NC_ERANGE,
 * if errors are detected.
 */

/*
 * An external data representation interface.
 */

/* alias poorly named limits.h macros */
#define  SHORT_MAX  SHRT_MAX
#define  SHORT_MIN  SHRT_MIN
#define USHORT_MAX USHRT_MAX
#ifndef LLONG_MAX
#   define LLONG_MAX	9223372036854775807LL
#   define LLONG_MIN	(-LLONG_MAX - 1LL)
#   define ULLONG_MAX	18446744073709551615ULL
#endif
#ifndef LONG_LONG_MAX
#define LONG_LONG_MAX LLONG_MAX
#endif
#ifndef LONGLONG_MAX
#define LONGLONG_MAX LONG_LONG_MAX
#endif
#ifndef LONG_LONG_MIN
#define LONG_LONG_MIN LLONG_MIN
#endif
#ifndef LONGLONG_MIN
#define LONGLONG_MIN LONG_LONG_MIN
#endif
#ifndef ULONG_LONG_MAX
#define ULONG_LONG_MAX ULLONG_MAX
#endif
#ifndef ULONGLONG_MAX
#define ULONGLONG_MAX ULONG_LONG_MAX
#endif
#include <float.h>
#ifndef FLT_MAX /* This POSIX macro missing on some systems */
# ifndef NO_IEEE_FLOAT
# define FLT_MAX 3.40282347e+38f
# else
# error "You will need to define FLT_MAX"
# endif
#endif
/* alias poorly named float.h macros */
#define FLOAT_MAX FLT_MAX
#define FLOAT_MIN (-FLT_MAX)
#define DOUBLE_MAX DBL_MAX
#define DOUBLE_MIN (-DBL_MAX)
#define FLOAT_MAX_EXP FLT_MAX_EXP
#define DOUBLE_MAX_EXP DBL_MAX_EXP
#include <assert.h>
#define UCHAR_MIN 0
#define Min(a,b) ((a) < (b) ? (a) : (b))
#define Max(a,b) ((a) > (b) ? (a) : (b))

#ifndef SIZEOF_UCHAR
#ifdef  SIZEOF_UNSIGNED_CHAR
#define SIZEOF_UCHAR SIZEOF_UNSIGNED_CHAR
#else
#error "unknown SIZEOF_UCHAR"
#endif
#endif

#ifndef SIZEOF_USHORT
#ifdef  SIZEOF_UNSIGNED_SHORT_INT
#define SIZEOF_USHORT SIZEOF_UNSIGNED_SHORT_INT
#elif defined(SIZEOF_UNSIGNED_SHORT)
#define SIZEOF_USHORT SIZEOF_UNSIGNED_SHORT
#else
#error "unknown SIZEOF_USHORT"
#endif
#endif

#ifndef SIZEOF_UINT
#ifdef  SIZEOF_UNSIGNED_INT
#define SIZEOF_UINT SIZEOF_UNSIGNED_INT
#else
#error "unknown SIZEOF_UINT"
#endif
#endif

#ifndef SIZEOF_LONGLONG
#ifdef  SIZEOF_LONG_LONG
#define SIZEOF_LONGLONG SIZEOF_LONG_LONG
#else
#error "unknown SIZEOF_LONGLONG"
#endif
#endif

#ifndef SIZEOF_INT64
#ifdef  SIZEOF_LONG_LONG
#define SIZEOF_INT64 SIZEOF_LONG_LONG
#elif defined(SIZEOF_LONGLONG)
#define SIZEOF_INT64 SIZEOF_LONGLONG
#else
#error "unknown SIZEOF_INT64"
#endif
#endif

#ifndef SIZEOF_ULONGLONG
#ifdef  SIZEOF_UNSIGNED_LONG_LONG
#define SIZEOF_ULONGLONG SIZEOF_UNSIGNED_LONG_LONG
#else
#error "unknown SIZEOF_ULONGLONG"
#endif
#endif

#ifndef SIZEOF_UINT64
#ifdef  SIZEOF_UNSIGNED_LONG_LONG
#define SIZEOF_UINT64 SIZEOF_UNSIGNED_LONG_LONG
#elif defined(SIZEOF_ULONGLONG)
#define SIZEOF_UINT64 SIZEOF_ULONGLONG
#else
#error "unknown SIZEOF_UINT64"
#endif
#endif

/*
 * If the machine's float domain is "smaller" than the external one
 * use the machine domain
 */
#if defined(FLT_MAX_EXP) && FLT_MAX_EXP < 128 /* 128 is X_FLT_MAX_EXP */
#undef X_FLOAT_MAX
# define X_FLOAT_MAX FLT_MAX
#undef X_FLOAT_MIN
# define X_FLOAT_MIN (-X_FLOAT_MAX)
#endif

#if defined(_SX) && _SX != 0 /* NEC SUPER UX */
#define LOOPCNT 256    /* must be no longer than hardware vector length */
#if _INT64
#undef  INT_MAX /* workaround cpp bug */
#define INT_MAX  X_INT_MAX
#undef  INT_MIN /* workaround cpp bug */
#define INT_MIN  X_INT_MIN
#undef  LONG_MAX /* workaround cpp bug */
#define LONG_MAX  X_INT_MAX
#undef  LONG_MIN /* workaround cpp bug */
#define LONG_MIN  X_INT_MIN
#elif _LONG64
#undef  LONG_MAX /* workaround cpp bug */
#define LONG_MAX  4294967295L
#undef  LONG_MIN /* workaround cpp bug */
#define LONG_MIN -4294967295L
#endif
#if !_FLOAT0
#error "FLOAT1 and FLOAT2 not supported"
#endif
#endif /* _SX */

static const char nada[X_ALIGN] = {0, 0, 0, 0};

#ifndef WORDS_BIGENDIAN
/* LITTLE_ENDIAN: DEC and intel */
/*
 * Routines to convert to BIG ENDIAN.
 * Optimize the swapn?b() and swap?b() routines aggressively.
 */

#define SWAP2(a) ( (((a) & 0xff) << 8) | \
                   (((a) >> 8) & 0xff) )

#define SWAP4(a) ( ((a) << 24) | \
                  (((a) <<  8) & 0x00ff0000) | \
                  (((a) >>  8) & 0x0000ff00) | \
                  (((a) >> 24) & 0x000000ff) )

#define SWAP8(a) ( (((a) & 0x00000000000000FFULL) << 56) | \
                   (((a) & 0x000000000000FF00ULL) << 40) | \
                   (((a) & 0x0000000000FF0000ULL) << 24) | \
                   (((a) & 0x00000000FF000000ULL) <<  8) | \
                   (((a) & 0x000000FF00000000ULL) >>  8) | \
                   (((a) & 0x0000FF0000000000ULL) >> 24) | \
                   (((a) & 0x00FF000000000000ULL) >> 40) | \
                   (((a) & 0xFF00000000000000ULL) >> 56) )

#if defined(_MSC_VER) && _MSC_VER < 1900
#define inline __inline
#endif

inline static void
swapn2b(void *dst, const void *src, size_t nn)
{
    /* it is OK if dst == src */
    size_t i;
    char *op = (char*) dst;
    char *ip = (char*) src;
    uint16_t tmp;
    for (i=0; i<nn; i++) {
        /* memcpy is used to handle the case of unaligned memory */
        memcpy(&tmp, ip, sizeof(tmp));
        tmp = SWAP2(tmp);
        memcpy(op, &tmp, sizeof(tmp));
        ip += sizeof(uint16_t);
        op += sizeof(uint16_t);
    }
}

# ifndef vax
inline static void
swap4b(void *dst, const void *src)
{
    uint32_t tmp;
    /* memcpy is used to handle the case of unaligned memory */
    memcpy(&tmp, src, sizeof(tmp));
    tmp = SWAP4(tmp);
    memcpy(dst, &tmp, 4);
}
# endif /* !vax */

inline static void
swapn4b(void *dst, const void *src, size_t nn)
{
    size_t i;
    char *op = (char*) dst;
    char *ip = (char*) src;
    uint32_t tmp;
    for (i=0; i<nn; i++) {
        /* memcpy is used to handle the case of unaligned memory */
        memcpy(&tmp, ip, sizeof(tmp));
        tmp = SWAP4(tmp);
        memcpy(op, &tmp, sizeof(tmp));
        ip += sizeof(uint32_t);
        op += sizeof(uint32_t);
    }
}

# ifndef vax
inline static void
swap8b(void *dst, const void *src)
{
    uint64_t tmp;
    /* memcpy is used to handle the case of unaligned memory */
    memcpy(&tmp, src, sizeof(tmp));
    tmp = SWAP8(tmp);
    memcpy(dst, &tmp, 8);
}
# endif /* !vax */

# ifndef vax
inline static void
swapn8b(void *dst, const void *src, size_t nn)
{
    size_t i;
    char *op = (char*) dst;
    char *ip = (char*) src;
    uint64_t tmp;
    for (i=0; i<nn; i++) {
        /* memcpy is used to handle the case of unaligned memory */
        memcpy(&tmp, ip, sizeof(tmp));
        tmp = SWAP8(tmp);
        memcpy(op, &tmp, sizeof(tmp));
        ip += sizeof(uint64_t);
        op += sizeof(uint64_t);
    }
}
# endif /* !vax */

#endif /* LITTLE_ENDIAN */

#line 406

#line 410

#line 422

#line 437


/*
 * Primitive numeric conversion functions.
 */

#line 465

#line 513

#line 546

#line 592

/* x_schar */
/* x_uchar */

/* We don't implement any x_schar and x_uchar primitives. */


/* external NC_SHORT --------------------------------------------------------*/

#if SHORT_MAX == X_SHORT_MAX
typedef short ix_short;
#define SIZEOF_IX_SHORT SIZEOF_SHORT
#define IX_SHORT_MAX SHORT_MAX
#elif INT_MAX >= X_SHORT_MAX
typedef int ix_short;
#define SIZEOF_IX_SHORT SIZEOF_INT
#define IX_SHORT_MAX INT_MAX
#elif LONG_MAX >= X_SHORT_MAX
typedef long ix_short;
#define SIZEOF_IX_SHORT SIZEOF_LONG
#define IX_SHORT_MAX LONG_MAX
#elif LLONG_MAX >= X_SHORT_MAX
typedef long long ix_short;
#define SIZEOF_IX_SHORT SIZEOF_LONGLONG
#define IX_SHORT_MAX LLONG_MAX
#else
#error "ix_short implementation"
#endif

static void
get_ix_short(const void *xp, ix_short *ip)
{
	const uchar *cp = (const uchar *) xp;
	*ip = (ix_short)(*cp++ << 8);
#if SIZEOF_IX_SHORT > X_SIZEOF_SHORT
	if (*ip & 0x8000)
	{
		/* extern is negative */
		*ip |= (~(0xffff)); /* N.B. Assumes "twos complement" */
	}
#endif
	*ip = (ix_short)(*ip | *cp);
}

static void
put_ix_short(void *xp, const ix_short *ip)
{
	uchar *cp = (uchar *) xp;
	*cp++ = (uchar)((*ip) >> 8);
	*cp   = (uchar)((*ip) & 0xff);
}

static int
#line 644
ncx_get_short_schar(const void *xp, schar *ip)
#line 644
{
#line 644
    int err=NC_NOERR;
#line 644
    ix_short xx = 0;
#line 644
    get_ix_short(xp, &xx);
#line 644

#line 644
#if IX_SHORT_MAX > SCHAR_MAX
#line 644
    if (xx > SCHAR_MAX || xx < SCHAR_MIN) {
#line 644
#ifdef ERANGE_FILL
#line 644
        *ip = NC_FILL_BYTE;
#line 644
        return NC_ERANGE;
#line 644
#else
#line 644
        err = NC_ERANGE;
#line 644
#endif
#line 644
    }
#line 644
#endif
#line 644

#line 644

#line 644
    *ip = (schar) xx;
#line 644
    return err;
#line 644
}
#line 644

static int
#line 645
ncx_get_short_short(const void *xp, short *ip)
#line 645
{
#line 645
    int err=NC_NOERR;
#line 645
#if SIZEOF_IX_SHORT == SIZEOF_SHORT && IX_SHORT_MAX == SHORT_MAX
#line 645
    get_ix_short(xp, (ix_short *)ip);
#line 645
#else
#line 645
    ix_short xx = 0;
#line 645
    get_ix_short(xp, &xx);
#line 645

#line 645
#if IX_SHORT_MAX > SHORT_MAX
#line 645
    if (xx > SHORT_MAX || xx < SHORT_MIN) {
#line 645
#ifdef ERANGE_FILL
#line 645
        *ip = NC_FILL_SHORT;
#line 645
        return NC_ERANGE;
#line 645
#else
#line 645
        err = NC_ERANGE;
#line 645
#endif
#line 645
    }
#line 645
#endif
#line 645

#line 645

#line 645
    *ip = (short) xx;
#line 645
#endif
#line 645
    return err;
#line 645
}
#line 645

static int
#line 646
ncx_get_short_int(const void *xp, int *ip)
#line 646
{
#line 646
    int err=NC_NOERR;
#line 646
#if SIZEOF_IX_SHORT == SIZEOF_INT && IX_SHORT_MAX == INT_MAX
#line 646
    get_ix_short(xp, (ix_short *)ip);
#line 646
#else
#line 646
    ix_short xx = 0;
#line 646
    get_ix_short(xp, &xx);
#line 646

#line 646
#if IX_SHORT_MAX > INT_MAX
#line 646
    if (xx > INT_MAX || xx < INT_MIN) {
#line 646
#ifdef ERANGE_FILL
#line 646
        *ip = NC_FILL_INT;
#line 646
        return NC_ERANGE;
#line 646
#else
#line 646
        err = NC_ERANGE;
#line 646
#endif
#line 646
    }
#line 646
#endif
#line 646

#line 646

#line 646
    *ip = (int) xx;
#line 646
#endif
#line 646
    return err;
#line 646
}
#line 646

static int
#line 647
ncx_get_short_long(const void *xp, long *ip)
#line 647
{
#line 647
    int err=NC_NOERR;
#line 647
#if SIZEOF_IX_SHORT == SIZEOF_LONG && IX_SHORT_MAX == LONG_MAX
#line 647
    get_ix_short(xp, (ix_short *)ip);
#line 647
#else
#line 647
    ix_short xx = 0;
#line 647
    get_ix_short(xp, &xx);
#line 647

#line 647
#if IX_SHORT_MAX > LONG_MAX
#line 647
    if (xx > LONG_MAX || xx < LONG_MIN) {
#line 647
#ifdef ERANGE_FILL
#line 647
        *ip = NC_FILL_INT;
#line 647
        return NC_ERANGE;
#line 647
#else
#line 647
        err = NC_ERANGE;
#line 647
#endif
#line 647
    }
#line 647
#endif
#line 647

#line 647

#line 647
    *ip = (long) xx;
#line 647
#endif
#line 647
    return err;
#line 647
}
#line 647

static int
#line 648
ncx_get_short_longlong(const void *xp, longlong *ip)
#line 648
{
#line 648
    int err=NC_NOERR;
#line 648
#if SIZEOF_IX_SHORT == SIZEOF_LONGLONG && IX_SHORT_MAX == LONGLONG_MAX
#line 648
    get_ix_short(xp, (ix_short *)ip);
#line 648
#else
#line 648
    ix_short xx = 0;
#line 648
    get_ix_short(xp, &xx);
#line 648

#line 648
#if IX_SHORT_MAX > LONGLONG_MAX
#line 648
    if (xx > LONGLONG_MAX || xx < LONGLONG_MIN) {
#line 648
#ifdef ERANGE_FILL
#line 648
        *ip = NC_FILL_INT64;
#line 648
        return NC_ERANGE;
#line 648
#else
#line 648
        err = NC_ERANGE;
#line 648
#endif
#line 648
    }
#line 648
#endif
#line 648

#line 648

#line 648
    *ip = (longlong) xx;
#line 648
#endif
#line 648
    return err;
#line 648
}
#line 648

static int
#line 649
ncx_get_short_ushort(const void *xp, ushort *ip)
#line 649
{
#line 649
    int err=NC_NOERR;
#line 649
    ix_short xx = 0;
#line 649
    get_ix_short(xp, &xx);
#line 649

#line 649
#if IX_SHORT_MAX > USHORT_MAX
#line 649
    if (xx > USHORT_MAX) {
#line 649
#ifdef ERANGE_FILL
#line 649
        *ip = NC_FILL_USHORT;
#line 649
        return NC_ERANGE;
#line 649
#else
#line 649
        err = NC_ERANGE;
#line 649
#endif
#line 649
    }
#line 649
#endif
#line 649

#line 649
    if (xx < 0) {
#line 649
#ifdef ERANGE_FILL
#line 649
        *ip = NC_FILL_USHORT;
#line 649
        return NC_ERANGE;
#line 649
#else
#line 649
        err = NC_ERANGE; /* because ip is unsigned */
#line 649
#endif
#line 649
    }
#line 649
    *ip = (ushort) xx;
#line 649
    return err;
#line 649
}
#line 649

static int
#line 650
ncx_get_short_uchar(const void *xp, uchar *ip)
#line 650
{
#line 650
    int err=NC_NOERR;
#line 650
    ix_short xx = 0;
#line 650
    get_ix_short(xp, &xx);
#line 650

#line 650
#if IX_SHORT_MAX > UCHAR_MAX
#line 650
    if (xx > UCHAR_MAX) {
#line 650
#ifdef ERANGE_FILL
#line 650
        *ip = NC_FILL_UBYTE;
#line 650
        return NC_ERANGE;
#line 650
#else
#line 650
        err = NC_ERANGE;
#line 650
#endif
#line 650
    }
#line 650
#endif
#line 650

#line 650
    if (xx < 0) {
#line 650
#ifdef ERANGE_FILL
#line 650
        *ip = NC_FILL_UBYTE;
#line 650
        return NC_ERANGE;
#line 650
#else
#line 650
        err = NC_ERANGE; /* because ip is unsigned */
#line 650
#endif
#line 650
    }
#line 650
    *ip = (uchar) xx;
#line 650
    return err;
#line 650
}
#line 650

static int
#line 651
ncx_get_short_uint(const void *xp, uint *ip)
#line 651
{
#line 651
    int err=NC_NOERR;
#line 651
    ix_short xx = 0;
#line 651
    get_ix_short(xp, &xx);
#line 651

#line 651
#if IX_SHORT_MAX > UINT_MAX
#line 651
    if (xx > UINT_MAX) {
#line 651
#ifdef ERANGE_FILL
#line 651
        *ip = NC_FILL_UINT;
#line 651
        return NC_ERANGE;
#line 651
#else
#line 651
        err = NC_ERANGE;
#line 651
#endif
#line 651
    }
#line 651
#endif
#line 651

#line 651
    if (xx < 0) {
#line 651
#ifdef ERANGE_FILL
#line 651
        *ip = NC_FILL_UINT;
#line 651
        return NC_ERANGE;
#line 651
#else
#line 651
        err = NC_ERANGE; /* because ip is unsigned */
#line 651
#endif
#line 651
    }
#line 651
    *ip = (uint) xx;
#line 651
    return err;
#line 651
}
#line 651

static int
#line 652
ncx_get_short_ulonglong(const void *xp, ulonglong *ip)
#line 652
{
#line 652
    int err=NC_NOERR;
#line 652
    ix_short xx = 0;
#line 652
    get_ix_short(xp, &xx);
#line 652

#line 652
#if IX_SHORT_MAX > ULONGLONG_MAX
#line 652
    if (xx > ULONGLONG_MAX) {
#line 652
#ifdef ERANGE_FILL
#line 652
        *ip = NC_FILL_UINT64;
#line 652
        return NC_ERANGE;
#line 652
#else
#line 652
        err = NC_ERANGE;
#line 652
#endif
#line 652
    }
#line 652
#endif
#line 652

#line 652
    if (xx < 0) {
#line 652
#ifdef ERANGE_FILL
#line 652
        *ip = NC_FILL_UINT64;
#line 652
        return NC_ERANGE;
#line 652
#else
#line 652
        err = NC_ERANGE; /* because ip is unsigned */
#line 652
#endif
#line 652
    }
#line 652
    *ip = (ulonglong) xx;
#line 652
    return err;
#line 652
}
#line 652

static int
#line 653
ncx_get_short_float(const void *xp, float *ip)
#line 653
{
#line 653
	ix_short xx = 0;
#line 653
	get_ix_short(xp, &xx);
#line 653
	*ip = (float)xx;
#line 653
	return NC_NOERR;
#line 653
}
#line 653

static int
#line 654
ncx_get_short_double(const void *xp, double *ip)
#line 654
{
#line 654
	ix_short xx = 0;
#line 654
	get_ix_short(xp, &xx);
#line 654
	*ip = (double)xx;
#line 654
	return NC_NOERR;
#line 654
}
#line 654


static int
ncx_put_short_schar(void *xp, const schar *ip, void *fillp)
{
	uchar *cp = (uchar *) xp;
	if (*ip & 0x80)
		*cp++ = 0xff;
	else
		*cp++ = 0;
	*cp = (uchar)*ip;
	return NC_NOERR;
}

static int
ncx_put_short_uchar(void *xp, const uchar *ip, void *fillp)
{
	uchar *cp = (uchar *) xp;
	*cp++ = 0;
	*cp = *ip;
	return NC_NOERR;
}

static int
#line 677
ncx_put_short_short(void *xp, const short *ip, void *fillp)
#line 677
{
#line 677
    int err=NC_NOERR;
#line 677
#if SIZEOF_IX_SHORT == SIZEOF_SHORT && IX_SHORT_MAX == SHORT_MAX
#line 677
    put_ix_short(xp, (const ix_short *)ip);
#line 677
#else
#line 677
    ix_short xx = NC_FILL_SHORT;
#line 677

#line 677
#if IX_SHORT_MAX < SHORT_MAX
#line 677
    if (*ip > IX_SHORT_MAX || *ip < X_SHORT_MIN) {
#line 677
        
#line 677
#ifdef ERANGE_FILL
#line 677
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 677
#endif
#line 677
        err = NC_ERANGE;
#line 677
    }
#line 677
#ifdef ERANGE_FILL
#line 677
    else
#line 677
#endif
#line 677
#endif
#line 677
        xx = (ix_short)*ip;
#line 677

#line 677
    put_ix_short(xp, &xx);
#line 677
#endif
#line 677
    return err;
#line 677
}
#line 677

static int
#line 678
ncx_put_short_int(void *xp, const int *ip, void *fillp)
#line 678
{
#line 678
    int err=NC_NOERR;
#line 678
#if SIZEOF_IX_SHORT == SIZEOF_INT && IX_SHORT_MAX == INT_MAX
#line 678
    put_ix_short(xp, (const ix_short *)ip);
#line 678
#else
#line 678
    ix_short xx = NC_FILL_SHORT;
#line 678

#line 678
#if IX_SHORT_MAX < INT_MAX
#line 678
    if (*ip > IX_SHORT_MAX || *ip < X_SHORT_MIN) {
#line 678
        
#line 678
#ifdef ERANGE_FILL
#line 678
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 678
#endif
#line 678
        err = NC_ERANGE;
#line 678
    }
#line 678
#ifdef ERANGE_FILL
#line 678
    else
#line 678
#endif
#line 678
#endif
#line 678
        xx = (ix_short)*ip;
#line 678

#line 678
    put_ix_short(xp, &xx);
#line 678
#endif
#line 678
    return err;
#line 678
}
#line 678

static int
#line 679
ncx_put_short_long(void *xp, const long *ip, void *fillp)
#line 679
{
#line 679
    int err=NC_NOERR;
#line 679
#if SIZEOF_IX_SHORT == SIZEOF_LONG && IX_SHORT_MAX == LONG_MAX
#line 679
    put_ix_short(xp, (const ix_short *)ip);
#line 679
#else
#line 679
    ix_short xx = NC_FILL_SHORT;
#line 679

#line 679
#if IX_SHORT_MAX < LONG_MAX
#line 679
    if (*ip > IX_SHORT_MAX || *ip < X_SHORT_MIN) {
#line 679
        
#line 679
#ifdef ERANGE_FILL
#line 679
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 679
#endif
#line 679
        err = NC_ERANGE;
#line 679
    }
#line 679
#ifdef ERANGE_FILL
#line 679
    else
#line 679
#endif
#line 679
#endif
#line 679
        xx = (ix_short)*ip;
#line 679

#line 679
    put_ix_short(xp, &xx);
#line 679
#endif
#line 679
    return err;
#line 679
}
#line 679

static int
#line 680
ncx_put_short_longlong(void *xp, const longlong *ip, void *fillp)
#line 680
{
#line 680
    int err=NC_NOERR;
#line 680
#if SIZEOF_IX_SHORT == SIZEOF_LONGLONG && IX_SHORT_MAX == LONGLONG_MAX
#line 680
    put_ix_short(xp, (const ix_short *)ip);
#line 680
#else
#line 680
    ix_short xx = NC_FILL_SHORT;
#line 680

#line 680
#if IX_SHORT_MAX < LONGLONG_MAX
#line 680
    if (*ip > IX_SHORT_MAX || *ip < X_SHORT_MIN) {
#line 680
        
#line 680
#ifdef ERANGE_FILL
#line 680
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 680
#endif
#line 680
        err = NC_ERANGE;
#line 680
    }
#line 680
#ifdef ERANGE_FILL
#line 680
    else
#line 680
#endif
#line 680
#endif
#line 680
        xx = (ix_short)*ip;
#line 680

#line 680
    put_ix_short(xp, &xx);
#line 680
#endif
#line 680
    return err;
#line 680
}
#line 680

static int
#line 681
ncx_put_short_ushort(void *xp, const ushort *ip, void *fillp)
#line 681
{
#line 681
    int err=NC_NOERR;
#line 681
    ix_short xx = NC_FILL_SHORT;
#line 681

#line 681
#if IX_SHORT_MAX < USHORT_MAX
#line 681
    if (*ip > IX_SHORT_MAX) {
#line 681
        
#line 681
#ifdef ERANGE_FILL
#line 681
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 681
#endif
#line 681
        err = NC_ERANGE;
#line 681
    }
#line 681
#ifdef ERANGE_FILL
#line 681
    else
#line 681
#endif
#line 681
#endif
#line 681
        xx = (ix_short)*ip;
#line 681

#line 681
    put_ix_short(xp, &xx);
#line 681
    return err;
#line 681
}
#line 681

static int
#line 682
ncx_put_short_uint(void *xp, const uint *ip, void *fillp)
#line 682
{
#line 682
    int err=NC_NOERR;
#line 682
    ix_short xx = NC_FILL_SHORT;
#line 682

#line 682
#if IX_SHORT_MAX < UINT_MAX
#line 682
    if (*ip > IX_SHORT_MAX) {
#line 682
        
#line 682
#ifdef ERANGE_FILL
#line 682
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 682
#endif
#line 682
        err = NC_ERANGE;
#line 682
    }
#line 682
#ifdef ERANGE_FILL
#line 682
    else
#line 682
#endif
#line 682
#endif
#line 682
        xx = (ix_short)*ip;
#line 682

#line 682
    put_ix_short(xp, &xx);
#line 682
    return err;
#line 682
}
#line 682

static int
#line 683
ncx_put_short_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 683
{
#line 683
    int err=NC_NOERR;
#line 683
    ix_short xx = NC_FILL_SHORT;
#line 683

#line 683
#if IX_SHORT_MAX < ULONGLONG_MAX
#line 683
    if (*ip > IX_SHORT_MAX) {
#line 683
        
#line 683
#ifdef ERANGE_FILL
#line 683
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 683
#endif
#line 683
        err = NC_ERANGE;
#line 683
    }
#line 683
#ifdef ERANGE_FILL
#line 683
    else
#line 683
#endif
#line 683
#endif
#line 683
        xx = (ix_short)*ip;
#line 683

#line 683
    put_ix_short(xp, &xx);
#line 683
    return err;
#line 683
}
#line 683

static int
#line 684
ncx_put_short_float(void *xp, const float *ip, void *fillp)
#line 684
{
#line 684
    int err=NC_NOERR;
#line 684
    ix_short xx = NC_FILL_SHORT;
#line 684

#line 684
    if (*ip > (double)X_SHORT_MAX || *ip < (double)X_SHORT_MIN) {
#line 684
        
#line 684
#ifdef ERANGE_FILL
#line 684
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 684
#endif
#line 684
        err = NC_ERANGE;
#line 684
    }
#line 684
#ifdef ERANGE_FILL
#line 684
    else
#line 684
#endif
#line 684
        xx = (ix_short)*ip;
#line 684

#line 684
    put_ix_short(xp, &xx);
#line 684
    return err;
#line 684
}
#line 684

static int
#line 685
ncx_put_short_double(void *xp, const double *ip, void *fillp)
#line 685
{
#line 685
    int err=NC_NOERR;
#line 685
    ix_short xx = NC_FILL_SHORT;
#line 685

#line 685
    if (*ip > X_SHORT_MAX || *ip < X_SHORT_MIN) {
#line 685
        
#line 685
#ifdef ERANGE_FILL
#line 685
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 685
#endif
#line 685
        err = NC_ERANGE;
#line 685
    }
#line 685
#ifdef ERANGE_FILL
#line 685
    else
#line 685
#endif
#line 685
        xx = (ix_short)*ip;
#line 685

#line 685
    put_ix_short(xp, &xx);
#line 685
    return err;
#line 685
}
#line 685


/* external NC_USHORT -------------------------------------------------------*/

#if USHORT_MAX == X_USHORT_MAX
typedef unsigned short ix_ushort;
#define SIZEOF_IX_USHORT SIZEOF_USHORT
#define IX_USHORT_MAX USHORT_MAX
#elif UINT_MAX >= X_USHORT_MAX
typedef unsigned int ix_ushort;
#define SIZEOF_IX_USHORT SIZEOF_UINT
#define IX_USHORT_MAX UINT_MAX
#elif ULONG_MAX >= X_USHORT_MAX
typedef unsigned long ix_ushort;
#define SIZEOF_IX_USHORT SIZEOF_ULONG
#define IX_USHORT_MAX ULONG_MAX
#elif ULLONG_MAX >= X_USHORT_MAX
typedef unsigned long long ix_ushort;
#define SIZEOF_IX_USHORT SIZEOF_ULONGLONG
#define IX_USHORT_MAX ULLONG_MAX
#else
#error "ix_ushort implementation"
#endif

static void
get_ix_ushort(const void *xp, ix_ushort *ip)
{
	const uchar *cp = (const uchar *) xp;
	*ip = (ix_ushort)(*cp++ << 8);
#if SIZEOF_IX_SHORT > X_SIZEOF_SHORT
	if (*ip & 0x8000)
	{
		/* extern is negative */
		*ip |= (~(0xffff)); /* N.B. Assumes "twos complement" */
	}
#endif
	*ip = (ix_ushort)(*ip | *cp);
}

static void
put_ix_ushort(void *xp, const ix_ushort *ip)
{
	uchar *cp = (uchar *) xp;
	*cp++ = (uchar)((*ip) >> 8);
	*cp   = (uchar)((*ip) & 0xff);
}

static int
#line 732
ncx_get_ushort_schar(const void *xp, schar *ip)
#line 732
{
#line 732
    int err=NC_NOERR;
#line 732
    ix_ushort xx = 0;
#line 732
    get_ix_ushort(xp, &xx);
#line 732

#line 732
#if IX_USHORT_MAX > SCHAR_MAX
#line 732
    if (xx > SCHAR_MAX) {
#line 732
#ifdef ERANGE_FILL
#line 732
        *ip = NC_FILL_BYTE;
#line 732
        return NC_ERANGE;
#line 732
#else
#line 732
        err = NC_ERANGE;
#line 732
#endif
#line 732
    }
#line 732
#endif
#line 732

#line 732

#line 732
    *ip = (schar) xx;
#line 732
    return err;
#line 732
}
#line 732

static int
#line 733
ncx_get_ushort_short(const void *xp, short *ip)
#line 733
{
#line 733
    int err=NC_NOERR;
#line 733
    ix_ushort xx = 0;
#line 733
    get_ix_ushort(xp, &xx);
#line 733

#line 733
#if IX_USHORT_MAX > SHORT_MAX
#line 733
    if (xx > SHORT_MAX) {
#line 733
#ifdef ERANGE_FILL
#line 733
        *ip = NC_FILL_SHORT;
#line 733
        return NC_ERANGE;
#line 733
#else
#line 733
        err = NC_ERANGE;
#line 733
#endif
#line 733
    }
#line 733
#endif
#line 733

#line 733

#line 733
    *ip = (short) xx;
#line 733
    return err;
#line 733
}
#line 733

static int
#line 734
ncx_get_ushort_int(const void *xp, int *ip)
#line 734
{
#line 734
    int err=NC_NOERR;
#line 734
    ix_ushort xx = 0;
#line 734
    get_ix_ushort(xp, &xx);
#line 734

#line 734
#if IX_USHORT_MAX > INT_MAX
#line 734
    if (xx > INT_MAX) {
#line 734
#ifdef ERANGE_FILL
#line 734
        *ip = NC_FILL_INT;
#line 734
        return NC_ERANGE;
#line 734
#else
#line 734
        err = NC_ERANGE;
#line 734
#endif
#line 734
    }
#line 734
#endif
#line 734

#line 734

#line 734
    *ip = (int) xx;
#line 734
    return err;
#line 734
}
#line 734

static int
#line 735
ncx_get_ushort_long(const void *xp, long *ip)
#line 735
{
#line 735
    int err=NC_NOERR;
#line 735
    ix_ushort xx = 0;
#line 735
    get_ix_ushort(xp, &xx);
#line 735

#line 735
#if IX_USHORT_MAX > LONG_MAX
#line 735
    if (xx > LONG_MAX) {
#line 735
#ifdef ERANGE_FILL
#line 735
        *ip = NC_FILL_INT;
#line 735
        return NC_ERANGE;
#line 735
#else
#line 735
        err = NC_ERANGE;
#line 735
#endif
#line 735
    }
#line 735
#endif
#line 735

#line 735

#line 735
    *ip = (long) xx;
#line 735
    return err;
#line 735
}
#line 735

static int
#line 736
ncx_get_ushort_longlong(const void *xp, longlong *ip)
#line 736
{
#line 736
    int err=NC_NOERR;
#line 736
    ix_ushort xx = 0;
#line 736
    get_ix_ushort(xp, &xx);
#line 736

#line 736
#if IX_USHORT_MAX > LONGLONG_MAX
#line 736
    if (xx > LONGLONG_MAX) {
#line 736
#ifdef ERANGE_FILL
#line 736
        *ip = NC_FILL_INT64;
#line 736
        return NC_ERANGE;
#line 736
#else
#line 736
        err = NC_ERANGE;
#line 736
#endif
#line 736
    }
#line 736
#endif
#line 736

#line 736

#line 736
    *ip = (longlong) xx;
#line 736
    return err;
#line 736
}
#line 736

static int
#line 737
ncx_get_ushort_ushort(const void *xp, ushort *ip)
#line 737
{
#line 737
    int err=NC_NOERR;
#line 737
#if SIZEOF_IX_USHORT == SIZEOF_USHORT && IX_USHORT_MAX == USHORT_MAX
#line 737
    get_ix_ushort(xp, (ix_ushort *)ip);
#line 737
#else
#line 737
    ix_ushort xx = 0;
#line 737
    get_ix_ushort(xp, &xx);
#line 737

#line 737
#if IX_USHORT_MAX > USHORT_MAX
#line 737
    if (xx > USHORT_MAX) {
#line 737
#ifdef ERANGE_FILL
#line 737
        *ip = NC_FILL_USHORT;
#line 737
        return NC_ERANGE;
#line 737
#else
#line 737
        err = NC_ERANGE;
#line 737
#endif
#line 737
    }
#line 737
#endif
#line 737

#line 737

#line 737
    *ip = (ushort) xx;
#line 737
#endif
#line 737
    return err;
#line 737
}
#line 737

static int
#line 738
ncx_get_ushort_uchar(const void *xp, uchar *ip)
#line 738
{
#line 738
    int err=NC_NOERR;
#line 738
#if SIZEOF_IX_USHORT == SIZEOF_UCHAR && IX_USHORT_MAX == UCHAR_MAX
#line 738
    get_ix_ushort(xp, (ix_ushort *)ip);
#line 738
#else
#line 738
    ix_ushort xx = 0;
#line 738
    get_ix_ushort(xp, &xx);
#line 738

#line 738
#if IX_USHORT_MAX > UCHAR_MAX
#line 738
    if (xx > UCHAR_MAX) {
#line 738
#ifdef ERANGE_FILL
#line 738
        *ip = NC_FILL_UBYTE;
#line 738
        return NC_ERANGE;
#line 738
#else
#line 738
        err = NC_ERANGE;
#line 738
#endif
#line 738
    }
#line 738
#endif
#line 738

#line 738

#line 738
    *ip = (uchar) xx;
#line 738
#endif
#line 738
    return err;
#line 738
}
#line 738

static int
#line 739
ncx_get_ushort_uint(const void *xp, uint *ip)
#line 739
{
#line 739
    int err=NC_NOERR;
#line 739
#if SIZEOF_IX_USHORT == SIZEOF_UINT && IX_USHORT_MAX == UINT_MAX
#line 739
    get_ix_ushort(xp, (ix_ushort *)ip);
#line 739
#else
#line 739
    ix_ushort xx = 0;
#line 739
    get_ix_ushort(xp, &xx);
#line 739

#line 739
#if IX_USHORT_MAX > UINT_MAX
#line 739
    if (xx > UINT_MAX) {
#line 739
#ifdef ERANGE_FILL
#line 739
        *ip = NC_FILL_UINT;
#line 739
        return NC_ERANGE;
#line 739
#else
#line 739
        err = NC_ERANGE;
#line 739
#endif
#line 739
    }
#line 739
#endif
#line 739

#line 739

#line 739
    *ip = (uint) xx;
#line 739
#endif
#line 739
    return err;
#line 739
}
#line 739

static int
#line 740
ncx_get_ushort_ulonglong(const void *xp, ulonglong *ip)
#line 740
{
#line 740
    int err=NC_NOERR;
#line 740
#if SIZEOF_IX_USHORT == SIZEOF_ULONGLONG && IX_USHORT_MAX == ULONGLONG_MAX
#line 740
    get_ix_ushort(xp, (ix_ushort *)ip);
#line 740
#else
#line 740
    ix_ushort xx = 0;
#line 740
    get_ix_ushort(xp, &xx);
#line 740

#line 740
#if IX_USHORT_MAX > ULONGLONG_MAX
#line 740
    if (xx > ULONGLONG_MAX) {
#line 740
#ifdef ERANGE_FILL
#line 740
        *ip = NC_FILL_UINT64;
#line 740
        return NC_ERANGE;
#line 740
#else
#line 740
        err = NC_ERANGE;
#line 740
#endif
#line 740
    }
#line 740
#endif
#line 740

#line 740

#line 740
    *ip = (ulonglong) xx;
#line 740
#endif
#line 740
    return err;
#line 740
}
#line 740

static int
#line 741
ncx_get_ushort_float(const void *xp, float *ip)
#line 741
{
#line 741
	ix_ushort xx = 0;
#line 741
	get_ix_ushort(xp, &xx);
#line 741
	*ip = (float)xx;
#line 741
	return NC_NOERR;
#line 741
}
#line 741

static int
#line 742
ncx_get_ushort_double(const void *xp, double *ip)
#line 742
{
#line 742
	ix_ushort xx = 0;
#line 742
	get_ix_ushort(xp, &xx);
#line 742
	*ip = (double)xx;
#line 742
	return NC_NOERR;
#line 742
}
#line 742


static int
ncx_put_ushort_schar(void *xp, const schar *ip, void *fillp)
{
    int err=NC_NOERR;
    uchar *cp;
    if (*ip < 0) {
#ifdef ERANGE_FILL
        if (fillp != NULL) memcpy(xp, fillp, 2);
#ifndef WORDS_BIGENDIAN
        swapn2b(xp, xp, 1);
#endif
        return NC_ERANGE;
#else
        err = NC_ERANGE;
#endif
    }

    cp = (uchar *) xp;
    if (*ip & 0x80)
        *cp++ = 0xff;
    else
        *cp++ = 0;
    *cp = (uchar)*ip;

    return err;
}

static int
ncx_put_ushort_uchar(void *xp, const uchar *ip, void *fillp)
{
	uchar *cp = (uchar *) xp;
	*cp++ = 0;
	*cp = *ip;
	return NC_NOERR;
}

static int
#line 780
ncx_put_ushort_short(void *xp, const short *ip, void *fillp)
#line 780
{
#line 780
    int err=NC_NOERR;
#line 780
    ix_ushort xx = NC_FILL_USHORT;
#line 780

#line 780
#if IX_USHORT_MAX < SHORT_MAX
#line 780
    if (*ip > IX_USHORT_MAX) {
#line 780
        
#line 780
#ifdef ERANGE_FILL
#line 780
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 780
#endif
#line 780
        err = NC_ERANGE;
#line 780
    }
#line 780
#ifdef ERANGE_FILL
#line 780
    else
#line 780
#endif
#line 780
#endif
#line 780
    if (*ip < 0) {
#line 780
        
#line 780
#ifdef ERANGE_FILL
#line 780
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 780
#endif
#line 780
        err = NC_ERANGE; /* because xp is unsigned */
#line 780
    }
#line 780
#ifdef ERANGE_FILL
#line 780
    else
#line 780
#endif
#line 780
        xx = (ix_ushort)*ip;
#line 780

#line 780
    put_ix_ushort(xp, &xx);
#line 780
    return err;
#line 780
}
#line 780

static int
#line 781
ncx_put_ushort_int(void *xp, const int *ip, void *fillp)
#line 781
{
#line 781
    int err=NC_NOERR;
#line 781
    ix_ushort xx = NC_FILL_USHORT;
#line 781

#line 781
#if IX_USHORT_MAX < INT_MAX
#line 781
    if (*ip > IX_USHORT_MAX) {
#line 781
        
#line 781
#ifdef ERANGE_FILL
#line 781
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 781
#endif
#line 781
        err = NC_ERANGE;
#line 781
    }
#line 781
#ifdef ERANGE_FILL
#line 781
    else
#line 781
#endif
#line 781
#endif
#line 781
    if (*ip < 0) {
#line 781
        
#line 781
#ifdef ERANGE_FILL
#line 781
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 781
#endif
#line 781
        err = NC_ERANGE; /* because xp is unsigned */
#line 781
    }
#line 781
#ifdef ERANGE_FILL
#line 781
    else
#line 781
#endif
#line 781
        xx = (ix_ushort)*ip;
#line 781

#line 781
    put_ix_ushort(xp, &xx);
#line 781
    return err;
#line 781
}
#line 781

static int
#line 782
ncx_put_ushort_long(void *xp, const long *ip, void *fillp)
#line 782
{
#line 782
    int err=NC_NOERR;
#line 782
    ix_ushort xx = NC_FILL_USHORT;
#line 782

#line 782
#if IX_USHORT_MAX < LONG_MAX
#line 782
    if (*ip > IX_USHORT_MAX) {
#line 782
        
#line 782
#ifdef ERANGE_FILL
#line 782
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 782
#endif
#line 782
        err = NC_ERANGE;
#line 782
    }
#line 782
#ifdef ERANGE_FILL
#line 782
    else
#line 782
#endif
#line 782
#endif
#line 782
    if (*ip < 0) {
#line 782
        
#line 782
#ifdef ERANGE_FILL
#line 782
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 782
#endif
#line 782
        err = NC_ERANGE; /* because xp is unsigned */
#line 782
    }
#line 782
#ifdef ERANGE_FILL
#line 782
    else
#line 782
#endif
#line 782
        xx = (ix_ushort)*ip;
#line 782

#line 782
    put_ix_ushort(xp, &xx);
#line 782
    return err;
#line 782
}
#line 782

static int
#line 783
ncx_put_ushort_longlong(void *xp, const longlong *ip, void *fillp)
#line 783
{
#line 783
    int err=NC_NOERR;
#line 783
    ix_ushort xx = NC_FILL_USHORT;
#line 783

#line 783
#if IX_USHORT_MAX < LONGLONG_MAX
#line 783
    if (*ip > IX_USHORT_MAX) {
#line 783
        
#line 783
#ifdef ERANGE_FILL
#line 783
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 783
#endif
#line 783
        err = NC_ERANGE;
#line 783
    }
#line 783
#ifdef ERANGE_FILL
#line 783
    else
#line 783
#endif
#line 783
#endif
#line 783
    if (*ip < 0) {
#line 783
        
#line 783
#ifdef ERANGE_FILL
#line 783
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 783
#endif
#line 783
        err = NC_ERANGE; /* because xp is unsigned */
#line 783
    }
#line 783
#ifdef ERANGE_FILL
#line 783
    else
#line 783
#endif
#line 783
        xx = (ix_ushort)*ip;
#line 783

#line 783
    put_ix_ushort(xp, &xx);
#line 783
    return err;
#line 783
}
#line 783

static int
#line 784
ncx_put_ushort_ushort(void *xp, const ushort *ip, void *fillp)
#line 784
{
#line 784
    int err=NC_NOERR;
#line 784
#if SIZEOF_IX_USHORT == SIZEOF_USHORT && IX_USHORT_MAX == USHORT_MAX
#line 784
    put_ix_ushort(xp, (const ix_ushort *)ip);
#line 784
#else
#line 784
    ix_ushort xx = NC_FILL_USHORT;
#line 784

#line 784
#if IX_USHORT_MAX < USHORT_MAX
#line 784
    if (*ip > IX_USHORT_MAX) {
#line 784
        
#line 784
#ifdef ERANGE_FILL
#line 784
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 784
#endif
#line 784
        err = NC_ERANGE;
#line 784
    }
#line 784
#ifdef ERANGE_FILL
#line 784
    else
#line 784
#endif
#line 784
#endif
#line 784
        xx = (ix_ushort)*ip;
#line 784

#line 784
    put_ix_ushort(xp, &xx);
#line 784
#endif
#line 784
    return err;
#line 784
}
#line 784

static int
#line 785
ncx_put_ushort_uint(void *xp, const uint *ip, void *fillp)
#line 785
{
#line 785
    int err=NC_NOERR;
#line 785
#if SIZEOF_IX_USHORT == SIZEOF_UINT && IX_USHORT_MAX == UINT_MAX
#line 785
    put_ix_ushort(xp, (const ix_ushort *)ip);
#line 785
#else
#line 785
    ix_ushort xx = NC_FILL_USHORT;
#line 785

#line 785
#if IX_USHORT_MAX < UINT_MAX
#line 785
    if (*ip > IX_USHORT_MAX) {
#line 785
        
#line 785
#ifdef ERANGE_FILL
#line 785
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 785
#endif
#line 785
        err = NC_ERANGE;
#line 785
    }
#line 785
#ifdef ERANGE_FILL
#line 785
    else
#line 785
#endif
#line 785
#endif
#line 785
        xx = (ix_ushort)*ip;
#line 785

#line 785
    put_ix_ushort(xp, &xx);
#line 785
#endif
#line 785
    return err;
#line 785
}
#line 785

static int
#line 786
ncx_put_ushort_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 786
{
#line 786
    int err=NC_NOERR;
#line 786
#if SIZEOF_IX_USHORT == SIZEOF_ULONGLONG && IX_USHORT_MAX == ULONGLONG_MAX
#line 786
    put_ix_ushort(xp, (const ix_ushort *)ip);
#line 786
#else
#line 786
    ix_ushort xx = NC_FILL_USHORT;
#line 786

#line 786
#if IX_USHORT_MAX < ULONGLONG_MAX
#line 786
    if (*ip > IX_USHORT_MAX) {
#line 786
        
#line 786
#ifdef ERANGE_FILL
#line 786
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 786
#endif
#line 786
        err = NC_ERANGE;
#line 786
    }
#line 786
#ifdef ERANGE_FILL
#line 786
    else
#line 786
#endif
#line 786
#endif
#line 786
        xx = (ix_ushort)*ip;
#line 786

#line 786
    put_ix_ushort(xp, &xx);
#line 786
#endif
#line 786
    return err;
#line 786
}
#line 786

static int
#line 787
ncx_put_ushort_float(void *xp, const float *ip, void *fillp)
#line 787
{
#line 787
    int err=NC_NOERR;
#line 787
    ix_ushort xx = NC_FILL_USHORT;
#line 787

#line 787
    if (*ip > (double)X_USHORT_MAX || *ip < 0) {
#line 787
        
#line 787
#ifdef ERANGE_FILL
#line 787
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 787
#endif
#line 787
        err = NC_ERANGE;
#line 787
    }
#line 787
#ifdef ERANGE_FILL
#line 787
    else
#line 787
#endif
#line 787
        xx = (ix_ushort)*ip;
#line 787

#line 787
    put_ix_ushort(xp, &xx);
#line 787
    return err;
#line 787
}
#line 787

static int
#line 788
ncx_put_ushort_double(void *xp, const double *ip, void *fillp)
#line 788
{
#line 788
    int err=NC_NOERR;
#line 788
    ix_ushort xx = NC_FILL_USHORT;
#line 788

#line 788
    if (*ip > X_USHORT_MAX || *ip < 0) {
#line 788
        
#line 788
#ifdef ERANGE_FILL
#line 788
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 788
#endif
#line 788
        err = NC_ERANGE;
#line 788
    }
#line 788
#ifdef ERANGE_FILL
#line 788
    else
#line 788
#endif
#line 788
        xx = (ix_ushort)*ip;
#line 788

#line 788
    put_ix_ushort(xp, &xx);
#line 788
    return err;
#line 788
}
#line 788


/* external NC_INT ----------------------------------------------------------*/

#if SHORT_MAX == X_INT_MAX
typedef short ix_int;
#define SIZEOF_IX_INT SIZEOF_SHORT
#define IX_INT_MAX SHORT_MAX
#elif INT_MAX  >= X_INT_MAX
typedef int ix_int;
#define SIZEOF_IX_INT SIZEOF_INT
#define IX_INT_MAX INT_MAX
#elif LONG_MAX  >= X_INT_MAX
typedef long ix_int;
#define SIZEOF_IX_INT SIZEOF_LONG
#define IX_INT_MAX LONG_MAX
#else
#error "ix_int implementation"
#endif


static void
get_ix_int(const void *xp, ix_int *ip)
{
	const uchar *cp = (const uchar *) xp;

#if INT_MAX  >= X_INT_MAX
	*ip = (ix_int)((unsigned)(*cp++) << 24);
#else
	*ip = *cp++ << 24;
#endif
#if SIZEOF_IX_INT > X_SIZEOF_INT
	if (*ip & 0x80000000)
	{
		/* extern is negative */
		*ip |= (~(0xffffffff)); /* N.B. Assumes "twos complement" */
	}
#endif
	*ip |= (*cp++ << 16);
	*ip |= (*cp++ << 8);
	*ip |= *cp;
}

static void
put_ix_int(void *xp, const ix_int *ip)
{
	uchar *cp = (uchar *) xp;

	*cp++ = (uchar)( (*ip) >> 24);
	*cp++ = (uchar)(((*ip) & 0x00ff0000) >> 16);
	*cp++ = (uchar)(((*ip) & 0x0000ff00) >>  8);
	*cp   = (uchar)( (*ip) & 0x000000ff);
}

#if X_SIZEOF_INT != SIZEOF_INT
static int
#line 843
ncx_get_int_int(const void *xp, int *ip)
#line 843
{
#line 843
    int err=NC_NOERR;
#line 843
#if SIZEOF_IX_INT == SIZEOF_INT && IX_INT_MAX == INT_MAX
#line 843
    get_ix_int(xp, (ix_int *)ip);
#line 843
#else
#line 843
    ix_int xx = 0;
#line 843
    get_ix_int(xp, &xx);
#line 843

#line 843
#if IX_INT_MAX > INT_MAX
#line 843
    if (xx > INT_MAX || xx < INT_MIN) {
#line 843
#ifdef ERANGE_FILL
#line 843
        *ip = NC_FILL_INT;
#line 843
        return NC_ERANGE;
#line 843
#else
#line 843
        err = NC_ERANGE;
#line 843
#endif
#line 843
    }
#line 843
#endif
#line 843

#line 843

#line 843
    *ip = (int) xx;
#line 843
#endif
#line 843
    return err;
#line 843
}
#line 843

#endif
static int
#line 845
ncx_get_int_schar(const void *xp, schar *ip)
#line 845
{
#line 845
    int err=NC_NOERR;
#line 845
    ix_int xx = 0;
#line 845
    get_ix_int(xp, &xx);
#line 845

#line 845
#if IX_INT_MAX > SCHAR_MAX
#line 845
    if (xx > SCHAR_MAX || xx < SCHAR_MIN) {
#line 845
#ifdef ERANGE_FILL
#line 845
        *ip = NC_FILL_BYTE;
#line 845
        return NC_ERANGE;
#line 845
#else
#line 845
        err = NC_ERANGE;
#line 845
#endif
#line 845
    }
#line 845
#endif
#line 845

#line 845

#line 845
    *ip = (schar) xx;
#line 845
    return err;
#line 845
}
#line 845

static int
#line 846
ncx_get_int_short(const void *xp, short *ip)
#line 846
{
#line 846
    int err=NC_NOERR;
#line 846
#if SIZEOF_IX_INT == SIZEOF_SHORT && IX_INT_MAX == SHORT_MAX
#line 846
    get_ix_int(xp, (ix_int *)ip);
#line 846
#else
#line 846
    ix_int xx = 0;
#line 846
    get_ix_int(xp, &xx);
#line 846

#line 846
#if IX_INT_MAX > SHORT_MAX
#line 846
    if (xx > SHORT_MAX || xx < SHORT_MIN) {
#line 846
#ifdef ERANGE_FILL
#line 846
        *ip = NC_FILL_SHORT;
#line 846
        return NC_ERANGE;
#line 846
#else
#line 846
        err = NC_ERANGE;
#line 846
#endif
#line 846
    }
#line 846
#endif
#line 846

#line 846

#line 846
    *ip = (short) xx;
#line 846
#endif
#line 846
    return err;
#line 846
}
#line 846

static int
#line 847
ncx_get_int_long(const void *xp, long *ip)
#line 847
{
#line 847
    int err=NC_NOERR;
#line 847
#if SIZEOF_IX_INT == SIZEOF_LONG && IX_INT_MAX == LONG_MAX
#line 847
    get_ix_int(xp, (ix_int *)ip);
#line 847
#else
#line 847
    ix_int xx = 0;
#line 847
    get_ix_int(xp, &xx);
#line 847

#line 847
#if IX_INT_MAX > LONG_MAX
#line 847
    if (xx > LONG_MAX || xx < LONG_MIN) {
#line 847
#ifdef ERANGE_FILL
#line 847
        *ip = NC_FILL_INT;
#line 847
        return NC_ERANGE;
#line 847
#else
#line 847
        err = NC_ERANGE;
#line 847
#endif
#line 847
    }
#line 847
#endif
#line 847

#line 847

#line 847
    *ip = (long) xx;
#line 847
#endif
#line 847
    return err;
#line 847
}
#line 847

static int
#line 848
ncx_get_int_longlong(const void *xp, longlong *ip)
#line 848
{
#line 848
    int err=NC_NOERR;
#line 848
#if SIZEOF_IX_INT == SIZEOF_LONGLONG && IX_INT_MAX == LONGLONG_MAX
#line 848
    get_ix_int(xp, (ix_int *)ip);
#line 848
#else
#line 848
    ix_int xx = 0;
#line 848
    get_ix_int(xp, &xx);
#line 848

#line 848
#if IX_INT_MAX > LONGLONG_MAX
#line 848
    if (xx > LONGLONG_MAX || xx < LONGLONG_MIN) {
#line 848
#ifdef ERANGE_FILL
#line 848
        *ip = NC_FILL_INT64;
#line 848
        return NC_ERANGE;
#line 848
#else
#line 848
        err = NC_ERANGE;
#line 848
#endif
#line 848
    }
#line 848
#endif
#line 848

#line 848

#line 848
    *ip = (longlong) xx;
#line 848
#endif
#line 848
    return err;
#line 848
}
#line 848

static int
#line 849
ncx_get_int_ushort(const void *xp, ushort *ip)
#line 849
{
#line 849
    int err=NC_NOERR;
#line 849
    ix_int xx = 0;
#line 849
    get_ix_int(xp, &xx);
#line 849

#line 849
#if IX_INT_MAX > USHORT_MAX
#line 849
    if (xx > USHORT_MAX) {
#line 849
#ifdef ERANGE_FILL
#line 849
        *ip = NC_FILL_USHORT;
#line 849
        return NC_ERANGE;
#line 849
#else
#line 849
        err = NC_ERANGE;
#line 849
#endif
#line 849
    }
#line 849
#endif
#line 849

#line 849
    if (xx < 0) {
#line 849
#ifdef ERANGE_FILL
#line 849
        *ip = NC_FILL_USHORT;
#line 849
        return NC_ERANGE;
#line 849
#else
#line 849
        err = NC_ERANGE; /* because ip is unsigned */
#line 849
#endif
#line 849
    }
#line 849
    *ip = (ushort) xx;
#line 849
    return err;
#line 849
}
#line 849

static int
#line 850
ncx_get_int_uchar(const void *xp, uchar *ip)
#line 850
{
#line 850
    int err=NC_NOERR;
#line 850
    ix_int xx = 0;
#line 850
    get_ix_int(xp, &xx);
#line 850

#line 850
#if IX_INT_MAX > UCHAR_MAX
#line 850
    if (xx > UCHAR_MAX) {
#line 850
#ifdef ERANGE_FILL
#line 850
        *ip = NC_FILL_UBYTE;
#line 850
        return NC_ERANGE;
#line 850
#else
#line 850
        err = NC_ERANGE;
#line 850
#endif
#line 850
    }
#line 850
#endif
#line 850

#line 850
    if (xx < 0) {
#line 850
#ifdef ERANGE_FILL
#line 850
        *ip = NC_FILL_UBYTE;
#line 850
        return NC_ERANGE;
#line 850
#else
#line 850
        err = NC_ERANGE; /* because ip is unsigned */
#line 850
#endif
#line 850
    }
#line 850
    *ip = (uchar) xx;
#line 850
    return err;
#line 850
}
#line 850

static int
#line 851
ncx_get_int_uint(const void *xp, uint *ip)
#line 851
{
#line 851
    int err=NC_NOERR;
#line 851
    ix_int xx = 0;
#line 851
    get_ix_int(xp, &xx);
#line 851

#line 851
#if IX_INT_MAX > UINT_MAX
#line 851
    if (xx > UINT_MAX) {
#line 851
#ifdef ERANGE_FILL
#line 851
        *ip = NC_FILL_UINT;
#line 851
        return NC_ERANGE;
#line 851
#else
#line 851
        err = NC_ERANGE;
#line 851
#endif
#line 851
    }
#line 851
#endif
#line 851

#line 851
    if (xx < 0) {
#line 851
#ifdef ERANGE_FILL
#line 851
        *ip = NC_FILL_UINT;
#line 851
        return NC_ERANGE;
#line 851
#else
#line 851
        err = NC_ERANGE; /* because ip is unsigned */
#line 851
#endif
#line 851
    }
#line 851
    *ip = (uint) xx;
#line 851
    return err;
#line 851
}
#line 851

static int
#line 852
ncx_get_int_ulonglong(const void *xp, ulonglong *ip)
#line 852
{
#line 852
    int err=NC_NOERR;
#line 852
    ix_int xx = 0;
#line 852
    get_ix_int(xp, &xx);
#line 852

#line 852
#if IX_INT_MAX > ULONGLONG_MAX
#line 852
    if (xx > ULONGLONG_MAX) {
#line 852
#ifdef ERANGE_FILL
#line 852
        *ip = NC_FILL_UINT64;
#line 852
        return NC_ERANGE;
#line 852
#else
#line 852
        err = NC_ERANGE;
#line 852
#endif
#line 852
    }
#line 852
#endif
#line 852

#line 852
    if (xx < 0) {
#line 852
#ifdef ERANGE_FILL
#line 852
        *ip = NC_FILL_UINT64;
#line 852
        return NC_ERANGE;
#line 852
#else
#line 852
        err = NC_ERANGE; /* because ip is unsigned */
#line 852
#endif
#line 852
    }
#line 852
    *ip = (ulonglong) xx;
#line 852
    return err;
#line 852
}
#line 852

static int
#line 853
ncx_get_int_float(const void *xp, float *ip)
#line 853
{
#line 853
	ix_int xx = 0;
#line 853
	get_ix_int(xp, &xx);
#line 853
	*ip = (float)xx;
#line 853
	return NC_NOERR;
#line 853
}
#line 853

static int
#line 854
ncx_get_int_double(const void *xp, double *ip)
#line 854
{
#line 854
	ix_int xx = 0;
#line 854
	get_ix_int(xp, &xx);
#line 854
	*ip = (double)xx;
#line 854
	return NC_NOERR;
#line 854
}
#line 854


static int
ncx_put_int_schar(void *xp, const schar *ip, void *fillp)
{
	uchar *cp = (uchar *) xp;
	if (*ip & 0x80)
	{
		*cp++ = 0xff;
		*cp++ = 0xff;
		*cp++ = 0xff;
	}
	else
	{
		*cp++ = 0x00;
		*cp++ = 0x00;
		*cp++ = 0x00;
	}
	*cp = (uchar)*ip;
	return NC_NOERR;
}

static int
ncx_put_int_uchar(void *xp, const uchar *ip, void *fillp)
{
	uchar *cp = (uchar *) xp;
	*cp++ = 0x00;
	*cp++ = 0x00;
	*cp++ = 0x00;
	*cp   = *ip;
	return NC_NOERR;
}

#if X_SIZEOF_INT != SIZEOF_INT
static int
#line 888
ncx_put_int_int(void *xp, const int *ip, void *fillp)
#line 888
{
#line 888
    int err=NC_NOERR;
#line 888
#if SIZEOF_IX_INT == SIZEOF_INT && IX_INT_MAX == INT_MAX
#line 888
    put_ix_int(xp, (const ix_int *)ip);
#line 888
#else
#line 888
    ix_int xx = NC_FILL_INT;
#line 888

#line 888
#if IX_INT_MAX < INT_MAX
#line 888
    if (*ip > IX_INT_MAX || *ip < X_INT_MIN) {
#line 888
        
#line 888
#ifdef ERANGE_FILL
#line 888
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 888
#endif
#line 888
        err = NC_ERANGE;
#line 888
    }
#line 888
#ifdef ERANGE_FILL
#line 888
    else
#line 888
#endif
#line 888
#endif
#line 888
        xx = (ix_int)*ip;
#line 888

#line 888
    put_ix_int(xp, &xx);
#line 888
#endif
#line 888
    return err;
#line 888
}
#line 888

#endif
static int
#line 890
ncx_put_int_short(void *xp, const short *ip, void *fillp)
#line 890
{
#line 890
    int err=NC_NOERR;
#line 890
#if SIZEOF_IX_INT == SIZEOF_SHORT && IX_INT_MAX == SHORT_MAX
#line 890
    put_ix_int(xp, (const ix_int *)ip);
#line 890
#else
#line 890
    ix_int xx = NC_FILL_INT;
#line 890

#line 890
#if IX_INT_MAX < SHORT_MAX
#line 890
    if (*ip > IX_INT_MAX || *ip < X_INT_MIN) {
#line 890
        
#line 890
#ifdef ERANGE_FILL
#line 890
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 890
#endif
#line 890
        err = NC_ERANGE;
#line 890
    }
#line 890
#ifdef ERANGE_FILL
#line 890
    else
#line 890
#endif
#line 890
#endif
#line 890
        xx = (ix_int)*ip;
#line 890

#line 890
    put_ix_int(xp, &xx);
#line 890
#endif
#line 890
    return err;
#line 890
}
#line 890

static int
#line 891
ncx_put_int_long(void *xp, const long *ip, void *fillp)
#line 891
{
#line 891
    int err=NC_NOERR;
#line 891
#if SIZEOF_IX_INT == SIZEOF_LONG && IX_INT_MAX == LONG_MAX
#line 891
    put_ix_int(xp, (const ix_int *)ip);
#line 891
#else
#line 891
    ix_int xx = NC_FILL_INT;
#line 891

#line 891
#if IX_INT_MAX < LONG_MAX
#line 891
    if (*ip > IX_INT_MAX || *ip < X_INT_MIN) {
#line 891
        
#line 891
#ifdef ERANGE_FILL
#line 891
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 891
#endif
#line 891
        err = NC_ERANGE;
#line 891
    }
#line 891
#ifdef ERANGE_FILL
#line 891
    else
#line 891
#endif
#line 891
#endif
#line 891
        xx = (ix_int)*ip;
#line 891

#line 891
    put_ix_int(xp, &xx);
#line 891
#endif
#line 891
    return err;
#line 891
}
#line 891

static int
#line 892
ncx_put_int_longlong(void *xp, const longlong *ip, void *fillp)
#line 892
{
#line 892
    int err=NC_NOERR;
#line 892
#if SIZEOF_IX_INT == SIZEOF_LONGLONG && IX_INT_MAX == LONGLONG_MAX
#line 892
    put_ix_int(xp, (const ix_int *)ip);
#line 892
#else
#line 892
    ix_int xx = NC_FILL_INT;
#line 892

#line 892
#if IX_INT_MAX < LONGLONG_MAX
#line 892
    if (*ip > IX_INT_MAX || *ip < X_INT_MIN) {
#line 892
        
#line 892
#ifdef ERANGE_FILL
#line 892
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 892
#endif
#line 892
        err = NC_ERANGE;
#line 892
    }
#line 892
#ifdef ERANGE_FILL
#line 892
    else
#line 892
#endif
#line 892
#endif
#line 892
        xx = (ix_int)*ip;
#line 892

#line 892
    put_ix_int(xp, &xx);
#line 892
#endif
#line 892
    return err;
#line 892
}
#line 892

static int
#line 893
ncx_put_int_ushort(void *xp, const ushort *ip, void *fillp)
#line 893
{
#line 893
    int err=NC_NOERR;
#line 893
    ix_int xx = NC_FILL_INT;
#line 893

#line 893
#if IX_INT_MAX < USHORT_MAX
#line 893
    if (*ip > IX_INT_MAX) {
#line 893
        
#line 893
#ifdef ERANGE_FILL
#line 893
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 893
#endif
#line 893
        err = NC_ERANGE;
#line 893
    }
#line 893
#ifdef ERANGE_FILL
#line 893
    else
#line 893
#endif
#line 893
#endif
#line 893
        xx = (ix_int)*ip;
#line 893

#line 893
    put_ix_int(xp, &xx);
#line 893
    return err;
#line 893
}
#line 893

static int
#line 894
ncx_put_int_uint(void *xp, const uint *ip, void *fillp)
#line 894
{
#line 894
    int err=NC_NOERR;
#line 894
    ix_int xx = NC_FILL_INT;
#line 894

#line 894
#if IX_INT_MAX < UINT_MAX
#line 894
    if (*ip > IX_INT_MAX) {
#line 894
        
#line 894
#ifdef ERANGE_FILL
#line 894
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 894
#endif
#line 894
        err = NC_ERANGE;
#line 894
    }
#line 894
#ifdef ERANGE_FILL
#line 894
    else
#line 894
#endif
#line 894
#endif
#line 894
        xx = (ix_int)*ip;
#line 894

#line 894
    put_ix_int(xp, &xx);
#line 894
    return err;
#line 894
}
#line 894

static int
#line 895
ncx_put_int_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 895
{
#line 895
    int err=NC_NOERR;
#line 895
    ix_int xx = NC_FILL_INT;
#line 895

#line 895
#if IX_INT_MAX < ULONGLONG_MAX
#line 895
    if (*ip > IX_INT_MAX) {
#line 895
        
#line 895
#ifdef ERANGE_FILL
#line 895
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 895
#endif
#line 895
        err = NC_ERANGE;
#line 895
    }
#line 895
#ifdef ERANGE_FILL
#line 895
    else
#line 895
#endif
#line 895
#endif
#line 895
        xx = (ix_int)*ip;
#line 895

#line 895
    put_ix_int(xp, &xx);
#line 895
    return err;
#line 895
}
#line 895

static int
#line 896
ncx_put_int_float(void *xp, const float *ip, void *fillp)
#line 896
{
#line 896
    int err=NC_NOERR;
#line 896
    ix_int xx = NC_FILL_INT;
#line 896

#line 896
    if (*ip > (double)X_INT_MAX || *ip < (double)X_INT_MIN) {
#line 896
        
#line 896
#ifdef ERANGE_FILL
#line 896
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 896
#endif
#line 896
        err = NC_ERANGE;
#line 896
    }
#line 896
#ifdef ERANGE_FILL
#line 896
    else
#line 896
#endif
#line 896
        xx = (ix_int)*ip;
#line 896

#line 896
    put_ix_int(xp, &xx);
#line 896
    return err;
#line 896
}
#line 896

static int
#line 897
ncx_put_int_double(void *xp, const double *ip, void *fillp)
#line 897
{
#line 897
    int err=NC_NOERR;
#line 897
    ix_int xx = NC_FILL_INT;
#line 897

#line 897
    if (*ip > X_INT_MAX || *ip < X_INT_MIN) {
#line 897
        
#line 897
#ifdef ERANGE_FILL
#line 897
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 897
#endif
#line 897
        err = NC_ERANGE;
#line 897
    }
#line 897
#ifdef ERANGE_FILL
#line 897
    else
#line 897
#endif
#line 897
        xx = (ix_int)*ip;
#line 897

#line 897
    put_ix_int(xp, &xx);
#line 897
    return err;
#line 897
}
#line 897



/* external NC_UINT ---------------------------------------------------------*/

#if USHORT_MAX == X_UINT_MAX
typedef ushort ix_uint;
#define SIZEOF_IX_UINT SIZEOF_USHORT
#define IX_UINT_MAX USHORT_MAX
#elif UINT_MAX  >= X_UINT_MAX
typedef uint ix_uint;
#define SIZEOF_IX_UINT SIZEOF_UINT
#define IX_UINT_MAX UINT_MAX
#elif ULONG_MAX  >= X_UINT_MAX
typedef ulong ix_uint;
#define SIZEOF_IX_UINT SIZEOF_ULONG
#define IX_UINT_MAX ULONG_MAX
#else
#error "ix_uint implementation"
#endif


static void
get_ix_uint(const void *xp, ix_uint *ip)
{
	const uchar *cp = (const uchar *) xp;

	*ip =       (ix_uint)(*cp++) << 24;
	*ip = *ip | (ix_uint)(*cp++) << 16;
	*ip = *ip | (ix_uint)(*cp++) << 8;
	*ip = *ip | (ix_uint)(*cp);
}

static void
put_ix_uint(void *xp, const ix_uint *ip)
{
	uchar *cp = (uchar *) xp;

	*cp++ = (uchar)((*ip) >> 24);
	*cp++ = (uchar)(((*ip) & 0x00ff0000) >> 16);
	*cp++ = (uchar)(((*ip) & 0x0000ff00) >>  8);
	*cp   = (uchar)( (*ip) & 0x000000ff);
}

#if X_SIZEOF_UINT != SIZEOF_UINT
static int
#line 942
ncx_get_uint_uint(const void *xp, uint *ip)
#line 942
{
#line 942
    int err=NC_NOERR;
#line 942
#if SIZEOF_IX_UINT == SIZEOF_UINT && IX_UINT_MAX == UINT_MAX
#line 942
    get_ix_uint(xp, (ix_uint *)ip);
#line 942
#else
#line 942
    ix_uint xx = 0;
#line 942
    get_ix_uint(xp, &xx);
#line 942

#line 942
#if IX_UINT_MAX > UINT_MAX
#line 942
    if (xx > UINT_MAX) {
#line 942
#ifdef ERANGE_FILL
#line 942
        *ip = NC_FILL_UINT;
#line 942
        return NC_ERANGE;
#line 942
#else
#line 942
        err = NC_ERANGE;
#line 942
#endif
#line 942
    }
#line 942
#endif
#line 942

#line 942

#line 942
    *ip = (uint) xx;
#line 942
#endif
#line 942
    return err;
#line 942
}
#line 942

#endif

static int
#line 945
ncx_get_uint_schar(const void *xp, schar *ip)
#line 945
{
#line 945
    int err=NC_NOERR;
#line 945
    ix_uint xx = 0;
#line 945
    get_ix_uint(xp, &xx);
#line 945

#line 945
#if IX_UINT_MAX > SCHAR_MAX
#line 945
    if (xx > SCHAR_MAX) {
#line 945
#ifdef ERANGE_FILL
#line 945
        *ip = NC_FILL_BYTE;
#line 945
        return NC_ERANGE;
#line 945
#else
#line 945
        err = NC_ERANGE;
#line 945
#endif
#line 945
    }
#line 945
#endif
#line 945

#line 945

#line 945
    *ip = (schar) xx;
#line 945
    return err;
#line 945
}
#line 945

static int
#line 946
ncx_get_uint_short(const void *xp, short *ip)
#line 946
{
#line 946
    int err=NC_NOERR;
#line 946
    ix_uint xx = 0;
#line 946
    get_ix_uint(xp, &xx);
#line 946

#line 946
#if IX_UINT_MAX > SHORT_MAX
#line 946
    if (xx > SHORT_MAX) {
#line 946
#ifdef ERANGE_FILL
#line 946
        *ip = NC_FILL_SHORT;
#line 946
        return NC_ERANGE;
#line 946
#else
#line 946
        err = NC_ERANGE;
#line 946
#endif
#line 946
    }
#line 946
#endif
#line 946

#line 946

#line 946
    *ip = (short) xx;
#line 946
    return err;
#line 946
}
#line 946

static int
#line 947
ncx_get_uint_int(const void *xp, int *ip)
#line 947
{
#line 947
    int err=NC_NOERR;
#line 947
    ix_uint xx = 0;
#line 947
    get_ix_uint(xp, &xx);
#line 947

#line 947
#if IX_UINT_MAX > INT_MAX
#line 947
    if (xx > INT_MAX) {
#line 947
#ifdef ERANGE_FILL
#line 947
        *ip = NC_FILL_INT;
#line 947
        return NC_ERANGE;
#line 947
#else
#line 947
        err = NC_ERANGE;
#line 947
#endif
#line 947
    }
#line 947
#endif
#line 947

#line 947

#line 947
    *ip = (int) xx;
#line 947
    return err;
#line 947
}
#line 947

static int
#line 948
ncx_get_uint_long(const void *xp, long *ip)
#line 948
{
#line 948
    int err=NC_NOERR;
#line 948
    ix_uint xx = 0;
#line 948
    get_ix_uint(xp, &xx);
#line 948

#line 948
#if IX_UINT_MAX > LONG_MAX
#line 948
    if (xx > LONG_MAX) {
#line 948
#ifdef ERANGE_FILL
#line 948
        *ip = NC_FILL_INT;
#line 948
        return NC_ERANGE;
#line 948
#else
#line 948
        err = NC_ERANGE;
#line 948
#endif
#line 948
    }
#line 948
#endif
#line 948

#line 948

#line 948
    *ip = (long) xx;
#line 948
    return err;
#line 948
}
#line 948

static int
#line 949
ncx_get_uint_longlong(const void *xp, longlong *ip)
#line 949
{
#line 949
    int err=NC_NOERR;
#line 949
    ix_uint xx = 0;
#line 949
    get_ix_uint(xp, &xx);
#line 949

#line 949
#if IX_UINT_MAX > LONGLONG_MAX
#line 949
    if (xx > LONGLONG_MAX) {
#line 949
#ifdef ERANGE_FILL
#line 949
        *ip = NC_FILL_INT64;
#line 949
        return NC_ERANGE;
#line 949
#else
#line 949
        err = NC_ERANGE;
#line 949
#endif
#line 949
    }
#line 949
#endif
#line 949

#line 949

#line 949
    *ip = (longlong) xx;
#line 949
    return err;
#line 949
}
#line 949

static int
#line 950
ncx_get_uint_ushort(const void *xp, ushort *ip)
#line 950
{
#line 950
    int err=NC_NOERR;
#line 950
#if SIZEOF_IX_UINT == SIZEOF_USHORT && IX_UINT_MAX == USHORT_MAX
#line 950
    get_ix_uint(xp, (ix_uint *)ip);
#line 950
#else
#line 950
    ix_uint xx = 0;
#line 950
    get_ix_uint(xp, &xx);
#line 950

#line 950
#if IX_UINT_MAX > USHORT_MAX
#line 950
    if (xx > USHORT_MAX) {
#line 950
#ifdef ERANGE_FILL
#line 950
        *ip = NC_FILL_USHORT;
#line 950
        return NC_ERANGE;
#line 950
#else
#line 950
        err = NC_ERANGE;
#line 950
#endif
#line 950
    }
#line 950
#endif
#line 950

#line 950

#line 950
    *ip = (ushort) xx;
#line 950
#endif
#line 950
    return err;
#line 950
}
#line 950

static int
#line 951
ncx_get_uint_uchar(const void *xp, uchar *ip)
#line 951
{
#line 951
    int err=NC_NOERR;
#line 951
#if SIZEOF_IX_UINT == SIZEOF_UCHAR && IX_UINT_MAX == UCHAR_MAX
#line 951
    get_ix_uint(xp, (ix_uint *)ip);
#line 951
#else
#line 951
    ix_uint xx = 0;
#line 951
    get_ix_uint(xp, &xx);
#line 951

#line 951
#if IX_UINT_MAX > UCHAR_MAX
#line 951
    if (xx > UCHAR_MAX) {
#line 951
#ifdef ERANGE_FILL
#line 951
        *ip = NC_FILL_UBYTE;
#line 951
        return NC_ERANGE;
#line 951
#else
#line 951
        err = NC_ERANGE;
#line 951
#endif
#line 951
    }
#line 951
#endif
#line 951

#line 951

#line 951
    *ip = (uchar) xx;
#line 951
#endif
#line 951
    return err;
#line 951
}
#line 951

static int
#line 952
ncx_get_uint_ulonglong(const void *xp, ulonglong *ip)
#line 952
{
#line 952
    int err=NC_NOERR;
#line 952
#if SIZEOF_IX_UINT == SIZEOF_ULONGLONG && IX_UINT_MAX == ULONGLONG_MAX
#line 952
    get_ix_uint(xp, (ix_uint *)ip);
#line 952
#else
#line 952
    ix_uint xx = 0;
#line 952
    get_ix_uint(xp, &xx);
#line 952

#line 952
#if IX_UINT_MAX > ULONGLONG_MAX
#line 952
    if (xx > ULONGLONG_MAX) {
#line 952
#ifdef ERANGE_FILL
#line 952
        *ip = NC_FILL_UINT64;
#line 952
        return NC_ERANGE;
#line 952
#else
#line 952
        err = NC_ERANGE;
#line 952
#endif
#line 952
    }
#line 952
#endif
#line 952

#line 952

#line 952
    *ip = (ulonglong) xx;
#line 952
#endif
#line 952
    return err;
#line 952
}
#line 952

static int
#line 953
ncx_get_uint_float(const void *xp, float *ip)
#line 953
{
#line 953
	ix_uint xx = 0;
#line 953
	get_ix_uint(xp, &xx);
#line 953
	*ip = (float)xx;
#line 953
	return NC_NOERR;
#line 953
}
#line 953

static int
#line 954
ncx_get_uint_double(const void *xp, double *ip)
#line 954
{
#line 954
	ix_uint xx = 0;
#line 954
	get_ix_uint(xp, &xx);
#line 954
	*ip = (double)xx;
#line 954
	return NC_NOERR;
#line 954
}
#line 954


static int
ncx_put_uint_schar(void *xp, const schar *ip, void *fillp)
{
    uchar *cp;
    if (*ip < 0) {
#ifdef ERANGE_FILL
        if (fillp != NULL) memcpy(xp, fillp, 4);
#ifndef WORDS_BIGENDIAN
        swapn4b(xp, xp, 1);
#endif
#endif
        return NC_ERANGE;
    }

    cp = (uchar *) xp;
    *cp++ = 0x00;
    *cp++ = 0x00;
    *cp++ = 0x00;
    *cp = (uchar)*ip;

    return NC_NOERR;
}

static int
ncx_put_uint_uchar(void *xp, const uchar *ip, void *fillp)
{
	uchar *cp = (uchar *) xp;
	*cp++ = 0x00;
	*cp++ = 0x00;
	*cp++ = 0x00;
	*cp   = *ip;
	return NC_NOERR;
}

#if X_SIZEOF_UINT != SIZEOF_UINT
static int
#line 991
ncx_put_uint_uint(void *xp, const uint *ip, void *fillp)
#line 991
{
#line 991
    int err=NC_NOERR;
#line 991
#if SIZEOF_IX_UINT == SIZEOF_UINT && IX_UINT_MAX == UINT_MAX
#line 991
    put_ix_uint(xp, (const ix_uint *)ip);
#line 991
#else
#line 991
    ix_uint xx = NC_FILL_UINT;
#line 991

#line 991
#if IX_UINT_MAX < UINT_MAX
#line 991
    if (*ip > IX_UINT_MAX) {
#line 991
        
#line 991
#ifdef ERANGE_FILL
#line 991
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 991
#endif
#line 991
        err = NC_ERANGE;
#line 991
    }
#line 991
#ifdef ERANGE_FILL
#line 991
    else
#line 991
#endif
#line 991
#endif
#line 991
        xx = (ix_uint)*ip;
#line 991

#line 991
    put_ix_uint(xp, &xx);
#line 991
#endif
#line 991
    return err;
#line 991
}
#line 991

#endif

static int
#line 994
ncx_put_uint_short(void *xp, const short *ip, void *fillp)
#line 994
{
#line 994
    int err=NC_NOERR;
#line 994
    ix_uint xx = NC_FILL_UINT;
#line 994

#line 994
#if IX_UINT_MAX < SHORT_MAX
#line 994
    if (*ip > IX_UINT_MAX) {
#line 994
        
#line 994
#ifdef ERANGE_FILL
#line 994
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 994
#endif
#line 994
        err = NC_ERANGE;
#line 994
    }
#line 994
#ifdef ERANGE_FILL
#line 994
    else
#line 994
#endif
#line 994
#endif
#line 994
    if (*ip < 0) {
#line 994
        
#line 994
#ifdef ERANGE_FILL
#line 994
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 994
#endif
#line 994
        err = NC_ERANGE; /* because xp is unsigned */
#line 994
    }
#line 994
#ifdef ERANGE_FILL
#line 994
    else
#line 994
#endif
#line 994
        xx = (ix_uint)*ip;
#line 994

#line 994
    put_ix_uint(xp, &xx);
#line 994
    return err;
#line 994
}
#line 994

static int
#line 995
ncx_put_uint_int(void *xp, const int *ip, void *fillp)
#line 995
{
#line 995
    int err=NC_NOERR;
#line 995
    ix_uint xx = NC_FILL_UINT;
#line 995

#line 995
#if IX_UINT_MAX < INT_MAX
#line 995
    if (*ip > IX_UINT_MAX) {
#line 995
        
#line 995
#ifdef ERANGE_FILL
#line 995
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 995
#endif
#line 995
        err = NC_ERANGE;
#line 995
    }
#line 995
#ifdef ERANGE_FILL
#line 995
    else
#line 995
#endif
#line 995
#endif
#line 995
    if (*ip < 0) {
#line 995
        
#line 995
#ifdef ERANGE_FILL
#line 995
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 995
#endif
#line 995
        err = NC_ERANGE; /* because xp is unsigned */
#line 995
    }
#line 995
#ifdef ERANGE_FILL
#line 995
    else
#line 995
#endif
#line 995
        xx = (ix_uint)*ip;
#line 995

#line 995
    put_ix_uint(xp, &xx);
#line 995
    return err;
#line 995
}
#line 995

static int
#line 996
ncx_put_uint_long(void *xp, const long *ip, void *fillp)
#line 996
{
#line 996
    int err=NC_NOERR;
#line 996
    ix_uint xx = NC_FILL_UINT;
#line 996

#line 996
#if IX_UINT_MAX < LONG_MAX
#line 996
    if (*ip > IX_UINT_MAX) {
#line 996
        
#line 996
#ifdef ERANGE_FILL
#line 996
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 996
#endif
#line 996
        err = NC_ERANGE;
#line 996
    }
#line 996
#ifdef ERANGE_FILL
#line 996
    else
#line 996
#endif
#line 996
#endif
#line 996
    if (*ip < 0) {
#line 996
        
#line 996
#ifdef ERANGE_FILL
#line 996
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 996
#endif
#line 996
        err = NC_ERANGE; /* because xp is unsigned */
#line 996
    }
#line 996
#ifdef ERANGE_FILL
#line 996
    else
#line 996
#endif
#line 996
        xx = (ix_uint)*ip;
#line 996

#line 996
    put_ix_uint(xp, &xx);
#line 996
    return err;
#line 996
}
#line 996

static int
#line 997
ncx_put_uint_longlong(void *xp, const longlong *ip, void *fillp)
#line 997
{
#line 997
    int err=NC_NOERR;
#line 997
    ix_uint xx = NC_FILL_UINT;
#line 997

#line 997
#if IX_UINT_MAX < LONGLONG_MAX
#line 997
    if (*ip > IX_UINT_MAX) {
#line 997
        
#line 997
#ifdef ERANGE_FILL
#line 997
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 997
#endif
#line 997
        err = NC_ERANGE;
#line 997
    }
#line 997
#ifdef ERANGE_FILL
#line 997
    else
#line 997
#endif
#line 997
#endif
#line 997
    if (*ip < 0) {
#line 997
        
#line 997
#ifdef ERANGE_FILL
#line 997
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 997
#endif
#line 997
        err = NC_ERANGE; /* because xp is unsigned */
#line 997
    }
#line 997
#ifdef ERANGE_FILL
#line 997
    else
#line 997
#endif
#line 997
        xx = (ix_uint)*ip;
#line 997

#line 997
    put_ix_uint(xp, &xx);
#line 997
    return err;
#line 997
}
#line 997

static int
#line 998
ncx_put_uint_ushort(void *xp, const ushort *ip, void *fillp)
#line 998
{
#line 998
    int err=NC_NOERR;
#line 998
#if SIZEOF_IX_UINT == SIZEOF_USHORT && IX_UINT_MAX == USHORT_MAX
#line 998
    put_ix_uint(xp, (const ix_uint *)ip);
#line 998
#else
#line 998
    ix_uint xx = NC_FILL_UINT;
#line 998

#line 998
#if IX_UINT_MAX < USHORT_MAX
#line 998
    if (*ip > IX_UINT_MAX) {
#line 998
        
#line 998
#ifdef ERANGE_FILL
#line 998
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 998
#endif
#line 998
        err = NC_ERANGE;
#line 998
    }
#line 998
#ifdef ERANGE_FILL
#line 998
    else
#line 998
#endif
#line 998
#endif
#line 998
        xx = (ix_uint)*ip;
#line 998

#line 998
    put_ix_uint(xp, &xx);
#line 998
#endif
#line 998
    return err;
#line 998
}
#line 998

static int
#line 999
ncx_put_uint_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 999
{
#line 999
    int err=NC_NOERR;
#line 999
#if SIZEOF_IX_UINT == SIZEOF_ULONGLONG && IX_UINT_MAX == ULONGLONG_MAX
#line 999
    put_ix_uint(xp, (const ix_uint *)ip);
#line 999
#else
#line 999
    ix_uint xx = NC_FILL_UINT;
#line 999

#line 999
#if IX_UINT_MAX < ULONGLONG_MAX
#line 999
    if (*ip > IX_UINT_MAX) {
#line 999
        
#line 999
#ifdef ERANGE_FILL
#line 999
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 999
#endif
#line 999
        err = NC_ERANGE;
#line 999
    }
#line 999
#ifdef ERANGE_FILL
#line 999
    else
#line 999
#endif
#line 999
#endif
#line 999
        xx = (ix_uint)*ip;
#line 999

#line 999
    put_ix_uint(xp, &xx);
#line 999
#endif
#line 999
    return err;
#line 999
}
#line 999

static int
#line 1000
ncx_put_uint_float(void *xp, const float *ip, void *fillp)
#line 1000
{
#line 1000
    int err=NC_NOERR;
#line 1000
    ix_uint xx = NC_FILL_UINT;
#line 1000

#line 1000
    if (*ip > (double)X_UINT_MAX || *ip < 0) {
#line 1000
        
#line 1000
#ifdef ERANGE_FILL
#line 1000
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1000
#endif
#line 1000
        err = NC_ERANGE;
#line 1000
    }
#line 1000
#ifdef ERANGE_FILL
#line 1000
    else
#line 1000
#endif
#line 1000
        xx = (ix_uint)*ip;
#line 1000

#line 1000
    put_ix_uint(xp, &xx);
#line 1000
    return err;
#line 1000
}
#line 1000

static int
#line 1001
ncx_put_uint_double(void *xp, const double *ip, void *fillp)
#line 1001
{
#line 1001
    int err=NC_NOERR;
#line 1001
    ix_uint xx = NC_FILL_UINT;
#line 1001

#line 1001
    if (*ip > X_UINT_MAX || *ip < 0) {
#line 1001
        
#line 1001
#ifdef ERANGE_FILL
#line 1001
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1001
#endif
#line 1001
        err = NC_ERANGE;
#line 1001
    }
#line 1001
#ifdef ERANGE_FILL
#line 1001
    else
#line 1001
#endif
#line 1001
        xx = (ix_uint)*ip;
#line 1001

#line 1001
    put_ix_uint(xp, &xx);
#line 1001
    return err;
#line 1001
}
#line 1001



/* external NC_FLOAT --------------------------------------------------------*/

#if X_SIZEOF_FLOAT == SIZEOF_FLOAT && !defined(NO_IEEE_FLOAT)

inline static void
get_ix_float(const void *xp, float *ip)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(ip, xp, SIZEOF_FLOAT);
#else
	swap4b(ip, xp);
#endif
}

inline static void
put_ix_float(void *xp, const float *ip)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(xp, ip, X_SIZEOF_FLOAT);
#else
	swap4b(xp, ip);
#endif
}

#elif defined(vax) && vax != 0

/* What IEEE single precision floating point looks like on a Vax */
struct	ieee_single {
	unsigned int	exp_hi       : 7;
	unsigned int	sign         : 1;
	unsigned int 	mant_hi      : 7;
	unsigned int	exp_lo       : 1;
	unsigned int	mant_lo_hi   : 8;
	unsigned int	mant_lo_lo   : 8;
};

/* Vax single precision floating point */
struct	vax_single {
	unsigned int	mantissa1 : 7;
	unsigned int	exp       : 8;
	unsigned int	sign      : 1;
	unsigned int	mantissa2 : 16;
};

#define VAX_SNG_BIAS	0x81
#define IEEE_SNG_BIAS	0x7f

static struct sgl_limits {
	struct vax_single s;
	struct ieee_single ieee;
} max = {
	{ 0x7f, 0xff, 0x0, 0xffff },	/* Max Vax */
	{ 0x7f, 0x0, 0x0, 0x1, 0x0, 0x0 }		/* Max IEEE */
};
static struct sgl_limits min = {
	{ 0x0, 0x0, 0x0, 0x0 },	/* Min Vax */
	{ 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 }		/* Min IEEE */
};

#line 1115
static void
get_ix_float(const void *xp, float *ip)
{
		struct vax_single *const vsp = (struct vax_single *) ip;
#line 1118
		const struct ieee_single *const isp =
#line 1118
			 (const struct ieee_single *) xp;
#line 1118
		unsigned exp = isp->exp_hi << 1 | isp->exp_lo;
#line 1118

#line 1118
		switch(exp) {
#line 1118
		case 0 :
#line 1118
			/* ieee subnormal */
#line 1118
			if (isp->mant_hi == min.ieee.mant_hi
#line 1118
				&& isp->mant_lo_hi == min.ieee.mant_lo_hi
#line 1118
				&& isp->mant_lo_lo == min.ieee.mant_lo_lo)
#line 1118
			{
#line 1118
				*vsp = min.s;
#line 1118
			}
#line 1118
			else
#line 1118
			{
#line 1118
				unsigned mantissa = (isp->mant_hi << 16)
#line 1118
					 | isp->mant_lo_hi << 8
#line 1118
					 | isp->mant_lo_lo;
#line 1118
				unsigned tmp = mantissa >> 20;
#line 1118
				if (tmp >= 4) {
#line 1118
					vsp->exp = 2;
#line 1118
				} else if (tmp >= 2) {
#line 1118
					vsp->exp = 1;
#line 1118
				} else {
#line 1118
					*vsp = min.s;
#line 1118
					break;
#line 1118
				} /* else */
#line 1118
				tmp = mantissa - (1 << (20 + vsp->exp ));
#line 1118
				tmp <<= 3 - vsp->exp;
#line 1118
				vsp->mantissa2 = tmp;
#line 1118
				vsp->mantissa1 = (tmp >> 16);
#line 1118
			}
#line 1118
			break;
#line 1118
		case 0xfe :
#line 1118
		case 0xff :
#line 1118
			*vsp = max.s;
#line 1118
			break;
#line 1118
		default :
#line 1118
			vsp->exp = exp - IEEE_SNG_BIAS + VAX_SNG_BIAS;
#line 1118
			vsp->mantissa2 = isp->mant_lo_hi << 8 | isp->mant_lo_lo;
#line 1118
			vsp->mantissa1 = isp->mant_hi;
#line 1118
		}
#line 1118

#line 1118
		vsp->sign = isp->sign;
#line 1118

}

#line 1172

static void
put_ix_float(void *xp, const float *ip)
{
		const struct vax_single *const vsp =
#line 1176
			 (const struct vax_single *)ip;
#line 1176
		struct ieee_single *const isp = (struct ieee_single *) xp;
#line 1176

#line 1176
		switch(vsp->exp){
#line 1176
		case 0 :
#line 1176
			/* all vax float with zero exponent map to zero */
#line 1176
			*isp = min.ieee;
#line 1176
			break;
#line 1176
		case 2 :
#line 1176
		case 1 :
#line 1176
		{
#line 1176
			/* These will map to subnormals */
#line 1176
			unsigned mantissa = (vsp->mantissa1 << 16)
#line 1176
					 | vsp->mantissa2;
#line 1176
			mantissa >>= 3 - vsp->exp;
#line 1176
			mantissa += (1 << (20 + vsp->exp));
#line 1176
			isp->mant_lo_lo = mantissa;
#line 1176
			isp->mant_lo_hi = mantissa >> 8;
#line 1176
			isp->mant_hi = mantissa >> 16;
#line 1176
			isp->exp_lo = 0;
#line 1176
			isp->exp_hi = 0;
#line 1176
		}
#line 1176
			break;
#line 1176
		case 0xff : /* max.s.exp */
#line 1176
			if (vsp->mantissa2 == max.s.mantissa2 &&
#line 1176
			    vsp->mantissa1 == max.s.mantissa1)
#line 1176
			{
#line 1176
				/* map largest vax float to ieee infinity */
#line 1176
				*isp = max.ieee;
#line 1176
				break;
#line 1176
			} /* else, fall thru */
#line 1176
		default :
#line 1176
		{
#line 1176
			unsigned exp = vsp->exp - VAX_SNG_BIAS + IEEE_SNG_BIAS;
#line 1176
			isp->exp_hi = exp >> 1;
#line 1176
			isp->exp_lo = exp;
#line 1176
			isp->mant_lo_lo = vsp->mantissa2;
#line 1176
			isp->mant_lo_hi = vsp->mantissa2 >> 8;
#line 1176
			isp->mant_hi = vsp->mantissa1;
#line 1176
		}
#line 1176
		}
#line 1176

#line 1176
		isp->sign = vsp->sign;
#line 1176

}

	/* vax */
#elif defined(_CRAY) && !defined(__crayx1)

/*
 * Return the number of bytes until the next "word" boundary
 * N.B. This is based on the very weird YMP address structure,
 * which puts the address within a word in the leftmost 3 bits
 * of the address.
 */
static size_t
word_align(const void *vp)
{
	const size_t rem = ((size_t)vp >> (64 - 3)) & 0x7;
	return (rem != 0);
}

struct ieee_single_hi {
	unsigned int	sign	: 1;
	unsigned int	 exp	: 8;
	unsigned int	mant	:23;
	unsigned int	pad	:32;
};
typedef struct ieee_single_hi ieee_single_hi;

struct ieee_single_lo {
	unsigned int	pad	:32;
	unsigned int	sign	: 1;
	unsigned int	 exp	: 8;
	unsigned int	mant	:23;
};
typedef struct ieee_single_lo ieee_single_lo;

static const int ieee_single_bias = 0x7f;

struct ieee_double {
	unsigned int	sign	: 1;
	unsigned int	 exp	:11;
	unsigned int	mant	:52;
};
typedef struct ieee_double ieee_double;

static const int ieee_double_bias = 0x3ff;

#if defined(NO_IEEE_FLOAT)

struct cray_single {
	unsigned int	sign	: 1;
	unsigned int	 exp	:15;
	unsigned int	mant	:48;
};
typedef struct cray_single cray_single;

static const int cs_ieis_bias = 0x4000 - 0x7f;

static const int cs_id_bias = 0x4000 - 0x3ff;

#line 1311

static void
get_ix_float(const void *xp, float *ip)
{

	if (word_align(xp) == 0)
	{
		const ieee_single_hi *isp = (const ieee_single_hi *) xp;
		cray_single *csp = (cray_single *) ip;
#line 1319

#line 1319
		if (isp->exp == 0)
#line 1319
		{
#line 1319
			/* ieee subnormal */
#line 1319
			*ip = (double)isp->mant;
#line 1319
			if (isp->mant != 0)
#line 1319
			{
#line 1319
				csp->exp -= (ieee_single_bias + 22);
#line 1319
			}
#line 1319
		}
#line 1319
		else
#line 1319
		{
#line 1319
			csp->exp  = isp->exp + cs_ieis_bias + 1;
#line 1319
			csp->mant = isp->mant << (48 - 1 - 23);
#line 1319
			csp->mant |= (1 << (48 - 1));
#line 1319
		}
#line 1319
		csp->sign = isp->sign;
#line 1319

#line 1319

	}
	else
	{
		const ieee_single_lo *isp = (const ieee_single_lo *) xp;
		cray_single *csp = (cray_single *) ip;
#line 1324

#line 1324
		if (isp->exp == 0)
#line 1324
		{
#line 1324
			/* ieee subnormal */
#line 1324
			*ip = (double)isp->mant;
#line 1324
			if (isp->mant != 0)
#line 1324
			{
#line 1324
				csp->exp -= (ieee_single_bias + 22);
#line 1324
			}
#line 1324
		}
#line 1324
		else
#line 1324
		{
#line 1324
			csp->exp  = isp->exp + cs_ieis_bias + 1;
#line 1324
			csp->mant = isp->mant << (48 - 1 - 23);
#line 1324
			csp->mant |= (1 << (48 - 1));
#line 1324
		}
#line 1324
		csp->sign = isp->sign;
#line 1324

#line 1324

	}
}

static void
put_ix_float(void *xp, const float *ip)
{
	if (word_align(xp) == 0)
	{
		ieee_single_hi *isp = (ieee_single_hi*)xp;
	const cray_single *csp = (const cray_single *) ip;
#line 1334
	int ieee_exp = csp->exp - cs_ieis_bias -1;
#line 1334

#line 1334
	isp->sign = csp->sign;
#line 1334

#line 1334
	if (ieee_exp >= 0xff)
#line 1334
	{
#line 1334
		/* NC_ERANGE => ieee Inf */
#line 1334
		isp->exp = 0xff;
#line 1334
		isp->mant = 0x0;
#line 1334
	}
#line 1334
	else if (ieee_exp > 0)
#line 1334
	{
#line 1334
		/* normal ieee representation */
#line 1334
		isp->exp  = ieee_exp;
#line 1334
		/* assumes cray rep is in normal form */
#line 1334
		assert(csp->mant & 0x800000000000);
#line 1334
		isp->mant = (((csp->mant << 1) &
#line 1334
				0xffffffffffff) >> (48 - 23));
#line 1334
	}
#line 1334
	else if (ieee_exp > -23)
#line 1334
	{
#line 1334
		/* ieee subnormal, right shift */
#line 1334
		const int rshift = (48 - 23 - ieee_exp);
#line 1334

#line 1334
		isp->mant = csp->mant >> rshift;
#line 1334

#line 1334
#if 0
#line 1334
		if (csp->mant & (1 << (rshift -1)))
#line 1334
		{
#line 1334
			/* round up */
#line 1334
			isp->mant++;
#line 1334
		}
#line 1334
#endif
#line 1334

#line 1334
		isp->exp  = 0;
#line 1334
	}
#line 1334
	else
#line 1334
	{
#line 1334
		/* smaller than ieee can represent */
#line 1334
		isp->exp = 0;
#line 1334
		isp->mant = 0;
#line 1334
	}
#line 1334

	}
	else
	{
		ieee_single_lo *isp = (ieee_single_lo*)xp;
	const cray_single *csp = (const cray_single *) ip;
#line 1339
	int ieee_exp = csp->exp - cs_ieis_bias -1;
#line 1339

#line 1339
	isp->sign = csp->sign;
#line 1339

#line 1339
	if (ieee_exp >= 0xff)
#line 1339
	{
#line 1339
		/* NC_ERANGE => ieee Inf */
#line 1339
		isp->exp = 0xff;
#line 1339
		isp->mant = 0x0;
#line 1339
	}
#line 1339
	else if (ieee_exp > 0)
#line 1339
	{
#line 1339
		/* normal ieee representation */
#line 1339
		isp->exp  = ieee_exp;
#line 1339
		/* assumes cray rep is in normal form */
#line 1339
		assert(csp->mant & 0x800000000000);
#line 1339
		isp->mant = (((csp->mant << 1) &
#line 1339
				0xffffffffffff) >> (48 - 23));
#line 1339
	}
#line 1339
	else if (ieee_exp > -23)
#line 1339
	{
#line 1339
		/* ieee subnormal, right shift */
#line 1339
		const int rshift = (48 - 23 - ieee_exp);
#line 1339

#line 1339
		isp->mant = csp->mant >> rshift;
#line 1339

#line 1339
#if 0
#line 1339
		if (csp->mant & (1 << (rshift -1)))
#line 1339
		{
#line 1339
			/* round up */
#line 1339
			isp->mant++;
#line 1339
		}
#line 1339
#endif
#line 1339

#line 1339
		isp->exp  = 0;
#line 1339
	}
#line 1339
	else
#line 1339
	{
#line 1339
		/* smaller than ieee can represent */
#line 1339
		isp->exp = 0;
#line 1339
		isp->mant = 0;
#line 1339
	}
#line 1339

	}
}

#else
	/* IEEE Cray with only doubles */
static void
get_ix_float(const void *xp, float *ip)
{

	ieee_double *idp = (ieee_double *) ip;

	if (word_align(xp) == 0)
	{
		const ieee_single_hi *isp = (const ieee_single_hi *) xp;
		if (isp->exp == 0 && isp->mant == 0)
		{
			idp->exp = 0;
			idp->mant = 0;
		}
		else
		{
			idp->exp = isp->exp + (ieee_double_bias - ieee_single_bias);
			idp->mant = isp->mant << (52 - 23);
		}
		idp->sign = isp->sign;
	}
	else
	{
		const ieee_single_lo *isp = (const ieee_single_lo *) xp;
		if (isp->exp == 0 && isp->mant == 0)
		{
			idp->exp = 0;
			idp->mant = 0;
		}
		else
		{
			idp->exp = isp->exp + (ieee_double_bias - ieee_single_bias);
			idp->mant = isp->mant << (52 - 23);
		}
		idp->sign = isp->sign;
	}
}

static void
put_ix_float(void *xp, const float *ip)
{
	const ieee_double *idp = (const ieee_double *) ip;
	if (word_align(xp) == 0)
	{
		ieee_single_hi *isp = (ieee_single_hi*)xp;
		if (idp->exp > (ieee_double_bias - ieee_single_bias))
			isp->exp = idp->exp - (ieee_double_bias - ieee_single_bias);
		else
			isp->exp = 0;
		isp->mant = idp->mant >> (52 - 23);
		isp->sign = idp->sign;
	}
	else
	{
		ieee_single_lo *isp = (ieee_single_lo*)xp;
		if (idp->exp > (ieee_double_bias - ieee_single_bias))
			isp->exp = idp->exp - (ieee_double_bias - ieee_single_bias);
		else
			isp->exp = 0;
		isp->mant = idp->mant >> (52 - 23);
		isp->sign = idp->sign;
	}
}
#endif

#else
#error "ix_float implementation"
#endif

#if X_SIZEOF_FLOAT != SIZEOF_FLOAT || defined(NO_IEEE_FLOAT)
static int
ncx_get_float_float(const void *xp, float *ip, void *fillp)
{
	/* TODO */
	get_ix_float(xp, ip);
	return NC_NOERR;
}
#endif

#define ix_float float

static int
#line 1426
ncx_get_float_schar(const void *xp, schar *ip)
#line 1426
{
#line 1426
	ix_float xx = 0;
#line 1426
	get_ix_float(xp, &xx);
#line 1426
	if (xx > (double)SCHAR_MAX || xx < (double)SCHAR_MIN) {
#line 1426
#ifdef ERANGE_FILL
#line 1426
            *ip = NC_FILL_BYTE;
#line 1426
#endif
#line 1426
            return NC_ERANGE;
#line 1426
        }
#line 1426
	*ip = (schar)xx;
#line 1426
	return NC_NOERR;
#line 1426
}
#line 1426

static int
#line 1427
ncx_get_float_short(const void *xp, short *ip)
#line 1427
{
#line 1427
	ix_float xx = 0;
#line 1427
	get_ix_float(xp, &xx);
#line 1427
	if (xx > (double)SHORT_MAX || xx < (double)SHORT_MIN) {
#line 1427
#ifdef ERANGE_FILL
#line 1427
            *ip = NC_FILL_SHORT;
#line 1427
#endif
#line 1427
            return NC_ERANGE;
#line 1427
        }
#line 1427
	*ip = (short)xx;
#line 1427
	return NC_NOERR;
#line 1427
}
#line 1427

static int
#line 1428
ncx_get_float_int(const void *xp, int *ip)
#line 1428
{
#line 1428
	ix_float xx = 0;
#line 1428
	get_ix_float(xp, &xx);
#line 1428
	if (xx > (double)INT_MAX || xx < (double)INT_MIN) {
#line 1428
#ifdef ERANGE_FILL
#line 1428
            *ip = NC_FILL_INT;
#line 1428
#endif
#line 1428
            return NC_ERANGE;
#line 1428
        }
#line 1428
	*ip = (int)xx;
#line 1428
	return NC_NOERR;
#line 1428
}
#line 1428

static int
#line 1429
ncx_get_float_long(const void *xp, long *ip)
#line 1429
{
#line 1429
	ix_float xx = 0;
#line 1429
	get_ix_float(xp, &xx);
#line 1429
	if (xx > (double)LONG_MAX || xx < (double)LONG_MIN) {
#line 1429
#ifdef ERANGE_FILL
#line 1429
            *ip = NC_FILL_INT;
#line 1429
#endif
#line 1429
            return NC_ERANGE;
#line 1429
        }
#line 1429
	*ip = (long)xx;
#line 1429
	return NC_NOERR;
#line 1429
}
#line 1429

static int
#line 1430
ncx_get_float_double(const void *xp, double *ip)
#line 1430
{
#line 1430
	ix_float xx = 0;
#line 1430
	get_ix_float(xp, &xx);
#line 1430
	*ip = (double)xx;
#line 1430
	return NC_NOERR;
#line 1430
}
#line 1430

static int
#line 1431
ncx_get_float_longlong(const void *xp, longlong *ip)
#line 1431
{
#line 1431
	ix_float xx = 0;
#line 1431
	get_ix_float(xp, &xx);
#line 1431
	if (xx == LONGLONG_MAX)      *ip = LONGLONG_MAX;
#line 1431
	else if (xx == LONGLONG_MIN) *ip = LONGLONG_MIN;
#line 1431
	else if (xx > (double)LONGLONG_MAX || xx < (double)LONGLONG_MIN) {
#line 1431
#ifdef ERANGE_FILL
#line 1431
            *ip = NC_FILL_INT64;
#line 1431
#endif
#line 1431
            return NC_ERANGE;
#line 1431
        }
#line 1431
	else *ip = (longlong)xx;
#line 1431
	return NC_NOERR;
#line 1431
}
#line 1431

static int
#line 1432
ncx_get_float_uchar(const void *xp, uchar *ip)
#line 1432
{
#line 1432
	ix_float xx = 0;
#line 1432
	get_ix_float(xp, &xx);
#line 1432
	if (xx > (double)UCHAR_MAX || xx < 0) {
#line 1432
#ifdef ERANGE_FILL
#line 1432
            *ip = NC_FILL_UBYTE;
#line 1432
#endif
#line 1432
            return NC_ERANGE;
#line 1432
        }
#line 1432
	*ip = (uchar)xx;
#line 1432
	return NC_NOERR;
#line 1432
}
#line 1432

static int
#line 1433
ncx_get_float_ushort(const void *xp, ushort *ip)
#line 1433
{
#line 1433
	ix_float xx = 0;
#line 1433
	get_ix_float(xp, &xx);
#line 1433
	if (xx > (double)USHORT_MAX || xx < 0) {
#line 1433
#ifdef ERANGE_FILL
#line 1433
            *ip = NC_FILL_USHORT;
#line 1433
#endif
#line 1433
            return NC_ERANGE;
#line 1433
        }
#line 1433
	*ip = (ushort)xx;
#line 1433
	return NC_NOERR;
#line 1433
}
#line 1433

static int
#line 1434
ncx_get_float_uint(const void *xp, uint *ip)
#line 1434
{
#line 1434
	ix_float xx = 0;
#line 1434
	get_ix_float(xp, &xx);
#line 1434
	if (xx > (double)UINT_MAX || xx < 0) {
#line 1434
#ifdef ERANGE_FILL
#line 1434
            *ip = NC_FILL_UINT;
#line 1434
#endif
#line 1434
            return NC_ERANGE;
#line 1434
        }
#line 1434
	*ip = (uint)xx;
#line 1434
	return NC_NOERR;
#line 1434
}
#line 1434

static int
#line 1435
ncx_get_float_ulonglong(const void *xp, ulonglong *ip)
#line 1435
{
#line 1435
	ix_float xx = 0;
#line 1435
	get_ix_float(xp, &xx);
#line 1435
	if (xx == ULONGLONG_MAX)      *ip = ULONGLONG_MAX;
#line 1435
	else if (xx > (double)ULONGLONG_MAX || xx < 0) {
#line 1435
#ifdef ERANGE_FILL
#line 1435
            *ip = NC_FILL_UINT64;
#line 1435
#endif
#line 1435
            return NC_ERANGE;
#line 1435
        }
#line 1435
	else *ip = (ulonglong)xx;
#line 1435
	return NC_NOERR;
#line 1435
}
#line 1435


#if X_SIZEOF_FLOAT != SIZEOF_FLOAT || defined(NO_IEEE_FLOAT)
static int
ncx_put_float_float(void *xp, const float *ip, void *fillp)
{
    int err=NC_NOERR;
    float *_ip=ip;
#ifdef NO_IEEE_FLOAT
#ifdef ERANGE_FILL
    float tmp;
#endif
    if (*ip > X_FLOAT_MAX || *ip < X_FLOAT_MIN) {
        
#line 1448
#ifdef ERANGE_FILL
#line 1448
            if (fillp != NULL) memcpy(&tmp, fillp, 4);
#line 1448
#endif
#ifdef ERANGE_FILL
        _ip = &tmp;
#endif
        err = NC_ERANGE;
    }
#endif
    put_ix_float(xp, _ip);
    return err;
}
#endif

static int
#line 1460
ncx_put_float_schar(void *xp, const schar *ip, void *fillp)
#line 1460
{
#line 1460
    int err=NC_NOERR;
#line 1460
    ix_float xx = NC_FILL_FLOAT;
#line 1460

#line 1460
    
#line 1460
        xx = (ix_float)*ip;
#line 1460

#line 1460
    put_ix_float(xp, &xx);
#line 1460
    return err;
#line 1460
}
#line 1460

static int
#line 1461
ncx_put_float_short(void *xp, const short *ip, void *fillp)
#line 1461
{
#line 1461
    int err=NC_NOERR;
#line 1461
    ix_float xx = NC_FILL_FLOAT;
#line 1461

#line 1461
    
#line 1461
        xx = (ix_float)*ip;
#line 1461

#line 1461
    put_ix_float(xp, &xx);
#line 1461
    return err;
#line 1461
}
#line 1461

static int
#line 1462
ncx_put_float_int(void *xp, const int *ip, void *fillp)
#line 1462
{
#line 1462
    int err=NC_NOERR;
#line 1462
    ix_float xx = NC_FILL_FLOAT;
#line 1462

#line 1462
    
#line 1462
        xx = (ix_float)*ip;
#line 1462

#line 1462
    put_ix_float(xp, &xx);
#line 1462
    return err;
#line 1462
}
#line 1462

static int
#line 1463
ncx_put_float_long(void *xp, const long *ip, void *fillp)
#line 1463
{
#line 1463
    int err=NC_NOERR;
#line 1463
    ix_float xx = NC_FILL_FLOAT;
#line 1463

#line 1463
    
#line 1463
        xx = (ix_float)*ip;
#line 1463

#line 1463
    put_ix_float(xp, &xx);
#line 1463
    return err;
#line 1463
}
#line 1463

static int
#line 1464
ncx_put_float_double(void *xp, const double *ip, void *fillp)
#line 1464
{
#line 1464
    int err=NC_NOERR;
#line 1464
    ix_float xx = NC_FILL_FLOAT;
#line 1464

#line 1464
    if (*ip > X_FLOAT_MAX || *ip < X_FLOAT_MIN) {
#line 1464
        
#line 1464
#ifdef ERANGE_FILL
#line 1464
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1464
#endif
#line 1464
        err = NC_ERANGE;
#line 1464
    }
#line 1464
#ifdef ERANGE_FILL
#line 1464
    else
#line 1464
#endif
#line 1464
        xx = (ix_float)*ip;
#line 1464

#line 1464
    put_ix_float(xp, &xx);
#line 1464
    return err;
#line 1464
}
#line 1464

static int
#line 1465
ncx_put_float_longlong(void *xp, const longlong *ip, void *fillp)
#line 1465
{
#line 1465
    int err=NC_NOERR;
#line 1465
    ix_float xx = NC_FILL_FLOAT;
#line 1465

#line 1465
    
#line 1465
        xx = (ix_float)*ip;
#line 1465

#line 1465
    put_ix_float(xp, &xx);
#line 1465
    return err;
#line 1465
}
#line 1465

static int
#line 1466
ncx_put_float_uchar(void *xp, const uchar *ip, void *fillp)
#line 1466
{
#line 1466
    int err=NC_NOERR;
#line 1466
    ix_float xx = NC_FILL_FLOAT;
#line 1466

#line 1466
    
#line 1466
        xx = (ix_float)*ip;
#line 1466

#line 1466
    put_ix_float(xp, &xx);
#line 1466
    return err;
#line 1466
}
#line 1466

static int
#line 1467
ncx_put_float_ushort(void *xp, const ushort *ip, void *fillp)
#line 1467
{
#line 1467
    int err=NC_NOERR;
#line 1467
    ix_float xx = NC_FILL_FLOAT;
#line 1467

#line 1467
    
#line 1467
        xx = (ix_float)*ip;
#line 1467

#line 1467
    put_ix_float(xp, &xx);
#line 1467
    return err;
#line 1467
}
#line 1467

static int
#line 1468
ncx_put_float_uint(void *xp, const uint *ip, void *fillp)
#line 1468
{
#line 1468
    int err=NC_NOERR;
#line 1468
    ix_float xx = NC_FILL_FLOAT;
#line 1468

#line 1468
    
#line 1468
        xx = (ix_float)*ip;
#line 1468

#line 1468
    put_ix_float(xp, &xx);
#line 1468
    return err;
#line 1468
}
#line 1468

static int
#line 1469
ncx_put_float_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 1469
{
#line 1469
    int err=NC_NOERR;
#line 1469
    ix_float xx = NC_FILL_FLOAT;
#line 1469

#line 1469
    
#line 1469
        xx = (ix_float)*ip;
#line 1469

#line 1469
    put_ix_float(xp, &xx);
#line 1469
    return err;
#line 1469
}
#line 1469



/* external NC_DOUBLE -------------------------------------------------------*/

#if X_SIZEOF_DOUBLE == SIZEOF_DOUBLE  && !defined(NO_IEEE_FLOAT)

static void
get_ix_double(const void *xp, double *ip)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(ip, xp, SIZEOF_DOUBLE);
#else
	swap8b(ip, xp);
#endif
}

static void
put_ix_double(void *xp, const double *ip)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(xp, ip, X_SIZEOF_DOUBLE);
#else
	swap8b(xp, ip);
#endif
}

#elif defined(vax) && vax != 0

/* What IEEE double precision floating point looks like on a Vax */
struct	ieee_double {
	unsigned int	exp_hi   : 7;
	unsigned int	sign     : 1;
	unsigned int 	mant_6   : 4;
	unsigned int	exp_lo   : 4;
	unsigned int	mant_5   : 8;
	unsigned int	mant_4   : 8;

	unsigned int	mant_lo  : 32;
};

/* Vax double precision floating point */
struct  vax_double {
	unsigned int	mantissa1 : 7;
	unsigned int	exp       : 8;
	unsigned int	sign      : 1;
	unsigned int	mantissa2 : 16;
	unsigned int	mantissa3 : 16;
	unsigned int	mantissa4 : 16;
};

#define VAX_DBL_BIAS	0x81
#define IEEE_DBL_BIAS	0x3ff
#define MASK(nbits)	((1 << nbits) - 1)

static const struct dbl_limits {
	struct	vax_double d;
	struct	ieee_double ieee;
} dbl_limits[2] = {
	{{ 0x7f, 0xff, 0x0, 0xffff, 0xffff, 0xffff },	/* Max Vax */
	{ 0x7f, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0}}, /* Max IEEE */
	{{ 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},		/* Min Vax */
	{ 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}}, /* Min IEEE */
};


#line 1583
static void
get_ix_double(const void *xp, double *ip)
{
	struct vax_double *const vdp =
#line 1586
			 (struct vax_double *)ip;
#line 1586
	const struct ieee_double *const idp =
#line 1586
			 (const struct ieee_double *) xp;
#line 1586
	{
#line 1586
		const struct dbl_limits *lim;
#line 1586
		int ii;
#line 1586
		for (ii = 0, lim = dbl_limits;
#line 1586
			ii < sizeof(dbl_limits)/sizeof(struct dbl_limits);
#line 1586
			ii++, lim++)
#line 1586
		{
#line 1586
			if ((idp->mant_lo == lim->ieee.mant_lo)
#line 1586
				&& (idp->mant_4 == lim->ieee.mant_4)
#line 1586
				&& (idp->mant_5 == lim->ieee.mant_5)
#line 1586
				&& (idp->mant_6 == lim->ieee.mant_6)
#line 1586
				&& (idp->exp_lo == lim->ieee.exp_lo)
#line 1586
				&& (idp->exp_hi == lim->ieee.exp_hi)
#line 1586
				)
#line 1586
			{
#line 1586
				*vdp = lim->d;
#line 1586
				goto doneit;
#line 1586
			}
#line 1586
		}
#line 1586
	}
#line 1586
	{
#line 1586
		unsigned exp = idp->exp_hi << 4 | idp->exp_lo;
#line 1586
		vdp->exp = exp - IEEE_DBL_BIAS + VAX_DBL_BIAS;
#line 1586
	}
#line 1586
	{
#line 1586
		unsigned mant_hi = ((idp->mant_6 << 16)
#line 1586
				 | (idp->mant_5 << 8)
#line 1586
				 | idp->mant_4);
#line 1586
		unsigned mant_lo = SWAP4(idp->mant_lo);
#line 1586
		vdp->mantissa1 = (mant_hi >> 13);
#line 1586
		vdp->mantissa2 = ((mant_hi & MASK(13)) << 3)
#line 1586
				| (mant_lo >> 29);
#line 1586
		vdp->mantissa3 = (mant_lo >> 13);
#line 1586
		vdp->mantissa4 = (mant_lo << 3);
#line 1586
	}
#line 1586
	doneit:
#line 1586
		vdp->sign = idp->sign;
#line 1586

}


#line 1656
static void
put_ix_double(void *xp, const double *ip)
{
	const struct vax_double *const vdp =
#line 1659
			(const struct vax_double *)ip;
#line 1659
	struct ieee_double *const idp =
#line 1659
			 (struct ieee_double *) xp;
#line 1659

#line 1659
	if ((vdp->mantissa4 > (dbl_limits[0].d.mantissa4 - 3)) &&
#line 1659
		(vdp->mantissa3 == dbl_limits[0].d.mantissa3) &&
#line 1659
		(vdp->mantissa2 == dbl_limits[0].d.mantissa2) &&
#line 1659
		(vdp->mantissa1 == dbl_limits[0].d.mantissa1) &&
#line 1659
		(vdp->exp == dbl_limits[0].d.exp))
#line 1659
	{
#line 1659
		*idp = dbl_limits[0].ieee;
#line 1659
		goto shipit;
#line 1659
	}
#line 1659
	if ((vdp->mantissa4 == dbl_limits[1].d.mantissa4) &&
#line 1659
		(vdp->mantissa3 == dbl_limits[1].d.mantissa3) &&
#line 1659
		(vdp->mantissa2 == dbl_limits[1].d.mantissa2) &&
#line 1659
		(vdp->mantissa1 == dbl_limits[1].d.mantissa1) &&
#line 1659
		(vdp->exp == dbl_limits[1].d.exp))
#line 1659
	{
#line 1659
		*idp = dbl_limits[1].ieee;
#line 1659
		goto shipit;
#line 1659
	}
#line 1659

#line 1659
	{
#line 1659
		unsigned exp = vdp->exp - VAX_DBL_BIAS + IEEE_DBL_BIAS;
#line 1659

#line 1659
		unsigned mant_lo = ((vdp->mantissa2 & MASK(3)) << 29) |
#line 1659
			(vdp->mantissa3 << 13) |
#line 1659
			((vdp->mantissa4 >> 3) & MASK(13));
#line 1659

#line 1659
		unsigned mant_hi = (vdp->mantissa1 << 13)
#line 1659
				 | (vdp->mantissa2 >> 3);
#line 1659

#line 1659
		if ((vdp->mantissa4 & 7) > 4)
#line 1659
		{
#line 1659
			/* round up */
#line 1659
			mant_lo++;
#line 1659
			if (mant_lo == 0)
#line 1659
			{
#line 1659
				mant_hi++;
#line 1659
				if (mant_hi > 0xffffff)
#line 1659
				{
#line 1659
					mant_hi = 0;
#line 1659
					exp++;
#line 1659
				}
#line 1659
			}
#line 1659
		}
#line 1659

#line 1659
		idp->mant_lo = SWAP4(mant_lo);
#line 1659
		idp->mant_6 = mant_hi >> 16;
#line 1659
		idp->mant_5 = (mant_hi & 0xff00) >> 8;
#line 1659
		idp->mant_4 = mant_hi;
#line 1659
		idp->exp_hi = exp >> 4;
#line 1659
		idp->exp_lo = exp;
#line 1659
	}
#line 1659

#line 1659
	shipit:
#line 1659
		idp->sign = vdp->sign;
#line 1659

}

	/* vax */
#elif defined(_CRAY) && !defined(__crayx1)

static void
get_ix_double(const void *xp, double *ip)
{
	const ieee_double *idp = (const ieee_double *) xp;
	cray_single *csp = (cray_single *) ip;

	if (idp->exp == 0)
	{
		/* ieee subnormal */
		*ip = (double)idp->mant;
		if (idp->mant != 0)
		{
			csp->exp -= (ieee_double_bias + 51);
		}
	}
	else
	{
		csp->exp  = idp->exp + cs_id_bias + 1;
		csp->mant = idp->mant >> (52 - 48 + 1);
		csp->mant |= (1 << (48 - 1));
	}
	csp->sign = idp->sign;
}

static void
put_ix_double(void *xp, const double *ip)
{
	ieee_double *idp = (ieee_double *) xp;
	const cray_single *csp = (const cray_single *) ip;

	int ieee_exp = csp->exp - cs_id_bias -1;

	idp->sign = csp->sign;

	if (ieee_exp >= 0x7ff)
	{
		/* NC_ERANGE => ieee Inf */
		idp->exp = 0x7ff;
		idp->mant = 0x0;
	}
	else if (ieee_exp > 0)
	{
		/* normal ieee representation */
		idp->exp  = ieee_exp;
		/* assumes cray rep is in normal form */
		assert(csp->mant & 0x800000000000);
		idp->mant = (((csp->mant << 1) &
				0xffffffffffff) << (52 - 48));
	}
	else if (ieee_exp >= (-(52 -48)))
	{
		/* ieee subnormal, left shift */
		const int lshift = (52 - 48) + ieee_exp;
		idp->mant = csp->mant << lshift;
		idp->exp  = 0;
	}
	else if (ieee_exp >= -52)
	{
		/* ieee subnormal, right shift */
		const int rshift = (- (52 - 48) - ieee_exp);

		idp->mant = csp->mant >> rshift;

#if 0
		if (csp->mant & (1 << (rshift -1)))
		{
			/* round up */
			idp->mant++;
		}
#endif

		idp->exp  = 0;
	}
	else
	{
		/* smaller than ieee can represent */
		idp->exp = 0;
		idp->mant = 0;
	}
}
#else
#error "ix_double implementation"
#endif

#define ix_double double

static int
#line 1751
ncx_get_double_schar(const void *xp, schar *ip)
#line 1751
{
#line 1751
	ix_double xx = 0;
#line 1751
	get_ix_double(xp, &xx);
#line 1751
	if (xx > (double)SCHAR_MAX || xx < (double)SCHAR_MIN) {
#line 1751
#ifdef ERANGE_FILL
#line 1751
            *ip = NC_FILL_BYTE;
#line 1751
#endif
#line 1751
            return NC_ERANGE;
#line 1751
        }
#line 1751
	*ip = (schar)xx;
#line 1751
	return NC_NOERR;
#line 1751
}
#line 1751

static int
#line 1752
ncx_get_double_short(const void *xp, short *ip)
#line 1752
{
#line 1752
	ix_double xx = 0;
#line 1752
	get_ix_double(xp, &xx);
#line 1752
	if (xx > (double)SHORT_MAX || xx < (double)SHORT_MIN) {
#line 1752
#ifdef ERANGE_FILL
#line 1752
            *ip = NC_FILL_SHORT;
#line 1752
#endif
#line 1752
            return NC_ERANGE;
#line 1752
        }
#line 1752
	*ip = (short)xx;
#line 1752
	return NC_NOERR;
#line 1752
}
#line 1752

static int
#line 1753
ncx_get_double_int(const void *xp, int *ip)
#line 1753
{
#line 1753
	ix_double xx = 0;
#line 1753
	get_ix_double(xp, &xx);
#line 1753
	if (xx > (double)INT_MAX || xx < (double)INT_MIN) {
#line 1753
#ifdef ERANGE_FILL
#line 1753
            *ip = NC_FILL_INT;
#line 1753
#endif
#line 1753
            return NC_ERANGE;
#line 1753
        }
#line 1753
	*ip = (int)xx;
#line 1753
	return NC_NOERR;
#line 1753
}
#line 1753

static int
#line 1754
ncx_get_double_long(const void *xp, long *ip)
#line 1754
{
#line 1754
	ix_double xx = 0;
#line 1754
	get_ix_double(xp, &xx);
#line 1754
	if (xx > (double)LONG_MAX || xx < (double)LONG_MIN) {
#line 1754
#ifdef ERANGE_FILL
#line 1754
            *ip = NC_FILL_INT;
#line 1754
#endif
#line 1754
            return NC_ERANGE;
#line 1754
        }
#line 1754
	*ip = (long)xx;
#line 1754
	return NC_NOERR;
#line 1754
}
#line 1754

static int
#line 1755
ncx_get_double_longlong(const void *xp, longlong *ip)
#line 1755
{
#line 1755
	ix_double xx = 0;
#line 1755
	get_ix_double(xp, &xx);
#line 1755
	if (xx == LONGLONG_MAX)      *ip = LONGLONG_MAX;
#line 1755
	else if (xx == LONGLONG_MIN) *ip = LONGLONG_MIN;
#line 1755
	else if (xx > (double)LONGLONG_MAX || xx < (double)LONGLONG_MIN) {
#line 1755
#ifdef ERANGE_FILL
#line 1755
            *ip = NC_FILL_INT64;
#line 1755
#endif
#line 1755
            return NC_ERANGE;
#line 1755
        }
#line 1755
	else *ip = (longlong)xx;
#line 1755
	return NC_NOERR;
#line 1755
}
#line 1755

static int
#line 1756
ncx_get_double_uchar(const void *xp, uchar *ip)
#line 1756
{
#line 1756
	ix_double xx = 0;
#line 1756
	get_ix_double(xp, &xx);
#line 1756
	if (xx > (double)UCHAR_MAX || xx < 0) {
#line 1756
#ifdef ERANGE_FILL
#line 1756
            *ip = NC_FILL_UBYTE;
#line 1756
#endif
#line 1756
            return NC_ERANGE;
#line 1756
        }
#line 1756
	*ip = (uchar)xx;
#line 1756
	return NC_NOERR;
#line 1756
}
#line 1756

static int
#line 1757
ncx_get_double_ushort(const void *xp, ushort *ip)
#line 1757
{
#line 1757
	ix_double xx = 0;
#line 1757
	get_ix_double(xp, &xx);
#line 1757
	if (xx > (double)USHORT_MAX || xx < 0) {
#line 1757
#ifdef ERANGE_FILL
#line 1757
            *ip = NC_FILL_USHORT;
#line 1757
#endif
#line 1757
            return NC_ERANGE;
#line 1757
        }
#line 1757
	*ip = (ushort)xx;
#line 1757
	return NC_NOERR;
#line 1757
}
#line 1757

static int
#line 1758
ncx_get_double_uint(const void *xp, uint *ip)
#line 1758
{
#line 1758
	ix_double xx = 0;
#line 1758
	get_ix_double(xp, &xx);
#line 1758
	if (xx > (double)UINT_MAX || xx < 0) {
#line 1758
#ifdef ERANGE_FILL
#line 1758
            *ip = NC_FILL_UINT;
#line 1758
#endif
#line 1758
            return NC_ERANGE;
#line 1758
        }
#line 1758
	*ip = (uint)xx;
#line 1758
	return NC_NOERR;
#line 1758
}
#line 1758

static int
#line 1759
ncx_get_double_ulonglong(const void *xp, ulonglong *ip)
#line 1759
{
#line 1759
	ix_double xx = 0;
#line 1759
	get_ix_double(xp, &xx);
#line 1759
	if (xx == ULONGLONG_MAX)      *ip = ULONGLONG_MAX;
#line 1759
	else if (xx > (double)ULONGLONG_MAX || xx < 0) {
#line 1759
#ifdef ERANGE_FILL
#line 1759
            *ip = NC_FILL_UINT64;
#line 1759
#endif
#line 1759
            return NC_ERANGE;
#line 1759
        }
#line 1759
	else *ip = (ulonglong)xx;
#line 1759
	return NC_NOERR;
#line 1759
}
#line 1759


static int
ncx_get_double_float(const void *xp, float *ip)
{
    double xx = 0.0;
    get_ix_double(xp, &xx);
    if (xx > FLT_MAX) {
#ifdef ERANGE_FILL
        *ip = NC_FILL_FLOAT;
#else
        *ip = FLT_MAX;
#endif
        return NC_ERANGE;
    }
    if (xx < (-FLT_MAX)) {
#ifdef ERANGE_FILL
        *ip = NC_FILL_FLOAT;
#else
        *ip = (-FLT_MAX);
#endif
        return NC_ERANGE;
    }
    *ip = (float) xx;
    return NC_NOERR;
}

#if X_SIZEOF_DOUBLE != SIZEOF_DOUBLE  || defined(NO_IEEE_FLOAT)
static int
ncx_get_double_double(const void *xp, double *ip, void *fillp)
{
	/* TODO */
	get_ix_double(xp, ip);
	return NC_NOERR;
}
#endif

static int
#line 1796
ncx_put_double_schar(void *xp, const schar *ip, void *fillp)
#line 1796
{
#line 1796
    int err=NC_NOERR;
#line 1796
    ix_double xx = NC_FILL_DOUBLE;
#line 1796

#line 1796
    
#line 1796
        xx = (ix_double)*ip;
#line 1796

#line 1796
    put_ix_double(xp, &xx);
#line 1796
    return err;
#line 1796
}
#line 1796

static int
#line 1797
ncx_put_double_uchar(void *xp, const uchar *ip, void *fillp)
#line 1797
{
#line 1797
    int err=NC_NOERR;
#line 1797
    ix_double xx = NC_FILL_DOUBLE;
#line 1797

#line 1797
    
#line 1797
        xx = (ix_double)*ip;
#line 1797

#line 1797
    put_ix_double(xp, &xx);
#line 1797
    return err;
#line 1797
}
#line 1797

static int
#line 1798
ncx_put_double_short(void *xp, const short *ip, void *fillp)
#line 1798
{
#line 1798
    int err=NC_NOERR;
#line 1798
    ix_double xx = NC_FILL_DOUBLE;
#line 1798

#line 1798
    
#line 1798
        xx = (ix_double)*ip;
#line 1798

#line 1798
    put_ix_double(xp, &xx);
#line 1798
    return err;
#line 1798
}
#line 1798

static int
#line 1799
ncx_put_double_ushort(void *xp, const ushort *ip, void *fillp)
#line 1799
{
#line 1799
    int err=NC_NOERR;
#line 1799
    ix_double xx = NC_FILL_DOUBLE;
#line 1799

#line 1799
    
#line 1799
        xx = (ix_double)*ip;
#line 1799

#line 1799
    put_ix_double(xp, &xx);
#line 1799
    return err;
#line 1799
}
#line 1799

static int
#line 1800
ncx_put_double_int(void *xp, const int *ip, void *fillp)
#line 1800
{
#line 1800
    int err=NC_NOERR;
#line 1800
    ix_double xx = NC_FILL_DOUBLE;
#line 1800

#line 1800
    
#line 1800
        xx = (ix_double)*ip;
#line 1800

#line 1800
    put_ix_double(xp, &xx);
#line 1800
    return err;
#line 1800
}
#line 1800

static int
#line 1801
ncx_put_double_long(void *xp, const long *ip, void *fillp)
#line 1801
{
#line 1801
    int err=NC_NOERR;
#line 1801
    ix_double xx = NC_FILL_DOUBLE;
#line 1801

#line 1801
    
#line 1801
        xx = (ix_double)*ip;
#line 1801

#line 1801
    put_ix_double(xp, &xx);
#line 1801
    return err;
#line 1801
}
#line 1801

static int
#line 1802
ncx_put_double_uint(void *xp, const uint *ip, void *fillp)
#line 1802
{
#line 1802
    int err=NC_NOERR;
#line 1802
    ix_double xx = NC_FILL_DOUBLE;
#line 1802

#line 1802
    
#line 1802
        xx = (ix_double)*ip;
#line 1802

#line 1802
    put_ix_double(xp, &xx);
#line 1802
    return err;
#line 1802
}
#line 1802

static int
#line 1803
ncx_put_double_longlong(void *xp, const longlong *ip, void *fillp)
#line 1803
{
#line 1803
    int err=NC_NOERR;
#line 1803
    ix_double xx = NC_FILL_DOUBLE;
#line 1803

#line 1803
    
#line 1803
        xx = (ix_double)*ip;
#line 1803

#line 1803
    put_ix_double(xp, &xx);
#line 1803
    return err;
#line 1803
}
#line 1803

static int
#line 1804
ncx_put_double_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 1804
{
#line 1804
    int err=NC_NOERR;
#line 1804
    ix_double xx = NC_FILL_DOUBLE;
#line 1804

#line 1804
    
#line 1804
        xx = (ix_double)*ip;
#line 1804

#line 1804
    put_ix_double(xp, &xx);
#line 1804
    return err;
#line 1804
}
#line 1804


static int
ncx_put_double_float(void *xp, const float *ip, void *fillp)
{
    int err=NC_NOERR;
    double xx = NC_FILL_DOUBLE;
#if 1	/* TODO: figure this out (if condition below will never be true)*/
    if ((double)(*ip) > X_DOUBLE_MAX || (double)(*ip) < X_DOUBLE_MIN) {
        
#line 1813
#ifdef ERANGE_FILL
#line 1813
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1813
#endif
        err = NC_ERANGE;
    }
#ifdef ERANGE_FILL
    else
#endif
#endif
        xx = (double) *ip;

    put_ix_double(xp, &xx);
    return err;
}

#if X_SIZEOF_DOUBLE != SIZEOF_DOUBLE  || defined(NO_IEEE_FLOAT)
static int
ncx_put_double_double(void *xp, const double *ip, void *fillp)
{
    int err=NC_NOERR;
    double *_ip = ip;
#ifdef NO_IEEE_FLOAT
#ifdef ERANGE_FILL
    double tmp=NC_FILL_DOUBLE;
#endif
    if (*ip > X_DOUBLE_MAX || *ip < X_DOUBLE_MIN) {
        
#line 1837
#ifdef ERANGE_FILL
#line 1837
            if (fillp != NULL) memcpy(&tmp, fillp, 8);
#line 1837
#endif
#ifdef ERANGE_FILL
        _ip = &tmp;
#endif
        err = NC_ERANGE;
    }
#endif
    put_ix_double(xp, _ip);
    return err;
}
#endif


/* external NC_INT64 --------------------------------------------------------*/

#if SHORT_MAX == X_INT64_MAX
typedef short ix_int64;
#define SIZEOF_IX_INT64 SIZEOF_SHORT
#define IX_INT64_MAX SHORT_MAX
#elif LONG_LONG_MAX  >= X_INT64_MAX
typedef longlong ix_int64;
#define SIZEOF_IX_INT64 SIZEOF_LONGLONG
#define IX_INT64_MAX LONG_LONG_MAX
#elif LONG_MAX  >= X_INT64_MAX
typedef long ix_int64;
#define SIZEOF_IX_INT64 SIZEOF_LONG
#define IX_INT64_MAX LONG_MAX
#else
#error "ix_int64 implementation"
#endif


static void
get_ix_int64(const void *xp, ix_int64 *ip)
{
    const uchar *cp = (const uchar *) xp;

    *ip  = (ix_int64)((uint64_t)(*cp++) << 56);
    *ip |= (ix_int64)((uint64_t)(*cp++) << 48);
    *ip |= (ix_int64)((uint64_t)(*cp++) << 40);
    *ip |= (ix_int64)((uint64_t)(*cp++) << 32);
    *ip |= (ix_int64)((uint64_t)(*cp++) << 24);
    *ip |= (ix_int64)((uint64_t)(*cp++) << 16);
    *ip |= (ix_int64)((uint64_t)(*cp++) <<  8);
    *ip |= (ix_int64)*cp;
}

static void
put_ix_int64(void *xp, const ix_int64 *ip)
{
    uchar *cp = (uchar *) xp;

    *cp++ = (uchar)((*ip) >> 56);
    *cp++ = (uchar)(((*ip) & 0x00ff000000000000LL) >> 48);
    *cp++ = (uchar)(((*ip) & 0x0000ff0000000000LL) >> 40);
    *cp++ = (uchar)(((*ip) & 0x000000ff00000000LL) >> 32);
    *cp++ = (uchar)(((*ip) & 0x00000000ff000000LL) >> 24);
    *cp++ = (uchar)(((*ip) & 0x0000000000ff0000LL) >> 16);
    *cp++ = (uchar)(((*ip) & 0x000000000000ff00LL) >>  8);
    *cp   = (uchar)( (*ip) & 0x00000000000000ffLL);
}

#if X_SIZEOF_INT64 != SIZEOF_LONGLONG
static int
#line 1900
ncx_get_longlong_longlong(const void *xp, longlong *ip)
#line 1900
{
#line 1900
    int err=NC_NOERR;
#line 1900
#if SIZEOF_IX_INT64 == SIZEOF_LONGLONG && IX_INT64_MAX == LONGLONG_MAX
#line 1900
    get_ix_int64(xp, (ix_int64 *)ip);
#line 1900
#else
#line 1900
    ix_int64 xx = 0;
#line 1900
    get_ix_int64(xp, &xx);
#line 1900

#line 1900
#if IX_INT64_MAX > LONGLONG_MAX
#line 1900
    if (xx > LONGLONG_MAX || xx < LONGLONG_MIN) {
#line 1900
#ifdef ERANGE_FILL
#line 1900
        *ip = NC_FILL_INT64;
#line 1900
        return NC_ERANGE;
#line 1900
#else
#line 1900
        err = NC_ERANGE;
#line 1900
#endif
#line 1900
    }
#line 1900
#endif
#line 1900

#line 1900

#line 1900
    *ip = (longlong) xx;
#line 1900
#endif
#line 1900
    return err;
#line 1900
}
#line 1900

#endif
static int
#line 1902
ncx_get_longlong_schar(const void *xp, schar *ip)
#line 1902
{
#line 1902
    int err=NC_NOERR;
#line 1902
    ix_int64 xx = 0;
#line 1902
    get_ix_int64(xp, &xx);
#line 1902

#line 1902
#if IX_INT64_MAX > SCHAR_MAX
#line 1902
    if (xx > SCHAR_MAX || xx < SCHAR_MIN) {
#line 1902
#ifdef ERANGE_FILL
#line 1902
        *ip = NC_FILL_BYTE;
#line 1902
        return NC_ERANGE;
#line 1902
#else
#line 1902
        err = NC_ERANGE;
#line 1902
#endif
#line 1902
    }
#line 1902
#endif
#line 1902

#line 1902

#line 1902
    *ip = (schar) xx;
#line 1902
    return err;
#line 1902
}
#line 1902

static int
#line 1903
ncx_get_longlong_short(const void *xp, short *ip)
#line 1903
{
#line 1903
    int err=NC_NOERR;
#line 1903
#if SIZEOF_IX_INT64 == SIZEOF_SHORT && IX_INT64_MAX == SHORT_MAX
#line 1903
    get_ix_int64(xp, (ix_int64 *)ip);
#line 1903
#else
#line 1903
    ix_int64 xx = 0;
#line 1903
    get_ix_int64(xp, &xx);
#line 1903

#line 1903
#if IX_INT64_MAX > SHORT_MAX
#line 1903
    if (xx > SHORT_MAX || xx < SHORT_MIN) {
#line 1903
#ifdef ERANGE_FILL
#line 1903
        *ip = NC_FILL_SHORT;
#line 1903
        return NC_ERANGE;
#line 1903
#else
#line 1903
        err = NC_ERANGE;
#line 1903
#endif
#line 1903
    }
#line 1903
#endif
#line 1903

#line 1903

#line 1903
    *ip = (short) xx;
#line 1903
#endif
#line 1903
    return err;
#line 1903
}
#line 1903

static int
#line 1904
ncx_get_longlong_int(const void *xp, int *ip)
#line 1904
{
#line 1904
    int err=NC_NOERR;
#line 1904
#if SIZEOF_IX_INT64 == SIZEOF_INT && IX_INT64_MAX == INT_MAX
#line 1904
    get_ix_int64(xp, (ix_int64 *)ip);
#line 1904
#else
#line 1904
    ix_int64 xx = 0;
#line 1904
    get_ix_int64(xp, &xx);
#line 1904

#line 1904
#if IX_INT64_MAX > INT_MAX
#line 1904
    if (xx > INT_MAX || xx < INT_MIN) {
#line 1904
#ifdef ERANGE_FILL
#line 1904
        *ip = NC_FILL_INT;
#line 1904
        return NC_ERANGE;
#line 1904
#else
#line 1904
        err = NC_ERANGE;
#line 1904
#endif
#line 1904
    }
#line 1904
#endif
#line 1904

#line 1904

#line 1904
    *ip = (int) xx;
#line 1904
#endif
#line 1904
    return err;
#line 1904
}
#line 1904

static int
#line 1905
ncx_get_longlong_long(const void *xp, long *ip)
#line 1905
{
#line 1905
    int err=NC_NOERR;
#line 1905
#if SIZEOF_IX_INT64 == SIZEOF_LONG && IX_INT64_MAX == LONG_MAX
#line 1905
    get_ix_int64(xp, (ix_int64 *)ip);
#line 1905
#else
#line 1905
    ix_int64 xx = 0;
#line 1905
    get_ix_int64(xp, &xx);
#line 1905

#line 1905
#if IX_INT64_MAX > LONG_MAX
#line 1905
    if (xx > LONG_MAX || xx < LONG_MIN) {
#line 1905
#ifdef ERANGE_FILL
#line 1905
        *ip = NC_FILL_INT;
#line 1905
        return NC_ERANGE;
#line 1905
#else
#line 1905
        err = NC_ERANGE;
#line 1905
#endif
#line 1905
    }
#line 1905
#endif
#line 1905

#line 1905

#line 1905
    *ip = (long) xx;
#line 1905
#endif
#line 1905
    return err;
#line 1905
}
#line 1905

static int
#line 1906
ncx_get_longlong_ushort(const void *xp, ushort *ip)
#line 1906
{
#line 1906
    int err=NC_NOERR;
#line 1906
    ix_int64 xx = 0;
#line 1906
    get_ix_int64(xp, &xx);
#line 1906

#line 1906
#if IX_INT64_MAX > USHORT_MAX
#line 1906
    if (xx > USHORT_MAX) {
#line 1906
#ifdef ERANGE_FILL
#line 1906
        *ip = NC_FILL_USHORT;
#line 1906
        return NC_ERANGE;
#line 1906
#else
#line 1906
        err = NC_ERANGE;
#line 1906
#endif
#line 1906
    }
#line 1906
#endif
#line 1906

#line 1906
    if (xx < 0) {
#line 1906
#ifdef ERANGE_FILL
#line 1906
        *ip = NC_FILL_USHORT;
#line 1906
        return NC_ERANGE;
#line 1906
#else
#line 1906
        err = NC_ERANGE; /* because ip is unsigned */
#line 1906
#endif
#line 1906
    }
#line 1906
    *ip = (ushort) xx;
#line 1906
    return err;
#line 1906
}
#line 1906

static int
#line 1907
ncx_get_longlong_uchar(const void *xp, uchar *ip)
#line 1907
{
#line 1907
    int err=NC_NOERR;
#line 1907
    ix_int64 xx = 0;
#line 1907
    get_ix_int64(xp, &xx);
#line 1907

#line 1907
#if IX_INT64_MAX > UCHAR_MAX
#line 1907
    if (xx > UCHAR_MAX) {
#line 1907
#ifdef ERANGE_FILL
#line 1907
        *ip = NC_FILL_UBYTE;
#line 1907
        return NC_ERANGE;
#line 1907
#else
#line 1907
        err = NC_ERANGE;
#line 1907
#endif
#line 1907
    }
#line 1907
#endif
#line 1907

#line 1907
    if (xx < 0) {
#line 1907
#ifdef ERANGE_FILL
#line 1907
        *ip = NC_FILL_UBYTE;
#line 1907
        return NC_ERANGE;
#line 1907
#else
#line 1907
        err = NC_ERANGE; /* because ip is unsigned */
#line 1907
#endif
#line 1907
    }
#line 1907
    *ip = (uchar) xx;
#line 1907
    return err;
#line 1907
}
#line 1907

static int
#line 1908
ncx_get_longlong_uint(const void *xp, uint *ip)
#line 1908
{
#line 1908
    int err=NC_NOERR;
#line 1908
    ix_int64 xx = 0;
#line 1908
    get_ix_int64(xp, &xx);
#line 1908

#line 1908
#if IX_INT64_MAX > UINT_MAX
#line 1908
    if (xx > UINT_MAX) {
#line 1908
#ifdef ERANGE_FILL
#line 1908
        *ip = NC_FILL_UINT;
#line 1908
        return NC_ERANGE;
#line 1908
#else
#line 1908
        err = NC_ERANGE;
#line 1908
#endif
#line 1908
    }
#line 1908
#endif
#line 1908

#line 1908
    if (xx < 0) {
#line 1908
#ifdef ERANGE_FILL
#line 1908
        *ip = NC_FILL_UINT;
#line 1908
        return NC_ERANGE;
#line 1908
#else
#line 1908
        err = NC_ERANGE; /* because ip is unsigned */
#line 1908
#endif
#line 1908
    }
#line 1908
    *ip = (uint) xx;
#line 1908
    return err;
#line 1908
}
#line 1908

static int
#line 1909
ncx_get_longlong_ulonglong(const void *xp, ulonglong *ip)
#line 1909
{
#line 1909
    int err=NC_NOERR;
#line 1909
    ix_int64 xx = 0;
#line 1909
    get_ix_int64(xp, &xx);
#line 1909

#line 1909
#if IX_INT64_MAX > ULONGLONG_MAX
#line 1909
    if (xx > ULONGLONG_MAX) {
#line 1909
#ifdef ERANGE_FILL
#line 1909
        *ip = NC_FILL_UINT64;
#line 1909
        return NC_ERANGE;
#line 1909
#else
#line 1909
        err = NC_ERANGE;
#line 1909
#endif
#line 1909
    }
#line 1909
#endif
#line 1909

#line 1909
    if (xx < 0) {
#line 1909
#ifdef ERANGE_FILL
#line 1909
        *ip = NC_FILL_UINT64;
#line 1909
        return NC_ERANGE;
#line 1909
#else
#line 1909
        err = NC_ERANGE; /* because ip is unsigned */
#line 1909
#endif
#line 1909
    }
#line 1909
    *ip = (ulonglong) xx;
#line 1909
    return err;
#line 1909
}
#line 1909

static int
#line 1910
ncx_get_longlong_float(const void *xp, float *ip)
#line 1910
{
#line 1910
	ix_int64 xx = 0;
#line 1910
	get_ix_int64(xp, &xx);
#line 1910
	*ip = (float)xx;
#line 1910
	return NC_NOERR;
#line 1910
}
#line 1910

static int
#line 1911
ncx_get_longlong_double(const void *xp, double *ip)
#line 1911
{
#line 1911
	ix_int64 xx = 0;
#line 1911
	get_ix_int64(xp, &xx);
#line 1911
	*ip = (double)xx;
#line 1911
	return NC_NOERR;
#line 1911
}
#line 1911


#if X_SIZEOF_INT64 != SIZEOF_LONGLONG
static int
#line 1914
ncx_put_longlong_longlong(void *xp, const longlong *ip, void *fillp)
#line 1914
{
#line 1914
    int err=NC_NOERR;
#line 1914
#if SIZEOF_IX_INT64 == SIZEOF_LONGLONG && IX_INT64_MAX == LONGLONG_MAX
#line 1914
    put_ix_int64(xp, (const ix_int64 *)ip);
#line 1914
#else
#line 1914
    ix_int64 xx = NC_FILL_INT64;
#line 1914

#line 1914
#if IX_INT64_MAX < LONGLONG_MAX
#line 1914
    if (*ip > IX_INT64_MAX || *ip < X_INT64_MIN) {
#line 1914
        
#line 1914
#ifdef ERANGE_FILL
#line 1914
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1914
#endif
#line 1914
        err = NC_ERANGE;
#line 1914
    }
#line 1914
#ifdef ERANGE_FILL
#line 1914
    else
#line 1914
#endif
#line 1914
#endif
#line 1914
        xx = (ix_int64)*ip;
#line 1914

#line 1914
    put_ix_int64(xp, &xx);
#line 1914
#endif
#line 1914
    return err;
#line 1914
}
#line 1914

#endif
static int
#line 1916
ncx_put_longlong_schar(void *xp, const schar *ip, void *fillp)
#line 1916
{
#line 1916
    int err=NC_NOERR;
#line 1916
    ix_int64 xx = NC_FILL_INT64;
#line 1916

#line 1916
#if IX_INT64_MAX < SCHAR_MAX
#line 1916
    if (*ip > IX_INT64_MAX || *ip < X_INT64_MIN) {
#line 1916
        
#line 1916
#ifdef ERANGE_FILL
#line 1916
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1916
#endif
#line 1916
        err = NC_ERANGE;
#line 1916
    }
#line 1916
#ifdef ERANGE_FILL
#line 1916
    else
#line 1916
#endif
#line 1916
#endif
#line 1916
        xx = (ix_int64)*ip;
#line 1916

#line 1916
    put_ix_int64(xp, &xx);
#line 1916
    return err;
#line 1916
}
#line 1916

static int
#line 1917
ncx_put_longlong_short(void *xp, const short *ip, void *fillp)
#line 1917
{
#line 1917
    int err=NC_NOERR;
#line 1917
#if SIZEOF_IX_INT64 == SIZEOF_SHORT && IX_INT64_MAX == SHORT_MAX
#line 1917
    put_ix_int64(xp, (const ix_int64 *)ip);
#line 1917
#else
#line 1917
    ix_int64 xx = NC_FILL_INT64;
#line 1917

#line 1917
#if IX_INT64_MAX < SHORT_MAX
#line 1917
    if (*ip > IX_INT64_MAX || *ip < X_INT64_MIN) {
#line 1917
        
#line 1917
#ifdef ERANGE_FILL
#line 1917
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1917
#endif
#line 1917
        err = NC_ERANGE;
#line 1917
    }
#line 1917
#ifdef ERANGE_FILL
#line 1917
    else
#line 1917
#endif
#line 1917
#endif
#line 1917
        xx = (ix_int64)*ip;
#line 1917

#line 1917
    put_ix_int64(xp, &xx);
#line 1917
#endif
#line 1917
    return err;
#line 1917
}
#line 1917

static int
#line 1918
ncx_put_longlong_int(void *xp, const int *ip, void *fillp)
#line 1918
{
#line 1918
    int err=NC_NOERR;
#line 1918
#if SIZEOF_IX_INT64 == SIZEOF_INT && IX_INT64_MAX == INT_MAX
#line 1918
    put_ix_int64(xp, (const ix_int64 *)ip);
#line 1918
#else
#line 1918
    ix_int64 xx = NC_FILL_INT64;
#line 1918

#line 1918
#if IX_INT64_MAX < INT_MAX
#line 1918
    if (*ip > IX_INT64_MAX || *ip < X_INT64_MIN) {
#line 1918
        
#line 1918
#ifdef ERANGE_FILL
#line 1918
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1918
#endif
#line 1918
        err = NC_ERANGE;
#line 1918
    }
#line 1918
#ifdef ERANGE_FILL
#line 1918
    else
#line 1918
#endif
#line 1918
#endif
#line 1918
        xx = (ix_int64)*ip;
#line 1918

#line 1918
    put_ix_int64(xp, &xx);
#line 1918
#endif
#line 1918
    return err;
#line 1918
}
#line 1918

static int
#line 1919
ncx_put_longlong_long(void *xp, const long *ip, void *fillp)
#line 1919
{
#line 1919
    int err=NC_NOERR;
#line 1919
#if SIZEOF_IX_INT64 == SIZEOF_LONG && IX_INT64_MAX == LONG_MAX
#line 1919
    put_ix_int64(xp, (const ix_int64 *)ip);
#line 1919
#else
#line 1919
    ix_int64 xx = NC_FILL_INT64;
#line 1919

#line 1919
#if IX_INT64_MAX < LONG_MAX
#line 1919
    if (*ip > IX_INT64_MAX || *ip < X_INT64_MIN) {
#line 1919
        
#line 1919
#ifdef ERANGE_FILL
#line 1919
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1919
#endif
#line 1919
        err = NC_ERANGE;
#line 1919
    }
#line 1919
#ifdef ERANGE_FILL
#line 1919
    else
#line 1919
#endif
#line 1919
#endif
#line 1919
        xx = (ix_int64)*ip;
#line 1919

#line 1919
    put_ix_int64(xp, &xx);
#line 1919
#endif
#line 1919
    return err;
#line 1919
}
#line 1919

static int
#line 1920
ncx_put_longlong_ushort(void *xp, const ushort *ip, void *fillp)
#line 1920
{
#line 1920
    int err=NC_NOERR;
#line 1920
    ix_int64 xx = NC_FILL_INT64;
#line 1920

#line 1920
#if IX_INT64_MAX < USHORT_MAX
#line 1920
    if (*ip > IX_INT64_MAX) {
#line 1920
        
#line 1920
#ifdef ERANGE_FILL
#line 1920
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1920
#endif
#line 1920
        err = NC_ERANGE;
#line 1920
    }
#line 1920
#ifdef ERANGE_FILL
#line 1920
    else
#line 1920
#endif
#line 1920
#endif
#line 1920
        xx = (ix_int64)*ip;
#line 1920

#line 1920
    put_ix_int64(xp, &xx);
#line 1920
    return err;
#line 1920
}
#line 1920

static int
#line 1921
ncx_put_longlong_uchar(void *xp, const uchar *ip, void *fillp)
#line 1921
{
#line 1921
    int err=NC_NOERR;
#line 1921
    ix_int64 xx = NC_FILL_INT64;
#line 1921

#line 1921
#if IX_INT64_MAX < UCHAR_MAX
#line 1921
    if (*ip > IX_INT64_MAX) {
#line 1921
        
#line 1921
#ifdef ERANGE_FILL
#line 1921
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1921
#endif
#line 1921
        err = NC_ERANGE;
#line 1921
    }
#line 1921
#ifdef ERANGE_FILL
#line 1921
    else
#line 1921
#endif
#line 1921
#endif
#line 1921
        xx = (ix_int64)*ip;
#line 1921

#line 1921
    put_ix_int64(xp, &xx);
#line 1921
    return err;
#line 1921
}
#line 1921

static int
#line 1922
ncx_put_longlong_uint(void *xp, const uint *ip, void *fillp)
#line 1922
{
#line 1922
    int err=NC_NOERR;
#line 1922
    ix_int64 xx = NC_FILL_INT64;
#line 1922

#line 1922
#if IX_INT64_MAX < UINT_MAX
#line 1922
    if (*ip > IX_INT64_MAX) {
#line 1922
        
#line 1922
#ifdef ERANGE_FILL
#line 1922
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1922
#endif
#line 1922
        err = NC_ERANGE;
#line 1922
    }
#line 1922
#ifdef ERANGE_FILL
#line 1922
    else
#line 1922
#endif
#line 1922
#endif
#line 1922
        xx = (ix_int64)*ip;
#line 1922

#line 1922
    put_ix_int64(xp, &xx);
#line 1922
    return err;
#line 1922
}
#line 1922

static int
#line 1923
ncx_put_longlong_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 1923
{
#line 1923
    int err=NC_NOERR;
#line 1923
    ix_int64 xx = NC_FILL_INT64;
#line 1923

#line 1923
#if IX_INT64_MAX < ULONGLONG_MAX
#line 1923
    if (*ip > IX_INT64_MAX) {
#line 1923
        
#line 1923
#ifdef ERANGE_FILL
#line 1923
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1923
#endif
#line 1923
        err = NC_ERANGE;
#line 1923
    }
#line 1923
#ifdef ERANGE_FILL
#line 1923
    else
#line 1923
#endif
#line 1923
#endif
#line 1923
        xx = (ix_int64)*ip;
#line 1923

#line 1923
    put_ix_int64(xp, &xx);
#line 1923
    return err;
#line 1923
}
#line 1923

static int
#line 1924
ncx_put_longlong_float(void *xp, const float *ip, void *fillp)
#line 1924
{
#line 1924
    int err=NC_NOERR;
#line 1924
    ix_int64 xx = NC_FILL_INT64;
#line 1924

#line 1924
    if (*ip > (double)X_INT64_MAX || *ip < (double)X_INT64_MIN) {
#line 1924
        
#line 1924
#ifdef ERANGE_FILL
#line 1924
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1924
#endif
#line 1924
        err = NC_ERANGE;
#line 1924
    }
#line 1924
#ifdef ERANGE_FILL
#line 1924
    else
#line 1924
#endif
#line 1924
        xx = (ix_int64)*ip;
#line 1924

#line 1924
    put_ix_int64(xp, &xx);
#line 1924
    return err;
#line 1924
}
#line 1924

static int
#line 1925
ncx_put_longlong_double(void *xp, const double *ip, void *fillp)
#line 1925
{
#line 1925
    int err=NC_NOERR;
#line 1925
    ix_int64 xx = NC_FILL_INT64;
#line 1925

#line 1925
    if (*ip > X_INT64_MAX || *ip < X_INT64_MIN) {
#line 1925
        
#line 1925
#ifdef ERANGE_FILL
#line 1925
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1925
#endif
#line 1925
        err = NC_ERANGE;
#line 1925
    }
#line 1925
#ifdef ERANGE_FILL
#line 1925
    else
#line 1925
#endif
#line 1925
        xx = (ix_int64)*ip;
#line 1925

#line 1925
    put_ix_int64(xp, &xx);
#line 1925
    return err;
#line 1925
}
#line 1925



/* external NC_UINT64 -------------------------------------------------------*/

#if USHORT_MAX == X_UINT64_MAX
typedef ushort ix_uint64;
#define SIZEOF_IX_UINT64 SIZEOF_USHORT
#define IX_UINT64_MAX USHORT_MAX
#elif ULONG_LONG_MAX  >= X_UINT64_MAX
typedef ulonglong ix_uint64;
#define SIZEOF_IX_UINT64 SIZEOF_ULONGLONG
#define IX_UINT64_MAX ULONG_LONG_MAX
#elif ULONG_MAX  >= X_UINT64_MAX
typedef ulong ix_uint64;
#define SIZEOF_IX_UINT64 SIZEOF_ULONG
#define IX_UINT64_MAX ULONG_MAX
#else
#error "ix_uint64 implementation"
#endif


static void
get_ix_uint64(const void *xp, ix_uint64 *ip)
{
    const uchar *cp = (const uchar *) xp;

    *ip  = ((ix_uint64)(*cp++) << 56);
    *ip |= ((ix_uint64)(*cp++) << 48);
    *ip |= ((ix_uint64)(*cp++) << 40);
    *ip |= ((ix_uint64)(*cp++) << 32);
    *ip |= ((ix_uint64)(*cp++) << 24);
    *ip |= ((ix_uint64)(*cp++) << 16);
    *ip |= ((ix_uint64)(*cp++) <<  8);
    *ip |=  (ix_uint64)*cp;
}

static void
put_ix_uint64(void *xp, const ix_uint64 *ip)
{
    uchar *cp = (uchar *) xp;

    *cp++ = (uchar)((*ip) >> 56);
    *cp++ = (uchar)(((*ip) & 0x00ff000000000000ULL) >> 48);
    *cp++ = (uchar)(((*ip) & 0x0000ff0000000000ULL) >> 40);
    *cp++ = (uchar)(((*ip) & 0x000000ff00000000ULL) >> 32);
    *cp++ = (uchar)(((*ip) & 0x00000000ff000000ULL) >> 24);
    *cp++ = (uchar)(((*ip) & 0x0000000000ff0000ULL) >> 16);
    *cp++ = (uchar)(((*ip) & 0x000000000000ff00ULL) >>  8);
    *cp   = (uchar)( (*ip) & 0x00000000000000ffULL);
}

#if X_SIZEOF_UINT64 != SIZEOF_ULONGLONG
static int
#line 1978
ncx_get_ulonglong_ulonglong(const void *xp, ulonglong *ip)
#line 1978
{
#line 1978
    int err=NC_NOERR;
#line 1978
#if SIZEOF_IX_UINT64 == SIZEOF_ULONGLONG && IX_UINT64_MAX == ULONGLONG_MAX
#line 1978
    get_ix_uint64(xp, (ix_uint64 *)ip);
#line 1978
#else
#line 1978
    ix_uint64 xx = 0;
#line 1978
    get_ix_uint64(xp, &xx);
#line 1978

#line 1978
#if IX_UINT64_MAX > ULONGLONG_MAX
#line 1978
    if (xx > ULONGLONG_MAX) {
#line 1978
#ifdef ERANGE_FILL
#line 1978
        *ip = NC_FILL_UINT64;
#line 1978
        return NC_ERANGE;
#line 1978
#else
#line 1978
        err = NC_ERANGE;
#line 1978
#endif
#line 1978
    }
#line 1978
#endif
#line 1978

#line 1978

#line 1978
    *ip = (ulonglong) xx;
#line 1978
#endif
#line 1978
    return err;
#line 1978
}
#line 1978

#endif
static int
#line 1980
ncx_get_ulonglong_schar(const void *xp, schar *ip)
#line 1980
{
#line 1980
    int err=NC_NOERR;
#line 1980
    ix_uint64 xx = 0;
#line 1980
    get_ix_uint64(xp, &xx);
#line 1980

#line 1980
#if IX_UINT64_MAX > SCHAR_MAX
#line 1980
    if (xx > SCHAR_MAX) {
#line 1980
#ifdef ERANGE_FILL
#line 1980
        *ip = NC_FILL_BYTE;
#line 1980
        return NC_ERANGE;
#line 1980
#else
#line 1980
        err = NC_ERANGE;
#line 1980
#endif
#line 1980
    }
#line 1980
#endif
#line 1980

#line 1980

#line 1980
    *ip = (schar) xx;
#line 1980
    return err;
#line 1980
}
#line 1980

static int
#line 1981
ncx_get_ulonglong_short(const void *xp, short *ip)
#line 1981
{
#line 1981
    int err=NC_NOERR;
#line 1981
    ix_uint64 xx = 0;
#line 1981
    get_ix_uint64(xp, &xx);
#line 1981

#line 1981
#if IX_UINT64_MAX > SHORT_MAX
#line 1981
    if (xx > SHORT_MAX) {
#line 1981
#ifdef ERANGE_FILL
#line 1981
        *ip = NC_FILL_SHORT;
#line 1981
        return NC_ERANGE;
#line 1981
#else
#line 1981
        err = NC_ERANGE;
#line 1981
#endif
#line 1981
    }
#line 1981
#endif
#line 1981

#line 1981

#line 1981
    *ip = (short) xx;
#line 1981
    return err;
#line 1981
}
#line 1981

static int
#line 1982
ncx_get_ulonglong_int(const void *xp, int *ip)
#line 1982
{
#line 1982
    int err=NC_NOERR;
#line 1982
    ix_uint64 xx = 0;
#line 1982
    get_ix_uint64(xp, &xx);
#line 1982

#line 1982
#if IX_UINT64_MAX > INT_MAX
#line 1982
    if (xx > INT_MAX) {
#line 1982
#ifdef ERANGE_FILL
#line 1982
        *ip = NC_FILL_INT;
#line 1982
        return NC_ERANGE;
#line 1982
#else
#line 1982
        err = NC_ERANGE;
#line 1982
#endif
#line 1982
    }
#line 1982
#endif
#line 1982

#line 1982

#line 1982
    *ip = (int) xx;
#line 1982
    return err;
#line 1982
}
#line 1982

static int
#line 1983
ncx_get_ulonglong_long(const void *xp, long *ip)
#line 1983
{
#line 1983
    int err=NC_NOERR;
#line 1983
    ix_uint64 xx = 0;
#line 1983
    get_ix_uint64(xp, &xx);
#line 1983

#line 1983
#if IX_UINT64_MAX > LONG_MAX
#line 1983
    if (xx > LONG_MAX) {
#line 1983
#ifdef ERANGE_FILL
#line 1983
        *ip = NC_FILL_INT;
#line 1983
        return NC_ERANGE;
#line 1983
#else
#line 1983
        err = NC_ERANGE;
#line 1983
#endif
#line 1983
    }
#line 1983
#endif
#line 1983

#line 1983

#line 1983
    *ip = (long) xx;
#line 1983
    return err;
#line 1983
}
#line 1983

static int
#line 1984
ncx_get_ulonglong_longlong(const void *xp, longlong *ip)
#line 1984
{
#line 1984
    int err=NC_NOERR;
#line 1984
    ix_uint64 xx = 0;
#line 1984
    get_ix_uint64(xp, &xx);
#line 1984

#line 1984
#if IX_UINT64_MAX > LONGLONG_MAX
#line 1984
    if (xx > LONGLONG_MAX) {
#line 1984
#ifdef ERANGE_FILL
#line 1984
        *ip = NC_FILL_INT64;
#line 1984
        return NC_ERANGE;
#line 1984
#else
#line 1984
        err = NC_ERANGE;
#line 1984
#endif
#line 1984
    }
#line 1984
#endif
#line 1984

#line 1984

#line 1984
    *ip = (longlong) xx;
#line 1984
    return err;
#line 1984
}
#line 1984

static int
#line 1985
ncx_get_ulonglong_ushort(const void *xp, ushort *ip)
#line 1985
{
#line 1985
    int err=NC_NOERR;
#line 1985
#if SIZEOF_IX_UINT64 == SIZEOF_USHORT && IX_UINT64_MAX == USHORT_MAX
#line 1985
    get_ix_uint64(xp, (ix_uint64 *)ip);
#line 1985
#else
#line 1985
    ix_uint64 xx = 0;
#line 1985
    get_ix_uint64(xp, &xx);
#line 1985

#line 1985
#if IX_UINT64_MAX > USHORT_MAX
#line 1985
    if (xx > USHORT_MAX) {
#line 1985
#ifdef ERANGE_FILL
#line 1985
        *ip = NC_FILL_USHORT;
#line 1985
        return NC_ERANGE;
#line 1985
#else
#line 1985
        err = NC_ERANGE;
#line 1985
#endif
#line 1985
    }
#line 1985
#endif
#line 1985

#line 1985

#line 1985
    *ip = (ushort) xx;
#line 1985
#endif
#line 1985
    return err;
#line 1985
}
#line 1985

static int
#line 1986
ncx_get_ulonglong_uchar(const void *xp, uchar *ip)
#line 1986
{
#line 1986
    int err=NC_NOERR;
#line 1986
#if SIZEOF_IX_UINT64 == SIZEOF_UCHAR && IX_UINT64_MAX == UCHAR_MAX
#line 1986
    get_ix_uint64(xp, (ix_uint64 *)ip);
#line 1986
#else
#line 1986
    ix_uint64 xx = 0;
#line 1986
    get_ix_uint64(xp, &xx);
#line 1986

#line 1986
#if IX_UINT64_MAX > UCHAR_MAX
#line 1986
    if (xx > UCHAR_MAX) {
#line 1986
#ifdef ERANGE_FILL
#line 1986
        *ip = NC_FILL_UBYTE;
#line 1986
        return NC_ERANGE;
#line 1986
#else
#line 1986
        err = NC_ERANGE;
#line 1986
#endif
#line 1986
    }
#line 1986
#endif
#line 1986

#line 1986

#line 1986
    *ip = (uchar) xx;
#line 1986
#endif
#line 1986
    return err;
#line 1986
}
#line 1986

static int
#line 1987
ncx_get_ulonglong_uint(const void *xp, uint *ip)
#line 1987
{
#line 1987
    int err=NC_NOERR;
#line 1987
#if SIZEOF_IX_UINT64 == SIZEOF_UINT && IX_UINT64_MAX == UINT_MAX
#line 1987
    get_ix_uint64(xp, (ix_uint64 *)ip);
#line 1987
#else
#line 1987
    ix_uint64 xx = 0;
#line 1987
    get_ix_uint64(xp, &xx);
#line 1987

#line 1987
#if IX_UINT64_MAX > UINT_MAX
#line 1987
    if (xx > UINT_MAX) {
#line 1987
#ifdef ERANGE_FILL
#line 1987
        *ip = NC_FILL_UINT;
#line 1987
        return NC_ERANGE;
#line 1987
#else
#line 1987
        err = NC_ERANGE;
#line 1987
#endif
#line 1987
    }
#line 1987
#endif
#line 1987

#line 1987

#line 1987
    *ip = (uint) xx;
#line 1987
#endif
#line 1987
    return err;
#line 1987
}
#line 1987

static int
#line 1988
ncx_get_ulonglong_float(const void *xp, float *ip)
#line 1988
{
#line 1988
	ix_uint64 xx = 0;
#line 1988
	get_ix_uint64(xp, &xx);
#line 1988
	*ip = (float)xx;
#line 1988
	return NC_NOERR;
#line 1988
}
#line 1988

static int
#line 1989
ncx_get_ulonglong_double(const void *xp, double *ip)
#line 1989
{
#line 1989
	ix_uint64 xx = 0;
#line 1989
	get_ix_uint64(xp, &xx);
#line 1989
	*ip = (double)xx;
#line 1989
	return NC_NOERR;
#line 1989
}
#line 1989


#if X_SIZEOF_UINT64 != SIZEOF_ULONGLONG
static int
#line 1992
ncx_put_ulonglong_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 1992
{
#line 1992
    int err=NC_NOERR;
#line 1992
#if SIZEOF_IX_UINT64 == SIZEOF_ULONGLONG && IX_UINT64_MAX == ULONGLONG_MAX
#line 1992
    put_ix_uint64(xp, (const ix_uint64 *)ip);
#line 1992
#else
#line 1992
    ix_uint64 xx = NC_FILL_UINT64;
#line 1992

#line 1992
#if IX_UINT64_MAX < ULONGLONG_MAX
#line 1992
    if (*ip > IX_UINT64_MAX) {
#line 1992
        
#line 1992
#ifdef ERANGE_FILL
#line 1992
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1992
#endif
#line 1992
        err = NC_ERANGE;
#line 1992
    }
#line 1992
#ifdef ERANGE_FILL
#line 1992
    else
#line 1992
#endif
#line 1992
#endif
#line 1992
        xx = (ix_uint64)*ip;
#line 1992

#line 1992
    put_ix_uint64(xp, &xx);
#line 1992
#endif
#line 1992
    return err;
#line 1992
}
#line 1992

#endif
static int
#line 1994
ncx_put_ulonglong_schar(void *xp, const schar *ip, void *fillp)
#line 1994
{
#line 1994
    int err=NC_NOERR;
#line 1994
    ix_uint64 xx = NC_FILL_UINT64;
#line 1994

#line 1994
#if IX_UINT64_MAX < SCHAR_MAX
#line 1994
    if (*ip > IX_UINT64_MAX) {
#line 1994
        
#line 1994
#ifdef ERANGE_FILL
#line 1994
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1994
#endif
#line 1994
        err = NC_ERANGE;
#line 1994
    }
#line 1994
#ifdef ERANGE_FILL
#line 1994
    else
#line 1994
#endif
#line 1994
#endif
#line 1994
    if (*ip < 0) {
#line 1994
        
#line 1994
#ifdef ERANGE_FILL
#line 1994
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1994
#endif
#line 1994
        err = NC_ERANGE; /* because xp is unsigned */
#line 1994
    }
#line 1994
#ifdef ERANGE_FILL
#line 1994
    else
#line 1994
#endif
#line 1994
        xx = (ix_uint64)*ip;
#line 1994

#line 1994
    put_ix_uint64(xp, &xx);
#line 1994
    return err;
#line 1994
}
#line 1994

static int
#line 1995
ncx_put_ulonglong_short(void *xp, const short *ip, void *fillp)
#line 1995
{
#line 1995
    int err=NC_NOERR;
#line 1995
    ix_uint64 xx = NC_FILL_UINT64;
#line 1995

#line 1995
#if IX_UINT64_MAX < SHORT_MAX
#line 1995
    if (*ip > IX_UINT64_MAX) {
#line 1995
        
#line 1995
#ifdef ERANGE_FILL
#line 1995
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1995
#endif
#line 1995
        err = NC_ERANGE;
#line 1995
    }
#line 1995
#ifdef ERANGE_FILL
#line 1995
    else
#line 1995
#endif
#line 1995
#endif
#line 1995
    if (*ip < 0) {
#line 1995
        
#line 1995
#ifdef ERANGE_FILL
#line 1995
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1995
#endif
#line 1995
        err = NC_ERANGE; /* because xp is unsigned */
#line 1995
    }
#line 1995
#ifdef ERANGE_FILL
#line 1995
    else
#line 1995
#endif
#line 1995
        xx = (ix_uint64)*ip;
#line 1995

#line 1995
    put_ix_uint64(xp, &xx);
#line 1995
    return err;
#line 1995
}
#line 1995

static int
#line 1996
ncx_put_ulonglong_int(void *xp, const int *ip, void *fillp)
#line 1996
{
#line 1996
    int err=NC_NOERR;
#line 1996
    ix_uint64 xx = NC_FILL_UINT64;
#line 1996

#line 1996
#if IX_UINT64_MAX < INT_MAX
#line 1996
    if (*ip > IX_UINT64_MAX) {
#line 1996
        
#line 1996
#ifdef ERANGE_FILL
#line 1996
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1996
#endif
#line 1996
        err = NC_ERANGE;
#line 1996
    }
#line 1996
#ifdef ERANGE_FILL
#line 1996
    else
#line 1996
#endif
#line 1996
#endif
#line 1996
    if (*ip < 0) {
#line 1996
        
#line 1996
#ifdef ERANGE_FILL
#line 1996
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1996
#endif
#line 1996
        err = NC_ERANGE; /* because xp is unsigned */
#line 1996
    }
#line 1996
#ifdef ERANGE_FILL
#line 1996
    else
#line 1996
#endif
#line 1996
        xx = (ix_uint64)*ip;
#line 1996

#line 1996
    put_ix_uint64(xp, &xx);
#line 1996
    return err;
#line 1996
}
#line 1996

static int
#line 1997
ncx_put_ulonglong_long(void *xp, const long *ip, void *fillp)
#line 1997
{
#line 1997
    int err=NC_NOERR;
#line 1997
    ix_uint64 xx = NC_FILL_UINT64;
#line 1997

#line 1997
#if IX_UINT64_MAX < LONG_MAX
#line 1997
    if (*ip > IX_UINT64_MAX) {
#line 1997
        
#line 1997
#ifdef ERANGE_FILL
#line 1997
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1997
#endif
#line 1997
        err = NC_ERANGE;
#line 1997
    }
#line 1997
#ifdef ERANGE_FILL
#line 1997
    else
#line 1997
#endif
#line 1997
#endif
#line 1997
    if (*ip < 0) {
#line 1997
        
#line 1997
#ifdef ERANGE_FILL
#line 1997
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1997
#endif
#line 1997
        err = NC_ERANGE; /* because xp is unsigned */
#line 1997
    }
#line 1997
#ifdef ERANGE_FILL
#line 1997
    else
#line 1997
#endif
#line 1997
        xx = (ix_uint64)*ip;
#line 1997

#line 1997
    put_ix_uint64(xp, &xx);
#line 1997
    return err;
#line 1997
}
#line 1997

static int
#line 1998
ncx_put_ulonglong_longlong(void *xp, const longlong *ip, void *fillp)
#line 1998
{
#line 1998
    int err=NC_NOERR;
#line 1998
    ix_uint64 xx = NC_FILL_UINT64;
#line 1998

#line 1998
#if IX_UINT64_MAX < LONGLONG_MAX
#line 1998
    if (*ip > IX_UINT64_MAX) {
#line 1998
        
#line 1998
#ifdef ERANGE_FILL
#line 1998
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1998
#endif
#line 1998
        err = NC_ERANGE;
#line 1998
    }
#line 1998
#ifdef ERANGE_FILL
#line 1998
    else
#line 1998
#endif
#line 1998
#endif
#line 1998
    if (*ip < 0) {
#line 1998
        
#line 1998
#ifdef ERANGE_FILL
#line 1998
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1998
#endif
#line 1998
        err = NC_ERANGE; /* because xp is unsigned */
#line 1998
    }
#line 1998
#ifdef ERANGE_FILL
#line 1998
    else
#line 1998
#endif
#line 1998
        xx = (ix_uint64)*ip;
#line 1998

#line 1998
    put_ix_uint64(xp, &xx);
#line 1998
    return err;
#line 1998
}
#line 1998

static int
#line 1999
ncx_put_ulonglong_uchar(void *xp, const uchar *ip, void *fillp)
#line 1999
{
#line 1999
    int err=NC_NOERR;
#line 1999
#if SIZEOF_IX_UINT64 == SIZEOF_UCHAR && IX_UINT64_MAX == UCHAR_MAX
#line 1999
    put_ix_uint64(xp, (const ix_uint64 *)ip);
#line 1999
#else
#line 1999
    ix_uint64 xx = NC_FILL_UINT64;
#line 1999

#line 1999
#if IX_UINT64_MAX < UCHAR_MAX
#line 1999
    if (*ip > IX_UINT64_MAX) {
#line 1999
        
#line 1999
#ifdef ERANGE_FILL
#line 1999
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 1999
#endif
#line 1999
        err = NC_ERANGE;
#line 1999
    }
#line 1999
#ifdef ERANGE_FILL
#line 1999
    else
#line 1999
#endif
#line 1999
#endif
#line 1999
        xx = (ix_uint64)*ip;
#line 1999

#line 1999
    put_ix_uint64(xp, &xx);
#line 1999
#endif
#line 1999
    return err;
#line 1999
}
#line 1999

static int
#line 2000
ncx_put_ulonglong_ushort(void *xp, const ushort *ip, void *fillp)
#line 2000
{
#line 2000
    int err=NC_NOERR;
#line 2000
#if SIZEOF_IX_UINT64 == SIZEOF_USHORT && IX_UINT64_MAX == USHORT_MAX
#line 2000
    put_ix_uint64(xp, (const ix_uint64 *)ip);
#line 2000
#else
#line 2000
    ix_uint64 xx = NC_FILL_UINT64;
#line 2000

#line 2000
#if IX_UINT64_MAX < USHORT_MAX
#line 2000
    if (*ip > IX_UINT64_MAX) {
#line 2000
        
#line 2000
#ifdef ERANGE_FILL
#line 2000
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2000
#endif
#line 2000
        err = NC_ERANGE;
#line 2000
    }
#line 2000
#ifdef ERANGE_FILL
#line 2000
    else
#line 2000
#endif
#line 2000
#endif
#line 2000
        xx = (ix_uint64)*ip;
#line 2000

#line 2000
    put_ix_uint64(xp, &xx);
#line 2000
#endif
#line 2000
    return err;
#line 2000
}
#line 2000

static int
#line 2001
ncx_put_ulonglong_uint(void *xp, const uint *ip, void *fillp)
#line 2001
{
#line 2001
    int err=NC_NOERR;
#line 2001
#if SIZEOF_IX_UINT64 == SIZEOF_UINT && IX_UINT64_MAX == UINT_MAX
#line 2001
    put_ix_uint64(xp, (const ix_uint64 *)ip);
#line 2001
#else
#line 2001
    ix_uint64 xx = NC_FILL_UINT64;
#line 2001

#line 2001
#if IX_UINT64_MAX < UINT_MAX
#line 2001
    if (*ip > IX_UINT64_MAX) {
#line 2001
        
#line 2001
#ifdef ERANGE_FILL
#line 2001
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2001
#endif
#line 2001
        err = NC_ERANGE;
#line 2001
    }
#line 2001
#ifdef ERANGE_FILL
#line 2001
    else
#line 2001
#endif
#line 2001
#endif
#line 2001
        xx = (ix_uint64)*ip;
#line 2001

#line 2001
    put_ix_uint64(xp, &xx);
#line 2001
#endif
#line 2001
    return err;
#line 2001
}
#line 2001

static int
#line 2002
ncx_put_ulonglong_float(void *xp, const float *ip, void *fillp)
#line 2002
{
#line 2002
    int err=NC_NOERR;
#line 2002
    ix_uint64 xx = NC_FILL_UINT64;
#line 2002

#line 2002
    if (*ip > (double)X_UINT64_MAX || *ip < 0) {
#line 2002
        
#line 2002
#ifdef ERANGE_FILL
#line 2002
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2002
#endif
#line 2002
        err = NC_ERANGE;
#line 2002
    }
#line 2002
#ifdef ERANGE_FILL
#line 2002
    else
#line 2002
#endif
#line 2002
        xx = (ix_uint64)*ip;
#line 2002

#line 2002
    put_ix_uint64(xp, &xx);
#line 2002
    return err;
#line 2002
}
#line 2002

static int
#line 2003
ncx_put_ulonglong_double(void *xp, const double *ip, void *fillp)
#line 2003
{
#line 2003
    int err=NC_NOERR;
#line 2003
    ix_uint64 xx = NC_FILL_UINT64;
#line 2003

#line 2003
    if (*ip > X_UINT64_MAX || *ip < 0) {
#line 2003
        
#line 2003
#ifdef ERANGE_FILL
#line 2003
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2003
#endif
#line 2003
        err = NC_ERANGE;
#line 2003
    }
#line 2003
#ifdef ERANGE_FILL
#line 2003
    else
#line 2003
#endif
#line 2003
        xx = (ix_uint64)*ip;
#line 2003

#line 2003
    put_ix_uint64(xp, &xx);
#line 2003
    return err;
#line 2003
}
#line 2003



/* x_size_t */

#if SIZEOF_SIZE_T < X_SIZEOF_SIZE_T
#error "x_size_t implementation"
/* netcdf requires size_t which can hold a values from 0 to 2^32 -1 */
#endif

int
ncx_put_size_t(void **xpp, const size_t *ulp)
{
	/* similar to put_ix_int() */
	uchar *cp = (uchar *) *xpp;
	assert(*ulp <= X_SIZE_MAX);

	*cp++ = (uchar)((*ulp) >> 24);
	*cp++ = (uchar)(((*ulp) & 0x00ff0000) >> 16);
	*cp++ = (uchar)(((*ulp) & 0x0000ff00) >>  8);
	*cp   = (uchar)((*ulp) & 0x000000ff);

	*xpp = (void *)((char *)(*xpp) + X_SIZEOF_SIZE_T);
	return NC_NOERR;
}

int
ncx_get_size_t(const void **xpp,  size_t *ulp)
{
	/* similar to get_ix_int */
	const uchar *cp = (const uchar *) *xpp;

	*ulp  = (unsigned)(*cp++) << 24;
	*ulp |= (*cp++ << 16);
	*ulp |= (*cp++ << 8);
	*ulp |= *cp;

	*xpp = (const void *)((const char *)(*xpp) + X_SIZEOF_SIZE_T);
	return NC_NOERR;
}

/* x_off_t */

int
ncx_put_off_t(void **xpp, const off_t *lp, size_t sizeof_off_t)
{
	/* similar to put_ix_int() */
	uchar *cp = (uchar *) *xpp;

	/* No negative offsets stored in netcdf */
	if (*lp < 0) {
	  /* Assume this is an overflow of a 32-bit int... */
	  return NC_ERANGE;
	}

	assert(sizeof_off_t == 4 || sizeof_off_t == 8);

	if (sizeof_off_t == 4) {
		*cp++ = (uchar) ((*lp)               >> 24);
		*cp++ = (uchar)(((*lp) & 0x00ff0000) >> 16);
		*cp++ = (uchar)(((*lp) & 0x0000ff00) >>  8);
		*cp   = (uchar)( (*lp) & 0x000000ff);
	} else {
#if SIZEOF_OFF_T == 4
/* Write a 64-bit offset on a system with only a 32-bit offset */
		*cp++ = (uchar)0;
		*cp++ = (uchar)0;
		*cp++ = (uchar)0;
		*cp++ = (uchar)0;

		*cp++ = (uchar)(((*lp) & 0xff000000) >> 24);
		*cp++ = (uchar)(((*lp) & 0x00ff0000) >> 16);
		*cp++ = (uchar)(((*lp) & 0x0000ff00) >>  8);
		*cp   = (uchar)( (*lp) & 0x000000ff);
#else
		*cp++ = (uchar) ((*lp)                          >> 56);
		*cp++ = (uchar)(((*lp) & 0x00ff000000000000LL) >> 48);
		*cp++ = (uchar)(((*lp) & 0x0000ff0000000000LL) >> 40);
		*cp++ = (uchar)(((*lp) & 0x000000ff00000000LL) >> 32);
		*cp++ = (uchar)(((*lp) & 0x00000000ff000000LL) >> 24);
		*cp++ = (uchar)(((*lp) & 0x0000000000ff0000LL) >> 16);
		*cp++ = (uchar)(((*lp) & 0x000000000000ff00LL) >>  8);
		*cp   = (uchar)( (*lp) & 0x00000000000000ffLL);
#endif
	}
	*xpp = (void *)((char *)(*xpp) + sizeof_off_t);
	return NC_NOERR;
}

int
ncx_get_off_t(const void **xpp, off_t *lp, size_t sizeof_off_t)
{
	/* similar to get_ix_int() */
	const uchar *cp = (const uchar *) *xpp;
	assert(sizeof_off_t == 4 || sizeof_off_t == 8);

 	if (sizeof_off_t == 4) {
		*lp =  (off_t)(*cp++ << 24);
		*lp |= (off_t)(*cp++ << 16);
		*lp |= (off_t)(*cp++ <<  8);
		*lp |= (off_t)*cp;
	} else {
#if SIZEOF_OFF_T == 4
/* Read a 64-bit offset on a system with only a 32-bit offset */
/* If the offset overflows, set an error code and return */
		*lp =  ((off_t)(*cp++) << 24);
		*lp |= ((off_t)(*cp++) << 16);
		*lp |= ((off_t)(*cp++) <<  8);
		*lp |= ((off_t)(*cp++));
/*
 * lp now contains the upper 32-bits of the 64-bit offset.  if lp is
 * not zero, then the dataset is larger than can be represented
 * on this system.  Set an error code and return.
 */
		if (*lp != 0) {
		  return NC_ERANGE;
		}

		*lp  = ((off_t)(*cp++) << 24);
		*lp |= ((off_t)(*cp++) << 16);
		*lp |= ((off_t)(*cp++) <<  8);
		*lp |=  (off_t)*cp;

		if (*lp < 0) {
		  /*
		   * If this fails, then the offset is >2^31, but less
		   * than 2^32 which is not allowed, but is not caught
		   * by the previous check
		   */
		  return NC_ERANGE;
		}
#else
		*lp =  ((off_t)(*cp++) << 56);
		*lp |= ((off_t)(*cp++) << 48);
		*lp |= ((off_t)(*cp++) << 40);
		*lp |= ((off_t)(*cp++) << 32);
		*lp |= ((off_t)(*cp++) << 24);
		*lp |= ((off_t)(*cp++) << 16);
		*lp |= ((off_t)(*cp++) <<  8);
		*lp |=  (off_t)*cp;
#endif
	}
	*xpp = (const void *)((const char *)(*xpp) + sizeof_off_t);
	return NC_NOERR;
}

/*----< ncx_get_uint32() >------------------------------------------*/
int
ncx_get_uint32(const void **xpp, uint *ip)
{
#ifdef WORDS_BIGENDIAN
    /* use memcpy instead of assignment to avoid BUS_ADRALN alignment error on
     * some system, such as HPUX */
    (void) memcpy(ip, *xpp, SIZEOF_UINT);
#else
    const uchar *cp = (const uchar *) *xpp;

    *ip = (uint)(*cp++ << 24);
    *ip = (uint)(*ip | (uint)(*cp++ << 16));
    *ip = (uint)(*ip | (uint)(*cp++ <<  8));
    *ip = (uint)(*ip | *cp);
#endif
    /* advance *xpp 4 bytes */
    *xpp = (void *)((const char *)(*xpp) + 4);

    return NC_NOERR;
}

/*----< ncx_get_uint64() >------------------------------------------*/
int
ncx_get_uint64(const void **xpp, unsigned long long *ullp)
{
#ifdef WORDS_BIGENDIAN
    /* use memcpy instead of assignment to avoid BUS_ADRALN alignment error on
     * some system, such as HPUX */
    (void) memcpy(ullp, *xpp, SIZEOF_UINT64);
#else
    const uchar *cp = (const uchar *) *xpp;

    /* below is the same as calling swap8b(ullp, *xpp) */
    *ullp = (unsigned long long)(*cp++) << 56;
    *ullp = (unsigned long long)(*ullp | (unsigned long long)(*cp++) << 48);
    *ullp = (unsigned long long)(*ullp | (unsigned long long)(*cp++) << 40);
    *ullp = (unsigned long long)(*ullp | (unsigned long long)(*cp++) << 32);
    *ullp = (unsigned long long)(*ullp | (unsigned long long)(*cp++) << 24);
    *ullp = (unsigned long long)(*ullp | (unsigned long long)(*cp++) << 16);
    *ullp = (unsigned long long)(*ullp | (unsigned long long)(*cp++) <<  8);
    *ullp = (unsigned long long)(*ullp | (unsigned long long)(*cp));
#endif
    /* advance *xpp 8 bytes */
    *xpp = (void *)((const char *)(*xpp) + 8);

    return NC_NOERR;
}

/*---< ncx_put_uint32() >-------------------------------------------*/
/* copy the contents of ip (an unsigned 32-bit integer) to xpp in Big Endian
 * form and advance *xpp 4 bytes
 */
int
ncx_put_uint32(void **xpp, const unsigned int ip)
{
#ifdef WORDS_BIGENDIAN
    /* use memcpy instead of assignment to avoid BUS_ADRALN alignment error on
     * some system, such as HPUX */
    (void) memcpy(*xpp, &ip, X_SIZEOF_UINT);
#else
    /* bitwise shifts below are to produce an integer in Big Endian */
    uchar *cp = (uchar *) *xpp;
    *cp++ = (uchar)((ip & 0xff000000) >> 24);
    *cp++ = (uchar)((ip & 0x00ff0000) >> 16);
    *cp++ = (uchar)((ip & 0x0000ff00) >>  8);
    *cp   = (uchar)( ip & 0x000000ff);
#endif
    /* advance *xpp 4 bytes */
    *xpp  = (void *)((char *)(*xpp) + 4);

    return NC_NOERR;
}

/*---< ncx_put_uint64() >-------------------------------------------*/
/* copy the contents of ip (an unsigned 64-bit integer) to xpp in Big Endian
 * form and advance *xpp 8 bytes
 */
int
ncx_put_uint64(void **xpp, const unsigned long long ip)
{
#ifdef WORDS_BIGENDIAN
    /* use memcpy instead of assignment to avoid BUS_ADRALN alignment error on
     * some system, such as HPUX */
    (void) memcpy(*xpp, &ip, X_SIZEOF_UINT64);
#else
    uchar *cp = (uchar *) *xpp;
    /* below is the same as calling swap8b(*xpp, &ip) */
    *cp++ = (uchar) (ip                         >> 56);
    *cp++ = (uchar)((ip & 0x00ff000000000000LL) >> 48);
    *cp++ = (uchar)((ip & 0x0000ff0000000000LL) >> 40);
    *cp++ = (uchar)((ip & 0x000000ff00000000LL) >> 32);
    *cp++ = (uchar)((ip & 0x00000000ff000000LL) >> 24);
    *cp++ = (uchar)((ip & 0x0000000000ff0000LL) >> 16);
    *cp++ = (uchar)((ip & 0x000000000000ff00LL) >>  8);
    *cp   = (uchar) (ip & 0x00000000000000ffLL);
#endif
    /* advance *xpp 8 bytes */
    *xpp  = (void *)((char *)(*xpp) + 8);

    return NC_NOERR;
}


/*
 * Aggregate numeric conversion functions.
 */
#line 2259

#line 2662

#line 2668

/* schar ---------------------------------------------------------------------*/

#line 2672
int
ncx_getn_schar_schar(const void **xpp, size_t nelems, schar *tp)
{
		(void) memcpy(tp, *xpp, (size_t)nelems);
#line 2675
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 2675
	return NC_NOERR;
#line 2675

}
int
#line 2677
ncx_getn_schar_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 2677
{
#line 2677
    int status = NC_NOERR;
#line 2677
    schar *xp = (schar *)(*xpp);
#line 2677

#line 2677
    while (nelems-- != 0) {
#line 2677
        
#line 2677
        if (*xp < 0) {
#line 2677
#ifdef ERANGE_FILL
#line 2677
            *tp = NC_FILL_UBYTE;
#line 2677
#endif
#line 2677
            status = NC_ERANGE; /* because tp is unsigned */
#line 2677
            
#line 2677
#ifdef ERANGE_FILL
#line 2677
            xp++; tp++; continue;
#line 2677
#endif
#line 2677
        }
#line 2677
        *tp++ = (uchar) (signed) (*xp++);  /* type cast from schar to uchar */
#line 2677
    }
#line 2677

#line 2677
    *xpp = (const void *)xp;
#line 2677
    return status;
#line 2677
}
#line 2677

int
#line 2678
ncx_getn_schar_short(const void **xpp, size_t nelems, short *tp)
#line 2678
{
#line 2678
    int status = NC_NOERR;
#line 2678
    schar *xp = (schar *)(*xpp);
#line 2678

#line 2678
    while (nelems-- != 0) {
#line 2678
        
#line 2678
        *tp++ = (short)  (*xp++);  /* type cast from schar to short */
#line 2678
    }
#line 2678

#line 2678
    *xpp = (const void *)xp;
#line 2678
    return status;
#line 2678
}
#line 2678

int
#line 2679
ncx_getn_schar_int(const void **xpp, size_t nelems, int *tp)
#line 2679
{
#line 2679
    int status = NC_NOERR;
#line 2679
    schar *xp = (schar *)(*xpp);
#line 2679

#line 2679
    while (nelems-- != 0) {
#line 2679
        
#line 2679
        *tp++ = (int)  (*xp++);  /* type cast from schar to int */
#line 2679
    }
#line 2679

#line 2679
    *xpp = (const void *)xp;
#line 2679
    return status;
#line 2679
}
#line 2679

int
#line 2680
ncx_getn_schar_long(const void **xpp, size_t nelems, long *tp)
#line 2680
{
#line 2680
    int status = NC_NOERR;
#line 2680
    schar *xp = (schar *)(*xpp);
#line 2680

#line 2680
    while (nelems-- != 0) {
#line 2680
        
#line 2680
        *tp++ = (long)  (*xp++);  /* type cast from schar to long */
#line 2680
    }
#line 2680

#line 2680
    *xpp = (const void *)xp;
#line 2680
    return status;
#line 2680
}
#line 2680

int
#line 2681
ncx_getn_schar_float(const void **xpp, size_t nelems, float *tp)
#line 2681
{
#line 2681
    int status = NC_NOERR;
#line 2681
    schar *xp = (schar *)(*xpp);
#line 2681

#line 2681
    while (nelems-- != 0) {
#line 2681
        
#line 2681
        *tp++ = (float)  (*xp++);  /* type cast from schar to float */
#line 2681
    }
#line 2681

#line 2681
    *xpp = (const void *)xp;
#line 2681
    return status;
#line 2681
}
#line 2681

int
#line 2682
ncx_getn_schar_double(const void **xpp, size_t nelems, double *tp)
#line 2682
{
#line 2682
    int status = NC_NOERR;
#line 2682
    schar *xp = (schar *)(*xpp);
#line 2682

#line 2682
    while (nelems-- != 0) {
#line 2682
        
#line 2682
        *tp++ = (double)  (*xp++);  /* type cast from schar to double */
#line 2682
    }
#line 2682

#line 2682
    *xpp = (const void *)xp;
#line 2682
    return status;
#line 2682
}
#line 2682

int
#line 2683
ncx_getn_schar_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 2683
{
#line 2683
    int status = NC_NOERR;
#line 2683
    schar *xp = (schar *)(*xpp);
#line 2683

#line 2683
    while (nelems-- != 0) {
#line 2683
        
#line 2683
        *tp++ = (longlong)  (*xp++);  /* type cast from schar to longlong */
#line 2683
    }
#line 2683

#line 2683
    *xpp = (const void *)xp;
#line 2683
    return status;
#line 2683
}
#line 2683

int
#line 2684
ncx_getn_schar_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 2684
{
#line 2684
    int status = NC_NOERR;
#line 2684
    schar *xp = (schar *)(*xpp);
#line 2684

#line 2684
    while (nelems-- != 0) {
#line 2684
        
#line 2684
        if (*xp < 0) {
#line 2684
#ifdef ERANGE_FILL
#line 2684
            *tp = NC_FILL_USHORT;
#line 2684
#endif
#line 2684
            status = NC_ERANGE; /* because tp is unsigned */
#line 2684
            
#line 2684
#ifdef ERANGE_FILL
#line 2684
            xp++; tp++; continue;
#line 2684
#endif
#line 2684
        }
#line 2684
        *tp++ = (ushort) (signed) (*xp++);  /* type cast from schar to ushort */
#line 2684
    }
#line 2684

#line 2684
    *xpp = (const void *)xp;
#line 2684
    return status;
#line 2684
}
#line 2684

int
#line 2685
ncx_getn_schar_uint(const void **xpp, size_t nelems, uint *tp)
#line 2685
{
#line 2685
    int status = NC_NOERR;
#line 2685
    schar *xp = (schar *)(*xpp);
#line 2685

#line 2685
    while (nelems-- != 0) {
#line 2685
        
#line 2685
        if (*xp < 0) {
#line 2685
#ifdef ERANGE_FILL
#line 2685
            *tp = NC_FILL_UINT;
#line 2685
#endif
#line 2685
            status = NC_ERANGE; /* because tp is unsigned */
#line 2685
            
#line 2685
#ifdef ERANGE_FILL
#line 2685
            xp++; tp++; continue;
#line 2685
#endif
#line 2685
        }
#line 2685
        *tp++ = (uint) (signed) (*xp++);  /* type cast from schar to uint */
#line 2685
    }
#line 2685

#line 2685
    *xpp = (const void *)xp;
#line 2685
    return status;
#line 2685
}
#line 2685

int
#line 2686
ncx_getn_schar_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 2686
{
#line 2686
    int status = NC_NOERR;
#line 2686
    schar *xp = (schar *)(*xpp);
#line 2686

#line 2686
    while (nelems-- != 0) {
#line 2686
        
#line 2686
        if (*xp < 0) {
#line 2686
#ifdef ERANGE_FILL
#line 2686
            *tp = NC_FILL_UINT64;
#line 2686
#endif
#line 2686
            status = NC_ERANGE; /* because tp is unsigned */
#line 2686
            
#line 2686
#ifdef ERANGE_FILL
#line 2686
            xp++; tp++; continue;
#line 2686
#endif
#line 2686
        }
#line 2686
        *tp++ = (ulonglong) (signed) (*xp++);  /* type cast from schar to ulonglong */
#line 2686
    }
#line 2686

#line 2686
    *xpp = (const void *)xp;
#line 2686
    return status;
#line 2686
}
#line 2686


#line 2689
int
ncx_pad_getn_schar_schar(const void **xpp, size_t nelems, schar *tp)
{
		size_t rndup = nelems % X_ALIGN;
#line 2692

#line 2692
	if (rndup)
#line 2692
		rndup = X_ALIGN - rndup;
#line 2692

#line 2692
	(void) memcpy(tp, *xpp, (size_t)nelems);
#line 2692
	*xpp = (void *)((char *)(*xpp) + nelems + rndup);
#line 2692

#line 2692
	return NC_NOERR;
#line 2692

}
int
#line 2694
ncx_pad_getn_schar_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 2694
{
#line 2694
    int status = NC_NOERR;
#line 2694
    size_t rndup = nelems % X_ALIGN;
#line 2694
    schar *xp = (schar *) *xpp;
#line 2694

#line 2694
    if (rndup)
#line 2694
        rndup = X_ALIGN - rndup;
#line 2694

#line 2694
    while (nelems-- != 0) {
#line 2694
        
#line 2694
        if (*xp < 0) {
#line 2694
#ifdef ERANGE_FILL
#line 2694
            *tp = NC_FILL_UBYTE;
#line 2694
#endif
#line 2694
            status = NC_ERANGE; /* because tp is unsigned */
#line 2694
            
#line 2694
#ifdef ERANGE_FILL
#line 2694
            xp++; tp++; continue;
#line 2694
#endif
#line 2694
        }
#line 2694
        *tp++ = (uchar) (signed) (*xp++);  /* type cast from schar to uchar */
#line 2694
    }
#line 2694

#line 2694
    *xpp = (void *)(xp + rndup);
#line 2694
    return status;
#line 2694
}
#line 2694

int
#line 2695
ncx_pad_getn_schar_short(const void **xpp, size_t nelems, short *tp)
#line 2695
{
#line 2695
    int status = NC_NOERR;
#line 2695
    size_t rndup = nelems % X_ALIGN;
#line 2695
    schar *xp = (schar *) *xpp;
#line 2695

#line 2695
    if (rndup)
#line 2695
        rndup = X_ALIGN - rndup;
#line 2695

#line 2695
    while (nelems-- != 0) {
#line 2695
        
#line 2695
        *tp++ = (short)  (*xp++);  /* type cast from schar to short */
#line 2695
    }
#line 2695

#line 2695
    *xpp = (void *)(xp + rndup);
#line 2695
    return status;
#line 2695
}
#line 2695

int
#line 2696
ncx_pad_getn_schar_int(const void **xpp, size_t nelems, int *tp)
#line 2696
{
#line 2696
    int status = NC_NOERR;
#line 2696
    size_t rndup = nelems % X_ALIGN;
#line 2696
    schar *xp = (schar *) *xpp;
#line 2696

#line 2696
    if (rndup)
#line 2696
        rndup = X_ALIGN - rndup;
#line 2696

#line 2696
    while (nelems-- != 0) {
#line 2696
        
#line 2696
        *tp++ = (int)  (*xp++);  /* type cast from schar to int */
#line 2696
    }
#line 2696

#line 2696
    *xpp = (void *)(xp + rndup);
#line 2696
    return status;
#line 2696
}
#line 2696

int
#line 2697
ncx_pad_getn_schar_long(const void **xpp, size_t nelems, long *tp)
#line 2697
{
#line 2697
    int status = NC_NOERR;
#line 2697
    size_t rndup = nelems % X_ALIGN;
#line 2697
    schar *xp = (schar *) *xpp;
#line 2697

#line 2697
    if (rndup)
#line 2697
        rndup = X_ALIGN - rndup;
#line 2697

#line 2697
    while (nelems-- != 0) {
#line 2697
        
#line 2697
        *tp++ = (long)  (*xp++);  /* type cast from schar to long */
#line 2697
    }
#line 2697

#line 2697
    *xpp = (void *)(xp + rndup);
#line 2697
    return status;
#line 2697
}
#line 2697

int
#line 2698
ncx_pad_getn_schar_float(const void **xpp, size_t nelems, float *tp)
#line 2698
{
#line 2698
    int status = NC_NOERR;
#line 2698
    size_t rndup = nelems % X_ALIGN;
#line 2698
    schar *xp = (schar *) *xpp;
#line 2698

#line 2698
    if (rndup)
#line 2698
        rndup = X_ALIGN - rndup;
#line 2698

#line 2698
    while (nelems-- != 0) {
#line 2698
        
#line 2698
        *tp++ = (float)  (*xp++);  /* type cast from schar to float */
#line 2698
    }
#line 2698

#line 2698
    *xpp = (void *)(xp + rndup);
#line 2698
    return status;
#line 2698
}
#line 2698

int
#line 2699
ncx_pad_getn_schar_double(const void **xpp, size_t nelems, double *tp)
#line 2699
{
#line 2699
    int status = NC_NOERR;
#line 2699
    size_t rndup = nelems % X_ALIGN;
#line 2699
    schar *xp = (schar *) *xpp;
#line 2699

#line 2699
    if (rndup)
#line 2699
        rndup = X_ALIGN - rndup;
#line 2699

#line 2699
    while (nelems-- != 0) {
#line 2699
        
#line 2699
        *tp++ = (double)  (*xp++);  /* type cast from schar to double */
#line 2699
    }
#line 2699

#line 2699
    *xpp = (void *)(xp + rndup);
#line 2699
    return status;
#line 2699
}
#line 2699

int
#line 2700
ncx_pad_getn_schar_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 2700
{
#line 2700
    int status = NC_NOERR;
#line 2700
    size_t rndup = nelems % X_ALIGN;
#line 2700
    schar *xp = (schar *) *xpp;
#line 2700

#line 2700
    if (rndup)
#line 2700
        rndup = X_ALIGN - rndup;
#line 2700

#line 2700
    while (nelems-- != 0) {
#line 2700
        
#line 2700
        *tp++ = (longlong)  (*xp++);  /* type cast from schar to longlong */
#line 2700
    }
#line 2700

#line 2700
    *xpp = (void *)(xp + rndup);
#line 2700
    return status;
#line 2700
}
#line 2700

int
#line 2701
ncx_pad_getn_schar_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 2701
{
#line 2701
    int status = NC_NOERR;
#line 2701
    size_t rndup = nelems % X_ALIGN;
#line 2701
    schar *xp = (schar *) *xpp;
#line 2701

#line 2701
    if (rndup)
#line 2701
        rndup = X_ALIGN - rndup;
#line 2701

#line 2701
    while (nelems-- != 0) {
#line 2701
        
#line 2701
        if (*xp < 0) {
#line 2701
#ifdef ERANGE_FILL
#line 2701
            *tp = NC_FILL_USHORT;
#line 2701
#endif
#line 2701
            status = NC_ERANGE; /* because tp is unsigned */
#line 2701
            
#line 2701
#ifdef ERANGE_FILL
#line 2701
            xp++; tp++; continue;
#line 2701
#endif
#line 2701
        }
#line 2701
        *tp++ = (ushort) (signed) (*xp++);  /* type cast from schar to ushort */
#line 2701
    }
#line 2701

#line 2701
    *xpp = (void *)(xp + rndup);
#line 2701
    return status;
#line 2701
}
#line 2701

int
#line 2702
ncx_pad_getn_schar_uint(const void **xpp, size_t nelems, uint *tp)
#line 2702
{
#line 2702
    int status = NC_NOERR;
#line 2702
    size_t rndup = nelems % X_ALIGN;
#line 2702
    schar *xp = (schar *) *xpp;
#line 2702

#line 2702
    if (rndup)
#line 2702
        rndup = X_ALIGN - rndup;
#line 2702

#line 2702
    while (nelems-- != 0) {
#line 2702
        
#line 2702
        if (*xp < 0) {
#line 2702
#ifdef ERANGE_FILL
#line 2702
            *tp = NC_FILL_UINT;
#line 2702
#endif
#line 2702
            status = NC_ERANGE; /* because tp is unsigned */
#line 2702
            
#line 2702
#ifdef ERANGE_FILL
#line 2702
            xp++; tp++; continue;
#line 2702
#endif
#line 2702
        }
#line 2702
        *tp++ = (uint) (signed) (*xp++);  /* type cast from schar to uint */
#line 2702
    }
#line 2702

#line 2702
    *xpp = (void *)(xp + rndup);
#line 2702
    return status;
#line 2702
}
#line 2702

int
#line 2703
ncx_pad_getn_schar_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 2703
{
#line 2703
    int status = NC_NOERR;
#line 2703
    size_t rndup = nelems % X_ALIGN;
#line 2703
    schar *xp = (schar *) *xpp;
#line 2703

#line 2703
    if (rndup)
#line 2703
        rndup = X_ALIGN - rndup;
#line 2703

#line 2703
    while (nelems-- != 0) {
#line 2703
        
#line 2703
        if (*xp < 0) {
#line 2703
#ifdef ERANGE_FILL
#line 2703
            *tp = NC_FILL_UINT64;
#line 2703
#endif
#line 2703
            status = NC_ERANGE; /* because tp is unsigned */
#line 2703
            
#line 2703
#ifdef ERANGE_FILL
#line 2703
            xp++; tp++; continue;
#line 2703
#endif
#line 2703
        }
#line 2703
        *tp++ = (ulonglong) (signed) (*xp++);  /* type cast from schar to ulonglong */
#line 2703
    }
#line 2703

#line 2703
    *xpp = (void *)(xp + rndup);
#line 2703
    return status;
#line 2703
}
#line 2703


#line 2706
int
ncx_putn_schar_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
{
		(void) memcpy(*xpp, tp, (size_t)nelems);
#line 2709
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 2709

#line 2709
	return NC_NOERR;
#line 2709

}
int
#line 2711
ncx_putn_schar_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 2711
{
#line 2711
    int status = NC_NOERR;
#line 2711
    schar *xp = (schar *) *xpp;
#line 2711

#line 2711
    while (nelems-- != 0) {
#line 2711
        if (*tp > (uchar)X_SCHAR_MAX ) {
#line 2711
            
#line 2711
#ifdef ERANGE_FILL
#line 2711
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2711
#endif
#line 2711
            status = NC_ERANGE;
#line 2711
            
#line 2711
#ifdef ERANGE_FILL
#line 2711
            xp++; tp++; continue;
#line 2711
#endif
#line 2711
        }
#line 2711
        *xp++ = (schar)  *tp++; /* type cast from uchar to schar */
#line 2711
    }
#line 2711

#line 2711
    *xpp = (void *)xp;
#line 2711
    return status;
#line 2711
}
#line 2711

int
#line 2712
ncx_putn_schar_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 2712
{
#line 2712
    int status = NC_NOERR;
#line 2712
    schar *xp = (schar *) *xpp;
#line 2712

#line 2712
    while (nelems-- != 0) {
#line 2712
        if (*tp > (short)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2712
            
#line 2712
#ifdef ERANGE_FILL
#line 2712
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2712
#endif
#line 2712
            status = NC_ERANGE;
#line 2712
            
#line 2712
#ifdef ERANGE_FILL
#line 2712
            xp++; tp++; continue;
#line 2712
#endif
#line 2712
        }
#line 2712
        *xp++ = (schar)  *tp++; /* type cast from short to schar */
#line 2712
    }
#line 2712

#line 2712
    *xpp = (void *)xp;
#line 2712
    return status;
#line 2712
}
#line 2712

int
#line 2713
ncx_putn_schar_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 2713
{
#line 2713
    int status = NC_NOERR;
#line 2713
    schar *xp = (schar *) *xpp;
#line 2713

#line 2713
    while (nelems-- != 0) {
#line 2713
        if (*tp > (int)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2713
            
#line 2713
#ifdef ERANGE_FILL
#line 2713
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2713
#endif
#line 2713
            status = NC_ERANGE;
#line 2713
            
#line 2713
#ifdef ERANGE_FILL
#line 2713
            xp++; tp++; continue;
#line 2713
#endif
#line 2713
        }
#line 2713
        *xp++ = (schar)  *tp++; /* type cast from int to schar */
#line 2713
    }
#line 2713

#line 2713
    *xpp = (void *)xp;
#line 2713
    return status;
#line 2713
}
#line 2713

int
#line 2714
ncx_putn_schar_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 2714
{
#line 2714
    int status = NC_NOERR;
#line 2714
    schar *xp = (schar *) *xpp;
#line 2714

#line 2714
    while (nelems-- != 0) {
#line 2714
        if (*tp > (long)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2714
            
#line 2714
#ifdef ERANGE_FILL
#line 2714
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2714
#endif
#line 2714
            status = NC_ERANGE;
#line 2714
            
#line 2714
#ifdef ERANGE_FILL
#line 2714
            xp++; tp++; continue;
#line 2714
#endif
#line 2714
        }
#line 2714
        *xp++ = (schar)  *tp++; /* type cast from long to schar */
#line 2714
    }
#line 2714

#line 2714
    *xpp = (void *)xp;
#line 2714
    return status;
#line 2714
}
#line 2714

int
#line 2715
ncx_putn_schar_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 2715
{
#line 2715
    int status = NC_NOERR;
#line 2715
    schar *xp = (schar *) *xpp;
#line 2715

#line 2715
    while (nelems-- != 0) {
#line 2715
        if (*tp > (float)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2715
            
#line 2715
#ifdef ERANGE_FILL
#line 2715
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2715
#endif
#line 2715
            status = NC_ERANGE;
#line 2715
            
#line 2715
#ifdef ERANGE_FILL
#line 2715
            xp++; tp++; continue;
#line 2715
#endif
#line 2715
        }
#line 2715
        *xp++ = (schar)  *tp++; /* type cast from float to schar */
#line 2715
    }
#line 2715

#line 2715
    *xpp = (void *)xp;
#line 2715
    return status;
#line 2715
}
#line 2715

int
#line 2716
ncx_putn_schar_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 2716
{
#line 2716
    int status = NC_NOERR;
#line 2716
    schar *xp = (schar *) *xpp;
#line 2716

#line 2716
    while (nelems-- != 0) {
#line 2716
        if (*tp > (double)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2716
            
#line 2716
#ifdef ERANGE_FILL
#line 2716
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2716
#endif
#line 2716
            status = NC_ERANGE;
#line 2716
            
#line 2716
#ifdef ERANGE_FILL
#line 2716
            xp++; tp++; continue;
#line 2716
#endif
#line 2716
        }
#line 2716
        *xp++ = (schar)  *tp++; /* type cast from double to schar */
#line 2716
    }
#line 2716

#line 2716
    *xpp = (void *)xp;
#line 2716
    return status;
#line 2716
}
#line 2716

int
#line 2717
ncx_putn_schar_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 2717
{
#line 2717
    int status = NC_NOERR;
#line 2717
    schar *xp = (schar *) *xpp;
#line 2717

#line 2717
    while (nelems-- != 0) {
#line 2717
        if (*tp > (longlong)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2717
            
#line 2717
#ifdef ERANGE_FILL
#line 2717
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2717
#endif
#line 2717
            status = NC_ERANGE;
#line 2717
            
#line 2717
#ifdef ERANGE_FILL
#line 2717
            xp++; tp++; continue;
#line 2717
#endif
#line 2717
        }
#line 2717
        *xp++ = (schar)  *tp++; /* type cast from longlong to schar */
#line 2717
    }
#line 2717

#line 2717
    *xpp = (void *)xp;
#line 2717
    return status;
#line 2717
}
#line 2717

int
#line 2718
ncx_putn_schar_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 2718
{
#line 2718
    int status = NC_NOERR;
#line 2718
    schar *xp = (schar *) *xpp;
#line 2718

#line 2718
    while (nelems-- != 0) {
#line 2718
        if (*tp > (ushort)X_SCHAR_MAX ) {
#line 2718
            
#line 2718
#ifdef ERANGE_FILL
#line 2718
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2718
#endif
#line 2718
            status = NC_ERANGE;
#line 2718
            
#line 2718
#ifdef ERANGE_FILL
#line 2718
            xp++; tp++; continue;
#line 2718
#endif
#line 2718
        }
#line 2718
        *xp++ = (schar)  *tp++; /* type cast from ushort to schar */
#line 2718
    }
#line 2718

#line 2718
    *xpp = (void *)xp;
#line 2718
    return status;
#line 2718
}
#line 2718

int
#line 2719
ncx_putn_schar_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 2719
{
#line 2719
    int status = NC_NOERR;
#line 2719
    schar *xp = (schar *) *xpp;
#line 2719

#line 2719
    while (nelems-- != 0) {
#line 2719
        if (*tp > (uint)X_SCHAR_MAX ) {
#line 2719
            
#line 2719
#ifdef ERANGE_FILL
#line 2719
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2719
#endif
#line 2719
            status = NC_ERANGE;
#line 2719
            
#line 2719
#ifdef ERANGE_FILL
#line 2719
            xp++; tp++; continue;
#line 2719
#endif
#line 2719
        }
#line 2719
        *xp++ = (schar)  *tp++; /* type cast from uint to schar */
#line 2719
    }
#line 2719

#line 2719
    *xpp = (void *)xp;
#line 2719
    return status;
#line 2719
}
#line 2719

int
#line 2720
ncx_putn_schar_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 2720
{
#line 2720
    int status = NC_NOERR;
#line 2720
    schar *xp = (schar *) *xpp;
#line 2720

#line 2720
    while (nelems-- != 0) {
#line 2720
        if (*tp > (ulonglong)X_SCHAR_MAX ) {
#line 2720
            
#line 2720
#ifdef ERANGE_FILL
#line 2720
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2720
#endif
#line 2720
            status = NC_ERANGE;
#line 2720
            
#line 2720
#ifdef ERANGE_FILL
#line 2720
            xp++; tp++; continue;
#line 2720
#endif
#line 2720
        }
#line 2720
        *xp++ = (schar)  *tp++; /* type cast from ulonglong to schar */
#line 2720
    }
#line 2720

#line 2720
    *xpp = (void *)xp;
#line 2720
    return status;
#line 2720
}
#line 2720


#line 2723
int
ncx_pad_putn_schar_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
{
		size_t rndup = nelems % X_ALIGN;
#line 2726

#line 2726
	if (rndup)
#line 2726
		rndup = X_ALIGN - rndup;
#line 2726

#line 2726
	(void) memcpy(*xpp, tp, (size_t)nelems);
#line 2726
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 2726

#line 2726
	if (rndup)
#line 2726
	{
#line 2726
		(void) memcpy(*xpp, nada, (size_t)rndup);
#line 2726
		*xpp = (void *)((char *)(*xpp) + rndup);
#line 2726
	}
#line 2726

#line 2726
	return NC_NOERR;
#line 2726

}
int
#line 2728
ncx_pad_putn_schar_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 2728
{
#line 2728
    int status = NC_NOERR;
#line 2728
    size_t rndup = nelems % X_ALIGN;
#line 2728
    schar *xp = (schar *) *xpp;
#line 2728

#line 2728
    if (rndup) rndup = X_ALIGN - rndup;
#line 2728

#line 2728
    while (nelems-- != 0) {
#line 2728
        if (*tp > (uchar)X_SCHAR_MAX ) {
#line 2728
            
#line 2728
#ifdef ERANGE_FILL
#line 2728
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2728
#endif
#line 2728
            status = NC_ERANGE;
#line 2728
            
#line 2728
#ifdef ERANGE_FILL
#line 2728
            xp++; tp++; continue;
#line 2728
#endif
#line 2728
        }
#line 2728
        *xp++ = (schar)  *tp++; /* type cast from uchar to schar */
#line 2728
    }
#line 2728

#line 2728

#line 2728
    if (rndup) {
#line 2728
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2728
        xp += rndup;
#line 2728
    }
#line 2728

#line 2728
    *xpp = (void *)xp;
#line 2728
    return status;
#line 2728
}
#line 2728

int
#line 2729
ncx_pad_putn_schar_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 2729
{
#line 2729
    int status = NC_NOERR;
#line 2729
    size_t rndup = nelems % X_ALIGN;
#line 2729
    schar *xp = (schar *) *xpp;
#line 2729

#line 2729
    if (rndup) rndup = X_ALIGN - rndup;
#line 2729

#line 2729
    while (nelems-- != 0) {
#line 2729
        if (*tp > (short)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2729
            
#line 2729
#ifdef ERANGE_FILL
#line 2729
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2729
#endif
#line 2729
            status = NC_ERANGE;
#line 2729
            
#line 2729
#ifdef ERANGE_FILL
#line 2729
            xp++; tp++; continue;
#line 2729
#endif
#line 2729
        }
#line 2729
        *xp++ = (schar)  *tp++; /* type cast from short to schar */
#line 2729
    }
#line 2729

#line 2729

#line 2729
    if (rndup) {
#line 2729
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2729
        xp += rndup;
#line 2729
    }
#line 2729

#line 2729
    *xpp = (void *)xp;
#line 2729
    return status;
#line 2729
}
#line 2729

int
#line 2730
ncx_pad_putn_schar_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 2730
{
#line 2730
    int status = NC_NOERR;
#line 2730
    size_t rndup = nelems % X_ALIGN;
#line 2730
    schar *xp = (schar *) *xpp;
#line 2730

#line 2730
    if (rndup) rndup = X_ALIGN - rndup;
#line 2730

#line 2730
    while (nelems-- != 0) {
#line 2730
        if (*tp > (int)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2730
            
#line 2730
#ifdef ERANGE_FILL
#line 2730
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2730
#endif
#line 2730
            status = NC_ERANGE;
#line 2730
            
#line 2730
#ifdef ERANGE_FILL
#line 2730
            xp++; tp++; continue;
#line 2730
#endif
#line 2730
        }
#line 2730
        *xp++ = (schar)  *tp++; /* type cast from int to schar */
#line 2730
    }
#line 2730

#line 2730

#line 2730
    if (rndup) {
#line 2730
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2730
        xp += rndup;
#line 2730
    }
#line 2730

#line 2730
    *xpp = (void *)xp;
#line 2730
    return status;
#line 2730
}
#line 2730

int
#line 2731
ncx_pad_putn_schar_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 2731
{
#line 2731
    int status = NC_NOERR;
#line 2731
    size_t rndup = nelems % X_ALIGN;
#line 2731
    schar *xp = (schar *) *xpp;
#line 2731

#line 2731
    if (rndup) rndup = X_ALIGN - rndup;
#line 2731

#line 2731
    while (nelems-- != 0) {
#line 2731
        if (*tp > (long)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2731
            
#line 2731
#ifdef ERANGE_FILL
#line 2731
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2731
#endif
#line 2731
            status = NC_ERANGE;
#line 2731
            
#line 2731
#ifdef ERANGE_FILL
#line 2731
            xp++; tp++; continue;
#line 2731
#endif
#line 2731
        }
#line 2731
        *xp++ = (schar)  *tp++; /* type cast from long to schar */
#line 2731
    }
#line 2731

#line 2731

#line 2731
    if (rndup) {
#line 2731
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2731
        xp += rndup;
#line 2731
    }
#line 2731

#line 2731
    *xpp = (void *)xp;
#line 2731
    return status;
#line 2731
}
#line 2731

int
#line 2732
ncx_pad_putn_schar_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 2732
{
#line 2732
    int status = NC_NOERR;
#line 2732
    size_t rndup = nelems % X_ALIGN;
#line 2732
    schar *xp = (schar *) *xpp;
#line 2732

#line 2732
    if (rndup) rndup = X_ALIGN - rndup;
#line 2732

#line 2732
    while (nelems-- != 0) {
#line 2732
        if (*tp > (float)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2732
            
#line 2732
#ifdef ERANGE_FILL
#line 2732
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2732
#endif
#line 2732
            status = NC_ERANGE;
#line 2732
            
#line 2732
#ifdef ERANGE_FILL
#line 2732
            xp++; tp++; continue;
#line 2732
#endif
#line 2732
        }
#line 2732
        *xp++ = (schar)  *tp++; /* type cast from float to schar */
#line 2732
    }
#line 2732

#line 2732

#line 2732
    if (rndup) {
#line 2732
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2732
        xp += rndup;
#line 2732
    }
#line 2732

#line 2732
    *xpp = (void *)xp;
#line 2732
    return status;
#line 2732
}
#line 2732

int
#line 2733
ncx_pad_putn_schar_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 2733
{
#line 2733
    int status = NC_NOERR;
#line 2733
    size_t rndup = nelems % X_ALIGN;
#line 2733
    schar *xp = (schar *) *xpp;
#line 2733

#line 2733
    if (rndup) rndup = X_ALIGN - rndup;
#line 2733

#line 2733
    while (nelems-- != 0) {
#line 2733
        if (*tp > (double)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2733
            
#line 2733
#ifdef ERANGE_FILL
#line 2733
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2733
#endif
#line 2733
            status = NC_ERANGE;
#line 2733
            
#line 2733
#ifdef ERANGE_FILL
#line 2733
            xp++; tp++; continue;
#line 2733
#endif
#line 2733
        }
#line 2733
        *xp++ = (schar)  *tp++; /* type cast from double to schar */
#line 2733
    }
#line 2733

#line 2733

#line 2733
    if (rndup) {
#line 2733
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2733
        xp += rndup;
#line 2733
    }
#line 2733

#line 2733
    *xpp = (void *)xp;
#line 2733
    return status;
#line 2733
}
#line 2733

int
#line 2734
ncx_pad_putn_schar_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 2734
{
#line 2734
    int status = NC_NOERR;
#line 2734
    size_t rndup = nelems % X_ALIGN;
#line 2734
    schar *xp = (schar *) *xpp;
#line 2734

#line 2734
    if (rndup) rndup = X_ALIGN - rndup;
#line 2734

#line 2734
    while (nelems-- != 0) {
#line 2734
        if (*tp > (longlong)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2734
            
#line 2734
#ifdef ERANGE_FILL
#line 2734
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2734
#endif
#line 2734
            status = NC_ERANGE;
#line 2734
            
#line 2734
#ifdef ERANGE_FILL
#line 2734
            xp++; tp++; continue;
#line 2734
#endif
#line 2734
        }
#line 2734
        *xp++ = (schar)  *tp++; /* type cast from longlong to schar */
#line 2734
    }
#line 2734

#line 2734

#line 2734
    if (rndup) {
#line 2734
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2734
        xp += rndup;
#line 2734
    }
#line 2734

#line 2734
    *xpp = (void *)xp;
#line 2734
    return status;
#line 2734
}
#line 2734

int
#line 2735
ncx_pad_putn_schar_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 2735
{
#line 2735
    int status = NC_NOERR;
#line 2735
    size_t rndup = nelems % X_ALIGN;
#line 2735
    schar *xp = (schar *) *xpp;
#line 2735

#line 2735
    if (rndup) rndup = X_ALIGN - rndup;
#line 2735

#line 2735
    while (nelems-- != 0) {
#line 2735
        if (*tp > (ushort)X_SCHAR_MAX ) {
#line 2735
            
#line 2735
#ifdef ERANGE_FILL
#line 2735
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2735
#endif
#line 2735
            status = NC_ERANGE;
#line 2735
            
#line 2735
#ifdef ERANGE_FILL
#line 2735
            xp++; tp++; continue;
#line 2735
#endif
#line 2735
        }
#line 2735
        *xp++ = (schar)  *tp++; /* type cast from ushort to schar */
#line 2735
    }
#line 2735

#line 2735

#line 2735
    if (rndup) {
#line 2735
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2735
        xp += rndup;
#line 2735
    }
#line 2735

#line 2735
    *xpp = (void *)xp;
#line 2735
    return status;
#line 2735
}
#line 2735

int
#line 2736
ncx_pad_putn_schar_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 2736
{
#line 2736
    int status = NC_NOERR;
#line 2736
    size_t rndup = nelems % X_ALIGN;
#line 2736
    schar *xp = (schar *) *xpp;
#line 2736

#line 2736
    if (rndup) rndup = X_ALIGN - rndup;
#line 2736

#line 2736
    while (nelems-- != 0) {
#line 2736
        if (*tp > (uint)X_SCHAR_MAX ) {
#line 2736
            
#line 2736
#ifdef ERANGE_FILL
#line 2736
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2736
#endif
#line 2736
            status = NC_ERANGE;
#line 2736
            
#line 2736
#ifdef ERANGE_FILL
#line 2736
            xp++; tp++; continue;
#line 2736
#endif
#line 2736
        }
#line 2736
        *xp++ = (schar)  *tp++; /* type cast from uint to schar */
#line 2736
    }
#line 2736

#line 2736

#line 2736
    if (rndup) {
#line 2736
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2736
        xp += rndup;
#line 2736
    }
#line 2736

#line 2736
    *xpp = (void *)xp;
#line 2736
    return status;
#line 2736
}
#line 2736

int
#line 2737
ncx_pad_putn_schar_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 2737
{
#line 2737
    int status = NC_NOERR;
#line 2737
    size_t rndup = nelems % X_ALIGN;
#line 2737
    schar *xp = (schar *) *xpp;
#line 2737

#line 2737
    if (rndup) rndup = X_ALIGN - rndup;
#line 2737

#line 2737
    while (nelems-- != 0) {
#line 2737
        if (*tp > (ulonglong)X_SCHAR_MAX ) {
#line 2737
            
#line 2737
#ifdef ERANGE_FILL
#line 2737
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2737
#endif
#line 2737
            status = NC_ERANGE;
#line 2737
            
#line 2737
#ifdef ERANGE_FILL
#line 2737
            xp++; tp++; continue;
#line 2737
#endif
#line 2737
        }
#line 2737
        *xp++ = (schar)  *tp++; /* type cast from ulonglong to schar */
#line 2737
    }
#line 2737

#line 2737

#line 2737
    if (rndup) {
#line 2737
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2737
        xp += rndup;
#line 2737
    }
#line 2737

#line 2737
    *xpp = (void *)xp;
#line 2737
    return status;
#line 2737
}
#line 2737



/* uchar ---------------------------------------------------------------------*/
#line 2743
int
ncx_getn_uchar_schar(const void **xpp, size_t nelems, schar *tp)
{
    int status = NC_NOERR;
    uchar *xp = (uchar *)(*xpp);

    while (nelems-- != 0) {
        if (*xp > SCHAR_MAX) {
            *tp = NC_FILL_BYTE;
       	    status = NC_ERANGE;
            
#line 2753
#ifdef ERANGE_FILL
#line 2753
            xp++; tp++; continue;
#line 2753
#endif
        }
	*tp++ = (schar) *xp++; /* type cast from uchar to schar */
    }

    *xpp = (const void *)xp;
    return status;
}
#line 2762
int
ncx_getn_uchar_uchar(const void **xpp, size_t nelems, uchar *tp)
{
		(void) memcpy(tp, *xpp, (size_t)nelems);
#line 2765
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 2765
	return NC_NOERR;
#line 2765

}
int
#line 2767
ncx_getn_uchar_short(const void **xpp, size_t nelems, short *tp)
#line 2767
{
#line 2767
    int status = NC_NOERR;
#line 2767
    uchar *xp = (uchar *)(*xpp);
#line 2767

#line 2767
    while (nelems-- != 0) {
#line 2767
        
#line 2767
        *tp++ = (short)  (*xp++);  /* type cast from uchar to short */
#line 2767
    }
#line 2767

#line 2767
    *xpp = (const void *)xp;
#line 2767
    return status;
#line 2767
}
#line 2767

int
#line 2768
ncx_getn_uchar_int(const void **xpp, size_t nelems, int *tp)
#line 2768
{
#line 2768
    int status = NC_NOERR;
#line 2768
    uchar *xp = (uchar *)(*xpp);
#line 2768

#line 2768
    while (nelems-- != 0) {
#line 2768
        
#line 2768
        *tp++ = (int)  (*xp++);  /* type cast from uchar to int */
#line 2768
    }
#line 2768

#line 2768
    *xpp = (const void *)xp;
#line 2768
    return status;
#line 2768
}
#line 2768

int
#line 2769
ncx_getn_uchar_long(const void **xpp, size_t nelems, long *tp)
#line 2769
{
#line 2769
    int status = NC_NOERR;
#line 2769
    uchar *xp = (uchar *)(*xpp);
#line 2769

#line 2769
    while (nelems-- != 0) {
#line 2769
        
#line 2769
        *tp++ = (long)  (*xp++);  /* type cast from uchar to long */
#line 2769
    }
#line 2769

#line 2769
    *xpp = (const void *)xp;
#line 2769
    return status;
#line 2769
}
#line 2769

int
#line 2770
ncx_getn_uchar_float(const void **xpp, size_t nelems, float *tp)
#line 2770
{
#line 2770
    int status = NC_NOERR;
#line 2770
    uchar *xp = (uchar *)(*xpp);
#line 2770

#line 2770
    while (nelems-- != 0) {
#line 2770
        
#line 2770
        *tp++ = (float)  (*xp++);  /* type cast from uchar to float */
#line 2770
    }
#line 2770

#line 2770
    *xpp = (const void *)xp;
#line 2770
    return status;
#line 2770
}
#line 2770

int
#line 2771
ncx_getn_uchar_double(const void **xpp, size_t nelems, double *tp)
#line 2771
{
#line 2771
    int status = NC_NOERR;
#line 2771
    uchar *xp = (uchar *)(*xpp);
#line 2771

#line 2771
    while (nelems-- != 0) {
#line 2771
        
#line 2771
        *tp++ = (double)  (*xp++);  /* type cast from uchar to double */
#line 2771
    }
#line 2771

#line 2771
    *xpp = (const void *)xp;
#line 2771
    return status;
#line 2771
}
#line 2771

int
#line 2772
ncx_getn_uchar_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 2772
{
#line 2772
    int status = NC_NOERR;
#line 2772
    uchar *xp = (uchar *)(*xpp);
#line 2772

#line 2772
    while (nelems-- != 0) {
#line 2772
        
#line 2772
        *tp++ = (longlong)  (*xp++);  /* type cast from uchar to longlong */
#line 2772
    }
#line 2772

#line 2772
    *xpp = (const void *)xp;
#line 2772
    return status;
#line 2772
}
#line 2772

int
#line 2773
ncx_getn_uchar_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 2773
{
#line 2773
    int status = NC_NOERR;
#line 2773
    uchar *xp = (uchar *)(*xpp);
#line 2773

#line 2773
    while (nelems-- != 0) {
#line 2773
        
#line 2773
        *tp++ = (ushort)  (*xp++);  /* type cast from uchar to ushort */
#line 2773
    }
#line 2773

#line 2773
    *xpp = (const void *)xp;
#line 2773
    return status;
#line 2773
}
#line 2773

int
#line 2774
ncx_getn_uchar_uint(const void **xpp, size_t nelems, uint *tp)
#line 2774
{
#line 2774
    int status = NC_NOERR;
#line 2774
    uchar *xp = (uchar *)(*xpp);
#line 2774

#line 2774
    while (nelems-- != 0) {
#line 2774
        
#line 2774
        *tp++ = (uint)  (*xp++);  /* type cast from uchar to uint */
#line 2774
    }
#line 2774

#line 2774
    *xpp = (const void *)xp;
#line 2774
    return status;
#line 2774
}
#line 2774

int
#line 2775
ncx_getn_uchar_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 2775
{
#line 2775
    int status = NC_NOERR;
#line 2775
    uchar *xp = (uchar *)(*xpp);
#line 2775

#line 2775
    while (nelems-- != 0) {
#line 2775
        
#line 2775
        *tp++ = (ulonglong)  (*xp++);  /* type cast from uchar to ulonglong */
#line 2775
    }
#line 2775

#line 2775
    *xpp = (const void *)xp;
#line 2775
    return status;
#line 2775
}
#line 2775


#line 2778
int
ncx_pad_getn_uchar_schar(const void **xpp, size_t nelems, schar *tp)
{
    int status = NC_NOERR;
    size_t rndup = nelems % X_ALIGN;
    uchar *xp = (uchar *) *xpp;

    if (rndup) rndup = X_ALIGN - rndup;

    while (nelems-- != 0) {
        if (*xp > SCHAR_MAX) {
            *tp = NC_FILL_BYTE;
            status = NC_ERANGE;
            
#line 2791
#ifdef ERANGE_FILL
#line 2791
            xp++; tp++; continue;
#line 2791
#endif
        }
        *tp++ = (schar) *xp++; /* type cast from uchar to schar */
    }

    *xpp = (void *)(xp + rndup);
    return status;
}
#line 2800
int
ncx_pad_getn_uchar_uchar(const void **xpp, size_t nelems, uchar *tp)
{
		size_t rndup = nelems % X_ALIGN;
#line 2803

#line 2803
	if (rndup)
#line 2803
		rndup = X_ALIGN - rndup;
#line 2803

#line 2803
	(void) memcpy(tp, *xpp, (size_t)nelems);
#line 2803
	*xpp = (void *)((char *)(*xpp) + nelems + rndup);
#line 2803

#line 2803
	return NC_NOERR;
#line 2803

}
int
#line 2805
ncx_pad_getn_uchar_short(const void **xpp, size_t nelems, short *tp)
#line 2805
{
#line 2805
    int status = NC_NOERR;
#line 2805
    size_t rndup = nelems % X_ALIGN;
#line 2805
    uchar *xp = (uchar *) *xpp;
#line 2805

#line 2805
    if (rndup)
#line 2805
        rndup = X_ALIGN - rndup;
#line 2805

#line 2805
    while (nelems-- != 0) {
#line 2805
        
#line 2805
        *tp++ = (short)  (*xp++);  /* type cast from uchar to short */
#line 2805
    }
#line 2805

#line 2805
    *xpp = (void *)(xp + rndup);
#line 2805
    return status;
#line 2805
}
#line 2805

int
#line 2806
ncx_pad_getn_uchar_int(const void **xpp, size_t nelems, int *tp)
#line 2806
{
#line 2806
    int status = NC_NOERR;
#line 2806
    size_t rndup = nelems % X_ALIGN;
#line 2806
    uchar *xp = (uchar *) *xpp;
#line 2806

#line 2806
    if (rndup)
#line 2806
        rndup = X_ALIGN - rndup;
#line 2806

#line 2806
    while (nelems-- != 0) {
#line 2806
        
#line 2806
        *tp++ = (int)  (*xp++);  /* type cast from uchar to int */
#line 2806
    }
#line 2806

#line 2806
    *xpp = (void *)(xp + rndup);
#line 2806
    return status;
#line 2806
}
#line 2806

int
#line 2807
ncx_pad_getn_uchar_long(const void **xpp, size_t nelems, long *tp)
#line 2807
{
#line 2807
    int status = NC_NOERR;
#line 2807
    size_t rndup = nelems % X_ALIGN;
#line 2807
    uchar *xp = (uchar *) *xpp;
#line 2807

#line 2807
    if (rndup)
#line 2807
        rndup = X_ALIGN - rndup;
#line 2807

#line 2807
    while (nelems-- != 0) {
#line 2807
        
#line 2807
        *tp++ = (long)  (*xp++);  /* type cast from uchar to long */
#line 2807
    }
#line 2807

#line 2807
    *xpp = (void *)(xp + rndup);
#line 2807
    return status;
#line 2807
}
#line 2807

int
#line 2808
ncx_pad_getn_uchar_float(const void **xpp, size_t nelems, float *tp)
#line 2808
{
#line 2808
    int status = NC_NOERR;
#line 2808
    size_t rndup = nelems % X_ALIGN;
#line 2808
    uchar *xp = (uchar *) *xpp;
#line 2808

#line 2808
    if (rndup)
#line 2808
        rndup = X_ALIGN - rndup;
#line 2808

#line 2808
    while (nelems-- != 0) {
#line 2808
        
#line 2808
        *tp++ = (float)  (*xp++);  /* type cast from uchar to float */
#line 2808
    }
#line 2808

#line 2808
    *xpp = (void *)(xp + rndup);
#line 2808
    return status;
#line 2808
}
#line 2808

int
#line 2809
ncx_pad_getn_uchar_double(const void **xpp, size_t nelems, double *tp)
#line 2809
{
#line 2809
    int status = NC_NOERR;
#line 2809
    size_t rndup = nelems % X_ALIGN;
#line 2809
    uchar *xp = (uchar *) *xpp;
#line 2809

#line 2809
    if (rndup)
#line 2809
        rndup = X_ALIGN - rndup;
#line 2809

#line 2809
    while (nelems-- != 0) {
#line 2809
        
#line 2809
        *tp++ = (double)  (*xp++);  /* type cast from uchar to double */
#line 2809
    }
#line 2809

#line 2809
    *xpp = (void *)(xp + rndup);
#line 2809
    return status;
#line 2809
}
#line 2809

int
#line 2810
ncx_pad_getn_uchar_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 2810
{
#line 2810
    int status = NC_NOERR;
#line 2810
    size_t rndup = nelems % X_ALIGN;
#line 2810
    uchar *xp = (uchar *) *xpp;
#line 2810

#line 2810
    if (rndup)
#line 2810
        rndup = X_ALIGN - rndup;
#line 2810

#line 2810
    while (nelems-- != 0) {
#line 2810
        
#line 2810
        *tp++ = (longlong)  (*xp++);  /* type cast from uchar to longlong */
#line 2810
    }
#line 2810

#line 2810
    *xpp = (void *)(xp + rndup);
#line 2810
    return status;
#line 2810
}
#line 2810

int
#line 2811
ncx_pad_getn_uchar_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 2811
{
#line 2811
    int status = NC_NOERR;
#line 2811
    size_t rndup = nelems % X_ALIGN;
#line 2811
    uchar *xp = (uchar *) *xpp;
#line 2811

#line 2811
    if (rndup)
#line 2811
        rndup = X_ALIGN - rndup;
#line 2811

#line 2811
    while (nelems-- != 0) {
#line 2811
        
#line 2811
        *tp++ = (ushort)  (*xp++);  /* type cast from uchar to ushort */
#line 2811
    }
#line 2811

#line 2811
    *xpp = (void *)(xp + rndup);
#line 2811
    return status;
#line 2811
}
#line 2811

int
#line 2812
ncx_pad_getn_uchar_uint(const void **xpp, size_t nelems, uint *tp)
#line 2812
{
#line 2812
    int status = NC_NOERR;
#line 2812
    size_t rndup = nelems % X_ALIGN;
#line 2812
    uchar *xp = (uchar *) *xpp;
#line 2812

#line 2812
    if (rndup)
#line 2812
        rndup = X_ALIGN - rndup;
#line 2812

#line 2812
    while (nelems-- != 0) {
#line 2812
        
#line 2812
        *tp++ = (uint)  (*xp++);  /* type cast from uchar to uint */
#line 2812
    }
#line 2812

#line 2812
    *xpp = (void *)(xp + rndup);
#line 2812
    return status;
#line 2812
}
#line 2812

int
#line 2813
ncx_pad_getn_uchar_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 2813
{
#line 2813
    int status = NC_NOERR;
#line 2813
    size_t rndup = nelems % X_ALIGN;
#line 2813
    uchar *xp = (uchar *) *xpp;
#line 2813

#line 2813
    if (rndup)
#line 2813
        rndup = X_ALIGN - rndup;
#line 2813

#line 2813
    while (nelems-- != 0) {
#line 2813
        
#line 2813
        *tp++ = (ulonglong)  (*xp++);  /* type cast from uchar to ulonglong */
#line 2813
    }
#line 2813

#line 2813
    *xpp = (void *)(xp + rndup);
#line 2813
    return status;
#line 2813
}
#line 2813


#line 2816
int
ncx_putn_uchar_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
{
    int status = NC_NOERR;
    uchar *xp = (uchar *) *xpp;

    while (nelems-- != 0) {
        if (*tp < 0) {
            
#line 2824
#ifdef ERANGE_FILL
#line 2824
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2824
#endif
            status = NC_ERANGE;
            
#line 2826
#ifdef ERANGE_FILL
#line 2826
            xp++; tp++; continue;
#line 2826
#endif
        }
        *xp++ = (uchar) (signed) *tp++; /* type cast from schar to uchar */
    }

    *xpp = (void *)xp;
    return status;
}
#line 2835
int
ncx_putn_uchar_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
{
		(void) memcpy(*xpp, tp, (size_t)nelems);
#line 2838
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 2838

#line 2838
	return NC_NOERR;
#line 2838

}
int
#line 2840
ncx_putn_uchar_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 2840
{
#line 2840
    int status = NC_NOERR;
#line 2840
    uchar *xp = (uchar *) *xpp;
#line 2840

#line 2840
    while (nelems-- != 0) {
#line 2840
        if (*tp > (short)X_UCHAR_MAX || *tp < 0) {
#line 2840
            
#line 2840
#ifdef ERANGE_FILL
#line 2840
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2840
#endif
#line 2840
            status = NC_ERANGE;
#line 2840
            
#line 2840
#ifdef ERANGE_FILL
#line 2840
            xp++; tp++; continue;
#line 2840
#endif
#line 2840
        }
#line 2840
        *xp++ = (uchar) (signed) *tp++; /* type cast from short to uchar */
#line 2840
    }
#line 2840

#line 2840
    *xpp = (void *)xp;
#line 2840
    return status;
#line 2840
}
#line 2840

int
#line 2841
ncx_putn_uchar_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 2841
{
#line 2841
    int status = NC_NOERR;
#line 2841
    uchar *xp = (uchar *) *xpp;
#line 2841

#line 2841
    while (nelems-- != 0) {
#line 2841
        if (*tp > (int)X_UCHAR_MAX || *tp < 0) {
#line 2841
            
#line 2841
#ifdef ERANGE_FILL
#line 2841
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2841
#endif
#line 2841
            status = NC_ERANGE;
#line 2841
            
#line 2841
#ifdef ERANGE_FILL
#line 2841
            xp++; tp++; continue;
#line 2841
#endif
#line 2841
        }
#line 2841
        *xp++ = (uchar) (signed) *tp++; /* type cast from int to uchar */
#line 2841
    }
#line 2841

#line 2841
    *xpp = (void *)xp;
#line 2841
    return status;
#line 2841
}
#line 2841

int
#line 2842
ncx_putn_uchar_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 2842
{
#line 2842
    int status = NC_NOERR;
#line 2842
    uchar *xp = (uchar *) *xpp;
#line 2842

#line 2842
    while (nelems-- != 0) {
#line 2842
        if (*tp > (long)X_UCHAR_MAX || *tp < 0) {
#line 2842
            
#line 2842
#ifdef ERANGE_FILL
#line 2842
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2842
#endif
#line 2842
            status = NC_ERANGE;
#line 2842
            
#line 2842
#ifdef ERANGE_FILL
#line 2842
            xp++; tp++; continue;
#line 2842
#endif
#line 2842
        }
#line 2842
        *xp++ = (uchar) (signed) *tp++; /* type cast from long to uchar */
#line 2842
    }
#line 2842

#line 2842
    *xpp = (void *)xp;
#line 2842
    return status;
#line 2842
}
#line 2842

int
#line 2843
ncx_putn_uchar_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 2843
{
#line 2843
    int status = NC_NOERR;
#line 2843
    uchar *xp = (uchar *) *xpp;
#line 2843

#line 2843
    while (nelems-- != 0) {
#line 2843
        if (*tp > (float)X_UCHAR_MAX || *tp < 0) {
#line 2843
            
#line 2843
#ifdef ERANGE_FILL
#line 2843
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2843
#endif
#line 2843
            status = NC_ERANGE;
#line 2843
            
#line 2843
#ifdef ERANGE_FILL
#line 2843
            xp++; tp++; continue;
#line 2843
#endif
#line 2843
        }
#line 2843
        *xp++ = (uchar) (signed) *tp++; /* type cast from float to uchar */
#line 2843
    }
#line 2843

#line 2843
    *xpp = (void *)xp;
#line 2843
    return status;
#line 2843
}
#line 2843

int
#line 2844
ncx_putn_uchar_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 2844
{
#line 2844
    int status = NC_NOERR;
#line 2844
    uchar *xp = (uchar *) *xpp;
#line 2844

#line 2844
    while (nelems-- != 0) {
#line 2844
        if (*tp > (double)X_UCHAR_MAX || *tp < 0) {
#line 2844
            
#line 2844
#ifdef ERANGE_FILL
#line 2844
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2844
#endif
#line 2844
            status = NC_ERANGE;
#line 2844
            
#line 2844
#ifdef ERANGE_FILL
#line 2844
            xp++; tp++; continue;
#line 2844
#endif
#line 2844
        }
#line 2844
        *xp++ = (uchar) (signed) *tp++; /* type cast from double to uchar */
#line 2844
    }
#line 2844

#line 2844
    *xpp = (void *)xp;
#line 2844
    return status;
#line 2844
}
#line 2844

int
#line 2845
ncx_putn_uchar_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 2845
{
#line 2845
    int status = NC_NOERR;
#line 2845
    uchar *xp = (uchar *) *xpp;
#line 2845

#line 2845
    while (nelems-- != 0) {
#line 2845
        if (*tp > (longlong)X_UCHAR_MAX || *tp < 0) {
#line 2845
            
#line 2845
#ifdef ERANGE_FILL
#line 2845
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2845
#endif
#line 2845
            status = NC_ERANGE;
#line 2845
            
#line 2845
#ifdef ERANGE_FILL
#line 2845
            xp++; tp++; continue;
#line 2845
#endif
#line 2845
        }
#line 2845
        *xp++ = (uchar) (signed) *tp++; /* type cast from longlong to uchar */
#line 2845
    }
#line 2845

#line 2845
    *xpp = (void *)xp;
#line 2845
    return status;
#line 2845
}
#line 2845

int
#line 2846
ncx_putn_uchar_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 2846
{
#line 2846
    int status = NC_NOERR;
#line 2846
    uchar *xp = (uchar *) *xpp;
#line 2846

#line 2846
    while (nelems-- != 0) {
#line 2846
        if (*tp > (ushort)X_UCHAR_MAX ) {
#line 2846
            
#line 2846
#ifdef ERANGE_FILL
#line 2846
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2846
#endif
#line 2846
            status = NC_ERANGE;
#line 2846
            
#line 2846
#ifdef ERANGE_FILL
#line 2846
            xp++; tp++; continue;
#line 2846
#endif
#line 2846
        }
#line 2846
        *xp++ = (uchar)  *tp++; /* type cast from ushort to uchar */
#line 2846
    }
#line 2846

#line 2846
    *xpp = (void *)xp;
#line 2846
    return status;
#line 2846
}
#line 2846

int
#line 2847
ncx_putn_uchar_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 2847
{
#line 2847
    int status = NC_NOERR;
#line 2847
    uchar *xp = (uchar *) *xpp;
#line 2847

#line 2847
    while (nelems-- != 0) {
#line 2847
        if (*tp > (uint)X_UCHAR_MAX ) {
#line 2847
            
#line 2847
#ifdef ERANGE_FILL
#line 2847
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2847
#endif
#line 2847
            status = NC_ERANGE;
#line 2847
            
#line 2847
#ifdef ERANGE_FILL
#line 2847
            xp++; tp++; continue;
#line 2847
#endif
#line 2847
        }
#line 2847
        *xp++ = (uchar)  *tp++; /* type cast from uint to uchar */
#line 2847
    }
#line 2847

#line 2847
    *xpp = (void *)xp;
#line 2847
    return status;
#line 2847
}
#line 2847

int
#line 2848
ncx_putn_uchar_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 2848
{
#line 2848
    int status = NC_NOERR;
#line 2848
    uchar *xp = (uchar *) *xpp;
#line 2848

#line 2848
    while (nelems-- != 0) {
#line 2848
        if (*tp > (ulonglong)X_UCHAR_MAX ) {
#line 2848
            
#line 2848
#ifdef ERANGE_FILL
#line 2848
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2848
#endif
#line 2848
            status = NC_ERANGE;
#line 2848
            
#line 2848
#ifdef ERANGE_FILL
#line 2848
            xp++; tp++; continue;
#line 2848
#endif
#line 2848
        }
#line 2848
        *xp++ = (uchar)  *tp++; /* type cast from ulonglong to uchar */
#line 2848
    }
#line 2848

#line 2848
    *xpp = (void *)xp;
#line 2848
    return status;
#line 2848
}
#line 2848


#line 2851
int
ncx_pad_putn_uchar_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
{
    int status = NC_NOERR;
    size_t rndup = nelems % X_ALIGN;
    uchar *xp = (uchar *) *xpp;

    if (rndup) rndup = X_ALIGN - rndup;

    while (nelems-- != 0) {
        if (*tp < 0) {
            
#line 2862
#ifdef ERANGE_FILL
#line 2862
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2862
#endif
            status = NC_ERANGE;
            
#line 2864
#ifdef ERANGE_FILL
#line 2864
            xp++; tp++; continue;
#line 2864
#endif
        }
        *xp++ = (uchar) (signed) *tp++; /* type cast from schar to uchar */
    }

    if (rndup) {
        (void) memcpy(xp, nada, (size_t)rndup);
        xp += rndup;
    }

    *xpp = (void *)xp;
    return status;
}
#line 2878
int
ncx_pad_putn_uchar_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
{
		size_t rndup = nelems % X_ALIGN;
#line 2881

#line 2881
	if (rndup)
#line 2881
		rndup = X_ALIGN - rndup;
#line 2881

#line 2881
	(void) memcpy(*xpp, tp, (size_t)nelems);
#line 2881
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 2881

#line 2881
	if (rndup)
#line 2881
	{
#line 2881
		(void) memcpy(*xpp, nada, (size_t)rndup);
#line 2881
		*xpp = (void *)((char *)(*xpp) + rndup);
#line 2881
	}
#line 2881

#line 2881
	return NC_NOERR;
#line 2881

}
int
#line 2883
ncx_pad_putn_uchar_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 2883
{
#line 2883
    int status = NC_NOERR;
#line 2883
    size_t rndup = nelems % X_ALIGN;
#line 2883
    uchar *xp = (uchar *) *xpp;
#line 2883

#line 2883
    if (rndup) rndup = X_ALIGN - rndup;
#line 2883

#line 2883
    while (nelems-- != 0) {
#line 2883
        if (*tp > (short)X_UCHAR_MAX || *tp < 0) {
#line 2883
            
#line 2883
#ifdef ERANGE_FILL
#line 2883
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2883
#endif
#line 2883
            status = NC_ERANGE;
#line 2883
            
#line 2883
#ifdef ERANGE_FILL
#line 2883
            xp++; tp++; continue;
#line 2883
#endif
#line 2883
        }
#line 2883
        *xp++ = (uchar) (signed) *tp++; /* type cast from short to uchar */
#line 2883
    }
#line 2883

#line 2883

#line 2883
    if (rndup) {
#line 2883
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2883
        xp += rndup;
#line 2883
    }
#line 2883

#line 2883
    *xpp = (void *)xp;
#line 2883
    return status;
#line 2883
}
#line 2883

int
#line 2884
ncx_pad_putn_uchar_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 2884
{
#line 2884
    int status = NC_NOERR;
#line 2884
    size_t rndup = nelems % X_ALIGN;
#line 2884
    uchar *xp = (uchar *) *xpp;
#line 2884

#line 2884
    if (rndup) rndup = X_ALIGN - rndup;
#line 2884

#line 2884
    while (nelems-- != 0) {
#line 2884
        if (*tp > (int)X_UCHAR_MAX || *tp < 0) {
#line 2884
            
#line 2884
#ifdef ERANGE_FILL
#line 2884
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2884
#endif
#line 2884
            status = NC_ERANGE;
#line 2884
            
#line 2884
#ifdef ERANGE_FILL
#line 2884
            xp++; tp++; continue;
#line 2884
#endif
#line 2884
        }
#line 2884
        *xp++ = (uchar) (signed) *tp++; /* type cast from int to uchar */
#line 2884
    }
#line 2884

#line 2884

#line 2884
    if (rndup) {
#line 2884
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2884
        xp += rndup;
#line 2884
    }
#line 2884

#line 2884
    *xpp = (void *)xp;
#line 2884
    return status;
#line 2884
}
#line 2884

int
#line 2885
ncx_pad_putn_uchar_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 2885
{
#line 2885
    int status = NC_NOERR;
#line 2885
    size_t rndup = nelems % X_ALIGN;
#line 2885
    uchar *xp = (uchar *) *xpp;
#line 2885

#line 2885
    if (rndup) rndup = X_ALIGN - rndup;
#line 2885

#line 2885
    while (nelems-- != 0) {
#line 2885
        if (*tp > (long)X_UCHAR_MAX || *tp < 0) {
#line 2885
            
#line 2885
#ifdef ERANGE_FILL
#line 2885
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2885
#endif
#line 2885
            status = NC_ERANGE;
#line 2885
            
#line 2885
#ifdef ERANGE_FILL
#line 2885
            xp++; tp++; continue;
#line 2885
#endif
#line 2885
        }
#line 2885
        *xp++ = (uchar) (signed) *tp++; /* type cast from long to uchar */
#line 2885
    }
#line 2885

#line 2885

#line 2885
    if (rndup) {
#line 2885
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2885
        xp += rndup;
#line 2885
    }
#line 2885

#line 2885
    *xpp = (void *)xp;
#line 2885
    return status;
#line 2885
}
#line 2885

int
#line 2886
ncx_pad_putn_uchar_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 2886
{
#line 2886
    int status = NC_NOERR;
#line 2886
    size_t rndup = nelems % X_ALIGN;
#line 2886
    uchar *xp = (uchar *) *xpp;
#line 2886

#line 2886
    if (rndup) rndup = X_ALIGN - rndup;
#line 2886

#line 2886
    while (nelems-- != 0) {
#line 2886
        if (*tp > (float)X_UCHAR_MAX || *tp < 0) {
#line 2886
            
#line 2886
#ifdef ERANGE_FILL
#line 2886
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2886
#endif
#line 2886
            status = NC_ERANGE;
#line 2886
            
#line 2886
#ifdef ERANGE_FILL
#line 2886
            xp++; tp++; continue;
#line 2886
#endif
#line 2886
        }
#line 2886
        *xp++ = (uchar) (signed) *tp++; /* type cast from float to uchar */
#line 2886
    }
#line 2886

#line 2886

#line 2886
    if (rndup) {
#line 2886
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2886
        xp += rndup;
#line 2886
    }
#line 2886

#line 2886
    *xpp = (void *)xp;
#line 2886
    return status;
#line 2886
}
#line 2886

int
#line 2887
ncx_pad_putn_uchar_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 2887
{
#line 2887
    int status = NC_NOERR;
#line 2887
    size_t rndup = nelems % X_ALIGN;
#line 2887
    uchar *xp = (uchar *) *xpp;
#line 2887

#line 2887
    if (rndup) rndup = X_ALIGN - rndup;
#line 2887

#line 2887
    while (nelems-- != 0) {
#line 2887
        if (*tp > (double)X_UCHAR_MAX || *tp < 0) {
#line 2887
            
#line 2887
#ifdef ERANGE_FILL
#line 2887
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2887
#endif
#line 2887
            status = NC_ERANGE;
#line 2887
            
#line 2887
#ifdef ERANGE_FILL
#line 2887
            xp++; tp++; continue;
#line 2887
#endif
#line 2887
        }
#line 2887
        *xp++ = (uchar) (signed) *tp++; /* type cast from double to uchar */
#line 2887
    }
#line 2887

#line 2887

#line 2887
    if (rndup) {
#line 2887
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2887
        xp += rndup;
#line 2887
    }
#line 2887

#line 2887
    *xpp = (void *)xp;
#line 2887
    return status;
#line 2887
}
#line 2887

int
#line 2888
ncx_pad_putn_uchar_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 2888
{
#line 2888
    int status = NC_NOERR;
#line 2888
    size_t rndup = nelems % X_ALIGN;
#line 2888
    uchar *xp = (uchar *) *xpp;
#line 2888

#line 2888
    if (rndup) rndup = X_ALIGN - rndup;
#line 2888

#line 2888
    while (nelems-- != 0) {
#line 2888
        if (*tp > (longlong)X_UCHAR_MAX || *tp < 0) {
#line 2888
            
#line 2888
#ifdef ERANGE_FILL
#line 2888
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2888
#endif
#line 2888
            status = NC_ERANGE;
#line 2888
            
#line 2888
#ifdef ERANGE_FILL
#line 2888
            xp++; tp++; continue;
#line 2888
#endif
#line 2888
        }
#line 2888
        *xp++ = (uchar) (signed) *tp++; /* type cast from longlong to uchar */
#line 2888
    }
#line 2888

#line 2888

#line 2888
    if (rndup) {
#line 2888
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2888
        xp += rndup;
#line 2888
    }
#line 2888

#line 2888
    *xpp = (void *)xp;
#line 2888
    return status;
#line 2888
}
#line 2888

int
#line 2889
ncx_pad_putn_uchar_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 2889
{
#line 2889
    int status = NC_NOERR;
#line 2889
    size_t rndup = nelems % X_ALIGN;
#line 2889
    uchar *xp = (uchar *) *xpp;
#line 2889

#line 2889
    if (rndup) rndup = X_ALIGN - rndup;
#line 2889

#line 2889
    while (nelems-- != 0) {
#line 2889
        if (*tp > (ushort)X_UCHAR_MAX ) {
#line 2889
            
#line 2889
#ifdef ERANGE_FILL
#line 2889
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2889
#endif
#line 2889
            status = NC_ERANGE;
#line 2889
            
#line 2889
#ifdef ERANGE_FILL
#line 2889
            xp++; tp++; continue;
#line 2889
#endif
#line 2889
        }
#line 2889
        *xp++ = (uchar)  *tp++; /* type cast from ushort to uchar */
#line 2889
    }
#line 2889

#line 2889

#line 2889
    if (rndup) {
#line 2889
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2889
        xp += rndup;
#line 2889
    }
#line 2889

#line 2889
    *xpp = (void *)xp;
#line 2889
    return status;
#line 2889
}
#line 2889

int
#line 2890
ncx_pad_putn_uchar_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 2890
{
#line 2890
    int status = NC_NOERR;
#line 2890
    size_t rndup = nelems % X_ALIGN;
#line 2890
    uchar *xp = (uchar *) *xpp;
#line 2890

#line 2890
    if (rndup) rndup = X_ALIGN - rndup;
#line 2890

#line 2890
    while (nelems-- != 0) {
#line 2890
        if (*tp > (uint)X_UCHAR_MAX ) {
#line 2890
            
#line 2890
#ifdef ERANGE_FILL
#line 2890
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2890
#endif
#line 2890
            status = NC_ERANGE;
#line 2890
            
#line 2890
#ifdef ERANGE_FILL
#line 2890
            xp++; tp++; continue;
#line 2890
#endif
#line 2890
        }
#line 2890
        *xp++ = (uchar)  *tp++; /* type cast from uint to uchar */
#line 2890
    }
#line 2890

#line 2890

#line 2890
    if (rndup) {
#line 2890
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2890
        xp += rndup;
#line 2890
    }
#line 2890

#line 2890
    *xpp = (void *)xp;
#line 2890
    return status;
#line 2890
}
#line 2890

int
#line 2891
ncx_pad_putn_uchar_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 2891
{
#line 2891
    int status = NC_NOERR;
#line 2891
    size_t rndup = nelems % X_ALIGN;
#line 2891
    uchar *xp = (uchar *) *xpp;
#line 2891

#line 2891
    if (rndup) rndup = X_ALIGN - rndup;
#line 2891

#line 2891
    while (nelems-- != 0) {
#line 2891
        if (*tp > (ulonglong)X_UCHAR_MAX ) {
#line 2891
            
#line 2891
#ifdef ERANGE_FILL
#line 2891
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2891
#endif
#line 2891
            status = NC_ERANGE;
#line 2891
            
#line 2891
#ifdef ERANGE_FILL
#line 2891
            xp++; tp++; continue;
#line 2891
#endif
#line 2891
        }
#line 2891
        *xp++ = (uchar)  *tp++; /* type cast from ulonglong to uchar */
#line 2891
    }
#line 2891

#line 2891

#line 2891
    if (rndup) {
#line 2891
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2891
        xp += rndup;
#line 2891
    }
#line 2891

#line 2891
    *xpp = (void *)xp;
#line 2891
    return status;
#line 2891
}
#line 2891


/* short ---------------------------------------------------------------------*/

#if X_SIZEOF_SHORT == SIZEOF_SHORT
/* optimized version */
int
ncx_getn_short_short(const void **xpp, size_t nelems, short *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_SHORT);
# else
	swapn2b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_SHORT);
	return NC_NOERR;
}
#else
int
#line 2909
ncx_getn_short_short(const void **xpp, size_t nelems, short *tp)
#line 2909
{
#line 2909
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2909

#line 2909
 /* basic algorithm is:
#line 2909
  *   - ensure sane alignment of input data
#line 2909
  *   - copy (conversion happens automatically) input data
#line 2909
  *     to output
#line 2909
  *   - update xpp to point at next unconverted input, and tp to point
#line 2909
  *     at next location for converted output
#line 2909
  */
#line 2909
  long i, j, ni;
#line 2909
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2909
  short *xp;
#line 2909
  int nrange = 0;         /* number of range errors */
#line 2909
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2909
  long cxp = (long) *((char**)xpp);
#line 2909

#line 2909
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2909
  /* sjl: manually stripmine so we can limit amount of
#line 2909
   * vector work space reserved to LOOPCNT elements. Also
#line 2909
   * makes vectorisation easy */
#line 2909
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2909
    ni=Min(nelems-j,LOOPCNT);
#line 2909
    if (realign) {
#line 2909
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 2909
      xp = tmp;
#line 2909
    } else {
#line 2909
      xp = (short *) *xpp;
#line 2909
    }
#line 2909
   /* copy the next block */
#line 2909
#pragma cdir loopcnt=LOOPCNT
#line 2909
#pragma cdir shortloop
#line 2909
    for (i=0; i<ni; i++) {
#line 2909
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 2909
     /* test for range errors (not always needed but do it anyway) */
#line 2909
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2909
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2909
      nrange += xp[i] > SHORT_MAX || xp[i] < SHORT_MIN;
#line 2909
    }
#line 2909
   /* update xpp and tp */
#line 2909
    if (realign) xp = (short *) *xpp;
#line 2909
    xp += ni;
#line 2909
    tp += ni;
#line 2909
    *xpp = (void*)xp;
#line 2909
  }
#line 2909
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2909

#line 2909
#else   /* not SX */
#line 2909
	const char *xp = (const char *) *xpp;
#line 2909
	int status = NC_NOERR;
#line 2909

#line 2909
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2909
	{
#line 2909
		const int lstatus = ncx_get_short_short(xp, tp);
#line 2909
		if (status == NC_NOERR) /* report the first encountered error */
#line 2909
			status = lstatus;
#line 2909
	}
#line 2909

#line 2909
	*xpp = (const void *)xp;
#line 2909
	return status;
#line 2909
#endif
#line 2909
}
#line 2909

#endif
int
#line 2911
ncx_getn_short_schar(const void **xpp, size_t nelems, schar *tp)
#line 2911
{
#line 2911
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2911

#line 2911
 /* basic algorithm is:
#line 2911
  *   - ensure sane alignment of input data
#line 2911
  *   - copy (conversion happens automatically) input data
#line 2911
  *     to output
#line 2911
  *   - update xpp to point at next unconverted input, and tp to point
#line 2911
  *     at next location for converted output
#line 2911
  */
#line 2911
  long i, j, ni;
#line 2911
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2911
  short *xp;
#line 2911
  int nrange = 0;         /* number of range errors */
#line 2911
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2911
  long cxp = (long) *((char**)xpp);
#line 2911

#line 2911
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2911
  /* sjl: manually stripmine so we can limit amount of
#line 2911
   * vector work space reserved to LOOPCNT elements. Also
#line 2911
   * makes vectorisation easy */
#line 2911
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2911
    ni=Min(nelems-j,LOOPCNT);
#line 2911
    if (realign) {
#line 2911
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 2911
      xp = tmp;
#line 2911
    } else {
#line 2911
      xp = (short *) *xpp;
#line 2911
    }
#line 2911
   /* copy the next block */
#line 2911
#pragma cdir loopcnt=LOOPCNT
#line 2911
#pragma cdir shortloop
#line 2911
    for (i=0; i<ni; i++) {
#line 2911
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 2911
     /* test for range errors (not always needed but do it anyway) */
#line 2911
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2911
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2911
      nrange += xp[i] > SCHAR_MAX || xp[i] < SCHAR_MIN;
#line 2911
    }
#line 2911
   /* update xpp and tp */
#line 2911
    if (realign) xp = (short *) *xpp;
#line 2911
    xp += ni;
#line 2911
    tp += ni;
#line 2911
    *xpp = (void*)xp;
#line 2911
  }
#line 2911
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2911

#line 2911
#else   /* not SX */
#line 2911
	const char *xp = (const char *) *xpp;
#line 2911
	int status = NC_NOERR;
#line 2911

#line 2911
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2911
	{
#line 2911
		const int lstatus = ncx_get_short_schar(xp, tp);
#line 2911
		if (status == NC_NOERR) /* report the first encountered error */
#line 2911
			status = lstatus;
#line 2911
	}
#line 2911

#line 2911
	*xpp = (const void *)xp;
#line 2911
	return status;
#line 2911
#endif
#line 2911
}
#line 2911

int
#line 2912
ncx_getn_short_int(const void **xpp, size_t nelems, int *tp)
#line 2912
{
#line 2912
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2912

#line 2912
 /* basic algorithm is:
#line 2912
  *   - ensure sane alignment of input data
#line 2912
  *   - copy (conversion happens automatically) input data
#line 2912
  *     to output
#line 2912
  *   - update xpp to point at next unconverted input, and tp to point
#line 2912
  *     at next location for converted output
#line 2912
  */
#line 2912
  long i, j, ni;
#line 2912
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2912
  short *xp;
#line 2912
  int nrange = 0;         /* number of range errors */
#line 2912
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2912
  long cxp = (long) *((char**)xpp);
#line 2912

#line 2912
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2912
  /* sjl: manually stripmine so we can limit amount of
#line 2912
   * vector work space reserved to LOOPCNT elements. Also
#line 2912
   * makes vectorisation easy */
#line 2912
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2912
    ni=Min(nelems-j,LOOPCNT);
#line 2912
    if (realign) {
#line 2912
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 2912
      xp = tmp;
#line 2912
    } else {
#line 2912
      xp = (short *) *xpp;
#line 2912
    }
#line 2912
   /* copy the next block */
#line 2912
#pragma cdir loopcnt=LOOPCNT
#line 2912
#pragma cdir shortloop
#line 2912
    for (i=0; i<ni; i++) {
#line 2912
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 2912
     /* test for range errors (not always needed but do it anyway) */
#line 2912
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2912
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2912
      nrange += xp[i] > INT_MAX || xp[i] < INT_MIN;
#line 2912
    }
#line 2912
   /* update xpp and tp */
#line 2912
    if (realign) xp = (short *) *xpp;
#line 2912
    xp += ni;
#line 2912
    tp += ni;
#line 2912
    *xpp = (void*)xp;
#line 2912
  }
#line 2912
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2912

#line 2912
#else   /* not SX */
#line 2912
	const char *xp = (const char *) *xpp;
#line 2912
	int status = NC_NOERR;
#line 2912

#line 2912
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2912
	{
#line 2912
		const int lstatus = ncx_get_short_int(xp, tp);
#line 2912
		if (status == NC_NOERR) /* report the first encountered error */
#line 2912
			status = lstatus;
#line 2912
	}
#line 2912

#line 2912
	*xpp = (const void *)xp;
#line 2912
	return status;
#line 2912
#endif
#line 2912
}
#line 2912

int
#line 2913
ncx_getn_short_long(const void **xpp, size_t nelems, long *tp)
#line 2913
{
#line 2913
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2913

#line 2913
 /* basic algorithm is:
#line 2913
  *   - ensure sane alignment of input data
#line 2913
  *   - copy (conversion happens automatically) input data
#line 2913
  *     to output
#line 2913
  *   - update xpp to point at next unconverted input, and tp to point
#line 2913
  *     at next location for converted output
#line 2913
  */
#line 2913
  long i, j, ni;
#line 2913
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2913
  short *xp;
#line 2913
  int nrange = 0;         /* number of range errors */
#line 2913
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2913
  long cxp = (long) *((char**)xpp);
#line 2913

#line 2913
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2913
  /* sjl: manually stripmine so we can limit amount of
#line 2913
   * vector work space reserved to LOOPCNT elements. Also
#line 2913
   * makes vectorisation easy */
#line 2913
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2913
    ni=Min(nelems-j,LOOPCNT);
#line 2913
    if (realign) {
#line 2913
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 2913
      xp = tmp;
#line 2913
    } else {
#line 2913
      xp = (short *) *xpp;
#line 2913
    }
#line 2913
   /* copy the next block */
#line 2913
#pragma cdir loopcnt=LOOPCNT
#line 2913
#pragma cdir shortloop
#line 2913
    for (i=0; i<ni; i++) {
#line 2913
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 2913
     /* test for range errors (not always needed but do it anyway) */
#line 2913
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2913
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2913
      nrange += xp[i] > LONG_MAX || xp[i] < LONG_MIN;
#line 2913
    }
#line 2913
   /* update xpp and tp */
#line 2913
    if (realign) xp = (short *) *xpp;
#line 2913
    xp += ni;
#line 2913
    tp += ni;
#line 2913
    *xpp = (void*)xp;
#line 2913
  }
#line 2913
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2913

#line 2913
#else   /* not SX */
#line 2913
	const char *xp = (const char *) *xpp;
#line 2913
	int status = NC_NOERR;
#line 2913

#line 2913
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2913
	{
#line 2913
		const int lstatus = ncx_get_short_long(xp, tp);
#line 2913
		if (status == NC_NOERR) /* report the first encountered error */
#line 2913
			status = lstatus;
#line 2913
	}
#line 2913

#line 2913
	*xpp = (const void *)xp;
#line 2913
	return status;
#line 2913
#endif
#line 2913
}
#line 2913

int
#line 2914
ncx_getn_short_float(const void **xpp, size_t nelems, float *tp)
#line 2914
{
#line 2914
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2914

#line 2914
 /* basic algorithm is:
#line 2914
  *   - ensure sane alignment of input data
#line 2914
  *   - copy (conversion happens automatically) input data
#line 2914
  *     to output
#line 2914
  *   - update xpp to point at next unconverted input, and tp to point
#line 2914
  *     at next location for converted output
#line 2914
  */
#line 2914
  long i, j, ni;
#line 2914
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2914
  short *xp;
#line 2914
  int nrange = 0;         /* number of range errors */
#line 2914
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2914
  long cxp = (long) *((char**)xpp);
#line 2914

#line 2914
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2914
  /* sjl: manually stripmine so we can limit amount of
#line 2914
   * vector work space reserved to LOOPCNT elements. Also
#line 2914
   * makes vectorisation easy */
#line 2914
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2914
    ni=Min(nelems-j,LOOPCNT);
#line 2914
    if (realign) {
#line 2914
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 2914
      xp = tmp;
#line 2914
    } else {
#line 2914
      xp = (short *) *xpp;
#line 2914
    }
#line 2914
   /* copy the next block */
#line 2914
#pragma cdir loopcnt=LOOPCNT
#line 2914
#pragma cdir shortloop
#line 2914
    for (i=0; i<ni; i++) {
#line 2914
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 2914
     /* test for range errors (not always needed but do it anyway) */
#line 2914
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2914
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2914
      nrange += xp[i] > FLOAT_MAX || xp[i] < FLOAT_MIN;
#line 2914
    }
#line 2914
   /* update xpp and tp */
#line 2914
    if (realign) xp = (short *) *xpp;
#line 2914
    xp += ni;
#line 2914
    tp += ni;
#line 2914
    *xpp = (void*)xp;
#line 2914
  }
#line 2914
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2914

#line 2914
#else   /* not SX */
#line 2914
	const char *xp = (const char *) *xpp;
#line 2914
	int status = NC_NOERR;
#line 2914

#line 2914
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2914
	{
#line 2914
		const int lstatus = ncx_get_short_float(xp, tp);
#line 2914
		if (status == NC_NOERR) /* report the first encountered error */
#line 2914
			status = lstatus;
#line 2914
	}
#line 2914

#line 2914
	*xpp = (const void *)xp;
#line 2914
	return status;
#line 2914
#endif
#line 2914
}
#line 2914

int
#line 2915
ncx_getn_short_double(const void **xpp, size_t nelems, double *tp)
#line 2915
{
#line 2915
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2915

#line 2915
 /* basic algorithm is:
#line 2915
  *   - ensure sane alignment of input data
#line 2915
  *   - copy (conversion happens automatically) input data
#line 2915
  *     to output
#line 2915
  *   - update xpp to point at next unconverted input, and tp to point
#line 2915
  *     at next location for converted output
#line 2915
  */
#line 2915
  long i, j, ni;
#line 2915
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2915
  short *xp;
#line 2915
  int nrange = 0;         /* number of range errors */
#line 2915
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2915
  long cxp = (long) *((char**)xpp);
#line 2915

#line 2915
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2915
  /* sjl: manually stripmine so we can limit amount of
#line 2915
   * vector work space reserved to LOOPCNT elements. Also
#line 2915
   * makes vectorisation easy */
#line 2915
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2915
    ni=Min(nelems-j,LOOPCNT);
#line 2915
    if (realign) {
#line 2915
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 2915
      xp = tmp;
#line 2915
    } else {
#line 2915
      xp = (short *) *xpp;
#line 2915
    }
#line 2915
   /* copy the next block */
#line 2915
#pragma cdir loopcnt=LOOPCNT
#line 2915
#pragma cdir shortloop
#line 2915
    for (i=0; i<ni; i++) {
#line 2915
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 2915
     /* test for range errors (not always needed but do it anyway) */
#line 2915
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2915
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2915
      nrange += xp[i] > DOUBLE_MAX || xp[i] < DOUBLE_MIN;
#line 2915
    }
#line 2915
   /* update xpp and tp */
#line 2915
    if (realign) xp = (short *) *xpp;
#line 2915
    xp += ni;
#line 2915
    tp += ni;
#line 2915
    *xpp = (void*)xp;
#line 2915
  }
#line 2915
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2915

#line 2915
#else   /* not SX */
#line 2915
	const char *xp = (const char *) *xpp;
#line 2915
	int status = NC_NOERR;
#line 2915

#line 2915
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2915
	{
#line 2915
		const int lstatus = ncx_get_short_double(xp, tp);
#line 2915
		if (status == NC_NOERR) /* report the first encountered error */
#line 2915
			status = lstatus;
#line 2915
	}
#line 2915

#line 2915
	*xpp = (const void *)xp;
#line 2915
	return status;
#line 2915
#endif
#line 2915
}
#line 2915

int
#line 2916
ncx_getn_short_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 2916
{
#line 2916
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2916

#line 2916
 /* basic algorithm is:
#line 2916
  *   - ensure sane alignment of input data
#line 2916
  *   - copy (conversion happens automatically) input data
#line 2916
  *     to output
#line 2916
  *   - update xpp to point at next unconverted input, and tp to point
#line 2916
  *     at next location for converted output
#line 2916
  */
#line 2916
  long i, j, ni;
#line 2916
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2916
  short *xp;
#line 2916
  int nrange = 0;         /* number of range errors */
#line 2916
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2916
  long cxp = (long) *((char**)xpp);
#line 2916

#line 2916
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2916
  /* sjl: manually stripmine so we can limit amount of
#line 2916
   * vector work space reserved to LOOPCNT elements. Also
#line 2916
   * makes vectorisation easy */
#line 2916
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2916
    ni=Min(nelems-j,LOOPCNT);
#line 2916
    if (realign) {
#line 2916
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 2916
      xp = tmp;
#line 2916
    } else {
#line 2916
      xp = (short *) *xpp;
#line 2916
    }
#line 2916
   /* copy the next block */
#line 2916
#pragma cdir loopcnt=LOOPCNT
#line 2916
#pragma cdir shortloop
#line 2916
    for (i=0; i<ni; i++) {
#line 2916
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 2916
     /* test for range errors (not always needed but do it anyway) */
#line 2916
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2916
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2916
      nrange += xp[i] > LONGLONG_MAX || xp[i] < LONGLONG_MIN;
#line 2916
    }
#line 2916
   /* update xpp and tp */
#line 2916
    if (realign) xp = (short *) *xpp;
#line 2916
    xp += ni;
#line 2916
    tp += ni;
#line 2916
    *xpp = (void*)xp;
#line 2916
  }
#line 2916
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2916

#line 2916
#else   /* not SX */
#line 2916
	const char *xp = (const char *) *xpp;
#line 2916
	int status = NC_NOERR;
#line 2916

#line 2916
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2916
	{
#line 2916
		const int lstatus = ncx_get_short_longlong(xp, tp);
#line 2916
		if (status == NC_NOERR) /* report the first encountered error */
#line 2916
			status = lstatus;
#line 2916
	}
#line 2916

#line 2916
	*xpp = (const void *)xp;
#line 2916
	return status;
#line 2916
#endif
#line 2916
}
#line 2916

int
#line 2917
ncx_getn_short_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 2917
{
#line 2917
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2917

#line 2917
 /* basic algorithm is:
#line 2917
  *   - ensure sane alignment of input data
#line 2917
  *   - copy (conversion happens automatically) input data
#line 2917
  *     to output
#line 2917
  *   - update xpp to point at next unconverted input, and tp to point
#line 2917
  *     at next location for converted output
#line 2917
  */
#line 2917
  long i, j, ni;
#line 2917
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2917
  short *xp;
#line 2917
  int nrange = 0;         /* number of range errors */
#line 2917
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2917
  long cxp = (long) *((char**)xpp);
#line 2917

#line 2917
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2917
  /* sjl: manually stripmine so we can limit amount of
#line 2917
   * vector work space reserved to LOOPCNT elements. Also
#line 2917
   * makes vectorisation easy */
#line 2917
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2917
    ni=Min(nelems-j,LOOPCNT);
#line 2917
    if (realign) {
#line 2917
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 2917
      xp = tmp;
#line 2917
    } else {
#line 2917
      xp = (short *) *xpp;
#line 2917
    }
#line 2917
   /* copy the next block */
#line 2917
#pragma cdir loopcnt=LOOPCNT
#line 2917
#pragma cdir shortloop
#line 2917
    for (i=0; i<ni; i++) {
#line 2917
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 2917
     /* test for range errors (not always needed but do it anyway) */
#line 2917
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2917
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2917
      nrange += xp[i] > UCHAR_MAX || xp[i] < 0;
#line 2917
    }
#line 2917
   /* update xpp and tp */
#line 2917
    if (realign) xp = (short *) *xpp;
#line 2917
    xp += ni;
#line 2917
    tp += ni;
#line 2917
    *xpp = (void*)xp;
#line 2917
  }
#line 2917
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2917

#line 2917
#else   /* not SX */
#line 2917
	const char *xp = (const char *) *xpp;
#line 2917
	int status = NC_NOERR;
#line 2917

#line 2917
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2917
	{
#line 2917
		const int lstatus = ncx_get_short_uchar(xp, tp);
#line 2917
		if (status == NC_NOERR) /* report the first encountered error */
#line 2917
			status = lstatus;
#line 2917
	}
#line 2917

#line 2917
	*xpp = (const void *)xp;
#line 2917
	return status;
#line 2917
#endif
#line 2917
}
#line 2917

int
#line 2918
ncx_getn_short_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 2918
{
#line 2918
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2918

#line 2918
 /* basic algorithm is:
#line 2918
  *   - ensure sane alignment of input data
#line 2918
  *   - copy (conversion happens automatically) input data
#line 2918
  *     to output
#line 2918
  *   - update xpp to point at next unconverted input, and tp to point
#line 2918
  *     at next location for converted output
#line 2918
  */
#line 2918
  long i, j, ni;
#line 2918
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2918
  short *xp;
#line 2918
  int nrange = 0;         /* number of range errors */
#line 2918
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2918
  long cxp = (long) *((char**)xpp);
#line 2918

#line 2918
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2918
  /* sjl: manually stripmine so we can limit amount of
#line 2918
   * vector work space reserved to LOOPCNT elements. Also
#line 2918
   * makes vectorisation easy */
#line 2918
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2918
    ni=Min(nelems-j,LOOPCNT);
#line 2918
    if (realign) {
#line 2918
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 2918
      xp = tmp;
#line 2918
    } else {
#line 2918
      xp = (short *) *xpp;
#line 2918
    }
#line 2918
   /* copy the next block */
#line 2918
#pragma cdir loopcnt=LOOPCNT
#line 2918
#pragma cdir shortloop
#line 2918
    for (i=0; i<ni; i++) {
#line 2918
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 2918
     /* test for range errors (not always needed but do it anyway) */
#line 2918
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2918
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2918
      nrange += xp[i] > USHORT_MAX || xp[i] < 0;
#line 2918
    }
#line 2918
   /* update xpp and tp */
#line 2918
    if (realign) xp = (short *) *xpp;
#line 2918
    xp += ni;
#line 2918
    tp += ni;
#line 2918
    *xpp = (void*)xp;
#line 2918
  }
#line 2918
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2918

#line 2918
#else   /* not SX */
#line 2918
	const char *xp = (const char *) *xpp;
#line 2918
	int status = NC_NOERR;
#line 2918

#line 2918
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2918
	{
#line 2918
		const int lstatus = ncx_get_short_ushort(xp, tp);
#line 2918
		if (status == NC_NOERR) /* report the first encountered error */
#line 2918
			status = lstatus;
#line 2918
	}
#line 2918

#line 2918
	*xpp = (const void *)xp;
#line 2918
	return status;
#line 2918
#endif
#line 2918
}
#line 2918

int
#line 2919
ncx_getn_short_uint(const void **xpp, size_t nelems, uint *tp)
#line 2919
{
#line 2919
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2919

#line 2919
 /* basic algorithm is:
#line 2919
  *   - ensure sane alignment of input data
#line 2919
  *   - copy (conversion happens automatically) input data
#line 2919
  *     to output
#line 2919
  *   - update xpp to point at next unconverted input, and tp to point
#line 2919
  *     at next location for converted output
#line 2919
  */
#line 2919
  long i, j, ni;
#line 2919
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2919
  short *xp;
#line 2919
  int nrange = 0;         /* number of range errors */
#line 2919
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2919
  long cxp = (long) *((char**)xpp);
#line 2919

#line 2919
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2919
  /* sjl: manually stripmine so we can limit amount of
#line 2919
   * vector work space reserved to LOOPCNT elements. Also
#line 2919
   * makes vectorisation easy */
#line 2919
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2919
    ni=Min(nelems-j,LOOPCNT);
#line 2919
    if (realign) {
#line 2919
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 2919
      xp = tmp;
#line 2919
    } else {
#line 2919
      xp = (short *) *xpp;
#line 2919
    }
#line 2919
   /* copy the next block */
#line 2919
#pragma cdir loopcnt=LOOPCNT
#line 2919
#pragma cdir shortloop
#line 2919
    for (i=0; i<ni; i++) {
#line 2919
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 2919
     /* test for range errors (not always needed but do it anyway) */
#line 2919
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2919
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2919
      nrange += xp[i] > UINT_MAX || xp[i] < 0;
#line 2919
    }
#line 2919
   /* update xpp and tp */
#line 2919
    if (realign) xp = (short *) *xpp;
#line 2919
    xp += ni;
#line 2919
    tp += ni;
#line 2919
    *xpp = (void*)xp;
#line 2919
  }
#line 2919
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2919

#line 2919
#else   /* not SX */
#line 2919
	const char *xp = (const char *) *xpp;
#line 2919
	int status = NC_NOERR;
#line 2919

#line 2919
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2919
	{
#line 2919
		const int lstatus = ncx_get_short_uint(xp, tp);
#line 2919
		if (status == NC_NOERR) /* report the first encountered error */
#line 2919
			status = lstatus;
#line 2919
	}
#line 2919

#line 2919
	*xpp = (const void *)xp;
#line 2919
	return status;
#line 2919
#endif
#line 2919
}
#line 2919

int
#line 2920
ncx_getn_short_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 2920
{
#line 2920
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2920

#line 2920
 /* basic algorithm is:
#line 2920
  *   - ensure sane alignment of input data
#line 2920
  *   - copy (conversion happens automatically) input data
#line 2920
  *     to output
#line 2920
  *   - update xpp to point at next unconverted input, and tp to point
#line 2920
  *     at next location for converted output
#line 2920
  */
#line 2920
  long i, j, ni;
#line 2920
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2920
  short *xp;
#line 2920
  int nrange = 0;         /* number of range errors */
#line 2920
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2920
  long cxp = (long) *((char**)xpp);
#line 2920

#line 2920
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2920
  /* sjl: manually stripmine so we can limit amount of
#line 2920
   * vector work space reserved to LOOPCNT elements. Also
#line 2920
   * makes vectorisation easy */
#line 2920
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2920
    ni=Min(nelems-j,LOOPCNT);
#line 2920
    if (realign) {
#line 2920
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 2920
      xp = tmp;
#line 2920
    } else {
#line 2920
      xp = (short *) *xpp;
#line 2920
    }
#line 2920
   /* copy the next block */
#line 2920
#pragma cdir loopcnt=LOOPCNT
#line 2920
#pragma cdir shortloop
#line 2920
    for (i=0; i<ni; i++) {
#line 2920
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 2920
     /* test for range errors (not always needed but do it anyway) */
#line 2920
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2920
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2920
      nrange += xp[i] > ULONGLONG_MAX || xp[i] < 0;
#line 2920
    }
#line 2920
   /* update xpp and tp */
#line 2920
    if (realign) xp = (short *) *xpp;
#line 2920
    xp += ni;
#line 2920
    tp += ni;
#line 2920
    *xpp = (void*)xp;
#line 2920
  }
#line 2920
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2920

#line 2920
#else   /* not SX */
#line 2920
	const char *xp = (const char *) *xpp;
#line 2920
	int status = NC_NOERR;
#line 2920

#line 2920
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2920
	{
#line 2920
		const int lstatus = ncx_get_short_ulonglong(xp, tp);
#line 2920
		if (status == NC_NOERR) /* report the first encountered error */
#line 2920
			status = lstatus;
#line 2920
	}
#line 2920

#line 2920
	*xpp = (const void *)xp;
#line 2920
	return status;
#line 2920
#endif
#line 2920
}
#line 2920


int
#line 2922
ncx_pad_getn_short_schar(const void **xpp, size_t nelems, schar *tp)
#line 2922
{
#line 2922
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2922

#line 2922
	const char *xp = (const char *) *xpp;
#line 2922
	int status = NC_NOERR;
#line 2922

#line 2922
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2922
	{
#line 2922
		const int lstatus = ncx_get_short_schar(xp, tp);
#line 2922
		if (status == NC_NOERR) /* report the first encountered error */
#line 2922
			status = lstatus;
#line 2922
	}
#line 2922

#line 2922
	if (rndup != 0)
#line 2922
		xp += X_SIZEOF_SHORT;
#line 2922

#line 2922
	*xpp = (void *)xp;
#line 2922
	return status;
#line 2922
}
#line 2922

int
#line 2923
ncx_pad_getn_short_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 2923
{
#line 2923
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2923

#line 2923
	const char *xp = (const char *) *xpp;
#line 2923
	int status = NC_NOERR;
#line 2923

#line 2923
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2923
	{
#line 2923
		const int lstatus = ncx_get_short_uchar(xp, tp);
#line 2923
		if (status == NC_NOERR) /* report the first encountered error */
#line 2923
			status = lstatus;
#line 2923
	}
#line 2923

#line 2923
	if (rndup != 0)
#line 2923
		xp += X_SIZEOF_SHORT;
#line 2923

#line 2923
	*xpp = (void *)xp;
#line 2923
	return status;
#line 2923
}
#line 2923

int
#line 2924
ncx_pad_getn_short_short(const void **xpp, size_t nelems, short *tp)
#line 2924
{
#line 2924
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2924

#line 2924
	const char *xp = (const char *) *xpp;
#line 2924
	int status = NC_NOERR;
#line 2924

#line 2924
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2924
	{
#line 2924
		const int lstatus = ncx_get_short_short(xp, tp);
#line 2924
		if (status == NC_NOERR) /* report the first encountered error */
#line 2924
			status = lstatus;
#line 2924
	}
#line 2924

#line 2924
	if (rndup != 0)
#line 2924
		xp += X_SIZEOF_SHORT;
#line 2924

#line 2924
	*xpp = (void *)xp;
#line 2924
	return status;
#line 2924
}
#line 2924

int
#line 2925
ncx_pad_getn_short_int(const void **xpp, size_t nelems, int *tp)
#line 2925
{
#line 2925
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2925

#line 2925
	const char *xp = (const char *) *xpp;
#line 2925
	int status = NC_NOERR;
#line 2925

#line 2925
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2925
	{
#line 2925
		const int lstatus = ncx_get_short_int(xp, tp);
#line 2925
		if (status == NC_NOERR) /* report the first encountered error */
#line 2925
			status = lstatus;
#line 2925
	}
#line 2925

#line 2925
	if (rndup != 0)
#line 2925
		xp += X_SIZEOF_SHORT;
#line 2925

#line 2925
	*xpp = (void *)xp;
#line 2925
	return status;
#line 2925
}
#line 2925

int
#line 2926
ncx_pad_getn_short_long(const void **xpp, size_t nelems, long *tp)
#line 2926
{
#line 2926
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2926

#line 2926
	const char *xp = (const char *) *xpp;
#line 2926
	int status = NC_NOERR;
#line 2926

#line 2926
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2926
	{
#line 2926
		const int lstatus = ncx_get_short_long(xp, tp);
#line 2926
		if (status == NC_NOERR) /* report the first encountered error */
#line 2926
			status = lstatus;
#line 2926
	}
#line 2926

#line 2926
	if (rndup != 0)
#line 2926
		xp += X_SIZEOF_SHORT;
#line 2926

#line 2926
	*xpp = (void *)xp;
#line 2926
	return status;
#line 2926
}
#line 2926

int
#line 2927
ncx_pad_getn_short_float(const void **xpp, size_t nelems, float *tp)
#line 2927
{
#line 2927
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2927

#line 2927
	const char *xp = (const char *) *xpp;
#line 2927
	int status = NC_NOERR;
#line 2927

#line 2927
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2927
	{
#line 2927
		const int lstatus = ncx_get_short_float(xp, tp);
#line 2927
		if (status == NC_NOERR) /* report the first encountered error */
#line 2927
			status = lstatus;
#line 2927
	}
#line 2927

#line 2927
	if (rndup != 0)
#line 2927
		xp += X_SIZEOF_SHORT;
#line 2927

#line 2927
	*xpp = (void *)xp;
#line 2927
	return status;
#line 2927
}
#line 2927

int
#line 2928
ncx_pad_getn_short_double(const void **xpp, size_t nelems, double *tp)
#line 2928
{
#line 2928
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2928

#line 2928
	const char *xp = (const char *) *xpp;
#line 2928
	int status = NC_NOERR;
#line 2928

#line 2928
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2928
	{
#line 2928
		const int lstatus = ncx_get_short_double(xp, tp);
#line 2928
		if (status == NC_NOERR) /* report the first encountered error */
#line 2928
			status = lstatus;
#line 2928
	}
#line 2928

#line 2928
	if (rndup != 0)
#line 2928
		xp += X_SIZEOF_SHORT;
#line 2928

#line 2928
	*xpp = (void *)xp;
#line 2928
	return status;
#line 2928
}
#line 2928

int
#line 2929
ncx_pad_getn_short_uint(const void **xpp, size_t nelems, uint *tp)
#line 2929
{
#line 2929
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2929

#line 2929
	const char *xp = (const char *) *xpp;
#line 2929
	int status = NC_NOERR;
#line 2929

#line 2929
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2929
	{
#line 2929
		const int lstatus = ncx_get_short_uint(xp, tp);
#line 2929
		if (status == NC_NOERR) /* report the first encountered error */
#line 2929
			status = lstatus;
#line 2929
	}
#line 2929

#line 2929
	if (rndup != 0)
#line 2929
		xp += X_SIZEOF_SHORT;
#line 2929

#line 2929
	*xpp = (void *)xp;
#line 2929
	return status;
#line 2929
}
#line 2929

int
#line 2930
ncx_pad_getn_short_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 2930
{
#line 2930
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2930

#line 2930
	const char *xp = (const char *) *xpp;
#line 2930
	int status = NC_NOERR;
#line 2930

#line 2930
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2930
	{
#line 2930
		const int lstatus = ncx_get_short_longlong(xp, tp);
#line 2930
		if (status == NC_NOERR) /* report the first encountered error */
#line 2930
			status = lstatus;
#line 2930
	}
#line 2930

#line 2930
	if (rndup != 0)
#line 2930
		xp += X_SIZEOF_SHORT;
#line 2930

#line 2930
	*xpp = (void *)xp;
#line 2930
	return status;
#line 2930
}
#line 2930

int
#line 2931
ncx_pad_getn_short_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 2931
{
#line 2931
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2931

#line 2931
	const char *xp = (const char *) *xpp;
#line 2931
	int status = NC_NOERR;
#line 2931

#line 2931
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2931
	{
#line 2931
		const int lstatus = ncx_get_short_ulonglong(xp, tp);
#line 2931
		if (status == NC_NOERR) /* report the first encountered error */
#line 2931
			status = lstatus;
#line 2931
	}
#line 2931

#line 2931
	if (rndup != 0)
#line 2931
		xp += X_SIZEOF_SHORT;
#line 2931

#line 2931
	*xpp = (void *)xp;
#line 2931
	return status;
#line 2931
}
#line 2931

int
#line 2932
ncx_pad_getn_short_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 2932
{
#line 2932
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2932

#line 2932
	const char *xp = (const char *) *xpp;
#line 2932
	int status = NC_NOERR;
#line 2932

#line 2932
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2932
	{
#line 2932
		const int lstatus = ncx_get_short_ushort(xp, tp);
#line 2932
		if (status == NC_NOERR) /* report the first encountered error */
#line 2932
			status = lstatus;
#line 2932
	}
#line 2932

#line 2932
	if (rndup != 0)
#line 2932
		xp += X_SIZEOF_SHORT;
#line 2932

#line 2932
	*xpp = (void *)xp;
#line 2932
	return status;
#line 2932
}
#line 2932


#if X_SIZEOF_SHORT == SIZEOF_SHORT
/* optimized version */
int
ncx_putn_short_short(void **xpp, size_t nelems, const short *tp, void *fillp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_SHORT);
# else
	swapn2b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_SHORT);
	return NC_NOERR;
}
#else
int
#line 2948
ncx_putn_short_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 2948
{
#line 2948
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2948

#line 2948
 /* basic algorithm is:
#line 2948
  *   - ensure sane alignment of output data
#line 2948
  *   - copy (conversion happens automatically) input data
#line 2948
  *     to output
#line 2948
  *   - update tp to point at next unconverted input, and xpp to point
#line 2948
  *     at next location for converted output
#line 2948
  */
#line 2948
  long i, j, ni;
#line 2948
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2948
  short *xp;
#line 2948
  int nrange = 0;         /* number of range errors */
#line 2948
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2948
  long cxp = (long) *((char**)xpp);
#line 2948

#line 2948
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2948
  /* sjl: manually stripmine so we can limit amount of
#line 2948
   * vector work space reserved to LOOPCNT elements. Also
#line 2948
   * makes vectorisation easy */
#line 2948
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2948
    ni=Min(nelems-j,LOOPCNT);
#line 2948
    if (realign) {
#line 2948
      xp = tmp;
#line 2948
    } else {
#line 2948
      xp = (short *) *xpp;
#line 2948
    }
#line 2948
   /* copy the next block */
#line 2948
#pragma cdir loopcnt=LOOPCNT
#line 2948
#pragma cdir shortloop
#line 2948
    for (i=0; i<ni; i++) {
#line 2948
      /* the normal case: */
#line 2948
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 2948
     /* test for range errors (not always needed but do it anyway) */
#line 2948
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2948
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2948
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 2948
    }
#line 2948
   /* copy workspace back if necessary */
#line 2948
    if (realign) {
#line 2948
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 2948
      xp = (short *) *xpp;
#line 2948
    }
#line 2948
   /* update xpp and tp */
#line 2948
    xp += ni;
#line 2948
    tp += ni;
#line 2948
    *xpp = (void*)xp;
#line 2948
  }
#line 2948
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2948

#line 2948
#else   /* not SX */
#line 2948

#line 2948
	char *xp = (char *) *xpp;
#line 2948
	int status = NC_NOERR;
#line 2948

#line 2948
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2948
	{
#line 2948
		int lstatus = ncx_put_short_short(xp, tp, fillp);
#line 2948
		if (status == NC_NOERR) /* report the first encountered error */
#line 2948
			status = lstatus;
#line 2948
	}
#line 2948

#line 2948
	*xpp = (void *)xp;
#line 2948
	return status;
#line 2948
#endif
#line 2948
}
#line 2948

#endif
int
#line 2950
ncx_putn_short_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 2950
{
#line 2950
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2950

#line 2950
 /* basic algorithm is:
#line 2950
  *   - ensure sane alignment of output data
#line 2950
  *   - copy (conversion happens automatically) input data
#line 2950
  *     to output
#line 2950
  *   - update tp to point at next unconverted input, and xpp to point
#line 2950
  *     at next location for converted output
#line 2950
  */
#line 2950
  long i, j, ni;
#line 2950
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2950
  short *xp;
#line 2950
  int nrange = 0;         /* number of range errors */
#line 2950
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2950
  long cxp = (long) *((char**)xpp);
#line 2950

#line 2950
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2950
  /* sjl: manually stripmine so we can limit amount of
#line 2950
   * vector work space reserved to LOOPCNT elements. Also
#line 2950
   * makes vectorisation easy */
#line 2950
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2950
    ni=Min(nelems-j,LOOPCNT);
#line 2950
    if (realign) {
#line 2950
      xp = tmp;
#line 2950
    } else {
#line 2950
      xp = (short *) *xpp;
#line 2950
    }
#line 2950
   /* copy the next block */
#line 2950
#pragma cdir loopcnt=LOOPCNT
#line 2950
#pragma cdir shortloop
#line 2950
    for (i=0; i<ni; i++) {
#line 2950
      /* the normal case: */
#line 2950
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 2950
     /* test for range errors (not always needed but do it anyway) */
#line 2950
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2950
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2950
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 2950
    }
#line 2950
   /* copy workspace back if necessary */
#line 2950
    if (realign) {
#line 2950
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 2950
      xp = (short *) *xpp;
#line 2950
    }
#line 2950
   /* update xpp and tp */
#line 2950
    xp += ni;
#line 2950
    tp += ni;
#line 2950
    *xpp = (void*)xp;
#line 2950
  }
#line 2950
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2950

#line 2950
#else   /* not SX */
#line 2950

#line 2950
	char *xp = (char *) *xpp;
#line 2950
	int status = NC_NOERR;
#line 2950

#line 2950
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2950
	{
#line 2950
		int lstatus = ncx_put_short_schar(xp, tp, fillp);
#line 2950
		if (status == NC_NOERR) /* report the first encountered error */
#line 2950
			status = lstatus;
#line 2950
	}
#line 2950

#line 2950
	*xpp = (void *)xp;
#line 2950
	return status;
#line 2950
#endif
#line 2950
}
#line 2950

int
#line 2951
ncx_putn_short_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 2951
{
#line 2951
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2951

#line 2951
 /* basic algorithm is:
#line 2951
  *   - ensure sane alignment of output data
#line 2951
  *   - copy (conversion happens automatically) input data
#line 2951
  *     to output
#line 2951
  *   - update tp to point at next unconverted input, and xpp to point
#line 2951
  *     at next location for converted output
#line 2951
  */
#line 2951
  long i, j, ni;
#line 2951
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2951
  short *xp;
#line 2951
  int nrange = 0;         /* number of range errors */
#line 2951
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2951
  long cxp = (long) *((char**)xpp);
#line 2951

#line 2951
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2951
  /* sjl: manually stripmine so we can limit amount of
#line 2951
   * vector work space reserved to LOOPCNT elements. Also
#line 2951
   * makes vectorisation easy */
#line 2951
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2951
    ni=Min(nelems-j,LOOPCNT);
#line 2951
    if (realign) {
#line 2951
      xp = tmp;
#line 2951
    } else {
#line 2951
      xp = (short *) *xpp;
#line 2951
    }
#line 2951
   /* copy the next block */
#line 2951
#pragma cdir loopcnt=LOOPCNT
#line 2951
#pragma cdir shortloop
#line 2951
    for (i=0; i<ni; i++) {
#line 2951
      /* the normal case: */
#line 2951
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 2951
     /* test for range errors (not always needed but do it anyway) */
#line 2951
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2951
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2951
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 2951
    }
#line 2951
   /* copy workspace back if necessary */
#line 2951
    if (realign) {
#line 2951
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 2951
      xp = (short *) *xpp;
#line 2951
    }
#line 2951
   /* update xpp and tp */
#line 2951
    xp += ni;
#line 2951
    tp += ni;
#line 2951
    *xpp = (void*)xp;
#line 2951
  }
#line 2951
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2951

#line 2951
#else   /* not SX */
#line 2951

#line 2951
	char *xp = (char *) *xpp;
#line 2951
	int status = NC_NOERR;
#line 2951

#line 2951
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2951
	{
#line 2951
		int lstatus = ncx_put_short_int(xp, tp, fillp);
#line 2951
		if (status == NC_NOERR) /* report the first encountered error */
#line 2951
			status = lstatus;
#line 2951
	}
#line 2951

#line 2951
	*xpp = (void *)xp;
#line 2951
	return status;
#line 2951
#endif
#line 2951
}
#line 2951

int
#line 2952
ncx_putn_short_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 2952
{
#line 2952
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2952

#line 2952
 /* basic algorithm is:
#line 2952
  *   - ensure sane alignment of output data
#line 2952
  *   - copy (conversion happens automatically) input data
#line 2952
  *     to output
#line 2952
  *   - update tp to point at next unconverted input, and xpp to point
#line 2952
  *     at next location for converted output
#line 2952
  */
#line 2952
  long i, j, ni;
#line 2952
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2952
  short *xp;
#line 2952
  int nrange = 0;         /* number of range errors */
#line 2952
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2952
  long cxp = (long) *((char**)xpp);
#line 2952

#line 2952
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2952
  /* sjl: manually stripmine so we can limit amount of
#line 2952
   * vector work space reserved to LOOPCNT elements. Also
#line 2952
   * makes vectorisation easy */
#line 2952
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2952
    ni=Min(nelems-j,LOOPCNT);
#line 2952
    if (realign) {
#line 2952
      xp = tmp;
#line 2952
    } else {
#line 2952
      xp = (short *) *xpp;
#line 2952
    }
#line 2952
   /* copy the next block */
#line 2952
#pragma cdir loopcnt=LOOPCNT
#line 2952
#pragma cdir shortloop
#line 2952
    for (i=0; i<ni; i++) {
#line 2952
      /* the normal case: */
#line 2952
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 2952
     /* test for range errors (not always needed but do it anyway) */
#line 2952
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2952
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2952
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 2952
    }
#line 2952
   /* copy workspace back if necessary */
#line 2952
    if (realign) {
#line 2952
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 2952
      xp = (short *) *xpp;
#line 2952
    }
#line 2952
   /* update xpp and tp */
#line 2952
    xp += ni;
#line 2952
    tp += ni;
#line 2952
    *xpp = (void*)xp;
#line 2952
  }
#line 2952
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2952

#line 2952
#else   /* not SX */
#line 2952

#line 2952
	char *xp = (char *) *xpp;
#line 2952
	int status = NC_NOERR;
#line 2952

#line 2952
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2952
	{
#line 2952
		int lstatus = ncx_put_short_long(xp, tp, fillp);
#line 2952
		if (status == NC_NOERR) /* report the first encountered error */
#line 2952
			status = lstatus;
#line 2952
	}
#line 2952

#line 2952
	*xpp = (void *)xp;
#line 2952
	return status;
#line 2952
#endif
#line 2952
}
#line 2952

int
#line 2953
ncx_putn_short_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 2953
{
#line 2953
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2953

#line 2953
 /* basic algorithm is:
#line 2953
  *   - ensure sane alignment of output data
#line 2953
  *   - copy (conversion happens automatically) input data
#line 2953
  *     to output
#line 2953
  *   - update tp to point at next unconverted input, and xpp to point
#line 2953
  *     at next location for converted output
#line 2953
  */
#line 2953
  long i, j, ni;
#line 2953
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2953
  short *xp;
#line 2953
  int nrange = 0;         /* number of range errors */
#line 2953
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2953
  long cxp = (long) *((char**)xpp);
#line 2953

#line 2953
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2953
  /* sjl: manually stripmine so we can limit amount of
#line 2953
   * vector work space reserved to LOOPCNT elements. Also
#line 2953
   * makes vectorisation easy */
#line 2953
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2953
    ni=Min(nelems-j,LOOPCNT);
#line 2953
    if (realign) {
#line 2953
      xp = tmp;
#line 2953
    } else {
#line 2953
      xp = (short *) *xpp;
#line 2953
    }
#line 2953
   /* copy the next block */
#line 2953
#pragma cdir loopcnt=LOOPCNT
#line 2953
#pragma cdir shortloop
#line 2953
    for (i=0; i<ni; i++) {
#line 2953
      /* the normal case: */
#line 2953
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 2953
     /* test for range errors (not always needed but do it anyway) */
#line 2953
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2953
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2953
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 2953
    }
#line 2953
   /* copy workspace back if necessary */
#line 2953
    if (realign) {
#line 2953
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 2953
      xp = (short *) *xpp;
#line 2953
    }
#line 2953
   /* update xpp and tp */
#line 2953
    xp += ni;
#line 2953
    tp += ni;
#line 2953
    *xpp = (void*)xp;
#line 2953
  }
#line 2953
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2953

#line 2953
#else   /* not SX */
#line 2953

#line 2953
	char *xp = (char *) *xpp;
#line 2953
	int status = NC_NOERR;
#line 2953

#line 2953
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2953
	{
#line 2953
		int lstatus = ncx_put_short_float(xp, tp, fillp);
#line 2953
		if (status == NC_NOERR) /* report the first encountered error */
#line 2953
			status = lstatus;
#line 2953
	}
#line 2953

#line 2953
	*xpp = (void *)xp;
#line 2953
	return status;
#line 2953
#endif
#line 2953
}
#line 2953

int
#line 2954
ncx_putn_short_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 2954
{
#line 2954
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2954

#line 2954
 /* basic algorithm is:
#line 2954
  *   - ensure sane alignment of output data
#line 2954
  *   - copy (conversion happens automatically) input data
#line 2954
  *     to output
#line 2954
  *   - update tp to point at next unconverted input, and xpp to point
#line 2954
  *     at next location for converted output
#line 2954
  */
#line 2954
  long i, j, ni;
#line 2954
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2954
  short *xp;
#line 2954
  int nrange = 0;         /* number of range errors */
#line 2954
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2954
  long cxp = (long) *((char**)xpp);
#line 2954

#line 2954
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2954
  /* sjl: manually stripmine so we can limit amount of
#line 2954
   * vector work space reserved to LOOPCNT elements. Also
#line 2954
   * makes vectorisation easy */
#line 2954
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2954
    ni=Min(nelems-j,LOOPCNT);
#line 2954
    if (realign) {
#line 2954
      xp = tmp;
#line 2954
    } else {
#line 2954
      xp = (short *) *xpp;
#line 2954
    }
#line 2954
   /* copy the next block */
#line 2954
#pragma cdir loopcnt=LOOPCNT
#line 2954
#pragma cdir shortloop
#line 2954
    for (i=0; i<ni; i++) {
#line 2954
      /* the normal case: */
#line 2954
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 2954
     /* test for range errors (not always needed but do it anyway) */
#line 2954
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2954
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2954
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 2954
    }
#line 2954
   /* copy workspace back if necessary */
#line 2954
    if (realign) {
#line 2954
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 2954
      xp = (short *) *xpp;
#line 2954
    }
#line 2954
   /* update xpp and tp */
#line 2954
    xp += ni;
#line 2954
    tp += ni;
#line 2954
    *xpp = (void*)xp;
#line 2954
  }
#line 2954
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2954

#line 2954
#else   /* not SX */
#line 2954

#line 2954
	char *xp = (char *) *xpp;
#line 2954
	int status = NC_NOERR;
#line 2954

#line 2954
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2954
	{
#line 2954
		int lstatus = ncx_put_short_double(xp, tp, fillp);
#line 2954
		if (status == NC_NOERR) /* report the first encountered error */
#line 2954
			status = lstatus;
#line 2954
	}
#line 2954

#line 2954
	*xpp = (void *)xp;
#line 2954
	return status;
#line 2954
#endif
#line 2954
}
#line 2954

int
#line 2955
ncx_putn_short_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 2955
{
#line 2955
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2955

#line 2955
 /* basic algorithm is:
#line 2955
  *   - ensure sane alignment of output data
#line 2955
  *   - copy (conversion happens automatically) input data
#line 2955
  *     to output
#line 2955
  *   - update tp to point at next unconverted input, and xpp to point
#line 2955
  *     at next location for converted output
#line 2955
  */
#line 2955
  long i, j, ni;
#line 2955
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2955
  short *xp;
#line 2955
  int nrange = 0;         /* number of range errors */
#line 2955
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2955
  long cxp = (long) *((char**)xpp);
#line 2955

#line 2955
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2955
  /* sjl: manually stripmine so we can limit amount of
#line 2955
   * vector work space reserved to LOOPCNT elements. Also
#line 2955
   * makes vectorisation easy */
#line 2955
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2955
    ni=Min(nelems-j,LOOPCNT);
#line 2955
    if (realign) {
#line 2955
      xp = tmp;
#line 2955
    } else {
#line 2955
      xp = (short *) *xpp;
#line 2955
    }
#line 2955
   /* copy the next block */
#line 2955
#pragma cdir loopcnt=LOOPCNT
#line 2955
#pragma cdir shortloop
#line 2955
    for (i=0; i<ni; i++) {
#line 2955
      /* the normal case: */
#line 2955
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 2955
     /* test for range errors (not always needed but do it anyway) */
#line 2955
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2955
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2955
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 2955
    }
#line 2955
   /* copy workspace back if necessary */
#line 2955
    if (realign) {
#line 2955
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 2955
      xp = (short *) *xpp;
#line 2955
    }
#line 2955
   /* update xpp and tp */
#line 2955
    xp += ni;
#line 2955
    tp += ni;
#line 2955
    *xpp = (void*)xp;
#line 2955
  }
#line 2955
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2955

#line 2955
#else   /* not SX */
#line 2955

#line 2955
	char *xp = (char *) *xpp;
#line 2955
	int status = NC_NOERR;
#line 2955

#line 2955
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2955
	{
#line 2955
		int lstatus = ncx_put_short_longlong(xp, tp, fillp);
#line 2955
		if (status == NC_NOERR) /* report the first encountered error */
#line 2955
			status = lstatus;
#line 2955
	}
#line 2955

#line 2955
	*xpp = (void *)xp;
#line 2955
	return status;
#line 2955
#endif
#line 2955
}
#line 2955

int
#line 2956
ncx_putn_short_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 2956
{
#line 2956
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2956

#line 2956
 /* basic algorithm is:
#line 2956
  *   - ensure sane alignment of output data
#line 2956
  *   - copy (conversion happens automatically) input data
#line 2956
  *     to output
#line 2956
  *   - update tp to point at next unconverted input, and xpp to point
#line 2956
  *     at next location for converted output
#line 2956
  */
#line 2956
  long i, j, ni;
#line 2956
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2956
  short *xp;
#line 2956
  int nrange = 0;         /* number of range errors */
#line 2956
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2956
  long cxp = (long) *((char**)xpp);
#line 2956

#line 2956
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2956
  /* sjl: manually stripmine so we can limit amount of
#line 2956
   * vector work space reserved to LOOPCNT elements. Also
#line 2956
   * makes vectorisation easy */
#line 2956
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2956
    ni=Min(nelems-j,LOOPCNT);
#line 2956
    if (realign) {
#line 2956
      xp = tmp;
#line 2956
    } else {
#line 2956
      xp = (short *) *xpp;
#line 2956
    }
#line 2956
   /* copy the next block */
#line 2956
#pragma cdir loopcnt=LOOPCNT
#line 2956
#pragma cdir shortloop
#line 2956
    for (i=0; i<ni; i++) {
#line 2956
      /* the normal case: */
#line 2956
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 2956
     /* test for range errors (not always needed but do it anyway) */
#line 2956
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2956
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2956
      nrange += tp[i] > X_SHORT_MAX ;
#line 2956
    }
#line 2956
   /* copy workspace back if necessary */
#line 2956
    if (realign) {
#line 2956
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 2956
      xp = (short *) *xpp;
#line 2956
    }
#line 2956
   /* update xpp and tp */
#line 2956
    xp += ni;
#line 2956
    tp += ni;
#line 2956
    *xpp = (void*)xp;
#line 2956
  }
#line 2956
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2956

#line 2956
#else   /* not SX */
#line 2956

#line 2956
	char *xp = (char *) *xpp;
#line 2956
	int status = NC_NOERR;
#line 2956

#line 2956
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2956
	{
#line 2956
		int lstatus = ncx_put_short_uchar(xp, tp, fillp);
#line 2956
		if (status == NC_NOERR) /* report the first encountered error */
#line 2956
			status = lstatus;
#line 2956
	}
#line 2956

#line 2956
	*xpp = (void *)xp;
#line 2956
	return status;
#line 2956
#endif
#line 2956
}
#line 2956

int
#line 2957
ncx_putn_short_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 2957
{
#line 2957
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2957

#line 2957
 /* basic algorithm is:
#line 2957
  *   - ensure sane alignment of output data
#line 2957
  *   - copy (conversion happens automatically) input data
#line 2957
  *     to output
#line 2957
  *   - update tp to point at next unconverted input, and xpp to point
#line 2957
  *     at next location for converted output
#line 2957
  */
#line 2957
  long i, j, ni;
#line 2957
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2957
  short *xp;
#line 2957
  int nrange = 0;         /* number of range errors */
#line 2957
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2957
  long cxp = (long) *((char**)xpp);
#line 2957

#line 2957
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2957
  /* sjl: manually stripmine so we can limit amount of
#line 2957
   * vector work space reserved to LOOPCNT elements. Also
#line 2957
   * makes vectorisation easy */
#line 2957
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2957
    ni=Min(nelems-j,LOOPCNT);
#line 2957
    if (realign) {
#line 2957
      xp = tmp;
#line 2957
    } else {
#line 2957
      xp = (short *) *xpp;
#line 2957
    }
#line 2957
   /* copy the next block */
#line 2957
#pragma cdir loopcnt=LOOPCNT
#line 2957
#pragma cdir shortloop
#line 2957
    for (i=0; i<ni; i++) {
#line 2957
      /* the normal case: */
#line 2957
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 2957
     /* test for range errors (not always needed but do it anyway) */
#line 2957
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2957
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2957
      nrange += tp[i] > X_SHORT_MAX ;
#line 2957
    }
#line 2957
   /* copy workspace back if necessary */
#line 2957
    if (realign) {
#line 2957
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 2957
      xp = (short *) *xpp;
#line 2957
    }
#line 2957
   /* update xpp and tp */
#line 2957
    xp += ni;
#line 2957
    tp += ni;
#line 2957
    *xpp = (void*)xp;
#line 2957
  }
#line 2957
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2957

#line 2957
#else   /* not SX */
#line 2957

#line 2957
	char *xp = (char *) *xpp;
#line 2957
	int status = NC_NOERR;
#line 2957

#line 2957
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2957
	{
#line 2957
		int lstatus = ncx_put_short_uint(xp, tp, fillp);
#line 2957
		if (status == NC_NOERR) /* report the first encountered error */
#line 2957
			status = lstatus;
#line 2957
	}
#line 2957

#line 2957
	*xpp = (void *)xp;
#line 2957
	return status;
#line 2957
#endif
#line 2957
}
#line 2957

int
#line 2958
ncx_putn_short_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 2958
{
#line 2958
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2958

#line 2958
 /* basic algorithm is:
#line 2958
  *   - ensure sane alignment of output data
#line 2958
  *   - copy (conversion happens automatically) input data
#line 2958
  *     to output
#line 2958
  *   - update tp to point at next unconverted input, and xpp to point
#line 2958
  *     at next location for converted output
#line 2958
  */
#line 2958
  long i, j, ni;
#line 2958
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2958
  short *xp;
#line 2958
  int nrange = 0;         /* number of range errors */
#line 2958
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2958
  long cxp = (long) *((char**)xpp);
#line 2958

#line 2958
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2958
  /* sjl: manually stripmine so we can limit amount of
#line 2958
   * vector work space reserved to LOOPCNT elements. Also
#line 2958
   * makes vectorisation easy */
#line 2958
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2958
    ni=Min(nelems-j,LOOPCNT);
#line 2958
    if (realign) {
#line 2958
      xp = tmp;
#line 2958
    } else {
#line 2958
      xp = (short *) *xpp;
#line 2958
    }
#line 2958
   /* copy the next block */
#line 2958
#pragma cdir loopcnt=LOOPCNT
#line 2958
#pragma cdir shortloop
#line 2958
    for (i=0; i<ni; i++) {
#line 2958
      /* the normal case: */
#line 2958
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 2958
     /* test for range errors (not always needed but do it anyway) */
#line 2958
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2958
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2958
      nrange += tp[i] > X_SHORT_MAX ;
#line 2958
    }
#line 2958
   /* copy workspace back if necessary */
#line 2958
    if (realign) {
#line 2958
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 2958
      xp = (short *) *xpp;
#line 2958
    }
#line 2958
   /* update xpp and tp */
#line 2958
    xp += ni;
#line 2958
    tp += ni;
#line 2958
    *xpp = (void*)xp;
#line 2958
  }
#line 2958
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2958

#line 2958
#else   /* not SX */
#line 2958

#line 2958
	char *xp = (char *) *xpp;
#line 2958
	int status = NC_NOERR;
#line 2958

#line 2958
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2958
	{
#line 2958
		int lstatus = ncx_put_short_ulonglong(xp, tp, fillp);
#line 2958
		if (status == NC_NOERR) /* report the first encountered error */
#line 2958
			status = lstatus;
#line 2958
	}
#line 2958

#line 2958
	*xpp = (void *)xp;
#line 2958
	return status;
#line 2958
#endif
#line 2958
}
#line 2958

int
#line 2959
ncx_putn_short_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 2959
{
#line 2959
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2959

#line 2959
 /* basic algorithm is:
#line 2959
  *   - ensure sane alignment of output data
#line 2959
  *   - copy (conversion happens automatically) input data
#line 2959
  *     to output
#line 2959
  *   - update tp to point at next unconverted input, and xpp to point
#line 2959
  *     at next location for converted output
#line 2959
  */
#line 2959
  long i, j, ni;
#line 2959
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2959
  short *xp;
#line 2959
  int nrange = 0;         /* number of range errors */
#line 2959
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2959
  long cxp = (long) *((char**)xpp);
#line 2959

#line 2959
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2959
  /* sjl: manually stripmine so we can limit amount of
#line 2959
   * vector work space reserved to LOOPCNT elements. Also
#line 2959
   * makes vectorisation easy */
#line 2959
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2959
    ni=Min(nelems-j,LOOPCNT);
#line 2959
    if (realign) {
#line 2959
      xp = tmp;
#line 2959
    } else {
#line 2959
      xp = (short *) *xpp;
#line 2959
    }
#line 2959
   /* copy the next block */
#line 2959
#pragma cdir loopcnt=LOOPCNT
#line 2959
#pragma cdir shortloop
#line 2959
    for (i=0; i<ni; i++) {
#line 2959
      /* the normal case: */
#line 2959
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 2959
     /* test for range errors (not always needed but do it anyway) */
#line 2959
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2959
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2959
      nrange += tp[i] > X_SHORT_MAX ;
#line 2959
    }
#line 2959
   /* copy workspace back if necessary */
#line 2959
    if (realign) {
#line 2959
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 2959
      xp = (short *) *xpp;
#line 2959
    }
#line 2959
   /* update xpp and tp */
#line 2959
    xp += ni;
#line 2959
    tp += ni;
#line 2959
    *xpp = (void*)xp;
#line 2959
  }
#line 2959
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2959

#line 2959
#else   /* not SX */
#line 2959

#line 2959
	char *xp = (char *) *xpp;
#line 2959
	int status = NC_NOERR;
#line 2959

#line 2959
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2959
	{
#line 2959
		int lstatus = ncx_put_short_ushort(xp, tp, fillp);
#line 2959
		if (status == NC_NOERR) /* report the first encountered error */
#line 2959
			status = lstatus;
#line 2959
	}
#line 2959

#line 2959
	*xpp = (void *)xp;
#line 2959
	return status;
#line 2959
#endif
#line 2959
}
#line 2959


int
#line 2961
ncx_pad_putn_short_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 2961
{
#line 2961
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2961

#line 2961
	char *xp = (char *) *xpp;
#line 2961
	int status = NC_NOERR;
#line 2961

#line 2961
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2961
	{
#line 2961
		int lstatus = ncx_put_short_schar(xp, tp, fillp);
#line 2961
		if (status == NC_NOERR) /* report the first encountered error */
#line 2961
			status = lstatus;
#line 2961
	}
#line 2961

#line 2961
	if (rndup != 0)
#line 2961
	{
#line 2961
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 2961
		xp += X_SIZEOF_SHORT;
#line 2961
	}
#line 2961

#line 2961
	*xpp = (void *)xp;
#line 2961
	return status;
#line 2961
}
#line 2961

int
#line 2962
ncx_pad_putn_short_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 2962
{
#line 2962
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2962

#line 2962
	char *xp = (char *) *xpp;
#line 2962
	int status = NC_NOERR;
#line 2962

#line 2962
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2962
	{
#line 2962
		int lstatus = ncx_put_short_uchar(xp, tp, fillp);
#line 2962
		if (status == NC_NOERR) /* report the first encountered error */
#line 2962
			status = lstatus;
#line 2962
	}
#line 2962

#line 2962
	if (rndup != 0)
#line 2962
	{
#line 2962
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 2962
		xp += X_SIZEOF_SHORT;
#line 2962
	}
#line 2962

#line 2962
	*xpp = (void *)xp;
#line 2962
	return status;
#line 2962
}
#line 2962

int
#line 2963
ncx_pad_putn_short_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 2963
{
#line 2963
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2963

#line 2963
	char *xp = (char *) *xpp;
#line 2963
	int status = NC_NOERR;
#line 2963

#line 2963
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2963
	{
#line 2963
		int lstatus = ncx_put_short_short(xp, tp, fillp);
#line 2963
		if (status == NC_NOERR) /* report the first encountered error */
#line 2963
			status = lstatus;
#line 2963
	}
#line 2963

#line 2963
	if (rndup != 0)
#line 2963
	{
#line 2963
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 2963
		xp += X_SIZEOF_SHORT;
#line 2963
	}
#line 2963

#line 2963
	*xpp = (void *)xp;
#line 2963
	return status;
#line 2963
}
#line 2963

int
#line 2964
ncx_pad_putn_short_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 2964
{
#line 2964
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2964

#line 2964
	char *xp = (char *) *xpp;
#line 2964
	int status = NC_NOERR;
#line 2964

#line 2964
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2964
	{
#line 2964
		int lstatus = ncx_put_short_int(xp, tp, fillp);
#line 2964
		if (status == NC_NOERR) /* report the first encountered error */
#line 2964
			status = lstatus;
#line 2964
	}
#line 2964

#line 2964
	if (rndup != 0)
#line 2964
	{
#line 2964
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 2964
		xp += X_SIZEOF_SHORT;
#line 2964
	}
#line 2964

#line 2964
	*xpp = (void *)xp;
#line 2964
	return status;
#line 2964
}
#line 2964

int
#line 2965
ncx_pad_putn_short_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 2965
{
#line 2965
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2965

#line 2965
	char *xp = (char *) *xpp;
#line 2965
	int status = NC_NOERR;
#line 2965

#line 2965
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2965
	{
#line 2965
		int lstatus = ncx_put_short_long(xp, tp, fillp);
#line 2965
		if (status == NC_NOERR) /* report the first encountered error */
#line 2965
			status = lstatus;
#line 2965
	}
#line 2965

#line 2965
	if (rndup != 0)
#line 2965
	{
#line 2965
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 2965
		xp += X_SIZEOF_SHORT;
#line 2965
	}
#line 2965

#line 2965
	*xpp = (void *)xp;
#line 2965
	return status;
#line 2965
}
#line 2965

int
#line 2966
ncx_pad_putn_short_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 2966
{
#line 2966
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2966

#line 2966
	char *xp = (char *) *xpp;
#line 2966
	int status = NC_NOERR;
#line 2966

#line 2966
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2966
	{
#line 2966
		int lstatus = ncx_put_short_float(xp, tp, fillp);
#line 2966
		if (status == NC_NOERR) /* report the first encountered error */
#line 2966
			status = lstatus;
#line 2966
	}
#line 2966

#line 2966
	if (rndup != 0)
#line 2966
	{
#line 2966
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 2966
		xp += X_SIZEOF_SHORT;
#line 2966
	}
#line 2966

#line 2966
	*xpp = (void *)xp;
#line 2966
	return status;
#line 2966
}
#line 2966

int
#line 2967
ncx_pad_putn_short_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 2967
{
#line 2967
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2967

#line 2967
	char *xp = (char *) *xpp;
#line 2967
	int status = NC_NOERR;
#line 2967

#line 2967
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2967
	{
#line 2967
		int lstatus = ncx_put_short_double(xp, tp, fillp);
#line 2967
		if (status == NC_NOERR) /* report the first encountered error */
#line 2967
			status = lstatus;
#line 2967
	}
#line 2967

#line 2967
	if (rndup != 0)
#line 2967
	{
#line 2967
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 2967
		xp += X_SIZEOF_SHORT;
#line 2967
	}
#line 2967

#line 2967
	*xpp = (void *)xp;
#line 2967
	return status;
#line 2967
}
#line 2967

int
#line 2968
ncx_pad_putn_short_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 2968
{
#line 2968
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2968

#line 2968
	char *xp = (char *) *xpp;
#line 2968
	int status = NC_NOERR;
#line 2968

#line 2968
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2968
	{
#line 2968
		int lstatus = ncx_put_short_uint(xp, tp, fillp);
#line 2968
		if (status == NC_NOERR) /* report the first encountered error */
#line 2968
			status = lstatus;
#line 2968
	}
#line 2968

#line 2968
	if (rndup != 0)
#line 2968
	{
#line 2968
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 2968
		xp += X_SIZEOF_SHORT;
#line 2968
	}
#line 2968

#line 2968
	*xpp = (void *)xp;
#line 2968
	return status;
#line 2968
}
#line 2968

int
#line 2969
ncx_pad_putn_short_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 2969
{
#line 2969
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2969

#line 2969
	char *xp = (char *) *xpp;
#line 2969
	int status = NC_NOERR;
#line 2969

#line 2969
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2969
	{
#line 2969
		int lstatus = ncx_put_short_longlong(xp, tp, fillp);
#line 2969
		if (status == NC_NOERR) /* report the first encountered error */
#line 2969
			status = lstatus;
#line 2969
	}
#line 2969

#line 2969
	if (rndup != 0)
#line 2969
	{
#line 2969
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 2969
		xp += X_SIZEOF_SHORT;
#line 2969
	}
#line 2969

#line 2969
	*xpp = (void *)xp;
#line 2969
	return status;
#line 2969
}
#line 2969

int
#line 2970
ncx_pad_putn_short_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 2970
{
#line 2970
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2970

#line 2970
	char *xp = (char *) *xpp;
#line 2970
	int status = NC_NOERR;
#line 2970

#line 2970
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2970
	{
#line 2970
		int lstatus = ncx_put_short_ulonglong(xp, tp, fillp);
#line 2970
		if (status == NC_NOERR) /* report the first encountered error */
#line 2970
			status = lstatus;
#line 2970
	}
#line 2970

#line 2970
	if (rndup != 0)
#line 2970
	{
#line 2970
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 2970
		xp += X_SIZEOF_SHORT;
#line 2970
	}
#line 2970

#line 2970
	*xpp = (void *)xp;
#line 2970
	return status;
#line 2970
}
#line 2970

int
#line 2971
ncx_pad_putn_short_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 2971
{
#line 2971
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 2971

#line 2971
	char *xp = (char *) *xpp;
#line 2971
	int status = NC_NOERR;
#line 2971

#line 2971
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2971
	{
#line 2971
		int lstatus = ncx_put_short_ushort(xp, tp, fillp);
#line 2971
		if (status == NC_NOERR) /* report the first encountered error */
#line 2971
			status = lstatus;
#line 2971
	}
#line 2971

#line 2971
	if (rndup != 0)
#line 2971
	{
#line 2971
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 2971
		xp += X_SIZEOF_SHORT;
#line 2971
	}
#line 2971

#line 2971
	*xpp = (void *)xp;
#line 2971
	return status;
#line 2971
}
#line 2971



/* ushort --------------------------------------------------------------------*/

#if X_SIZEOF_USHORT == SIZEOF_USHORT
/* optimized version */
int
ncx_getn_ushort_ushort(const void **xpp, size_t nelems, unsigned short *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_USHORT);
# else
	swapn2b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_USHORT);
	return NC_NOERR;
}
#else
int
#line 2990
ncx_getn_ushort_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 2990
{
#line 2990
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 2990

#line 2990
 /* basic algorithm is:
#line 2990
  *   - ensure sane alignment of input data
#line 2990
  *   - copy (conversion happens automatically) input data
#line 2990
  *     to output
#line 2990
  *   - update xpp to point at next unconverted input, and tp to point
#line 2990
  *     at next location for converted output
#line 2990
  */
#line 2990
  long i, j, ni;
#line 2990
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 2990
  ushort *xp;
#line 2990
  int nrange = 0;         /* number of range errors */
#line 2990
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2990
  long cxp = (long) *((char**)xpp);
#line 2990

#line 2990
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 2990
  /* sjl: manually stripmine so we can limit amount of
#line 2990
   * vector work space reserved to LOOPCNT elements. Also
#line 2990
   * makes vectorisation easy */
#line 2990
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2990
    ni=Min(nelems-j,LOOPCNT);
#line 2990
    if (realign) {
#line 2990
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 2990
      xp = tmp;
#line 2990
    } else {
#line 2990
      xp = (ushort *) *xpp;
#line 2990
    }
#line 2990
   /* copy the next block */
#line 2990
#pragma cdir loopcnt=LOOPCNT
#line 2990
#pragma cdir shortloop
#line 2990
    for (i=0; i<ni; i++) {
#line 2990
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 2990
     /* test for range errors (not always needed but do it anyway) */
#line 2990
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2990
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2990
      nrange += xp[i] > USHORT_MAX ;
#line 2990
    }
#line 2990
   /* update xpp and tp */
#line 2990
    if (realign) xp = (ushort *) *xpp;
#line 2990
    xp += ni;
#line 2990
    tp += ni;
#line 2990
    *xpp = (void*)xp;
#line 2990
  }
#line 2990
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2990

#line 2990
#else   /* not SX */
#line 2990
	const char *xp = (const char *) *xpp;
#line 2990
	int status = NC_NOERR;
#line 2990

#line 2990
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2990
	{
#line 2990
		const int lstatus = ncx_get_ushort_ushort(xp, tp);
#line 2990
		if (status == NC_NOERR) /* report the first encountered error */
#line 2990
			status = lstatus;
#line 2990
	}
#line 2990

#line 2990
	*xpp = (const void *)xp;
#line 2990
	return status;
#line 2990
#endif
#line 2990
}
#line 2990

#endif
int
#line 2992
ncx_getn_ushort_schar(const void **xpp, size_t nelems, schar *tp)
#line 2992
{
#line 2992
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 2992

#line 2992
 /* basic algorithm is:
#line 2992
  *   - ensure sane alignment of input data
#line 2992
  *   - copy (conversion happens automatically) input data
#line 2992
  *     to output
#line 2992
  *   - update xpp to point at next unconverted input, and tp to point
#line 2992
  *     at next location for converted output
#line 2992
  */
#line 2992
  long i, j, ni;
#line 2992
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 2992
  ushort *xp;
#line 2992
  int nrange = 0;         /* number of range errors */
#line 2992
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2992
  long cxp = (long) *((char**)xpp);
#line 2992

#line 2992
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 2992
  /* sjl: manually stripmine so we can limit amount of
#line 2992
   * vector work space reserved to LOOPCNT elements. Also
#line 2992
   * makes vectorisation easy */
#line 2992
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2992
    ni=Min(nelems-j,LOOPCNT);
#line 2992
    if (realign) {
#line 2992
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 2992
      xp = tmp;
#line 2992
    } else {
#line 2992
      xp = (ushort *) *xpp;
#line 2992
    }
#line 2992
   /* copy the next block */
#line 2992
#pragma cdir loopcnt=LOOPCNT
#line 2992
#pragma cdir shortloop
#line 2992
    for (i=0; i<ni; i++) {
#line 2992
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 2992
     /* test for range errors (not always needed but do it anyway) */
#line 2992
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2992
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2992
      nrange += xp[i] > SCHAR_MAX ;
#line 2992
    }
#line 2992
   /* update xpp and tp */
#line 2992
    if (realign) xp = (ushort *) *xpp;
#line 2992
    xp += ni;
#line 2992
    tp += ni;
#line 2992
    *xpp = (void*)xp;
#line 2992
  }
#line 2992
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2992

#line 2992
#else   /* not SX */
#line 2992
	const char *xp = (const char *) *xpp;
#line 2992
	int status = NC_NOERR;
#line 2992

#line 2992
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2992
	{
#line 2992
		const int lstatus = ncx_get_ushort_schar(xp, tp);
#line 2992
		if (status == NC_NOERR) /* report the first encountered error */
#line 2992
			status = lstatus;
#line 2992
	}
#line 2992

#line 2992
	*xpp = (const void *)xp;
#line 2992
	return status;
#line 2992
#endif
#line 2992
}
#line 2992

int
#line 2993
ncx_getn_ushort_short(const void **xpp, size_t nelems, short *tp)
#line 2993
{
#line 2993
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 2993

#line 2993
 /* basic algorithm is:
#line 2993
  *   - ensure sane alignment of input data
#line 2993
  *   - copy (conversion happens automatically) input data
#line 2993
  *     to output
#line 2993
  *   - update xpp to point at next unconverted input, and tp to point
#line 2993
  *     at next location for converted output
#line 2993
  */
#line 2993
  long i, j, ni;
#line 2993
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 2993
  ushort *xp;
#line 2993
  int nrange = 0;         /* number of range errors */
#line 2993
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2993
  long cxp = (long) *((char**)xpp);
#line 2993

#line 2993
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 2993
  /* sjl: manually stripmine so we can limit amount of
#line 2993
   * vector work space reserved to LOOPCNT elements. Also
#line 2993
   * makes vectorisation easy */
#line 2993
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2993
    ni=Min(nelems-j,LOOPCNT);
#line 2993
    if (realign) {
#line 2993
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 2993
      xp = tmp;
#line 2993
    } else {
#line 2993
      xp = (ushort *) *xpp;
#line 2993
    }
#line 2993
   /* copy the next block */
#line 2993
#pragma cdir loopcnt=LOOPCNT
#line 2993
#pragma cdir shortloop
#line 2993
    for (i=0; i<ni; i++) {
#line 2993
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 2993
     /* test for range errors (not always needed but do it anyway) */
#line 2993
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2993
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2993
      nrange += xp[i] > SHORT_MAX ;
#line 2993
    }
#line 2993
   /* update xpp and tp */
#line 2993
    if (realign) xp = (ushort *) *xpp;
#line 2993
    xp += ni;
#line 2993
    tp += ni;
#line 2993
    *xpp = (void*)xp;
#line 2993
  }
#line 2993
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2993

#line 2993
#else   /* not SX */
#line 2993
	const char *xp = (const char *) *xpp;
#line 2993
	int status = NC_NOERR;
#line 2993

#line 2993
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2993
	{
#line 2993
		const int lstatus = ncx_get_ushort_short(xp, tp);
#line 2993
		if (status == NC_NOERR) /* report the first encountered error */
#line 2993
			status = lstatus;
#line 2993
	}
#line 2993

#line 2993
	*xpp = (const void *)xp;
#line 2993
	return status;
#line 2993
#endif
#line 2993
}
#line 2993

int
#line 2994
ncx_getn_ushort_int(const void **xpp, size_t nelems, int *tp)
#line 2994
{
#line 2994
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 2994

#line 2994
 /* basic algorithm is:
#line 2994
  *   - ensure sane alignment of input data
#line 2994
  *   - copy (conversion happens automatically) input data
#line 2994
  *     to output
#line 2994
  *   - update xpp to point at next unconverted input, and tp to point
#line 2994
  *     at next location for converted output
#line 2994
  */
#line 2994
  long i, j, ni;
#line 2994
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 2994
  ushort *xp;
#line 2994
  int nrange = 0;         /* number of range errors */
#line 2994
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2994
  long cxp = (long) *((char**)xpp);
#line 2994

#line 2994
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 2994
  /* sjl: manually stripmine so we can limit amount of
#line 2994
   * vector work space reserved to LOOPCNT elements. Also
#line 2994
   * makes vectorisation easy */
#line 2994
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2994
    ni=Min(nelems-j,LOOPCNT);
#line 2994
    if (realign) {
#line 2994
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 2994
      xp = tmp;
#line 2994
    } else {
#line 2994
      xp = (ushort *) *xpp;
#line 2994
    }
#line 2994
   /* copy the next block */
#line 2994
#pragma cdir loopcnt=LOOPCNT
#line 2994
#pragma cdir shortloop
#line 2994
    for (i=0; i<ni; i++) {
#line 2994
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 2994
     /* test for range errors (not always needed but do it anyway) */
#line 2994
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2994
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2994
      nrange += xp[i] > INT_MAX ;
#line 2994
    }
#line 2994
   /* update xpp and tp */
#line 2994
    if (realign) xp = (ushort *) *xpp;
#line 2994
    xp += ni;
#line 2994
    tp += ni;
#line 2994
    *xpp = (void*)xp;
#line 2994
  }
#line 2994
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2994

#line 2994
#else   /* not SX */
#line 2994
	const char *xp = (const char *) *xpp;
#line 2994
	int status = NC_NOERR;
#line 2994

#line 2994
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2994
	{
#line 2994
		const int lstatus = ncx_get_ushort_int(xp, tp);
#line 2994
		if (status == NC_NOERR) /* report the first encountered error */
#line 2994
			status = lstatus;
#line 2994
	}
#line 2994

#line 2994
	*xpp = (const void *)xp;
#line 2994
	return status;
#line 2994
#endif
#line 2994
}
#line 2994

int
#line 2995
ncx_getn_ushort_long(const void **xpp, size_t nelems, long *tp)
#line 2995
{
#line 2995
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 2995

#line 2995
 /* basic algorithm is:
#line 2995
  *   - ensure sane alignment of input data
#line 2995
  *   - copy (conversion happens automatically) input data
#line 2995
  *     to output
#line 2995
  *   - update xpp to point at next unconverted input, and tp to point
#line 2995
  *     at next location for converted output
#line 2995
  */
#line 2995
  long i, j, ni;
#line 2995
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 2995
  ushort *xp;
#line 2995
  int nrange = 0;         /* number of range errors */
#line 2995
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2995
  long cxp = (long) *((char**)xpp);
#line 2995

#line 2995
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 2995
  /* sjl: manually stripmine so we can limit amount of
#line 2995
   * vector work space reserved to LOOPCNT elements. Also
#line 2995
   * makes vectorisation easy */
#line 2995
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2995
    ni=Min(nelems-j,LOOPCNT);
#line 2995
    if (realign) {
#line 2995
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 2995
      xp = tmp;
#line 2995
    } else {
#line 2995
      xp = (ushort *) *xpp;
#line 2995
    }
#line 2995
   /* copy the next block */
#line 2995
#pragma cdir loopcnt=LOOPCNT
#line 2995
#pragma cdir shortloop
#line 2995
    for (i=0; i<ni; i++) {
#line 2995
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 2995
     /* test for range errors (not always needed but do it anyway) */
#line 2995
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2995
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2995
      nrange += xp[i] > LONG_MAX ;
#line 2995
    }
#line 2995
   /* update xpp and tp */
#line 2995
    if (realign) xp = (ushort *) *xpp;
#line 2995
    xp += ni;
#line 2995
    tp += ni;
#line 2995
    *xpp = (void*)xp;
#line 2995
  }
#line 2995
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2995

#line 2995
#else   /* not SX */
#line 2995
	const char *xp = (const char *) *xpp;
#line 2995
	int status = NC_NOERR;
#line 2995

#line 2995
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2995
	{
#line 2995
		const int lstatus = ncx_get_ushort_long(xp, tp);
#line 2995
		if (status == NC_NOERR) /* report the first encountered error */
#line 2995
			status = lstatus;
#line 2995
	}
#line 2995

#line 2995
	*xpp = (const void *)xp;
#line 2995
	return status;
#line 2995
#endif
#line 2995
}
#line 2995

int
#line 2996
ncx_getn_ushort_float(const void **xpp, size_t nelems, float *tp)
#line 2996
{
#line 2996
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 2996

#line 2996
 /* basic algorithm is:
#line 2996
  *   - ensure sane alignment of input data
#line 2996
  *   - copy (conversion happens automatically) input data
#line 2996
  *     to output
#line 2996
  *   - update xpp to point at next unconverted input, and tp to point
#line 2996
  *     at next location for converted output
#line 2996
  */
#line 2996
  long i, j, ni;
#line 2996
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 2996
  ushort *xp;
#line 2996
  int nrange = 0;         /* number of range errors */
#line 2996
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2996
  long cxp = (long) *((char**)xpp);
#line 2996

#line 2996
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 2996
  /* sjl: manually stripmine so we can limit amount of
#line 2996
   * vector work space reserved to LOOPCNT elements. Also
#line 2996
   * makes vectorisation easy */
#line 2996
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2996
    ni=Min(nelems-j,LOOPCNT);
#line 2996
    if (realign) {
#line 2996
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 2996
      xp = tmp;
#line 2996
    } else {
#line 2996
      xp = (ushort *) *xpp;
#line 2996
    }
#line 2996
   /* copy the next block */
#line 2996
#pragma cdir loopcnt=LOOPCNT
#line 2996
#pragma cdir shortloop
#line 2996
    for (i=0; i<ni; i++) {
#line 2996
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 2996
     /* test for range errors (not always needed but do it anyway) */
#line 2996
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2996
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2996
      nrange += xp[i] > FLOAT_MAX ;
#line 2996
    }
#line 2996
   /* update xpp and tp */
#line 2996
    if (realign) xp = (ushort *) *xpp;
#line 2996
    xp += ni;
#line 2996
    tp += ni;
#line 2996
    *xpp = (void*)xp;
#line 2996
  }
#line 2996
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2996

#line 2996
#else   /* not SX */
#line 2996
	const char *xp = (const char *) *xpp;
#line 2996
	int status = NC_NOERR;
#line 2996

#line 2996
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2996
	{
#line 2996
		const int lstatus = ncx_get_ushort_float(xp, tp);
#line 2996
		if (status == NC_NOERR) /* report the first encountered error */
#line 2996
			status = lstatus;
#line 2996
	}
#line 2996

#line 2996
	*xpp = (const void *)xp;
#line 2996
	return status;
#line 2996
#endif
#line 2996
}
#line 2996

int
#line 2997
ncx_getn_ushort_double(const void **xpp, size_t nelems, double *tp)
#line 2997
{
#line 2997
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 2997

#line 2997
 /* basic algorithm is:
#line 2997
  *   - ensure sane alignment of input data
#line 2997
  *   - copy (conversion happens automatically) input data
#line 2997
  *     to output
#line 2997
  *   - update xpp to point at next unconverted input, and tp to point
#line 2997
  *     at next location for converted output
#line 2997
  */
#line 2997
  long i, j, ni;
#line 2997
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 2997
  ushort *xp;
#line 2997
  int nrange = 0;         /* number of range errors */
#line 2997
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2997
  long cxp = (long) *((char**)xpp);
#line 2997

#line 2997
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 2997
  /* sjl: manually stripmine so we can limit amount of
#line 2997
   * vector work space reserved to LOOPCNT elements. Also
#line 2997
   * makes vectorisation easy */
#line 2997
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2997
    ni=Min(nelems-j,LOOPCNT);
#line 2997
    if (realign) {
#line 2997
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 2997
      xp = tmp;
#line 2997
    } else {
#line 2997
      xp = (ushort *) *xpp;
#line 2997
    }
#line 2997
   /* copy the next block */
#line 2997
#pragma cdir loopcnt=LOOPCNT
#line 2997
#pragma cdir shortloop
#line 2997
    for (i=0; i<ni; i++) {
#line 2997
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 2997
     /* test for range errors (not always needed but do it anyway) */
#line 2997
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2997
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2997
      nrange += xp[i] > DOUBLE_MAX ;
#line 2997
    }
#line 2997
   /* update xpp and tp */
#line 2997
    if (realign) xp = (ushort *) *xpp;
#line 2997
    xp += ni;
#line 2997
    tp += ni;
#line 2997
    *xpp = (void*)xp;
#line 2997
  }
#line 2997
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2997

#line 2997
#else   /* not SX */
#line 2997
	const char *xp = (const char *) *xpp;
#line 2997
	int status = NC_NOERR;
#line 2997

#line 2997
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2997
	{
#line 2997
		const int lstatus = ncx_get_ushort_double(xp, tp);
#line 2997
		if (status == NC_NOERR) /* report the first encountered error */
#line 2997
			status = lstatus;
#line 2997
	}
#line 2997

#line 2997
	*xpp = (const void *)xp;
#line 2997
	return status;
#line 2997
#endif
#line 2997
}
#line 2997

int
#line 2998
ncx_getn_ushort_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 2998
{
#line 2998
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 2998

#line 2998
 /* basic algorithm is:
#line 2998
  *   - ensure sane alignment of input data
#line 2998
  *   - copy (conversion happens automatically) input data
#line 2998
  *     to output
#line 2998
  *   - update xpp to point at next unconverted input, and tp to point
#line 2998
  *     at next location for converted output
#line 2998
  */
#line 2998
  long i, j, ni;
#line 2998
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 2998
  ushort *xp;
#line 2998
  int nrange = 0;         /* number of range errors */
#line 2998
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2998
  long cxp = (long) *((char**)xpp);
#line 2998

#line 2998
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 2998
  /* sjl: manually stripmine so we can limit amount of
#line 2998
   * vector work space reserved to LOOPCNT elements. Also
#line 2998
   * makes vectorisation easy */
#line 2998
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2998
    ni=Min(nelems-j,LOOPCNT);
#line 2998
    if (realign) {
#line 2998
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 2998
      xp = tmp;
#line 2998
    } else {
#line 2998
      xp = (ushort *) *xpp;
#line 2998
    }
#line 2998
   /* copy the next block */
#line 2998
#pragma cdir loopcnt=LOOPCNT
#line 2998
#pragma cdir shortloop
#line 2998
    for (i=0; i<ni; i++) {
#line 2998
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 2998
     /* test for range errors (not always needed but do it anyway) */
#line 2998
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2998
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2998
      nrange += xp[i] > LONGLONG_MAX ;
#line 2998
    }
#line 2998
   /* update xpp and tp */
#line 2998
    if (realign) xp = (ushort *) *xpp;
#line 2998
    xp += ni;
#line 2998
    tp += ni;
#line 2998
    *xpp = (void*)xp;
#line 2998
  }
#line 2998
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2998

#line 2998
#else   /* not SX */
#line 2998
	const char *xp = (const char *) *xpp;
#line 2998
	int status = NC_NOERR;
#line 2998

#line 2998
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2998
	{
#line 2998
		const int lstatus = ncx_get_ushort_longlong(xp, tp);
#line 2998
		if (status == NC_NOERR) /* report the first encountered error */
#line 2998
			status = lstatus;
#line 2998
	}
#line 2998

#line 2998
	*xpp = (const void *)xp;
#line 2998
	return status;
#line 2998
#endif
#line 2998
}
#line 2998

int
#line 2999
ncx_getn_ushort_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 2999
{
#line 2999
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 2999

#line 2999
 /* basic algorithm is:
#line 2999
  *   - ensure sane alignment of input data
#line 2999
  *   - copy (conversion happens automatically) input data
#line 2999
  *     to output
#line 2999
  *   - update xpp to point at next unconverted input, and tp to point
#line 2999
  *     at next location for converted output
#line 2999
  */
#line 2999
  long i, j, ni;
#line 2999
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 2999
  ushort *xp;
#line 2999
  int nrange = 0;         /* number of range errors */
#line 2999
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2999
  long cxp = (long) *((char**)xpp);
#line 2999

#line 2999
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 2999
  /* sjl: manually stripmine so we can limit amount of
#line 2999
   * vector work space reserved to LOOPCNT elements. Also
#line 2999
   * makes vectorisation easy */
#line 2999
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2999
    ni=Min(nelems-j,LOOPCNT);
#line 2999
    if (realign) {
#line 2999
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 2999
      xp = tmp;
#line 2999
    } else {
#line 2999
      xp = (ushort *) *xpp;
#line 2999
    }
#line 2999
   /* copy the next block */
#line 2999
#pragma cdir loopcnt=LOOPCNT
#line 2999
#pragma cdir shortloop
#line 2999
    for (i=0; i<ni; i++) {
#line 2999
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 2999
     /* test for range errors (not always needed but do it anyway) */
#line 2999
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2999
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2999
      nrange += xp[i] > UCHAR_MAX ;
#line 2999
    }
#line 2999
   /* update xpp and tp */
#line 2999
    if (realign) xp = (ushort *) *xpp;
#line 2999
    xp += ni;
#line 2999
    tp += ni;
#line 2999
    *xpp = (void*)xp;
#line 2999
  }
#line 2999
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2999

#line 2999
#else   /* not SX */
#line 2999
	const char *xp = (const char *) *xpp;
#line 2999
	int status = NC_NOERR;
#line 2999

#line 2999
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2999
	{
#line 2999
		const int lstatus = ncx_get_ushort_uchar(xp, tp);
#line 2999
		if (status == NC_NOERR) /* report the first encountered error */
#line 2999
			status = lstatus;
#line 2999
	}
#line 2999

#line 2999
	*xpp = (const void *)xp;
#line 2999
	return status;
#line 2999
#endif
#line 2999
}
#line 2999

int
#line 3000
ncx_getn_ushort_uint(const void **xpp, size_t nelems, uint *tp)
#line 3000
{
#line 3000
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3000

#line 3000
 /* basic algorithm is:
#line 3000
  *   - ensure sane alignment of input data
#line 3000
  *   - copy (conversion happens automatically) input data
#line 3000
  *     to output
#line 3000
  *   - update xpp to point at next unconverted input, and tp to point
#line 3000
  *     at next location for converted output
#line 3000
  */
#line 3000
  long i, j, ni;
#line 3000
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3000
  ushort *xp;
#line 3000
  int nrange = 0;         /* number of range errors */
#line 3000
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3000
  long cxp = (long) *((char**)xpp);
#line 3000

#line 3000
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3000
  /* sjl: manually stripmine so we can limit amount of
#line 3000
   * vector work space reserved to LOOPCNT elements. Also
#line 3000
   * makes vectorisation easy */
#line 3000
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3000
    ni=Min(nelems-j,LOOPCNT);
#line 3000
    if (realign) {
#line 3000
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3000
      xp = tmp;
#line 3000
    } else {
#line 3000
      xp = (ushort *) *xpp;
#line 3000
    }
#line 3000
   /* copy the next block */
#line 3000
#pragma cdir loopcnt=LOOPCNT
#line 3000
#pragma cdir shortloop
#line 3000
    for (i=0; i<ni; i++) {
#line 3000
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3000
     /* test for range errors (not always needed but do it anyway) */
#line 3000
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3000
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3000
      nrange += xp[i] > UINT_MAX ;
#line 3000
    }
#line 3000
   /* update xpp and tp */
#line 3000
    if (realign) xp = (ushort *) *xpp;
#line 3000
    xp += ni;
#line 3000
    tp += ni;
#line 3000
    *xpp = (void*)xp;
#line 3000
  }
#line 3000
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3000

#line 3000
#else   /* not SX */
#line 3000
	const char *xp = (const char *) *xpp;
#line 3000
	int status = NC_NOERR;
#line 3000

#line 3000
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3000
	{
#line 3000
		const int lstatus = ncx_get_ushort_uint(xp, tp);
#line 3000
		if (status == NC_NOERR) /* report the first encountered error */
#line 3000
			status = lstatus;
#line 3000
	}
#line 3000

#line 3000
	*xpp = (const void *)xp;
#line 3000
	return status;
#line 3000
#endif
#line 3000
}
#line 3000

int
#line 3001
ncx_getn_ushort_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3001
{
#line 3001
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3001

#line 3001
 /* basic algorithm is:
#line 3001
  *   - ensure sane alignment of input data
#line 3001
  *   - copy (conversion happens automatically) input data
#line 3001
  *     to output
#line 3001
  *   - update xpp to point at next unconverted input, and tp to point
#line 3001
  *     at next location for converted output
#line 3001
  */
#line 3001
  long i, j, ni;
#line 3001
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3001
  ushort *xp;
#line 3001
  int nrange = 0;         /* number of range errors */
#line 3001
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3001
  long cxp = (long) *((char**)xpp);
#line 3001

#line 3001
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3001
  /* sjl: manually stripmine so we can limit amount of
#line 3001
   * vector work space reserved to LOOPCNT elements. Also
#line 3001
   * makes vectorisation easy */
#line 3001
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3001
    ni=Min(nelems-j,LOOPCNT);
#line 3001
    if (realign) {
#line 3001
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3001
      xp = tmp;
#line 3001
    } else {
#line 3001
      xp = (ushort *) *xpp;
#line 3001
    }
#line 3001
   /* copy the next block */
#line 3001
#pragma cdir loopcnt=LOOPCNT
#line 3001
#pragma cdir shortloop
#line 3001
    for (i=0; i<ni; i++) {
#line 3001
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3001
     /* test for range errors (not always needed but do it anyway) */
#line 3001
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3001
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3001
      nrange += xp[i] > ULONGLONG_MAX ;
#line 3001
    }
#line 3001
   /* update xpp and tp */
#line 3001
    if (realign) xp = (ushort *) *xpp;
#line 3001
    xp += ni;
#line 3001
    tp += ni;
#line 3001
    *xpp = (void*)xp;
#line 3001
  }
#line 3001
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3001

#line 3001
#else   /* not SX */
#line 3001
	const char *xp = (const char *) *xpp;
#line 3001
	int status = NC_NOERR;
#line 3001

#line 3001
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3001
	{
#line 3001
		const int lstatus = ncx_get_ushort_ulonglong(xp, tp);
#line 3001
		if (status == NC_NOERR) /* report the first encountered error */
#line 3001
			status = lstatus;
#line 3001
	}
#line 3001

#line 3001
	*xpp = (const void *)xp;
#line 3001
	return status;
#line 3001
#endif
#line 3001
}
#line 3001


int
#line 3003
ncx_pad_getn_ushort_schar(const void **xpp, size_t nelems, schar *tp)
#line 3003
{
#line 3003
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3003

#line 3003
	const char *xp = (const char *) *xpp;
#line 3003
	int status = NC_NOERR;
#line 3003

#line 3003
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3003
	{
#line 3003
		const int lstatus = ncx_get_ushort_schar(xp, tp);
#line 3003
		if (status == NC_NOERR) /* report the first encountered error */
#line 3003
			status = lstatus;
#line 3003
	}
#line 3003

#line 3003
	if (rndup != 0)
#line 3003
		xp += X_SIZEOF_USHORT;
#line 3003

#line 3003
	*xpp = (void *)xp;
#line 3003
	return status;
#line 3003
}
#line 3003

int
#line 3004
ncx_pad_getn_ushort_short(const void **xpp, size_t nelems, short *tp)
#line 3004
{
#line 3004
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3004

#line 3004
	const char *xp = (const char *) *xpp;
#line 3004
	int status = NC_NOERR;
#line 3004

#line 3004
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3004
	{
#line 3004
		const int lstatus = ncx_get_ushort_short(xp, tp);
#line 3004
		if (status == NC_NOERR) /* report the first encountered error */
#line 3004
			status = lstatus;
#line 3004
	}
#line 3004

#line 3004
	if (rndup != 0)
#line 3004
		xp += X_SIZEOF_USHORT;
#line 3004

#line 3004
	*xpp = (void *)xp;
#line 3004
	return status;
#line 3004
}
#line 3004

int
#line 3005
ncx_pad_getn_ushort_int(const void **xpp, size_t nelems, int *tp)
#line 3005
{
#line 3005
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3005

#line 3005
	const char *xp = (const char *) *xpp;
#line 3005
	int status = NC_NOERR;
#line 3005

#line 3005
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3005
	{
#line 3005
		const int lstatus = ncx_get_ushort_int(xp, tp);
#line 3005
		if (status == NC_NOERR) /* report the first encountered error */
#line 3005
			status = lstatus;
#line 3005
	}
#line 3005

#line 3005
	if (rndup != 0)
#line 3005
		xp += X_SIZEOF_USHORT;
#line 3005

#line 3005
	*xpp = (void *)xp;
#line 3005
	return status;
#line 3005
}
#line 3005

int
#line 3006
ncx_pad_getn_ushort_long(const void **xpp, size_t nelems, long *tp)
#line 3006
{
#line 3006
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3006

#line 3006
	const char *xp = (const char *) *xpp;
#line 3006
	int status = NC_NOERR;
#line 3006

#line 3006
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3006
	{
#line 3006
		const int lstatus = ncx_get_ushort_long(xp, tp);
#line 3006
		if (status == NC_NOERR) /* report the first encountered error */
#line 3006
			status = lstatus;
#line 3006
	}
#line 3006

#line 3006
	if (rndup != 0)
#line 3006
		xp += X_SIZEOF_USHORT;
#line 3006

#line 3006
	*xpp = (void *)xp;
#line 3006
	return status;
#line 3006
}
#line 3006

int
#line 3007
ncx_pad_getn_ushort_float(const void **xpp, size_t nelems, float *tp)
#line 3007
{
#line 3007
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3007

#line 3007
	const char *xp = (const char *) *xpp;
#line 3007
	int status = NC_NOERR;
#line 3007

#line 3007
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3007
	{
#line 3007
		const int lstatus = ncx_get_ushort_float(xp, tp);
#line 3007
		if (status == NC_NOERR) /* report the first encountered error */
#line 3007
			status = lstatus;
#line 3007
	}
#line 3007

#line 3007
	if (rndup != 0)
#line 3007
		xp += X_SIZEOF_USHORT;
#line 3007

#line 3007
	*xpp = (void *)xp;
#line 3007
	return status;
#line 3007
}
#line 3007

int
#line 3008
ncx_pad_getn_ushort_double(const void **xpp, size_t nelems, double *tp)
#line 3008
{
#line 3008
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3008

#line 3008
	const char *xp = (const char *) *xpp;
#line 3008
	int status = NC_NOERR;
#line 3008

#line 3008
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3008
	{
#line 3008
		const int lstatus = ncx_get_ushort_double(xp, tp);
#line 3008
		if (status == NC_NOERR) /* report the first encountered error */
#line 3008
			status = lstatus;
#line 3008
	}
#line 3008

#line 3008
	if (rndup != 0)
#line 3008
		xp += X_SIZEOF_USHORT;
#line 3008

#line 3008
	*xpp = (void *)xp;
#line 3008
	return status;
#line 3008
}
#line 3008

int
#line 3009
ncx_pad_getn_ushort_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3009
{
#line 3009
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3009

#line 3009
	const char *xp = (const char *) *xpp;
#line 3009
	int status = NC_NOERR;
#line 3009

#line 3009
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3009
	{
#line 3009
		const int lstatus = ncx_get_ushort_uchar(xp, tp);
#line 3009
		if (status == NC_NOERR) /* report the first encountered error */
#line 3009
			status = lstatus;
#line 3009
	}
#line 3009

#line 3009
	if (rndup != 0)
#line 3009
		xp += X_SIZEOF_USHORT;
#line 3009

#line 3009
	*xpp = (void *)xp;
#line 3009
	return status;
#line 3009
}
#line 3009

int
#line 3010
ncx_pad_getn_ushort_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3010
{
#line 3010
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3010

#line 3010
	const char *xp = (const char *) *xpp;
#line 3010
	int status = NC_NOERR;
#line 3010

#line 3010
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3010
	{
#line 3010
		const int lstatus = ncx_get_ushort_ushort(xp, tp);
#line 3010
		if (status == NC_NOERR) /* report the first encountered error */
#line 3010
			status = lstatus;
#line 3010
	}
#line 3010

#line 3010
	if (rndup != 0)
#line 3010
		xp += X_SIZEOF_USHORT;
#line 3010

#line 3010
	*xpp = (void *)xp;
#line 3010
	return status;
#line 3010
}
#line 3010

int
#line 3011
ncx_pad_getn_ushort_uint(const void **xpp, size_t nelems, uint *tp)
#line 3011
{
#line 3011
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3011

#line 3011
	const char *xp = (const char *) *xpp;
#line 3011
	int status = NC_NOERR;
#line 3011

#line 3011
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3011
	{
#line 3011
		const int lstatus = ncx_get_ushort_uint(xp, tp);
#line 3011
		if (status == NC_NOERR) /* report the first encountered error */
#line 3011
			status = lstatus;
#line 3011
	}
#line 3011

#line 3011
	if (rndup != 0)
#line 3011
		xp += X_SIZEOF_USHORT;
#line 3011

#line 3011
	*xpp = (void *)xp;
#line 3011
	return status;
#line 3011
}
#line 3011

int
#line 3012
ncx_pad_getn_ushort_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3012
{
#line 3012
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3012

#line 3012
	const char *xp = (const char *) *xpp;
#line 3012
	int status = NC_NOERR;
#line 3012

#line 3012
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3012
	{
#line 3012
		const int lstatus = ncx_get_ushort_longlong(xp, tp);
#line 3012
		if (status == NC_NOERR) /* report the first encountered error */
#line 3012
			status = lstatus;
#line 3012
	}
#line 3012

#line 3012
	if (rndup != 0)
#line 3012
		xp += X_SIZEOF_USHORT;
#line 3012

#line 3012
	*xpp = (void *)xp;
#line 3012
	return status;
#line 3012
}
#line 3012

int
#line 3013
ncx_pad_getn_ushort_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3013
{
#line 3013
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3013

#line 3013
	const char *xp = (const char *) *xpp;
#line 3013
	int status = NC_NOERR;
#line 3013

#line 3013
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3013
	{
#line 3013
		const int lstatus = ncx_get_ushort_ulonglong(xp, tp);
#line 3013
		if (status == NC_NOERR) /* report the first encountered error */
#line 3013
			status = lstatus;
#line 3013
	}
#line 3013

#line 3013
	if (rndup != 0)
#line 3013
		xp += X_SIZEOF_USHORT;
#line 3013

#line 3013
	*xpp = (void *)xp;
#line 3013
	return status;
#line 3013
}
#line 3013


#if X_SIZEOF_USHORT == SIZEOF_USHORT
/* optimized version */
int
ncx_putn_ushort_ushort(void **xpp, size_t nelems, const unsigned short *tp, void *fillp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_USHORT);
# else
	swapn2b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_USHORT);
	return NC_NOERR;
}
#else
int
#line 3029
ncx_putn_ushort_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3029
{
#line 3029
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3029

#line 3029
 /* basic algorithm is:
#line 3029
  *   - ensure sane alignment of output data
#line 3029
  *   - copy (conversion happens automatically) input data
#line 3029
  *     to output
#line 3029
  *   - update tp to point at next unconverted input, and xpp to point
#line 3029
  *     at next location for converted output
#line 3029
  */
#line 3029
  long i, j, ni;
#line 3029
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3029
  ushort *xp;
#line 3029
  int nrange = 0;         /* number of range errors */
#line 3029
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3029
  long cxp = (long) *((char**)xpp);
#line 3029

#line 3029
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3029
  /* sjl: manually stripmine so we can limit amount of
#line 3029
   * vector work space reserved to LOOPCNT elements. Also
#line 3029
   * makes vectorisation easy */
#line 3029
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3029
    ni=Min(nelems-j,LOOPCNT);
#line 3029
    if (realign) {
#line 3029
      xp = tmp;
#line 3029
    } else {
#line 3029
      xp = (ushort *) *xpp;
#line 3029
    }
#line 3029
   /* copy the next block */
#line 3029
#pragma cdir loopcnt=LOOPCNT
#line 3029
#pragma cdir shortloop
#line 3029
    for (i=0; i<ni; i++) {
#line 3029
      /* the normal case: */
#line 3029
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3029
     /* test for range errors (not always needed but do it anyway) */
#line 3029
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3029
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3029
      nrange += tp[i] > X_USHORT_MAX ;
#line 3029
    }
#line 3029
   /* copy workspace back if necessary */
#line 3029
    if (realign) {
#line 3029
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3029
      xp = (ushort *) *xpp;
#line 3029
    }
#line 3029
   /* update xpp and tp */
#line 3029
    xp += ni;
#line 3029
    tp += ni;
#line 3029
    *xpp = (void*)xp;
#line 3029
  }
#line 3029
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3029

#line 3029
#else   /* not SX */
#line 3029

#line 3029
	char *xp = (char *) *xpp;
#line 3029
	int status = NC_NOERR;
#line 3029

#line 3029
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3029
	{
#line 3029
		int lstatus = ncx_put_ushort_ushort(xp, tp, fillp);
#line 3029
		if (status == NC_NOERR) /* report the first encountered error */
#line 3029
			status = lstatus;
#line 3029
	}
#line 3029

#line 3029
	*xpp = (void *)xp;
#line 3029
	return status;
#line 3029
#endif
#line 3029
}
#line 3029

#endif
int
#line 3031
ncx_putn_ushort_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3031
{
#line 3031
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3031

#line 3031
 /* basic algorithm is:
#line 3031
  *   - ensure sane alignment of output data
#line 3031
  *   - copy (conversion happens automatically) input data
#line 3031
  *     to output
#line 3031
  *   - update tp to point at next unconverted input, and xpp to point
#line 3031
  *     at next location for converted output
#line 3031
  */
#line 3031
  long i, j, ni;
#line 3031
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3031
  ushort *xp;
#line 3031
  int nrange = 0;         /* number of range errors */
#line 3031
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3031
  long cxp = (long) *((char**)xpp);
#line 3031

#line 3031
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3031
  /* sjl: manually stripmine so we can limit amount of
#line 3031
   * vector work space reserved to LOOPCNT elements. Also
#line 3031
   * makes vectorisation easy */
#line 3031
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3031
    ni=Min(nelems-j,LOOPCNT);
#line 3031
    if (realign) {
#line 3031
      xp = tmp;
#line 3031
    } else {
#line 3031
      xp = (ushort *) *xpp;
#line 3031
    }
#line 3031
   /* copy the next block */
#line 3031
#pragma cdir loopcnt=LOOPCNT
#line 3031
#pragma cdir shortloop
#line 3031
    for (i=0; i<ni; i++) {
#line 3031
      /* the normal case: */
#line 3031
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3031
     /* test for range errors (not always needed but do it anyway) */
#line 3031
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3031
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3031
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 3031
    }
#line 3031
   /* copy workspace back if necessary */
#line 3031
    if (realign) {
#line 3031
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3031
      xp = (ushort *) *xpp;
#line 3031
    }
#line 3031
   /* update xpp and tp */
#line 3031
    xp += ni;
#line 3031
    tp += ni;
#line 3031
    *xpp = (void*)xp;
#line 3031
  }
#line 3031
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3031

#line 3031
#else   /* not SX */
#line 3031

#line 3031
	char *xp = (char *) *xpp;
#line 3031
	int status = NC_NOERR;
#line 3031

#line 3031
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3031
	{
#line 3031
		int lstatus = ncx_put_ushort_schar(xp, tp, fillp);
#line 3031
		if (status == NC_NOERR) /* report the first encountered error */
#line 3031
			status = lstatus;
#line 3031
	}
#line 3031

#line 3031
	*xpp = (void *)xp;
#line 3031
	return status;
#line 3031
#endif
#line 3031
}
#line 3031

int
#line 3032
ncx_putn_ushort_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3032
{
#line 3032
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3032

#line 3032
 /* basic algorithm is:
#line 3032
  *   - ensure sane alignment of output data
#line 3032
  *   - copy (conversion happens automatically) input data
#line 3032
  *     to output
#line 3032
  *   - update tp to point at next unconverted input, and xpp to point
#line 3032
  *     at next location for converted output
#line 3032
  */
#line 3032
  long i, j, ni;
#line 3032
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3032
  ushort *xp;
#line 3032
  int nrange = 0;         /* number of range errors */
#line 3032
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3032
  long cxp = (long) *((char**)xpp);
#line 3032

#line 3032
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3032
  /* sjl: manually stripmine so we can limit amount of
#line 3032
   * vector work space reserved to LOOPCNT elements. Also
#line 3032
   * makes vectorisation easy */
#line 3032
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3032
    ni=Min(nelems-j,LOOPCNT);
#line 3032
    if (realign) {
#line 3032
      xp = tmp;
#line 3032
    } else {
#line 3032
      xp = (ushort *) *xpp;
#line 3032
    }
#line 3032
   /* copy the next block */
#line 3032
#pragma cdir loopcnt=LOOPCNT
#line 3032
#pragma cdir shortloop
#line 3032
    for (i=0; i<ni; i++) {
#line 3032
      /* the normal case: */
#line 3032
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3032
     /* test for range errors (not always needed but do it anyway) */
#line 3032
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3032
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3032
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 3032
    }
#line 3032
   /* copy workspace back if necessary */
#line 3032
    if (realign) {
#line 3032
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3032
      xp = (ushort *) *xpp;
#line 3032
    }
#line 3032
   /* update xpp and tp */
#line 3032
    xp += ni;
#line 3032
    tp += ni;
#line 3032
    *xpp = (void*)xp;
#line 3032
  }
#line 3032
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3032

#line 3032
#else   /* not SX */
#line 3032

#line 3032
	char *xp = (char *) *xpp;
#line 3032
	int status = NC_NOERR;
#line 3032

#line 3032
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3032
	{
#line 3032
		int lstatus = ncx_put_ushort_short(xp, tp, fillp);
#line 3032
		if (status == NC_NOERR) /* report the first encountered error */
#line 3032
			status = lstatus;
#line 3032
	}
#line 3032

#line 3032
	*xpp = (void *)xp;
#line 3032
	return status;
#line 3032
#endif
#line 3032
}
#line 3032

int
#line 3033
ncx_putn_ushort_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3033
{
#line 3033
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3033

#line 3033
 /* basic algorithm is:
#line 3033
  *   - ensure sane alignment of output data
#line 3033
  *   - copy (conversion happens automatically) input data
#line 3033
  *     to output
#line 3033
  *   - update tp to point at next unconverted input, and xpp to point
#line 3033
  *     at next location for converted output
#line 3033
  */
#line 3033
  long i, j, ni;
#line 3033
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3033
  ushort *xp;
#line 3033
  int nrange = 0;         /* number of range errors */
#line 3033
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3033
  long cxp = (long) *((char**)xpp);
#line 3033

#line 3033
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3033
  /* sjl: manually stripmine so we can limit amount of
#line 3033
   * vector work space reserved to LOOPCNT elements. Also
#line 3033
   * makes vectorisation easy */
#line 3033
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3033
    ni=Min(nelems-j,LOOPCNT);
#line 3033
    if (realign) {
#line 3033
      xp = tmp;
#line 3033
    } else {
#line 3033
      xp = (ushort *) *xpp;
#line 3033
    }
#line 3033
   /* copy the next block */
#line 3033
#pragma cdir loopcnt=LOOPCNT
#line 3033
#pragma cdir shortloop
#line 3033
    for (i=0; i<ni; i++) {
#line 3033
      /* the normal case: */
#line 3033
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3033
     /* test for range errors (not always needed but do it anyway) */
#line 3033
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3033
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3033
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 3033
    }
#line 3033
   /* copy workspace back if necessary */
#line 3033
    if (realign) {
#line 3033
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3033
      xp = (ushort *) *xpp;
#line 3033
    }
#line 3033
   /* update xpp and tp */
#line 3033
    xp += ni;
#line 3033
    tp += ni;
#line 3033
    *xpp = (void*)xp;
#line 3033
  }
#line 3033
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3033

#line 3033
#else   /* not SX */
#line 3033

#line 3033
	char *xp = (char *) *xpp;
#line 3033
	int status = NC_NOERR;
#line 3033

#line 3033
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3033
	{
#line 3033
		int lstatus = ncx_put_ushort_int(xp, tp, fillp);
#line 3033
		if (status == NC_NOERR) /* report the first encountered error */
#line 3033
			status = lstatus;
#line 3033
	}
#line 3033

#line 3033
	*xpp = (void *)xp;
#line 3033
	return status;
#line 3033
#endif
#line 3033
}
#line 3033

int
#line 3034
ncx_putn_ushort_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3034
{
#line 3034
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3034

#line 3034
 /* basic algorithm is:
#line 3034
  *   - ensure sane alignment of output data
#line 3034
  *   - copy (conversion happens automatically) input data
#line 3034
  *     to output
#line 3034
  *   - update tp to point at next unconverted input, and xpp to point
#line 3034
  *     at next location for converted output
#line 3034
  */
#line 3034
  long i, j, ni;
#line 3034
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3034
  ushort *xp;
#line 3034
  int nrange = 0;         /* number of range errors */
#line 3034
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3034
  long cxp = (long) *((char**)xpp);
#line 3034

#line 3034
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3034
  /* sjl: manually stripmine so we can limit amount of
#line 3034
   * vector work space reserved to LOOPCNT elements. Also
#line 3034
   * makes vectorisation easy */
#line 3034
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3034
    ni=Min(nelems-j,LOOPCNT);
#line 3034
    if (realign) {
#line 3034
      xp = tmp;
#line 3034
    } else {
#line 3034
      xp = (ushort *) *xpp;
#line 3034
    }
#line 3034
   /* copy the next block */
#line 3034
#pragma cdir loopcnt=LOOPCNT
#line 3034
#pragma cdir shortloop
#line 3034
    for (i=0; i<ni; i++) {
#line 3034
      /* the normal case: */
#line 3034
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3034
     /* test for range errors (not always needed but do it anyway) */
#line 3034
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3034
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3034
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 3034
    }
#line 3034
   /* copy workspace back if necessary */
#line 3034
    if (realign) {
#line 3034
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3034
      xp = (ushort *) *xpp;
#line 3034
    }
#line 3034
   /* update xpp and tp */
#line 3034
    xp += ni;
#line 3034
    tp += ni;
#line 3034
    *xpp = (void*)xp;
#line 3034
  }
#line 3034
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3034

#line 3034
#else   /* not SX */
#line 3034

#line 3034
	char *xp = (char *) *xpp;
#line 3034
	int status = NC_NOERR;
#line 3034

#line 3034
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3034
	{
#line 3034
		int lstatus = ncx_put_ushort_long(xp, tp, fillp);
#line 3034
		if (status == NC_NOERR) /* report the first encountered error */
#line 3034
			status = lstatus;
#line 3034
	}
#line 3034

#line 3034
	*xpp = (void *)xp;
#line 3034
	return status;
#line 3034
#endif
#line 3034
}
#line 3034

int
#line 3035
ncx_putn_ushort_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3035
{
#line 3035
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3035

#line 3035
 /* basic algorithm is:
#line 3035
  *   - ensure sane alignment of output data
#line 3035
  *   - copy (conversion happens automatically) input data
#line 3035
  *     to output
#line 3035
  *   - update tp to point at next unconverted input, and xpp to point
#line 3035
  *     at next location for converted output
#line 3035
  */
#line 3035
  long i, j, ni;
#line 3035
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3035
  ushort *xp;
#line 3035
  int nrange = 0;         /* number of range errors */
#line 3035
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3035
  long cxp = (long) *((char**)xpp);
#line 3035

#line 3035
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3035
  /* sjl: manually stripmine so we can limit amount of
#line 3035
   * vector work space reserved to LOOPCNT elements. Also
#line 3035
   * makes vectorisation easy */
#line 3035
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3035
    ni=Min(nelems-j,LOOPCNT);
#line 3035
    if (realign) {
#line 3035
      xp = tmp;
#line 3035
    } else {
#line 3035
      xp = (ushort *) *xpp;
#line 3035
    }
#line 3035
   /* copy the next block */
#line 3035
#pragma cdir loopcnt=LOOPCNT
#line 3035
#pragma cdir shortloop
#line 3035
    for (i=0; i<ni; i++) {
#line 3035
      /* the normal case: */
#line 3035
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3035
     /* test for range errors (not always needed but do it anyway) */
#line 3035
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3035
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3035
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 3035
    }
#line 3035
   /* copy workspace back if necessary */
#line 3035
    if (realign) {
#line 3035
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3035
      xp = (ushort *) *xpp;
#line 3035
    }
#line 3035
   /* update xpp and tp */
#line 3035
    xp += ni;
#line 3035
    tp += ni;
#line 3035
    *xpp = (void*)xp;
#line 3035
  }
#line 3035
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3035

#line 3035
#else   /* not SX */
#line 3035

#line 3035
	char *xp = (char *) *xpp;
#line 3035
	int status = NC_NOERR;
#line 3035

#line 3035
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3035
	{
#line 3035
		int lstatus = ncx_put_ushort_float(xp, tp, fillp);
#line 3035
		if (status == NC_NOERR) /* report the first encountered error */
#line 3035
			status = lstatus;
#line 3035
	}
#line 3035

#line 3035
	*xpp = (void *)xp;
#line 3035
	return status;
#line 3035
#endif
#line 3035
}
#line 3035

int
#line 3036
ncx_putn_ushort_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3036
{
#line 3036
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3036

#line 3036
 /* basic algorithm is:
#line 3036
  *   - ensure sane alignment of output data
#line 3036
  *   - copy (conversion happens automatically) input data
#line 3036
  *     to output
#line 3036
  *   - update tp to point at next unconverted input, and xpp to point
#line 3036
  *     at next location for converted output
#line 3036
  */
#line 3036
  long i, j, ni;
#line 3036
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3036
  ushort *xp;
#line 3036
  int nrange = 0;         /* number of range errors */
#line 3036
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3036
  long cxp = (long) *((char**)xpp);
#line 3036

#line 3036
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3036
  /* sjl: manually stripmine so we can limit amount of
#line 3036
   * vector work space reserved to LOOPCNT elements. Also
#line 3036
   * makes vectorisation easy */
#line 3036
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3036
    ni=Min(nelems-j,LOOPCNT);
#line 3036
    if (realign) {
#line 3036
      xp = tmp;
#line 3036
    } else {
#line 3036
      xp = (ushort *) *xpp;
#line 3036
    }
#line 3036
   /* copy the next block */
#line 3036
#pragma cdir loopcnt=LOOPCNT
#line 3036
#pragma cdir shortloop
#line 3036
    for (i=0; i<ni; i++) {
#line 3036
      /* the normal case: */
#line 3036
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3036
     /* test for range errors (not always needed but do it anyway) */
#line 3036
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3036
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3036
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 3036
    }
#line 3036
   /* copy workspace back if necessary */
#line 3036
    if (realign) {
#line 3036
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3036
      xp = (ushort *) *xpp;
#line 3036
    }
#line 3036
   /* update xpp and tp */
#line 3036
    xp += ni;
#line 3036
    tp += ni;
#line 3036
    *xpp = (void*)xp;
#line 3036
  }
#line 3036
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3036

#line 3036
#else   /* not SX */
#line 3036

#line 3036
	char *xp = (char *) *xpp;
#line 3036
	int status = NC_NOERR;
#line 3036

#line 3036
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3036
	{
#line 3036
		int lstatus = ncx_put_ushort_double(xp, tp, fillp);
#line 3036
		if (status == NC_NOERR) /* report the first encountered error */
#line 3036
			status = lstatus;
#line 3036
	}
#line 3036

#line 3036
	*xpp = (void *)xp;
#line 3036
	return status;
#line 3036
#endif
#line 3036
}
#line 3036

int
#line 3037
ncx_putn_ushort_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3037
{
#line 3037
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3037

#line 3037
 /* basic algorithm is:
#line 3037
  *   - ensure sane alignment of output data
#line 3037
  *   - copy (conversion happens automatically) input data
#line 3037
  *     to output
#line 3037
  *   - update tp to point at next unconverted input, and xpp to point
#line 3037
  *     at next location for converted output
#line 3037
  */
#line 3037
  long i, j, ni;
#line 3037
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3037
  ushort *xp;
#line 3037
  int nrange = 0;         /* number of range errors */
#line 3037
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3037
  long cxp = (long) *((char**)xpp);
#line 3037

#line 3037
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3037
  /* sjl: manually stripmine so we can limit amount of
#line 3037
   * vector work space reserved to LOOPCNT elements. Also
#line 3037
   * makes vectorisation easy */
#line 3037
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3037
    ni=Min(nelems-j,LOOPCNT);
#line 3037
    if (realign) {
#line 3037
      xp = tmp;
#line 3037
    } else {
#line 3037
      xp = (ushort *) *xpp;
#line 3037
    }
#line 3037
   /* copy the next block */
#line 3037
#pragma cdir loopcnt=LOOPCNT
#line 3037
#pragma cdir shortloop
#line 3037
    for (i=0; i<ni; i++) {
#line 3037
      /* the normal case: */
#line 3037
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3037
     /* test for range errors (not always needed but do it anyway) */
#line 3037
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3037
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3037
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 3037
    }
#line 3037
   /* copy workspace back if necessary */
#line 3037
    if (realign) {
#line 3037
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3037
      xp = (ushort *) *xpp;
#line 3037
    }
#line 3037
   /* update xpp and tp */
#line 3037
    xp += ni;
#line 3037
    tp += ni;
#line 3037
    *xpp = (void*)xp;
#line 3037
  }
#line 3037
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3037

#line 3037
#else   /* not SX */
#line 3037

#line 3037
	char *xp = (char *) *xpp;
#line 3037
	int status = NC_NOERR;
#line 3037

#line 3037
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3037
	{
#line 3037
		int lstatus = ncx_put_ushort_longlong(xp, tp, fillp);
#line 3037
		if (status == NC_NOERR) /* report the first encountered error */
#line 3037
			status = lstatus;
#line 3037
	}
#line 3037

#line 3037
	*xpp = (void *)xp;
#line 3037
	return status;
#line 3037
#endif
#line 3037
}
#line 3037

int
#line 3038
ncx_putn_ushort_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3038
{
#line 3038
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3038

#line 3038
 /* basic algorithm is:
#line 3038
  *   - ensure sane alignment of output data
#line 3038
  *   - copy (conversion happens automatically) input data
#line 3038
  *     to output
#line 3038
  *   - update tp to point at next unconverted input, and xpp to point
#line 3038
  *     at next location for converted output
#line 3038
  */
#line 3038
  long i, j, ni;
#line 3038
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3038
  ushort *xp;
#line 3038
  int nrange = 0;         /* number of range errors */
#line 3038
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3038
  long cxp = (long) *((char**)xpp);
#line 3038

#line 3038
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3038
  /* sjl: manually stripmine so we can limit amount of
#line 3038
   * vector work space reserved to LOOPCNT elements. Also
#line 3038
   * makes vectorisation easy */
#line 3038
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3038
    ni=Min(nelems-j,LOOPCNT);
#line 3038
    if (realign) {
#line 3038
      xp = tmp;
#line 3038
    } else {
#line 3038
      xp = (ushort *) *xpp;
#line 3038
    }
#line 3038
   /* copy the next block */
#line 3038
#pragma cdir loopcnt=LOOPCNT
#line 3038
#pragma cdir shortloop
#line 3038
    for (i=0; i<ni; i++) {
#line 3038
      /* the normal case: */
#line 3038
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3038
     /* test for range errors (not always needed but do it anyway) */
#line 3038
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3038
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3038
      nrange += tp[i] > X_USHORT_MAX ;
#line 3038
    }
#line 3038
   /* copy workspace back if necessary */
#line 3038
    if (realign) {
#line 3038
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3038
      xp = (ushort *) *xpp;
#line 3038
    }
#line 3038
   /* update xpp and tp */
#line 3038
    xp += ni;
#line 3038
    tp += ni;
#line 3038
    *xpp = (void*)xp;
#line 3038
  }
#line 3038
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3038

#line 3038
#else   /* not SX */
#line 3038

#line 3038
	char *xp = (char *) *xpp;
#line 3038
	int status = NC_NOERR;
#line 3038

#line 3038
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3038
	{
#line 3038
		int lstatus = ncx_put_ushort_uchar(xp, tp, fillp);
#line 3038
		if (status == NC_NOERR) /* report the first encountered error */
#line 3038
			status = lstatus;
#line 3038
	}
#line 3038

#line 3038
	*xpp = (void *)xp;
#line 3038
	return status;
#line 3038
#endif
#line 3038
}
#line 3038

int
#line 3039
ncx_putn_ushort_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3039
{
#line 3039
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3039

#line 3039
 /* basic algorithm is:
#line 3039
  *   - ensure sane alignment of output data
#line 3039
  *   - copy (conversion happens automatically) input data
#line 3039
  *     to output
#line 3039
  *   - update tp to point at next unconverted input, and xpp to point
#line 3039
  *     at next location for converted output
#line 3039
  */
#line 3039
  long i, j, ni;
#line 3039
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3039
  ushort *xp;
#line 3039
  int nrange = 0;         /* number of range errors */
#line 3039
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3039
  long cxp = (long) *((char**)xpp);
#line 3039

#line 3039
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3039
  /* sjl: manually stripmine so we can limit amount of
#line 3039
   * vector work space reserved to LOOPCNT elements. Also
#line 3039
   * makes vectorisation easy */
#line 3039
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3039
    ni=Min(nelems-j,LOOPCNT);
#line 3039
    if (realign) {
#line 3039
      xp = tmp;
#line 3039
    } else {
#line 3039
      xp = (ushort *) *xpp;
#line 3039
    }
#line 3039
   /* copy the next block */
#line 3039
#pragma cdir loopcnt=LOOPCNT
#line 3039
#pragma cdir shortloop
#line 3039
    for (i=0; i<ni; i++) {
#line 3039
      /* the normal case: */
#line 3039
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3039
     /* test for range errors (not always needed but do it anyway) */
#line 3039
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3039
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3039
      nrange += tp[i] > X_USHORT_MAX ;
#line 3039
    }
#line 3039
   /* copy workspace back if necessary */
#line 3039
    if (realign) {
#line 3039
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3039
      xp = (ushort *) *xpp;
#line 3039
    }
#line 3039
   /* update xpp and tp */
#line 3039
    xp += ni;
#line 3039
    tp += ni;
#line 3039
    *xpp = (void*)xp;
#line 3039
  }
#line 3039
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3039

#line 3039
#else   /* not SX */
#line 3039

#line 3039
	char *xp = (char *) *xpp;
#line 3039
	int status = NC_NOERR;
#line 3039

#line 3039
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3039
	{
#line 3039
		int lstatus = ncx_put_ushort_uint(xp, tp, fillp);
#line 3039
		if (status == NC_NOERR) /* report the first encountered error */
#line 3039
			status = lstatus;
#line 3039
	}
#line 3039

#line 3039
	*xpp = (void *)xp;
#line 3039
	return status;
#line 3039
#endif
#line 3039
}
#line 3039

int
#line 3040
ncx_putn_ushort_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3040
{
#line 3040
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3040

#line 3040
 /* basic algorithm is:
#line 3040
  *   - ensure sane alignment of output data
#line 3040
  *   - copy (conversion happens automatically) input data
#line 3040
  *     to output
#line 3040
  *   - update tp to point at next unconverted input, and xpp to point
#line 3040
  *     at next location for converted output
#line 3040
  */
#line 3040
  long i, j, ni;
#line 3040
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3040
  ushort *xp;
#line 3040
  int nrange = 0;         /* number of range errors */
#line 3040
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3040
  long cxp = (long) *((char**)xpp);
#line 3040

#line 3040
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3040
  /* sjl: manually stripmine so we can limit amount of
#line 3040
   * vector work space reserved to LOOPCNT elements. Also
#line 3040
   * makes vectorisation easy */
#line 3040
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3040
    ni=Min(nelems-j,LOOPCNT);
#line 3040
    if (realign) {
#line 3040
      xp = tmp;
#line 3040
    } else {
#line 3040
      xp = (ushort *) *xpp;
#line 3040
    }
#line 3040
   /* copy the next block */
#line 3040
#pragma cdir loopcnt=LOOPCNT
#line 3040
#pragma cdir shortloop
#line 3040
    for (i=0; i<ni; i++) {
#line 3040
      /* the normal case: */
#line 3040
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3040
     /* test for range errors (not always needed but do it anyway) */
#line 3040
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3040
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3040
      nrange += tp[i] > X_USHORT_MAX ;
#line 3040
    }
#line 3040
   /* copy workspace back if necessary */
#line 3040
    if (realign) {
#line 3040
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3040
      xp = (ushort *) *xpp;
#line 3040
    }
#line 3040
   /* update xpp and tp */
#line 3040
    xp += ni;
#line 3040
    tp += ni;
#line 3040
    *xpp = (void*)xp;
#line 3040
  }
#line 3040
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3040

#line 3040
#else   /* not SX */
#line 3040

#line 3040
	char *xp = (char *) *xpp;
#line 3040
	int status = NC_NOERR;
#line 3040

#line 3040
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3040
	{
#line 3040
		int lstatus = ncx_put_ushort_ulonglong(xp, tp, fillp);
#line 3040
		if (status == NC_NOERR) /* report the first encountered error */
#line 3040
			status = lstatus;
#line 3040
	}
#line 3040

#line 3040
	*xpp = (void *)xp;
#line 3040
	return status;
#line 3040
#endif
#line 3040
}
#line 3040


int
#line 3042
ncx_pad_putn_ushort_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3042
{
#line 3042
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3042

#line 3042
	char *xp = (char *) *xpp;
#line 3042
	int status = NC_NOERR;
#line 3042

#line 3042
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3042
	{
#line 3042
		int lstatus = ncx_put_ushort_schar(xp, tp, fillp);
#line 3042
		if (status == NC_NOERR) /* report the first encountered error */
#line 3042
			status = lstatus;
#line 3042
	}
#line 3042

#line 3042
	if (rndup != 0)
#line 3042
	{
#line 3042
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3042
		xp += X_SIZEOF_USHORT;
#line 3042
	}
#line 3042

#line 3042
	*xpp = (void *)xp;
#line 3042
	return status;
#line 3042
}
#line 3042

int
#line 3043
ncx_pad_putn_ushort_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3043
{
#line 3043
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3043

#line 3043
	char *xp = (char *) *xpp;
#line 3043
	int status = NC_NOERR;
#line 3043

#line 3043
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3043
	{
#line 3043
		int lstatus = ncx_put_ushort_uchar(xp, tp, fillp);
#line 3043
		if (status == NC_NOERR) /* report the first encountered error */
#line 3043
			status = lstatus;
#line 3043
	}
#line 3043

#line 3043
	if (rndup != 0)
#line 3043
	{
#line 3043
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3043
		xp += X_SIZEOF_USHORT;
#line 3043
	}
#line 3043

#line 3043
	*xpp = (void *)xp;
#line 3043
	return status;
#line 3043
}
#line 3043

int
#line 3044
ncx_pad_putn_ushort_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3044
{
#line 3044
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3044

#line 3044
	char *xp = (char *) *xpp;
#line 3044
	int status = NC_NOERR;
#line 3044

#line 3044
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3044
	{
#line 3044
		int lstatus = ncx_put_ushort_short(xp, tp, fillp);
#line 3044
		if (status == NC_NOERR) /* report the first encountered error */
#line 3044
			status = lstatus;
#line 3044
	}
#line 3044

#line 3044
	if (rndup != 0)
#line 3044
	{
#line 3044
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3044
		xp += X_SIZEOF_USHORT;
#line 3044
	}
#line 3044

#line 3044
	*xpp = (void *)xp;
#line 3044
	return status;
#line 3044
}
#line 3044

int
#line 3045
ncx_pad_putn_ushort_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3045
{
#line 3045
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3045

#line 3045
	char *xp = (char *) *xpp;
#line 3045
	int status = NC_NOERR;
#line 3045

#line 3045
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3045
	{
#line 3045
		int lstatus = ncx_put_ushort_int(xp, tp, fillp);
#line 3045
		if (status == NC_NOERR) /* report the first encountered error */
#line 3045
			status = lstatus;
#line 3045
	}
#line 3045

#line 3045
	if (rndup != 0)
#line 3045
	{
#line 3045
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3045
		xp += X_SIZEOF_USHORT;
#line 3045
	}
#line 3045

#line 3045
	*xpp = (void *)xp;
#line 3045
	return status;
#line 3045
}
#line 3045

int
#line 3046
ncx_pad_putn_ushort_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3046
{
#line 3046
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3046

#line 3046
	char *xp = (char *) *xpp;
#line 3046
	int status = NC_NOERR;
#line 3046

#line 3046
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3046
	{
#line 3046
		int lstatus = ncx_put_ushort_long(xp, tp, fillp);
#line 3046
		if (status == NC_NOERR) /* report the first encountered error */
#line 3046
			status = lstatus;
#line 3046
	}
#line 3046

#line 3046
	if (rndup != 0)
#line 3046
	{
#line 3046
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3046
		xp += X_SIZEOF_USHORT;
#line 3046
	}
#line 3046

#line 3046
	*xpp = (void *)xp;
#line 3046
	return status;
#line 3046
}
#line 3046

int
#line 3047
ncx_pad_putn_ushort_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3047
{
#line 3047
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3047

#line 3047
	char *xp = (char *) *xpp;
#line 3047
	int status = NC_NOERR;
#line 3047

#line 3047
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3047
	{
#line 3047
		int lstatus = ncx_put_ushort_float(xp, tp, fillp);
#line 3047
		if (status == NC_NOERR) /* report the first encountered error */
#line 3047
			status = lstatus;
#line 3047
	}
#line 3047

#line 3047
	if (rndup != 0)
#line 3047
	{
#line 3047
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3047
		xp += X_SIZEOF_USHORT;
#line 3047
	}
#line 3047

#line 3047
	*xpp = (void *)xp;
#line 3047
	return status;
#line 3047
}
#line 3047

int
#line 3048
ncx_pad_putn_ushort_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3048
{
#line 3048
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3048

#line 3048
	char *xp = (char *) *xpp;
#line 3048
	int status = NC_NOERR;
#line 3048

#line 3048
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3048
	{
#line 3048
		int lstatus = ncx_put_ushort_double(xp, tp, fillp);
#line 3048
		if (status == NC_NOERR) /* report the first encountered error */
#line 3048
			status = lstatus;
#line 3048
	}
#line 3048

#line 3048
	if (rndup != 0)
#line 3048
	{
#line 3048
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3048
		xp += X_SIZEOF_USHORT;
#line 3048
	}
#line 3048

#line 3048
	*xpp = (void *)xp;
#line 3048
	return status;
#line 3048
}
#line 3048

int
#line 3049
ncx_pad_putn_ushort_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3049
{
#line 3049
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3049

#line 3049
	char *xp = (char *) *xpp;
#line 3049
	int status = NC_NOERR;
#line 3049

#line 3049
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3049
	{
#line 3049
		int lstatus = ncx_put_ushort_uint(xp, tp, fillp);
#line 3049
		if (status == NC_NOERR) /* report the first encountered error */
#line 3049
			status = lstatus;
#line 3049
	}
#line 3049

#line 3049
	if (rndup != 0)
#line 3049
	{
#line 3049
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3049
		xp += X_SIZEOF_USHORT;
#line 3049
	}
#line 3049

#line 3049
	*xpp = (void *)xp;
#line 3049
	return status;
#line 3049
}
#line 3049

int
#line 3050
ncx_pad_putn_ushort_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3050
{
#line 3050
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3050

#line 3050
	char *xp = (char *) *xpp;
#line 3050
	int status = NC_NOERR;
#line 3050

#line 3050
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3050
	{
#line 3050
		int lstatus = ncx_put_ushort_longlong(xp, tp, fillp);
#line 3050
		if (status == NC_NOERR) /* report the first encountered error */
#line 3050
			status = lstatus;
#line 3050
	}
#line 3050

#line 3050
	if (rndup != 0)
#line 3050
	{
#line 3050
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3050
		xp += X_SIZEOF_USHORT;
#line 3050
	}
#line 3050

#line 3050
	*xpp = (void *)xp;
#line 3050
	return status;
#line 3050
}
#line 3050

int
#line 3051
ncx_pad_putn_ushort_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3051
{
#line 3051
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3051

#line 3051
	char *xp = (char *) *xpp;
#line 3051
	int status = NC_NOERR;
#line 3051

#line 3051
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3051
	{
#line 3051
		int lstatus = ncx_put_ushort_ulonglong(xp, tp, fillp);
#line 3051
		if (status == NC_NOERR) /* report the first encountered error */
#line 3051
			status = lstatus;
#line 3051
	}
#line 3051

#line 3051
	if (rndup != 0)
#line 3051
	{
#line 3051
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3051
		xp += X_SIZEOF_USHORT;
#line 3051
	}
#line 3051

#line 3051
	*xpp = (void *)xp;
#line 3051
	return status;
#line 3051
}
#line 3051

int
#line 3052
ncx_pad_putn_ushort_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3052
{
#line 3052
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3052

#line 3052
	char *xp = (char *) *xpp;
#line 3052
	int status = NC_NOERR;
#line 3052

#line 3052
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3052
	{
#line 3052
		int lstatus = ncx_put_ushort_ushort(xp, tp, fillp);
#line 3052
		if (status == NC_NOERR) /* report the first encountered error */
#line 3052
			status = lstatus;
#line 3052
	}
#line 3052

#line 3052
	if (rndup != 0)
#line 3052
	{
#line 3052
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3052
		xp += X_SIZEOF_USHORT;
#line 3052
	}
#line 3052

#line 3052
	*xpp = (void *)xp;
#line 3052
	return status;
#line 3052
}
#line 3052



/* int -----------------------------------------------------------------------*/

#if X_SIZEOF_INT == SIZEOF_INT
/* optimized version */
int
ncx_getn_int_int(const void **xpp, size_t nelems, int *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_INT);
# else
	swapn4b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_INT);
	return NC_NOERR;
}
#else
int
#line 3071
ncx_getn_int_int(const void **xpp, size_t nelems, int *tp)
#line 3071
{
#line 3071
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3071

#line 3071
 /* basic algorithm is:
#line 3071
  *   - ensure sane alignment of input data
#line 3071
  *   - copy (conversion happens automatically) input data
#line 3071
  *     to output
#line 3071
  *   - update xpp to point at next unconverted input, and tp to point
#line 3071
  *     at next location for converted output
#line 3071
  */
#line 3071
  long i, j, ni;
#line 3071
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3071
  int *xp;
#line 3071
  int nrange = 0;         /* number of range errors */
#line 3071
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3071
  long cxp = (long) *((char**)xpp);
#line 3071

#line 3071
  realign = (cxp & 7) % SIZEOF_INT;
#line 3071
  /* sjl: manually stripmine so we can limit amount of
#line 3071
   * vector work space reserved to LOOPCNT elements. Also
#line 3071
   * makes vectorisation easy */
#line 3071
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3071
    ni=Min(nelems-j,LOOPCNT);
#line 3071
    if (realign) {
#line 3071
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3071
      xp = tmp;
#line 3071
    } else {
#line 3071
      xp = (int *) *xpp;
#line 3071
    }
#line 3071
   /* copy the next block */
#line 3071
#pragma cdir loopcnt=LOOPCNT
#line 3071
#pragma cdir shortloop
#line 3071
    for (i=0; i<ni; i++) {
#line 3071
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3071
     /* test for range errors (not always needed but do it anyway) */
#line 3071
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3071
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3071
      nrange += xp[i] > INT_MAX || xp[i] < INT_MIN;
#line 3071
    }
#line 3071
   /* update xpp and tp */
#line 3071
    if (realign) xp = (int *) *xpp;
#line 3071
    xp += ni;
#line 3071
    tp += ni;
#line 3071
    *xpp = (void*)xp;
#line 3071
  }
#line 3071
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3071

#line 3071
#else   /* not SX */
#line 3071
	const char *xp = (const char *) *xpp;
#line 3071
	int status = NC_NOERR;
#line 3071

#line 3071
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3071
	{
#line 3071
		const int lstatus = ncx_get_int_int(xp, tp);
#line 3071
		if (status == NC_NOERR) /* report the first encountered error */
#line 3071
			status = lstatus;
#line 3071
	}
#line 3071

#line 3071
	*xpp = (const void *)xp;
#line 3071
	return status;
#line 3071
#endif
#line 3071
}
#line 3071

#endif
int
#line 3073
ncx_getn_int_schar(const void **xpp, size_t nelems, schar *tp)
#line 3073
{
#line 3073
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3073

#line 3073
 /* basic algorithm is:
#line 3073
  *   - ensure sane alignment of input data
#line 3073
  *   - copy (conversion happens automatically) input data
#line 3073
  *     to output
#line 3073
  *   - update xpp to point at next unconverted input, and tp to point
#line 3073
  *     at next location for converted output
#line 3073
  */
#line 3073
  long i, j, ni;
#line 3073
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3073
  int *xp;
#line 3073
  int nrange = 0;         /* number of range errors */
#line 3073
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3073
  long cxp = (long) *((char**)xpp);
#line 3073

#line 3073
  realign = (cxp & 7) % SIZEOF_INT;
#line 3073
  /* sjl: manually stripmine so we can limit amount of
#line 3073
   * vector work space reserved to LOOPCNT elements. Also
#line 3073
   * makes vectorisation easy */
#line 3073
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3073
    ni=Min(nelems-j,LOOPCNT);
#line 3073
    if (realign) {
#line 3073
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3073
      xp = tmp;
#line 3073
    } else {
#line 3073
      xp = (int *) *xpp;
#line 3073
    }
#line 3073
   /* copy the next block */
#line 3073
#pragma cdir loopcnt=LOOPCNT
#line 3073
#pragma cdir shortloop
#line 3073
    for (i=0; i<ni; i++) {
#line 3073
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3073
     /* test for range errors (not always needed but do it anyway) */
#line 3073
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3073
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3073
      nrange += xp[i] > SCHAR_MAX || xp[i] < SCHAR_MIN;
#line 3073
    }
#line 3073
   /* update xpp and tp */
#line 3073
    if (realign) xp = (int *) *xpp;
#line 3073
    xp += ni;
#line 3073
    tp += ni;
#line 3073
    *xpp = (void*)xp;
#line 3073
  }
#line 3073
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3073

#line 3073
#else   /* not SX */
#line 3073
	const char *xp = (const char *) *xpp;
#line 3073
	int status = NC_NOERR;
#line 3073

#line 3073
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3073
	{
#line 3073
		const int lstatus = ncx_get_int_schar(xp, tp);
#line 3073
		if (status == NC_NOERR) /* report the first encountered error */
#line 3073
			status = lstatus;
#line 3073
	}
#line 3073

#line 3073
	*xpp = (const void *)xp;
#line 3073
	return status;
#line 3073
#endif
#line 3073
}
#line 3073

int
#line 3074
ncx_getn_int_short(const void **xpp, size_t nelems, short *tp)
#line 3074
{
#line 3074
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3074

#line 3074
 /* basic algorithm is:
#line 3074
  *   - ensure sane alignment of input data
#line 3074
  *   - copy (conversion happens automatically) input data
#line 3074
  *     to output
#line 3074
  *   - update xpp to point at next unconverted input, and tp to point
#line 3074
  *     at next location for converted output
#line 3074
  */
#line 3074
  long i, j, ni;
#line 3074
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3074
  int *xp;
#line 3074
  int nrange = 0;         /* number of range errors */
#line 3074
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3074
  long cxp = (long) *((char**)xpp);
#line 3074

#line 3074
  realign = (cxp & 7) % SIZEOF_INT;
#line 3074
  /* sjl: manually stripmine so we can limit amount of
#line 3074
   * vector work space reserved to LOOPCNT elements. Also
#line 3074
   * makes vectorisation easy */
#line 3074
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3074
    ni=Min(nelems-j,LOOPCNT);
#line 3074
    if (realign) {
#line 3074
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3074
      xp = tmp;
#line 3074
    } else {
#line 3074
      xp = (int *) *xpp;
#line 3074
    }
#line 3074
   /* copy the next block */
#line 3074
#pragma cdir loopcnt=LOOPCNT
#line 3074
#pragma cdir shortloop
#line 3074
    for (i=0; i<ni; i++) {
#line 3074
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3074
     /* test for range errors (not always needed but do it anyway) */
#line 3074
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3074
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3074
      nrange += xp[i] > SHORT_MAX || xp[i] < SHORT_MIN;
#line 3074
    }
#line 3074
   /* update xpp and tp */
#line 3074
    if (realign) xp = (int *) *xpp;
#line 3074
    xp += ni;
#line 3074
    tp += ni;
#line 3074
    *xpp = (void*)xp;
#line 3074
  }
#line 3074
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3074

#line 3074
#else   /* not SX */
#line 3074
	const char *xp = (const char *) *xpp;
#line 3074
	int status = NC_NOERR;
#line 3074

#line 3074
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3074
	{
#line 3074
		const int lstatus = ncx_get_int_short(xp, tp);
#line 3074
		if (status == NC_NOERR) /* report the first encountered error */
#line 3074
			status = lstatus;
#line 3074
	}
#line 3074

#line 3074
	*xpp = (const void *)xp;
#line 3074
	return status;
#line 3074
#endif
#line 3074
}
#line 3074

int
#line 3075
ncx_getn_int_long(const void **xpp, size_t nelems, long *tp)
#line 3075
{
#line 3075
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3075

#line 3075
 /* basic algorithm is:
#line 3075
  *   - ensure sane alignment of input data
#line 3075
  *   - copy (conversion happens automatically) input data
#line 3075
  *     to output
#line 3075
  *   - update xpp to point at next unconverted input, and tp to point
#line 3075
  *     at next location for converted output
#line 3075
  */
#line 3075
  long i, j, ni;
#line 3075
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3075
  int *xp;
#line 3075
  int nrange = 0;         /* number of range errors */
#line 3075
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3075
  long cxp = (long) *((char**)xpp);
#line 3075

#line 3075
  realign = (cxp & 7) % SIZEOF_INT;
#line 3075
  /* sjl: manually stripmine so we can limit amount of
#line 3075
   * vector work space reserved to LOOPCNT elements. Also
#line 3075
   * makes vectorisation easy */
#line 3075
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3075
    ni=Min(nelems-j,LOOPCNT);
#line 3075
    if (realign) {
#line 3075
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3075
      xp = tmp;
#line 3075
    } else {
#line 3075
      xp = (int *) *xpp;
#line 3075
    }
#line 3075
   /* copy the next block */
#line 3075
#pragma cdir loopcnt=LOOPCNT
#line 3075
#pragma cdir shortloop
#line 3075
    for (i=0; i<ni; i++) {
#line 3075
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3075
     /* test for range errors (not always needed but do it anyway) */
#line 3075
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3075
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3075
      nrange += xp[i] > LONG_MAX || xp[i] < LONG_MIN;
#line 3075
    }
#line 3075
   /* update xpp and tp */
#line 3075
    if (realign) xp = (int *) *xpp;
#line 3075
    xp += ni;
#line 3075
    tp += ni;
#line 3075
    *xpp = (void*)xp;
#line 3075
  }
#line 3075
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3075

#line 3075
#else   /* not SX */
#line 3075
	const char *xp = (const char *) *xpp;
#line 3075
	int status = NC_NOERR;
#line 3075

#line 3075
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3075
	{
#line 3075
		const int lstatus = ncx_get_int_long(xp, tp);
#line 3075
		if (status == NC_NOERR) /* report the first encountered error */
#line 3075
			status = lstatus;
#line 3075
	}
#line 3075

#line 3075
	*xpp = (const void *)xp;
#line 3075
	return status;
#line 3075
#endif
#line 3075
}
#line 3075

int
#line 3076
ncx_getn_int_float(const void **xpp, size_t nelems, float *tp)
#line 3076
{
#line 3076
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3076

#line 3076
 /* basic algorithm is:
#line 3076
  *   - ensure sane alignment of input data
#line 3076
  *   - copy (conversion happens automatically) input data
#line 3076
  *     to output
#line 3076
  *   - update xpp to point at next unconverted input, and tp to point
#line 3076
  *     at next location for converted output
#line 3076
  */
#line 3076
  long i, j, ni;
#line 3076
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3076
  int *xp;
#line 3076
  int nrange = 0;         /* number of range errors */
#line 3076
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3076
  long cxp = (long) *((char**)xpp);
#line 3076

#line 3076
  realign = (cxp & 7) % SIZEOF_INT;
#line 3076
  /* sjl: manually stripmine so we can limit amount of
#line 3076
   * vector work space reserved to LOOPCNT elements. Also
#line 3076
   * makes vectorisation easy */
#line 3076
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3076
    ni=Min(nelems-j,LOOPCNT);
#line 3076
    if (realign) {
#line 3076
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3076
      xp = tmp;
#line 3076
    } else {
#line 3076
      xp = (int *) *xpp;
#line 3076
    }
#line 3076
   /* copy the next block */
#line 3076
#pragma cdir loopcnt=LOOPCNT
#line 3076
#pragma cdir shortloop
#line 3076
    for (i=0; i<ni; i++) {
#line 3076
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 3076
     /* test for range errors (not always needed but do it anyway) */
#line 3076
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3076
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3076
      nrange += xp[i] > FLOAT_MAX || xp[i] < FLOAT_MIN;
#line 3076
    }
#line 3076
   /* update xpp and tp */
#line 3076
    if (realign) xp = (int *) *xpp;
#line 3076
    xp += ni;
#line 3076
    tp += ni;
#line 3076
    *xpp = (void*)xp;
#line 3076
  }
#line 3076
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3076

#line 3076
#else   /* not SX */
#line 3076
	const char *xp = (const char *) *xpp;
#line 3076
	int status = NC_NOERR;
#line 3076

#line 3076
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3076
	{
#line 3076
		const int lstatus = ncx_get_int_float(xp, tp);
#line 3076
		if (status == NC_NOERR) /* report the first encountered error */
#line 3076
			status = lstatus;
#line 3076
	}
#line 3076

#line 3076
	*xpp = (const void *)xp;
#line 3076
	return status;
#line 3076
#endif
#line 3076
}
#line 3076

int
#line 3077
ncx_getn_int_double(const void **xpp, size_t nelems, double *tp)
#line 3077
{
#line 3077
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3077

#line 3077
 /* basic algorithm is:
#line 3077
  *   - ensure sane alignment of input data
#line 3077
  *   - copy (conversion happens automatically) input data
#line 3077
  *     to output
#line 3077
  *   - update xpp to point at next unconverted input, and tp to point
#line 3077
  *     at next location for converted output
#line 3077
  */
#line 3077
  long i, j, ni;
#line 3077
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3077
  int *xp;
#line 3077
  int nrange = 0;         /* number of range errors */
#line 3077
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3077
  long cxp = (long) *((char**)xpp);
#line 3077

#line 3077
  realign = (cxp & 7) % SIZEOF_INT;
#line 3077
  /* sjl: manually stripmine so we can limit amount of
#line 3077
   * vector work space reserved to LOOPCNT elements. Also
#line 3077
   * makes vectorisation easy */
#line 3077
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3077
    ni=Min(nelems-j,LOOPCNT);
#line 3077
    if (realign) {
#line 3077
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3077
      xp = tmp;
#line 3077
    } else {
#line 3077
      xp = (int *) *xpp;
#line 3077
    }
#line 3077
   /* copy the next block */
#line 3077
#pragma cdir loopcnt=LOOPCNT
#line 3077
#pragma cdir shortloop
#line 3077
    for (i=0; i<ni; i++) {
#line 3077
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 3077
     /* test for range errors (not always needed but do it anyway) */
#line 3077
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3077
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3077
      nrange += xp[i] > DOUBLE_MAX || xp[i] < DOUBLE_MIN;
#line 3077
    }
#line 3077
   /* update xpp and tp */
#line 3077
    if (realign) xp = (int *) *xpp;
#line 3077
    xp += ni;
#line 3077
    tp += ni;
#line 3077
    *xpp = (void*)xp;
#line 3077
  }
#line 3077
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3077

#line 3077
#else   /* not SX */
#line 3077
	const char *xp = (const char *) *xpp;
#line 3077
	int status = NC_NOERR;
#line 3077

#line 3077
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3077
	{
#line 3077
		const int lstatus = ncx_get_int_double(xp, tp);
#line 3077
		if (status == NC_NOERR) /* report the first encountered error */
#line 3077
			status = lstatus;
#line 3077
	}
#line 3077

#line 3077
	*xpp = (const void *)xp;
#line 3077
	return status;
#line 3077
#endif
#line 3077
}
#line 3077

int
#line 3078
ncx_getn_int_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3078
{
#line 3078
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3078

#line 3078
 /* basic algorithm is:
#line 3078
  *   - ensure sane alignment of input data
#line 3078
  *   - copy (conversion happens automatically) input data
#line 3078
  *     to output
#line 3078
  *   - update xpp to point at next unconverted input, and tp to point
#line 3078
  *     at next location for converted output
#line 3078
  */
#line 3078
  long i, j, ni;
#line 3078
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3078
  int *xp;
#line 3078
  int nrange = 0;         /* number of range errors */
#line 3078
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3078
  long cxp = (long) *((char**)xpp);
#line 3078

#line 3078
  realign = (cxp & 7) % SIZEOF_INT;
#line 3078
  /* sjl: manually stripmine so we can limit amount of
#line 3078
   * vector work space reserved to LOOPCNT elements. Also
#line 3078
   * makes vectorisation easy */
#line 3078
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3078
    ni=Min(nelems-j,LOOPCNT);
#line 3078
    if (realign) {
#line 3078
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3078
      xp = tmp;
#line 3078
    } else {
#line 3078
      xp = (int *) *xpp;
#line 3078
    }
#line 3078
   /* copy the next block */
#line 3078
#pragma cdir loopcnt=LOOPCNT
#line 3078
#pragma cdir shortloop
#line 3078
    for (i=0; i<ni; i++) {
#line 3078
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3078
     /* test for range errors (not always needed but do it anyway) */
#line 3078
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3078
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3078
      nrange += xp[i] > LONGLONG_MAX || xp[i] < LONGLONG_MIN;
#line 3078
    }
#line 3078
   /* update xpp and tp */
#line 3078
    if (realign) xp = (int *) *xpp;
#line 3078
    xp += ni;
#line 3078
    tp += ni;
#line 3078
    *xpp = (void*)xp;
#line 3078
  }
#line 3078
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3078

#line 3078
#else   /* not SX */
#line 3078
	const char *xp = (const char *) *xpp;
#line 3078
	int status = NC_NOERR;
#line 3078

#line 3078
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3078
	{
#line 3078
		const int lstatus = ncx_get_int_longlong(xp, tp);
#line 3078
		if (status == NC_NOERR) /* report the first encountered error */
#line 3078
			status = lstatus;
#line 3078
	}
#line 3078

#line 3078
	*xpp = (const void *)xp;
#line 3078
	return status;
#line 3078
#endif
#line 3078
}
#line 3078

int
#line 3079
ncx_getn_int_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3079
{
#line 3079
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3079

#line 3079
 /* basic algorithm is:
#line 3079
  *   - ensure sane alignment of input data
#line 3079
  *   - copy (conversion happens automatically) input data
#line 3079
  *     to output
#line 3079
  *   - update xpp to point at next unconverted input, and tp to point
#line 3079
  *     at next location for converted output
#line 3079
  */
#line 3079
  long i, j, ni;
#line 3079
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3079
  int *xp;
#line 3079
  int nrange = 0;         /* number of range errors */
#line 3079
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3079
  long cxp = (long) *((char**)xpp);
#line 3079

#line 3079
  realign = (cxp & 7) % SIZEOF_INT;
#line 3079
  /* sjl: manually stripmine so we can limit amount of
#line 3079
   * vector work space reserved to LOOPCNT elements. Also
#line 3079
   * makes vectorisation easy */
#line 3079
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3079
    ni=Min(nelems-j,LOOPCNT);
#line 3079
    if (realign) {
#line 3079
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3079
      xp = tmp;
#line 3079
    } else {
#line 3079
      xp = (int *) *xpp;
#line 3079
    }
#line 3079
   /* copy the next block */
#line 3079
#pragma cdir loopcnt=LOOPCNT
#line 3079
#pragma cdir shortloop
#line 3079
    for (i=0; i<ni; i++) {
#line 3079
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3079
     /* test for range errors (not always needed but do it anyway) */
#line 3079
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3079
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3079
      nrange += xp[i] > UCHAR_MAX || xp[i] < 0;
#line 3079
    }
#line 3079
   /* update xpp and tp */
#line 3079
    if (realign) xp = (int *) *xpp;
#line 3079
    xp += ni;
#line 3079
    tp += ni;
#line 3079
    *xpp = (void*)xp;
#line 3079
  }
#line 3079
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3079

#line 3079
#else   /* not SX */
#line 3079
	const char *xp = (const char *) *xpp;
#line 3079
	int status = NC_NOERR;
#line 3079

#line 3079
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3079
	{
#line 3079
		const int lstatus = ncx_get_int_uchar(xp, tp);
#line 3079
		if (status == NC_NOERR) /* report the first encountered error */
#line 3079
			status = lstatus;
#line 3079
	}
#line 3079

#line 3079
	*xpp = (const void *)xp;
#line 3079
	return status;
#line 3079
#endif
#line 3079
}
#line 3079

int
#line 3080
ncx_getn_int_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3080
{
#line 3080
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3080

#line 3080
 /* basic algorithm is:
#line 3080
  *   - ensure sane alignment of input data
#line 3080
  *   - copy (conversion happens automatically) input data
#line 3080
  *     to output
#line 3080
  *   - update xpp to point at next unconverted input, and tp to point
#line 3080
  *     at next location for converted output
#line 3080
  */
#line 3080
  long i, j, ni;
#line 3080
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3080
  int *xp;
#line 3080
  int nrange = 0;         /* number of range errors */
#line 3080
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3080
  long cxp = (long) *((char**)xpp);
#line 3080

#line 3080
  realign = (cxp & 7) % SIZEOF_INT;
#line 3080
  /* sjl: manually stripmine so we can limit amount of
#line 3080
   * vector work space reserved to LOOPCNT elements. Also
#line 3080
   * makes vectorisation easy */
#line 3080
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3080
    ni=Min(nelems-j,LOOPCNT);
#line 3080
    if (realign) {
#line 3080
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3080
      xp = tmp;
#line 3080
    } else {
#line 3080
      xp = (int *) *xpp;
#line 3080
    }
#line 3080
   /* copy the next block */
#line 3080
#pragma cdir loopcnt=LOOPCNT
#line 3080
#pragma cdir shortloop
#line 3080
    for (i=0; i<ni; i++) {
#line 3080
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3080
     /* test for range errors (not always needed but do it anyway) */
#line 3080
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3080
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3080
      nrange += xp[i] > USHORT_MAX || xp[i] < 0;
#line 3080
    }
#line 3080
   /* update xpp and tp */
#line 3080
    if (realign) xp = (int *) *xpp;
#line 3080
    xp += ni;
#line 3080
    tp += ni;
#line 3080
    *xpp = (void*)xp;
#line 3080
  }
#line 3080
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3080

#line 3080
#else   /* not SX */
#line 3080
	const char *xp = (const char *) *xpp;
#line 3080
	int status = NC_NOERR;
#line 3080

#line 3080
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3080
	{
#line 3080
		const int lstatus = ncx_get_int_ushort(xp, tp);
#line 3080
		if (status == NC_NOERR) /* report the first encountered error */
#line 3080
			status = lstatus;
#line 3080
	}
#line 3080

#line 3080
	*xpp = (const void *)xp;
#line 3080
	return status;
#line 3080
#endif
#line 3080
}
#line 3080

int
#line 3081
ncx_getn_int_uint(const void **xpp, size_t nelems, uint *tp)
#line 3081
{
#line 3081
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3081

#line 3081
 /* basic algorithm is:
#line 3081
  *   - ensure sane alignment of input data
#line 3081
  *   - copy (conversion happens automatically) input data
#line 3081
  *     to output
#line 3081
  *   - update xpp to point at next unconverted input, and tp to point
#line 3081
  *     at next location for converted output
#line 3081
  */
#line 3081
  long i, j, ni;
#line 3081
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3081
  int *xp;
#line 3081
  int nrange = 0;         /* number of range errors */
#line 3081
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3081
  long cxp = (long) *((char**)xpp);
#line 3081

#line 3081
  realign = (cxp & 7) % SIZEOF_INT;
#line 3081
  /* sjl: manually stripmine so we can limit amount of
#line 3081
   * vector work space reserved to LOOPCNT elements. Also
#line 3081
   * makes vectorisation easy */
#line 3081
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3081
    ni=Min(nelems-j,LOOPCNT);
#line 3081
    if (realign) {
#line 3081
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3081
      xp = tmp;
#line 3081
    } else {
#line 3081
      xp = (int *) *xpp;
#line 3081
    }
#line 3081
   /* copy the next block */
#line 3081
#pragma cdir loopcnt=LOOPCNT
#line 3081
#pragma cdir shortloop
#line 3081
    for (i=0; i<ni; i++) {
#line 3081
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3081
     /* test for range errors (not always needed but do it anyway) */
#line 3081
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3081
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3081
      nrange += xp[i] > UINT_MAX || xp[i] < 0;
#line 3081
    }
#line 3081
   /* update xpp and tp */
#line 3081
    if (realign) xp = (int *) *xpp;
#line 3081
    xp += ni;
#line 3081
    tp += ni;
#line 3081
    *xpp = (void*)xp;
#line 3081
  }
#line 3081
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3081

#line 3081
#else   /* not SX */
#line 3081
	const char *xp = (const char *) *xpp;
#line 3081
	int status = NC_NOERR;
#line 3081

#line 3081
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3081
	{
#line 3081
		const int lstatus = ncx_get_int_uint(xp, tp);
#line 3081
		if (status == NC_NOERR) /* report the first encountered error */
#line 3081
			status = lstatus;
#line 3081
	}
#line 3081

#line 3081
	*xpp = (const void *)xp;
#line 3081
	return status;
#line 3081
#endif
#line 3081
}
#line 3081

int
#line 3082
ncx_getn_int_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3082
{
#line 3082
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3082

#line 3082
 /* basic algorithm is:
#line 3082
  *   - ensure sane alignment of input data
#line 3082
  *   - copy (conversion happens automatically) input data
#line 3082
  *     to output
#line 3082
  *   - update xpp to point at next unconverted input, and tp to point
#line 3082
  *     at next location for converted output
#line 3082
  */
#line 3082
  long i, j, ni;
#line 3082
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3082
  int *xp;
#line 3082
  int nrange = 0;         /* number of range errors */
#line 3082
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3082
  long cxp = (long) *((char**)xpp);
#line 3082

#line 3082
  realign = (cxp & 7) % SIZEOF_INT;
#line 3082
  /* sjl: manually stripmine so we can limit amount of
#line 3082
   * vector work space reserved to LOOPCNT elements. Also
#line 3082
   * makes vectorisation easy */
#line 3082
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3082
    ni=Min(nelems-j,LOOPCNT);
#line 3082
    if (realign) {
#line 3082
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3082
      xp = tmp;
#line 3082
    } else {
#line 3082
      xp = (int *) *xpp;
#line 3082
    }
#line 3082
   /* copy the next block */
#line 3082
#pragma cdir loopcnt=LOOPCNT
#line 3082
#pragma cdir shortloop
#line 3082
    for (i=0; i<ni; i++) {
#line 3082
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3082
     /* test for range errors (not always needed but do it anyway) */
#line 3082
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3082
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3082
      nrange += xp[i] > ULONGLONG_MAX || xp[i] < 0;
#line 3082
    }
#line 3082
   /* update xpp and tp */
#line 3082
    if (realign) xp = (int *) *xpp;
#line 3082
    xp += ni;
#line 3082
    tp += ni;
#line 3082
    *xpp = (void*)xp;
#line 3082
  }
#line 3082
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3082

#line 3082
#else   /* not SX */
#line 3082
	const char *xp = (const char *) *xpp;
#line 3082
	int status = NC_NOERR;
#line 3082

#line 3082
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3082
	{
#line 3082
		const int lstatus = ncx_get_int_ulonglong(xp, tp);
#line 3082
		if (status == NC_NOERR) /* report the first encountered error */
#line 3082
			status = lstatus;
#line 3082
	}
#line 3082

#line 3082
	*xpp = (const void *)xp;
#line 3082
	return status;
#line 3082
#endif
#line 3082
}
#line 3082


#if X_SIZEOF_INT == SIZEOF_INT
/* optimized version */
int
ncx_putn_int_int(void **xpp, size_t nelems, const int *tp, void *fillp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_INT);
# else
	swapn4b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_INT);
	return NC_NOERR;
}
#else
int
#line 3098
ncx_putn_int_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3098
{
#line 3098
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3098

#line 3098
 /* basic algorithm is:
#line 3098
  *   - ensure sane alignment of output data
#line 3098
  *   - copy (conversion happens automatically) input data
#line 3098
  *     to output
#line 3098
  *   - update tp to point at next unconverted input, and xpp to point
#line 3098
  *     at next location for converted output
#line 3098
  */
#line 3098
  long i, j, ni;
#line 3098
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3098
  int *xp;
#line 3098
  int nrange = 0;         /* number of range errors */
#line 3098
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3098
  long cxp = (long) *((char**)xpp);
#line 3098

#line 3098
  realign = (cxp & 7) % SIZEOF_INT;
#line 3098
  /* sjl: manually stripmine so we can limit amount of
#line 3098
   * vector work space reserved to LOOPCNT elements. Also
#line 3098
   * makes vectorisation easy */
#line 3098
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3098
    ni=Min(nelems-j,LOOPCNT);
#line 3098
    if (realign) {
#line 3098
      xp = tmp;
#line 3098
    } else {
#line 3098
      xp = (int *) *xpp;
#line 3098
    }
#line 3098
   /* copy the next block */
#line 3098
#pragma cdir loopcnt=LOOPCNT
#line 3098
#pragma cdir shortloop
#line 3098
    for (i=0; i<ni; i++) {
#line 3098
      /* the normal case: */
#line 3098
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3098
     /* test for range errors (not always needed but do it anyway) */
#line 3098
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3098
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3098
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 3098
    }
#line 3098
   /* copy workspace back if necessary */
#line 3098
    if (realign) {
#line 3098
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3098
      xp = (int *) *xpp;
#line 3098
    }
#line 3098
   /* update xpp and tp */
#line 3098
    xp += ni;
#line 3098
    tp += ni;
#line 3098
    *xpp = (void*)xp;
#line 3098
  }
#line 3098
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3098

#line 3098
#else   /* not SX */
#line 3098

#line 3098
	char *xp = (char *) *xpp;
#line 3098
	int status = NC_NOERR;
#line 3098

#line 3098
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3098
	{
#line 3098
		int lstatus = ncx_put_int_int(xp, tp, fillp);
#line 3098
		if (status == NC_NOERR) /* report the first encountered error */
#line 3098
			status = lstatus;
#line 3098
	}
#line 3098

#line 3098
	*xpp = (void *)xp;
#line 3098
	return status;
#line 3098
#endif
#line 3098
}
#line 3098

#endif
int
#line 3100
ncx_putn_int_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3100
{
#line 3100
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3100

#line 3100
 /* basic algorithm is:
#line 3100
  *   - ensure sane alignment of output data
#line 3100
  *   - copy (conversion happens automatically) input data
#line 3100
  *     to output
#line 3100
  *   - update tp to point at next unconverted input, and xpp to point
#line 3100
  *     at next location for converted output
#line 3100
  */
#line 3100
  long i, j, ni;
#line 3100
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3100
  int *xp;
#line 3100
  int nrange = 0;         /* number of range errors */
#line 3100
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3100
  long cxp = (long) *((char**)xpp);
#line 3100

#line 3100
  realign = (cxp & 7) % SIZEOF_INT;
#line 3100
  /* sjl: manually stripmine so we can limit amount of
#line 3100
   * vector work space reserved to LOOPCNT elements. Also
#line 3100
   * makes vectorisation easy */
#line 3100
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3100
    ni=Min(nelems-j,LOOPCNT);
#line 3100
    if (realign) {
#line 3100
      xp = tmp;
#line 3100
    } else {
#line 3100
      xp = (int *) *xpp;
#line 3100
    }
#line 3100
   /* copy the next block */
#line 3100
#pragma cdir loopcnt=LOOPCNT
#line 3100
#pragma cdir shortloop
#line 3100
    for (i=0; i<ni; i++) {
#line 3100
      /* the normal case: */
#line 3100
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3100
     /* test for range errors (not always needed but do it anyway) */
#line 3100
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3100
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3100
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 3100
    }
#line 3100
   /* copy workspace back if necessary */
#line 3100
    if (realign) {
#line 3100
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3100
      xp = (int *) *xpp;
#line 3100
    }
#line 3100
   /* update xpp and tp */
#line 3100
    xp += ni;
#line 3100
    tp += ni;
#line 3100
    *xpp = (void*)xp;
#line 3100
  }
#line 3100
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3100

#line 3100
#else   /* not SX */
#line 3100

#line 3100
	char *xp = (char *) *xpp;
#line 3100
	int status = NC_NOERR;
#line 3100

#line 3100
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3100
	{
#line 3100
		int lstatus = ncx_put_int_schar(xp, tp, fillp);
#line 3100
		if (status == NC_NOERR) /* report the first encountered error */
#line 3100
			status = lstatus;
#line 3100
	}
#line 3100

#line 3100
	*xpp = (void *)xp;
#line 3100
	return status;
#line 3100
#endif
#line 3100
}
#line 3100

int
#line 3101
ncx_putn_int_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3101
{
#line 3101
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3101

#line 3101
 /* basic algorithm is:
#line 3101
  *   - ensure sane alignment of output data
#line 3101
  *   - copy (conversion happens automatically) input data
#line 3101
  *     to output
#line 3101
  *   - update tp to point at next unconverted input, and xpp to point
#line 3101
  *     at next location for converted output
#line 3101
  */
#line 3101
  long i, j, ni;
#line 3101
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3101
  int *xp;
#line 3101
  int nrange = 0;         /* number of range errors */
#line 3101
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3101
  long cxp = (long) *((char**)xpp);
#line 3101

#line 3101
  realign = (cxp & 7) % SIZEOF_INT;
#line 3101
  /* sjl: manually stripmine so we can limit amount of
#line 3101
   * vector work space reserved to LOOPCNT elements. Also
#line 3101
   * makes vectorisation easy */
#line 3101
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3101
    ni=Min(nelems-j,LOOPCNT);
#line 3101
    if (realign) {
#line 3101
      xp = tmp;
#line 3101
    } else {
#line 3101
      xp = (int *) *xpp;
#line 3101
    }
#line 3101
   /* copy the next block */
#line 3101
#pragma cdir loopcnt=LOOPCNT
#line 3101
#pragma cdir shortloop
#line 3101
    for (i=0; i<ni; i++) {
#line 3101
      /* the normal case: */
#line 3101
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3101
     /* test for range errors (not always needed but do it anyway) */
#line 3101
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3101
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3101
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 3101
    }
#line 3101
   /* copy workspace back if necessary */
#line 3101
    if (realign) {
#line 3101
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3101
      xp = (int *) *xpp;
#line 3101
    }
#line 3101
   /* update xpp and tp */
#line 3101
    xp += ni;
#line 3101
    tp += ni;
#line 3101
    *xpp = (void*)xp;
#line 3101
  }
#line 3101
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3101

#line 3101
#else   /* not SX */
#line 3101

#line 3101
	char *xp = (char *) *xpp;
#line 3101
	int status = NC_NOERR;
#line 3101

#line 3101
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3101
	{
#line 3101
		int lstatus = ncx_put_int_short(xp, tp, fillp);
#line 3101
		if (status == NC_NOERR) /* report the first encountered error */
#line 3101
			status = lstatus;
#line 3101
	}
#line 3101

#line 3101
	*xpp = (void *)xp;
#line 3101
	return status;
#line 3101
#endif
#line 3101
}
#line 3101

int
#line 3102
ncx_putn_int_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3102
{
#line 3102
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3102

#line 3102
 /* basic algorithm is:
#line 3102
  *   - ensure sane alignment of output data
#line 3102
  *   - copy (conversion happens automatically) input data
#line 3102
  *     to output
#line 3102
  *   - update tp to point at next unconverted input, and xpp to point
#line 3102
  *     at next location for converted output
#line 3102
  */
#line 3102
  long i, j, ni;
#line 3102
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3102
  int *xp;
#line 3102
  int nrange = 0;         /* number of range errors */
#line 3102
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3102
  long cxp = (long) *((char**)xpp);
#line 3102

#line 3102
  realign = (cxp & 7) % SIZEOF_INT;
#line 3102
  /* sjl: manually stripmine so we can limit amount of
#line 3102
   * vector work space reserved to LOOPCNT elements. Also
#line 3102
   * makes vectorisation easy */
#line 3102
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3102
    ni=Min(nelems-j,LOOPCNT);
#line 3102
    if (realign) {
#line 3102
      xp = tmp;
#line 3102
    } else {
#line 3102
      xp = (int *) *xpp;
#line 3102
    }
#line 3102
   /* copy the next block */
#line 3102
#pragma cdir loopcnt=LOOPCNT
#line 3102
#pragma cdir shortloop
#line 3102
    for (i=0; i<ni; i++) {
#line 3102
      /* the normal case: */
#line 3102
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3102
     /* test for range errors (not always needed but do it anyway) */
#line 3102
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3102
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3102
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 3102
    }
#line 3102
   /* copy workspace back if necessary */
#line 3102
    if (realign) {
#line 3102
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3102
      xp = (int *) *xpp;
#line 3102
    }
#line 3102
   /* update xpp and tp */
#line 3102
    xp += ni;
#line 3102
    tp += ni;
#line 3102
    *xpp = (void*)xp;
#line 3102
  }
#line 3102
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3102

#line 3102
#else   /* not SX */
#line 3102

#line 3102
	char *xp = (char *) *xpp;
#line 3102
	int status = NC_NOERR;
#line 3102

#line 3102
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3102
	{
#line 3102
		int lstatus = ncx_put_int_long(xp, tp, fillp);
#line 3102
		if (status == NC_NOERR) /* report the first encountered error */
#line 3102
			status = lstatus;
#line 3102
	}
#line 3102

#line 3102
	*xpp = (void *)xp;
#line 3102
	return status;
#line 3102
#endif
#line 3102
}
#line 3102

int
#line 3103
ncx_putn_int_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3103
{
#line 3103
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3103

#line 3103
 /* basic algorithm is:
#line 3103
  *   - ensure sane alignment of output data
#line 3103
  *   - copy (conversion happens automatically) input data
#line 3103
  *     to output
#line 3103
  *   - update tp to point at next unconverted input, and xpp to point
#line 3103
  *     at next location for converted output
#line 3103
  */
#line 3103
  long i, j, ni;
#line 3103
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3103
  int *xp;
#line 3103
  double d;               /* special case for ncx_putn_int_float */
#line 3103
  int nrange = 0;         /* number of range errors */
#line 3103
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3103
  long cxp = (long) *((char**)xpp);
#line 3103

#line 3103
  realign = (cxp & 7) % SIZEOF_INT;
#line 3103
  /* sjl: manually stripmine so we can limit amount of
#line 3103
   * vector work space reserved to LOOPCNT elements. Also
#line 3103
   * makes vectorisation easy */
#line 3103
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3103
    ni=Min(nelems-j,LOOPCNT);
#line 3103
    if (realign) {
#line 3103
      xp = tmp;
#line 3103
    } else {
#line 3103
      xp = (int *) *xpp;
#line 3103
    }
#line 3103
   /* copy the next block */
#line 3103
#pragma cdir loopcnt=LOOPCNT
#line 3103
#pragma cdir shortloop
#line 3103
    for (i=0; i<ni; i++) {
#line 3103
      /* for some reason int to float, for putn, requires a special case */
#line 3103
      d = tp[i];
#line 3103
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) d));
#line 3103
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 3103
    }
#line 3103
   /* copy workspace back if necessary */
#line 3103
    if (realign) {
#line 3103
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3103
      xp = (int *) *xpp;
#line 3103
    }
#line 3103
   /* update xpp and tp */
#line 3103
    xp += ni;
#line 3103
    tp += ni;
#line 3103
    *xpp = (void*)xp;
#line 3103
  }
#line 3103
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3103

#line 3103
#else   /* not SX */
#line 3103

#line 3103
	char *xp = (char *) *xpp;
#line 3103
	int status = NC_NOERR;
#line 3103

#line 3103
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3103
	{
#line 3103
		int lstatus = ncx_put_int_float(xp, tp, fillp);
#line 3103
		if (status == NC_NOERR) /* report the first encountered error */
#line 3103
			status = lstatus;
#line 3103
	}
#line 3103

#line 3103
	*xpp = (void *)xp;
#line 3103
	return status;
#line 3103
#endif
#line 3103
}
#line 3103

int
#line 3104
ncx_putn_int_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3104
{
#line 3104
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3104

#line 3104
 /* basic algorithm is:
#line 3104
  *   - ensure sane alignment of output data
#line 3104
  *   - copy (conversion happens automatically) input data
#line 3104
  *     to output
#line 3104
  *   - update tp to point at next unconverted input, and xpp to point
#line 3104
  *     at next location for converted output
#line 3104
  */
#line 3104
  long i, j, ni;
#line 3104
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3104
  int *xp;
#line 3104
  int nrange = 0;         /* number of range errors */
#line 3104
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3104
  long cxp = (long) *((char**)xpp);
#line 3104

#line 3104
  realign = (cxp & 7) % SIZEOF_INT;
#line 3104
  /* sjl: manually stripmine so we can limit amount of
#line 3104
   * vector work space reserved to LOOPCNT elements. Also
#line 3104
   * makes vectorisation easy */
#line 3104
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3104
    ni=Min(nelems-j,LOOPCNT);
#line 3104
    if (realign) {
#line 3104
      xp = tmp;
#line 3104
    } else {
#line 3104
      xp = (int *) *xpp;
#line 3104
    }
#line 3104
   /* copy the next block */
#line 3104
#pragma cdir loopcnt=LOOPCNT
#line 3104
#pragma cdir shortloop
#line 3104
    for (i=0; i<ni; i++) {
#line 3104
      /* the normal case: */
#line 3104
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3104
     /* test for range errors (not always needed but do it anyway) */
#line 3104
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3104
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3104
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 3104
    }
#line 3104
   /* copy workspace back if necessary */
#line 3104
    if (realign) {
#line 3104
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3104
      xp = (int *) *xpp;
#line 3104
    }
#line 3104
   /* update xpp and tp */
#line 3104
    xp += ni;
#line 3104
    tp += ni;
#line 3104
    *xpp = (void*)xp;
#line 3104
  }
#line 3104
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3104

#line 3104
#else   /* not SX */
#line 3104

#line 3104
	char *xp = (char *) *xpp;
#line 3104
	int status = NC_NOERR;
#line 3104

#line 3104
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3104
	{
#line 3104
		int lstatus = ncx_put_int_double(xp, tp, fillp);
#line 3104
		if (status == NC_NOERR) /* report the first encountered error */
#line 3104
			status = lstatus;
#line 3104
	}
#line 3104

#line 3104
	*xpp = (void *)xp;
#line 3104
	return status;
#line 3104
#endif
#line 3104
}
#line 3104

int
#line 3105
ncx_putn_int_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3105
{
#line 3105
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3105

#line 3105
 /* basic algorithm is:
#line 3105
  *   - ensure sane alignment of output data
#line 3105
  *   - copy (conversion happens automatically) input data
#line 3105
  *     to output
#line 3105
  *   - update tp to point at next unconverted input, and xpp to point
#line 3105
  *     at next location for converted output
#line 3105
  */
#line 3105
  long i, j, ni;
#line 3105
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3105
  int *xp;
#line 3105
  int nrange = 0;         /* number of range errors */
#line 3105
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3105
  long cxp = (long) *((char**)xpp);
#line 3105

#line 3105
  realign = (cxp & 7) % SIZEOF_INT;
#line 3105
  /* sjl: manually stripmine so we can limit amount of
#line 3105
   * vector work space reserved to LOOPCNT elements. Also
#line 3105
   * makes vectorisation easy */
#line 3105
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3105
    ni=Min(nelems-j,LOOPCNT);
#line 3105
    if (realign) {
#line 3105
      xp = tmp;
#line 3105
    } else {
#line 3105
      xp = (int *) *xpp;
#line 3105
    }
#line 3105
   /* copy the next block */
#line 3105
#pragma cdir loopcnt=LOOPCNT
#line 3105
#pragma cdir shortloop
#line 3105
    for (i=0; i<ni; i++) {
#line 3105
      /* the normal case: */
#line 3105
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3105
     /* test for range errors (not always needed but do it anyway) */
#line 3105
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3105
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3105
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 3105
    }
#line 3105
   /* copy workspace back if necessary */
#line 3105
    if (realign) {
#line 3105
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3105
      xp = (int *) *xpp;
#line 3105
    }
#line 3105
   /* update xpp and tp */
#line 3105
    xp += ni;
#line 3105
    tp += ni;
#line 3105
    *xpp = (void*)xp;
#line 3105
  }
#line 3105
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3105

#line 3105
#else   /* not SX */
#line 3105

#line 3105
	char *xp = (char *) *xpp;
#line 3105
	int status = NC_NOERR;
#line 3105

#line 3105
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3105
	{
#line 3105
		int lstatus = ncx_put_int_longlong(xp, tp, fillp);
#line 3105
		if (status == NC_NOERR) /* report the first encountered error */
#line 3105
			status = lstatus;
#line 3105
	}
#line 3105

#line 3105
	*xpp = (void *)xp;
#line 3105
	return status;
#line 3105
#endif
#line 3105
}
#line 3105

int
#line 3106
ncx_putn_int_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3106
{
#line 3106
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3106

#line 3106
 /* basic algorithm is:
#line 3106
  *   - ensure sane alignment of output data
#line 3106
  *   - copy (conversion happens automatically) input data
#line 3106
  *     to output
#line 3106
  *   - update tp to point at next unconverted input, and xpp to point
#line 3106
  *     at next location for converted output
#line 3106
  */
#line 3106
  long i, j, ni;
#line 3106
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3106
  int *xp;
#line 3106
  int nrange = 0;         /* number of range errors */
#line 3106
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3106
  long cxp = (long) *((char**)xpp);
#line 3106

#line 3106
  realign = (cxp & 7) % SIZEOF_INT;
#line 3106
  /* sjl: manually stripmine so we can limit amount of
#line 3106
   * vector work space reserved to LOOPCNT elements. Also
#line 3106
   * makes vectorisation easy */
#line 3106
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3106
    ni=Min(nelems-j,LOOPCNT);
#line 3106
    if (realign) {
#line 3106
      xp = tmp;
#line 3106
    } else {
#line 3106
      xp = (int *) *xpp;
#line 3106
    }
#line 3106
   /* copy the next block */
#line 3106
#pragma cdir loopcnt=LOOPCNT
#line 3106
#pragma cdir shortloop
#line 3106
    for (i=0; i<ni; i++) {
#line 3106
      /* the normal case: */
#line 3106
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3106
     /* test for range errors (not always needed but do it anyway) */
#line 3106
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3106
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3106
      nrange += tp[i] > X_INT_MAX ;
#line 3106
    }
#line 3106
   /* copy workspace back if necessary */
#line 3106
    if (realign) {
#line 3106
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3106
      xp = (int *) *xpp;
#line 3106
    }
#line 3106
   /* update xpp and tp */
#line 3106
    xp += ni;
#line 3106
    tp += ni;
#line 3106
    *xpp = (void*)xp;
#line 3106
  }
#line 3106
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3106

#line 3106
#else   /* not SX */
#line 3106

#line 3106
	char *xp = (char *) *xpp;
#line 3106
	int status = NC_NOERR;
#line 3106

#line 3106
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3106
	{
#line 3106
		int lstatus = ncx_put_int_uchar(xp, tp, fillp);
#line 3106
		if (status == NC_NOERR) /* report the first encountered error */
#line 3106
			status = lstatus;
#line 3106
	}
#line 3106

#line 3106
	*xpp = (void *)xp;
#line 3106
	return status;
#line 3106
#endif
#line 3106
}
#line 3106

int
#line 3107
ncx_putn_int_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3107
{
#line 3107
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3107

#line 3107
 /* basic algorithm is:
#line 3107
  *   - ensure sane alignment of output data
#line 3107
  *   - copy (conversion happens automatically) input data
#line 3107
  *     to output
#line 3107
  *   - update tp to point at next unconverted input, and xpp to point
#line 3107
  *     at next location for converted output
#line 3107
  */
#line 3107
  long i, j, ni;
#line 3107
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3107
  int *xp;
#line 3107
  int nrange = 0;         /* number of range errors */
#line 3107
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3107
  long cxp = (long) *((char**)xpp);
#line 3107

#line 3107
  realign = (cxp & 7) % SIZEOF_INT;
#line 3107
  /* sjl: manually stripmine so we can limit amount of
#line 3107
   * vector work space reserved to LOOPCNT elements. Also
#line 3107
   * makes vectorisation easy */
#line 3107
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3107
    ni=Min(nelems-j,LOOPCNT);
#line 3107
    if (realign) {
#line 3107
      xp = tmp;
#line 3107
    } else {
#line 3107
      xp = (int *) *xpp;
#line 3107
    }
#line 3107
   /* copy the next block */
#line 3107
#pragma cdir loopcnt=LOOPCNT
#line 3107
#pragma cdir shortloop
#line 3107
    for (i=0; i<ni; i++) {
#line 3107
      /* the normal case: */
#line 3107
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3107
     /* test for range errors (not always needed but do it anyway) */
#line 3107
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3107
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3107
      nrange += tp[i] > X_INT_MAX ;
#line 3107
    }
#line 3107
   /* copy workspace back if necessary */
#line 3107
    if (realign) {
#line 3107
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3107
      xp = (int *) *xpp;
#line 3107
    }
#line 3107
   /* update xpp and tp */
#line 3107
    xp += ni;
#line 3107
    tp += ni;
#line 3107
    *xpp = (void*)xp;
#line 3107
  }
#line 3107
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3107

#line 3107
#else   /* not SX */
#line 3107

#line 3107
	char *xp = (char *) *xpp;
#line 3107
	int status = NC_NOERR;
#line 3107

#line 3107
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3107
	{
#line 3107
		int lstatus = ncx_put_int_ushort(xp, tp, fillp);
#line 3107
		if (status == NC_NOERR) /* report the first encountered error */
#line 3107
			status = lstatus;
#line 3107
	}
#line 3107

#line 3107
	*xpp = (void *)xp;
#line 3107
	return status;
#line 3107
#endif
#line 3107
}
#line 3107

int
#line 3108
ncx_putn_int_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3108
{
#line 3108
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3108

#line 3108
 /* basic algorithm is:
#line 3108
  *   - ensure sane alignment of output data
#line 3108
  *   - copy (conversion happens automatically) input data
#line 3108
  *     to output
#line 3108
  *   - update tp to point at next unconverted input, and xpp to point
#line 3108
  *     at next location for converted output
#line 3108
  */
#line 3108
  long i, j, ni;
#line 3108
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3108
  int *xp;
#line 3108
  int nrange = 0;         /* number of range errors */
#line 3108
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3108
  long cxp = (long) *((char**)xpp);
#line 3108

#line 3108
  realign = (cxp & 7) % SIZEOF_INT;
#line 3108
  /* sjl: manually stripmine so we can limit amount of
#line 3108
   * vector work space reserved to LOOPCNT elements. Also
#line 3108
   * makes vectorisation easy */
#line 3108
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3108
    ni=Min(nelems-j,LOOPCNT);
#line 3108
    if (realign) {
#line 3108
      xp = tmp;
#line 3108
    } else {
#line 3108
      xp = (int *) *xpp;
#line 3108
    }
#line 3108
   /* copy the next block */
#line 3108
#pragma cdir loopcnt=LOOPCNT
#line 3108
#pragma cdir shortloop
#line 3108
    for (i=0; i<ni; i++) {
#line 3108
      /* the normal case: */
#line 3108
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3108
     /* test for range errors (not always needed but do it anyway) */
#line 3108
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3108
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3108
      nrange += tp[i] > X_INT_MAX ;
#line 3108
    }
#line 3108
   /* copy workspace back if necessary */
#line 3108
    if (realign) {
#line 3108
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3108
      xp = (int *) *xpp;
#line 3108
    }
#line 3108
   /* update xpp and tp */
#line 3108
    xp += ni;
#line 3108
    tp += ni;
#line 3108
    *xpp = (void*)xp;
#line 3108
  }
#line 3108
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3108

#line 3108
#else   /* not SX */
#line 3108

#line 3108
	char *xp = (char *) *xpp;
#line 3108
	int status = NC_NOERR;
#line 3108

#line 3108
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3108
	{
#line 3108
		int lstatus = ncx_put_int_uint(xp, tp, fillp);
#line 3108
		if (status == NC_NOERR) /* report the first encountered error */
#line 3108
			status = lstatus;
#line 3108
	}
#line 3108

#line 3108
	*xpp = (void *)xp;
#line 3108
	return status;
#line 3108
#endif
#line 3108
}
#line 3108

int
#line 3109
ncx_putn_int_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3109
{
#line 3109
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3109

#line 3109
 /* basic algorithm is:
#line 3109
  *   - ensure sane alignment of output data
#line 3109
  *   - copy (conversion happens automatically) input data
#line 3109
  *     to output
#line 3109
  *   - update tp to point at next unconverted input, and xpp to point
#line 3109
  *     at next location for converted output
#line 3109
  */
#line 3109
  long i, j, ni;
#line 3109
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3109
  int *xp;
#line 3109
  int nrange = 0;         /* number of range errors */
#line 3109
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3109
  long cxp = (long) *((char**)xpp);
#line 3109

#line 3109
  realign = (cxp & 7) % SIZEOF_INT;
#line 3109
  /* sjl: manually stripmine so we can limit amount of
#line 3109
   * vector work space reserved to LOOPCNT elements. Also
#line 3109
   * makes vectorisation easy */
#line 3109
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3109
    ni=Min(nelems-j,LOOPCNT);
#line 3109
    if (realign) {
#line 3109
      xp = tmp;
#line 3109
    } else {
#line 3109
      xp = (int *) *xpp;
#line 3109
    }
#line 3109
   /* copy the next block */
#line 3109
#pragma cdir loopcnt=LOOPCNT
#line 3109
#pragma cdir shortloop
#line 3109
    for (i=0; i<ni; i++) {
#line 3109
      /* the normal case: */
#line 3109
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3109
     /* test for range errors (not always needed but do it anyway) */
#line 3109
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3109
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3109
      nrange += tp[i] > X_INT_MAX ;
#line 3109
    }
#line 3109
   /* copy workspace back if necessary */
#line 3109
    if (realign) {
#line 3109
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3109
      xp = (int *) *xpp;
#line 3109
    }
#line 3109
   /* update xpp and tp */
#line 3109
    xp += ni;
#line 3109
    tp += ni;
#line 3109
    *xpp = (void*)xp;
#line 3109
  }
#line 3109
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3109

#line 3109
#else   /* not SX */
#line 3109

#line 3109
	char *xp = (char *) *xpp;
#line 3109
	int status = NC_NOERR;
#line 3109

#line 3109
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3109
	{
#line 3109
		int lstatus = ncx_put_int_ulonglong(xp, tp, fillp);
#line 3109
		if (status == NC_NOERR) /* report the first encountered error */
#line 3109
			status = lstatus;
#line 3109
	}
#line 3109

#line 3109
	*xpp = (void *)xp;
#line 3109
	return status;
#line 3109
#endif
#line 3109
}
#line 3109


/* uint ----------------------------------------------------------------------*/

#if X_SIZEOF_UINT == SIZEOF_UINT
/* optimized version */
int
ncx_getn_uint_uint(const void **xpp, size_t nelems, unsigned int *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_UINT);
# else
	swapn4b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_UINT);
	return NC_NOERR;
}
#else
int
#line 3127
ncx_getn_uint_uint(const void **xpp, size_t nelems, uint *tp)
#line 3127
{
#line 3127
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3127

#line 3127
 /* basic algorithm is:
#line 3127
  *   - ensure sane alignment of input data
#line 3127
  *   - copy (conversion happens automatically) input data
#line 3127
  *     to output
#line 3127
  *   - update xpp to point at next unconverted input, and tp to point
#line 3127
  *     at next location for converted output
#line 3127
  */
#line 3127
  long i, j, ni;
#line 3127
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3127
  uint *xp;
#line 3127
  int nrange = 0;         /* number of range errors */
#line 3127
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3127
  long cxp = (long) *((char**)xpp);
#line 3127

#line 3127
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3127
  /* sjl: manually stripmine so we can limit amount of
#line 3127
   * vector work space reserved to LOOPCNT elements. Also
#line 3127
   * makes vectorisation easy */
#line 3127
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3127
    ni=Min(nelems-j,LOOPCNT);
#line 3127
    if (realign) {
#line 3127
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3127
      xp = tmp;
#line 3127
    } else {
#line 3127
      xp = (uint *) *xpp;
#line 3127
    }
#line 3127
   /* copy the next block */
#line 3127
#pragma cdir loopcnt=LOOPCNT
#line 3127
#pragma cdir shortloop
#line 3127
    for (i=0; i<ni; i++) {
#line 3127
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3127
     /* test for range errors (not always needed but do it anyway) */
#line 3127
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3127
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3127
      nrange += xp[i] > UINT_MAX ;
#line 3127
    }
#line 3127
   /* update xpp and tp */
#line 3127
    if (realign) xp = (uint *) *xpp;
#line 3127
    xp += ni;
#line 3127
    tp += ni;
#line 3127
    *xpp = (void*)xp;
#line 3127
  }
#line 3127
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3127

#line 3127
#else   /* not SX */
#line 3127
	const char *xp = (const char *) *xpp;
#line 3127
	int status = NC_NOERR;
#line 3127

#line 3127
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3127
	{
#line 3127
		const int lstatus = ncx_get_uint_uint(xp, tp);
#line 3127
		if (status == NC_NOERR) /* report the first encountered error */
#line 3127
			status = lstatus;
#line 3127
	}
#line 3127

#line 3127
	*xpp = (const void *)xp;
#line 3127
	return status;
#line 3127
#endif
#line 3127
}
#line 3127

#endif
int
#line 3129
ncx_getn_uint_schar(const void **xpp, size_t nelems, schar *tp)
#line 3129
{
#line 3129
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3129

#line 3129
 /* basic algorithm is:
#line 3129
  *   - ensure sane alignment of input data
#line 3129
  *   - copy (conversion happens automatically) input data
#line 3129
  *     to output
#line 3129
  *   - update xpp to point at next unconverted input, and tp to point
#line 3129
  *     at next location for converted output
#line 3129
  */
#line 3129
  long i, j, ni;
#line 3129
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3129
  uint *xp;
#line 3129
  int nrange = 0;         /* number of range errors */
#line 3129
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3129
  long cxp = (long) *((char**)xpp);
#line 3129

#line 3129
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3129
  /* sjl: manually stripmine so we can limit amount of
#line 3129
   * vector work space reserved to LOOPCNT elements. Also
#line 3129
   * makes vectorisation easy */
#line 3129
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3129
    ni=Min(nelems-j,LOOPCNT);
#line 3129
    if (realign) {
#line 3129
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3129
      xp = tmp;
#line 3129
    } else {
#line 3129
      xp = (uint *) *xpp;
#line 3129
    }
#line 3129
   /* copy the next block */
#line 3129
#pragma cdir loopcnt=LOOPCNT
#line 3129
#pragma cdir shortloop
#line 3129
    for (i=0; i<ni; i++) {
#line 3129
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3129
     /* test for range errors (not always needed but do it anyway) */
#line 3129
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3129
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3129
      nrange += xp[i] > SCHAR_MAX ;
#line 3129
    }
#line 3129
   /* update xpp and tp */
#line 3129
    if (realign) xp = (uint *) *xpp;
#line 3129
    xp += ni;
#line 3129
    tp += ni;
#line 3129
    *xpp = (void*)xp;
#line 3129
  }
#line 3129
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3129

#line 3129
#else   /* not SX */
#line 3129
	const char *xp = (const char *) *xpp;
#line 3129
	int status = NC_NOERR;
#line 3129

#line 3129
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3129
	{
#line 3129
		const int lstatus = ncx_get_uint_schar(xp, tp);
#line 3129
		if (status == NC_NOERR) /* report the first encountered error */
#line 3129
			status = lstatus;
#line 3129
	}
#line 3129

#line 3129
	*xpp = (const void *)xp;
#line 3129
	return status;
#line 3129
#endif
#line 3129
}
#line 3129

int
#line 3130
ncx_getn_uint_short(const void **xpp, size_t nelems, short *tp)
#line 3130
{
#line 3130
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3130

#line 3130
 /* basic algorithm is:
#line 3130
  *   - ensure sane alignment of input data
#line 3130
  *   - copy (conversion happens automatically) input data
#line 3130
  *     to output
#line 3130
  *   - update xpp to point at next unconverted input, and tp to point
#line 3130
  *     at next location for converted output
#line 3130
  */
#line 3130
  long i, j, ni;
#line 3130
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3130
  uint *xp;
#line 3130
  int nrange = 0;         /* number of range errors */
#line 3130
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3130
  long cxp = (long) *((char**)xpp);
#line 3130

#line 3130
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3130
  /* sjl: manually stripmine so we can limit amount of
#line 3130
   * vector work space reserved to LOOPCNT elements. Also
#line 3130
   * makes vectorisation easy */
#line 3130
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3130
    ni=Min(nelems-j,LOOPCNT);
#line 3130
    if (realign) {
#line 3130
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3130
      xp = tmp;
#line 3130
    } else {
#line 3130
      xp = (uint *) *xpp;
#line 3130
    }
#line 3130
   /* copy the next block */
#line 3130
#pragma cdir loopcnt=LOOPCNT
#line 3130
#pragma cdir shortloop
#line 3130
    for (i=0; i<ni; i++) {
#line 3130
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3130
     /* test for range errors (not always needed but do it anyway) */
#line 3130
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3130
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3130
      nrange += xp[i] > SHORT_MAX ;
#line 3130
    }
#line 3130
   /* update xpp and tp */
#line 3130
    if (realign) xp = (uint *) *xpp;
#line 3130
    xp += ni;
#line 3130
    tp += ni;
#line 3130
    *xpp = (void*)xp;
#line 3130
  }
#line 3130
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3130

#line 3130
#else   /* not SX */
#line 3130
	const char *xp = (const char *) *xpp;
#line 3130
	int status = NC_NOERR;
#line 3130

#line 3130
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3130
	{
#line 3130
		const int lstatus = ncx_get_uint_short(xp, tp);
#line 3130
		if (status == NC_NOERR) /* report the first encountered error */
#line 3130
			status = lstatus;
#line 3130
	}
#line 3130

#line 3130
	*xpp = (const void *)xp;
#line 3130
	return status;
#line 3130
#endif
#line 3130
}
#line 3130

int
#line 3131
ncx_getn_uint_int(const void **xpp, size_t nelems, int *tp)
#line 3131
{
#line 3131
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3131

#line 3131
 /* basic algorithm is:
#line 3131
  *   - ensure sane alignment of input data
#line 3131
  *   - copy (conversion happens automatically) input data
#line 3131
  *     to output
#line 3131
  *   - update xpp to point at next unconverted input, and tp to point
#line 3131
  *     at next location for converted output
#line 3131
  */
#line 3131
  long i, j, ni;
#line 3131
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3131
  uint *xp;
#line 3131
  int nrange = 0;         /* number of range errors */
#line 3131
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3131
  long cxp = (long) *((char**)xpp);
#line 3131

#line 3131
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3131
  /* sjl: manually stripmine so we can limit amount of
#line 3131
   * vector work space reserved to LOOPCNT elements. Also
#line 3131
   * makes vectorisation easy */
#line 3131
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3131
    ni=Min(nelems-j,LOOPCNT);
#line 3131
    if (realign) {
#line 3131
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3131
      xp = tmp;
#line 3131
    } else {
#line 3131
      xp = (uint *) *xpp;
#line 3131
    }
#line 3131
   /* copy the next block */
#line 3131
#pragma cdir loopcnt=LOOPCNT
#line 3131
#pragma cdir shortloop
#line 3131
    for (i=0; i<ni; i++) {
#line 3131
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3131
     /* test for range errors (not always needed but do it anyway) */
#line 3131
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3131
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3131
      nrange += xp[i] > INT_MAX ;
#line 3131
    }
#line 3131
   /* update xpp and tp */
#line 3131
    if (realign) xp = (uint *) *xpp;
#line 3131
    xp += ni;
#line 3131
    tp += ni;
#line 3131
    *xpp = (void*)xp;
#line 3131
  }
#line 3131
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3131

#line 3131
#else   /* not SX */
#line 3131
	const char *xp = (const char *) *xpp;
#line 3131
	int status = NC_NOERR;
#line 3131

#line 3131
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3131
	{
#line 3131
		const int lstatus = ncx_get_uint_int(xp, tp);
#line 3131
		if (status == NC_NOERR) /* report the first encountered error */
#line 3131
			status = lstatus;
#line 3131
	}
#line 3131

#line 3131
	*xpp = (const void *)xp;
#line 3131
	return status;
#line 3131
#endif
#line 3131
}
#line 3131

int
#line 3132
ncx_getn_uint_long(const void **xpp, size_t nelems, long *tp)
#line 3132
{
#line 3132
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3132

#line 3132
 /* basic algorithm is:
#line 3132
  *   - ensure sane alignment of input data
#line 3132
  *   - copy (conversion happens automatically) input data
#line 3132
  *     to output
#line 3132
  *   - update xpp to point at next unconverted input, and tp to point
#line 3132
  *     at next location for converted output
#line 3132
  */
#line 3132
  long i, j, ni;
#line 3132
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3132
  uint *xp;
#line 3132
  int nrange = 0;         /* number of range errors */
#line 3132
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3132
  long cxp = (long) *((char**)xpp);
#line 3132

#line 3132
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3132
  /* sjl: manually stripmine so we can limit amount of
#line 3132
   * vector work space reserved to LOOPCNT elements. Also
#line 3132
   * makes vectorisation easy */
#line 3132
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3132
    ni=Min(nelems-j,LOOPCNT);
#line 3132
    if (realign) {
#line 3132
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3132
      xp = tmp;
#line 3132
    } else {
#line 3132
      xp = (uint *) *xpp;
#line 3132
    }
#line 3132
   /* copy the next block */
#line 3132
#pragma cdir loopcnt=LOOPCNT
#line 3132
#pragma cdir shortloop
#line 3132
    for (i=0; i<ni; i++) {
#line 3132
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3132
     /* test for range errors (not always needed but do it anyway) */
#line 3132
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3132
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3132
      nrange += xp[i] > LONG_MAX ;
#line 3132
    }
#line 3132
   /* update xpp and tp */
#line 3132
    if (realign) xp = (uint *) *xpp;
#line 3132
    xp += ni;
#line 3132
    tp += ni;
#line 3132
    *xpp = (void*)xp;
#line 3132
  }
#line 3132
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3132

#line 3132
#else   /* not SX */
#line 3132
	const char *xp = (const char *) *xpp;
#line 3132
	int status = NC_NOERR;
#line 3132

#line 3132
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3132
	{
#line 3132
		const int lstatus = ncx_get_uint_long(xp, tp);
#line 3132
		if (status == NC_NOERR) /* report the first encountered error */
#line 3132
			status = lstatus;
#line 3132
	}
#line 3132

#line 3132
	*xpp = (const void *)xp;
#line 3132
	return status;
#line 3132
#endif
#line 3132
}
#line 3132

int
#line 3133
ncx_getn_uint_float(const void **xpp, size_t nelems, float *tp)
#line 3133
{
#line 3133
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3133

#line 3133
 /* basic algorithm is:
#line 3133
  *   - ensure sane alignment of input data
#line 3133
  *   - copy (conversion happens automatically) input data
#line 3133
  *     to output
#line 3133
  *   - update xpp to point at next unconverted input, and tp to point
#line 3133
  *     at next location for converted output
#line 3133
  */
#line 3133
  long i, j, ni;
#line 3133
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3133
  uint *xp;
#line 3133
  int nrange = 0;         /* number of range errors */
#line 3133
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3133
  long cxp = (long) *((char**)xpp);
#line 3133

#line 3133
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3133
  /* sjl: manually stripmine so we can limit amount of
#line 3133
   * vector work space reserved to LOOPCNT elements. Also
#line 3133
   * makes vectorisation easy */
#line 3133
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3133
    ni=Min(nelems-j,LOOPCNT);
#line 3133
    if (realign) {
#line 3133
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3133
      xp = tmp;
#line 3133
    } else {
#line 3133
      xp = (uint *) *xpp;
#line 3133
    }
#line 3133
   /* copy the next block */
#line 3133
#pragma cdir loopcnt=LOOPCNT
#line 3133
#pragma cdir shortloop
#line 3133
    for (i=0; i<ni; i++) {
#line 3133
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 3133
     /* test for range errors (not always needed but do it anyway) */
#line 3133
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3133
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3133
      nrange += xp[i] > FLOAT_MAX ;
#line 3133
    }
#line 3133
   /* update xpp and tp */
#line 3133
    if (realign) xp = (uint *) *xpp;
#line 3133
    xp += ni;
#line 3133
    tp += ni;
#line 3133
    *xpp = (void*)xp;
#line 3133
  }
#line 3133
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3133

#line 3133
#else   /* not SX */
#line 3133
	const char *xp = (const char *) *xpp;
#line 3133
	int status = NC_NOERR;
#line 3133

#line 3133
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3133
	{
#line 3133
		const int lstatus = ncx_get_uint_float(xp, tp);
#line 3133
		if (status == NC_NOERR) /* report the first encountered error */
#line 3133
			status = lstatus;
#line 3133
	}
#line 3133

#line 3133
	*xpp = (const void *)xp;
#line 3133
	return status;
#line 3133
#endif
#line 3133
}
#line 3133

int
#line 3134
ncx_getn_uint_double(const void **xpp, size_t nelems, double *tp)
#line 3134
{
#line 3134
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3134

#line 3134
 /* basic algorithm is:
#line 3134
  *   - ensure sane alignment of input data
#line 3134
  *   - copy (conversion happens automatically) input data
#line 3134
  *     to output
#line 3134
  *   - update xpp to point at next unconverted input, and tp to point
#line 3134
  *     at next location for converted output
#line 3134
  */
#line 3134
  long i, j, ni;
#line 3134
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3134
  uint *xp;
#line 3134
  int nrange = 0;         /* number of range errors */
#line 3134
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3134
  long cxp = (long) *((char**)xpp);
#line 3134

#line 3134
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3134
  /* sjl: manually stripmine so we can limit amount of
#line 3134
   * vector work space reserved to LOOPCNT elements. Also
#line 3134
   * makes vectorisation easy */
#line 3134
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3134
    ni=Min(nelems-j,LOOPCNT);
#line 3134
    if (realign) {
#line 3134
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3134
      xp = tmp;
#line 3134
    } else {
#line 3134
      xp = (uint *) *xpp;
#line 3134
    }
#line 3134
   /* copy the next block */
#line 3134
#pragma cdir loopcnt=LOOPCNT
#line 3134
#pragma cdir shortloop
#line 3134
    for (i=0; i<ni; i++) {
#line 3134
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 3134
     /* test for range errors (not always needed but do it anyway) */
#line 3134
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3134
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3134
      nrange += xp[i] > DOUBLE_MAX ;
#line 3134
    }
#line 3134
   /* update xpp and tp */
#line 3134
    if (realign) xp = (uint *) *xpp;
#line 3134
    xp += ni;
#line 3134
    tp += ni;
#line 3134
    *xpp = (void*)xp;
#line 3134
  }
#line 3134
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3134

#line 3134
#else   /* not SX */
#line 3134
	const char *xp = (const char *) *xpp;
#line 3134
	int status = NC_NOERR;
#line 3134

#line 3134
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3134
	{
#line 3134
		const int lstatus = ncx_get_uint_double(xp, tp);
#line 3134
		if (status == NC_NOERR) /* report the first encountered error */
#line 3134
			status = lstatus;
#line 3134
	}
#line 3134

#line 3134
	*xpp = (const void *)xp;
#line 3134
	return status;
#line 3134
#endif
#line 3134
}
#line 3134

int
#line 3135
ncx_getn_uint_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3135
{
#line 3135
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3135

#line 3135
 /* basic algorithm is:
#line 3135
  *   - ensure sane alignment of input data
#line 3135
  *   - copy (conversion happens automatically) input data
#line 3135
  *     to output
#line 3135
  *   - update xpp to point at next unconverted input, and tp to point
#line 3135
  *     at next location for converted output
#line 3135
  */
#line 3135
  long i, j, ni;
#line 3135
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3135
  uint *xp;
#line 3135
  int nrange = 0;         /* number of range errors */
#line 3135
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3135
  long cxp = (long) *((char**)xpp);
#line 3135

#line 3135
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3135
  /* sjl: manually stripmine so we can limit amount of
#line 3135
   * vector work space reserved to LOOPCNT elements. Also
#line 3135
   * makes vectorisation easy */
#line 3135
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3135
    ni=Min(nelems-j,LOOPCNT);
#line 3135
    if (realign) {
#line 3135
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3135
      xp = tmp;
#line 3135
    } else {
#line 3135
      xp = (uint *) *xpp;
#line 3135
    }
#line 3135
   /* copy the next block */
#line 3135
#pragma cdir loopcnt=LOOPCNT
#line 3135
#pragma cdir shortloop
#line 3135
    for (i=0; i<ni; i++) {
#line 3135
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3135
     /* test for range errors (not always needed but do it anyway) */
#line 3135
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3135
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3135
      nrange += xp[i] > LONGLONG_MAX ;
#line 3135
    }
#line 3135
   /* update xpp and tp */
#line 3135
    if (realign) xp = (uint *) *xpp;
#line 3135
    xp += ni;
#line 3135
    tp += ni;
#line 3135
    *xpp = (void*)xp;
#line 3135
  }
#line 3135
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3135

#line 3135
#else   /* not SX */
#line 3135
	const char *xp = (const char *) *xpp;
#line 3135
	int status = NC_NOERR;
#line 3135

#line 3135
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3135
	{
#line 3135
		const int lstatus = ncx_get_uint_longlong(xp, tp);
#line 3135
		if (status == NC_NOERR) /* report the first encountered error */
#line 3135
			status = lstatus;
#line 3135
	}
#line 3135

#line 3135
	*xpp = (const void *)xp;
#line 3135
	return status;
#line 3135
#endif
#line 3135
}
#line 3135

int
#line 3136
ncx_getn_uint_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3136
{
#line 3136
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3136

#line 3136
 /* basic algorithm is:
#line 3136
  *   - ensure sane alignment of input data
#line 3136
  *   - copy (conversion happens automatically) input data
#line 3136
  *     to output
#line 3136
  *   - update xpp to point at next unconverted input, and tp to point
#line 3136
  *     at next location for converted output
#line 3136
  */
#line 3136
  long i, j, ni;
#line 3136
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3136
  uint *xp;
#line 3136
  int nrange = 0;         /* number of range errors */
#line 3136
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3136
  long cxp = (long) *((char**)xpp);
#line 3136

#line 3136
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3136
  /* sjl: manually stripmine so we can limit amount of
#line 3136
   * vector work space reserved to LOOPCNT elements. Also
#line 3136
   * makes vectorisation easy */
#line 3136
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3136
    ni=Min(nelems-j,LOOPCNT);
#line 3136
    if (realign) {
#line 3136
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3136
      xp = tmp;
#line 3136
    } else {
#line 3136
      xp = (uint *) *xpp;
#line 3136
    }
#line 3136
   /* copy the next block */
#line 3136
#pragma cdir loopcnt=LOOPCNT
#line 3136
#pragma cdir shortloop
#line 3136
    for (i=0; i<ni; i++) {
#line 3136
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3136
     /* test for range errors (not always needed but do it anyway) */
#line 3136
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3136
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3136
      nrange += xp[i] > UCHAR_MAX ;
#line 3136
    }
#line 3136
   /* update xpp and tp */
#line 3136
    if (realign) xp = (uint *) *xpp;
#line 3136
    xp += ni;
#line 3136
    tp += ni;
#line 3136
    *xpp = (void*)xp;
#line 3136
  }
#line 3136
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3136

#line 3136
#else   /* not SX */
#line 3136
	const char *xp = (const char *) *xpp;
#line 3136
	int status = NC_NOERR;
#line 3136

#line 3136
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3136
	{
#line 3136
		const int lstatus = ncx_get_uint_uchar(xp, tp);
#line 3136
		if (status == NC_NOERR) /* report the first encountered error */
#line 3136
			status = lstatus;
#line 3136
	}
#line 3136

#line 3136
	*xpp = (const void *)xp;
#line 3136
	return status;
#line 3136
#endif
#line 3136
}
#line 3136

int
#line 3137
ncx_getn_uint_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3137
{
#line 3137
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3137

#line 3137
 /* basic algorithm is:
#line 3137
  *   - ensure sane alignment of input data
#line 3137
  *   - copy (conversion happens automatically) input data
#line 3137
  *     to output
#line 3137
  *   - update xpp to point at next unconverted input, and tp to point
#line 3137
  *     at next location for converted output
#line 3137
  */
#line 3137
  long i, j, ni;
#line 3137
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3137
  uint *xp;
#line 3137
  int nrange = 0;         /* number of range errors */
#line 3137
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3137
  long cxp = (long) *((char**)xpp);
#line 3137

#line 3137
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3137
  /* sjl: manually stripmine so we can limit amount of
#line 3137
   * vector work space reserved to LOOPCNT elements. Also
#line 3137
   * makes vectorisation easy */
#line 3137
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3137
    ni=Min(nelems-j,LOOPCNT);
#line 3137
    if (realign) {
#line 3137
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3137
      xp = tmp;
#line 3137
    } else {
#line 3137
      xp = (uint *) *xpp;
#line 3137
    }
#line 3137
   /* copy the next block */
#line 3137
#pragma cdir loopcnt=LOOPCNT
#line 3137
#pragma cdir shortloop
#line 3137
    for (i=0; i<ni; i++) {
#line 3137
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3137
     /* test for range errors (not always needed but do it anyway) */
#line 3137
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3137
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3137
      nrange += xp[i] > USHORT_MAX ;
#line 3137
    }
#line 3137
   /* update xpp and tp */
#line 3137
    if (realign) xp = (uint *) *xpp;
#line 3137
    xp += ni;
#line 3137
    tp += ni;
#line 3137
    *xpp = (void*)xp;
#line 3137
  }
#line 3137
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3137

#line 3137
#else   /* not SX */
#line 3137
	const char *xp = (const char *) *xpp;
#line 3137
	int status = NC_NOERR;
#line 3137

#line 3137
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3137
	{
#line 3137
		const int lstatus = ncx_get_uint_ushort(xp, tp);
#line 3137
		if (status == NC_NOERR) /* report the first encountered error */
#line 3137
			status = lstatus;
#line 3137
	}
#line 3137

#line 3137
	*xpp = (const void *)xp;
#line 3137
	return status;
#line 3137
#endif
#line 3137
}
#line 3137

int
#line 3138
ncx_getn_uint_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3138
{
#line 3138
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3138

#line 3138
 /* basic algorithm is:
#line 3138
  *   - ensure sane alignment of input data
#line 3138
  *   - copy (conversion happens automatically) input data
#line 3138
  *     to output
#line 3138
  *   - update xpp to point at next unconverted input, and tp to point
#line 3138
  *     at next location for converted output
#line 3138
  */
#line 3138
  long i, j, ni;
#line 3138
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3138
  uint *xp;
#line 3138
  int nrange = 0;         /* number of range errors */
#line 3138
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3138
  long cxp = (long) *((char**)xpp);
#line 3138

#line 3138
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3138
  /* sjl: manually stripmine so we can limit amount of
#line 3138
   * vector work space reserved to LOOPCNT elements. Also
#line 3138
   * makes vectorisation easy */
#line 3138
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3138
    ni=Min(nelems-j,LOOPCNT);
#line 3138
    if (realign) {
#line 3138
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3138
      xp = tmp;
#line 3138
    } else {
#line 3138
      xp = (uint *) *xpp;
#line 3138
    }
#line 3138
   /* copy the next block */
#line 3138
#pragma cdir loopcnt=LOOPCNT
#line 3138
#pragma cdir shortloop
#line 3138
    for (i=0; i<ni; i++) {
#line 3138
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3138
     /* test for range errors (not always needed but do it anyway) */
#line 3138
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3138
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3138
      nrange += xp[i] > ULONGLONG_MAX ;
#line 3138
    }
#line 3138
   /* update xpp and tp */
#line 3138
    if (realign) xp = (uint *) *xpp;
#line 3138
    xp += ni;
#line 3138
    tp += ni;
#line 3138
    *xpp = (void*)xp;
#line 3138
  }
#line 3138
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3138

#line 3138
#else   /* not SX */
#line 3138
	const char *xp = (const char *) *xpp;
#line 3138
	int status = NC_NOERR;
#line 3138

#line 3138
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3138
	{
#line 3138
		const int lstatus = ncx_get_uint_ulonglong(xp, tp);
#line 3138
		if (status == NC_NOERR) /* report the first encountered error */
#line 3138
			status = lstatus;
#line 3138
	}
#line 3138

#line 3138
	*xpp = (const void *)xp;
#line 3138
	return status;
#line 3138
#endif
#line 3138
}
#line 3138


#if X_SIZEOF_UINT == SIZEOF_UINT
/* optimized version */
int
ncx_putn_uint_uint(void **xpp, size_t nelems, const unsigned int *tp, void *fillp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_UINT);
# else
	swapn4b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_UINT);
	return NC_NOERR;
}
#else
int
#line 3154
ncx_putn_uint_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3154
{
#line 3154
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3154

#line 3154
 /* basic algorithm is:
#line 3154
  *   - ensure sane alignment of output data
#line 3154
  *   - copy (conversion happens automatically) input data
#line 3154
  *     to output
#line 3154
  *   - update tp to point at next unconverted input, and xpp to point
#line 3154
  *     at next location for converted output
#line 3154
  */
#line 3154
  long i, j, ni;
#line 3154
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3154
  uint *xp;
#line 3154
  int nrange = 0;         /* number of range errors */
#line 3154
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3154
  long cxp = (long) *((char**)xpp);
#line 3154

#line 3154
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3154
  /* sjl: manually stripmine so we can limit amount of
#line 3154
   * vector work space reserved to LOOPCNT elements. Also
#line 3154
   * makes vectorisation easy */
#line 3154
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3154
    ni=Min(nelems-j,LOOPCNT);
#line 3154
    if (realign) {
#line 3154
      xp = tmp;
#line 3154
    } else {
#line 3154
      xp = (uint *) *xpp;
#line 3154
    }
#line 3154
   /* copy the next block */
#line 3154
#pragma cdir loopcnt=LOOPCNT
#line 3154
#pragma cdir shortloop
#line 3154
    for (i=0; i<ni; i++) {
#line 3154
      /* the normal case: */
#line 3154
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3154
     /* test for range errors (not always needed but do it anyway) */
#line 3154
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3154
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3154
      nrange += tp[i] > X_UINT_MAX ;
#line 3154
    }
#line 3154
   /* copy workspace back if necessary */
#line 3154
    if (realign) {
#line 3154
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3154
      xp = (uint *) *xpp;
#line 3154
    }
#line 3154
   /* update xpp and tp */
#line 3154
    xp += ni;
#line 3154
    tp += ni;
#line 3154
    *xpp = (void*)xp;
#line 3154
  }
#line 3154
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3154

#line 3154
#else   /* not SX */
#line 3154

#line 3154
	char *xp = (char *) *xpp;
#line 3154
	int status = NC_NOERR;
#line 3154

#line 3154
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3154
	{
#line 3154
		int lstatus = ncx_put_uint_uint(xp, tp, fillp);
#line 3154
		if (status == NC_NOERR) /* report the first encountered error */
#line 3154
			status = lstatus;
#line 3154
	}
#line 3154

#line 3154
	*xpp = (void *)xp;
#line 3154
	return status;
#line 3154
#endif
#line 3154
}
#line 3154

#endif
int
#line 3156
ncx_putn_uint_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3156
{
#line 3156
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3156

#line 3156
 /* basic algorithm is:
#line 3156
  *   - ensure sane alignment of output data
#line 3156
  *   - copy (conversion happens automatically) input data
#line 3156
  *     to output
#line 3156
  *   - update tp to point at next unconverted input, and xpp to point
#line 3156
  *     at next location for converted output
#line 3156
  */
#line 3156
  long i, j, ni;
#line 3156
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3156
  uint *xp;
#line 3156
  int nrange = 0;         /* number of range errors */
#line 3156
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3156
  long cxp = (long) *((char**)xpp);
#line 3156

#line 3156
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3156
  /* sjl: manually stripmine so we can limit amount of
#line 3156
   * vector work space reserved to LOOPCNT elements. Also
#line 3156
   * makes vectorisation easy */
#line 3156
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3156
    ni=Min(nelems-j,LOOPCNT);
#line 3156
    if (realign) {
#line 3156
      xp = tmp;
#line 3156
    } else {
#line 3156
      xp = (uint *) *xpp;
#line 3156
    }
#line 3156
   /* copy the next block */
#line 3156
#pragma cdir loopcnt=LOOPCNT
#line 3156
#pragma cdir shortloop
#line 3156
    for (i=0; i<ni; i++) {
#line 3156
      /* the normal case: */
#line 3156
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3156
     /* test for range errors (not always needed but do it anyway) */
#line 3156
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3156
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3156
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 3156
    }
#line 3156
   /* copy workspace back if necessary */
#line 3156
    if (realign) {
#line 3156
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3156
      xp = (uint *) *xpp;
#line 3156
    }
#line 3156
   /* update xpp and tp */
#line 3156
    xp += ni;
#line 3156
    tp += ni;
#line 3156
    *xpp = (void*)xp;
#line 3156
  }
#line 3156
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3156

#line 3156
#else   /* not SX */
#line 3156

#line 3156
	char *xp = (char *) *xpp;
#line 3156
	int status = NC_NOERR;
#line 3156

#line 3156
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3156
	{
#line 3156
		int lstatus = ncx_put_uint_schar(xp, tp, fillp);
#line 3156
		if (status == NC_NOERR) /* report the first encountered error */
#line 3156
			status = lstatus;
#line 3156
	}
#line 3156

#line 3156
	*xpp = (void *)xp;
#line 3156
	return status;
#line 3156
#endif
#line 3156
}
#line 3156

int
#line 3157
ncx_putn_uint_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3157
{
#line 3157
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3157

#line 3157
 /* basic algorithm is:
#line 3157
  *   - ensure sane alignment of output data
#line 3157
  *   - copy (conversion happens automatically) input data
#line 3157
  *     to output
#line 3157
  *   - update tp to point at next unconverted input, and xpp to point
#line 3157
  *     at next location for converted output
#line 3157
  */
#line 3157
  long i, j, ni;
#line 3157
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3157
  uint *xp;
#line 3157
  int nrange = 0;         /* number of range errors */
#line 3157
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3157
  long cxp = (long) *((char**)xpp);
#line 3157

#line 3157
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3157
  /* sjl: manually stripmine so we can limit amount of
#line 3157
   * vector work space reserved to LOOPCNT elements. Also
#line 3157
   * makes vectorisation easy */
#line 3157
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3157
    ni=Min(nelems-j,LOOPCNT);
#line 3157
    if (realign) {
#line 3157
      xp = tmp;
#line 3157
    } else {
#line 3157
      xp = (uint *) *xpp;
#line 3157
    }
#line 3157
   /* copy the next block */
#line 3157
#pragma cdir loopcnt=LOOPCNT
#line 3157
#pragma cdir shortloop
#line 3157
    for (i=0; i<ni; i++) {
#line 3157
      /* the normal case: */
#line 3157
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3157
     /* test for range errors (not always needed but do it anyway) */
#line 3157
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3157
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3157
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 3157
    }
#line 3157
   /* copy workspace back if necessary */
#line 3157
    if (realign) {
#line 3157
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3157
      xp = (uint *) *xpp;
#line 3157
    }
#line 3157
   /* update xpp and tp */
#line 3157
    xp += ni;
#line 3157
    tp += ni;
#line 3157
    *xpp = (void*)xp;
#line 3157
  }
#line 3157
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3157

#line 3157
#else   /* not SX */
#line 3157

#line 3157
	char *xp = (char *) *xpp;
#line 3157
	int status = NC_NOERR;
#line 3157

#line 3157
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3157
	{
#line 3157
		int lstatus = ncx_put_uint_short(xp, tp, fillp);
#line 3157
		if (status == NC_NOERR) /* report the first encountered error */
#line 3157
			status = lstatus;
#line 3157
	}
#line 3157

#line 3157
	*xpp = (void *)xp;
#line 3157
	return status;
#line 3157
#endif
#line 3157
}
#line 3157

int
#line 3158
ncx_putn_uint_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3158
{
#line 3158
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3158

#line 3158
 /* basic algorithm is:
#line 3158
  *   - ensure sane alignment of output data
#line 3158
  *   - copy (conversion happens automatically) input data
#line 3158
  *     to output
#line 3158
  *   - update tp to point at next unconverted input, and xpp to point
#line 3158
  *     at next location for converted output
#line 3158
  */
#line 3158
  long i, j, ni;
#line 3158
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3158
  uint *xp;
#line 3158
  int nrange = 0;         /* number of range errors */
#line 3158
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3158
  long cxp = (long) *((char**)xpp);
#line 3158

#line 3158
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3158
  /* sjl: manually stripmine so we can limit amount of
#line 3158
   * vector work space reserved to LOOPCNT elements. Also
#line 3158
   * makes vectorisation easy */
#line 3158
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3158
    ni=Min(nelems-j,LOOPCNT);
#line 3158
    if (realign) {
#line 3158
      xp = tmp;
#line 3158
    } else {
#line 3158
      xp = (uint *) *xpp;
#line 3158
    }
#line 3158
   /* copy the next block */
#line 3158
#pragma cdir loopcnt=LOOPCNT
#line 3158
#pragma cdir shortloop
#line 3158
    for (i=0; i<ni; i++) {
#line 3158
      /* the normal case: */
#line 3158
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3158
     /* test for range errors (not always needed but do it anyway) */
#line 3158
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3158
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3158
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 3158
    }
#line 3158
   /* copy workspace back if necessary */
#line 3158
    if (realign) {
#line 3158
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3158
      xp = (uint *) *xpp;
#line 3158
    }
#line 3158
   /* update xpp and tp */
#line 3158
    xp += ni;
#line 3158
    tp += ni;
#line 3158
    *xpp = (void*)xp;
#line 3158
  }
#line 3158
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3158

#line 3158
#else   /* not SX */
#line 3158

#line 3158
	char *xp = (char *) *xpp;
#line 3158
	int status = NC_NOERR;
#line 3158

#line 3158
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3158
	{
#line 3158
		int lstatus = ncx_put_uint_int(xp, tp, fillp);
#line 3158
		if (status == NC_NOERR) /* report the first encountered error */
#line 3158
			status = lstatus;
#line 3158
	}
#line 3158

#line 3158
	*xpp = (void *)xp;
#line 3158
	return status;
#line 3158
#endif
#line 3158
}
#line 3158

int
#line 3159
ncx_putn_uint_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3159
{
#line 3159
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3159

#line 3159
 /* basic algorithm is:
#line 3159
  *   - ensure sane alignment of output data
#line 3159
  *   - copy (conversion happens automatically) input data
#line 3159
  *     to output
#line 3159
  *   - update tp to point at next unconverted input, and xpp to point
#line 3159
  *     at next location for converted output
#line 3159
  */
#line 3159
  long i, j, ni;
#line 3159
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3159
  uint *xp;
#line 3159
  int nrange = 0;         /* number of range errors */
#line 3159
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3159
  long cxp = (long) *((char**)xpp);
#line 3159

#line 3159
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3159
  /* sjl: manually stripmine so we can limit amount of
#line 3159
   * vector work space reserved to LOOPCNT elements. Also
#line 3159
   * makes vectorisation easy */
#line 3159
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3159
    ni=Min(nelems-j,LOOPCNT);
#line 3159
    if (realign) {
#line 3159
      xp = tmp;
#line 3159
    } else {
#line 3159
      xp = (uint *) *xpp;
#line 3159
    }
#line 3159
   /* copy the next block */
#line 3159
#pragma cdir loopcnt=LOOPCNT
#line 3159
#pragma cdir shortloop
#line 3159
    for (i=0; i<ni; i++) {
#line 3159
      /* the normal case: */
#line 3159
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3159
     /* test for range errors (not always needed but do it anyway) */
#line 3159
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3159
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3159
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 3159
    }
#line 3159
   /* copy workspace back if necessary */
#line 3159
    if (realign) {
#line 3159
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3159
      xp = (uint *) *xpp;
#line 3159
    }
#line 3159
   /* update xpp and tp */
#line 3159
    xp += ni;
#line 3159
    tp += ni;
#line 3159
    *xpp = (void*)xp;
#line 3159
  }
#line 3159
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3159

#line 3159
#else   /* not SX */
#line 3159

#line 3159
	char *xp = (char *) *xpp;
#line 3159
	int status = NC_NOERR;
#line 3159

#line 3159
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3159
	{
#line 3159
		int lstatus = ncx_put_uint_long(xp, tp, fillp);
#line 3159
		if (status == NC_NOERR) /* report the first encountered error */
#line 3159
			status = lstatus;
#line 3159
	}
#line 3159

#line 3159
	*xpp = (void *)xp;
#line 3159
	return status;
#line 3159
#endif
#line 3159
}
#line 3159

int
#line 3160
ncx_putn_uint_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3160
{
#line 3160
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3160

#line 3160
 /* basic algorithm is:
#line 3160
  *   - ensure sane alignment of output data
#line 3160
  *   - copy (conversion happens automatically) input data
#line 3160
  *     to output
#line 3160
  *   - update tp to point at next unconverted input, and xpp to point
#line 3160
  *     at next location for converted output
#line 3160
  */
#line 3160
  long i, j, ni;
#line 3160
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3160
  uint *xp;
#line 3160
  int nrange = 0;         /* number of range errors */
#line 3160
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3160
  long cxp = (long) *((char**)xpp);
#line 3160

#line 3160
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3160
  /* sjl: manually stripmine so we can limit amount of
#line 3160
   * vector work space reserved to LOOPCNT elements. Also
#line 3160
   * makes vectorisation easy */
#line 3160
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3160
    ni=Min(nelems-j,LOOPCNT);
#line 3160
    if (realign) {
#line 3160
      xp = tmp;
#line 3160
    } else {
#line 3160
      xp = (uint *) *xpp;
#line 3160
    }
#line 3160
   /* copy the next block */
#line 3160
#pragma cdir loopcnt=LOOPCNT
#line 3160
#pragma cdir shortloop
#line 3160
    for (i=0; i<ni; i++) {
#line 3160
      /* the normal case: */
#line 3160
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3160
     /* test for range errors (not always needed but do it anyway) */
#line 3160
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3160
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3160
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 3160
    }
#line 3160
   /* copy workspace back if necessary */
#line 3160
    if (realign) {
#line 3160
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3160
      xp = (uint *) *xpp;
#line 3160
    }
#line 3160
   /* update xpp and tp */
#line 3160
    xp += ni;
#line 3160
    tp += ni;
#line 3160
    *xpp = (void*)xp;
#line 3160
  }
#line 3160
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3160

#line 3160
#else   /* not SX */
#line 3160

#line 3160
	char *xp = (char *) *xpp;
#line 3160
	int status = NC_NOERR;
#line 3160

#line 3160
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3160
	{
#line 3160
		int lstatus = ncx_put_uint_float(xp, tp, fillp);
#line 3160
		if (status == NC_NOERR) /* report the first encountered error */
#line 3160
			status = lstatus;
#line 3160
	}
#line 3160

#line 3160
	*xpp = (void *)xp;
#line 3160
	return status;
#line 3160
#endif
#line 3160
}
#line 3160

int
#line 3161
ncx_putn_uint_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3161
{
#line 3161
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3161

#line 3161
 /* basic algorithm is:
#line 3161
  *   - ensure sane alignment of output data
#line 3161
  *   - copy (conversion happens automatically) input data
#line 3161
  *     to output
#line 3161
  *   - update tp to point at next unconverted input, and xpp to point
#line 3161
  *     at next location for converted output
#line 3161
  */
#line 3161
  long i, j, ni;
#line 3161
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3161
  uint *xp;
#line 3161
  int nrange = 0;         /* number of range errors */
#line 3161
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3161
  long cxp = (long) *((char**)xpp);
#line 3161

#line 3161
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3161
  /* sjl: manually stripmine so we can limit amount of
#line 3161
   * vector work space reserved to LOOPCNT elements. Also
#line 3161
   * makes vectorisation easy */
#line 3161
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3161
    ni=Min(nelems-j,LOOPCNT);
#line 3161
    if (realign) {
#line 3161
      xp = tmp;
#line 3161
    } else {
#line 3161
      xp = (uint *) *xpp;
#line 3161
    }
#line 3161
   /* copy the next block */
#line 3161
#pragma cdir loopcnt=LOOPCNT
#line 3161
#pragma cdir shortloop
#line 3161
    for (i=0; i<ni; i++) {
#line 3161
      /* the normal case: */
#line 3161
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3161
     /* test for range errors (not always needed but do it anyway) */
#line 3161
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3161
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3161
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 3161
    }
#line 3161
   /* copy workspace back if necessary */
#line 3161
    if (realign) {
#line 3161
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3161
      xp = (uint *) *xpp;
#line 3161
    }
#line 3161
   /* update xpp and tp */
#line 3161
    xp += ni;
#line 3161
    tp += ni;
#line 3161
    *xpp = (void*)xp;
#line 3161
  }
#line 3161
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3161

#line 3161
#else   /* not SX */
#line 3161

#line 3161
	char *xp = (char *) *xpp;
#line 3161
	int status = NC_NOERR;
#line 3161

#line 3161
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3161
	{
#line 3161
		int lstatus = ncx_put_uint_double(xp, tp, fillp);
#line 3161
		if (status == NC_NOERR) /* report the first encountered error */
#line 3161
			status = lstatus;
#line 3161
	}
#line 3161

#line 3161
	*xpp = (void *)xp;
#line 3161
	return status;
#line 3161
#endif
#line 3161
}
#line 3161

int
#line 3162
ncx_putn_uint_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3162
{
#line 3162
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3162

#line 3162
 /* basic algorithm is:
#line 3162
  *   - ensure sane alignment of output data
#line 3162
  *   - copy (conversion happens automatically) input data
#line 3162
  *     to output
#line 3162
  *   - update tp to point at next unconverted input, and xpp to point
#line 3162
  *     at next location for converted output
#line 3162
  */
#line 3162
  long i, j, ni;
#line 3162
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3162
  uint *xp;
#line 3162
  int nrange = 0;         /* number of range errors */
#line 3162
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3162
  long cxp = (long) *((char**)xpp);
#line 3162

#line 3162
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3162
  /* sjl: manually stripmine so we can limit amount of
#line 3162
   * vector work space reserved to LOOPCNT elements. Also
#line 3162
   * makes vectorisation easy */
#line 3162
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3162
    ni=Min(nelems-j,LOOPCNT);
#line 3162
    if (realign) {
#line 3162
      xp = tmp;
#line 3162
    } else {
#line 3162
      xp = (uint *) *xpp;
#line 3162
    }
#line 3162
   /* copy the next block */
#line 3162
#pragma cdir loopcnt=LOOPCNT
#line 3162
#pragma cdir shortloop
#line 3162
    for (i=0; i<ni; i++) {
#line 3162
      /* the normal case: */
#line 3162
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3162
     /* test for range errors (not always needed but do it anyway) */
#line 3162
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3162
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3162
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 3162
    }
#line 3162
   /* copy workspace back if necessary */
#line 3162
    if (realign) {
#line 3162
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3162
      xp = (uint *) *xpp;
#line 3162
    }
#line 3162
   /* update xpp and tp */
#line 3162
    xp += ni;
#line 3162
    tp += ni;
#line 3162
    *xpp = (void*)xp;
#line 3162
  }
#line 3162
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3162

#line 3162
#else   /* not SX */
#line 3162

#line 3162
	char *xp = (char *) *xpp;
#line 3162
	int status = NC_NOERR;
#line 3162

#line 3162
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3162
	{
#line 3162
		int lstatus = ncx_put_uint_longlong(xp, tp, fillp);
#line 3162
		if (status == NC_NOERR) /* report the first encountered error */
#line 3162
			status = lstatus;
#line 3162
	}
#line 3162

#line 3162
	*xpp = (void *)xp;
#line 3162
	return status;
#line 3162
#endif
#line 3162
}
#line 3162

int
#line 3163
ncx_putn_uint_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3163
{
#line 3163
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3163

#line 3163
 /* basic algorithm is:
#line 3163
  *   - ensure sane alignment of output data
#line 3163
  *   - copy (conversion happens automatically) input data
#line 3163
  *     to output
#line 3163
  *   - update tp to point at next unconverted input, and xpp to point
#line 3163
  *     at next location for converted output
#line 3163
  */
#line 3163
  long i, j, ni;
#line 3163
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3163
  uint *xp;
#line 3163
  int nrange = 0;         /* number of range errors */
#line 3163
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3163
  long cxp = (long) *((char**)xpp);
#line 3163

#line 3163
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3163
  /* sjl: manually stripmine so we can limit amount of
#line 3163
   * vector work space reserved to LOOPCNT elements. Also
#line 3163
   * makes vectorisation easy */
#line 3163
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3163
    ni=Min(nelems-j,LOOPCNT);
#line 3163
    if (realign) {
#line 3163
      xp = tmp;
#line 3163
    } else {
#line 3163
      xp = (uint *) *xpp;
#line 3163
    }
#line 3163
   /* copy the next block */
#line 3163
#pragma cdir loopcnt=LOOPCNT
#line 3163
#pragma cdir shortloop
#line 3163
    for (i=0; i<ni; i++) {
#line 3163
      /* the normal case: */
#line 3163
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3163
     /* test for range errors (not always needed but do it anyway) */
#line 3163
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3163
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3163
      nrange += tp[i] > X_UINT_MAX ;
#line 3163
    }
#line 3163
   /* copy workspace back if necessary */
#line 3163
    if (realign) {
#line 3163
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3163
      xp = (uint *) *xpp;
#line 3163
    }
#line 3163
   /* update xpp and tp */
#line 3163
    xp += ni;
#line 3163
    tp += ni;
#line 3163
    *xpp = (void*)xp;
#line 3163
  }
#line 3163
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3163

#line 3163
#else   /* not SX */
#line 3163

#line 3163
	char *xp = (char *) *xpp;
#line 3163
	int status = NC_NOERR;
#line 3163

#line 3163
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3163
	{
#line 3163
		int lstatus = ncx_put_uint_uchar(xp, tp, fillp);
#line 3163
		if (status == NC_NOERR) /* report the first encountered error */
#line 3163
			status = lstatus;
#line 3163
	}
#line 3163

#line 3163
	*xpp = (void *)xp;
#line 3163
	return status;
#line 3163
#endif
#line 3163
}
#line 3163

int
#line 3164
ncx_putn_uint_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3164
{
#line 3164
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3164

#line 3164
 /* basic algorithm is:
#line 3164
  *   - ensure sane alignment of output data
#line 3164
  *   - copy (conversion happens automatically) input data
#line 3164
  *     to output
#line 3164
  *   - update tp to point at next unconverted input, and xpp to point
#line 3164
  *     at next location for converted output
#line 3164
  */
#line 3164
  long i, j, ni;
#line 3164
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3164
  uint *xp;
#line 3164
  int nrange = 0;         /* number of range errors */
#line 3164
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3164
  long cxp = (long) *((char**)xpp);
#line 3164

#line 3164
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3164
  /* sjl: manually stripmine so we can limit amount of
#line 3164
   * vector work space reserved to LOOPCNT elements. Also
#line 3164
   * makes vectorisation easy */
#line 3164
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3164
    ni=Min(nelems-j,LOOPCNT);
#line 3164
    if (realign) {
#line 3164
      xp = tmp;
#line 3164
    } else {
#line 3164
      xp = (uint *) *xpp;
#line 3164
    }
#line 3164
   /* copy the next block */
#line 3164
#pragma cdir loopcnt=LOOPCNT
#line 3164
#pragma cdir shortloop
#line 3164
    for (i=0; i<ni; i++) {
#line 3164
      /* the normal case: */
#line 3164
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3164
     /* test for range errors (not always needed but do it anyway) */
#line 3164
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3164
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3164
      nrange += tp[i] > X_UINT_MAX ;
#line 3164
    }
#line 3164
   /* copy workspace back if necessary */
#line 3164
    if (realign) {
#line 3164
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3164
      xp = (uint *) *xpp;
#line 3164
    }
#line 3164
   /* update xpp and tp */
#line 3164
    xp += ni;
#line 3164
    tp += ni;
#line 3164
    *xpp = (void*)xp;
#line 3164
  }
#line 3164
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3164

#line 3164
#else   /* not SX */
#line 3164

#line 3164
	char *xp = (char *) *xpp;
#line 3164
	int status = NC_NOERR;
#line 3164

#line 3164
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3164
	{
#line 3164
		int lstatus = ncx_put_uint_ushort(xp, tp, fillp);
#line 3164
		if (status == NC_NOERR) /* report the first encountered error */
#line 3164
			status = lstatus;
#line 3164
	}
#line 3164

#line 3164
	*xpp = (void *)xp;
#line 3164
	return status;
#line 3164
#endif
#line 3164
}
#line 3164

int
#line 3165
ncx_putn_uint_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3165
{
#line 3165
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3165

#line 3165
 /* basic algorithm is:
#line 3165
  *   - ensure sane alignment of output data
#line 3165
  *   - copy (conversion happens automatically) input data
#line 3165
  *     to output
#line 3165
  *   - update tp to point at next unconverted input, and xpp to point
#line 3165
  *     at next location for converted output
#line 3165
  */
#line 3165
  long i, j, ni;
#line 3165
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3165
  uint *xp;
#line 3165
  int nrange = 0;         /* number of range errors */
#line 3165
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3165
  long cxp = (long) *((char**)xpp);
#line 3165

#line 3165
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3165
  /* sjl: manually stripmine so we can limit amount of
#line 3165
   * vector work space reserved to LOOPCNT elements. Also
#line 3165
   * makes vectorisation easy */
#line 3165
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3165
    ni=Min(nelems-j,LOOPCNT);
#line 3165
    if (realign) {
#line 3165
      xp = tmp;
#line 3165
    } else {
#line 3165
      xp = (uint *) *xpp;
#line 3165
    }
#line 3165
   /* copy the next block */
#line 3165
#pragma cdir loopcnt=LOOPCNT
#line 3165
#pragma cdir shortloop
#line 3165
    for (i=0; i<ni; i++) {
#line 3165
      /* the normal case: */
#line 3165
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3165
     /* test for range errors (not always needed but do it anyway) */
#line 3165
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3165
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3165
      nrange += tp[i] > X_UINT_MAX ;
#line 3165
    }
#line 3165
   /* copy workspace back if necessary */
#line 3165
    if (realign) {
#line 3165
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3165
      xp = (uint *) *xpp;
#line 3165
    }
#line 3165
   /* update xpp and tp */
#line 3165
    xp += ni;
#line 3165
    tp += ni;
#line 3165
    *xpp = (void*)xp;
#line 3165
  }
#line 3165
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3165

#line 3165
#else   /* not SX */
#line 3165

#line 3165
	char *xp = (char *) *xpp;
#line 3165
	int status = NC_NOERR;
#line 3165

#line 3165
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3165
	{
#line 3165
		int lstatus = ncx_put_uint_ulonglong(xp, tp, fillp);
#line 3165
		if (status == NC_NOERR) /* report the first encountered error */
#line 3165
			status = lstatus;
#line 3165
	}
#line 3165

#line 3165
	*xpp = (void *)xp;
#line 3165
	return status;
#line 3165
#endif
#line 3165
}
#line 3165



/* float ---------------------------------------------------------------------*/

#if X_SIZEOF_FLOAT == SIZEOF_FLOAT && !defined(NO_IEEE_FLOAT)
/* optimized version */
int
ncx_getn_float_float(const void **xpp, size_t nelems, float *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_FLOAT);
# else
	swapn4b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_FLOAT);
	return NC_NOERR;
}
#elif defined(vax) && vax != 0
int
ncx_getn_float_float(const void **xpp, size_t nfloats, float *ip)
{
	float *const end = ip + nfloats;

	while (ip < end)
	{
		struct vax_single *const vsp = (struct vax_single *) ip;
#line 3191
		const struct ieee_single *const isp =
#line 3191
			 (const struct ieee_single *) (*xpp);
#line 3191
		unsigned exp = isp->exp_hi << 1 | isp->exp_lo;
#line 3191

#line 3191
		switch(exp) {
#line 3191
		case 0 :
#line 3191
			/* ieee subnormal */
#line 3191
			if (isp->mant_hi == min.ieee.mant_hi
#line 3191
				&& isp->mant_lo_hi == min.ieee.mant_lo_hi
#line 3191
				&& isp->mant_lo_lo == min.ieee.mant_lo_lo)
#line 3191
			{
#line 3191
				*vsp = min.s;
#line 3191
			}
#line 3191
			else
#line 3191
			{
#line 3191
				unsigned mantissa = (isp->mant_hi << 16)
#line 3191
					 | isp->mant_lo_hi << 8
#line 3191
					 | isp->mant_lo_lo;
#line 3191
				unsigned tmp = mantissa >> 20;
#line 3191
				if (tmp >= 4) {
#line 3191
					vsp->exp = 2;
#line 3191
				} else if (tmp >= 2) {
#line 3191
					vsp->exp = 1;
#line 3191
				} else {
#line 3191
					*vsp = min.s;
#line 3191
					break;
#line 3191
				} /* else */
#line 3191
				tmp = mantissa - (1 << (20 + vsp->exp ));
#line 3191
				tmp <<= 3 - vsp->exp;
#line 3191
				vsp->mantissa2 = tmp;
#line 3191
				vsp->mantissa1 = (tmp >> 16);
#line 3191
			}
#line 3191
			break;
#line 3191
		case 0xfe :
#line 3191
		case 0xff :
#line 3191
			*vsp = max.s;
#line 3191
			break;
#line 3191
		default :
#line 3191
			vsp->exp = exp - IEEE_SNG_BIAS + VAX_SNG_BIAS;
#line 3191
			vsp->mantissa2 = isp->mant_lo_hi << 8 | isp->mant_lo_lo;
#line 3191
			vsp->mantissa1 = isp->mant_hi;
#line 3191
		}
#line 3191

#line 3191
		vsp->sign = isp->sign;
#line 3191


		ip++;
		*xpp = (char *)(*xpp) + X_SIZEOF_FLOAT;
	}
	return NC_NOERR;
}
#else
int
ncx_getn_float_float(const void **xpp, size_t nelems, float *tp)
{
	const char *xp = *xpp;
	int status = NC_NOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
	{
		const int lstatus = ncx_get_float_float(xp, tp, fillp);
		if (status == NC_NOERR) /* report the first encountered error */
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
}

#endif
int
#line 3217
ncx_getn_float_schar(const void **xpp, size_t nelems, schar *tp)
#line 3217
{
#line 3217
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3217

#line 3217
 /* basic algorithm is:
#line 3217
  *   - ensure sane alignment of input data
#line 3217
  *   - copy (conversion happens automatically) input data
#line 3217
  *     to output
#line 3217
  *   - update xpp to point at next unconverted input, and tp to point
#line 3217
  *     at next location for converted output
#line 3217
  */
#line 3217
  long i, j, ni;
#line 3217
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3217
  float *xp;
#line 3217
  int nrange = 0;         /* number of range errors */
#line 3217
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3217
  long cxp = (long) *((char**)xpp);
#line 3217

#line 3217
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3217
  /* sjl: manually stripmine so we can limit amount of
#line 3217
   * vector work space reserved to LOOPCNT elements. Also
#line 3217
   * makes vectorisation easy */
#line 3217
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3217
    ni=Min(nelems-j,LOOPCNT);
#line 3217
    if (realign) {
#line 3217
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3217
      xp = tmp;
#line 3217
    } else {
#line 3217
      xp = (float *) *xpp;
#line 3217
    }
#line 3217
   /* copy the next block */
#line 3217
#pragma cdir loopcnt=LOOPCNT
#line 3217
#pragma cdir shortloop
#line 3217
    for (i=0; i<ni; i++) {
#line 3217
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3217
     /* test for range errors (not always needed but do it anyway) */
#line 3217
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3217
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3217
      nrange += xp[i] > SCHAR_MAX || xp[i] < SCHAR_MIN;
#line 3217
    }
#line 3217
   /* update xpp and tp */
#line 3217
    if (realign) xp = (float *) *xpp;
#line 3217
    xp += ni;
#line 3217
    tp += ni;
#line 3217
    *xpp = (void*)xp;
#line 3217
  }
#line 3217
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3217

#line 3217
#else   /* not SX */
#line 3217
	const char *xp = (const char *) *xpp;
#line 3217
	int status = NC_NOERR;
#line 3217

#line 3217
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3217
	{
#line 3217
		const int lstatus = ncx_get_float_schar(xp, tp);
#line 3217
		if (status == NC_NOERR) /* report the first encountered error */
#line 3217
			status = lstatus;
#line 3217
	}
#line 3217

#line 3217
	*xpp = (const void *)xp;
#line 3217
	return status;
#line 3217
#endif
#line 3217
}
#line 3217

int
#line 3218
ncx_getn_float_short(const void **xpp, size_t nelems, short *tp)
#line 3218
{
#line 3218
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3218

#line 3218
 /* basic algorithm is:
#line 3218
  *   - ensure sane alignment of input data
#line 3218
  *   - copy (conversion happens automatically) input data
#line 3218
  *     to output
#line 3218
  *   - update xpp to point at next unconverted input, and tp to point
#line 3218
  *     at next location for converted output
#line 3218
  */
#line 3218
  long i, j, ni;
#line 3218
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3218
  float *xp;
#line 3218
  int nrange = 0;         /* number of range errors */
#line 3218
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3218
  long cxp = (long) *((char**)xpp);
#line 3218

#line 3218
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3218
  /* sjl: manually stripmine so we can limit amount of
#line 3218
   * vector work space reserved to LOOPCNT elements. Also
#line 3218
   * makes vectorisation easy */
#line 3218
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3218
    ni=Min(nelems-j,LOOPCNT);
#line 3218
    if (realign) {
#line 3218
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3218
      xp = tmp;
#line 3218
    } else {
#line 3218
      xp = (float *) *xpp;
#line 3218
    }
#line 3218
   /* copy the next block */
#line 3218
#pragma cdir loopcnt=LOOPCNT
#line 3218
#pragma cdir shortloop
#line 3218
    for (i=0; i<ni; i++) {
#line 3218
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3218
     /* test for range errors (not always needed but do it anyway) */
#line 3218
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3218
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3218
      nrange += xp[i] > SHORT_MAX || xp[i] < SHORT_MIN;
#line 3218
    }
#line 3218
   /* update xpp and tp */
#line 3218
    if (realign) xp = (float *) *xpp;
#line 3218
    xp += ni;
#line 3218
    tp += ni;
#line 3218
    *xpp = (void*)xp;
#line 3218
  }
#line 3218
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3218

#line 3218
#else   /* not SX */
#line 3218
	const char *xp = (const char *) *xpp;
#line 3218
	int status = NC_NOERR;
#line 3218

#line 3218
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3218
	{
#line 3218
		const int lstatus = ncx_get_float_short(xp, tp);
#line 3218
		if (status == NC_NOERR) /* report the first encountered error */
#line 3218
			status = lstatus;
#line 3218
	}
#line 3218

#line 3218
	*xpp = (const void *)xp;
#line 3218
	return status;
#line 3218
#endif
#line 3218
}
#line 3218

int
#line 3219
ncx_getn_float_int(const void **xpp, size_t nelems, int *tp)
#line 3219
{
#line 3219
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3219

#line 3219
 /* basic algorithm is:
#line 3219
  *   - ensure sane alignment of input data
#line 3219
  *   - copy (conversion happens automatically) input data
#line 3219
  *     to output
#line 3219
  *   - update xpp to point at next unconverted input, and tp to point
#line 3219
  *     at next location for converted output
#line 3219
  */
#line 3219
  long i, j, ni;
#line 3219
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3219
  float *xp;
#line 3219
  int nrange = 0;         /* number of range errors */
#line 3219
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3219
  long cxp = (long) *((char**)xpp);
#line 3219

#line 3219
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3219
  /* sjl: manually stripmine so we can limit amount of
#line 3219
   * vector work space reserved to LOOPCNT elements. Also
#line 3219
   * makes vectorisation easy */
#line 3219
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3219
    ni=Min(nelems-j,LOOPCNT);
#line 3219
    if (realign) {
#line 3219
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3219
      xp = tmp;
#line 3219
    } else {
#line 3219
      xp = (float *) *xpp;
#line 3219
    }
#line 3219
   /* copy the next block */
#line 3219
#pragma cdir loopcnt=LOOPCNT
#line 3219
#pragma cdir shortloop
#line 3219
    for (i=0; i<ni; i++) {
#line 3219
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3219
     /* test for range errors (not always needed but do it anyway) */
#line 3219
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3219
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3219
      nrange += xp[i] > INT_MAX || xp[i] < INT_MIN;
#line 3219
    }
#line 3219
   /* update xpp and tp */
#line 3219
    if (realign) xp = (float *) *xpp;
#line 3219
    xp += ni;
#line 3219
    tp += ni;
#line 3219
    *xpp = (void*)xp;
#line 3219
  }
#line 3219
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3219

#line 3219
#else   /* not SX */
#line 3219
	const char *xp = (const char *) *xpp;
#line 3219
	int status = NC_NOERR;
#line 3219

#line 3219
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3219
	{
#line 3219
		const int lstatus = ncx_get_float_int(xp, tp);
#line 3219
		if (status == NC_NOERR) /* report the first encountered error */
#line 3219
			status = lstatus;
#line 3219
	}
#line 3219

#line 3219
	*xpp = (const void *)xp;
#line 3219
	return status;
#line 3219
#endif
#line 3219
}
#line 3219

int
#line 3220
ncx_getn_float_long(const void **xpp, size_t nelems, long *tp)
#line 3220
{
#line 3220
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3220

#line 3220
 /* basic algorithm is:
#line 3220
  *   - ensure sane alignment of input data
#line 3220
  *   - copy (conversion happens automatically) input data
#line 3220
  *     to output
#line 3220
  *   - update xpp to point at next unconverted input, and tp to point
#line 3220
  *     at next location for converted output
#line 3220
  */
#line 3220
  long i, j, ni;
#line 3220
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3220
  float *xp;
#line 3220
  int nrange = 0;         /* number of range errors */
#line 3220
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3220
  long cxp = (long) *((char**)xpp);
#line 3220

#line 3220
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3220
  /* sjl: manually stripmine so we can limit amount of
#line 3220
   * vector work space reserved to LOOPCNT elements. Also
#line 3220
   * makes vectorisation easy */
#line 3220
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3220
    ni=Min(nelems-j,LOOPCNT);
#line 3220
    if (realign) {
#line 3220
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3220
      xp = tmp;
#line 3220
    } else {
#line 3220
      xp = (float *) *xpp;
#line 3220
    }
#line 3220
   /* copy the next block */
#line 3220
#pragma cdir loopcnt=LOOPCNT
#line 3220
#pragma cdir shortloop
#line 3220
    for (i=0; i<ni; i++) {
#line 3220
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3220
     /* test for range errors (not always needed but do it anyway) */
#line 3220
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3220
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3220
      nrange += xp[i] > LONG_MAX || xp[i] < LONG_MIN;
#line 3220
    }
#line 3220
   /* update xpp and tp */
#line 3220
    if (realign) xp = (float *) *xpp;
#line 3220
    xp += ni;
#line 3220
    tp += ni;
#line 3220
    *xpp = (void*)xp;
#line 3220
  }
#line 3220
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3220

#line 3220
#else   /* not SX */
#line 3220
	const char *xp = (const char *) *xpp;
#line 3220
	int status = NC_NOERR;
#line 3220

#line 3220
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3220
	{
#line 3220
		const int lstatus = ncx_get_float_long(xp, tp);
#line 3220
		if (status == NC_NOERR) /* report the first encountered error */
#line 3220
			status = lstatus;
#line 3220
	}
#line 3220

#line 3220
	*xpp = (const void *)xp;
#line 3220
	return status;
#line 3220
#endif
#line 3220
}
#line 3220

int
#line 3221
ncx_getn_float_double(const void **xpp, size_t nelems, double *tp)
#line 3221
{
#line 3221
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3221

#line 3221
 /* basic algorithm is:
#line 3221
  *   - ensure sane alignment of input data
#line 3221
  *   - copy (conversion happens automatically) input data
#line 3221
  *     to output
#line 3221
  *   - update xpp to point at next unconverted input, and tp to point
#line 3221
  *     at next location for converted output
#line 3221
  */
#line 3221
  long i, j, ni;
#line 3221
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3221
  float *xp;
#line 3221
  int nrange = 0;         /* number of range errors */
#line 3221
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3221
  long cxp = (long) *((char**)xpp);
#line 3221

#line 3221
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3221
  /* sjl: manually stripmine so we can limit amount of
#line 3221
   * vector work space reserved to LOOPCNT elements. Also
#line 3221
   * makes vectorisation easy */
#line 3221
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3221
    ni=Min(nelems-j,LOOPCNT);
#line 3221
    if (realign) {
#line 3221
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3221
      xp = tmp;
#line 3221
    } else {
#line 3221
      xp = (float *) *xpp;
#line 3221
    }
#line 3221
   /* copy the next block */
#line 3221
#pragma cdir loopcnt=LOOPCNT
#line 3221
#pragma cdir shortloop
#line 3221
    for (i=0; i<ni; i++) {
#line 3221
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 3221
     /* test for range errors (not always needed but do it anyway) */
#line 3221
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3221
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3221
      nrange += xp[i] > DOUBLE_MAX || xp[i] < DOUBLE_MIN;
#line 3221
    }
#line 3221
   /* update xpp and tp */
#line 3221
    if (realign) xp = (float *) *xpp;
#line 3221
    xp += ni;
#line 3221
    tp += ni;
#line 3221
    *xpp = (void*)xp;
#line 3221
  }
#line 3221
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3221

#line 3221
#else   /* not SX */
#line 3221
	const char *xp = (const char *) *xpp;
#line 3221
	int status = NC_NOERR;
#line 3221

#line 3221
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3221
	{
#line 3221
		const int lstatus = ncx_get_float_double(xp, tp);
#line 3221
		if (status == NC_NOERR) /* report the first encountered error */
#line 3221
			status = lstatus;
#line 3221
	}
#line 3221

#line 3221
	*xpp = (const void *)xp;
#line 3221
	return status;
#line 3221
#endif
#line 3221
}
#line 3221

int
#line 3222
ncx_getn_float_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3222
{
#line 3222
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3222

#line 3222
 /* basic algorithm is:
#line 3222
  *   - ensure sane alignment of input data
#line 3222
  *   - copy (conversion happens automatically) input data
#line 3222
  *     to output
#line 3222
  *   - update xpp to point at next unconverted input, and tp to point
#line 3222
  *     at next location for converted output
#line 3222
  */
#line 3222
  long i, j, ni;
#line 3222
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3222
  float *xp;
#line 3222
  int nrange = 0;         /* number of range errors */
#line 3222
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3222
  long cxp = (long) *((char**)xpp);
#line 3222

#line 3222
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3222
  /* sjl: manually stripmine so we can limit amount of
#line 3222
   * vector work space reserved to LOOPCNT elements. Also
#line 3222
   * makes vectorisation easy */
#line 3222
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3222
    ni=Min(nelems-j,LOOPCNT);
#line 3222
    if (realign) {
#line 3222
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3222
      xp = tmp;
#line 3222
    } else {
#line 3222
      xp = (float *) *xpp;
#line 3222
    }
#line 3222
   /* copy the next block */
#line 3222
#pragma cdir loopcnt=LOOPCNT
#line 3222
#pragma cdir shortloop
#line 3222
    for (i=0; i<ni; i++) {
#line 3222
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3222
     /* test for range errors (not always needed but do it anyway) */
#line 3222
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3222
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3222
      nrange += xp[i] > LONGLONG_MAX || xp[i] < LONGLONG_MIN;
#line 3222
    }
#line 3222
   /* update xpp and tp */
#line 3222
    if (realign) xp = (float *) *xpp;
#line 3222
    xp += ni;
#line 3222
    tp += ni;
#line 3222
    *xpp = (void*)xp;
#line 3222
  }
#line 3222
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3222

#line 3222
#else   /* not SX */
#line 3222
	const char *xp = (const char *) *xpp;
#line 3222
	int status = NC_NOERR;
#line 3222

#line 3222
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3222
	{
#line 3222
		const int lstatus = ncx_get_float_longlong(xp, tp);
#line 3222
		if (status == NC_NOERR) /* report the first encountered error */
#line 3222
			status = lstatus;
#line 3222
	}
#line 3222

#line 3222
	*xpp = (const void *)xp;
#line 3222
	return status;
#line 3222
#endif
#line 3222
}
#line 3222

int
#line 3223
ncx_getn_float_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3223
{
#line 3223
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3223

#line 3223
 /* basic algorithm is:
#line 3223
  *   - ensure sane alignment of input data
#line 3223
  *   - copy (conversion happens automatically) input data
#line 3223
  *     to output
#line 3223
  *   - update xpp to point at next unconverted input, and tp to point
#line 3223
  *     at next location for converted output
#line 3223
  */
#line 3223
  long i, j, ni;
#line 3223
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3223
  float *xp;
#line 3223
  int nrange = 0;         /* number of range errors */
#line 3223
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3223
  long cxp = (long) *((char**)xpp);
#line 3223

#line 3223
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3223
  /* sjl: manually stripmine so we can limit amount of
#line 3223
   * vector work space reserved to LOOPCNT elements. Also
#line 3223
   * makes vectorisation easy */
#line 3223
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3223
    ni=Min(nelems-j,LOOPCNT);
#line 3223
    if (realign) {
#line 3223
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3223
      xp = tmp;
#line 3223
    } else {
#line 3223
      xp = (float *) *xpp;
#line 3223
    }
#line 3223
   /* copy the next block */
#line 3223
#pragma cdir loopcnt=LOOPCNT
#line 3223
#pragma cdir shortloop
#line 3223
    for (i=0; i<ni; i++) {
#line 3223
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3223
     /* test for range errors (not always needed but do it anyway) */
#line 3223
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3223
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3223
      nrange += xp[i] > USHORT_MAX || xp[i] < 0;
#line 3223
    }
#line 3223
   /* update xpp and tp */
#line 3223
    if (realign) xp = (float *) *xpp;
#line 3223
    xp += ni;
#line 3223
    tp += ni;
#line 3223
    *xpp = (void*)xp;
#line 3223
  }
#line 3223
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3223

#line 3223
#else   /* not SX */
#line 3223
	const char *xp = (const char *) *xpp;
#line 3223
	int status = NC_NOERR;
#line 3223

#line 3223
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3223
	{
#line 3223
		const int lstatus = ncx_get_float_ushort(xp, tp);
#line 3223
		if (status == NC_NOERR) /* report the first encountered error */
#line 3223
			status = lstatus;
#line 3223
	}
#line 3223

#line 3223
	*xpp = (const void *)xp;
#line 3223
	return status;
#line 3223
#endif
#line 3223
}
#line 3223

int
#line 3224
ncx_getn_float_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3224
{
#line 3224
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3224

#line 3224
 /* basic algorithm is:
#line 3224
  *   - ensure sane alignment of input data
#line 3224
  *   - copy (conversion happens automatically) input data
#line 3224
  *     to output
#line 3224
  *   - update xpp to point at next unconverted input, and tp to point
#line 3224
  *     at next location for converted output
#line 3224
  */
#line 3224
  long i, j, ni;
#line 3224
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3224
  float *xp;
#line 3224
  int nrange = 0;         /* number of range errors */
#line 3224
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3224
  long cxp = (long) *((char**)xpp);
#line 3224

#line 3224
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3224
  /* sjl: manually stripmine so we can limit amount of
#line 3224
   * vector work space reserved to LOOPCNT elements. Also
#line 3224
   * makes vectorisation easy */
#line 3224
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3224
    ni=Min(nelems-j,LOOPCNT);
#line 3224
    if (realign) {
#line 3224
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3224
      xp = tmp;
#line 3224
    } else {
#line 3224
      xp = (float *) *xpp;
#line 3224
    }
#line 3224
   /* copy the next block */
#line 3224
#pragma cdir loopcnt=LOOPCNT
#line 3224
#pragma cdir shortloop
#line 3224
    for (i=0; i<ni; i++) {
#line 3224
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3224
     /* test for range errors (not always needed but do it anyway) */
#line 3224
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3224
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3224
      nrange += xp[i] > UCHAR_MAX || xp[i] < 0;
#line 3224
    }
#line 3224
   /* update xpp and tp */
#line 3224
    if (realign) xp = (float *) *xpp;
#line 3224
    xp += ni;
#line 3224
    tp += ni;
#line 3224
    *xpp = (void*)xp;
#line 3224
  }
#line 3224
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3224

#line 3224
#else   /* not SX */
#line 3224
	const char *xp = (const char *) *xpp;
#line 3224
	int status = NC_NOERR;
#line 3224

#line 3224
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3224
	{
#line 3224
		const int lstatus = ncx_get_float_uchar(xp, tp);
#line 3224
		if (status == NC_NOERR) /* report the first encountered error */
#line 3224
			status = lstatus;
#line 3224
	}
#line 3224

#line 3224
	*xpp = (const void *)xp;
#line 3224
	return status;
#line 3224
#endif
#line 3224
}
#line 3224

int
#line 3225
ncx_getn_float_uint(const void **xpp, size_t nelems, uint *tp)
#line 3225
{
#line 3225
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3225

#line 3225
 /* basic algorithm is:
#line 3225
  *   - ensure sane alignment of input data
#line 3225
  *   - copy (conversion happens automatically) input data
#line 3225
  *     to output
#line 3225
  *   - update xpp to point at next unconverted input, and tp to point
#line 3225
  *     at next location for converted output
#line 3225
  */
#line 3225
  long i, j, ni;
#line 3225
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3225
  float *xp;
#line 3225
  int nrange = 0;         /* number of range errors */
#line 3225
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3225
  long cxp = (long) *((char**)xpp);
#line 3225

#line 3225
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3225
  /* sjl: manually stripmine so we can limit amount of
#line 3225
   * vector work space reserved to LOOPCNT elements. Also
#line 3225
   * makes vectorisation easy */
#line 3225
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3225
    ni=Min(nelems-j,LOOPCNT);
#line 3225
    if (realign) {
#line 3225
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3225
      xp = tmp;
#line 3225
    } else {
#line 3225
      xp = (float *) *xpp;
#line 3225
    }
#line 3225
   /* copy the next block */
#line 3225
#pragma cdir loopcnt=LOOPCNT
#line 3225
#pragma cdir shortloop
#line 3225
    for (i=0; i<ni; i++) {
#line 3225
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3225
     /* test for range errors (not always needed but do it anyway) */
#line 3225
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3225
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3225
      nrange += xp[i] > UINT_MAX || xp[i] < 0;
#line 3225
    }
#line 3225
   /* update xpp and tp */
#line 3225
    if (realign) xp = (float *) *xpp;
#line 3225
    xp += ni;
#line 3225
    tp += ni;
#line 3225
    *xpp = (void*)xp;
#line 3225
  }
#line 3225
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3225

#line 3225
#else   /* not SX */
#line 3225
	const char *xp = (const char *) *xpp;
#line 3225
	int status = NC_NOERR;
#line 3225

#line 3225
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3225
	{
#line 3225
		const int lstatus = ncx_get_float_uint(xp, tp);
#line 3225
		if (status == NC_NOERR) /* report the first encountered error */
#line 3225
			status = lstatus;
#line 3225
	}
#line 3225

#line 3225
	*xpp = (const void *)xp;
#line 3225
	return status;
#line 3225
#endif
#line 3225
}
#line 3225

int
#line 3226
ncx_getn_float_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3226
{
#line 3226
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3226

#line 3226
 /* basic algorithm is:
#line 3226
  *   - ensure sane alignment of input data
#line 3226
  *   - copy (conversion happens automatically) input data
#line 3226
  *     to output
#line 3226
  *   - update xpp to point at next unconverted input, and tp to point
#line 3226
  *     at next location for converted output
#line 3226
  */
#line 3226
  long i, j, ni;
#line 3226
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3226
  float *xp;
#line 3226
  int nrange = 0;         /* number of range errors */
#line 3226
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3226
  long cxp = (long) *((char**)xpp);
#line 3226

#line 3226
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3226
  /* sjl: manually stripmine so we can limit amount of
#line 3226
   * vector work space reserved to LOOPCNT elements. Also
#line 3226
   * makes vectorisation easy */
#line 3226
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3226
    ni=Min(nelems-j,LOOPCNT);
#line 3226
    if (realign) {
#line 3226
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3226
      xp = tmp;
#line 3226
    } else {
#line 3226
      xp = (float *) *xpp;
#line 3226
    }
#line 3226
   /* copy the next block */
#line 3226
#pragma cdir loopcnt=LOOPCNT
#line 3226
#pragma cdir shortloop
#line 3226
    for (i=0; i<ni; i++) {
#line 3226
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3226
     /* test for range errors (not always needed but do it anyway) */
#line 3226
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3226
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3226
      nrange += xp[i] > ULONGLONG_MAX || xp[i] < 0;
#line 3226
    }
#line 3226
   /* update xpp and tp */
#line 3226
    if (realign) xp = (float *) *xpp;
#line 3226
    xp += ni;
#line 3226
    tp += ni;
#line 3226
    *xpp = (void*)xp;
#line 3226
  }
#line 3226
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3226

#line 3226
#else   /* not SX */
#line 3226
	const char *xp = (const char *) *xpp;
#line 3226
	int status = NC_NOERR;
#line 3226

#line 3226
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3226
	{
#line 3226
		const int lstatus = ncx_get_float_ulonglong(xp, tp);
#line 3226
		if (status == NC_NOERR) /* report the first encountered error */
#line 3226
			status = lstatus;
#line 3226
	}
#line 3226

#line 3226
	*xpp = (const void *)xp;
#line 3226
	return status;
#line 3226
#endif
#line 3226
}
#line 3226


int
ncx_putn_float_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#if X_SIZEOF_FLOAT == SIZEOF_FLOAT && !defined(NO_IEEE_FLOAT)
/* optimized version */
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_FLOAT);
# else
	swapn4b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_FLOAT);
	return NC_NOERR;
}
#elif defined(vax) && vax != 0
{
	const float *const end = tp + nelems;

	while (tp < end) {
				const struct vax_single *const vsp =
#line 3246
			 (const struct vax_single *)ip;
#line 3246
		struct ieee_single *const isp = (struct ieee_single *) (*xpp);
#line 3246

#line 3246
		switch(vsp->exp){
#line 3246
		case 0 :
#line 3246
			/* all vax float with zero exponent map to zero */
#line 3246
			*isp = min.ieee;
#line 3246
			break;
#line 3246
		case 2 :
#line 3246
		case 1 :
#line 3246
		{
#line 3246
			/* These will map to subnormals */
#line 3246
			unsigned mantissa = (vsp->mantissa1 << 16)
#line 3246
					 | vsp->mantissa2;
#line 3246
			mantissa >>= 3 - vsp->exp;
#line 3246
			mantissa += (1 << (20 + vsp->exp));
#line 3246
			isp->mant_lo_lo = mantissa;
#line 3246
			isp->mant_lo_hi = mantissa >> 8;
#line 3246
			isp->mant_hi = mantissa >> 16;
#line 3246
			isp->exp_lo = 0;
#line 3246
			isp->exp_hi = 0;
#line 3246
		}
#line 3246
			break;
#line 3246
		case 0xff : /* max.s.exp */
#line 3246
			if (vsp->mantissa2 == max.s.mantissa2 &&
#line 3246
			    vsp->mantissa1 == max.s.mantissa1)
#line 3246
			{
#line 3246
				/* map largest vax float to ieee infinity */
#line 3246
				*isp = max.ieee;
#line 3246
				break;
#line 3246
			} /* else, fall thru */
#line 3246
		default :
#line 3246
		{
#line 3246
			unsigned exp = vsp->exp - VAX_SNG_BIAS + IEEE_SNG_BIAS;
#line 3246
			isp->exp_hi = exp >> 1;
#line 3246
			isp->exp_lo = exp;
#line 3246
			isp->mant_lo_lo = vsp->mantissa2;
#line 3246
			isp->mant_lo_hi = vsp->mantissa2 >> 8;
#line 3246
			isp->mant_hi = vsp->mantissa1;
#line 3246
		}
#line 3246
		}
#line 3246

#line 3246
		isp->sign = vsp->sign;
#line 3246

		tp++;
		*xpp = (char *)(*xpp) + X_SIZEOF_FLOAT;
	}
	return NC_NOERR;
}
#else
{
	char *xp = *xpp;
	int status = NC_NOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++) {
		int lstatus = ncx_put_float_float(xp, tp, fillp);
		if (status == NC_NOERR) /* report the first encountered error */
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
}
#endif
int
#line 3267
ncx_putn_float_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3267
{
#line 3267
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3267

#line 3267
 /* basic algorithm is:
#line 3267
  *   - ensure sane alignment of output data
#line 3267
  *   - copy (conversion happens automatically) input data
#line 3267
  *     to output
#line 3267
  *   - update tp to point at next unconverted input, and xpp to point
#line 3267
  *     at next location for converted output
#line 3267
  */
#line 3267
  long i, j, ni;
#line 3267
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3267
  float *xp;
#line 3267
  int nrange = 0;         /* number of range errors */
#line 3267
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3267
  long cxp = (long) *((char**)xpp);
#line 3267

#line 3267
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3267
  /* sjl: manually stripmine so we can limit amount of
#line 3267
   * vector work space reserved to LOOPCNT elements. Also
#line 3267
   * makes vectorisation easy */
#line 3267
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3267
    ni=Min(nelems-j,LOOPCNT);
#line 3267
    if (realign) {
#line 3267
      xp = tmp;
#line 3267
    } else {
#line 3267
      xp = (float *) *xpp;
#line 3267
    }
#line 3267
   /* copy the next block */
#line 3267
#pragma cdir loopcnt=LOOPCNT
#line 3267
#pragma cdir shortloop
#line 3267
    for (i=0; i<ni; i++) {
#line 3267
      /* the normal case: */
#line 3267
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3267
     /* test for range errors (not always needed but do it anyway) */
#line 3267
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3267
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3267
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
#line 3267
    }
#line 3267
   /* copy workspace back if necessary */
#line 3267
    if (realign) {
#line 3267
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3267
      xp = (float *) *xpp;
#line 3267
    }
#line 3267
   /* update xpp and tp */
#line 3267
    xp += ni;
#line 3267
    tp += ni;
#line 3267
    *xpp = (void*)xp;
#line 3267
  }
#line 3267
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3267

#line 3267
#else   /* not SX */
#line 3267

#line 3267
	char *xp = (char *) *xpp;
#line 3267
	int status = NC_NOERR;
#line 3267

#line 3267
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3267
	{
#line 3267
		int lstatus = ncx_put_float_schar(xp, tp, fillp);
#line 3267
		if (status == NC_NOERR) /* report the first encountered error */
#line 3267
			status = lstatus;
#line 3267
	}
#line 3267

#line 3267
	*xpp = (void *)xp;
#line 3267
	return status;
#line 3267
#endif
#line 3267
}
#line 3267

int
#line 3268
ncx_putn_float_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3268
{
#line 3268
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3268

#line 3268
 /* basic algorithm is:
#line 3268
  *   - ensure sane alignment of output data
#line 3268
  *   - copy (conversion happens automatically) input data
#line 3268
  *     to output
#line 3268
  *   - update tp to point at next unconverted input, and xpp to point
#line 3268
  *     at next location for converted output
#line 3268
  */
#line 3268
  long i, j, ni;
#line 3268
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3268
  float *xp;
#line 3268
  int nrange = 0;         /* number of range errors */
#line 3268
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3268
  long cxp = (long) *((char**)xpp);
#line 3268

#line 3268
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3268
  /* sjl: manually stripmine so we can limit amount of
#line 3268
   * vector work space reserved to LOOPCNT elements. Also
#line 3268
   * makes vectorisation easy */
#line 3268
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3268
    ni=Min(nelems-j,LOOPCNT);
#line 3268
    if (realign) {
#line 3268
      xp = tmp;
#line 3268
    } else {
#line 3268
      xp = (float *) *xpp;
#line 3268
    }
#line 3268
   /* copy the next block */
#line 3268
#pragma cdir loopcnt=LOOPCNT
#line 3268
#pragma cdir shortloop
#line 3268
    for (i=0; i<ni; i++) {
#line 3268
      /* the normal case: */
#line 3268
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3268
     /* test for range errors (not always needed but do it anyway) */
#line 3268
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3268
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3268
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
#line 3268
    }
#line 3268
   /* copy workspace back if necessary */
#line 3268
    if (realign) {
#line 3268
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3268
      xp = (float *) *xpp;
#line 3268
    }
#line 3268
   /* update xpp and tp */
#line 3268
    xp += ni;
#line 3268
    tp += ni;
#line 3268
    *xpp = (void*)xp;
#line 3268
  }
#line 3268
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3268

#line 3268
#else   /* not SX */
#line 3268

#line 3268
	char *xp = (char *) *xpp;
#line 3268
	int status = NC_NOERR;
#line 3268

#line 3268
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3268
	{
#line 3268
		int lstatus = ncx_put_float_short(xp, tp, fillp);
#line 3268
		if (status == NC_NOERR) /* report the first encountered error */
#line 3268
			status = lstatus;
#line 3268
	}
#line 3268

#line 3268
	*xpp = (void *)xp;
#line 3268
	return status;
#line 3268
#endif
#line 3268
}
#line 3268

int
#line 3269
ncx_putn_float_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3269
{
#line 3269
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3269

#line 3269
 /* basic algorithm is:
#line 3269
  *   - ensure sane alignment of output data
#line 3269
  *   - copy (conversion happens automatically) input data
#line 3269
  *     to output
#line 3269
  *   - update tp to point at next unconverted input, and xpp to point
#line 3269
  *     at next location for converted output
#line 3269
  */
#line 3269
  long i, j, ni;
#line 3269
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3269
  float *xp;
#line 3269
  int nrange = 0;         /* number of range errors */
#line 3269
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3269
  long cxp = (long) *((char**)xpp);
#line 3269

#line 3269
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3269
  /* sjl: manually stripmine so we can limit amount of
#line 3269
   * vector work space reserved to LOOPCNT elements. Also
#line 3269
   * makes vectorisation easy */
#line 3269
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3269
    ni=Min(nelems-j,LOOPCNT);
#line 3269
    if (realign) {
#line 3269
      xp = tmp;
#line 3269
    } else {
#line 3269
      xp = (float *) *xpp;
#line 3269
    }
#line 3269
   /* copy the next block */
#line 3269
#pragma cdir loopcnt=LOOPCNT
#line 3269
#pragma cdir shortloop
#line 3269
    for (i=0; i<ni; i++) {
#line 3269
      /* the normal case: */
#line 3269
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3269
     /* test for range errors (not always needed but do it anyway) */
#line 3269
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3269
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3269
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
#line 3269
    }
#line 3269
   /* copy workspace back if necessary */
#line 3269
    if (realign) {
#line 3269
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3269
      xp = (float *) *xpp;
#line 3269
    }
#line 3269
   /* update xpp and tp */
#line 3269
    xp += ni;
#line 3269
    tp += ni;
#line 3269
    *xpp = (void*)xp;
#line 3269
  }
#line 3269
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3269

#line 3269
#else   /* not SX */
#line 3269

#line 3269
	char *xp = (char *) *xpp;
#line 3269
	int status = NC_NOERR;
#line 3269

#line 3269
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3269
	{
#line 3269
		int lstatus = ncx_put_float_int(xp, tp, fillp);
#line 3269
		if (status == NC_NOERR) /* report the first encountered error */
#line 3269
			status = lstatus;
#line 3269
	}
#line 3269

#line 3269
	*xpp = (void *)xp;
#line 3269
	return status;
#line 3269
#endif
#line 3269
}
#line 3269

int
#line 3270
ncx_putn_float_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3270
{
#line 3270
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3270

#line 3270
 /* basic algorithm is:
#line 3270
  *   - ensure sane alignment of output data
#line 3270
  *   - copy (conversion happens automatically) input data
#line 3270
  *     to output
#line 3270
  *   - update tp to point at next unconverted input, and xpp to point
#line 3270
  *     at next location for converted output
#line 3270
  */
#line 3270
  long i, j, ni;
#line 3270
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3270
  float *xp;
#line 3270
  int nrange = 0;         /* number of range errors */
#line 3270
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3270
  long cxp = (long) *((char**)xpp);
#line 3270

#line 3270
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3270
  /* sjl: manually stripmine so we can limit amount of
#line 3270
   * vector work space reserved to LOOPCNT elements. Also
#line 3270
   * makes vectorisation easy */
#line 3270
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3270
    ni=Min(nelems-j,LOOPCNT);
#line 3270
    if (realign) {
#line 3270
      xp = tmp;
#line 3270
    } else {
#line 3270
      xp = (float *) *xpp;
#line 3270
    }
#line 3270
   /* copy the next block */
#line 3270
#pragma cdir loopcnt=LOOPCNT
#line 3270
#pragma cdir shortloop
#line 3270
    for (i=0; i<ni; i++) {
#line 3270
      /* the normal case: */
#line 3270
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3270
     /* test for range errors (not always needed but do it anyway) */
#line 3270
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3270
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3270
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
#line 3270
    }
#line 3270
   /* copy workspace back if necessary */
#line 3270
    if (realign) {
#line 3270
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3270
      xp = (float *) *xpp;
#line 3270
    }
#line 3270
   /* update xpp and tp */
#line 3270
    xp += ni;
#line 3270
    tp += ni;
#line 3270
    *xpp = (void*)xp;
#line 3270
  }
#line 3270
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3270

#line 3270
#else   /* not SX */
#line 3270

#line 3270
	char *xp = (char *) *xpp;
#line 3270
	int status = NC_NOERR;
#line 3270

#line 3270
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3270
	{
#line 3270
		int lstatus = ncx_put_float_long(xp, tp, fillp);
#line 3270
		if (status == NC_NOERR) /* report the first encountered error */
#line 3270
			status = lstatus;
#line 3270
	}
#line 3270

#line 3270
	*xpp = (void *)xp;
#line 3270
	return status;
#line 3270
#endif
#line 3270
}
#line 3270

int
#line 3271
ncx_putn_float_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3271
{
#line 3271
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3271

#line 3271
 /* basic algorithm is:
#line 3271
  *   - ensure sane alignment of output data
#line 3271
  *   - copy (conversion happens automatically) input data
#line 3271
  *     to output
#line 3271
  *   - update tp to point at next unconverted input, and xpp to point
#line 3271
  *     at next location for converted output
#line 3271
  */
#line 3271
  long i, j, ni;
#line 3271
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3271
  float *xp;
#line 3271
  int nrange = 0;         /* number of range errors */
#line 3271
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3271
  long cxp = (long) *((char**)xpp);
#line 3271

#line 3271
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3271
  /* sjl: manually stripmine so we can limit amount of
#line 3271
   * vector work space reserved to LOOPCNT elements. Also
#line 3271
   * makes vectorisation easy */
#line 3271
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3271
    ni=Min(nelems-j,LOOPCNT);
#line 3271
    if (realign) {
#line 3271
      xp = tmp;
#line 3271
    } else {
#line 3271
      xp = (float *) *xpp;
#line 3271
    }
#line 3271
   /* copy the next block */
#line 3271
#pragma cdir loopcnt=LOOPCNT
#line 3271
#pragma cdir shortloop
#line 3271
    for (i=0; i<ni; i++) {
#line 3271
      /* the normal case: */
#line 3271
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3271
     /* test for range errors (not always needed but do it anyway) */
#line 3271
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3271
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3271
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
#line 3271
    }
#line 3271
   /* copy workspace back if necessary */
#line 3271
    if (realign) {
#line 3271
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3271
      xp = (float *) *xpp;
#line 3271
    }
#line 3271
   /* update xpp and tp */
#line 3271
    xp += ni;
#line 3271
    tp += ni;
#line 3271
    *xpp = (void*)xp;
#line 3271
  }
#line 3271
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3271

#line 3271
#else   /* not SX */
#line 3271

#line 3271
	char *xp = (char *) *xpp;
#line 3271
	int status = NC_NOERR;
#line 3271

#line 3271
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3271
	{
#line 3271
		int lstatus = ncx_put_float_double(xp, tp, fillp);
#line 3271
		if (status == NC_NOERR) /* report the first encountered error */
#line 3271
			status = lstatus;
#line 3271
	}
#line 3271

#line 3271
	*xpp = (void *)xp;
#line 3271
	return status;
#line 3271
#endif
#line 3271
}
#line 3271

int
#line 3272
ncx_putn_float_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3272
{
#line 3272
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3272

#line 3272
 /* basic algorithm is:
#line 3272
  *   - ensure sane alignment of output data
#line 3272
  *   - copy (conversion happens automatically) input data
#line 3272
  *     to output
#line 3272
  *   - update tp to point at next unconverted input, and xpp to point
#line 3272
  *     at next location for converted output
#line 3272
  */
#line 3272
  long i, j, ni;
#line 3272
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3272
  float *xp;
#line 3272
  int nrange = 0;         /* number of range errors */
#line 3272
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3272
  long cxp = (long) *((char**)xpp);
#line 3272

#line 3272
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3272
  /* sjl: manually stripmine so we can limit amount of
#line 3272
   * vector work space reserved to LOOPCNT elements. Also
#line 3272
   * makes vectorisation easy */
#line 3272
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3272
    ni=Min(nelems-j,LOOPCNT);
#line 3272
    if (realign) {
#line 3272
      xp = tmp;
#line 3272
    } else {
#line 3272
      xp = (float *) *xpp;
#line 3272
    }
#line 3272
   /* copy the next block */
#line 3272
#pragma cdir loopcnt=LOOPCNT
#line 3272
#pragma cdir shortloop
#line 3272
    for (i=0; i<ni; i++) {
#line 3272
      /* the normal case: */
#line 3272
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3272
     /* test for range errors (not always needed but do it anyway) */
#line 3272
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3272
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3272
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
#line 3272
    }
#line 3272
   /* copy workspace back if necessary */
#line 3272
    if (realign) {
#line 3272
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3272
      xp = (float *) *xpp;
#line 3272
    }
#line 3272
   /* update xpp and tp */
#line 3272
    xp += ni;
#line 3272
    tp += ni;
#line 3272
    *xpp = (void*)xp;
#line 3272
  }
#line 3272
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3272

#line 3272
#else   /* not SX */
#line 3272

#line 3272
	char *xp = (char *) *xpp;
#line 3272
	int status = NC_NOERR;
#line 3272

#line 3272
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3272
	{
#line 3272
		int lstatus = ncx_put_float_longlong(xp, tp, fillp);
#line 3272
		if (status == NC_NOERR) /* report the first encountered error */
#line 3272
			status = lstatus;
#line 3272
	}
#line 3272

#line 3272
	*xpp = (void *)xp;
#line 3272
	return status;
#line 3272
#endif
#line 3272
}
#line 3272

int
#line 3273
ncx_putn_float_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3273
{
#line 3273
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3273

#line 3273
 /* basic algorithm is:
#line 3273
  *   - ensure sane alignment of output data
#line 3273
  *   - copy (conversion happens automatically) input data
#line 3273
  *     to output
#line 3273
  *   - update tp to point at next unconverted input, and xpp to point
#line 3273
  *     at next location for converted output
#line 3273
  */
#line 3273
  long i, j, ni;
#line 3273
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3273
  float *xp;
#line 3273
  int nrange = 0;         /* number of range errors */
#line 3273
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3273
  long cxp = (long) *((char**)xpp);
#line 3273

#line 3273
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3273
  /* sjl: manually stripmine so we can limit amount of
#line 3273
   * vector work space reserved to LOOPCNT elements. Also
#line 3273
   * makes vectorisation easy */
#line 3273
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3273
    ni=Min(nelems-j,LOOPCNT);
#line 3273
    if (realign) {
#line 3273
      xp = tmp;
#line 3273
    } else {
#line 3273
      xp = (float *) *xpp;
#line 3273
    }
#line 3273
   /* copy the next block */
#line 3273
#pragma cdir loopcnt=LOOPCNT
#line 3273
#pragma cdir shortloop
#line 3273
    for (i=0; i<ni; i++) {
#line 3273
      /* the normal case: */
#line 3273
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3273
     /* test for range errors (not always needed but do it anyway) */
#line 3273
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3273
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3273
      nrange += tp[i] > X_FLOAT_MAX ;
#line 3273
    }
#line 3273
   /* copy workspace back if necessary */
#line 3273
    if (realign) {
#line 3273
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3273
      xp = (float *) *xpp;
#line 3273
    }
#line 3273
   /* update xpp and tp */
#line 3273
    xp += ni;
#line 3273
    tp += ni;
#line 3273
    *xpp = (void*)xp;
#line 3273
  }
#line 3273
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3273

#line 3273
#else   /* not SX */
#line 3273

#line 3273
	char *xp = (char *) *xpp;
#line 3273
	int status = NC_NOERR;
#line 3273

#line 3273
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3273
	{
#line 3273
		int lstatus = ncx_put_float_uchar(xp, tp, fillp);
#line 3273
		if (status == NC_NOERR) /* report the first encountered error */
#line 3273
			status = lstatus;
#line 3273
	}
#line 3273

#line 3273
	*xpp = (void *)xp;
#line 3273
	return status;
#line 3273
#endif
#line 3273
}
#line 3273

int
#line 3274
ncx_putn_float_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3274
{
#line 3274
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3274

#line 3274
 /* basic algorithm is:
#line 3274
  *   - ensure sane alignment of output data
#line 3274
  *   - copy (conversion happens automatically) input data
#line 3274
  *     to output
#line 3274
  *   - update tp to point at next unconverted input, and xpp to point
#line 3274
  *     at next location for converted output
#line 3274
  */
#line 3274
  long i, j, ni;
#line 3274
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3274
  float *xp;
#line 3274
  int nrange = 0;         /* number of range errors */
#line 3274
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3274
  long cxp = (long) *((char**)xpp);
#line 3274

#line 3274
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3274
  /* sjl: manually stripmine so we can limit amount of
#line 3274
   * vector work space reserved to LOOPCNT elements. Also
#line 3274
   * makes vectorisation easy */
#line 3274
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3274
    ni=Min(nelems-j,LOOPCNT);
#line 3274
    if (realign) {
#line 3274
      xp = tmp;
#line 3274
    } else {
#line 3274
      xp = (float *) *xpp;
#line 3274
    }
#line 3274
   /* copy the next block */
#line 3274
#pragma cdir loopcnt=LOOPCNT
#line 3274
#pragma cdir shortloop
#line 3274
    for (i=0; i<ni; i++) {
#line 3274
      /* the normal case: */
#line 3274
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3274
     /* test for range errors (not always needed but do it anyway) */
#line 3274
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3274
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3274
      nrange += tp[i] > X_FLOAT_MAX ;
#line 3274
    }
#line 3274
   /* copy workspace back if necessary */
#line 3274
    if (realign) {
#line 3274
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3274
      xp = (float *) *xpp;
#line 3274
    }
#line 3274
   /* update xpp and tp */
#line 3274
    xp += ni;
#line 3274
    tp += ni;
#line 3274
    *xpp = (void*)xp;
#line 3274
  }
#line 3274
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3274

#line 3274
#else   /* not SX */
#line 3274

#line 3274
	char *xp = (char *) *xpp;
#line 3274
	int status = NC_NOERR;
#line 3274

#line 3274
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3274
	{
#line 3274
		int lstatus = ncx_put_float_ushort(xp, tp, fillp);
#line 3274
		if (status == NC_NOERR) /* report the first encountered error */
#line 3274
			status = lstatus;
#line 3274
	}
#line 3274

#line 3274
	*xpp = (void *)xp;
#line 3274
	return status;
#line 3274
#endif
#line 3274
}
#line 3274

int
#line 3275
ncx_putn_float_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3275
{
#line 3275
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3275

#line 3275
 /* basic algorithm is:
#line 3275
  *   - ensure sane alignment of output data
#line 3275
  *   - copy (conversion happens automatically) input data
#line 3275
  *     to output
#line 3275
  *   - update tp to point at next unconverted input, and xpp to point
#line 3275
  *     at next location for converted output
#line 3275
  */
#line 3275
  long i, j, ni;
#line 3275
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3275
  float *xp;
#line 3275
  int nrange = 0;         /* number of range errors */
#line 3275
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3275
  long cxp = (long) *((char**)xpp);
#line 3275

#line 3275
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3275
  /* sjl: manually stripmine so we can limit amount of
#line 3275
   * vector work space reserved to LOOPCNT elements. Also
#line 3275
   * makes vectorisation easy */
#line 3275
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3275
    ni=Min(nelems-j,LOOPCNT);
#line 3275
    if (realign) {
#line 3275
      xp = tmp;
#line 3275
    } else {
#line 3275
      xp = (float *) *xpp;
#line 3275
    }
#line 3275
   /* copy the next block */
#line 3275
#pragma cdir loopcnt=LOOPCNT
#line 3275
#pragma cdir shortloop
#line 3275
    for (i=0; i<ni; i++) {
#line 3275
      /* the normal case: */
#line 3275
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3275
     /* test for range errors (not always needed but do it anyway) */
#line 3275
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3275
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3275
      nrange += tp[i] > X_FLOAT_MAX ;
#line 3275
    }
#line 3275
   /* copy workspace back if necessary */
#line 3275
    if (realign) {
#line 3275
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3275
      xp = (float *) *xpp;
#line 3275
    }
#line 3275
   /* update xpp and tp */
#line 3275
    xp += ni;
#line 3275
    tp += ni;
#line 3275
    *xpp = (void*)xp;
#line 3275
  }
#line 3275
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3275

#line 3275
#else   /* not SX */
#line 3275

#line 3275
	char *xp = (char *) *xpp;
#line 3275
	int status = NC_NOERR;
#line 3275

#line 3275
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3275
	{
#line 3275
		int lstatus = ncx_put_float_uint(xp, tp, fillp);
#line 3275
		if (status == NC_NOERR) /* report the first encountered error */
#line 3275
			status = lstatus;
#line 3275
	}
#line 3275

#line 3275
	*xpp = (void *)xp;
#line 3275
	return status;
#line 3275
#endif
#line 3275
}
#line 3275

int
#line 3276
ncx_putn_float_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3276
{
#line 3276
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3276

#line 3276
 /* basic algorithm is:
#line 3276
  *   - ensure sane alignment of output data
#line 3276
  *   - copy (conversion happens automatically) input data
#line 3276
  *     to output
#line 3276
  *   - update tp to point at next unconverted input, and xpp to point
#line 3276
  *     at next location for converted output
#line 3276
  */
#line 3276
  long i, j, ni;
#line 3276
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3276
  float *xp;
#line 3276
  int nrange = 0;         /* number of range errors */
#line 3276
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3276
  long cxp = (long) *((char**)xpp);
#line 3276

#line 3276
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3276
  /* sjl: manually stripmine so we can limit amount of
#line 3276
   * vector work space reserved to LOOPCNT elements. Also
#line 3276
   * makes vectorisation easy */
#line 3276
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3276
    ni=Min(nelems-j,LOOPCNT);
#line 3276
    if (realign) {
#line 3276
      xp = tmp;
#line 3276
    } else {
#line 3276
      xp = (float *) *xpp;
#line 3276
    }
#line 3276
   /* copy the next block */
#line 3276
#pragma cdir loopcnt=LOOPCNT
#line 3276
#pragma cdir shortloop
#line 3276
    for (i=0; i<ni; i++) {
#line 3276
      /* the normal case: */
#line 3276
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3276
     /* test for range errors (not always needed but do it anyway) */
#line 3276
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3276
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3276
      nrange += tp[i] > X_FLOAT_MAX ;
#line 3276
    }
#line 3276
   /* copy workspace back if necessary */
#line 3276
    if (realign) {
#line 3276
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3276
      xp = (float *) *xpp;
#line 3276
    }
#line 3276
   /* update xpp and tp */
#line 3276
    xp += ni;
#line 3276
    tp += ni;
#line 3276
    *xpp = (void*)xp;
#line 3276
  }
#line 3276
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3276

#line 3276
#else   /* not SX */
#line 3276

#line 3276
	char *xp = (char *) *xpp;
#line 3276
	int status = NC_NOERR;
#line 3276

#line 3276
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3276
	{
#line 3276
		int lstatus = ncx_put_float_ulonglong(xp, tp, fillp);
#line 3276
		if (status == NC_NOERR) /* report the first encountered error */
#line 3276
			status = lstatus;
#line 3276
	}
#line 3276

#line 3276
	*xpp = (void *)xp;
#line 3276
	return status;
#line 3276
#endif
#line 3276
}
#line 3276


/* double --------------------------------------------------------------------*/

#if X_SIZEOF_DOUBLE == SIZEOF_DOUBLE && !defined(NO_IEEE_FLOAT)
/* optimized version */
int
ncx_getn_double_double(const void **xpp, size_t nelems, double *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_DOUBLE);
# else
	swapn8b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_DOUBLE);
	return NC_NOERR;
}
#elif defined(vax) && vax != 0
int
ncx_getn_double_double(const void **xpp, size_t ndoubles, double *ip)
{
	double *const end = ip + ndoubles;

	while (ip < end)
	{
	struct vax_double *const vdp =
#line 3301
			 (struct vax_double *)ip;
#line 3301
	const struct ieee_double *const idp =
#line 3301
			 (const struct ieee_double *) (*xpp);
#line 3301
	{
#line 3301
		const struct dbl_limits *lim;
#line 3301
		int ii;
#line 3301
		for (ii = 0, lim = dbl_limits;
#line 3301
			ii < sizeof(dbl_limits)/sizeof(struct dbl_limits);
#line 3301
			ii++, lim++)
#line 3301
		{
#line 3301
			if ((idp->mant_lo == lim->ieee.mant_lo)
#line 3301
				&& (idp->mant_4 == lim->ieee.mant_4)
#line 3301
				&& (idp->mant_5 == lim->ieee.mant_5)
#line 3301
				&& (idp->mant_6 == lim->ieee.mant_6)
#line 3301
				&& (idp->exp_lo == lim->ieee.exp_lo)
#line 3301
				&& (idp->exp_hi == lim->ieee.exp_hi)
#line 3301
				)
#line 3301
			{
#line 3301
				*vdp = lim->d;
#line 3301
				goto doneit;
#line 3301
			}
#line 3301
		}
#line 3301
	}
#line 3301
	{
#line 3301
		unsigned exp = idp->exp_hi << 4 | idp->exp_lo;
#line 3301
		vdp->exp = exp - IEEE_DBL_BIAS + VAX_DBL_BIAS;
#line 3301
	}
#line 3301
	{
#line 3301
		unsigned mant_hi = ((idp->mant_6 << 16)
#line 3301
				 | (idp->mant_5 << 8)
#line 3301
				 | idp->mant_4);
#line 3301
		unsigned mant_lo = SWAP4(idp->mant_lo);
#line 3301
		vdp->mantissa1 = (mant_hi >> 13);
#line 3301
		vdp->mantissa2 = ((mant_hi & MASK(13)) << 3)
#line 3301
				| (mant_lo >> 29);
#line 3301
		vdp->mantissa3 = (mant_lo >> 13);
#line 3301
		vdp->mantissa4 = (mant_lo << 3);
#line 3301
	}
#line 3301
	doneit:
#line 3301
		vdp->sign = idp->sign;
#line 3301

		ip++;
		*xpp = (char *)(*xpp) + X_SIZEOF_DOUBLE;
	}
	return NC_NOERR;
}
	/* vax */
#else
int
ncx_getn_double_double(const void **xpp, size_t nelems, double *tp)
{
	const char *xp = *xpp;
	int status = NC_NOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
	{
		const int lstatus = ncx_get_double_double(xp, tp, fillp);
		if (status == NC_NOERR) /* report the first encountered error */
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
}
#endif
int
#line 3326
ncx_getn_double_schar(const void **xpp, size_t nelems, schar *tp)
#line 3326
{
#line 3326
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3326

#line 3326
 /* basic algorithm is:
#line 3326
  *   - ensure sane alignment of input data
#line 3326
  *   - copy (conversion happens automatically) input data
#line 3326
  *     to output
#line 3326
  *   - update xpp to point at next unconverted input, and tp to point
#line 3326
  *     at next location for converted output
#line 3326
  */
#line 3326
  long i, j, ni;
#line 3326
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3326
  double *xp;
#line 3326
  int nrange = 0;         /* number of range errors */
#line 3326
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3326
  long cxp = (long) *((char**)xpp);
#line 3326

#line 3326
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3326
  /* sjl: manually stripmine so we can limit amount of
#line 3326
   * vector work space reserved to LOOPCNT elements. Also
#line 3326
   * makes vectorisation easy */
#line 3326
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3326
    ni=Min(nelems-j,LOOPCNT);
#line 3326
    if (realign) {
#line 3326
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3326
      xp = tmp;
#line 3326
    } else {
#line 3326
      xp = (double *) *xpp;
#line 3326
    }
#line 3326
   /* copy the next block */
#line 3326
#pragma cdir loopcnt=LOOPCNT
#line 3326
#pragma cdir shortloop
#line 3326
    for (i=0; i<ni; i++) {
#line 3326
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3326
     /* test for range errors (not always needed but do it anyway) */
#line 3326
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3326
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3326
      nrange += xp[i] > SCHAR_MAX || xp[i] < SCHAR_MIN;
#line 3326
    }
#line 3326
   /* update xpp and tp */
#line 3326
    if (realign) xp = (double *) *xpp;
#line 3326
    xp += ni;
#line 3326
    tp += ni;
#line 3326
    *xpp = (void*)xp;
#line 3326
  }
#line 3326
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3326

#line 3326
#else   /* not SX */
#line 3326
	const char *xp = (const char *) *xpp;
#line 3326
	int status = NC_NOERR;
#line 3326

#line 3326
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3326
	{
#line 3326
		const int lstatus = ncx_get_double_schar(xp, tp);
#line 3326
		if (status == NC_NOERR) /* report the first encountered error */
#line 3326
			status = lstatus;
#line 3326
	}
#line 3326

#line 3326
	*xpp = (const void *)xp;
#line 3326
	return status;
#line 3326
#endif
#line 3326
}
#line 3326

int
#line 3327
ncx_getn_double_short(const void **xpp, size_t nelems, short *tp)
#line 3327
{
#line 3327
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3327

#line 3327
 /* basic algorithm is:
#line 3327
  *   - ensure sane alignment of input data
#line 3327
  *   - copy (conversion happens automatically) input data
#line 3327
  *     to output
#line 3327
  *   - update xpp to point at next unconverted input, and tp to point
#line 3327
  *     at next location for converted output
#line 3327
  */
#line 3327
  long i, j, ni;
#line 3327
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3327
  double *xp;
#line 3327
  int nrange = 0;         /* number of range errors */
#line 3327
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3327
  long cxp = (long) *((char**)xpp);
#line 3327

#line 3327
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3327
  /* sjl: manually stripmine so we can limit amount of
#line 3327
   * vector work space reserved to LOOPCNT elements. Also
#line 3327
   * makes vectorisation easy */
#line 3327
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3327
    ni=Min(nelems-j,LOOPCNT);
#line 3327
    if (realign) {
#line 3327
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3327
      xp = tmp;
#line 3327
    } else {
#line 3327
      xp = (double *) *xpp;
#line 3327
    }
#line 3327
   /* copy the next block */
#line 3327
#pragma cdir loopcnt=LOOPCNT
#line 3327
#pragma cdir shortloop
#line 3327
    for (i=0; i<ni; i++) {
#line 3327
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3327
     /* test for range errors (not always needed but do it anyway) */
#line 3327
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3327
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3327
      nrange += xp[i] > SHORT_MAX || xp[i] < SHORT_MIN;
#line 3327
    }
#line 3327
   /* update xpp and tp */
#line 3327
    if (realign) xp = (double *) *xpp;
#line 3327
    xp += ni;
#line 3327
    tp += ni;
#line 3327
    *xpp = (void*)xp;
#line 3327
  }
#line 3327
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3327

#line 3327
#else   /* not SX */
#line 3327
	const char *xp = (const char *) *xpp;
#line 3327
	int status = NC_NOERR;
#line 3327

#line 3327
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3327
	{
#line 3327
		const int lstatus = ncx_get_double_short(xp, tp);
#line 3327
		if (status == NC_NOERR) /* report the first encountered error */
#line 3327
			status = lstatus;
#line 3327
	}
#line 3327

#line 3327
	*xpp = (const void *)xp;
#line 3327
	return status;
#line 3327
#endif
#line 3327
}
#line 3327

int
#line 3328
ncx_getn_double_int(const void **xpp, size_t nelems, int *tp)
#line 3328
{
#line 3328
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3328

#line 3328
 /* basic algorithm is:
#line 3328
  *   - ensure sane alignment of input data
#line 3328
  *   - copy (conversion happens automatically) input data
#line 3328
  *     to output
#line 3328
  *   - update xpp to point at next unconverted input, and tp to point
#line 3328
  *     at next location for converted output
#line 3328
  */
#line 3328
  long i, j, ni;
#line 3328
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3328
  double *xp;
#line 3328
  int nrange = 0;         /* number of range errors */
#line 3328
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3328
  long cxp = (long) *((char**)xpp);
#line 3328

#line 3328
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3328
  /* sjl: manually stripmine so we can limit amount of
#line 3328
   * vector work space reserved to LOOPCNT elements. Also
#line 3328
   * makes vectorisation easy */
#line 3328
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3328
    ni=Min(nelems-j,LOOPCNT);
#line 3328
    if (realign) {
#line 3328
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3328
      xp = tmp;
#line 3328
    } else {
#line 3328
      xp = (double *) *xpp;
#line 3328
    }
#line 3328
   /* copy the next block */
#line 3328
#pragma cdir loopcnt=LOOPCNT
#line 3328
#pragma cdir shortloop
#line 3328
    for (i=0; i<ni; i++) {
#line 3328
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3328
     /* test for range errors (not always needed but do it anyway) */
#line 3328
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3328
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3328
      nrange += xp[i] > INT_MAX || xp[i] < INT_MIN;
#line 3328
    }
#line 3328
   /* update xpp and tp */
#line 3328
    if (realign) xp = (double *) *xpp;
#line 3328
    xp += ni;
#line 3328
    tp += ni;
#line 3328
    *xpp = (void*)xp;
#line 3328
  }
#line 3328
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3328

#line 3328
#else   /* not SX */
#line 3328
	const char *xp = (const char *) *xpp;
#line 3328
	int status = NC_NOERR;
#line 3328

#line 3328
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3328
	{
#line 3328
		const int lstatus = ncx_get_double_int(xp, tp);
#line 3328
		if (status == NC_NOERR) /* report the first encountered error */
#line 3328
			status = lstatus;
#line 3328
	}
#line 3328

#line 3328
	*xpp = (const void *)xp;
#line 3328
	return status;
#line 3328
#endif
#line 3328
}
#line 3328

int
#line 3329
ncx_getn_double_long(const void **xpp, size_t nelems, long *tp)
#line 3329
{
#line 3329
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3329

#line 3329
 /* basic algorithm is:
#line 3329
  *   - ensure sane alignment of input data
#line 3329
  *   - copy (conversion happens automatically) input data
#line 3329
  *     to output
#line 3329
  *   - update xpp to point at next unconverted input, and tp to point
#line 3329
  *     at next location for converted output
#line 3329
  */
#line 3329
  long i, j, ni;
#line 3329
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3329
  double *xp;
#line 3329
  int nrange = 0;         /* number of range errors */
#line 3329
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3329
  long cxp = (long) *((char**)xpp);
#line 3329

#line 3329
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3329
  /* sjl: manually stripmine so we can limit amount of
#line 3329
   * vector work space reserved to LOOPCNT elements. Also
#line 3329
   * makes vectorisation easy */
#line 3329
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3329
    ni=Min(nelems-j,LOOPCNT);
#line 3329
    if (realign) {
#line 3329
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3329
      xp = tmp;
#line 3329
    } else {
#line 3329
      xp = (double *) *xpp;
#line 3329
    }
#line 3329
   /* copy the next block */
#line 3329
#pragma cdir loopcnt=LOOPCNT
#line 3329
#pragma cdir shortloop
#line 3329
    for (i=0; i<ni; i++) {
#line 3329
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3329
     /* test for range errors (not always needed but do it anyway) */
#line 3329
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3329
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3329
      nrange += xp[i] > LONG_MAX || xp[i] < LONG_MIN;
#line 3329
    }
#line 3329
   /* update xpp and tp */
#line 3329
    if (realign) xp = (double *) *xpp;
#line 3329
    xp += ni;
#line 3329
    tp += ni;
#line 3329
    *xpp = (void*)xp;
#line 3329
  }
#line 3329
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3329

#line 3329
#else   /* not SX */
#line 3329
	const char *xp = (const char *) *xpp;
#line 3329
	int status = NC_NOERR;
#line 3329

#line 3329
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3329
	{
#line 3329
		const int lstatus = ncx_get_double_long(xp, tp);
#line 3329
		if (status == NC_NOERR) /* report the first encountered error */
#line 3329
			status = lstatus;
#line 3329
	}
#line 3329

#line 3329
	*xpp = (const void *)xp;
#line 3329
	return status;
#line 3329
#endif
#line 3329
}
#line 3329

int
#line 3330
ncx_getn_double_float(const void **xpp, size_t nelems, float *tp)
#line 3330
{
#line 3330
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3330

#line 3330
 /* basic algorithm is:
#line 3330
  *   - ensure sane alignment of input data
#line 3330
  *   - copy (conversion happens automatically) input data
#line 3330
  *     to output
#line 3330
  *   - update xpp to point at next unconverted input, and tp to point
#line 3330
  *     at next location for converted output
#line 3330
  */
#line 3330
  long i, j, ni;
#line 3330
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3330
  double *xp;
#line 3330
  int nrange = 0;         /* number of range errors */
#line 3330
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3330
  long cxp = (long) *((char**)xpp);
#line 3330

#line 3330
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3330
  /* sjl: manually stripmine so we can limit amount of
#line 3330
   * vector work space reserved to LOOPCNT elements. Also
#line 3330
   * makes vectorisation easy */
#line 3330
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3330
    ni=Min(nelems-j,LOOPCNT);
#line 3330
    if (realign) {
#line 3330
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3330
      xp = tmp;
#line 3330
    } else {
#line 3330
      xp = (double *) *xpp;
#line 3330
    }
#line 3330
   /* copy the next block */
#line 3330
#pragma cdir loopcnt=LOOPCNT
#line 3330
#pragma cdir shortloop
#line 3330
    for (i=0; i<ni; i++) {
#line 3330
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 3330
     /* test for range errors (not always needed but do it anyway) */
#line 3330
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3330
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3330
      nrange += xp[i] > FLOAT_MAX || xp[i] < FLOAT_MIN;
#line 3330
    }
#line 3330
   /* update xpp and tp */
#line 3330
    if (realign) xp = (double *) *xpp;
#line 3330
    xp += ni;
#line 3330
    tp += ni;
#line 3330
    *xpp = (void*)xp;
#line 3330
  }
#line 3330
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3330

#line 3330
#else   /* not SX */
#line 3330
	const char *xp = (const char *) *xpp;
#line 3330
	int status = NC_NOERR;
#line 3330

#line 3330
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3330
	{
#line 3330
		const int lstatus = ncx_get_double_float(xp, tp);
#line 3330
		if (status == NC_NOERR) /* report the first encountered error */
#line 3330
			status = lstatus;
#line 3330
	}
#line 3330

#line 3330
	*xpp = (const void *)xp;
#line 3330
	return status;
#line 3330
#endif
#line 3330
}
#line 3330

int
#line 3331
ncx_getn_double_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3331
{
#line 3331
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3331

#line 3331
 /* basic algorithm is:
#line 3331
  *   - ensure sane alignment of input data
#line 3331
  *   - copy (conversion happens automatically) input data
#line 3331
  *     to output
#line 3331
  *   - update xpp to point at next unconverted input, and tp to point
#line 3331
  *     at next location for converted output
#line 3331
  */
#line 3331
  long i, j, ni;
#line 3331
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3331
  double *xp;
#line 3331
  int nrange = 0;         /* number of range errors */
#line 3331
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3331
  long cxp = (long) *((char**)xpp);
#line 3331

#line 3331
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3331
  /* sjl: manually stripmine so we can limit amount of
#line 3331
   * vector work space reserved to LOOPCNT elements. Also
#line 3331
   * makes vectorisation easy */
#line 3331
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3331
    ni=Min(nelems-j,LOOPCNT);
#line 3331
    if (realign) {
#line 3331
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3331
      xp = tmp;
#line 3331
    } else {
#line 3331
      xp = (double *) *xpp;
#line 3331
    }
#line 3331
   /* copy the next block */
#line 3331
#pragma cdir loopcnt=LOOPCNT
#line 3331
#pragma cdir shortloop
#line 3331
    for (i=0; i<ni; i++) {
#line 3331
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3331
     /* test for range errors (not always needed but do it anyway) */
#line 3331
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3331
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3331
      nrange += xp[i] > LONGLONG_MAX || xp[i] < LONGLONG_MIN;
#line 3331
    }
#line 3331
   /* update xpp and tp */
#line 3331
    if (realign) xp = (double *) *xpp;
#line 3331
    xp += ni;
#line 3331
    tp += ni;
#line 3331
    *xpp = (void*)xp;
#line 3331
  }
#line 3331
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3331

#line 3331
#else   /* not SX */
#line 3331
	const char *xp = (const char *) *xpp;
#line 3331
	int status = NC_NOERR;
#line 3331

#line 3331
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3331
	{
#line 3331
		const int lstatus = ncx_get_double_longlong(xp, tp);
#line 3331
		if (status == NC_NOERR) /* report the first encountered error */
#line 3331
			status = lstatus;
#line 3331
	}
#line 3331

#line 3331
	*xpp = (const void *)xp;
#line 3331
	return status;
#line 3331
#endif
#line 3331
}
#line 3331

int
#line 3332
ncx_getn_double_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3332
{
#line 3332
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3332

#line 3332
 /* basic algorithm is:
#line 3332
  *   - ensure sane alignment of input data
#line 3332
  *   - copy (conversion happens automatically) input data
#line 3332
  *     to output
#line 3332
  *   - update xpp to point at next unconverted input, and tp to point
#line 3332
  *     at next location for converted output
#line 3332
  */
#line 3332
  long i, j, ni;
#line 3332
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3332
  double *xp;
#line 3332
  int nrange = 0;         /* number of range errors */
#line 3332
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3332
  long cxp = (long) *((char**)xpp);
#line 3332

#line 3332
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3332
  /* sjl: manually stripmine so we can limit amount of
#line 3332
   * vector work space reserved to LOOPCNT elements. Also
#line 3332
   * makes vectorisation easy */
#line 3332
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3332
    ni=Min(nelems-j,LOOPCNT);
#line 3332
    if (realign) {
#line 3332
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3332
      xp = tmp;
#line 3332
    } else {
#line 3332
      xp = (double *) *xpp;
#line 3332
    }
#line 3332
   /* copy the next block */
#line 3332
#pragma cdir loopcnt=LOOPCNT
#line 3332
#pragma cdir shortloop
#line 3332
    for (i=0; i<ni; i++) {
#line 3332
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3332
     /* test for range errors (not always needed but do it anyway) */
#line 3332
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3332
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3332
      nrange += xp[i] > UCHAR_MAX || xp[i] < 0;
#line 3332
    }
#line 3332
   /* update xpp and tp */
#line 3332
    if (realign) xp = (double *) *xpp;
#line 3332
    xp += ni;
#line 3332
    tp += ni;
#line 3332
    *xpp = (void*)xp;
#line 3332
  }
#line 3332
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3332

#line 3332
#else   /* not SX */
#line 3332
	const char *xp = (const char *) *xpp;
#line 3332
	int status = NC_NOERR;
#line 3332

#line 3332
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3332
	{
#line 3332
		const int lstatus = ncx_get_double_uchar(xp, tp);
#line 3332
		if (status == NC_NOERR) /* report the first encountered error */
#line 3332
			status = lstatus;
#line 3332
	}
#line 3332

#line 3332
	*xpp = (const void *)xp;
#line 3332
	return status;
#line 3332
#endif
#line 3332
}
#line 3332

int
#line 3333
ncx_getn_double_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3333
{
#line 3333
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3333

#line 3333
 /* basic algorithm is:
#line 3333
  *   - ensure sane alignment of input data
#line 3333
  *   - copy (conversion happens automatically) input data
#line 3333
  *     to output
#line 3333
  *   - update xpp to point at next unconverted input, and tp to point
#line 3333
  *     at next location for converted output
#line 3333
  */
#line 3333
  long i, j, ni;
#line 3333
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3333
  double *xp;
#line 3333
  int nrange = 0;         /* number of range errors */
#line 3333
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3333
  long cxp = (long) *((char**)xpp);
#line 3333

#line 3333
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3333
  /* sjl: manually stripmine so we can limit amount of
#line 3333
   * vector work space reserved to LOOPCNT elements. Also
#line 3333
   * makes vectorisation easy */
#line 3333
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3333
    ni=Min(nelems-j,LOOPCNT);
#line 3333
    if (realign) {
#line 3333
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3333
      xp = tmp;
#line 3333
    } else {
#line 3333
      xp = (double *) *xpp;
#line 3333
    }
#line 3333
   /* copy the next block */
#line 3333
#pragma cdir loopcnt=LOOPCNT
#line 3333
#pragma cdir shortloop
#line 3333
    for (i=0; i<ni; i++) {
#line 3333
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3333
     /* test for range errors (not always needed but do it anyway) */
#line 3333
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3333
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3333
      nrange += xp[i] > USHORT_MAX || xp[i] < 0;
#line 3333
    }
#line 3333
   /* update xpp and tp */
#line 3333
    if (realign) xp = (double *) *xpp;
#line 3333
    xp += ni;
#line 3333
    tp += ni;
#line 3333
    *xpp = (void*)xp;
#line 3333
  }
#line 3333
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3333

#line 3333
#else   /* not SX */
#line 3333
	const char *xp = (const char *) *xpp;
#line 3333
	int status = NC_NOERR;
#line 3333

#line 3333
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3333
	{
#line 3333
		const int lstatus = ncx_get_double_ushort(xp, tp);
#line 3333
		if (status == NC_NOERR) /* report the first encountered error */
#line 3333
			status = lstatus;
#line 3333
	}
#line 3333

#line 3333
	*xpp = (const void *)xp;
#line 3333
	return status;
#line 3333
#endif
#line 3333
}
#line 3333

int
#line 3334
ncx_getn_double_uint(const void **xpp, size_t nelems, uint *tp)
#line 3334
{
#line 3334
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3334

#line 3334
 /* basic algorithm is:
#line 3334
  *   - ensure sane alignment of input data
#line 3334
  *   - copy (conversion happens automatically) input data
#line 3334
  *     to output
#line 3334
  *   - update xpp to point at next unconverted input, and tp to point
#line 3334
  *     at next location for converted output
#line 3334
  */
#line 3334
  long i, j, ni;
#line 3334
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3334
  double *xp;
#line 3334
  int nrange = 0;         /* number of range errors */
#line 3334
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3334
  long cxp = (long) *((char**)xpp);
#line 3334

#line 3334
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3334
  /* sjl: manually stripmine so we can limit amount of
#line 3334
   * vector work space reserved to LOOPCNT elements. Also
#line 3334
   * makes vectorisation easy */
#line 3334
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3334
    ni=Min(nelems-j,LOOPCNT);
#line 3334
    if (realign) {
#line 3334
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3334
      xp = tmp;
#line 3334
    } else {
#line 3334
      xp = (double *) *xpp;
#line 3334
    }
#line 3334
   /* copy the next block */
#line 3334
#pragma cdir loopcnt=LOOPCNT
#line 3334
#pragma cdir shortloop
#line 3334
    for (i=0; i<ni; i++) {
#line 3334
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3334
     /* test for range errors (not always needed but do it anyway) */
#line 3334
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3334
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3334
      nrange += xp[i] > UINT_MAX || xp[i] < 0;
#line 3334
    }
#line 3334
   /* update xpp and tp */
#line 3334
    if (realign) xp = (double *) *xpp;
#line 3334
    xp += ni;
#line 3334
    tp += ni;
#line 3334
    *xpp = (void*)xp;
#line 3334
  }
#line 3334
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3334

#line 3334
#else   /* not SX */
#line 3334
	const char *xp = (const char *) *xpp;
#line 3334
	int status = NC_NOERR;
#line 3334

#line 3334
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3334
	{
#line 3334
		const int lstatus = ncx_get_double_uint(xp, tp);
#line 3334
		if (status == NC_NOERR) /* report the first encountered error */
#line 3334
			status = lstatus;
#line 3334
	}
#line 3334

#line 3334
	*xpp = (const void *)xp;
#line 3334
	return status;
#line 3334
#endif
#line 3334
}
#line 3334

int
#line 3335
ncx_getn_double_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3335
{
#line 3335
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3335

#line 3335
 /* basic algorithm is:
#line 3335
  *   - ensure sane alignment of input data
#line 3335
  *   - copy (conversion happens automatically) input data
#line 3335
  *     to output
#line 3335
  *   - update xpp to point at next unconverted input, and tp to point
#line 3335
  *     at next location for converted output
#line 3335
  */
#line 3335
  long i, j, ni;
#line 3335
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3335
  double *xp;
#line 3335
  int nrange = 0;         /* number of range errors */
#line 3335
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3335
  long cxp = (long) *((char**)xpp);
#line 3335

#line 3335
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3335
  /* sjl: manually stripmine so we can limit amount of
#line 3335
   * vector work space reserved to LOOPCNT elements. Also
#line 3335
   * makes vectorisation easy */
#line 3335
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3335
    ni=Min(nelems-j,LOOPCNT);
#line 3335
    if (realign) {
#line 3335
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3335
      xp = tmp;
#line 3335
    } else {
#line 3335
      xp = (double *) *xpp;
#line 3335
    }
#line 3335
   /* copy the next block */
#line 3335
#pragma cdir loopcnt=LOOPCNT
#line 3335
#pragma cdir shortloop
#line 3335
    for (i=0; i<ni; i++) {
#line 3335
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3335
     /* test for range errors (not always needed but do it anyway) */
#line 3335
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3335
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3335
      nrange += xp[i] > ULONGLONG_MAX || xp[i] < 0;
#line 3335
    }
#line 3335
   /* update xpp and tp */
#line 3335
    if (realign) xp = (double *) *xpp;
#line 3335
    xp += ni;
#line 3335
    tp += ni;
#line 3335
    *xpp = (void*)xp;
#line 3335
  }
#line 3335
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3335

#line 3335
#else   /* not SX */
#line 3335
	const char *xp = (const char *) *xpp;
#line 3335
	int status = NC_NOERR;
#line 3335

#line 3335
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3335
	{
#line 3335
		const int lstatus = ncx_get_double_ulonglong(xp, tp);
#line 3335
		if (status == NC_NOERR) /* report the first encountered error */
#line 3335
			status = lstatus;
#line 3335
	}
#line 3335

#line 3335
	*xpp = (const void *)xp;
#line 3335
	return status;
#line 3335
#endif
#line 3335
}
#line 3335


#if X_SIZEOF_DOUBLE == SIZEOF_DOUBLE && !defined(NO_IEEE_FLOAT)
/* optimized version */
int
ncx_putn_double_double(void **xpp, size_t nelems, const double *tp, void *fillp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_DOUBLE);
# else
	swapn8b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_DOUBLE);
	return NC_NOERR;
}
#elif defined(vax) && vax != 0
int
ncx_putn_double_double(void **xpp, size_t ndoubles, const double *ip, void *fillp)
{
	const double *const end = ip + ndoubles;

	while (ip < end)
	{
	const struct vax_double *const vdp =
#line 3358
			(const struct vax_double *)ip;
#line 3358
	struct ieee_double *const idp =
#line 3358
			 (struct ieee_double *) (*xpp);
#line 3358

#line 3358
	if ((vdp->mantissa4 > (dbl_limits[0].d.mantissa4 - 3)) &&
#line 3358
		(vdp->mantissa3 == dbl_limits[0].d.mantissa3) &&
#line 3358
		(vdp->mantissa2 == dbl_limits[0].d.mantissa2) &&
#line 3358
		(vdp->mantissa1 == dbl_limits[0].d.mantissa1) &&
#line 3358
		(vdp->exp == dbl_limits[0].d.exp))
#line 3358
	{
#line 3358
		*idp = dbl_limits[0].ieee;
#line 3358
		goto shipit;
#line 3358
	}
#line 3358
	if ((vdp->mantissa4 == dbl_limits[1].d.mantissa4) &&
#line 3358
		(vdp->mantissa3 == dbl_limits[1].d.mantissa3) &&
#line 3358
		(vdp->mantissa2 == dbl_limits[1].d.mantissa2) &&
#line 3358
		(vdp->mantissa1 == dbl_limits[1].d.mantissa1) &&
#line 3358
		(vdp->exp == dbl_limits[1].d.exp))
#line 3358
	{
#line 3358
		*idp = dbl_limits[1].ieee;
#line 3358
		goto shipit;
#line 3358
	}
#line 3358

#line 3358
	{
#line 3358
		unsigned exp = vdp->exp - VAX_DBL_BIAS + IEEE_DBL_BIAS;
#line 3358

#line 3358
		unsigned mant_lo = ((vdp->mantissa2 & MASK(3)) << 29) |
#line 3358
			(vdp->mantissa3 << 13) |
#line 3358
			((vdp->mantissa4 >> 3) & MASK(13));
#line 3358

#line 3358
		unsigned mant_hi = (vdp->mantissa1 << 13)
#line 3358
				 | (vdp->mantissa2 >> 3);
#line 3358

#line 3358
		if ((vdp->mantissa4 & 7) > 4)
#line 3358
		{
#line 3358
			/* round up */
#line 3358
			mant_lo++;
#line 3358
			if (mant_lo == 0)
#line 3358
			{
#line 3358
				mant_hi++;
#line 3358
				if (mant_hi > 0xffffff)
#line 3358
				{
#line 3358
					mant_hi = 0;
#line 3358
					exp++;
#line 3358
				}
#line 3358
			}
#line 3358
		}
#line 3358

#line 3358
		idp->mant_lo = SWAP4(mant_lo);
#line 3358
		idp->mant_6 = mant_hi >> 16;
#line 3358
		idp->mant_5 = (mant_hi & 0xff00) >> 8;
#line 3358
		idp->mant_4 = mant_hi;
#line 3358
		idp->exp_hi = exp >> 4;
#line 3358
		idp->exp_lo = exp;
#line 3358
	}
#line 3358

#line 3358
	shipit:
#line 3358
		idp->sign = vdp->sign;
#line 3358

		ip++;
		*xpp = (char *)(*xpp) + X_SIZEOF_DOUBLE;
	}
	return NC_NOERR;
}
	/* vax */
#else
int
ncx_putn_double_double(void **xpp, size_t nelems, const double *tp, void *fillp)
{
	char *xp = *xpp;
	int status = NC_NOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
	{
		int lstatus = ncx_put_double_double(xp, tp, fillp);
		if (status == NC_NOERR) /* report the first encountered error */
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
}
#endif
int
#line 3383
ncx_putn_double_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3383
{
#line 3383
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3383

#line 3383
 /* basic algorithm is:
#line 3383
  *   - ensure sane alignment of output data
#line 3383
  *   - copy (conversion happens automatically) input data
#line 3383
  *     to output
#line 3383
  *   - update tp to point at next unconverted input, and xpp to point
#line 3383
  *     at next location for converted output
#line 3383
  */
#line 3383
  long i, j, ni;
#line 3383
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3383
  double *xp;
#line 3383
  int nrange = 0;         /* number of range errors */
#line 3383
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3383
  long cxp = (long) *((char**)xpp);
#line 3383

#line 3383
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3383
  /* sjl: manually stripmine so we can limit amount of
#line 3383
   * vector work space reserved to LOOPCNT elements. Also
#line 3383
   * makes vectorisation easy */
#line 3383
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3383
    ni=Min(nelems-j,LOOPCNT);
#line 3383
    if (realign) {
#line 3383
      xp = tmp;
#line 3383
    } else {
#line 3383
      xp = (double *) *xpp;
#line 3383
    }
#line 3383
   /* copy the next block */
#line 3383
#pragma cdir loopcnt=LOOPCNT
#line 3383
#pragma cdir shortloop
#line 3383
    for (i=0; i<ni; i++) {
#line 3383
      /* the normal case: */
#line 3383
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3383
     /* test for range errors (not always needed but do it anyway) */
#line 3383
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3383
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3383
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
#line 3383
    }
#line 3383
   /* copy workspace back if necessary */
#line 3383
    if (realign) {
#line 3383
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3383
      xp = (double *) *xpp;
#line 3383
    }
#line 3383
   /* update xpp and tp */
#line 3383
    xp += ni;
#line 3383
    tp += ni;
#line 3383
    *xpp = (void*)xp;
#line 3383
  }
#line 3383
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3383

#line 3383
#else   /* not SX */
#line 3383

#line 3383
	char *xp = (char *) *xpp;
#line 3383
	int status = NC_NOERR;
#line 3383

#line 3383
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3383
	{
#line 3383
		int lstatus = ncx_put_double_schar(xp, tp, fillp);
#line 3383
		if (status == NC_NOERR) /* report the first encountered error */
#line 3383
			status = lstatus;
#line 3383
	}
#line 3383

#line 3383
	*xpp = (void *)xp;
#line 3383
	return status;
#line 3383
#endif
#line 3383
}
#line 3383

int
#line 3384
ncx_putn_double_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3384
{
#line 3384
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3384

#line 3384
 /* basic algorithm is:
#line 3384
  *   - ensure sane alignment of output data
#line 3384
  *   - copy (conversion happens automatically) input data
#line 3384
  *     to output
#line 3384
  *   - update tp to point at next unconverted input, and xpp to point
#line 3384
  *     at next location for converted output
#line 3384
  */
#line 3384
  long i, j, ni;
#line 3384
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3384
  double *xp;
#line 3384
  int nrange = 0;         /* number of range errors */
#line 3384
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3384
  long cxp = (long) *((char**)xpp);
#line 3384

#line 3384
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3384
  /* sjl: manually stripmine so we can limit amount of
#line 3384
   * vector work space reserved to LOOPCNT elements. Also
#line 3384
   * makes vectorisation easy */
#line 3384
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3384
    ni=Min(nelems-j,LOOPCNT);
#line 3384
    if (realign) {
#line 3384
      xp = tmp;
#line 3384
    } else {
#line 3384
      xp = (double *) *xpp;
#line 3384
    }
#line 3384
   /* copy the next block */
#line 3384
#pragma cdir loopcnt=LOOPCNT
#line 3384
#pragma cdir shortloop
#line 3384
    for (i=0; i<ni; i++) {
#line 3384
      /* the normal case: */
#line 3384
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3384
     /* test for range errors (not always needed but do it anyway) */
#line 3384
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3384
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3384
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
#line 3384
    }
#line 3384
   /* copy workspace back if necessary */
#line 3384
    if (realign) {
#line 3384
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3384
      xp = (double *) *xpp;
#line 3384
    }
#line 3384
   /* update xpp and tp */
#line 3384
    xp += ni;
#line 3384
    tp += ni;
#line 3384
    *xpp = (void*)xp;
#line 3384
  }
#line 3384
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3384

#line 3384
#else   /* not SX */
#line 3384

#line 3384
	char *xp = (char *) *xpp;
#line 3384
	int status = NC_NOERR;
#line 3384

#line 3384
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3384
	{
#line 3384
		int lstatus = ncx_put_double_short(xp, tp, fillp);
#line 3384
		if (status == NC_NOERR) /* report the first encountered error */
#line 3384
			status = lstatus;
#line 3384
	}
#line 3384

#line 3384
	*xpp = (void *)xp;
#line 3384
	return status;
#line 3384
#endif
#line 3384
}
#line 3384

int
#line 3385
ncx_putn_double_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3385
{
#line 3385
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3385

#line 3385
 /* basic algorithm is:
#line 3385
  *   - ensure sane alignment of output data
#line 3385
  *   - copy (conversion happens automatically) input data
#line 3385
  *     to output
#line 3385
  *   - update tp to point at next unconverted input, and xpp to point
#line 3385
  *     at next location for converted output
#line 3385
  */
#line 3385
  long i, j, ni;
#line 3385
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3385
  double *xp;
#line 3385
  int nrange = 0;         /* number of range errors */
#line 3385
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3385
  long cxp = (long) *((char**)xpp);
#line 3385

#line 3385
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3385
  /* sjl: manually stripmine so we can limit amount of
#line 3385
   * vector work space reserved to LOOPCNT elements. Also
#line 3385
   * makes vectorisation easy */
#line 3385
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3385
    ni=Min(nelems-j,LOOPCNT);
#line 3385
    if (realign) {
#line 3385
      xp = tmp;
#line 3385
    } else {
#line 3385
      xp = (double *) *xpp;
#line 3385
    }
#line 3385
   /* copy the next block */
#line 3385
#pragma cdir loopcnt=LOOPCNT
#line 3385
#pragma cdir shortloop
#line 3385
    for (i=0; i<ni; i++) {
#line 3385
      /* the normal case: */
#line 3385
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3385
     /* test for range errors (not always needed but do it anyway) */
#line 3385
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3385
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3385
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
#line 3385
    }
#line 3385
   /* copy workspace back if necessary */
#line 3385
    if (realign) {
#line 3385
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3385
      xp = (double *) *xpp;
#line 3385
    }
#line 3385
   /* update xpp and tp */
#line 3385
    xp += ni;
#line 3385
    tp += ni;
#line 3385
    *xpp = (void*)xp;
#line 3385
  }
#line 3385
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3385

#line 3385
#else   /* not SX */
#line 3385

#line 3385
	char *xp = (char *) *xpp;
#line 3385
	int status = NC_NOERR;
#line 3385

#line 3385
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3385
	{
#line 3385
		int lstatus = ncx_put_double_int(xp, tp, fillp);
#line 3385
		if (status == NC_NOERR) /* report the first encountered error */
#line 3385
			status = lstatus;
#line 3385
	}
#line 3385

#line 3385
	*xpp = (void *)xp;
#line 3385
	return status;
#line 3385
#endif
#line 3385
}
#line 3385

int
#line 3386
ncx_putn_double_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3386
{
#line 3386
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3386

#line 3386
 /* basic algorithm is:
#line 3386
  *   - ensure sane alignment of output data
#line 3386
  *   - copy (conversion happens automatically) input data
#line 3386
  *     to output
#line 3386
  *   - update tp to point at next unconverted input, and xpp to point
#line 3386
  *     at next location for converted output
#line 3386
  */
#line 3386
  long i, j, ni;
#line 3386
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3386
  double *xp;
#line 3386
  int nrange = 0;         /* number of range errors */
#line 3386
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3386
  long cxp = (long) *((char**)xpp);
#line 3386

#line 3386
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3386
  /* sjl: manually stripmine so we can limit amount of
#line 3386
   * vector work space reserved to LOOPCNT elements. Also
#line 3386
   * makes vectorisation easy */
#line 3386
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3386
    ni=Min(nelems-j,LOOPCNT);
#line 3386
    if (realign) {
#line 3386
      xp = tmp;
#line 3386
    } else {
#line 3386
      xp = (double *) *xpp;
#line 3386
    }
#line 3386
   /* copy the next block */
#line 3386
#pragma cdir loopcnt=LOOPCNT
#line 3386
#pragma cdir shortloop
#line 3386
    for (i=0; i<ni; i++) {
#line 3386
      /* the normal case: */
#line 3386
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3386
     /* test for range errors (not always needed but do it anyway) */
#line 3386
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3386
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3386
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
#line 3386
    }
#line 3386
   /* copy workspace back if necessary */
#line 3386
    if (realign) {
#line 3386
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3386
      xp = (double *) *xpp;
#line 3386
    }
#line 3386
   /* update xpp and tp */
#line 3386
    xp += ni;
#line 3386
    tp += ni;
#line 3386
    *xpp = (void*)xp;
#line 3386
  }
#line 3386
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3386

#line 3386
#else   /* not SX */
#line 3386

#line 3386
	char *xp = (char *) *xpp;
#line 3386
	int status = NC_NOERR;
#line 3386

#line 3386
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3386
	{
#line 3386
		int lstatus = ncx_put_double_long(xp, tp, fillp);
#line 3386
		if (status == NC_NOERR) /* report the first encountered error */
#line 3386
			status = lstatus;
#line 3386
	}
#line 3386

#line 3386
	*xpp = (void *)xp;
#line 3386
	return status;
#line 3386
#endif
#line 3386
}
#line 3386

int
#line 3387
ncx_putn_double_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3387
{
#line 3387
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3387

#line 3387
 /* basic algorithm is:
#line 3387
  *   - ensure sane alignment of output data
#line 3387
  *   - copy (conversion happens automatically) input data
#line 3387
  *     to output
#line 3387
  *   - update tp to point at next unconverted input, and xpp to point
#line 3387
  *     at next location for converted output
#line 3387
  */
#line 3387
  long i, j, ni;
#line 3387
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3387
  double *xp;
#line 3387
  int nrange = 0;         /* number of range errors */
#line 3387
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3387
  long cxp = (long) *((char**)xpp);
#line 3387

#line 3387
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3387
  /* sjl: manually stripmine so we can limit amount of
#line 3387
   * vector work space reserved to LOOPCNT elements. Also
#line 3387
   * makes vectorisation easy */
#line 3387
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3387
    ni=Min(nelems-j,LOOPCNT);
#line 3387
    if (realign) {
#line 3387
      xp = tmp;
#line 3387
    } else {
#line 3387
      xp = (double *) *xpp;
#line 3387
    }
#line 3387
   /* copy the next block */
#line 3387
#pragma cdir loopcnt=LOOPCNT
#line 3387
#pragma cdir shortloop
#line 3387
    for (i=0; i<ni; i++) {
#line 3387
      /* the normal case: */
#line 3387
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3387
     /* test for range errors (not always needed but do it anyway) */
#line 3387
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3387
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3387
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
#line 3387
    }
#line 3387
   /* copy workspace back if necessary */
#line 3387
    if (realign) {
#line 3387
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3387
      xp = (double *) *xpp;
#line 3387
    }
#line 3387
   /* update xpp and tp */
#line 3387
    xp += ni;
#line 3387
    tp += ni;
#line 3387
    *xpp = (void*)xp;
#line 3387
  }
#line 3387
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3387

#line 3387
#else   /* not SX */
#line 3387

#line 3387
	char *xp = (char *) *xpp;
#line 3387
	int status = NC_NOERR;
#line 3387

#line 3387
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3387
	{
#line 3387
		int lstatus = ncx_put_double_float(xp, tp, fillp);
#line 3387
		if (status == NC_NOERR) /* report the first encountered error */
#line 3387
			status = lstatus;
#line 3387
	}
#line 3387

#line 3387
	*xpp = (void *)xp;
#line 3387
	return status;
#line 3387
#endif
#line 3387
}
#line 3387

int
#line 3388
ncx_putn_double_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3388
{
#line 3388
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3388

#line 3388
 /* basic algorithm is:
#line 3388
  *   - ensure sane alignment of output data
#line 3388
  *   - copy (conversion happens automatically) input data
#line 3388
  *     to output
#line 3388
  *   - update tp to point at next unconverted input, and xpp to point
#line 3388
  *     at next location for converted output
#line 3388
  */
#line 3388
  long i, j, ni;
#line 3388
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3388
  double *xp;
#line 3388
  int nrange = 0;         /* number of range errors */
#line 3388
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3388
  long cxp = (long) *((char**)xpp);
#line 3388

#line 3388
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3388
  /* sjl: manually stripmine so we can limit amount of
#line 3388
   * vector work space reserved to LOOPCNT elements. Also
#line 3388
   * makes vectorisation easy */
#line 3388
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3388
    ni=Min(nelems-j,LOOPCNT);
#line 3388
    if (realign) {
#line 3388
      xp = tmp;
#line 3388
    } else {
#line 3388
      xp = (double *) *xpp;
#line 3388
    }
#line 3388
   /* copy the next block */
#line 3388
#pragma cdir loopcnt=LOOPCNT
#line 3388
#pragma cdir shortloop
#line 3388
    for (i=0; i<ni; i++) {
#line 3388
      /* the normal case: */
#line 3388
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3388
     /* test for range errors (not always needed but do it anyway) */
#line 3388
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3388
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3388
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
#line 3388
    }
#line 3388
   /* copy workspace back if necessary */
#line 3388
    if (realign) {
#line 3388
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3388
      xp = (double *) *xpp;
#line 3388
    }
#line 3388
   /* update xpp and tp */
#line 3388
    xp += ni;
#line 3388
    tp += ni;
#line 3388
    *xpp = (void*)xp;
#line 3388
  }
#line 3388
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3388

#line 3388
#else   /* not SX */
#line 3388

#line 3388
	char *xp = (char *) *xpp;
#line 3388
	int status = NC_NOERR;
#line 3388

#line 3388
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3388
	{
#line 3388
		int lstatus = ncx_put_double_longlong(xp, tp, fillp);
#line 3388
		if (status == NC_NOERR) /* report the first encountered error */
#line 3388
			status = lstatus;
#line 3388
	}
#line 3388

#line 3388
	*xpp = (void *)xp;
#line 3388
	return status;
#line 3388
#endif
#line 3388
}
#line 3388

int
#line 3389
ncx_putn_double_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3389
{
#line 3389
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3389

#line 3389
 /* basic algorithm is:
#line 3389
  *   - ensure sane alignment of output data
#line 3389
  *   - copy (conversion happens automatically) input data
#line 3389
  *     to output
#line 3389
  *   - update tp to point at next unconverted input, and xpp to point
#line 3389
  *     at next location for converted output
#line 3389
  */
#line 3389
  long i, j, ni;
#line 3389
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3389
  double *xp;
#line 3389
  int nrange = 0;         /* number of range errors */
#line 3389
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3389
  long cxp = (long) *((char**)xpp);
#line 3389

#line 3389
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3389
  /* sjl: manually stripmine so we can limit amount of
#line 3389
   * vector work space reserved to LOOPCNT elements. Also
#line 3389
   * makes vectorisation easy */
#line 3389
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3389
    ni=Min(nelems-j,LOOPCNT);
#line 3389
    if (realign) {
#line 3389
      xp = tmp;
#line 3389
    } else {
#line 3389
      xp = (double *) *xpp;
#line 3389
    }
#line 3389
   /* copy the next block */
#line 3389
#pragma cdir loopcnt=LOOPCNT
#line 3389
#pragma cdir shortloop
#line 3389
    for (i=0; i<ni; i++) {
#line 3389
      /* the normal case: */
#line 3389
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3389
     /* test for range errors (not always needed but do it anyway) */
#line 3389
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3389
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3389
      nrange += tp[i] > X_DOUBLE_MAX ;
#line 3389
    }
#line 3389
   /* copy workspace back if necessary */
#line 3389
    if (realign) {
#line 3389
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3389
      xp = (double *) *xpp;
#line 3389
    }
#line 3389
   /* update xpp and tp */
#line 3389
    xp += ni;
#line 3389
    tp += ni;
#line 3389
    *xpp = (void*)xp;
#line 3389
  }
#line 3389
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3389

#line 3389
#else   /* not SX */
#line 3389

#line 3389
	char *xp = (char *) *xpp;
#line 3389
	int status = NC_NOERR;
#line 3389

#line 3389
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3389
	{
#line 3389
		int lstatus = ncx_put_double_uchar(xp, tp, fillp);
#line 3389
		if (status == NC_NOERR) /* report the first encountered error */
#line 3389
			status = lstatus;
#line 3389
	}
#line 3389

#line 3389
	*xpp = (void *)xp;
#line 3389
	return status;
#line 3389
#endif
#line 3389
}
#line 3389

int
#line 3390
ncx_putn_double_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3390
{
#line 3390
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3390

#line 3390
 /* basic algorithm is:
#line 3390
  *   - ensure sane alignment of output data
#line 3390
  *   - copy (conversion happens automatically) input data
#line 3390
  *     to output
#line 3390
  *   - update tp to point at next unconverted input, and xpp to point
#line 3390
  *     at next location for converted output
#line 3390
  */
#line 3390
  long i, j, ni;
#line 3390
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3390
  double *xp;
#line 3390
  int nrange = 0;         /* number of range errors */
#line 3390
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3390
  long cxp = (long) *((char**)xpp);
#line 3390

#line 3390
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3390
  /* sjl: manually stripmine so we can limit amount of
#line 3390
   * vector work space reserved to LOOPCNT elements. Also
#line 3390
   * makes vectorisation easy */
#line 3390
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3390
    ni=Min(nelems-j,LOOPCNT);
#line 3390
    if (realign) {
#line 3390
      xp = tmp;
#line 3390
    } else {
#line 3390
      xp = (double *) *xpp;
#line 3390
    }
#line 3390
   /* copy the next block */
#line 3390
#pragma cdir loopcnt=LOOPCNT
#line 3390
#pragma cdir shortloop
#line 3390
    for (i=0; i<ni; i++) {
#line 3390
      /* the normal case: */
#line 3390
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3390
     /* test for range errors (not always needed but do it anyway) */
#line 3390
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3390
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3390
      nrange += tp[i] > X_DOUBLE_MAX ;
#line 3390
    }
#line 3390
   /* copy workspace back if necessary */
#line 3390
    if (realign) {
#line 3390
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3390
      xp = (double *) *xpp;
#line 3390
    }
#line 3390
   /* update xpp and tp */
#line 3390
    xp += ni;
#line 3390
    tp += ni;
#line 3390
    *xpp = (void*)xp;
#line 3390
  }
#line 3390
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3390

#line 3390
#else   /* not SX */
#line 3390

#line 3390
	char *xp = (char *) *xpp;
#line 3390
	int status = NC_NOERR;
#line 3390

#line 3390
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3390
	{
#line 3390
		int lstatus = ncx_put_double_ushort(xp, tp, fillp);
#line 3390
		if (status == NC_NOERR) /* report the first encountered error */
#line 3390
			status = lstatus;
#line 3390
	}
#line 3390

#line 3390
	*xpp = (void *)xp;
#line 3390
	return status;
#line 3390
#endif
#line 3390
}
#line 3390

int
#line 3391
ncx_putn_double_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3391
{
#line 3391
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3391

#line 3391
 /* basic algorithm is:
#line 3391
  *   - ensure sane alignment of output data
#line 3391
  *   - copy (conversion happens automatically) input data
#line 3391
  *     to output
#line 3391
  *   - update tp to point at next unconverted input, and xpp to point
#line 3391
  *     at next location for converted output
#line 3391
  */
#line 3391
  long i, j, ni;
#line 3391
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3391
  double *xp;
#line 3391
  int nrange = 0;         /* number of range errors */
#line 3391
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3391
  long cxp = (long) *((char**)xpp);
#line 3391

#line 3391
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3391
  /* sjl: manually stripmine so we can limit amount of
#line 3391
   * vector work space reserved to LOOPCNT elements. Also
#line 3391
   * makes vectorisation easy */
#line 3391
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3391
    ni=Min(nelems-j,LOOPCNT);
#line 3391
    if (realign) {
#line 3391
      xp = tmp;
#line 3391
    } else {
#line 3391
      xp = (double *) *xpp;
#line 3391
    }
#line 3391
   /* copy the next block */
#line 3391
#pragma cdir loopcnt=LOOPCNT
#line 3391
#pragma cdir shortloop
#line 3391
    for (i=0; i<ni; i++) {
#line 3391
      /* the normal case: */
#line 3391
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3391
     /* test for range errors (not always needed but do it anyway) */
#line 3391
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3391
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3391
      nrange += tp[i] > X_DOUBLE_MAX ;
#line 3391
    }
#line 3391
   /* copy workspace back if necessary */
#line 3391
    if (realign) {
#line 3391
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3391
      xp = (double *) *xpp;
#line 3391
    }
#line 3391
   /* update xpp and tp */
#line 3391
    xp += ni;
#line 3391
    tp += ni;
#line 3391
    *xpp = (void*)xp;
#line 3391
  }
#line 3391
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3391

#line 3391
#else   /* not SX */
#line 3391

#line 3391
	char *xp = (char *) *xpp;
#line 3391
	int status = NC_NOERR;
#line 3391

#line 3391
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3391
	{
#line 3391
		int lstatus = ncx_put_double_uint(xp, tp, fillp);
#line 3391
		if (status == NC_NOERR) /* report the first encountered error */
#line 3391
			status = lstatus;
#line 3391
	}
#line 3391

#line 3391
	*xpp = (void *)xp;
#line 3391
	return status;
#line 3391
#endif
#line 3391
}
#line 3391

int
#line 3392
ncx_putn_double_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3392
{
#line 3392
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3392

#line 3392
 /* basic algorithm is:
#line 3392
  *   - ensure sane alignment of output data
#line 3392
  *   - copy (conversion happens automatically) input data
#line 3392
  *     to output
#line 3392
  *   - update tp to point at next unconverted input, and xpp to point
#line 3392
  *     at next location for converted output
#line 3392
  */
#line 3392
  long i, j, ni;
#line 3392
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3392
  double *xp;
#line 3392
  int nrange = 0;         /* number of range errors */
#line 3392
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3392
  long cxp = (long) *((char**)xpp);
#line 3392

#line 3392
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3392
  /* sjl: manually stripmine so we can limit amount of
#line 3392
   * vector work space reserved to LOOPCNT elements. Also
#line 3392
   * makes vectorisation easy */
#line 3392
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3392
    ni=Min(nelems-j,LOOPCNT);
#line 3392
    if (realign) {
#line 3392
      xp = tmp;
#line 3392
    } else {
#line 3392
      xp = (double *) *xpp;
#line 3392
    }
#line 3392
   /* copy the next block */
#line 3392
#pragma cdir loopcnt=LOOPCNT
#line 3392
#pragma cdir shortloop
#line 3392
    for (i=0; i<ni; i++) {
#line 3392
      /* the normal case: */
#line 3392
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3392
     /* test for range errors (not always needed but do it anyway) */
#line 3392
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3392
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3392
      nrange += tp[i] > X_DOUBLE_MAX ;
#line 3392
    }
#line 3392
   /* copy workspace back if necessary */
#line 3392
    if (realign) {
#line 3392
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3392
      xp = (double *) *xpp;
#line 3392
    }
#line 3392
   /* update xpp and tp */
#line 3392
    xp += ni;
#line 3392
    tp += ni;
#line 3392
    *xpp = (void*)xp;
#line 3392
  }
#line 3392
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3392

#line 3392
#else   /* not SX */
#line 3392

#line 3392
	char *xp = (char *) *xpp;
#line 3392
	int status = NC_NOERR;
#line 3392

#line 3392
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3392
	{
#line 3392
		int lstatus = ncx_put_double_ulonglong(xp, tp, fillp);
#line 3392
		if (status == NC_NOERR) /* report the first encountered error */
#line 3392
			status = lstatus;
#line 3392
	}
#line 3392

#line 3392
	*xpp = (void *)xp;
#line 3392
	return status;
#line 3392
#endif
#line 3392
}
#line 3392



/* longlong ------------------------------------------------------------------*/

#if X_SIZEOF_INT64 == SIZEOF_LONGLONG
/* optimized version */
int
ncx_getn_longlong_longlong(const void **xpp, size_t nelems, long long *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_LONG_LONG);
# else
	swapn8b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_INT64);
	return NC_NOERR;
}
#else
int
#line 3411
ncx_getn_longlong_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3411
{
#line 3411
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3411

#line 3411
 /* basic algorithm is:
#line 3411
  *   - ensure sane alignment of input data
#line 3411
  *   - copy (conversion happens automatically) input data
#line 3411
  *     to output
#line 3411
  *   - update xpp to point at next unconverted input, and tp to point
#line 3411
  *     at next location for converted output
#line 3411
  */
#line 3411
  long i, j, ni;
#line 3411
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3411
  int64 *xp;
#line 3411
  int nrange = 0;         /* number of range errors */
#line 3411
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3411
  long cxp = (long) *((char**)xpp);
#line 3411

#line 3411
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3411
  /* sjl: manually stripmine so we can limit amount of
#line 3411
   * vector work space reserved to LOOPCNT elements. Also
#line 3411
   * makes vectorisation easy */
#line 3411
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3411
    ni=Min(nelems-j,LOOPCNT);
#line 3411
    if (realign) {
#line 3411
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3411
      xp = tmp;
#line 3411
    } else {
#line 3411
      xp = (int64 *) *xpp;
#line 3411
    }
#line 3411
   /* copy the next block */
#line 3411
#pragma cdir loopcnt=LOOPCNT
#line 3411
#pragma cdir shortloop
#line 3411
    for (i=0; i<ni; i++) {
#line 3411
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3411
     /* test for range errors (not always needed but do it anyway) */
#line 3411
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3411
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3411
      nrange += xp[i] > LONGLONG_MAX || xp[i] < LONGLONG_MIN;
#line 3411
    }
#line 3411
   /* update xpp and tp */
#line 3411
    if (realign) xp = (int64 *) *xpp;
#line 3411
    xp += ni;
#line 3411
    tp += ni;
#line 3411
    *xpp = (void*)xp;
#line 3411
  }
#line 3411
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3411

#line 3411
#else   /* not SX */
#line 3411
	const char *xp = (const char *) *xpp;
#line 3411
	int status = NC_NOERR;
#line 3411

#line 3411
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3411
	{
#line 3411
		const int lstatus = ncx_get_longlong_longlong(xp, tp);
#line 3411
		if (status == NC_NOERR) /* report the first encountered error */
#line 3411
			status = lstatus;
#line 3411
	}
#line 3411

#line 3411
	*xpp = (const void *)xp;
#line 3411
	return status;
#line 3411
#endif
#line 3411
}
#line 3411

#endif
int
#line 3413
ncx_getn_longlong_schar(const void **xpp, size_t nelems, schar *tp)
#line 3413
{
#line 3413
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3413

#line 3413
 /* basic algorithm is:
#line 3413
  *   - ensure sane alignment of input data
#line 3413
  *   - copy (conversion happens automatically) input data
#line 3413
  *     to output
#line 3413
  *   - update xpp to point at next unconverted input, and tp to point
#line 3413
  *     at next location for converted output
#line 3413
  */
#line 3413
  long i, j, ni;
#line 3413
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3413
  int64 *xp;
#line 3413
  int nrange = 0;         /* number of range errors */
#line 3413
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3413
  long cxp = (long) *((char**)xpp);
#line 3413

#line 3413
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3413
  /* sjl: manually stripmine so we can limit amount of
#line 3413
   * vector work space reserved to LOOPCNT elements. Also
#line 3413
   * makes vectorisation easy */
#line 3413
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3413
    ni=Min(nelems-j,LOOPCNT);
#line 3413
    if (realign) {
#line 3413
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3413
      xp = tmp;
#line 3413
    } else {
#line 3413
      xp = (int64 *) *xpp;
#line 3413
    }
#line 3413
   /* copy the next block */
#line 3413
#pragma cdir loopcnt=LOOPCNT
#line 3413
#pragma cdir shortloop
#line 3413
    for (i=0; i<ni; i++) {
#line 3413
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3413
     /* test for range errors (not always needed but do it anyway) */
#line 3413
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3413
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3413
      nrange += xp[i] > SCHAR_MAX || xp[i] < SCHAR_MIN;
#line 3413
    }
#line 3413
   /* update xpp and tp */
#line 3413
    if (realign) xp = (int64 *) *xpp;
#line 3413
    xp += ni;
#line 3413
    tp += ni;
#line 3413
    *xpp = (void*)xp;
#line 3413
  }
#line 3413
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3413

#line 3413
#else   /* not SX */
#line 3413
	const char *xp = (const char *) *xpp;
#line 3413
	int status = NC_NOERR;
#line 3413

#line 3413
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3413
	{
#line 3413
		const int lstatus = ncx_get_longlong_schar(xp, tp);
#line 3413
		if (status == NC_NOERR) /* report the first encountered error */
#line 3413
			status = lstatus;
#line 3413
	}
#line 3413

#line 3413
	*xpp = (const void *)xp;
#line 3413
	return status;
#line 3413
#endif
#line 3413
}
#line 3413

int
#line 3414
ncx_getn_longlong_short(const void **xpp, size_t nelems, short *tp)
#line 3414
{
#line 3414
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3414

#line 3414
 /* basic algorithm is:
#line 3414
  *   - ensure sane alignment of input data
#line 3414
  *   - copy (conversion happens automatically) input data
#line 3414
  *     to output
#line 3414
  *   - update xpp to point at next unconverted input, and tp to point
#line 3414
  *     at next location for converted output
#line 3414
  */
#line 3414
  long i, j, ni;
#line 3414
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3414
  int64 *xp;
#line 3414
  int nrange = 0;         /* number of range errors */
#line 3414
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3414
  long cxp = (long) *((char**)xpp);
#line 3414

#line 3414
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3414
  /* sjl: manually stripmine so we can limit amount of
#line 3414
   * vector work space reserved to LOOPCNT elements. Also
#line 3414
   * makes vectorisation easy */
#line 3414
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3414
    ni=Min(nelems-j,LOOPCNT);
#line 3414
    if (realign) {
#line 3414
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3414
      xp = tmp;
#line 3414
    } else {
#line 3414
      xp = (int64 *) *xpp;
#line 3414
    }
#line 3414
   /* copy the next block */
#line 3414
#pragma cdir loopcnt=LOOPCNT
#line 3414
#pragma cdir shortloop
#line 3414
    for (i=0; i<ni; i++) {
#line 3414
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3414
     /* test for range errors (not always needed but do it anyway) */
#line 3414
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3414
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3414
      nrange += xp[i] > SHORT_MAX || xp[i] < SHORT_MIN;
#line 3414
    }
#line 3414
   /* update xpp and tp */
#line 3414
    if (realign) xp = (int64 *) *xpp;
#line 3414
    xp += ni;
#line 3414
    tp += ni;
#line 3414
    *xpp = (void*)xp;
#line 3414
  }
#line 3414
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3414

#line 3414
#else   /* not SX */
#line 3414
	const char *xp = (const char *) *xpp;
#line 3414
	int status = NC_NOERR;
#line 3414

#line 3414
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3414
	{
#line 3414
		const int lstatus = ncx_get_longlong_short(xp, tp);
#line 3414
		if (status == NC_NOERR) /* report the first encountered error */
#line 3414
			status = lstatus;
#line 3414
	}
#line 3414

#line 3414
	*xpp = (const void *)xp;
#line 3414
	return status;
#line 3414
#endif
#line 3414
}
#line 3414

int
#line 3415
ncx_getn_longlong_int(const void **xpp, size_t nelems, int *tp)
#line 3415
{
#line 3415
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3415

#line 3415
 /* basic algorithm is:
#line 3415
  *   - ensure sane alignment of input data
#line 3415
  *   - copy (conversion happens automatically) input data
#line 3415
  *     to output
#line 3415
  *   - update xpp to point at next unconverted input, and tp to point
#line 3415
  *     at next location for converted output
#line 3415
  */
#line 3415
  long i, j, ni;
#line 3415
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3415
  int64 *xp;
#line 3415
  int nrange = 0;         /* number of range errors */
#line 3415
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3415
  long cxp = (long) *((char**)xpp);
#line 3415

#line 3415
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3415
  /* sjl: manually stripmine so we can limit amount of
#line 3415
   * vector work space reserved to LOOPCNT elements. Also
#line 3415
   * makes vectorisation easy */
#line 3415
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3415
    ni=Min(nelems-j,LOOPCNT);
#line 3415
    if (realign) {
#line 3415
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3415
      xp = tmp;
#line 3415
    } else {
#line 3415
      xp = (int64 *) *xpp;
#line 3415
    }
#line 3415
   /* copy the next block */
#line 3415
#pragma cdir loopcnt=LOOPCNT
#line 3415
#pragma cdir shortloop
#line 3415
    for (i=0; i<ni; i++) {
#line 3415
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3415
     /* test for range errors (not always needed but do it anyway) */
#line 3415
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3415
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3415
      nrange += xp[i] > INT_MAX || xp[i] < INT_MIN;
#line 3415
    }
#line 3415
   /* update xpp and tp */
#line 3415
    if (realign) xp = (int64 *) *xpp;
#line 3415
    xp += ni;
#line 3415
    tp += ni;
#line 3415
    *xpp = (void*)xp;
#line 3415
  }
#line 3415
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3415

#line 3415
#else   /* not SX */
#line 3415
	const char *xp = (const char *) *xpp;
#line 3415
	int status = NC_NOERR;
#line 3415

#line 3415
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3415
	{
#line 3415
		const int lstatus = ncx_get_longlong_int(xp, tp);
#line 3415
		if (status == NC_NOERR) /* report the first encountered error */
#line 3415
			status = lstatus;
#line 3415
	}
#line 3415

#line 3415
	*xpp = (const void *)xp;
#line 3415
	return status;
#line 3415
#endif
#line 3415
}
#line 3415

int
#line 3416
ncx_getn_longlong_long(const void **xpp, size_t nelems, long *tp)
#line 3416
{
#line 3416
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3416

#line 3416
 /* basic algorithm is:
#line 3416
  *   - ensure sane alignment of input data
#line 3416
  *   - copy (conversion happens automatically) input data
#line 3416
  *     to output
#line 3416
  *   - update xpp to point at next unconverted input, and tp to point
#line 3416
  *     at next location for converted output
#line 3416
  */
#line 3416
  long i, j, ni;
#line 3416
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3416
  int64 *xp;
#line 3416
  int nrange = 0;         /* number of range errors */
#line 3416
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3416
  long cxp = (long) *((char**)xpp);
#line 3416

#line 3416
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3416
  /* sjl: manually stripmine so we can limit amount of
#line 3416
   * vector work space reserved to LOOPCNT elements. Also
#line 3416
   * makes vectorisation easy */
#line 3416
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3416
    ni=Min(nelems-j,LOOPCNT);
#line 3416
    if (realign) {
#line 3416
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3416
      xp = tmp;
#line 3416
    } else {
#line 3416
      xp = (int64 *) *xpp;
#line 3416
    }
#line 3416
   /* copy the next block */
#line 3416
#pragma cdir loopcnt=LOOPCNT
#line 3416
#pragma cdir shortloop
#line 3416
    for (i=0; i<ni; i++) {
#line 3416
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3416
     /* test for range errors (not always needed but do it anyway) */
#line 3416
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3416
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3416
      nrange += xp[i] > LONG_MAX || xp[i] < LONG_MIN;
#line 3416
    }
#line 3416
   /* update xpp and tp */
#line 3416
    if (realign) xp = (int64 *) *xpp;
#line 3416
    xp += ni;
#line 3416
    tp += ni;
#line 3416
    *xpp = (void*)xp;
#line 3416
  }
#line 3416
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3416

#line 3416
#else   /* not SX */
#line 3416
	const char *xp = (const char *) *xpp;
#line 3416
	int status = NC_NOERR;
#line 3416

#line 3416
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3416
	{
#line 3416
		const int lstatus = ncx_get_longlong_long(xp, tp);
#line 3416
		if (status == NC_NOERR) /* report the first encountered error */
#line 3416
			status = lstatus;
#line 3416
	}
#line 3416

#line 3416
	*xpp = (const void *)xp;
#line 3416
	return status;
#line 3416
#endif
#line 3416
}
#line 3416

int
#line 3417
ncx_getn_longlong_float(const void **xpp, size_t nelems, float *tp)
#line 3417
{
#line 3417
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3417

#line 3417
 /* basic algorithm is:
#line 3417
  *   - ensure sane alignment of input data
#line 3417
  *   - copy (conversion happens automatically) input data
#line 3417
  *     to output
#line 3417
  *   - update xpp to point at next unconverted input, and tp to point
#line 3417
  *     at next location for converted output
#line 3417
  */
#line 3417
  long i, j, ni;
#line 3417
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3417
  int64 *xp;
#line 3417
  int nrange = 0;         /* number of range errors */
#line 3417
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3417
  long cxp = (long) *((char**)xpp);
#line 3417

#line 3417
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3417
  /* sjl: manually stripmine so we can limit amount of
#line 3417
   * vector work space reserved to LOOPCNT elements. Also
#line 3417
   * makes vectorisation easy */
#line 3417
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3417
    ni=Min(nelems-j,LOOPCNT);
#line 3417
    if (realign) {
#line 3417
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3417
      xp = tmp;
#line 3417
    } else {
#line 3417
      xp = (int64 *) *xpp;
#line 3417
    }
#line 3417
   /* copy the next block */
#line 3417
#pragma cdir loopcnt=LOOPCNT
#line 3417
#pragma cdir shortloop
#line 3417
    for (i=0; i<ni; i++) {
#line 3417
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 3417
     /* test for range errors (not always needed but do it anyway) */
#line 3417
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3417
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3417
      nrange += xp[i] > FLOAT_MAX || xp[i] < FLOAT_MIN;
#line 3417
    }
#line 3417
   /* update xpp and tp */
#line 3417
    if (realign) xp = (int64 *) *xpp;
#line 3417
    xp += ni;
#line 3417
    tp += ni;
#line 3417
    *xpp = (void*)xp;
#line 3417
  }
#line 3417
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3417

#line 3417
#else   /* not SX */
#line 3417
	const char *xp = (const char *) *xpp;
#line 3417
	int status = NC_NOERR;
#line 3417

#line 3417
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3417
	{
#line 3417
		const int lstatus = ncx_get_longlong_float(xp, tp);
#line 3417
		if (status == NC_NOERR) /* report the first encountered error */
#line 3417
			status = lstatus;
#line 3417
	}
#line 3417

#line 3417
	*xpp = (const void *)xp;
#line 3417
	return status;
#line 3417
#endif
#line 3417
}
#line 3417

int
#line 3418
ncx_getn_longlong_double(const void **xpp, size_t nelems, double *tp)
#line 3418
{
#line 3418
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3418

#line 3418
 /* basic algorithm is:
#line 3418
  *   - ensure sane alignment of input data
#line 3418
  *   - copy (conversion happens automatically) input data
#line 3418
  *     to output
#line 3418
  *   - update xpp to point at next unconverted input, and tp to point
#line 3418
  *     at next location for converted output
#line 3418
  */
#line 3418
  long i, j, ni;
#line 3418
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3418
  int64 *xp;
#line 3418
  int nrange = 0;         /* number of range errors */
#line 3418
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3418
  long cxp = (long) *((char**)xpp);
#line 3418

#line 3418
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3418
  /* sjl: manually stripmine so we can limit amount of
#line 3418
   * vector work space reserved to LOOPCNT elements. Also
#line 3418
   * makes vectorisation easy */
#line 3418
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3418
    ni=Min(nelems-j,LOOPCNT);
#line 3418
    if (realign) {
#line 3418
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3418
      xp = tmp;
#line 3418
    } else {
#line 3418
      xp = (int64 *) *xpp;
#line 3418
    }
#line 3418
   /* copy the next block */
#line 3418
#pragma cdir loopcnt=LOOPCNT
#line 3418
#pragma cdir shortloop
#line 3418
    for (i=0; i<ni; i++) {
#line 3418
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 3418
     /* test for range errors (not always needed but do it anyway) */
#line 3418
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3418
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3418
      nrange += xp[i] > DOUBLE_MAX || xp[i] < DOUBLE_MIN;
#line 3418
    }
#line 3418
   /* update xpp and tp */
#line 3418
    if (realign) xp = (int64 *) *xpp;
#line 3418
    xp += ni;
#line 3418
    tp += ni;
#line 3418
    *xpp = (void*)xp;
#line 3418
  }
#line 3418
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3418

#line 3418
#else   /* not SX */
#line 3418
	const char *xp = (const char *) *xpp;
#line 3418
	int status = NC_NOERR;
#line 3418

#line 3418
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3418
	{
#line 3418
		const int lstatus = ncx_get_longlong_double(xp, tp);
#line 3418
		if (status == NC_NOERR) /* report the first encountered error */
#line 3418
			status = lstatus;
#line 3418
	}
#line 3418

#line 3418
	*xpp = (const void *)xp;
#line 3418
	return status;
#line 3418
#endif
#line 3418
}
#line 3418

int
#line 3419
ncx_getn_longlong_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3419
{
#line 3419
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3419

#line 3419
 /* basic algorithm is:
#line 3419
  *   - ensure sane alignment of input data
#line 3419
  *   - copy (conversion happens automatically) input data
#line 3419
  *     to output
#line 3419
  *   - update xpp to point at next unconverted input, and tp to point
#line 3419
  *     at next location for converted output
#line 3419
  */
#line 3419
  long i, j, ni;
#line 3419
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3419
  int64 *xp;
#line 3419
  int nrange = 0;         /* number of range errors */
#line 3419
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3419
  long cxp = (long) *((char**)xpp);
#line 3419

#line 3419
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3419
  /* sjl: manually stripmine so we can limit amount of
#line 3419
   * vector work space reserved to LOOPCNT elements. Also
#line 3419
   * makes vectorisation easy */
#line 3419
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3419
    ni=Min(nelems-j,LOOPCNT);
#line 3419
    if (realign) {
#line 3419
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3419
      xp = tmp;
#line 3419
    } else {
#line 3419
      xp = (int64 *) *xpp;
#line 3419
    }
#line 3419
   /* copy the next block */
#line 3419
#pragma cdir loopcnt=LOOPCNT
#line 3419
#pragma cdir shortloop
#line 3419
    for (i=0; i<ni; i++) {
#line 3419
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3419
     /* test for range errors (not always needed but do it anyway) */
#line 3419
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3419
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3419
      nrange += xp[i] > UCHAR_MAX || xp[i] < 0;
#line 3419
    }
#line 3419
   /* update xpp and tp */
#line 3419
    if (realign) xp = (int64 *) *xpp;
#line 3419
    xp += ni;
#line 3419
    tp += ni;
#line 3419
    *xpp = (void*)xp;
#line 3419
  }
#line 3419
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3419

#line 3419
#else   /* not SX */
#line 3419
	const char *xp = (const char *) *xpp;
#line 3419
	int status = NC_NOERR;
#line 3419

#line 3419
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3419
	{
#line 3419
		const int lstatus = ncx_get_longlong_uchar(xp, tp);
#line 3419
		if (status == NC_NOERR) /* report the first encountered error */
#line 3419
			status = lstatus;
#line 3419
	}
#line 3419

#line 3419
	*xpp = (const void *)xp;
#line 3419
	return status;
#line 3419
#endif
#line 3419
}
#line 3419

int
#line 3420
ncx_getn_longlong_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3420
{
#line 3420
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3420

#line 3420
 /* basic algorithm is:
#line 3420
  *   - ensure sane alignment of input data
#line 3420
  *   - copy (conversion happens automatically) input data
#line 3420
  *     to output
#line 3420
  *   - update xpp to point at next unconverted input, and tp to point
#line 3420
  *     at next location for converted output
#line 3420
  */
#line 3420
  long i, j, ni;
#line 3420
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3420
  int64 *xp;
#line 3420
  int nrange = 0;         /* number of range errors */
#line 3420
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3420
  long cxp = (long) *((char**)xpp);
#line 3420

#line 3420
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3420
  /* sjl: manually stripmine so we can limit amount of
#line 3420
   * vector work space reserved to LOOPCNT elements. Also
#line 3420
   * makes vectorisation easy */
#line 3420
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3420
    ni=Min(nelems-j,LOOPCNT);
#line 3420
    if (realign) {
#line 3420
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3420
      xp = tmp;
#line 3420
    } else {
#line 3420
      xp = (int64 *) *xpp;
#line 3420
    }
#line 3420
   /* copy the next block */
#line 3420
#pragma cdir loopcnt=LOOPCNT
#line 3420
#pragma cdir shortloop
#line 3420
    for (i=0; i<ni; i++) {
#line 3420
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3420
     /* test for range errors (not always needed but do it anyway) */
#line 3420
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3420
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3420
      nrange += xp[i] > USHORT_MAX || xp[i] < 0;
#line 3420
    }
#line 3420
   /* update xpp and tp */
#line 3420
    if (realign) xp = (int64 *) *xpp;
#line 3420
    xp += ni;
#line 3420
    tp += ni;
#line 3420
    *xpp = (void*)xp;
#line 3420
  }
#line 3420
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3420

#line 3420
#else   /* not SX */
#line 3420
	const char *xp = (const char *) *xpp;
#line 3420
	int status = NC_NOERR;
#line 3420

#line 3420
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3420
	{
#line 3420
		const int lstatus = ncx_get_longlong_ushort(xp, tp);
#line 3420
		if (status == NC_NOERR) /* report the first encountered error */
#line 3420
			status = lstatus;
#line 3420
	}
#line 3420

#line 3420
	*xpp = (const void *)xp;
#line 3420
	return status;
#line 3420
#endif
#line 3420
}
#line 3420

int
#line 3421
ncx_getn_longlong_uint(const void **xpp, size_t nelems, uint *tp)
#line 3421
{
#line 3421
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3421

#line 3421
 /* basic algorithm is:
#line 3421
  *   - ensure sane alignment of input data
#line 3421
  *   - copy (conversion happens automatically) input data
#line 3421
  *     to output
#line 3421
  *   - update xpp to point at next unconverted input, and tp to point
#line 3421
  *     at next location for converted output
#line 3421
  */
#line 3421
  long i, j, ni;
#line 3421
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3421
  int64 *xp;
#line 3421
  int nrange = 0;         /* number of range errors */
#line 3421
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3421
  long cxp = (long) *((char**)xpp);
#line 3421

#line 3421
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3421
  /* sjl: manually stripmine so we can limit amount of
#line 3421
   * vector work space reserved to LOOPCNT elements. Also
#line 3421
   * makes vectorisation easy */
#line 3421
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3421
    ni=Min(nelems-j,LOOPCNT);
#line 3421
    if (realign) {
#line 3421
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3421
      xp = tmp;
#line 3421
    } else {
#line 3421
      xp = (int64 *) *xpp;
#line 3421
    }
#line 3421
   /* copy the next block */
#line 3421
#pragma cdir loopcnt=LOOPCNT
#line 3421
#pragma cdir shortloop
#line 3421
    for (i=0; i<ni; i++) {
#line 3421
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3421
     /* test for range errors (not always needed but do it anyway) */
#line 3421
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3421
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3421
      nrange += xp[i] > UINT_MAX || xp[i] < 0;
#line 3421
    }
#line 3421
   /* update xpp and tp */
#line 3421
    if (realign) xp = (int64 *) *xpp;
#line 3421
    xp += ni;
#line 3421
    tp += ni;
#line 3421
    *xpp = (void*)xp;
#line 3421
  }
#line 3421
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3421

#line 3421
#else   /* not SX */
#line 3421
	const char *xp = (const char *) *xpp;
#line 3421
	int status = NC_NOERR;
#line 3421

#line 3421
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3421
	{
#line 3421
		const int lstatus = ncx_get_longlong_uint(xp, tp);
#line 3421
		if (status == NC_NOERR) /* report the first encountered error */
#line 3421
			status = lstatus;
#line 3421
	}
#line 3421

#line 3421
	*xpp = (const void *)xp;
#line 3421
	return status;
#line 3421
#endif
#line 3421
}
#line 3421

int
#line 3422
ncx_getn_longlong_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3422
{
#line 3422
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3422

#line 3422
 /* basic algorithm is:
#line 3422
  *   - ensure sane alignment of input data
#line 3422
  *   - copy (conversion happens automatically) input data
#line 3422
  *     to output
#line 3422
  *   - update xpp to point at next unconverted input, and tp to point
#line 3422
  *     at next location for converted output
#line 3422
  */
#line 3422
  long i, j, ni;
#line 3422
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3422
  int64 *xp;
#line 3422
  int nrange = 0;         /* number of range errors */
#line 3422
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3422
  long cxp = (long) *((char**)xpp);
#line 3422

#line 3422
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3422
  /* sjl: manually stripmine so we can limit amount of
#line 3422
   * vector work space reserved to LOOPCNT elements. Also
#line 3422
   * makes vectorisation easy */
#line 3422
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3422
    ni=Min(nelems-j,LOOPCNT);
#line 3422
    if (realign) {
#line 3422
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3422
      xp = tmp;
#line 3422
    } else {
#line 3422
      xp = (int64 *) *xpp;
#line 3422
    }
#line 3422
   /* copy the next block */
#line 3422
#pragma cdir loopcnt=LOOPCNT
#line 3422
#pragma cdir shortloop
#line 3422
    for (i=0; i<ni; i++) {
#line 3422
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3422
     /* test for range errors (not always needed but do it anyway) */
#line 3422
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3422
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3422
      nrange += xp[i] > ULONGLONG_MAX || xp[i] < 0;
#line 3422
    }
#line 3422
   /* update xpp and tp */
#line 3422
    if (realign) xp = (int64 *) *xpp;
#line 3422
    xp += ni;
#line 3422
    tp += ni;
#line 3422
    *xpp = (void*)xp;
#line 3422
  }
#line 3422
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3422

#line 3422
#else   /* not SX */
#line 3422
	const char *xp = (const char *) *xpp;
#line 3422
	int status = NC_NOERR;
#line 3422

#line 3422
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3422
	{
#line 3422
		const int lstatus = ncx_get_longlong_ulonglong(xp, tp);
#line 3422
		if (status == NC_NOERR) /* report the first encountered error */
#line 3422
			status = lstatus;
#line 3422
	}
#line 3422

#line 3422
	*xpp = (const void *)xp;
#line 3422
	return status;
#line 3422
#endif
#line 3422
}
#line 3422


#if X_SIZEOF_INT64 == SIZEOF_LONGLONG
/* optimized version */
int
ncx_putn_longlong_longlong(void **xpp, size_t nelems, const long long *tp, void *fillp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_INT64);
# else
	swapn8b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_INT64);
	return NC_NOERR;
}
#else
int
#line 3438
ncx_putn_longlong_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3438
{
#line 3438
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3438

#line 3438
 /* basic algorithm is:
#line 3438
  *   - ensure sane alignment of output data
#line 3438
  *   - copy (conversion happens automatically) input data
#line 3438
  *     to output
#line 3438
  *   - update tp to point at next unconverted input, and xpp to point
#line 3438
  *     at next location for converted output
#line 3438
  */
#line 3438
  long i, j, ni;
#line 3438
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3438
  int64 *xp;
#line 3438
  int nrange = 0;         /* number of range errors */
#line 3438
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3438
  long cxp = (long) *((char**)xpp);
#line 3438

#line 3438
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3438
  /* sjl: manually stripmine so we can limit amount of
#line 3438
   * vector work space reserved to LOOPCNT elements. Also
#line 3438
   * makes vectorisation easy */
#line 3438
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3438
    ni=Min(nelems-j,LOOPCNT);
#line 3438
    if (realign) {
#line 3438
      xp = tmp;
#line 3438
    } else {
#line 3438
      xp = (int64 *) *xpp;
#line 3438
    }
#line 3438
   /* copy the next block */
#line 3438
#pragma cdir loopcnt=LOOPCNT
#line 3438
#pragma cdir shortloop
#line 3438
    for (i=0; i<ni; i++) {
#line 3438
      /* the normal case: */
#line 3438
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3438
     /* test for range errors (not always needed but do it anyway) */
#line 3438
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3438
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3438
      nrange += tp[i] > X_INT64_MAX || tp[i] < X_INT64_MIN;
#line 3438
    }
#line 3438
   /* copy workspace back if necessary */
#line 3438
    if (realign) {
#line 3438
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3438
      xp = (int64 *) *xpp;
#line 3438
    }
#line 3438
   /* update xpp and tp */
#line 3438
    xp += ni;
#line 3438
    tp += ni;
#line 3438
    *xpp = (void*)xp;
#line 3438
  }
#line 3438
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3438

#line 3438
#else   /* not SX */
#line 3438

#line 3438
	char *xp = (char *) *xpp;
#line 3438
	int status = NC_NOERR;
#line 3438

#line 3438
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3438
	{
#line 3438
		int lstatus = ncx_put_longlong_longlong(xp, tp, fillp);
#line 3438
		if (status == NC_NOERR) /* report the first encountered error */
#line 3438
			status = lstatus;
#line 3438
	}
#line 3438

#line 3438
	*xpp = (void *)xp;
#line 3438
	return status;
#line 3438
#endif
#line 3438
}
#line 3438

#endif
int
#line 3440
ncx_putn_longlong_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3440
{
#line 3440
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3440

#line 3440
 /* basic algorithm is:
#line 3440
  *   - ensure sane alignment of output data
#line 3440
  *   - copy (conversion happens automatically) input data
#line 3440
  *     to output
#line 3440
  *   - update tp to point at next unconverted input, and xpp to point
#line 3440
  *     at next location for converted output
#line 3440
  */
#line 3440
  long i, j, ni;
#line 3440
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3440
  int64 *xp;
#line 3440
  int nrange = 0;         /* number of range errors */
#line 3440
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3440
  long cxp = (long) *((char**)xpp);
#line 3440

#line 3440
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3440
  /* sjl: manually stripmine so we can limit amount of
#line 3440
   * vector work space reserved to LOOPCNT elements. Also
#line 3440
   * makes vectorisation easy */
#line 3440
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3440
    ni=Min(nelems-j,LOOPCNT);
#line 3440
    if (realign) {
#line 3440
      xp = tmp;
#line 3440
    } else {
#line 3440
      xp = (int64 *) *xpp;
#line 3440
    }
#line 3440
   /* copy the next block */
#line 3440
#pragma cdir loopcnt=LOOPCNT
#line 3440
#pragma cdir shortloop
#line 3440
    for (i=0; i<ni; i++) {
#line 3440
      /* the normal case: */
#line 3440
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3440
     /* test for range errors (not always needed but do it anyway) */
#line 3440
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3440
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3440
      nrange += tp[i] > X_INT64_MAX || tp[i] < X_INT64_MIN;
#line 3440
    }
#line 3440
   /* copy workspace back if necessary */
#line 3440
    if (realign) {
#line 3440
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3440
      xp = (int64 *) *xpp;
#line 3440
    }
#line 3440
   /* update xpp and tp */
#line 3440
    xp += ni;
#line 3440
    tp += ni;
#line 3440
    *xpp = (void*)xp;
#line 3440
  }
#line 3440
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3440

#line 3440
#else   /* not SX */
#line 3440

#line 3440
	char *xp = (char *) *xpp;
#line 3440
	int status = NC_NOERR;
#line 3440

#line 3440
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3440
	{
#line 3440
		int lstatus = ncx_put_longlong_schar(xp, tp, fillp);
#line 3440
		if (status == NC_NOERR) /* report the first encountered error */
#line 3440
			status = lstatus;
#line 3440
	}
#line 3440

#line 3440
	*xpp = (void *)xp;
#line 3440
	return status;
#line 3440
#endif
#line 3440
}
#line 3440

int
#line 3441
ncx_putn_longlong_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3441
{
#line 3441
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3441

#line 3441
 /* basic algorithm is:
#line 3441
  *   - ensure sane alignment of output data
#line 3441
  *   - copy (conversion happens automatically) input data
#line 3441
  *     to output
#line 3441
  *   - update tp to point at next unconverted input, and xpp to point
#line 3441
  *     at next location for converted output
#line 3441
  */
#line 3441
  long i, j, ni;
#line 3441
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3441
  int64 *xp;
#line 3441
  int nrange = 0;         /* number of range errors */
#line 3441
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3441
  long cxp = (long) *((char**)xpp);
#line 3441

#line 3441
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3441
  /* sjl: manually stripmine so we can limit amount of
#line 3441
   * vector work space reserved to LOOPCNT elements. Also
#line 3441
   * makes vectorisation easy */
#line 3441
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3441
    ni=Min(nelems-j,LOOPCNT);
#line 3441
    if (realign) {
#line 3441
      xp = tmp;
#line 3441
    } else {
#line 3441
      xp = (int64 *) *xpp;
#line 3441
    }
#line 3441
   /* copy the next block */
#line 3441
#pragma cdir loopcnt=LOOPCNT
#line 3441
#pragma cdir shortloop
#line 3441
    for (i=0; i<ni; i++) {
#line 3441
      /* the normal case: */
#line 3441
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3441
     /* test for range errors (not always needed but do it anyway) */
#line 3441
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3441
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3441
      nrange += tp[i] > X_INT64_MAX || tp[i] < X_INT64_MIN;
#line 3441
    }
#line 3441
   /* copy workspace back if necessary */
#line 3441
    if (realign) {
#line 3441
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3441
      xp = (int64 *) *xpp;
#line 3441
    }
#line 3441
   /* update xpp and tp */
#line 3441
    xp += ni;
#line 3441
    tp += ni;
#line 3441
    *xpp = (void*)xp;
#line 3441
  }
#line 3441
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3441

#line 3441
#else   /* not SX */
#line 3441

#line 3441
	char *xp = (char *) *xpp;
#line 3441
	int status = NC_NOERR;
#line 3441

#line 3441
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3441
	{
#line 3441
		int lstatus = ncx_put_longlong_short(xp, tp, fillp);
#line 3441
		if (status == NC_NOERR) /* report the first encountered error */
#line 3441
			status = lstatus;
#line 3441
	}
#line 3441

#line 3441
	*xpp = (void *)xp;
#line 3441
	return status;
#line 3441
#endif
#line 3441
}
#line 3441

int
#line 3442
ncx_putn_longlong_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3442
{
#line 3442
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3442

#line 3442
 /* basic algorithm is:
#line 3442
  *   - ensure sane alignment of output data
#line 3442
  *   - copy (conversion happens automatically) input data
#line 3442
  *     to output
#line 3442
  *   - update tp to point at next unconverted input, and xpp to point
#line 3442
  *     at next location for converted output
#line 3442
  */
#line 3442
  long i, j, ni;
#line 3442
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3442
  int64 *xp;
#line 3442
  int nrange = 0;         /* number of range errors */
#line 3442
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3442
  long cxp = (long) *((char**)xpp);
#line 3442

#line 3442
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3442
  /* sjl: manually stripmine so we can limit amount of
#line 3442
   * vector work space reserved to LOOPCNT elements. Also
#line 3442
   * makes vectorisation easy */
#line 3442
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3442
    ni=Min(nelems-j,LOOPCNT);
#line 3442
    if (realign) {
#line 3442
      xp = tmp;
#line 3442
    } else {
#line 3442
      xp = (int64 *) *xpp;
#line 3442
    }
#line 3442
   /* copy the next block */
#line 3442
#pragma cdir loopcnt=LOOPCNT
#line 3442
#pragma cdir shortloop
#line 3442
    for (i=0; i<ni; i++) {
#line 3442
      /* the normal case: */
#line 3442
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3442
     /* test for range errors (not always needed but do it anyway) */
#line 3442
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3442
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3442
      nrange += tp[i] > X_INT64_MAX || tp[i] < X_INT64_MIN;
#line 3442
    }
#line 3442
   /* copy workspace back if necessary */
#line 3442
    if (realign) {
#line 3442
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3442
      xp = (int64 *) *xpp;
#line 3442
    }
#line 3442
   /* update xpp and tp */
#line 3442
    xp += ni;
#line 3442
    tp += ni;
#line 3442
    *xpp = (void*)xp;
#line 3442
  }
#line 3442
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3442

#line 3442
#else   /* not SX */
#line 3442

#line 3442
	char *xp = (char *) *xpp;
#line 3442
	int status = NC_NOERR;
#line 3442

#line 3442
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3442
	{
#line 3442
		int lstatus = ncx_put_longlong_int(xp, tp, fillp);
#line 3442
		if (status == NC_NOERR) /* report the first encountered error */
#line 3442
			status = lstatus;
#line 3442
	}
#line 3442

#line 3442
	*xpp = (void *)xp;
#line 3442
	return status;
#line 3442
#endif
#line 3442
}
#line 3442

int
#line 3443
ncx_putn_longlong_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3443
{
#line 3443
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3443

#line 3443
 /* basic algorithm is:
#line 3443
  *   - ensure sane alignment of output data
#line 3443
  *   - copy (conversion happens automatically) input data
#line 3443
  *     to output
#line 3443
  *   - update tp to point at next unconverted input, and xpp to point
#line 3443
  *     at next location for converted output
#line 3443
  */
#line 3443
  long i, j, ni;
#line 3443
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3443
  int64 *xp;
#line 3443
  int nrange = 0;         /* number of range errors */
#line 3443
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3443
  long cxp = (long) *((char**)xpp);
#line 3443

#line 3443
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3443
  /* sjl: manually stripmine so we can limit amount of
#line 3443
   * vector work space reserved to LOOPCNT elements. Also
#line 3443
   * makes vectorisation easy */
#line 3443
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3443
    ni=Min(nelems-j,LOOPCNT);
#line 3443
    if (realign) {
#line 3443
      xp = tmp;
#line 3443
    } else {
#line 3443
      xp = (int64 *) *xpp;
#line 3443
    }
#line 3443
   /* copy the next block */
#line 3443
#pragma cdir loopcnt=LOOPCNT
#line 3443
#pragma cdir shortloop
#line 3443
    for (i=0; i<ni; i++) {
#line 3443
      /* the normal case: */
#line 3443
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3443
     /* test for range errors (not always needed but do it anyway) */
#line 3443
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3443
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3443
      nrange += tp[i] > X_INT64_MAX || tp[i] < X_INT64_MIN;
#line 3443
    }
#line 3443
   /* copy workspace back if necessary */
#line 3443
    if (realign) {
#line 3443
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3443
      xp = (int64 *) *xpp;
#line 3443
    }
#line 3443
   /* update xpp and tp */
#line 3443
    xp += ni;
#line 3443
    tp += ni;
#line 3443
    *xpp = (void*)xp;
#line 3443
  }
#line 3443
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3443

#line 3443
#else   /* not SX */
#line 3443

#line 3443
	char *xp = (char *) *xpp;
#line 3443
	int status = NC_NOERR;
#line 3443

#line 3443
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3443
	{
#line 3443
		int lstatus = ncx_put_longlong_long(xp, tp, fillp);
#line 3443
		if (status == NC_NOERR) /* report the first encountered error */
#line 3443
			status = lstatus;
#line 3443
	}
#line 3443

#line 3443
	*xpp = (void *)xp;
#line 3443
	return status;
#line 3443
#endif
#line 3443
}
#line 3443

int
#line 3444
ncx_putn_longlong_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3444
{
#line 3444
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3444

#line 3444
 /* basic algorithm is:
#line 3444
  *   - ensure sane alignment of output data
#line 3444
  *   - copy (conversion happens automatically) input data
#line 3444
  *     to output
#line 3444
  *   - update tp to point at next unconverted input, and xpp to point
#line 3444
  *     at next location for converted output
#line 3444
  */
#line 3444
  long i, j, ni;
#line 3444
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3444
  int64 *xp;
#line 3444
  int nrange = 0;         /* number of range errors */
#line 3444
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3444
  long cxp = (long) *((char**)xpp);
#line 3444

#line 3444
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3444
  /* sjl: manually stripmine so we can limit amount of
#line 3444
   * vector work space reserved to LOOPCNT elements. Also
#line 3444
   * makes vectorisation easy */
#line 3444
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3444
    ni=Min(nelems-j,LOOPCNT);
#line 3444
    if (realign) {
#line 3444
      xp = tmp;
#line 3444
    } else {
#line 3444
      xp = (int64 *) *xpp;
#line 3444
    }
#line 3444
   /* copy the next block */
#line 3444
#pragma cdir loopcnt=LOOPCNT
#line 3444
#pragma cdir shortloop
#line 3444
    for (i=0; i<ni; i++) {
#line 3444
      /* the normal case: */
#line 3444
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3444
     /* test for range errors (not always needed but do it anyway) */
#line 3444
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3444
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3444
      nrange += tp[i] > X_INT64_MAX || tp[i] < X_INT64_MIN;
#line 3444
    }
#line 3444
   /* copy workspace back if necessary */
#line 3444
    if (realign) {
#line 3444
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3444
      xp = (int64 *) *xpp;
#line 3444
    }
#line 3444
   /* update xpp and tp */
#line 3444
    xp += ni;
#line 3444
    tp += ni;
#line 3444
    *xpp = (void*)xp;
#line 3444
  }
#line 3444
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3444

#line 3444
#else   /* not SX */
#line 3444

#line 3444
	char *xp = (char *) *xpp;
#line 3444
	int status = NC_NOERR;
#line 3444

#line 3444
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3444
	{
#line 3444
		int lstatus = ncx_put_longlong_float(xp, tp, fillp);
#line 3444
		if (status == NC_NOERR) /* report the first encountered error */
#line 3444
			status = lstatus;
#line 3444
	}
#line 3444

#line 3444
	*xpp = (void *)xp;
#line 3444
	return status;
#line 3444
#endif
#line 3444
}
#line 3444

int
#line 3445
ncx_putn_longlong_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3445
{
#line 3445
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3445

#line 3445
 /* basic algorithm is:
#line 3445
  *   - ensure sane alignment of output data
#line 3445
  *   - copy (conversion happens automatically) input data
#line 3445
  *     to output
#line 3445
  *   - update tp to point at next unconverted input, and xpp to point
#line 3445
  *     at next location for converted output
#line 3445
  */
#line 3445
  long i, j, ni;
#line 3445
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3445
  int64 *xp;
#line 3445
  int nrange = 0;         /* number of range errors */
#line 3445
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3445
  long cxp = (long) *((char**)xpp);
#line 3445

#line 3445
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3445
  /* sjl: manually stripmine so we can limit amount of
#line 3445
   * vector work space reserved to LOOPCNT elements. Also
#line 3445
   * makes vectorisation easy */
#line 3445
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3445
    ni=Min(nelems-j,LOOPCNT);
#line 3445
    if (realign) {
#line 3445
      xp = tmp;
#line 3445
    } else {
#line 3445
      xp = (int64 *) *xpp;
#line 3445
    }
#line 3445
   /* copy the next block */
#line 3445
#pragma cdir loopcnt=LOOPCNT
#line 3445
#pragma cdir shortloop
#line 3445
    for (i=0; i<ni; i++) {
#line 3445
      /* the normal case: */
#line 3445
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3445
     /* test for range errors (not always needed but do it anyway) */
#line 3445
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3445
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3445
      nrange += tp[i] > X_INT64_MAX || tp[i] < X_INT64_MIN;
#line 3445
    }
#line 3445
   /* copy workspace back if necessary */
#line 3445
    if (realign) {
#line 3445
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3445
      xp = (int64 *) *xpp;
#line 3445
    }
#line 3445
   /* update xpp and tp */
#line 3445
    xp += ni;
#line 3445
    tp += ni;
#line 3445
    *xpp = (void*)xp;
#line 3445
  }
#line 3445
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3445

#line 3445
#else   /* not SX */
#line 3445

#line 3445
	char *xp = (char *) *xpp;
#line 3445
	int status = NC_NOERR;
#line 3445

#line 3445
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3445
	{
#line 3445
		int lstatus = ncx_put_longlong_double(xp, tp, fillp);
#line 3445
		if (status == NC_NOERR) /* report the first encountered error */
#line 3445
			status = lstatus;
#line 3445
	}
#line 3445

#line 3445
	*xpp = (void *)xp;
#line 3445
	return status;
#line 3445
#endif
#line 3445
}
#line 3445

int
#line 3446
ncx_putn_longlong_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3446
{
#line 3446
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3446

#line 3446
 /* basic algorithm is:
#line 3446
  *   - ensure sane alignment of output data
#line 3446
  *   - copy (conversion happens automatically) input data
#line 3446
  *     to output
#line 3446
  *   - update tp to point at next unconverted input, and xpp to point
#line 3446
  *     at next location for converted output
#line 3446
  */
#line 3446
  long i, j, ni;
#line 3446
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3446
  int64 *xp;
#line 3446
  int nrange = 0;         /* number of range errors */
#line 3446
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3446
  long cxp = (long) *((char**)xpp);
#line 3446

#line 3446
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3446
  /* sjl: manually stripmine so we can limit amount of
#line 3446
   * vector work space reserved to LOOPCNT elements. Also
#line 3446
   * makes vectorisation easy */
#line 3446
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3446
    ni=Min(nelems-j,LOOPCNT);
#line 3446
    if (realign) {
#line 3446
      xp = tmp;
#line 3446
    } else {
#line 3446
      xp = (int64 *) *xpp;
#line 3446
    }
#line 3446
   /* copy the next block */
#line 3446
#pragma cdir loopcnt=LOOPCNT
#line 3446
#pragma cdir shortloop
#line 3446
    for (i=0; i<ni; i++) {
#line 3446
      /* the normal case: */
#line 3446
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3446
     /* test for range errors (not always needed but do it anyway) */
#line 3446
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3446
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3446
      nrange += tp[i] > X_INT64_MAX ;
#line 3446
    }
#line 3446
   /* copy workspace back if necessary */
#line 3446
    if (realign) {
#line 3446
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3446
      xp = (int64 *) *xpp;
#line 3446
    }
#line 3446
   /* update xpp and tp */
#line 3446
    xp += ni;
#line 3446
    tp += ni;
#line 3446
    *xpp = (void*)xp;
#line 3446
  }
#line 3446
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3446

#line 3446
#else   /* not SX */
#line 3446

#line 3446
	char *xp = (char *) *xpp;
#line 3446
	int status = NC_NOERR;
#line 3446

#line 3446
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3446
	{
#line 3446
		int lstatus = ncx_put_longlong_uchar(xp, tp, fillp);
#line 3446
		if (status == NC_NOERR) /* report the first encountered error */
#line 3446
			status = lstatus;
#line 3446
	}
#line 3446

#line 3446
	*xpp = (void *)xp;
#line 3446
	return status;
#line 3446
#endif
#line 3446
}
#line 3446

int
#line 3447
ncx_putn_longlong_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3447
{
#line 3447
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3447

#line 3447
 /* basic algorithm is:
#line 3447
  *   - ensure sane alignment of output data
#line 3447
  *   - copy (conversion happens automatically) input data
#line 3447
  *     to output
#line 3447
  *   - update tp to point at next unconverted input, and xpp to point
#line 3447
  *     at next location for converted output
#line 3447
  */
#line 3447
  long i, j, ni;
#line 3447
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3447
  int64 *xp;
#line 3447
  int nrange = 0;         /* number of range errors */
#line 3447
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3447
  long cxp = (long) *((char**)xpp);
#line 3447

#line 3447
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3447
  /* sjl: manually stripmine so we can limit amount of
#line 3447
   * vector work space reserved to LOOPCNT elements. Also
#line 3447
   * makes vectorisation easy */
#line 3447
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3447
    ni=Min(nelems-j,LOOPCNT);
#line 3447
    if (realign) {
#line 3447
      xp = tmp;
#line 3447
    } else {
#line 3447
      xp = (int64 *) *xpp;
#line 3447
    }
#line 3447
   /* copy the next block */
#line 3447
#pragma cdir loopcnt=LOOPCNT
#line 3447
#pragma cdir shortloop
#line 3447
    for (i=0; i<ni; i++) {
#line 3447
      /* the normal case: */
#line 3447
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3447
     /* test for range errors (not always needed but do it anyway) */
#line 3447
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3447
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3447
      nrange += tp[i] > X_INT64_MAX ;
#line 3447
    }
#line 3447
   /* copy workspace back if necessary */
#line 3447
    if (realign) {
#line 3447
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3447
      xp = (int64 *) *xpp;
#line 3447
    }
#line 3447
   /* update xpp and tp */
#line 3447
    xp += ni;
#line 3447
    tp += ni;
#line 3447
    *xpp = (void*)xp;
#line 3447
  }
#line 3447
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3447

#line 3447
#else   /* not SX */
#line 3447

#line 3447
	char *xp = (char *) *xpp;
#line 3447
	int status = NC_NOERR;
#line 3447

#line 3447
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3447
	{
#line 3447
		int lstatus = ncx_put_longlong_ushort(xp, tp, fillp);
#line 3447
		if (status == NC_NOERR) /* report the first encountered error */
#line 3447
			status = lstatus;
#line 3447
	}
#line 3447

#line 3447
	*xpp = (void *)xp;
#line 3447
	return status;
#line 3447
#endif
#line 3447
}
#line 3447

int
#line 3448
ncx_putn_longlong_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3448
{
#line 3448
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3448

#line 3448
 /* basic algorithm is:
#line 3448
  *   - ensure sane alignment of output data
#line 3448
  *   - copy (conversion happens automatically) input data
#line 3448
  *     to output
#line 3448
  *   - update tp to point at next unconverted input, and xpp to point
#line 3448
  *     at next location for converted output
#line 3448
  */
#line 3448
  long i, j, ni;
#line 3448
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3448
  int64 *xp;
#line 3448
  int nrange = 0;         /* number of range errors */
#line 3448
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3448
  long cxp = (long) *((char**)xpp);
#line 3448

#line 3448
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3448
  /* sjl: manually stripmine so we can limit amount of
#line 3448
   * vector work space reserved to LOOPCNT elements. Also
#line 3448
   * makes vectorisation easy */
#line 3448
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3448
    ni=Min(nelems-j,LOOPCNT);
#line 3448
    if (realign) {
#line 3448
      xp = tmp;
#line 3448
    } else {
#line 3448
      xp = (int64 *) *xpp;
#line 3448
    }
#line 3448
   /* copy the next block */
#line 3448
#pragma cdir loopcnt=LOOPCNT
#line 3448
#pragma cdir shortloop
#line 3448
    for (i=0; i<ni; i++) {
#line 3448
      /* the normal case: */
#line 3448
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3448
     /* test for range errors (not always needed but do it anyway) */
#line 3448
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3448
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3448
      nrange += tp[i] > X_INT64_MAX ;
#line 3448
    }
#line 3448
   /* copy workspace back if necessary */
#line 3448
    if (realign) {
#line 3448
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3448
      xp = (int64 *) *xpp;
#line 3448
    }
#line 3448
   /* update xpp and tp */
#line 3448
    xp += ni;
#line 3448
    tp += ni;
#line 3448
    *xpp = (void*)xp;
#line 3448
  }
#line 3448
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3448

#line 3448
#else   /* not SX */
#line 3448

#line 3448
	char *xp = (char *) *xpp;
#line 3448
	int status = NC_NOERR;
#line 3448

#line 3448
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3448
	{
#line 3448
		int lstatus = ncx_put_longlong_uint(xp, tp, fillp);
#line 3448
		if (status == NC_NOERR) /* report the first encountered error */
#line 3448
			status = lstatus;
#line 3448
	}
#line 3448

#line 3448
	*xpp = (void *)xp;
#line 3448
	return status;
#line 3448
#endif
#line 3448
}
#line 3448

int
#line 3449
ncx_putn_longlong_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3449
{
#line 3449
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3449

#line 3449
 /* basic algorithm is:
#line 3449
  *   - ensure sane alignment of output data
#line 3449
  *   - copy (conversion happens automatically) input data
#line 3449
  *     to output
#line 3449
  *   - update tp to point at next unconverted input, and xpp to point
#line 3449
  *     at next location for converted output
#line 3449
  */
#line 3449
  long i, j, ni;
#line 3449
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3449
  int64 *xp;
#line 3449
  int nrange = 0;         /* number of range errors */
#line 3449
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3449
  long cxp = (long) *((char**)xpp);
#line 3449

#line 3449
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3449
  /* sjl: manually stripmine so we can limit amount of
#line 3449
   * vector work space reserved to LOOPCNT elements. Also
#line 3449
   * makes vectorisation easy */
#line 3449
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3449
    ni=Min(nelems-j,LOOPCNT);
#line 3449
    if (realign) {
#line 3449
      xp = tmp;
#line 3449
    } else {
#line 3449
      xp = (int64 *) *xpp;
#line 3449
    }
#line 3449
   /* copy the next block */
#line 3449
#pragma cdir loopcnt=LOOPCNT
#line 3449
#pragma cdir shortloop
#line 3449
    for (i=0; i<ni; i++) {
#line 3449
      /* the normal case: */
#line 3449
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3449
     /* test for range errors (not always needed but do it anyway) */
#line 3449
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3449
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3449
      nrange += tp[i] > X_INT64_MAX ;
#line 3449
    }
#line 3449
   /* copy workspace back if necessary */
#line 3449
    if (realign) {
#line 3449
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3449
      xp = (int64 *) *xpp;
#line 3449
    }
#line 3449
   /* update xpp and tp */
#line 3449
    xp += ni;
#line 3449
    tp += ni;
#line 3449
    *xpp = (void*)xp;
#line 3449
  }
#line 3449
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3449

#line 3449
#else   /* not SX */
#line 3449

#line 3449
	char *xp = (char *) *xpp;
#line 3449
	int status = NC_NOERR;
#line 3449

#line 3449
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3449
	{
#line 3449
		int lstatus = ncx_put_longlong_ulonglong(xp, tp, fillp);
#line 3449
		if (status == NC_NOERR) /* report the first encountered error */
#line 3449
			status = lstatus;
#line 3449
	}
#line 3449

#line 3449
	*xpp = (void *)xp;
#line 3449
	return status;
#line 3449
#endif
#line 3449
}
#line 3449


/* uint64 --------------------------------------------------------------------*/

#if X_SIZEOF_UINT64 == SIZEOF_ULONGLONG
/* optimized version */
int
ncx_getn_ulonglong_ulonglong(const void **xpp, size_t nelems, unsigned long long *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_UNSIGNED_LONG_LONG);
# else
	swapn8b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_UINT64);
	return NC_NOERR;
}
#else
int
#line 3467
ncx_getn_ulonglong_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3467
{
#line 3467
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3467

#line 3467
 /* basic algorithm is:
#line 3467
  *   - ensure sane alignment of input data
#line 3467
  *   - copy (conversion happens automatically) input data
#line 3467
  *     to output
#line 3467
  *   - update xpp to point at next unconverted input, and tp to point
#line 3467
  *     at next location for converted output
#line 3467
  */
#line 3467
  long i, j, ni;
#line 3467
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3467
  uint64 *xp;
#line 3467
  int nrange = 0;         /* number of range errors */
#line 3467
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3467
  long cxp = (long) *((char**)xpp);
#line 3467

#line 3467
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3467
  /* sjl: manually stripmine so we can limit amount of
#line 3467
   * vector work space reserved to LOOPCNT elements. Also
#line 3467
   * makes vectorisation easy */
#line 3467
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3467
    ni=Min(nelems-j,LOOPCNT);
#line 3467
    if (realign) {
#line 3467
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3467
      xp = tmp;
#line 3467
    } else {
#line 3467
      xp = (uint64 *) *xpp;
#line 3467
    }
#line 3467
   /* copy the next block */
#line 3467
#pragma cdir loopcnt=LOOPCNT
#line 3467
#pragma cdir shortloop
#line 3467
    for (i=0; i<ni; i++) {
#line 3467
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3467
     /* test for range errors (not always needed but do it anyway) */
#line 3467
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3467
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3467
      nrange += xp[i] > ULONGLONG_MAX ;
#line 3467
    }
#line 3467
   /* update xpp and tp */
#line 3467
    if (realign) xp = (uint64 *) *xpp;
#line 3467
    xp += ni;
#line 3467
    tp += ni;
#line 3467
    *xpp = (void*)xp;
#line 3467
  }
#line 3467
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3467

#line 3467
#else   /* not SX */
#line 3467
	const char *xp = (const char *) *xpp;
#line 3467
	int status = NC_NOERR;
#line 3467

#line 3467
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3467
	{
#line 3467
		const int lstatus = ncx_get_ulonglong_ulonglong(xp, tp);
#line 3467
		if (status == NC_NOERR) /* report the first encountered error */
#line 3467
			status = lstatus;
#line 3467
	}
#line 3467

#line 3467
	*xpp = (const void *)xp;
#line 3467
	return status;
#line 3467
#endif
#line 3467
}
#line 3467

#endif
int
#line 3469
ncx_getn_ulonglong_schar(const void **xpp, size_t nelems, schar *tp)
#line 3469
{
#line 3469
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3469

#line 3469
 /* basic algorithm is:
#line 3469
  *   - ensure sane alignment of input data
#line 3469
  *   - copy (conversion happens automatically) input data
#line 3469
  *     to output
#line 3469
  *   - update xpp to point at next unconverted input, and tp to point
#line 3469
  *     at next location for converted output
#line 3469
  */
#line 3469
  long i, j, ni;
#line 3469
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3469
  uint64 *xp;
#line 3469
  int nrange = 0;         /* number of range errors */
#line 3469
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3469
  long cxp = (long) *((char**)xpp);
#line 3469

#line 3469
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3469
  /* sjl: manually stripmine so we can limit amount of
#line 3469
   * vector work space reserved to LOOPCNT elements. Also
#line 3469
   * makes vectorisation easy */
#line 3469
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3469
    ni=Min(nelems-j,LOOPCNT);
#line 3469
    if (realign) {
#line 3469
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3469
      xp = tmp;
#line 3469
    } else {
#line 3469
      xp = (uint64 *) *xpp;
#line 3469
    }
#line 3469
   /* copy the next block */
#line 3469
#pragma cdir loopcnt=LOOPCNT
#line 3469
#pragma cdir shortloop
#line 3469
    for (i=0; i<ni; i++) {
#line 3469
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3469
     /* test for range errors (not always needed but do it anyway) */
#line 3469
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3469
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3469
      nrange += xp[i] > SCHAR_MAX ;
#line 3469
    }
#line 3469
   /* update xpp and tp */
#line 3469
    if (realign) xp = (uint64 *) *xpp;
#line 3469
    xp += ni;
#line 3469
    tp += ni;
#line 3469
    *xpp = (void*)xp;
#line 3469
  }
#line 3469
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3469

#line 3469
#else   /* not SX */
#line 3469
	const char *xp = (const char *) *xpp;
#line 3469
	int status = NC_NOERR;
#line 3469

#line 3469
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3469
	{
#line 3469
		const int lstatus = ncx_get_ulonglong_schar(xp, tp);
#line 3469
		if (status == NC_NOERR) /* report the first encountered error */
#line 3469
			status = lstatus;
#line 3469
	}
#line 3469

#line 3469
	*xpp = (const void *)xp;
#line 3469
	return status;
#line 3469
#endif
#line 3469
}
#line 3469

int
#line 3470
ncx_getn_ulonglong_short(const void **xpp, size_t nelems, short *tp)
#line 3470
{
#line 3470
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3470

#line 3470
 /* basic algorithm is:
#line 3470
  *   - ensure sane alignment of input data
#line 3470
  *   - copy (conversion happens automatically) input data
#line 3470
  *     to output
#line 3470
  *   - update xpp to point at next unconverted input, and tp to point
#line 3470
  *     at next location for converted output
#line 3470
  */
#line 3470
  long i, j, ni;
#line 3470
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3470
  uint64 *xp;
#line 3470
  int nrange = 0;         /* number of range errors */
#line 3470
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3470
  long cxp = (long) *((char**)xpp);
#line 3470

#line 3470
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3470
  /* sjl: manually stripmine so we can limit amount of
#line 3470
   * vector work space reserved to LOOPCNT elements. Also
#line 3470
   * makes vectorisation easy */
#line 3470
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3470
    ni=Min(nelems-j,LOOPCNT);
#line 3470
    if (realign) {
#line 3470
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3470
      xp = tmp;
#line 3470
    } else {
#line 3470
      xp = (uint64 *) *xpp;
#line 3470
    }
#line 3470
   /* copy the next block */
#line 3470
#pragma cdir loopcnt=LOOPCNT
#line 3470
#pragma cdir shortloop
#line 3470
    for (i=0; i<ni; i++) {
#line 3470
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3470
     /* test for range errors (not always needed but do it anyway) */
#line 3470
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3470
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3470
      nrange += xp[i] > SHORT_MAX ;
#line 3470
    }
#line 3470
   /* update xpp and tp */
#line 3470
    if (realign) xp = (uint64 *) *xpp;
#line 3470
    xp += ni;
#line 3470
    tp += ni;
#line 3470
    *xpp = (void*)xp;
#line 3470
  }
#line 3470
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3470

#line 3470
#else   /* not SX */
#line 3470
	const char *xp = (const char *) *xpp;
#line 3470
	int status = NC_NOERR;
#line 3470

#line 3470
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3470
	{
#line 3470
		const int lstatus = ncx_get_ulonglong_short(xp, tp);
#line 3470
		if (status == NC_NOERR) /* report the first encountered error */
#line 3470
			status = lstatus;
#line 3470
	}
#line 3470

#line 3470
	*xpp = (const void *)xp;
#line 3470
	return status;
#line 3470
#endif
#line 3470
}
#line 3470

int
#line 3471
ncx_getn_ulonglong_int(const void **xpp, size_t nelems, int *tp)
#line 3471
{
#line 3471
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3471

#line 3471
 /* basic algorithm is:
#line 3471
  *   - ensure sane alignment of input data
#line 3471
  *   - copy (conversion happens automatically) input data
#line 3471
  *     to output
#line 3471
  *   - update xpp to point at next unconverted input, and tp to point
#line 3471
  *     at next location for converted output
#line 3471
  */
#line 3471
  long i, j, ni;
#line 3471
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3471
  uint64 *xp;
#line 3471
  int nrange = 0;         /* number of range errors */
#line 3471
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3471
  long cxp = (long) *((char**)xpp);
#line 3471

#line 3471
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3471
  /* sjl: manually stripmine so we can limit amount of
#line 3471
   * vector work space reserved to LOOPCNT elements. Also
#line 3471
   * makes vectorisation easy */
#line 3471
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3471
    ni=Min(nelems-j,LOOPCNT);
#line 3471
    if (realign) {
#line 3471
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3471
      xp = tmp;
#line 3471
    } else {
#line 3471
      xp = (uint64 *) *xpp;
#line 3471
    }
#line 3471
   /* copy the next block */
#line 3471
#pragma cdir loopcnt=LOOPCNT
#line 3471
#pragma cdir shortloop
#line 3471
    for (i=0; i<ni; i++) {
#line 3471
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3471
     /* test for range errors (not always needed but do it anyway) */
#line 3471
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3471
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3471
      nrange += xp[i] > INT_MAX ;
#line 3471
    }
#line 3471
   /* update xpp and tp */
#line 3471
    if (realign) xp = (uint64 *) *xpp;
#line 3471
    xp += ni;
#line 3471
    tp += ni;
#line 3471
    *xpp = (void*)xp;
#line 3471
  }
#line 3471
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3471

#line 3471
#else   /* not SX */
#line 3471
	const char *xp = (const char *) *xpp;
#line 3471
	int status = NC_NOERR;
#line 3471

#line 3471
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3471
	{
#line 3471
		const int lstatus = ncx_get_ulonglong_int(xp, tp);
#line 3471
		if (status == NC_NOERR) /* report the first encountered error */
#line 3471
			status = lstatus;
#line 3471
	}
#line 3471

#line 3471
	*xpp = (const void *)xp;
#line 3471
	return status;
#line 3471
#endif
#line 3471
}
#line 3471

int
#line 3472
ncx_getn_ulonglong_long(const void **xpp, size_t nelems, long *tp)
#line 3472
{
#line 3472
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3472

#line 3472
 /* basic algorithm is:
#line 3472
  *   - ensure sane alignment of input data
#line 3472
  *   - copy (conversion happens automatically) input data
#line 3472
  *     to output
#line 3472
  *   - update xpp to point at next unconverted input, and tp to point
#line 3472
  *     at next location for converted output
#line 3472
  */
#line 3472
  long i, j, ni;
#line 3472
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3472
  uint64 *xp;
#line 3472
  int nrange = 0;         /* number of range errors */
#line 3472
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3472
  long cxp = (long) *((char**)xpp);
#line 3472

#line 3472
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3472
  /* sjl: manually stripmine so we can limit amount of
#line 3472
   * vector work space reserved to LOOPCNT elements. Also
#line 3472
   * makes vectorisation easy */
#line 3472
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3472
    ni=Min(nelems-j,LOOPCNT);
#line 3472
    if (realign) {
#line 3472
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3472
      xp = tmp;
#line 3472
    } else {
#line 3472
      xp = (uint64 *) *xpp;
#line 3472
    }
#line 3472
   /* copy the next block */
#line 3472
#pragma cdir loopcnt=LOOPCNT
#line 3472
#pragma cdir shortloop
#line 3472
    for (i=0; i<ni; i++) {
#line 3472
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3472
     /* test for range errors (not always needed but do it anyway) */
#line 3472
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3472
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3472
      nrange += xp[i] > LONG_MAX ;
#line 3472
    }
#line 3472
   /* update xpp and tp */
#line 3472
    if (realign) xp = (uint64 *) *xpp;
#line 3472
    xp += ni;
#line 3472
    tp += ni;
#line 3472
    *xpp = (void*)xp;
#line 3472
  }
#line 3472
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3472

#line 3472
#else   /* not SX */
#line 3472
	const char *xp = (const char *) *xpp;
#line 3472
	int status = NC_NOERR;
#line 3472

#line 3472
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3472
	{
#line 3472
		const int lstatus = ncx_get_ulonglong_long(xp, tp);
#line 3472
		if (status == NC_NOERR) /* report the first encountered error */
#line 3472
			status = lstatus;
#line 3472
	}
#line 3472

#line 3472
	*xpp = (const void *)xp;
#line 3472
	return status;
#line 3472
#endif
#line 3472
}
#line 3472

int
#line 3473
ncx_getn_ulonglong_float(const void **xpp, size_t nelems, float *tp)
#line 3473
{
#line 3473
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3473

#line 3473
 /* basic algorithm is:
#line 3473
  *   - ensure sane alignment of input data
#line 3473
  *   - copy (conversion happens automatically) input data
#line 3473
  *     to output
#line 3473
  *   - update xpp to point at next unconverted input, and tp to point
#line 3473
  *     at next location for converted output
#line 3473
  */
#line 3473
  long i, j, ni;
#line 3473
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3473
  uint64 *xp;
#line 3473
  int nrange = 0;         /* number of range errors */
#line 3473
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3473
  long cxp = (long) *((char**)xpp);
#line 3473

#line 3473
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3473
  /* sjl: manually stripmine so we can limit amount of
#line 3473
   * vector work space reserved to LOOPCNT elements. Also
#line 3473
   * makes vectorisation easy */
#line 3473
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3473
    ni=Min(nelems-j,LOOPCNT);
#line 3473
    if (realign) {
#line 3473
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3473
      xp = tmp;
#line 3473
    } else {
#line 3473
      xp = (uint64 *) *xpp;
#line 3473
    }
#line 3473
   /* copy the next block */
#line 3473
#pragma cdir loopcnt=LOOPCNT
#line 3473
#pragma cdir shortloop
#line 3473
    for (i=0; i<ni; i++) {
#line 3473
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 3473
     /* test for range errors (not always needed but do it anyway) */
#line 3473
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3473
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3473
      nrange += xp[i] > FLOAT_MAX ;
#line 3473
    }
#line 3473
   /* update xpp and tp */
#line 3473
    if (realign) xp = (uint64 *) *xpp;
#line 3473
    xp += ni;
#line 3473
    tp += ni;
#line 3473
    *xpp = (void*)xp;
#line 3473
  }
#line 3473
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3473

#line 3473
#else   /* not SX */
#line 3473
	const char *xp = (const char *) *xpp;
#line 3473
	int status = NC_NOERR;
#line 3473

#line 3473
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3473
	{
#line 3473
		const int lstatus = ncx_get_ulonglong_float(xp, tp);
#line 3473
		if (status == NC_NOERR) /* report the first encountered error */
#line 3473
			status = lstatus;
#line 3473
	}
#line 3473

#line 3473
	*xpp = (const void *)xp;
#line 3473
	return status;
#line 3473
#endif
#line 3473
}
#line 3473

int
#line 3474
ncx_getn_ulonglong_double(const void **xpp, size_t nelems, double *tp)
#line 3474
{
#line 3474
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3474

#line 3474
 /* basic algorithm is:
#line 3474
  *   - ensure sane alignment of input data
#line 3474
  *   - copy (conversion happens automatically) input data
#line 3474
  *     to output
#line 3474
  *   - update xpp to point at next unconverted input, and tp to point
#line 3474
  *     at next location for converted output
#line 3474
  */
#line 3474
  long i, j, ni;
#line 3474
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3474
  uint64 *xp;
#line 3474
  int nrange = 0;         /* number of range errors */
#line 3474
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3474
  long cxp = (long) *((char**)xpp);
#line 3474

#line 3474
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3474
  /* sjl: manually stripmine so we can limit amount of
#line 3474
   * vector work space reserved to LOOPCNT elements. Also
#line 3474
   * makes vectorisation easy */
#line 3474
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3474
    ni=Min(nelems-j,LOOPCNT);
#line 3474
    if (realign) {
#line 3474
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3474
      xp = tmp;
#line 3474
    } else {
#line 3474
      xp = (uint64 *) *xpp;
#line 3474
    }
#line 3474
   /* copy the next block */
#line 3474
#pragma cdir loopcnt=LOOPCNT
#line 3474
#pragma cdir shortloop
#line 3474
    for (i=0; i<ni; i++) {
#line 3474
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 3474
     /* test for range errors (not always needed but do it anyway) */
#line 3474
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3474
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3474
      nrange += xp[i] > DOUBLE_MAX ;
#line 3474
    }
#line 3474
   /* update xpp and tp */
#line 3474
    if (realign) xp = (uint64 *) *xpp;
#line 3474
    xp += ni;
#line 3474
    tp += ni;
#line 3474
    *xpp = (void*)xp;
#line 3474
  }
#line 3474
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3474

#line 3474
#else   /* not SX */
#line 3474
	const char *xp = (const char *) *xpp;
#line 3474
	int status = NC_NOERR;
#line 3474

#line 3474
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3474
	{
#line 3474
		const int lstatus = ncx_get_ulonglong_double(xp, tp);
#line 3474
		if (status == NC_NOERR) /* report the first encountered error */
#line 3474
			status = lstatus;
#line 3474
	}
#line 3474

#line 3474
	*xpp = (const void *)xp;
#line 3474
	return status;
#line 3474
#endif
#line 3474
}
#line 3474

int
#line 3475
ncx_getn_ulonglong_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3475
{
#line 3475
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3475

#line 3475
 /* basic algorithm is:
#line 3475
  *   - ensure sane alignment of input data
#line 3475
  *   - copy (conversion happens automatically) input data
#line 3475
  *     to output
#line 3475
  *   - update xpp to point at next unconverted input, and tp to point
#line 3475
  *     at next location for converted output
#line 3475
  */
#line 3475
  long i, j, ni;
#line 3475
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3475
  uint64 *xp;
#line 3475
  int nrange = 0;         /* number of range errors */
#line 3475
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3475
  long cxp = (long) *((char**)xpp);
#line 3475

#line 3475
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3475
  /* sjl: manually stripmine so we can limit amount of
#line 3475
   * vector work space reserved to LOOPCNT elements. Also
#line 3475
   * makes vectorisation easy */
#line 3475
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3475
    ni=Min(nelems-j,LOOPCNT);
#line 3475
    if (realign) {
#line 3475
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3475
      xp = tmp;
#line 3475
    } else {
#line 3475
      xp = (uint64 *) *xpp;
#line 3475
    }
#line 3475
   /* copy the next block */
#line 3475
#pragma cdir loopcnt=LOOPCNT
#line 3475
#pragma cdir shortloop
#line 3475
    for (i=0; i<ni; i++) {
#line 3475
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3475
     /* test for range errors (not always needed but do it anyway) */
#line 3475
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3475
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3475
      nrange += xp[i] > LONGLONG_MAX ;
#line 3475
    }
#line 3475
   /* update xpp and tp */
#line 3475
    if (realign) xp = (uint64 *) *xpp;
#line 3475
    xp += ni;
#line 3475
    tp += ni;
#line 3475
    *xpp = (void*)xp;
#line 3475
  }
#line 3475
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3475

#line 3475
#else   /* not SX */
#line 3475
	const char *xp = (const char *) *xpp;
#line 3475
	int status = NC_NOERR;
#line 3475

#line 3475
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3475
	{
#line 3475
		const int lstatus = ncx_get_ulonglong_longlong(xp, tp);
#line 3475
		if (status == NC_NOERR) /* report the first encountered error */
#line 3475
			status = lstatus;
#line 3475
	}
#line 3475

#line 3475
	*xpp = (const void *)xp;
#line 3475
	return status;
#line 3475
#endif
#line 3475
}
#line 3475

int
#line 3476
ncx_getn_ulonglong_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3476
{
#line 3476
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3476

#line 3476
 /* basic algorithm is:
#line 3476
  *   - ensure sane alignment of input data
#line 3476
  *   - copy (conversion happens automatically) input data
#line 3476
  *     to output
#line 3476
  *   - update xpp to point at next unconverted input, and tp to point
#line 3476
  *     at next location for converted output
#line 3476
  */
#line 3476
  long i, j, ni;
#line 3476
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3476
  uint64 *xp;
#line 3476
  int nrange = 0;         /* number of range errors */
#line 3476
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3476
  long cxp = (long) *((char**)xpp);
#line 3476

#line 3476
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3476
  /* sjl: manually stripmine so we can limit amount of
#line 3476
   * vector work space reserved to LOOPCNT elements. Also
#line 3476
   * makes vectorisation easy */
#line 3476
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3476
    ni=Min(nelems-j,LOOPCNT);
#line 3476
    if (realign) {
#line 3476
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3476
      xp = tmp;
#line 3476
    } else {
#line 3476
      xp = (uint64 *) *xpp;
#line 3476
    }
#line 3476
   /* copy the next block */
#line 3476
#pragma cdir loopcnt=LOOPCNT
#line 3476
#pragma cdir shortloop
#line 3476
    for (i=0; i<ni; i++) {
#line 3476
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3476
     /* test for range errors (not always needed but do it anyway) */
#line 3476
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3476
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3476
      nrange += xp[i] > UCHAR_MAX ;
#line 3476
    }
#line 3476
   /* update xpp and tp */
#line 3476
    if (realign) xp = (uint64 *) *xpp;
#line 3476
    xp += ni;
#line 3476
    tp += ni;
#line 3476
    *xpp = (void*)xp;
#line 3476
  }
#line 3476
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3476

#line 3476
#else   /* not SX */
#line 3476
	const char *xp = (const char *) *xpp;
#line 3476
	int status = NC_NOERR;
#line 3476

#line 3476
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3476
	{
#line 3476
		const int lstatus = ncx_get_ulonglong_uchar(xp, tp);
#line 3476
		if (status == NC_NOERR) /* report the first encountered error */
#line 3476
			status = lstatus;
#line 3476
	}
#line 3476

#line 3476
	*xpp = (const void *)xp;
#line 3476
	return status;
#line 3476
#endif
#line 3476
}
#line 3476

int
#line 3477
ncx_getn_ulonglong_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3477
{
#line 3477
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3477

#line 3477
 /* basic algorithm is:
#line 3477
  *   - ensure sane alignment of input data
#line 3477
  *   - copy (conversion happens automatically) input data
#line 3477
  *     to output
#line 3477
  *   - update xpp to point at next unconverted input, and tp to point
#line 3477
  *     at next location for converted output
#line 3477
  */
#line 3477
  long i, j, ni;
#line 3477
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3477
  uint64 *xp;
#line 3477
  int nrange = 0;         /* number of range errors */
#line 3477
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3477
  long cxp = (long) *((char**)xpp);
#line 3477

#line 3477
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3477
  /* sjl: manually stripmine so we can limit amount of
#line 3477
   * vector work space reserved to LOOPCNT elements. Also
#line 3477
   * makes vectorisation easy */
#line 3477
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3477
    ni=Min(nelems-j,LOOPCNT);
#line 3477
    if (realign) {
#line 3477
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3477
      xp = tmp;
#line 3477
    } else {
#line 3477
      xp = (uint64 *) *xpp;
#line 3477
    }
#line 3477
   /* copy the next block */
#line 3477
#pragma cdir loopcnt=LOOPCNT
#line 3477
#pragma cdir shortloop
#line 3477
    for (i=0; i<ni; i++) {
#line 3477
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3477
     /* test for range errors (not always needed but do it anyway) */
#line 3477
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3477
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3477
      nrange += xp[i] > USHORT_MAX ;
#line 3477
    }
#line 3477
   /* update xpp and tp */
#line 3477
    if (realign) xp = (uint64 *) *xpp;
#line 3477
    xp += ni;
#line 3477
    tp += ni;
#line 3477
    *xpp = (void*)xp;
#line 3477
  }
#line 3477
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3477

#line 3477
#else   /* not SX */
#line 3477
	const char *xp = (const char *) *xpp;
#line 3477
	int status = NC_NOERR;
#line 3477

#line 3477
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3477
	{
#line 3477
		const int lstatus = ncx_get_ulonglong_ushort(xp, tp);
#line 3477
		if (status == NC_NOERR) /* report the first encountered error */
#line 3477
			status = lstatus;
#line 3477
	}
#line 3477

#line 3477
	*xpp = (const void *)xp;
#line 3477
	return status;
#line 3477
#endif
#line 3477
}
#line 3477

int
#line 3478
ncx_getn_ulonglong_uint(const void **xpp, size_t nelems, uint *tp)
#line 3478
{
#line 3478
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3478

#line 3478
 /* basic algorithm is:
#line 3478
  *   - ensure sane alignment of input data
#line 3478
  *   - copy (conversion happens automatically) input data
#line 3478
  *     to output
#line 3478
  *   - update xpp to point at next unconverted input, and tp to point
#line 3478
  *     at next location for converted output
#line 3478
  */
#line 3478
  long i, j, ni;
#line 3478
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3478
  uint64 *xp;
#line 3478
  int nrange = 0;         /* number of range errors */
#line 3478
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3478
  long cxp = (long) *((char**)xpp);
#line 3478

#line 3478
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3478
  /* sjl: manually stripmine so we can limit amount of
#line 3478
   * vector work space reserved to LOOPCNT elements. Also
#line 3478
   * makes vectorisation easy */
#line 3478
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3478
    ni=Min(nelems-j,LOOPCNT);
#line 3478
    if (realign) {
#line 3478
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3478
      xp = tmp;
#line 3478
    } else {
#line 3478
      xp = (uint64 *) *xpp;
#line 3478
    }
#line 3478
   /* copy the next block */
#line 3478
#pragma cdir loopcnt=LOOPCNT
#line 3478
#pragma cdir shortloop
#line 3478
    for (i=0; i<ni; i++) {
#line 3478
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3478
     /* test for range errors (not always needed but do it anyway) */
#line 3478
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3478
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3478
      nrange += xp[i] > UINT_MAX ;
#line 3478
    }
#line 3478
   /* update xpp and tp */
#line 3478
    if (realign) xp = (uint64 *) *xpp;
#line 3478
    xp += ni;
#line 3478
    tp += ni;
#line 3478
    *xpp = (void*)xp;
#line 3478
  }
#line 3478
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3478

#line 3478
#else   /* not SX */
#line 3478
	const char *xp = (const char *) *xpp;
#line 3478
	int status = NC_NOERR;
#line 3478

#line 3478
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3478
	{
#line 3478
		const int lstatus = ncx_get_ulonglong_uint(xp, tp);
#line 3478
		if (status == NC_NOERR) /* report the first encountered error */
#line 3478
			status = lstatus;
#line 3478
	}
#line 3478

#line 3478
	*xpp = (const void *)xp;
#line 3478
	return status;
#line 3478
#endif
#line 3478
}
#line 3478


#if X_SIZEOF_UINT64 == SIZEOF_ULONGLONG
/* optimized version */
int
ncx_putn_ulonglong_ulonglong(void **xpp, size_t nelems, const unsigned long long *tp, void *fillp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_UINT64);
# else
	swapn8b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_UINT64);
	return NC_NOERR;
}
#else
int
#line 3494
ncx_putn_ulonglong_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3494
{
#line 3494
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3494

#line 3494
 /* basic algorithm is:
#line 3494
  *   - ensure sane alignment of output data
#line 3494
  *   - copy (conversion happens automatically) input data
#line 3494
  *     to output
#line 3494
  *   - update tp to point at next unconverted input, and xpp to point
#line 3494
  *     at next location for converted output
#line 3494
  */
#line 3494
  long i, j, ni;
#line 3494
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3494
  uint64 *xp;
#line 3494
  int nrange = 0;         /* number of range errors */
#line 3494
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3494
  long cxp = (long) *((char**)xpp);
#line 3494

#line 3494
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3494
  /* sjl: manually stripmine so we can limit amount of
#line 3494
   * vector work space reserved to LOOPCNT elements. Also
#line 3494
   * makes vectorisation easy */
#line 3494
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3494
    ni=Min(nelems-j,LOOPCNT);
#line 3494
    if (realign) {
#line 3494
      xp = tmp;
#line 3494
    } else {
#line 3494
      xp = (uint64 *) *xpp;
#line 3494
    }
#line 3494
   /* copy the next block */
#line 3494
#pragma cdir loopcnt=LOOPCNT
#line 3494
#pragma cdir shortloop
#line 3494
    for (i=0; i<ni; i++) {
#line 3494
      /* the normal case: */
#line 3494
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3494
     /* test for range errors (not always needed but do it anyway) */
#line 3494
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3494
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3494
      nrange += tp[i] > X_UINT64_MAX ;
#line 3494
    }
#line 3494
   /* copy workspace back if necessary */
#line 3494
    if (realign) {
#line 3494
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3494
      xp = (uint64 *) *xpp;
#line 3494
    }
#line 3494
   /* update xpp and tp */
#line 3494
    xp += ni;
#line 3494
    tp += ni;
#line 3494
    *xpp = (void*)xp;
#line 3494
  }
#line 3494
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3494

#line 3494
#else   /* not SX */
#line 3494

#line 3494
	char *xp = (char *) *xpp;
#line 3494
	int status = NC_NOERR;
#line 3494

#line 3494
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3494
	{
#line 3494
		int lstatus = ncx_put_ulonglong_ulonglong(xp, tp, fillp);
#line 3494
		if (status == NC_NOERR) /* report the first encountered error */
#line 3494
			status = lstatus;
#line 3494
	}
#line 3494

#line 3494
	*xpp = (void *)xp;
#line 3494
	return status;
#line 3494
#endif
#line 3494
}
#line 3494

#endif
int
#line 3496
ncx_putn_ulonglong_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3496
{
#line 3496
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3496

#line 3496
 /* basic algorithm is:
#line 3496
  *   - ensure sane alignment of output data
#line 3496
  *   - copy (conversion happens automatically) input data
#line 3496
  *     to output
#line 3496
  *   - update tp to point at next unconverted input, and xpp to point
#line 3496
  *     at next location for converted output
#line 3496
  */
#line 3496
  long i, j, ni;
#line 3496
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3496
  uint64 *xp;
#line 3496
  int nrange = 0;         /* number of range errors */
#line 3496
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3496
  long cxp = (long) *((char**)xpp);
#line 3496

#line 3496
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3496
  /* sjl: manually stripmine so we can limit amount of
#line 3496
   * vector work space reserved to LOOPCNT elements. Also
#line 3496
   * makes vectorisation easy */
#line 3496
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3496
    ni=Min(nelems-j,LOOPCNT);
#line 3496
    if (realign) {
#line 3496
      xp = tmp;
#line 3496
    } else {
#line 3496
      xp = (uint64 *) *xpp;
#line 3496
    }
#line 3496
   /* copy the next block */
#line 3496
#pragma cdir loopcnt=LOOPCNT
#line 3496
#pragma cdir shortloop
#line 3496
    for (i=0; i<ni; i++) {
#line 3496
      /* the normal case: */
#line 3496
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3496
     /* test for range errors (not always needed but do it anyway) */
#line 3496
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3496
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3496
      nrange += tp[i] > X_UINT64_MAX || tp[i] < 0;
#line 3496
    }
#line 3496
   /* copy workspace back if necessary */
#line 3496
    if (realign) {
#line 3496
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3496
      xp = (uint64 *) *xpp;
#line 3496
    }
#line 3496
   /* update xpp and tp */
#line 3496
    xp += ni;
#line 3496
    tp += ni;
#line 3496
    *xpp = (void*)xp;
#line 3496
  }
#line 3496
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3496

#line 3496
#else   /* not SX */
#line 3496

#line 3496
	char *xp = (char *) *xpp;
#line 3496
	int status = NC_NOERR;
#line 3496

#line 3496
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3496
	{
#line 3496
		int lstatus = ncx_put_ulonglong_schar(xp, tp, fillp);
#line 3496
		if (status == NC_NOERR) /* report the first encountered error */
#line 3496
			status = lstatus;
#line 3496
	}
#line 3496

#line 3496
	*xpp = (void *)xp;
#line 3496
	return status;
#line 3496
#endif
#line 3496
}
#line 3496

int
#line 3497
ncx_putn_ulonglong_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3497
{
#line 3497
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3497

#line 3497
 /* basic algorithm is:
#line 3497
  *   - ensure sane alignment of output data
#line 3497
  *   - copy (conversion happens automatically) input data
#line 3497
  *     to output
#line 3497
  *   - update tp to point at next unconverted input, and xpp to point
#line 3497
  *     at next location for converted output
#line 3497
  */
#line 3497
  long i, j, ni;
#line 3497
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3497
  uint64 *xp;
#line 3497
  int nrange = 0;         /* number of range errors */
#line 3497
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3497
  long cxp = (long) *((char**)xpp);
#line 3497

#line 3497
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3497
  /* sjl: manually stripmine so we can limit amount of
#line 3497
   * vector work space reserved to LOOPCNT elements. Also
#line 3497
   * makes vectorisation easy */
#line 3497
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3497
    ni=Min(nelems-j,LOOPCNT);
#line 3497
    if (realign) {
#line 3497
      xp = tmp;
#line 3497
    } else {
#line 3497
      xp = (uint64 *) *xpp;
#line 3497
    }
#line 3497
   /* copy the next block */
#line 3497
#pragma cdir loopcnt=LOOPCNT
#line 3497
#pragma cdir shortloop
#line 3497
    for (i=0; i<ni; i++) {
#line 3497
      /* the normal case: */
#line 3497
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3497
     /* test for range errors (not always needed but do it anyway) */
#line 3497
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3497
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3497
      nrange += tp[i] > X_UINT64_MAX || tp[i] < 0;
#line 3497
    }
#line 3497
   /* copy workspace back if necessary */
#line 3497
    if (realign) {
#line 3497
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3497
      xp = (uint64 *) *xpp;
#line 3497
    }
#line 3497
   /* update xpp and tp */
#line 3497
    xp += ni;
#line 3497
    tp += ni;
#line 3497
    *xpp = (void*)xp;
#line 3497
  }
#line 3497
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3497

#line 3497
#else   /* not SX */
#line 3497

#line 3497
	char *xp = (char *) *xpp;
#line 3497
	int status = NC_NOERR;
#line 3497

#line 3497
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3497
	{
#line 3497
		int lstatus = ncx_put_ulonglong_short(xp, tp, fillp);
#line 3497
		if (status == NC_NOERR) /* report the first encountered error */
#line 3497
			status = lstatus;
#line 3497
	}
#line 3497

#line 3497
	*xpp = (void *)xp;
#line 3497
	return status;
#line 3497
#endif
#line 3497
}
#line 3497

int
#line 3498
ncx_putn_ulonglong_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3498
{
#line 3498
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3498

#line 3498
 /* basic algorithm is:
#line 3498
  *   - ensure sane alignment of output data
#line 3498
  *   - copy (conversion happens automatically) input data
#line 3498
  *     to output
#line 3498
  *   - update tp to point at next unconverted input, and xpp to point
#line 3498
  *     at next location for converted output
#line 3498
  */
#line 3498
  long i, j, ni;
#line 3498
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3498
  uint64 *xp;
#line 3498
  int nrange = 0;         /* number of range errors */
#line 3498
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3498
  long cxp = (long) *((char**)xpp);
#line 3498

#line 3498
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3498
  /* sjl: manually stripmine so we can limit amount of
#line 3498
   * vector work space reserved to LOOPCNT elements. Also
#line 3498
   * makes vectorisation easy */
#line 3498
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3498
    ni=Min(nelems-j,LOOPCNT);
#line 3498
    if (realign) {
#line 3498
      xp = tmp;
#line 3498
    } else {
#line 3498
      xp = (uint64 *) *xpp;
#line 3498
    }
#line 3498
   /* copy the next block */
#line 3498
#pragma cdir loopcnt=LOOPCNT
#line 3498
#pragma cdir shortloop
#line 3498
    for (i=0; i<ni; i++) {
#line 3498
      /* the normal case: */
#line 3498
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3498
     /* test for range errors (not always needed but do it anyway) */
#line 3498
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3498
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3498
      nrange += tp[i] > X_UINT64_MAX || tp[i] < 0;
#line 3498
    }
#line 3498
   /* copy workspace back if necessary */
#line 3498
    if (realign) {
#line 3498
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3498
      xp = (uint64 *) *xpp;
#line 3498
    }
#line 3498
   /* update xpp and tp */
#line 3498
    xp += ni;
#line 3498
    tp += ni;
#line 3498
    *xpp = (void*)xp;
#line 3498
  }
#line 3498
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3498

#line 3498
#else   /* not SX */
#line 3498

#line 3498
	char *xp = (char *) *xpp;
#line 3498
	int status = NC_NOERR;
#line 3498

#line 3498
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3498
	{
#line 3498
		int lstatus = ncx_put_ulonglong_int(xp, tp, fillp);
#line 3498
		if (status == NC_NOERR) /* report the first encountered error */
#line 3498
			status = lstatus;
#line 3498
	}
#line 3498

#line 3498
	*xpp = (void *)xp;
#line 3498
	return status;
#line 3498
#endif
#line 3498
}
#line 3498

int
#line 3499
ncx_putn_ulonglong_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3499
{
#line 3499
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3499

#line 3499
 /* basic algorithm is:
#line 3499
  *   - ensure sane alignment of output data
#line 3499
  *   - copy (conversion happens automatically) input data
#line 3499
  *     to output
#line 3499
  *   - update tp to point at next unconverted input, and xpp to point
#line 3499
  *     at next location for converted output
#line 3499
  */
#line 3499
  long i, j, ni;
#line 3499
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3499
  uint64 *xp;
#line 3499
  int nrange = 0;         /* number of range errors */
#line 3499
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3499
  long cxp = (long) *((char**)xpp);
#line 3499

#line 3499
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3499
  /* sjl: manually stripmine so we can limit amount of
#line 3499
   * vector work space reserved to LOOPCNT elements. Also
#line 3499
   * makes vectorisation easy */
#line 3499
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3499
    ni=Min(nelems-j,LOOPCNT);
#line 3499
    if (realign) {
#line 3499
      xp = tmp;
#line 3499
    } else {
#line 3499
      xp = (uint64 *) *xpp;
#line 3499
    }
#line 3499
   /* copy the next block */
#line 3499
#pragma cdir loopcnt=LOOPCNT
#line 3499
#pragma cdir shortloop
#line 3499
    for (i=0; i<ni; i++) {
#line 3499
      /* the normal case: */
#line 3499
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3499
     /* test for range errors (not always needed but do it anyway) */
#line 3499
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3499
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3499
      nrange += tp[i] > X_UINT64_MAX || tp[i] < 0;
#line 3499
    }
#line 3499
   /* copy workspace back if necessary */
#line 3499
    if (realign) {
#line 3499
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3499
      xp = (uint64 *) *xpp;
#line 3499
    }
#line 3499
   /* update xpp and tp */
#line 3499
    xp += ni;
#line 3499
    tp += ni;
#line 3499
    *xpp = (void*)xp;
#line 3499
  }
#line 3499
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3499

#line 3499
#else   /* not SX */
#line 3499

#line 3499
	char *xp = (char *) *xpp;
#line 3499
	int status = NC_NOERR;
#line 3499

#line 3499
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3499
	{
#line 3499
		int lstatus = ncx_put_ulonglong_long(xp, tp, fillp);
#line 3499
		if (status == NC_NOERR) /* report the first encountered error */
#line 3499
			status = lstatus;
#line 3499
	}
#line 3499

#line 3499
	*xpp = (void *)xp;
#line 3499
	return status;
#line 3499
#endif
#line 3499
}
#line 3499

int
#line 3500
ncx_putn_ulonglong_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3500
{
#line 3500
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3500

#line 3500
 /* basic algorithm is:
#line 3500
  *   - ensure sane alignment of output data
#line 3500
  *   - copy (conversion happens automatically) input data
#line 3500
  *     to output
#line 3500
  *   - update tp to point at next unconverted input, and xpp to point
#line 3500
  *     at next location for converted output
#line 3500
  */
#line 3500
  long i, j, ni;
#line 3500
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3500
  uint64 *xp;
#line 3500
  int nrange = 0;         /* number of range errors */
#line 3500
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3500
  long cxp = (long) *((char**)xpp);
#line 3500

#line 3500
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3500
  /* sjl: manually stripmine so we can limit amount of
#line 3500
   * vector work space reserved to LOOPCNT elements. Also
#line 3500
   * makes vectorisation easy */
#line 3500
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3500
    ni=Min(nelems-j,LOOPCNT);
#line 3500
    if (realign) {
#line 3500
      xp = tmp;
#line 3500
    } else {
#line 3500
      xp = (uint64 *) *xpp;
#line 3500
    }
#line 3500
   /* copy the next block */
#line 3500
#pragma cdir loopcnt=LOOPCNT
#line 3500
#pragma cdir shortloop
#line 3500
    for (i=0; i<ni; i++) {
#line 3500
      /* the normal case: */
#line 3500
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3500
     /* test for range errors (not always needed but do it anyway) */
#line 3500
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3500
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3500
      nrange += tp[i] > X_UINT64_MAX || tp[i] < 0;
#line 3500
    }
#line 3500
   /* copy workspace back if necessary */
#line 3500
    if (realign) {
#line 3500
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3500
      xp = (uint64 *) *xpp;
#line 3500
    }
#line 3500
   /* update xpp and tp */
#line 3500
    xp += ni;
#line 3500
    tp += ni;
#line 3500
    *xpp = (void*)xp;
#line 3500
  }
#line 3500
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3500

#line 3500
#else   /* not SX */
#line 3500

#line 3500
	char *xp = (char *) *xpp;
#line 3500
	int status = NC_NOERR;
#line 3500

#line 3500
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3500
	{
#line 3500
		int lstatus = ncx_put_ulonglong_float(xp, tp, fillp);
#line 3500
		if (status == NC_NOERR) /* report the first encountered error */
#line 3500
			status = lstatus;
#line 3500
	}
#line 3500

#line 3500
	*xpp = (void *)xp;
#line 3500
	return status;
#line 3500
#endif
#line 3500
}
#line 3500

int
#line 3501
ncx_putn_ulonglong_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3501
{
#line 3501
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3501

#line 3501
 /* basic algorithm is:
#line 3501
  *   - ensure sane alignment of output data
#line 3501
  *   - copy (conversion happens automatically) input data
#line 3501
  *     to output
#line 3501
  *   - update tp to point at next unconverted input, and xpp to point
#line 3501
  *     at next location for converted output
#line 3501
  */
#line 3501
  long i, j, ni;
#line 3501
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3501
  uint64 *xp;
#line 3501
  int nrange = 0;         /* number of range errors */
#line 3501
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3501
  long cxp = (long) *((char**)xpp);
#line 3501

#line 3501
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3501
  /* sjl: manually stripmine so we can limit amount of
#line 3501
   * vector work space reserved to LOOPCNT elements. Also
#line 3501
   * makes vectorisation easy */
#line 3501
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3501
    ni=Min(nelems-j,LOOPCNT);
#line 3501
    if (realign) {
#line 3501
      xp = tmp;
#line 3501
    } else {
#line 3501
      xp = (uint64 *) *xpp;
#line 3501
    }
#line 3501
   /* copy the next block */
#line 3501
#pragma cdir loopcnt=LOOPCNT
#line 3501
#pragma cdir shortloop
#line 3501
    for (i=0; i<ni; i++) {
#line 3501
      /* the normal case: */
#line 3501
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3501
     /* test for range errors (not always needed but do it anyway) */
#line 3501
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3501
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3501
      nrange += tp[i] > X_UINT64_MAX || tp[i] < 0;
#line 3501
    }
#line 3501
   /* copy workspace back if necessary */
#line 3501
    if (realign) {
#line 3501
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3501
      xp = (uint64 *) *xpp;
#line 3501
    }
#line 3501
   /* update xpp and tp */
#line 3501
    xp += ni;
#line 3501
    tp += ni;
#line 3501
    *xpp = (void*)xp;
#line 3501
  }
#line 3501
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3501

#line 3501
#else   /* not SX */
#line 3501

#line 3501
	char *xp = (char *) *xpp;
#line 3501
	int status = NC_NOERR;
#line 3501

#line 3501
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3501
	{
#line 3501
		int lstatus = ncx_put_ulonglong_double(xp, tp, fillp);
#line 3501
		if (status == NC_NOERR) /* report the first encountered error */
#line 3501
			status = lstatus;
#line 3501
	}
#line 3501

#line 3501
	*xpp = (void *)xp;
#line 3501
	return status;
#line 3501
#endif
#line 3501
}
#line 3501

int
#line 3502
ncx_putn_ulonglong_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3502
{
#line 3502
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3502

#line 3502
 /* basic algorithm is:
#line 3502
  *   - ensure sane alignment of output data
#line 3502
  *   - copy (conversion happens automatically) input data
#line 3502
  *     to output
#line 3502
  *   - update tp to point at next unconverted input, and xpp to point
#line 3502
  *     at next location for converted output
#line 3502
  */
#line 3502
  long i, j, ni;
#line 3502
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3502
  uint64 *xp;
#line 3502
  int nrange = 0;         /* number of range errors */
#line 3502
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3502
  long cxp = (long) *((char**)xpp);
#line 3502

#line 3502
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3502
  /* sjl: manually stripmine so we can limit amount of
#line 3502
   * vector work space reserved to LOOPCNT elements. Also
#line 3502
   * makes vectorisation easy */
#line 3502
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3502
    ni=Min(nelems-j,LOOPCNT);
#line 3502
    if (realign) {
#line 3502
      xp = tmp;
#line 3502
    } else {
#line 3502
      xp = (uint64 *) *xpp;
#line 3502
    }
#line 3502
   /* copy the next block */
#line 3502
#pragma cdir loopcnt=LOOPCNT
#line 3502
#pragma cdir shortloop
#line 3502
    for (i=0; i<ni; i++) {
#line 3502
      /* the normal case: */
#line 3502
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3502
     /* test for range errors (not always needed but do it anyway) */
#line 3502
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3502
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3502
      nrange += tp[i] > X_UINT64_MAX || tp[i] < 0;
#line 3502
    }
#line 3502
   /* copy workspace back if necessary */
#line 3502
    if (realign) {
#line 3502
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3502
      xp = (uint64 *) *xpp;
#line 3502
    }
#line 3502
   /* update xpp and tp */
#line 3502
    xp += ni;
#line 3502
    tp += ni;
#line 3502
    *xpp = (void*)xp;
#line 3502
  }
#line 3502
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3502

#line 3502
#else   /* not SX */
#line 3502

#line 3502
	char *xp = (char *) *xpp;
#line 3502
	int status = NC_NOERR;
#line 3502

#line 3502
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3502
	{
#line 3502
		int lstatus = ncx_put_ulonglong_longlong(xp, tp, fillp);
#line 3502
		if (status == NC_NOERR) /* report the first encountered error */
#line 3502
			status = lstatus;
#line 3502
	}
#line 3502

#line 3502
	*xpp = (void *)xp;
#line 3502
	return status;
#line 3502
#endif
#line 3502
}
#line 3502

int
#line 3503
ncx_putn_ulonglong_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3503
{
#line 3503
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3503

#line 3503
 /* basic algorithm is:
#line 3503
  *   - ensure sane alignment of output data
#line 3503
  *   - copy (conversion happens automatically) input data
#line 3503
  *     to output
#line 3503
  *   - update tp to point at next unconverted input, and xpp to point
#line 3503
  *     at next location for converted output
#line 3503
  */
#line 3503
  long i, j, ni;
#line 3503
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3503
  uint64 *xp;
#line 3503
  int nrange = 0;         /* number of range errors */
#line 3503
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3503
  long cxp = (long) *((char**)xpp);
#line 3503

#line 3503
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3503
  /* sjl: manually stripmine so we can limit amount of
#line 3503
   * vector work space reserved to LOOPCNT elements. Also
#line 3503
   * makes vectorisation easy */
#line 3503
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3503
    ni=Min(nelems-j,LOOPCNT);
#line 3503
    if (realign) {
#line 3503
      xp = tmp;
#line 3503
    } else {
#line 3503
      xp = (uint64 *) *xpp;
#line 3503
    }
#line 3503
   /* copy the next block */
#line 3503
#pragma cdir loopcnt=LOOPCNT
#line 3503
#pragma cdir shortloop
#line 3503
    for (i=0; i<ni; i++) {
#line 3503
      /* the normal case: */
#line 3503
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3503
     /* test for range errors (not always needed but do it anyway) */
#line 3503
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3503
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3503
      nrange += tp[i] > X_UINT64_MAX ;
#line 3503
    }
#line 3503
   /* copy workspace back if necessary */
#line 3503
    if (realign) {
#line 3503
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3503
      xp = (uint64 *) *xpp;
#line 3503
    }
#line 3503
   /* update xpp and tp */
#line 3503
    xp += ni;
#line 3503
    tp += ni;
#line 3503
    *xpp = (void*)xp;
#line 3503
  }
#line 3503
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3503

#line 3503
#else   /* not SX */
#line 3503

#line 3503
	char *xp = (char *) *xpp;
#line 3503
	int status = NC_NOERR;
#line 3503

#line 3503
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3503
	{
#line 3503
		int lstatus = ncx_put_ulonglong_uchar(xp, tp, fillp);
#line 3503
		if (status == NC_NOERR) /* report the first encountered error */
#line 3503
			status = lstatus;
#line 3503
	}
#line 3503

#line 3503
	*xpp = (void *)xp;
#line 3503
	return status;
#line 3503
#endif
#line 3503
}
#line 3503

int
#line 3504
ncx_putn_ulonglong_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3504
{
#line 3504
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3504

#line 3504
 /* basic algorithm is:
#line 3504
  *   - ensure sane alignment of output data
#line 3504
  *   - copy (conversion happens automatically) input data
#line 3504
  *     to output
#line 3504
  *   - update tp to point at next unconverted input, and xpp to point
#line 3504
  *     at next location for converted output
#line 3504
  */
#line 3504
  long i, j, ni;
#line 3504
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3504
  uint64 *xp;
#line 3504
  int nrange = 0;         /* number of range errors */
#line 3504
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3504
  long cxp = (long) *((char**)xpp);
#line 3504

#line 3504
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3504
  /* sjl: manually stripmine so we can limit amount of
#line 3504
   * vector work space reserved to LOOPCNT elements. Also
#line 3504
   * makes vectorisation easy */
#line 3504
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3504
    ni=Min(nelems-j,LOOPCNT);
#line 3504
    if (realign) {
#line 3504
      xp = tmp;
#line 3504
    } else {
#line 3504
      xp = (uint64 *) *xpp;
#line 3504
    }
#line 3504
   /* copy the next block */
#line 3504
#pragma cdir loopcnt=LOOPCNT
#line 3504
#pragma cdir shortloop
#line 3504
    for (i=0; i<ni; i++) {
#line 3504
      /* the normal case: */
#line 3504
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3504
     /* test for range errors (not always needed but do it anyway) */
#line 3504
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3504
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3504
      nrange += tp[i] > X_UINT64_MAX ;
#line 3504
    }
#line 3504
   /* copy workspace back if necessary */
#line 3504
    if (realign) {
#line 3504
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3504
      xp = (uint64 *) *xpp;
#line 3504
    }
#line 3504
   /* update xpp and tp */
#line 3504
    xp += ni;
#line 3504
    tp += ni;
#line 3504
    *xpp = (void*)xp;
#line 3504
  }
#line 3504
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3504

#line 3504
#else   /* not SX */
#line 3504

#line 3504
	char *xp = (char *) *xpp;
#line 3504
	int status = NC_NOERR;
#line 3504

#line 3504
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3504
	{
#line 3504
		int lstatus = ncx_put_ulonglong_ushort(xp, tp, fillp);
#line 3504
		if (status == NC_NOERR) /* report the first encountered error */
#line 3504
			status = lstatus;
#line 3504
	}
#line 3504

#line 3504
	*xpp = (void *)xp;
#line 3504
	return status;
#line 3504
#endif
#line 3504
}
#line 3504

int
#line 3505
ncx_putn_ulonglong_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3505
{
#line 3505
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3505

#line 3505
 /* basic algorithm is:
#line 3505
  *   - ensure sane alignment of output data
#line 3505
  *   - copy (conversion happens automatically) input data
#line 3505
  *     to output
#line 3505
  *   - update tp to point at next unconverted input, and xpp to point
#line 3505
  *     at next location for converted output
#line 3505
  */
#line 3505
  long i, j, ni;
#line 3505
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3505
  uint64 *xp;
#line 3505
  int nrange = 0;         /* number of range errors */
#line 3505
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3505
  long cxp = (long) *((char**)xpp);
#line 3505

#line 3505
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3505
  /* sjl: manually stripmine so we can limit amount of
#line 3505
   * vector work space reserved to LOOPCNT elements. Also
#line 3505
   * makes vectorisation easy */
#line 3505
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3505
    ni=Min(nelems-j,LOOPCNT);
#line 3505
    if (realign) {
#line 3505
      xp = tmp;
#line 3505
    } else {
#line 3505
      xp = (uint64 *) *xpp;
#line 3505
    }
#line 3505
   /* copy the next block */
#line 3505
#pragma cdir loopcnt=LOOPCNT
#line 3505
#pragma cdir shortloop
#line 3505
    for (i=0; i<ni; i++) {
#line 3505
      /* the normal case: */
#line 3505
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3505
     /* test for range errors (not always needed but do it anyway) */
#line 3505
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3505
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3505
      nrange += tp[i] > X_UINT64_MAX ;
#line 3505
    }
#line 3505
   /* copy workspace back if necessary */
#line 3505
    if (realign) {
#line 3505
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3505
      xp = (uint64 *) *xpp;
#line 3505
    }
#line 3505
   /* update xpp and tp */
#line 3505
    xp += ni;
#line 3505
    tp += ni;
#line 3505
    *xpp = (void*)xp;
#line 3505
  }
#line 3505
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3505

#line 3505
#else   /* not SX */
#line 3505

#line 3505
	char *xp = (char *) *xpp;
#line 3505
	int status = NC_NOERR;
#line 3505

#line 3505
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3505
	{
#line 3505
		int lstatus = ncx_put_ulonglong_uint(xp, tp, fillp);
#line 3505
		if (status == NC_NOERR) /* report the first encountered error */
#line 3505
			status = lstatus;
#line 3505
	}
#line 3505

#line 3505
	*xpp = (void *)xp;
#line 3505
	return status;
#line 3505
#endif
#line 3505
}
#line 3505



/*
 * Other aggregate conversion functions.
 */

/* text */

int
ncx_getn_text(const void **xpp, size_t nelems, char *tp)
{
	(void) memcpy(tp, *xpp, (size_t)nelems);
#line 3517
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3517
	return NC_NOERR;
#line 3517

}

int
ncx_pad_getn_text(const void **xpp, size_t nelems, char *tp)
{
	size_t rndup = nelems % X_ALIGN;
#line 3523

#line 3523
	if (rndup)
#line 3523
		rndup = X_ALIGN - rndup;
#line 3523

#line 3523
	(void) memcpy(tp, *xpp, (size_t)nelems);
#line 3523
	*xpp = (void *)((char *)(*xpp) + nelems + rndup);
#line 3523

#line 3523
	return NC_NOERR;
#line 3523

}

int
ncx_putn_text(void **xpp, size_t nelems, const char *tp)
{
	(void) memcpy(*xpp, tp, (size_t)nelems);
#line 3529
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3529

#line 3529
	return NC_NOERR;
#line 3529

}

int
ncx_pad_putn_text(void **xpp, size_t nelems, const char *tp)
{
	size_t rndup = nelems % X_ALIGN;
#line 3535

#line 3535
	if (rndup)
#line 3535
		rndup = X_ALIGN - rndup;
#line 3535

#line 3535
	(void) memcpy(*xpp, tp, (size_t)nelems);
#line 3535
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3535

#line 3535
	if (rndup)
#line 3535
	{
#line 3535
		(void) memcpy(*xpp, nada, (size_t)rndup);
#line 3535
		*xpp = (void *)((char *)(*xpp) + rndup);
#line 3535
	}
#line 3535

#line 3535
	return NC_NOERR;
#line 3535

}


/* opaque */

int
ncx_getn_void(const void **xpp, size_t nelems, void *tp)
{
	(void) memcpy(tp, *xpp, (size_t)nelems);
#line 3544
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3544
	return NC_NOERR;
#line 3544

}

int
ncx_pad_getn_void(const void **xpp, size_t nelems, void *tp)
{
	size_t rndup = nelems % X_ALIGN;
#line 3550

#line 3550
	if (rndup)
#line 3550
		rndup = X_ALIGN - rndup;
#line 3550

#line 3550
	(void) memcpy(tp, *xpp, (size_t)nelems);
#line 3550
	*xpp = (void *)((char *)(*xpp) + nelems + rndup);
#line 3550

#line 3550
	return NC_NOERR;
#line 3550

}

int
ncx_putn_void(void **xpp, size_t nelems, const void *tp)
{
	(void) memcpy(*xpp, tp, (size_t)nelems);
#line 3556
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3556

#line 3556
	return NC_NOERR;
#line 3556

}

int
ncx_pad_putn_void(void **xpp, size_t nelems, const void *tp)
{
	size_t rndup = nelems % X_ALIGN;
#line 3562

#line 3562
	if (rndup)
#line 3562
		rndup = X_ALIGN - rndup;
#line 3562

#line 3562
	(void) memcpy(*xpp, tp, (size_t)nelems);
#line 3562
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3562

#line 3562
	if (rndup)
#line 3562
	{
#line 3562
		(void) memcpy(*xpp, nada, (size_t)rndup);
#line 3562
		*xpp = (void *)((char *)(*xpp) + rndup);
#line 3562
	}
#line 3562

#line 3562
	return NC_NOERR;
#line 3562

}
