
// $Id: GeneratedKeys.java,v 1.4 2005/03/10 18:38:44 jeffmc Exp $

/*
 * Copyright 1997-2022 Unidata Program Center/University Corporation for
 * Atmospheric Research, P.O. Box 3000, Boulder, CO 80307,
 * support@unidata.ucar.edu.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

package ucar.unidata.gis.geotiff;


/**
 * This class has been generated from the different properties files in the geotiff package (Of Niles Ritter).
 *  It holds the different constant values for geotiffs.
 *
 * @author Unidata development team
 */


public class GeneratedKeys {

    /**
     *  @author IDV development team
     */

    public static class EpsgDatum {

        /** _more_          */
        public static final int DatumE_Airy1830 = 6001;

        /** _more_          */
        public static final int DatumE_AiryModified1849 = 6002;

        /** _more_          */
        public static final int DatumE_AustralianNationalSpheroid = 6003;

        /** _more_          */
        public static final int DatumE_Bessel1841 = 6004;

        /** _more_          */
        public static final int DatumE_BesselModified = 6005;

        /** _more_          */
        public static final int DatumE_BesselNamibia = 6006;

        /** _more_          */
        public static final int DatumE_Clarke1858 = 6007;

        /** _more_          */
        public static final int DatumE_Clarke1866 = 6008;

        /** _more_          */
        public static final int DatumE_Clarke1866Michigan = 6009;

        /** _more_          */
        public static final int DatumE_Clarke1880_Benoit = 6010;

        /** _more_          */
        public static final int DatumE_Clarke1880_IGN = 6011;

        /** _more_          */
        public static final int DatumE_Clarke1880_RGS = 6012;

        /** _more_          */
        public static final int DatumE_Clarke1880_Arc = 6013;

        /** _more_          */
        public static final int DatumE_Clarke1880_SGA1922 = 6014;

        /** _more_          */
        public static final int DatumE_Everest1830_1937Adjustment = 6015;

        /** _more_          */
        public static final int DatumE_Everest1830_1967Definition = 6016;

        /** _more_          */
        public static final int DatumE_Everest1830_1975Definition = 6017;

        /** _more_          */
        public static final int DatumE_Everest1830Modified = 6018;

        /** _more_          */
        public static final int DatumE_GRS1980 = 6019;

        /** _more_          */
        public static final int DatumE_Helmert1906 = 6020;

        /** _more_          */
        public static final int DatumE_IndonesianNationalSpheroid = 6021;

        /** _more_          */
        public static final int DatumE_International1924 = 6022;

        /** _more_          */
        public static final int DatumE_International1967 = 6023;

        /** _more_          */
        public static final int DatumE_Krassowsky1960 = 6024;

        /** _more_          */
        public static final int DatumE_NWL9D = 6025;

        /** _more_          */
        public static final int DatumE_NWL10D = 6026;

        /** _more_          */
        public static final int DatumE_Plessis1817 = 6027;

        /** _more_          */
        public static final int DatumE_Struve1860 = 6028;

        /** _more_          */
        public static final int DatumE_WarOffice = 6029;

        /** _more_          */
        public static final int DatumE_WGS84 = 6030;

        /** _more_          */
        public static final int DatumE_GEM10C = 6031;

        /** _more_          */
        public static final int DatumE_OSU86F = 6032;

        /** _more_          */
        public static final int DatumE_OSU91A = 6033;

        /** _more_          */
        public static final int DatumE_Clarke1880 = 6034;

        /** _more_          */
        public static final int DatumE_Sphere = 6035;

        /** _more_          */
        public static final int Datum_Adindan = 6201;

        /** _more_          */
        public static final int Datum_Australian_Geodetic_Datum_1966 = 6202;

        /** _more_          */
        public static final int Datum_Australian_Geodetic_Datum_1984 = 6203;

        /** _more_          */
        public static final int Datum_Ain_el_Abd_1970 = 6204;

        /** _more_          */
        public static final int Datum_Afgooye = 6205;

        /** _more_          */
        public static final int Datum_Agadez = 6206;

        /** _more_          */
        public static final int Datum_Lisbon = 6207;

        /** _more_          */
        public static final int Datum_Aratu = 6208;

        /** _more_          */
        public static final int Datum_Arc_1950 = 6209;

        /** _more_          */
        public static final int Datum_Arc_1960 = 6210;

        /** _more_          */
        public static final int Datum_Batavia = 6211;

        /** _more_          */
        public static final int Datum_Barbados = 6212;

        /** _more_          */
        public static final int Datum_Beduaram = 6213;

        /** _more_          */
        public static final int Datum_Beijing_1954 = 6214;

        /** _more_          */
        public static final int Datum_Reseau_National_Belge_1950 = 6215;

        /** _more_          */
        public static final int Datum_Bermuda_1957 = 6216;

        /** _more_          */
        public static final int Datum_Bern_1898 = 6217;

        /** _more_          */
        public static final int Datum_Bogota = 6218;

        /** _more_          */
        public static final int Datum_Bukit_Rimpah = 6219;

        /** _more_          */
        public static final int Datum_Camacupa = 6220;

        /** _more_          */
        public static final int Datum_Campo_Inchauspe = 6221;

        /** _more_          */
        public static final int Datum_Cape = 6222;

        /** _more_          */
        public static final int Datum_Carthage = 6223;

        /** _more_          */
        public static final int Datum_Chua = 6224;

        /** _more_          */
        public static final int Datum_Corrego_Alegre = 6225;

        /** _more_          */
        public static final int Datum_Cote_d_Ivoire = 6226;

        /** _more_          */
        public static final int Datum_Deir_ez_Zor = 6227;

        /** _more_          */
        public static final int Datum_Douala = 6228;

        /** _more_          */
        public static final int Datum_Egypt_1907 = 6229;

        /** _more_          */
        public static final int Datum_European_Datum_1950 = 6230;

        /** _more_          */
        public static final int Datum_European_Datum_1987 = 6231;

        /** _more_          */
        public static final int Datum_Fahud = 6232;

        /** _more_          */
        public static final int Datum_Gandajika_1970 = 6233;

        /** _more_          */
        public static final int Datum_Garoua = 6234;

        /** _more_          */
        public static final int Datum_Guyane_Francaise = 6235;

        /** _more_          */
        public static final int Datum_Hu_Tzu_Shan = 6236;

        /** _more_          */
        public static final int Datum_Hungarian_Datum_1972 = 6237;

        /** _more_          */
        public static final int Datum_Indonesian_Datum_1974 = 6238;

        /** _more_          */
        public static final int Datum_Indian_1954 = 6239;

        /** _more_          */
        public static final int Datum_Indian_1975 = 6240;

        /** _more_          */
        public static final int Datum_Jamaica_1875 = 6241;

        /** _more_          */
        public static final int Datum_Jamaica_1969 = 6242;

        /** _more_          */
        public static final int Datum_Kalianpur = 6243;

        /** _more_          */
        public static final int Datum_Kandawala = 6244;

        /** _more_          */
        public static final int Datum_Kertau = 6245;

        /** _more_          */
        public static final int Datum_Kuwait_Oil_Company = 6246;

        /** _more_          */
        public static final int Datum_La_Canoa = 6247;

        /** _more_          */
        public static final int Datum_Provisional_S_American_Datum_1956 =
            6248;

        /** _more_          */
        public static final int Datum_Lake = 6249;

        /** _more_          */
        public static final int Datum_Leigon = 6250;

        /** _more_          */
        public static final int Datum_Liberia_1964 = 6251;

        /** _more_          */
        public static final int Datum_Lome = 6252;

        /** _more_          */
        public static final int Datum_Luzon_1911 = 6253;

        /** _more_          */
        public static final int Datum_Hito_XVIII_1963 = 6254;

        /** _more_          */
        public static final int Datum_Herat_North = 6255;

        /** _more_          */
        public static final int Datum_Mahe_1971 = 6256;

        /** _more_          */
        public static final int Datum_Makassar = 6257;

        /** _more_          */
        public static final int Datum_European_Reference_System_1989 = 6258;

        /** _more_          */
        public static final int Datum_Malongo_1987 = 6259;

        /** _more_          */
        public static final int Datum_Manoca = 6260;

        /** _more_          */
        public static final int Datum_Merchich = 6261;

        /** _more_          */
        public static final int Datum_Massawa = 6262;

        /** _more_          */
        public static final int Datum_Minna = 6263;

        /** _more_          */
        public static final int Datum_Mhast = 6264;

        /** _more_          */
        public static final int Datum_Monte_Mario = 6265;

        /** _more_          */
        public static final int Datum_M_poraloko = 6266;

        /** _more_          */
        public static final int Datum_North_American_Datum_1927 = 6267;

        /** _more_          */
        public static final int Datum_NAD_Michigan = 6268;

        /** _more_          */
        public static final int Datum_North_American_Datum_1983 = 6269;

        /** _more_          */
        public static final int Datum_Nahrwan_1967 = 6270;

        /** _more_          */
        public static final int Datum_Naparima_1972 = 6271;

        /** _more_          */
        public static final int Datum_New_Zealand_Geodetic_Datum_1949 = 6272;

        /** _more_          */
        public static final int Datum_NGO_1948 = 6273;

        /** _more_          */
        public static final int Datum_Datum_73 = 6274;

        /** _more_          */
        public static final int Datum_Nouvelle_Triangulation_Francaise = 6275;

        /** _more_          */
        public static final int Datum_NSWC_9Z_2 = 6276;

        /** _more_          */
        public static final int Datum_OSGB_1936 = 6277;

        /** _more_          */
        public static final int Datum_OSGB_1970_SN = 6278;

        /** _more_          */
        public static final int Datum_OS_SN_1980 = 6279;

        /** _more_          */
        public static final int Datum_Padang_1884 = 6280;

        /** _more_          */
        public static final int Datum_Palestine_1923 = 6281;

        /** _more_          */
        public static final int Datum_Pointe_Noire = 6282;

        /** _more_          */
        public static final int Datum_Geocentric_Datum_of_Australia_1994 =
            6283;

        /** _more_          */
        public static final int Datum_Pulkovo_1942 = 6284;

        /** _more_          */
        public static final int Datum_Qatar = 6285;

        /** _more_          */
        public static final int Datum_Qatar_1948 = 6286;

        /** _more_          */
        public static final int Datum_Qornoq = 6287;

        /** _more_          */
        public static final int Datum_Loma_Quintana = 6288;

        /** _more_          */
        public static final int Datum_Amersfoort = 6289;

        /** _more_          */
        public static final int Datum_RT38 = 6290;

        /** _more_          */
        public static final int Datum_South_American_Datum_1969 = 6291;

        /** _more_          */
        public static final int Datum_Sapper_Hill_1943 = 6292;

        /** _more_          */
        public static final int Datum_Schwarzeck = 6293;

        /** _more_          */
        public static final int Datum_Segora = 6294;

        /** _more_          */
        public static final int Datum_Serindung = 6295;

        /** _more_          */
        public static final int Datum_Sudan = 6296;

        /** _more_          */
        public static final int Datum_Tananarive_1925 = 6297;

        /** _more_          */
        public static final int Datum_Timbalai_1948 = 6298;

        /** _more_          */
        public static final int Datum_TM65 = 6299;

        /** _more_          */
        public static final int Datum_TM75 = 6300;

        /** _more_          */
        public static final int Datum_Tokyo = 6301;

        /** _more_          */
        public static final int Datum_Trinidad_1903 = 6302;

        /** _more_          */
        public static final int Datum_Trucial_Coast_1948 = 6303;

        /** _more_          */
        public static final int Datum_Voirol_1875 = 6304;

        /** _more_          */
        public static final int Datum_Voirol_Unifie_1960 = 6305;

        /** _more_          */
        public static final int Datum_Bern_1938 = 6306;

        /** _more_          */
        public static final int Datum_Nord_Sahara_1959 = 6307;

        /** _more_          */
        public static final int Datum_Stockholm_1938 = 6308;

        /** _more_          */
        public static final int Datum_Yacare = 6309;

        /** _more_          */
        public static final int Datum_Yoff = 6310;

        /** _more_          */
        public static final int Datum_Zanderij = 6311;

        /** _more_          */
        public static final int Datum_Militar_Geographische_Institut = 6312;

        /** _more_          */
        public static final int Datum_Reseau_National_Belge_1972 = 6313;

        /** _more_          */
        public static final int Datum_Deutsche_Hauptdreiecksnetz = 6314;

        /** _more_          */
        public static final int Datum_Conakry_1905 = 6315;

        /** _more_          */
        public static final int Datum_WGS72 = 6322;

        /** _more_          */
        public static final int Datum_WGS72_Transit_Broadcast_Ephemeris =
            6324;

        /** _more_          */
        public static final int Datum_WGS84 = 6326;

        /** _more_          */
        public static final int Datum_Ancienne_Triangulation_Francaise = 6901;

        /** _more_          */
        public static final int Datum_Nord_de_Guerre = 6902;


        /** _more_          */
        public static final int values[] = {
            DatumE_Airy1830, DatumE_AiryModified1849,
            DatumE_AustralianNationalSpheroid, DatumE_Bessel1841,
            DatumE_BesselModified, DatumE_BesselNamibia, DatumE_Clarke1858,
            DatumE_Clarke1866, DatumE_Clarke1866Michigan,
            DatumE_Clarke1880_Benoit, DatumE_Clarke1880_IGN,
            DatumE_Clarke1880_RGS, DatumE_Clarke1880_Arc,
            DatumE_Clarke1880_SGA1922, DatumE_Everest1830_1937Adjustment,
            DatumE_Everest1830_1967Definition,
            DatumE_Everest1830_1975Definition, DatumE_Everest1830Modified,
            DatumE_GRS1980, DatumE_Helmert1906,
            DatumE_IndonesianNationalSpheroid, DatumE_International1924,
            DatumE_International1967, DatumE_Krassowsky1960, DatumE_NWL9D,
            DatumE_NWL10D, DatumE_Plessis1817, DatumE_Struve1860,
            DatumE_WarOffice, DatumE_WGS84, DatumE_GEM10C, DatumE_OSU86F,
            DatumE_OSU91A, DatumE_Clarke1880, DatumE_Sphere, Datum_Adindan,
            Datum_Australian_Geodetic_Datum_1966,
            Datum_Australian_Geodetic_Datum_1984, Datum_Ain_el_Abd_1970,
            Datum_Afgooye, Datum_Agadez, Datum_Lisbon, Datum_Aratu,
            Datum_Arc_1950, Datum_Arc_1960, Datum_Batavia, Datum_Barbados,
            Datum_Beduaram, Datum_Beijing_1954,
            Datum_Reseau_National_Belge_1950, Datum_Bermuda_1957,
            Datum_Bern_1898, Datum_Bogota, Datum_Bukit_Rimpah, Datum_Camacupa,
            Datum_Campo_Inchauspe, Datum_Cape, Datum_Carthage, Datum_Chua,
            Datum_Corrego_Alegre, Datum_Cote_d_Ivoire, Datum_Deir_ez_Zor,
            Datum_Douala, Datum_Egypt_1907, Datum_European_Datum_1950,
            Datum_European_Datum_1987, Datum_Fahud, Datum_Gandajika_1970,
            Datum_Garoua, Datum_Guyane_Francaise, Datum_Hu_Tzu_Shan,
            Datum_Hungarian_Datum_1972, Datum_Indonesian_Datum_1974,
            Datum_Indian_1954, Datum_Indian_1975, Datum_Jamaica_1875,
            Datum_Jamaica_1969, Datum_Kalianpur, Datum_Kandawala,
            Datum_Kertau, Datum_Kuwait_Oil_Company, Datum_La_Canoa,
            Datum_Provisional_S_American_Datum_1956, Datum_Lake, Datum_Leigon,
            Datum_Liberia_1964, Datum_Lome, Datum_Luzon_1911,
            Datum_Hito_XVIII_1963, Datum_Herat_North, Datum_Mahe_1971,
            Datum_Makassar, Datum_European_Reference_System_1989,
            Datum_Malongo_1987, Datum_Manoca, Datum_Merchich, Datum_Massawa,
            Datum_Minna, Datum_Mhast, Datum_Monte_Mario, Datum_M_poraloko,
            Datum_North_American_Datum_1927, Datum_NAD_Michigan,
            Datum_North_American_Datum_1983, Datum_Nahrwan_1967,
            Datum_Naparima_1972, Datum_New_Zealand_Geodetic_Datum_1949,
            Datum_NGO_1948, Datum_Datum_73,
            Datum_Nouvelle_Triangulation_Francaise, Datum_NSWC_9Z_2,
            Datum_OSGB_1936, Datum_OSGB_1970_SN, Datum_OS_SN_1980,
            Datum_Padang_1884, Datum_Palestine_1923, Datum_Pointe_Noire,
            Datum_Geocentric_Datum_of_Australia_1994, Datum_Pulkovo_1942,
            Datum_Qatar, Datum_Qatar_1948, Datum_Qornoq, Datum_Loma_Quintana,
            Datum_Amersfoort, Datum_RT38, Datum_South_American_Datum_1969,
            Datum_Sapper_Hill_1943, Datum_Schwarzeck, Datum_Segora,
            Datum_Serindung, Datum_Sudan, Datum_Tananarive_1925,
            Datum_Timbalai_1948, Datum_TM65, Datum_TM75, Datum_Tokyo,
            Datum_Trinidad_1903, Datum_Trucial_Coast_1948, Datum_Voirol_1875,
            Datum_Voirol_Unifie_1960, Datum_Bern_1938, Datum_Nord_Sahara_1959,
            Datum_Stockholm_1938, Datum_Yacare, Datum_Yoff, Datum_Zanderij,
            Datum_Militar_Geographische_Institut,
            Datum_Reseau_National_Belge_1972,
            Datum_Deutsche_Hauptdreiecksnetz, Datum_Conakry_1905, Datum_WGS72,
            Datum_WGS72_Transit_Broadcast_Ephemeris, Datum_WGS84,
            Datum_Ancienne_Triangulation_Francaise, Datum_Nord_de_Guerre
        };

        /** _more_          */
        public static final String names[] = {
            "DatumE_Airy1830", "DatumE_AiryModified1849",
            "DatumE_AustralianNationalSpheroid", "DatumE_Bessel1841",
            "DatumE_BesselModified", "DatumE_BesselNamibia",
            "DatumE_Clarke1858", "DatumE_Clarke1866",
            "DatumE_Clarke1866Michigan", "DatumE_Clarke1880_Benoit",
            "DatumE_Clarke1880_IGN", "DatumE_Clarke1880_RGS",
            "DatumE_Clarke1880_Arc", "DatumE_Clarke1880_SGA1922",
            "DatumE_Everest1830_1937Adjustment",
            "DatumE_Everest1830_1967Definition",
            "DatumE_Everest1830_1975Definition", "DatumE_Everest1830Modified",
            "DatumE_GRS1980", "DatumE_Helmert1906",
            "DatumE_IndonesianNationalSpheroid", "DatumE_International1924",
            "DatumE_International1967", "DatumE_Krassowsky1960",
            "DatumE_NWL9D", "DatumE_NWL10D", "DatumE_Plessis1817",
            "DatumE_Struve1860", "DatumE_WarOffice", "DatumE_WGS84",
            "DatumE_GEM10C", "DatumE_OSU86F", "DatumE_OSU91A",
            "DatumE_Clarke1880", "DatumE_Sphere", "Datum_Adindan",
            "Datum_Australian_Geodetic_Datum_1966",
            "Datum_Australian_Geodetic_Datum_1984", "Datum_Ain_el_Abd_1970",
            "Datum_Afgooye", "Datum_Agadez", "Datum_Lisbon", "Datum_Aratu",
            "Datum_Arc_1950", "Datum_Arc_1960", "Datum_Batavia",
            "Datum_Barbados", "Datum_Beduaram", "Datum_Beijing_1954",
            "Datum_Reseau_National_Belge_1950", "Datum_Bermuda_1957",
            "Datum_Bern_1898", "Datum_Bogota", "Datum_Bukit_Rimpah",
            "Datum_Camacupa", "Datum_Campo_Inchauspe", "Datum_Cape",
            "Datum_Carthage", "Datum_Chua", "Datum_Corrego_Alegre",
            "Datum_Cote_d_Ivoire", "Datum_Deir_ez_Zor", "Datum_Douala",
            "Datum_Egypt_1907", "Datum_European_Datum_1950",
            "Datum_European_Datum_1987", "Datum_Fahud",
            "Datum_Gandajika_1970", "Datum_Garoua", "Datum_Guyane_Francaise",
            "Datum_Hu_Tzu_Shan", "Datum_Hungarian_Datum_1972",
            "Datum_Indonesian_Datum_1974", "Datum_Indian_1954",
            "Datum_Indian_1975", "Datum_Jamaica_1875", "Datum_Jamaica_1969",
            "Datum_Kalianpur", "Datum_Kandawala", "Datum_Kertau",
            "Datum_Kuwait_Oil_Company", "Datum_La_Canoa",
            "Datum_Provisional_S_American_Datum_1956", "Datum_Lake",
            "Datum_Leigon", "Datum_Liberia_1964", "Datum_Lome",
            "Datum_Luzon_1911", "Datum_Hito_XVIII_1963", "Datum_Herat_North",
            "Datum_Mahe_1971", "Datum_Makassar",
            "Datum_European_Reference_System_1989", "Datum_Malongo_1987",
            "Datum_Manoca", "Datum_Merchich", "Datum_Massawa", "Datum_Minna",
            "Datum_Mhast", "Datum_Monte_Mario", "Datum_M_poraloko",
            "Datum_North_American_Datum_1927", "Datum_NAD_Michigan",
            "Datum_North_American_Datum_1983", "Datum_Nahrwan_1967",
            "Datum_Naparima_1972", "Datum_New_Zealand_Geodetic_Datum_1949",
            "Datum_NGO_1948", "Datum_Datum_73",
            "Datum_Nouvelle_Triangulation_Francaise", "Datum_NSWC_9Z_2",
            "Datum_OSGB_1936", "Datum_OSGB_1970_SN", "Datum_OS_SN_1980",
            "Datum_Padang_1884", "Datum_Palestine_1923", "Datum_Pointe_Noire",
            "Datum_Geocentric_Datum_of_Australia_1994", "Datum_Pulkovo_1942",
            "Datum_Qatar", "Datum_Qatar_1948", "Datum_Qornoq",
            "Datum_Loma_Quintana", "Datum_Amersfoort", "Datum_RT38",
            "Datum_South_American_Datum_1969", "Datum_Sapper_Hill_1943",
            "Datum_Schwarzeck", "Datum_Segora", "Datum_Serindung",
            "Datum_Sudan", "Datum_Tananarive_1925", "Datum_Timbalai_1948",
            "Datum_TM65", "Datum_TM75", "Datum_Tokyo", "Datum_Trinidad_1903",
            "Datum_Trucial_Coast_1948", "Datum_Voirol_1875",
            "Datum_Voirol_Unifie_1960", "Datum_Bern_1938",
            "Datum_Nord_Sahara_1959", "Datum_Stockholm_1938", "Datum_Yacare",
            "Datum_Yoff", "Datum_Zanderij",
            "Datum_Militar_Geographische_Institut",
            "Datum_Reseau_National_Belge_1972",
            "Datum_Deutsche_Hauptdreiecksnetz", "Datum_Conakry_1905",
            "Datum_WGS72", "Datum_WGS72_Transit_Broadcast_Ephemeris",
            "Datum_WGS84", "Datum_Ancienne_Triangulation_Francaise",
            "Datum_Nord_de_Guerre"
        };

        /**
         * _more_
         *
         * @param value _more_
         *
         * @return _more_
         */
        public static String getName(int value) {
            for (int i = 0; i < values.length; i++) {
                if (values[i] == value) {
                    return names[i];
                }
            }
            return null;
        }
    }



    /**
     *  @author IDV development team
     */

    public static class EpsgEllipse {

        /** _more_          */
        public static final int Airy_1830 = 7001;

        /** _more_          */
        public static final int Airy_Modified_1849 = 7002;

        /** _more_          */
        public static final int Australian_National_Spheroid = 7003;

        /** _more_          */
        public static final int Bessel_1841 = 7004;

        /** _more_          */
        public static final int Bessel_Modified = 7005;

        /** _more_          */
        public static final int Bessel_Namibia = 7006;

        /** _more_          */
        public static final int Clarke_1858 = 7007;

        /** _more_          */
        public static final int Clarke_1866 = 7008;

        /** _more_          */
        public static final int Clarke_1866_Michigan = 7009;

        /** _more_          */
        public static final int Clarke_1880_Benoit = 7010;

        /** _more_          */
        public static final int Clarke_1880_IGN = 7011;

        /** _more_          */
        public static final int Clarke_1880_RGS = 7012;

        /** _more_          */
        public static final int Clarke_1880_Arc = 7013;

        /** _more_          */
        public static final int Clarke_1880_SGA_1922 = 7014;

        /** _more_          */
        public static final int Everest_1830_1937_Adjustment = 7015;

        /** _more_          */
        public static final int Everest_1830_1967_Definition = 7016;

        /** _more_          */
        public static final int Everest_1830_1975_Definition = 7017;

        /** _more_          */
        public static final int Everest_1830_Modified = 7018;

        /** _more_          */
        public static final int GRS_1980 = 7019;

        /** _more_          */
        public static final int Helmert_1906 = 7020;

        /** _more_          */
        public static final int Indonesian_National_Spheroid = 7021;

        /** _more_          */
        public static final int International_1924 = 7022;

        /** _more_          */
        public static final int International_1967 = 7023;

        /** _more_          */
        public static final int Krassowsky_1940 = 7024;

        /** _more_          */
        public static final int NWL_9D = 7025;

        /** _more_          */
        public static final int NWL_10D = 7026;

        /** _more_          */
        public static final int Plessis_1817 = 7027;

        /** _more_          */
        public static final int Struve_1860 = 7028;

        /** _more_          */
        public static final int War_Office = 7029;

        /** _more_          */
        public static final int WGS_84 = 7030;

        /** _more_          */
        public static final int GEM_10C = 7031;

        /** _more_          */
        public static final int OSU86F = 7032;

        /** _more_          */
        public static final int OSU91A = 7033;

        /** _more_          */
        public static final int Clarke_1880 = 7034;

        /** _more_          */
        public static final int Sphere = 7035;


        /** _more_          */
        public static final int values[] = {
            Airy_1830, Airy_Modified_1849, Australian_National_Spheroid,
            Bessel_1841, Bessel_Modified, Bessel_Namibia, Clarke_1858,
            Clarke_1866, Clarke_1866_Michigan, Clarke_1880_Benoit,
            Clarke_1880_IGN, Clarke_1880_RGS, Clarke_1880_Arc,
            Clarke_1880_SGA_1922, Everest_1830_1937_Adjustment,
            Everest_1830_1967_Definition, Everest_1830_1975_Definition,
            Everest_1830_Modified, GRS_1980, Helmert_1906,
            Indonesian_National_Spheroid, International_1924,
            International_1967, Krassowsky_1940, NWL_9D, NWL_10D,
            Plessis_1817, Struve_1860, War_Office, WGS_84, GEM_10C, OSU86F,
            OSU91A, Clarke_1880, Sphere
        };

        /** _more_          */
        public static final String names[] = {
            "Ellipse_Airy_1830", "Ellipse_Airy_Modified_1849",
            "Ellipse_Australian_National_Spheroid", "Ellipse_Bessel_1841",
            "Ellipse_Bessel_Modified", "Ellipse_Bessel_Namibia",
            "Ellipse_Clarke_1858", "Ellipse_Clarke_1866",
            "Ellipse_Clarke_1866_Michigan", "Ellipse_Clarke_1880_Benoit",
            "Ellipse_Clarke_1880_IGN", "Ellipse_Clarke_1880_RGS",
            "Ellipse_Clarke_1880_Arc", "Ellipse_Clarke_1880_SGA_1922",
            "Ellipse_Everest_1830_1937_Adjustment",
            "Ellipse_Everest_1830_1967_Definition",
            "Ellipse_Everest_1830_1975_Definition",
            "Ellipse_Everest_1830_Modified", "Ellipse_GRS_1980",
            "Ellipse_Helmert_1906", "Ellipse_Indonesian_National_Spheroid",
            "Ellipse_International_1924", "Ellipse_International_1967",
            "Ellipse_Krassowsky_1940", "Ellipse_NWL_9D", "Ellipse_NWL_10D",
            "Ellipse_Plessis_1817", "Ellipse_Struve_1860",
            "Ellipse_War_Office", "Ellipse_WGS_84", "Ellipse_GEM_10C",
            "Ellipse_OSU86F", "Ellipse_OSU91A", "Ellipse_Clarke_1880",
            "Ellipse_Sphere"
        };

        /**
         * _more_
         *
         * @param value _more_
         *
         * @return _more_
         */
        public static String getName(int value) {
            for (int i = 0; i < values.length; i++) {
                if (values[i] == value) {
                    return names[i];
                }
            }
            return null;
        }
    }



    /**
     *  @author IDV development team
     */

    public static class EpsgGcs {

        /** _more_          */
        public static final int Airy1830 = 4001;

        /** _more_          */
        public static final int AiryModified1849 = 4002;

        /** _more_          */
        public static final int AustralianNationalSpheroid = 4003;

        /** _more_          */
        public static final int Bessel1841 = 4004;

        /** _more_          */
        public static final int BesselModified = 4005;

        /** _more_          */
        public static final int BesselNamibia = 4006;

        /** _more_          */
        public static final int Clarke1858 = 4007;

        /** _more_          */
        public static final int Clarke1866 = 4008;

        /** _more_          */
        public static final int Clarke1866Michigan = 4009;

        /** _more_          */
        public static final int Clarke1880_Benoit = 4010;

        /** _more_          */
        public static final int Clarke1880_IGN = 4011;

        /** _more_          */
        public static final int Clarke1880_RGS = 4012;

        /** _more_          */
        public static final int Clarke1880_Arc = 4013;

        /** _more_          */
        public static final int Clarke1880_SGA1922 = 4014;

        /** _more_          */
        public static final int Everest1830_1937Adjustment = 4015;

        /** _more_          */
        public static final int Everest1830_1967Definition = 4016;

        /** _more_          */
        public static final int Everest1830_1975Definition = 4017;

        /** _more_          */
        public static final int Everest1830Modified = 4018;

        /** _more_          */
        public static final int GRS1980 = 4019;

        /** _more_          */
        public static final int Helmert1906 = 4020;

        /** _more_          */
        public static final int IndonesianNationalSpheroid = 4021;

        /** _more_          */
        public static final int International1924 = 4022;

        /** _more_          */
        public static final int International1967 = 4023;

        /** _more_          */
        public static final int Krassowsky1940 = 4024;

        /** _more_          */
        public static final int NWL9D = 4025;

        /** _more_          */
        public static final int NWL10D = 4026;

        /** _more_          */
        public static final int Plessis1817 = 4027;

        /** _more_          */
        public static final int Struve1860 = 4028;

        /** _more_          */
        public static final int WarOffice = 4029;

        /** _more_          */
        public static final int WGS84 = 4030;

        /** _more_          */
        public static final int GEM10C = 4031;

        /** _more_          */
        public static final int OSU86F = 4032;

        /** _more_          */
        public static final int OSU91A = 4033;

        /** _more_          */
        public static final int Clarke1880 = 4034;

        /** _more_          */
        public static final int Sphere = 4035;

        /** _more_          */
        public static final int GCS_Adindan = 4201;

        /** _more_          */
        public static final int GCS_AGD66 = 4202;

        /** _more_          */
        public static final int GCS_AGD84 = 4203;

        /** _more_          */
        public static final int GCS_Ain_el_Abd = 4204;

        /** _more_          */
        public static final int GCS_Afgooye = 4205;

        /** _more_          */
        public static final int GCS_Agadez = 4206;

        /** _more_          */
        public static final int GCS_Lisbon = 4207;

        /** _more_          */
        public static final int GCS_Aratu = 4208;

        /** _more_          */
        public static final int GCS_Arc_1950 = 4209;

        /** _more_          */
        public static final int GCS_Arc_1960 = 4210;

        /** _more_          */
        public static final int GCS_Batavia = 4211;

        /** _more_          */
        public static final int GCS_Barbados = 4212;

        /** _more_          */
        public static final int GCS_Beduaram = 4213;

        /** _more_          */
        public static final int GCS_Beijing_1954 = 4214;

        /** _more_          */
        public static final int GCS_Belge_1950 = 4215;

        /** _more_          */
        public static final int GCS_Bermuda_1957 = 4216;

        /** _more_          */
        public static final int GCS_Bern_1898 = 4217;

        /** _more_          */
        public static final int GCS_Bogota = 4218;

        /** _more_          */
        public static final int GCS_Bukit_Rimpah = 4219;

        /** _more_          */
        public static final int GCS_Camacupa = 4220;

        /** _more_          */
        public static final int GCS_Campo_Inchauspe = 4221;

        /** _more_          */
        public static final int GCS_Cape = 4222;

        /** _more_          */
        public static final int GCS_Carthage = 4223;

        /** _more_          */
        public static final int GCS_Chua = 4224;

        /** _more_          */
        public static final int GCS_Corrego_Alegre = 4225;

        /** _more_          */
        public static final int GCS_Cote_d_Ivoire = 4226;

        /** _more_          */
        public static final int GCS_Deir_ez_Zor = 4227;

        /** _more_          */
        public static final int GCS_Douala = 4228;

        /** _more_          */
        public static final int GCS_Egypt_1907 = 4229;

        /** _more_          */
        public static final int GCS_ED50 = 4230;

        /** _more_          */
        public static final int GCS_ED87 = 4231;

        /** _more_          */
        public static final int GCS_Fahud = 4232;

        /** _more_          */
        public static final int GCS_Gandajika_1970 = 4233;

        /** _more_          */
        public static final int GCS_Garoua = 4234;

        /** _more_          */
        public static final int GCS_Guyane_Francaise = 4235;

        /** _more_          */
        public static final int GCS_Hu_Tzu_Shan = 4236;

        /** _more_          */
        public static final int GCS_HD72 = 4237;

        /** _more_          */
        public static final int GCS_ID74 = 4238;

        /** _more_          */
        public static final int GCS_Indian_1954 = 4239;

        /** _more_          */
        public static final int GCS_Indian_1975 = 4240;

        /** _more_          */
        public static final int GCS_Jamaica_1875 = 4241;

        /** _more_          */
        public static final int GCS_JAD69 = 4242;

        /** _more_          */
        public static final int GCS_Kalianpur = 4243;

        /** _more_          */
        public static final int GCS_Kandawala = 4244;

        /** _more_          */
        public static final int GCS_Kertau = 4245;

        /** _more_          */
        public static final int GCS_KOC = 4246;

        /** _more_          */
        public static final int GCS_La_Canoa = 4247;

        /** _more_          */
        public static final int GCS_PSAD56 = 4248;

        /** _more_          */
        public static final int GCS_Lake = 4249;

        /** _more_          */
        public static final int GCS_Leigon = 4250;

        /** _more_          */
        public static final int GCS_Liberia_1964 = 4251;

        /** _more_          */
        public static final int GCS_Lome = 4252;

        /** _more_          */
        public static final int GCS_Luzon_1911 = 4253;

        /** _more_          */
        public static final int GCS_Hito_XVIII_1963 = 4254;

        /** _more_          */
        public static final int GCS_Herat_North = 4255;

        /** _more_          */
        public static final int GCS_Mahe_1971 = 4256;

        /** _more_          */
        public static final int GCS_Makassar = 4257;

        /** _more_          */
        public static final int GCS_EUREF89 = 4258;

        /** _more_          */
        public static final int GCS_Malongo_1987 = 4259;

        /** _more_          */
        public static final int GCS_Manoca = 4260;

        /** _more_          */
        public static final int GCS_Merchich = 4261;

        /** _more_          */
        public static final int GCS_Massawa = 4262;

        /** _more_          */
        public static final int GCS_Minna = 4263;

        /** _more_          */
        public static final int GCS_Mhast = 4264;

        /** _more_          */
        public static final int GCS_Monte_Mario = 4265;

        /** _more_          */
        public static final int GCS_M_poraloko = 4266;

        /** _more_          */
        public static final int GCS_NAD27 = 4267;

        /** _more_          */
        public static final int GCS_NAD_Michigan = 4268;

        /** _more_          */
        public static final int GCS_NAD83 = 4269;

        /** _more_          */
        public static final int GCS_Nahrwan_1967 = 4270;

        /** _more_          */
        public static final int GCS_Naparima_1972 = 4271;

        /** _more_          */
        public static final int GCS_GD49 = 4272;

        /** _more_          */
        public static final int GCS_NGO_1948 = 4273;

        /** _more_          */
        public static final int GCS_Datum_73 = 4274;

        /** _more_          */
        public static final int GCS_NTF = 4275;

        /** _more_          */
        public static final int GCS_NSWC_9Z_2 = 4276;

        /** _more_          */
        public static final int GCS_OSGB_1936 = 4277;

        /** _more_          */
        public static final int GCS_OSGB70 = 4278;

        /** _more_          */
        public static final int GCS_OS_SN80 = 4279;

        /** _more_          */
        public static final int GCS_Padang = 4280;

        /** _more_          */
        public static final int GCS_Palestine_1923 = 4281;

        /** _more_          */
        public static final int GCS_Pointe_Noire = 4282;

        /** _more_          */
        public static final int GCS_GDA94 = 4283;

        /** _more_          */
        public static final int GCS_Pulkovo_1942 = 4284;

        /** _more_          */
        public static final int GCS_Qatar = 4285;

        /** _more_          */
        public static final int GCS_Qatar_1948 = 4286;

        /** _more_          */
        public static final int GCS_Qornoq = 4287;

        /** _more_          */
        public static final int GCS_Loma_Quintana = 4288;

        /** _more_          */
        public static final int GCS_Amersfoort = 4289;

        /** _more_          */
        public static final int GCS_RT38 = 4290;

        /** _more_          */
        public static final int GCS_SAD69 = 4291;

        /** _more_          */
        public static final int GCS_Sapper_Hill_1943 = 4292;

        /** _more_          */
        public static final int GCS_Schwarzeck = 4293;

        /** _more_          */
        public static final int GCS_Segora = 4294;

        /** _more_          */
        public static final int GCS_Serindung = 4295;

        /** _more_          */
        public static final int GCS_Sudan = 4296;

        /** _more_          */
        public static final int GCS_Tananarive = 4297;

        /** _more_          */
        public static final int GCS_Timbalai_1948 = 4298;

        /** _more_          */
        public static final int GCS_TM65 = 4299;

        /** _more_          */
        public static final int GCS_TM75 = 4300;

        /** _more_          */
        public static final int GCS_Tokyo = 4301;

        /** _more_          */
        public static final int GCS_Trinidad_1903 = 4302;

        /** _more_          */
        public static final int GCS_TC_1948 = 4303;

        /** _more_          */
        public static final int GCS_Voirol_1875 = 4304;

        /** _more_          */
        public static final int GCS_Voirol_Unifie = 4305;

        /** _more_          */
        public static final int GCS_Bern_1938 = 4306;

        /** _more_          */
        public static final int GCS_Nord_Sahara_1959 = 4307;

        /** _more_          */
        public static final int GCS_Stockholm_1938 = 4308;

        /** _more_          */
        public static final int GCS_Yacare = 4309;

        /** _more_          */
        public static final int GCS_Yoff = 4310;

        /** _more_          */
        public static final int GCS_Zanderij = 4311;

        /** _more_          */
        public static final int GCS_MGI = 4312;

        /** _more_          */
        public static final int GCS_Belge_1972 = 4313;

        /** _more_          */
        public static final int GCS_DHDN = 4314;

        /** _more_          */
        public static final int GCS_Conakry_1905 = 4315;

        /** _more_          */
        public static final int GCS_WGS_72 = 4322;

        /** _more_          */
        public static final int GCS_WGS_72BE = 4324;

        /** _more_          */
        public static final int GCS_WGS_84 = 4326;

        /** _more_          */
        public static final int GCS_Bern_1898_Bern = 4801;

        /** _more_          */
        public static final int GCS_Bogota_Bogota = 4802;

        /** _more_          */
        public static final int GCS_Lisbon_Lisbon = 4803;

        /** _more_          */
        public static final int GCS_Makassar_Jakarta = 4804;

        /** _more_          */
        public static final int GCS_MGI_Ferro = 4805;

        /** _more_          */
        public static final int GCS_Monte_Mario_Rome = 4806;

        /** _more_          */
        public static final int GCS_NTF_Paris = 4807;

        /** _more_          */
        public static final int GCS_Padang_Jakarta = 4808;

        /** _more_          */
        public static final int GCS_Belge_1950_Brussels = 4809;

        /** _more_          */
        public static final int GCS_Tananarive_Paris = 4810;

        /** _more_          */
        public static final int GCS_Voirol_1875_Paris = 4811;

        /** _more_          */
        public static final int GCS_Voirol_Unifie_Paris = 4812;

        /** _more_          */
        public static final int GCS_Batavia_Jakarta = 4813;

        /** _more_          */
        public static final int GCS_ATF_Paris = 4901;

        /** _more_          */
        public static final int GCS_NDG_Paris = 4902;


        /** _more_          */
        public static final int values[] = {
            Airy1830, AiryModified1849, AustralianNationalSpheroid,
            Bessel1841, BesselModified, BesselNamibia, Clarke1858, Clarke1866,
            Clarke1866Michigan, Clarke1880_Benoit, Clarke1880_IGN,
            Clarke1880_RGS, Clarke1880_Arc, Clarke1880_SGA1922,
            Everest1830_1937Adjustment, Everest1830_1967Definition,
            Everest1830_1975Definition, Everest1830Modified, GRS1980,
            Helmert1906, IndonesianNationalSpheroid, International1924,
            International1967, Krassowsky1940, NWL9D, NWL10D, Plessis1817,
            Struve1860, WarOffice, WGS84, GEM10C, OSU86F, OSU91A, Clarke1880,
            Sphere, GCS_Adindan, GCS_AGD66, GCS_AGD84, GCS_Ain_el_Abd,
            GCS_Afgooye, GCS_Agadez, GCS_Lisbon, GCS_Aratu, GCS_Arc_1950,
            GCS_Arc_1960, GCS_Batavia, GCS_Barbados, GCS_Beduaram,
            GCS_Beijing_1954, GCS_Belge_1950, GCS_Bermuda_1957, GCS_Bern_1898,
            GCS_Bogota, GCS_Bukit_Rimpah, GCS_Camacupa, GCS_Campo_Inchauspe,
            GCS_Cape, GCS_Carthage, GCS_Chua, GCS_Corrego_Alegre,
            GCS_Cote_d_Ivoire, GCS_Deir_ez_Zor, GCS_Douala, GCS_Egypt_1907,
            GCS_ED50, GCS_ED87, GCS_Fahud, GCS_Gandajika_1970, GCS_Garoua,
            GCS_Guyane_Francaise, GCS_Hu_Tzu_Shan, GCS_HD72, GCS_ID74,
            GCS_Indian_1954, GCS_Indian_1975, GCS_Jamaica_1875, GCS_JAD69,
            GCS_Kalianpur, GCS_Kandawala, GCS_Kertau, GCS_KOC, GCS_La_Canoa,
            GCS_PSAD56, GCS_Lake, GCS_Leigon, GCS_Liberia_1964, GCS_Lome,
            GCS_Luzon_1911, GCS_Hito_XVIII_1963, GCS_Herat_North,
            GCS_Mahe_1971, GCS_Makassar, GCS_EUREF89, GCS_Malongo_1987,
            GCS_Manoca, GCS_Merchich, GCS_Massawa, GCS_Minna, GCS_Mhast,
            GCS_Monte_Mario, GCS_M_poraloko, GCS_NAD27, GCS_NAD_Michigan,
            GCS_NAD83, GCS_Nahrwan_1967, GCS_Naparima_1972, GCS_GD49,
            GCS_NGO_1948, GCS_Datum_73, GCS_NTF, GCS_NSWC_9Z_2, GCS_OSGB_1936,
            GCS_OSGB70, GCS_OS_SN80, GCS_Padang, GCS_Palestine_1923,
            GCS_Pointe_Noire, GCS_GDA94, GCS_Pulkovo_1942, GCS_Qatar,
            GCS_Qatar_1948, GCS_Qornoq, GCS_Loma_Quintana, GCS_Amersfoort,
            GCS_RT38, GCS_SAD69, GCS_Sapper_Hill_1943, GCS_Schwarzeck,
            GCS_Segora, GCS_Serindung, GCS_Sudan, GCS_Tananarive,
            GCS_Timbalai_1948, GCS_TM65, GCS_TM75, GCS_Tokyo,
            GCS_Trinidad_1903, GCS_TC_1948, GCS_Voirol_1875,
            GCS_Voirol_Unifie, GCS_Bern_1938, GCS_Nord_Sahara_1959,
            GCS_Stockholm_1938, GCS_Yacare, GCS_Yoff, GCS_Zanderij, GCS_MGI,
            GCS_Belge_1972, GCS_DHDN, GCS_Conakry_1905, GCS_WGS_72,
            GCS_WGS_72BE, GCS_WGS_84, GCS_Bern_1898_Bern, GCS_Bogota_Bogota,
            GCS_Lisbon_Lisbon, GCS_Makassar_Jakarta, GCS_MGI_Ferro,
            GCS_Monte_Mario_Rome, GCS_NTF_Paris, GCS_Padang_Jakarta,
            GCS_Belge_1950_Brussels, GCS_Tananarive_Paris,
            GCS_Voirol_1875_Paris, GCS_Voirol_Unifie_Paris,
            GCS_Batavia_Jakarta, GCS_ATF_Paris, GCS_NDG_Paris
        };

        /** _more_          */
        public static final String names[] = {
            "GCSE_Airy1830", "GCSE_AiryModified1849",
            "GCSE_AustralianNationalSpheroid", "GCSE_Bessel1841",
            "GCSE_BesselModified", "GCSE_BesselNamibia", "GCSE_Clarke1858",
            "GCSE_Clarke1866", "GCSE_Clarke1866Michigan",
            "GCSE_Clarke1880_Benoit", "GCSE_Clarke1880_IGN",
            "GCSE_Clarke1880_RGS", "GCSE_Clarke1880_Arc",
            "GCSE_Clarke1880_SGA1922", "GCSE_Everest1830_1937Adjustment",
            "GCSE_Everest1830_1967Definition",
            "GCSE_Everest1830_1975Definition", "GCSE_Everest1830Modified",
            "GCSE_GRS1980", "GCSE_Helmert1906",
            "GCSE_IndonesianNationalSpheroid", "GCSE_International1924",
            "GCSE_International1967", "GCSE_Krassowsky1940", "GCSE_NWL9D",
            "GCSE_NWL10D", "GCSE_Plessis1817", "GCSE_Struve1860",
            "GCSE_WarOffice", "GCSE_WGS84", "GCSE_GEM10C", "GCSE_OSU86F",
            "GCSE_OSU91A", "GCSE_Clarke1880", "GCSE_Sphere", "GCS_Adindan",
            "GCS_AGD66", "GCS_AGD84", "GCS_Ain_el_Abd", "GCS_Afgooye",
            "GCS_Agadez", "GCS_Lisbon", "GCS_Aratu", "GCS_Arc_1950",
            "GCS_Arc_1960", "GCS_Batavia", "GCS_Barbados", "GCS_Beduaram",
            "GCS_Beijing_1954", "GCS_Belge_1950", "GCS_Bermuda_1957",
            "GCS_Bern_1898", "GCS_Bogota", "GCS_Bukit_Rimpah", "GCS_Camacupa",
            "GCS_Campo_Inchauspe", "GCS_Cape", "GCS_Carthage", "GCS_Chua",
            "GCS_Corrego_Alegre", "GCS_Cote_d_Ivoire", "GCS_Deir_ez_Zor",
            "GCS_Douala", "GCS_Egypt_1907", "GCS_ED50", "GCS_ED87",
            "GCS_Fahud", "GCS_Gandajika_1970", "GCS_Garoua",
            "GCS_Guyane_Francaise", "GCS_Hu_Tzu_Shan", "GCS_HD72", "GCS_ID74",
            "GCS_Indian_1954", "GCS_Indian_1975", "GCS_Jamaica_1875",
            "GCS_JAD69", "GCS_Kalianpur", "GCS_Kandawala", "GCS_Kertau",
            "GCS_KOC", "GCS_La_Canoa", "GCS_PSAD56", "GCS_Lake", "GCS_Leigon",
            "GCS_Liberia_1964", "GCS_Lome", "GCS_Luzon_1911",
            "GCS_Hito_XVIII_1963", "GCS_Herat_North", "GCS_Mahe_1971",
            "GCS_Makassar", "GCS_EUREF89", "GCS_Malongo_1987", "GCS_Manoca",
            "GCS_Merchich", "GCS_Massawa", "GCS_Minna", "GCS_Mhast",
            "GCS_Monte_Mario", "GCS_M_poraloko", "GCS_NAD27",
            "GCS_NAD_Michigan", "GCS_NAD83", "GCS_Nahrwan_1967",
            "GCS_Naparima_1972", "GCS_GD49", "GCS_NGO_1948", "GCS_Datum_73",
            "GCS_NTF", "GCS_NSWC_9Z_2", "GCS_OSGB_1936", "GCS_OSGB70",
            "GCS_OS_SN80", "GCS_Padang", "GCS_Palestine_1923",
            "GCS_Pointe_Noire", "GCS_GDA94", "GCS_Pulkovo_1942", "GCS_Qatar",
            "GCS_Qatar_1948", "GCS_Qornoq", "GCS_Loma_Quintana",
            "GCS_Amersfoort", "GCS_RT38", "GCS_SAD69", "GCS_Sapper_Hill_1943",
            "GCS_Schwarzeck", "GCS_Segora", "GCS_Serindung", "GCS_Sudan",
            "GCS_Tananarive", "GCS_Timbalai_1948", "GCS_TM65", "GCS_TM75",
            "GCS_Tokyo", "GCS_Trinidad_1903", "GCS_TC_1948",
            "GCS_Voirol_1875", "GCS_Voirol_Unifie", "GCS_Bern_1938",
            "GCS_Nord_Sahara_1959", "GCS_Stockholm_1938", "GCS_Yacare",
            "GCS_Yoff", "GCS_Zanderij", "GCS_MGI", "GCS_Belge_1972",
            "GCS_DHDN", "GCS_Conakry_1905", "GCS_WGS_72", "GCS_WGS_72BE",
            "GCS_WGS_84", "GCS_Bern_1898_Bern", "GCS_Bogota_Bogota",
            "GCS_Lisbon_Lisbon", "GCS_Makassar_Jakarta", "GCS_MGI_Ferro",
            "GCS_Monte_Mario_Rome", "GCS_NTF_Paris", "GCS_Padang_Jakarta",
            "GCS_Belge_1950_Brussels", "GCS_Tananarive_Paris",
            "GCS_Voirol_1875_Paris", "GCS_Voirol_Unifie_Paris",
            "GCS_Batavia_Jakarta", "GCS_ATF_Paris", "GCS_NDG_Paris"
        };

        /**
         * _more_
         *
         * @param value _more_
         *
         * @return _more_
         */
        public static String getName(int value) {
            for (int i = 0; i < values.length; i++) {
                if (values[i] == value) {
                    return names[i];
                }
            }
            return null;
        }
    }



    /**
     *  @author IDV development team
     */

    public static class EpsgPcs {

        /** _more_          */
        public static final int Adindan_UTM_zone_37N = 20137;

        /** _more_          */
        public static final int Adindan_UTM_zone_38N = 20138;

        /** _more_          */
        public static final int AGD66_AMG_zone_48 = 20248;

        /** _more_          */
        public static final int AGD66_AMG_zone_49 = 20249;

        /** _more_          */
        public static final int AGD66_AMG_zone_50 = 20250;

        /** _more_          */
        public static final int AGD66_AMG_zone_51 = 20251;

        /** _more_          */
        public static final int AGD66_AMG_zone_52 = 20252;

        /** _more_          */
        public static final int AGD66_AMG_zone_53 = 20253;

        /** _more_          */
        public static final int AGD66_AMG_zone_54 = 20254;

        /** _more_          */
        public static final int AGD66_AMG_zone_55 = 20255;

        /** _more_          */
        public static final int AGD66_AMG_zone_56 = 20256;

        /** _more_          */
        public static final int AGD66_AMG_zone_57 = 20257;

        /** _more_          */
        public static final int AGD66_AMG_zone_58 = 20258;

        /** _more_          */
        public static final int AGD84_AMG_zone_48 = 20348;

        /** _more_          */
        public static final int AGD84_AMG_zone_49 = 20349;

        /** _more_          */
        public static final int AGD84_AMG_zone_50 = 20350;

        /** _more_          */
        public static final int AGD84_AMG_zone_51 = 20351;

        /** _more_          */
        public static final int AGD84_AMG_zone_52 = 20352;

        /** _more_          */
        public static final int AGD84_AMG_zone_53 = 20353;

        /** _more_          */
        public static final int AGD84_AMG_zone_54 = 20354;

        /** _more_          */
        public static final int AGD84_AMG_zone_55 = 20355;

        /** _more_          */
        public static final int AGD84_AMG_zone_56 = 20356;

        /** _more_          */
        public static final int AGD84_AMG_zone_57 = 20357;

        /** _more_          */
        public static final int AGD84_AMG_zone_58 = 20358;

        /** _more_          */
        public static final int Ain_el_Abd_UTM_zone_37N = 20437;

        /** _more_          */
        public static final int Ain_el_Abd_UTM_zone_38N = 20438;

        /** _more_          */
        public static final int Ain_el_Abd_UTM_zone_39N = 20439;

        /** _more_          */
        public static final int Ain_el_Abd_Bahrain_Grid = 20499;

        /** _more_          */
        public static final int Afgooye_UTM_zone_38N = 20538;

        /** _more_          */
        public static final int Afgooye_UTM_zone_39N = 20539;

        /** _more_          */
        public static final int Lisbon_Portugese_Grid = 20700;

        /** _more_          */
        public static final int Aratu_UTM_zone_22S = 20822;

        /** _more_          */
        public static final int Aratu_UTM_zone_23S = 20823;

        /** _more_          */
        public static final int Aratu_UTM_zone_24S = 20824;

        /** _more_          */
        public static final int Arc_1950_Lo13 = 20973;

        /** _more_          */
        public static final int Arc_1950_Lo15 = 20975;

        /** _more_          */
        public static final int Arc_1950_Lo17 = 20977;

        /** _more_          */
        public static final int Arc_1950_Lo19 = 20979;

        /** _more_          */
        public static final int Arc_1950_Lo21 = 20981;

        /** _more_          */
        public static final int Arc_1950_Lo23 = 20983;

        /** _more_          */
        public static final int Arc_1950_Lo25 = 20985;

        /** _more_          */
        public static final int Arc_1950_Lo27 = 20987;

        /** _more_          */
        public static final int Arc_1950_Lo29 = 20989;

        /** _more_          */
        public static final int Arc_1950_Lo31 = 20991;

        /** _more_          */
        public static final int Arc_1950_Lo33 = 20993;

        /** _more_          */
        public static final int Arc_1950_Lo35 = 20995;

        /** _more_          */
        public static final int Batavia_NEIEZ = 21100;

        /** _more_          */
        public static final int Batavia_UTM_zone_48S = 21148;

        /** _more_          */
        public static final int Batavia_UTM_zone_49S = 21149;

        /** _more_          */
        public static final int Batavia_UTM_zone_50S = 21150;

        /** _more_          */
        public static final int Beijing_Gauss_zone_13 = 21413;

        /** _more_          */
        public static final int Beijing_Gauss_zone_14 = 21414;

        /** _more_          */
        public static final int Beijing_Gauss_zone_15 = 21415;

        /** _more_          */
        public static final int Beijing_Gauss_zone_16 = 21416;

        /** _more_          */
        public static final int Beijing_Gauss_zone_17 = 21417;

        /** _more_          */
        public static final int Beijing_Gauss_zone_18 = 21418;

        /** _more_          */
        public static final int Beijing_Gauss_zone_19 = 21419;

        /** _more_          */
        public static final int Beijing_Gauss_zone_20 = 21420;

        /** _more_          */
        public static final int Beijing_Gauss_zone_21 = 21421;

        /** _more_          */
        public static final int Beijing_Gauss_zone_22 = 21422;

        /** _more_          */
        public static final int Beijing_Gauss_zone_23 = 21423;

        /** _more_          */
        public static final int Beijing_Gauss_13N = 21473;

        /** _more_          */
        public static final int Beijing_Gauss_14N = 21474;

        /** _more_          */
        public static final int Beijing_Gauss_15N = 21475;

        /** _more_          */
        public static final int Beijing_Gauss_16N = 21476;

        /** _more_          */
        public static final int Beijing_Gauss_17N = 21477;

        /** _more_          */
        public static final int Beijing_Gauss_18N = 21478;

        /** _more_          */
        public static final int Beijing_Gauss_19N = 21479;

        /** _more_          */
        public static final int Beijing_Gauss_20N = 21480;

        /** _more_          */
        public static final int Beijing_Gauss_21N = 21481;

        /** _more_          */
        public static final int Beijing_Gauss_22N = 21482;

        /** _more_          */
        public static final int Beijing_Gauss_23N = 21483;

        /** _more_          */
        public static final int Belge_Lambert_50 = 21500;

        /** _more_          */
        public static final int Bern_1898_Swiss_Old = 21790;

        /** _more_          */
        public static final int Bogota_UTM_zone_17N = 21817;

        /** _more_          */
        public static final int Bogota_UTM_zone_18N = 21818;

        /** _more_          */
        public static final int Bogota_Colombia_3W = 21891;

        /** _more_          */
        public static final int Bogota_Colombia_Bogota = 21892;

        /** _more_          */
        public static final int Bogota_Colombia_3E = 21893;

        /** _more_          */
        public static final int Bogota_Colombia_6E = 21894;

        /** _more_          */
        public static final int Camacupa_UTM_32S = 22032;

        /** _more_          */
        public static final int Camacupa_UTM_33S = 22033;

        /** _more_          */
        public static final int C_Inchauspe_Argentina_1 = 22191;

        /** _more_          */
        public static final int C_Inchauspe_Argentina_2 = 22192;

        /** _more_          */
        public static final int C_Inchauspe_Argentina_3 = 22193;

        /** _more_          */
        public static final int C_Inchauspe_Argentina_4 = 22194;

        /** _more_          */
        public static final int C_Inchauspe_Argentina_5 = 22195;

        /** _more_          */
        public static final int C_Inchauspe_Argentina_6 = 22196;

        /** _more_          */
        public static final int C_Inchauspe_Argentina_7 = 22197;

        /** _more_          */
        public static final int Carthage_UTM_zone_32N = 22332;

        /** _more_          */
        public static final int Carthage_Nord_Tunisie = 22391;

        /** _more_          */
        public static final int Carthage_Sud_Tunisie = 22392;

        /** _more_          */
        public static final int Corrego_Alegre_UTM_23S = 22523;

        /** _more_          */
        public static final int Corrego_Alegre_UTM_24S = 22524;

        /** _more_          */
        public static final int Douala_UTM_zone_32N = 22832;

        /** _more_          */
        public static final int Egypt_1907_Red_Belt = 22992;

        /** _more_          */
        public static final int Egypt_1907_Purple_Belt = 22993;

        /** _more_          */
        public static final int Egypt_1907_Ext_Purple = 22994;

        /** _more_          */
        public static final int ED50_UTM_zone_28N = 23028;

        /** _more_          */
        public static final int ED50_UTM_zone_29N = 23029;

        /** _more_          */
        public static final int ED50_UTM_zone_30N = 23030;

        /** _more_          */
        public static final int ED50_UTM_zone_31N = 23031;

        /** _more_          */
        public static final int ED50_UTM_zone_32N = 23032;

        /** _more_          */
        public static final int ED50_UTM_zone_33N = 23033;

        /** _more_          */
        public static final int ED50_UTM_zone_34N = 23034;

        /** _more_          */
        public static final int ED50_UTM_zone_35N = 23035;

        /** _more_          */
        public static final int ED50_UTM_zone_36N = 23036;

        /** _more_          */
        public static final int ED50_UTM_zone_37N = 23037;

        /** _more_          */
        public static final int ED50_UTM_zone_38N = 23038;

        /** _more_          */
        public static final int Fahud_UTM_zone_39N = 23239;

        /** _more_          */
        public static final int Fahud_UTM_zone_40N = 23240;

        /** _more_          */
        public static final int Garoua_UTM_zone_33N = 23433;

        /** _more_          */
        public static final int ID74_UTM_zone_46N = 23846;

        /** _more_          */
        public static final int ID74_UTM_zone_47N = 23847;

        /** _more_          */
        public static final int ID74_UTM_zone_48N = 23848;

        /** _more_          */
        public static final int ID74_UTM_zone_49N = 23849;

        /** _more_          */
        public static final int ID74_UTM_zone_50N = 23850;

        /** _more_          */
        public static final int ID74_UTM_zone_51N = 23851;

        /** _more_          */
        public static final int ID74_UTM_zone_52N = 23852;

        /** _more_          */
        public static final int ID74_UTM_zone_53N = 23853;

        /** _more_          */
        public static final int ID74_UTM_zone_46S = 23886;

        /** _more_          */
        public static final int ID74_UTM_zone_47S = 23887;

        /** _more_          */
        public static final int ID74_UTM_zone_48S = 23888;

        /** _more_          */
        public static final int ID74_UTM_zone_49S = 23889;

        /** _more_          */
        public static final int ID74_UTM_zone_50S = 23890;

        /** _more_          */
        public static final int ID74_UTM_zone_51S = 23891;

        /** _more_          */
        public static final int ID74_UTM_zone_52S = 23892;

        /** _more_          */
        public static final int ID74_UTM_zone_53S = 23893;

        /** _more_          */
        public static final int ID74_UTM_zone_54S = 23894;

        /** _more_          */
        public static final int Indian_1954_UTM_47N = 23947;

        /** _more_          */
        public static final int Indian_1954_UTM_48N = 23948;

        /** _more_          */
        public static final int Indian_1975_UTM_47N = 24047;

        /** _more_          */
        public static final int Indian_1975_UTM_48N = 24048;

        /** _more_          */
        public static final int Jamaica_1875_Old_Grid = 24100;

        /** _more_          */
        public static final int JAD69_Jamaica_Grid = 24200;

        /** _more_          */
        public static final int Kalianpur_India_0 = 24370;

        /** _more_          */
        public static final int Kalianpur_India_I = 24371;

        /** _more_          */
        public static final int Kalianpur_India_IIa = 24372;

        /** _more_          */
        public static final int Kalianpur_India_IIIa = 24373;

        /** _more_          */
        public static final int Kalianpur_India_IVa = 24374;

        /** _more_          */
        public static final int Kalianpur_India_IIb = 24382;

        /** _more_          */
        public static final int Kalianpur_India_IIIb = 24383;

        /** _more_          */
        public static final int Kalianpur_India_IVb = 24384;

        /** _more_          */
        public static final int Kertau_Singapore_Grid = 24500;

        /** _more_          */
        public static final int Kertau_UTM_zone_47N = 24547;

        /** _more_          */
        public static final int Kertau_UTM_zone_48N = 24548;

        /** _more_          */
        public static final int La_Canoa_UTM_zone_20N = 24720;

        /** _more_          */
        public static final int La_Canoa_UTM_zone_21N = 24721;

        /** _more_          */
        public static final int PSAD56_UTM_zone_18N = 24818;

        /** _more_          */
        public static final int PSAD56_UTM_zone_19N = 24819;

        /** _more_          */
        public static final int PSAD56_UTM_zone_20N = 24820;

        /** _more_          */
        public static final int PSAD56_UTM_zone_21N = 24821;

        /** _more_          */
        public static final int PSAD56_UTM_zone_17S = 24877;

        /** _more_          */
        public static final int PSAD56_UTM_zone_18S = 24878;

        /** _more_          */
        public static final int PSAD56_UTM_zone_19S = 24879;

        /** _more_          */
        public static final int PSAD56_UTM_zone_20S = 24880;

        /** _more_          */
        public static final int PSAD56_Peru_west_zone = 24891;

        /** _more_          */
        public static final int PSAD56_Peru_central = 24892;

        /** _more_          */
        public static final int PSAD56_Peru_east_zone = 24893;

        /** _more_          */
        public static final int Leigon_Ghana_Grid = 25000;

        /** _more_          */
        public static final int Lome_UTM_zone_31N = 25231;

        /** _more_          */
        public static final int Luzon_Philippines_I = 25391;

        /** _more_          */
        public static final int Luzon_Philippines_II = 25392;

        /** _more_          */
        public static final int Luzon_Philippines_III = 25393;

        /** _more_          */
        public static final int Luzon_Philippines_IV = 25394;

        /** _more_          */
        public static final int Luzon_Philippines_V = 25395;

        /** _more_          */
        public static final int Makassar_NEIEZ = 25700;

        /** _more_          */
        public static final int Malongo_1987_UTM_32S = 25932;

        /** _more_          */
        public static final int Merchich_Nord_Maroc = 26191;

        /** _more_          */
        public static final int Merchich_Sud_Maroc = 26192;

        /** _more_          */
        public static final int Merchich_Sahara = 26193;

        /** _more_          */
        public static final int Massawa_UTM_zone_37N = 26237;

        /** _more_          */
        public static final int Minna_UTM_zone_31N = 26331;

        /** _more_          */
        public static final int Minna_UTM_zone_32N = 26332;

        /** _more_          */
        public static final int Minna_Nigeria_West = 26391;

        /** _more_          */
        public static final int Minna_Nigeria_Mid_Belt = 26392;

        /** _more_          */
        public static final int Minna_Nigeria_East = 26393;

        /** _more_          */
        public static final int Mhast_UTM_zone_32S = 26432;

        /** _more_          */
        public static final int Monte_Mario_Italy_1 = 26591;

        /** _more_          */
        public static final int Monte_Mario_Italy_2 = 26592;

        /** _more_          */
        public static final int M_poraloko_UTM_32N = 26632;

        /** _more_          */
        public static final int M_poraloko_UTM_32S = 26692;

        /** _more_          */
        public static final int NAD27_UTM_zone_3N = 26703;

        /** _more_          */
        public static final int NAD27_UTM_zone_4N = 26704;

        /** _more_          */
        public static final int NAD27_UTM_zone_5N = 26705;

        /** _more_          */
        public static final int NAD27_UTM_zone_6N = 26706;

        /** _more_          */
        public static final int NAD27_UTM_zone_7N = 26707;

        /** _more_          */
        public static final int NAD27_UTM_zone_8N = 26708;

        /** _more_          */
        public static final int NAD27_UTM_zone_9N = 26709;

        /** _more_          */
        public static final int NAD27_UTM_zone_10N = 26710;

        /** _more_          */
        public static final int NAD27_UTM_zone_11N = 26711;

        /** _more_          */
        public static final int NAD27_UTM_zone_12N = 26712;

        /** _more_          */
        public static final int NAD27_UTM_zone_13N = 26713;

        /** _more_          */
        public static final int NAD27_UTM_zone_14N = 26714;

        /** _more_          */
        public static final int NAD27_UTM_zone_15N = 26715;

        /** _more_          */
        public static final int NAD27_UTM_zone_16N = 26716;

        /** _more_          */
        public static final int NAD27_UTM_zone_17N = 26717;

        /** _more_          */
        public static final int NAD27_UTM_zone_18N = 26718;

        /** _more_          */
        public static final int NAD27_UTM_zone_19N = 26719;

        /** _more_          */
        public static final int NAD27_UTM_zone_20N = 26720;

        /** _more_          */
        public static final int NAD27_UTM_zone_21N = 26721;

        /** _more_          */
        public static final int NAD27_UTM_zone_22N = 26722;

        /** _more_          */
        public static final int NAD27_Alabama_East = 26729;

        /** _more_          */
        public static final int NAD27_Alabama_West = 26730;

        /** _more_          */
        public static final int NAD27_Alaska_zone_1 = 26731;

        /** _more_          */
        public static final int NAD27_Alaska_zone_2 = 26732;

        /** _more_          */
        public static final int NAD27_Alaska_zone_3 = 26733;

        /** _more_          */
        public static final int NAD27_Alaska_zone_4 = 26734;

        /** _more_          */
        public static final int NAD27_Alaska_zone_5 = 26735;

        /** _more_          */
        public static final int NAD27_Alaska_zone_6 = 26736;

        /** _more_          */
        public static final int NAD27_Alaska_zone_7 = 26737;

        /** _more_          */
        public static final int NAD27_Alaska_zone_8 = 26738;

        /** _more_          */
        public static final int NAD27_Alaska_zone_9 = 26739;

        /** _more_          */
        public static final int NAD27_Alaska_zone_10 = 26740;

        /** _more_          */
        public static final int NAD27_California_I = 26741;

        /** _more_          */
        public static final int NAD27_California_II = 26742;

        /** _more_          */
        public static final int NAD27_California_III = 26743;

        /** _more_          */
        public static final int NAD27_California_IV = 26744;

        /** _more_          */
        public static final int NAD27_California_V = 26745;

        /** _more_          */
        public static final int NAD27_California_VI = 26746;

        /** _more_          */
        public static final int NAD27_California_VII = 26747;

        /** _more_          */
        public static final int NAD27_Arizona_East = 26748;

        /** _more_          */
        public static final int NAD27_Arizona_Central = 26749;

        /** _more_          */
        public static final int NAD27_Arizona_West = 26750;

        /** _more_          */
        public static final int NAD27_Arkansas_North = 26751;

        /** _more_          */
        public static final int NAD27_Arkansas_South = 26752;

        /** _more_          */
        public static final int NAD27_Colorado_North = 26753;

        /** _more_          */
        public static final int NAD27_Colorado_Central = 26754;

        /** _more_          */
        public static final int NAD27_Colorado_South = 26755;

        /** _more_          */
        public static final int NAD27_Connecticut = 26756;

        /** _more_          */
        public static final int NAD27_Delaware = 26757;

        /** _more_          */
        public static final int NAD27_Florida_East = 26758;

        /** _more_          */
        public static final int NAD27_Florida_West = 26759;

        /** _more_          */
        public static final int NAD27_Florida_North = 26760;

        /** _more_          */
        public static final int NAD27_Hawaii_zone_1 = 26761;

        /** _more_          */
        public static final int NAD27_Hawaii_zone_2 = 26762;

        /** _more_          */
        public static final int NAD27_Hawaii_zone_3 = 26763;

        /** _more_          */
        public static final int NAD27_Hawaii_zone_4 = 26764;

        /** _more_          */
        public static final int NAD27_Hawaii_zone_5 = 26765;

        /** _more_          */
        public static final int NAD27_Georgia_East = 26766;

        /** _more_          */
        public static final int NAD27_Georgia_West = 26767;

        /** _more_          */
        public static final int NAD27_Idaho_East = 26768;

        /** _more_          */
        public static final int NAD27_Idaho_Central = 26769;

        /** _more_          */
        public static final int NAD27_Idaho_West = 26770;

        /** _more_          */
        public static final int NAD27_Illinois_East = 26771;

        /** _more_          */
        public static final int NAD27_Illinois_West = 26772;

        /** _more_          */
        public static final int NAD27_Indiana_East = 26773;

        /** _more_          */
        public static final int NAD27_BLM_14N_feet = 26774;

        /** _more_          */
        public static final int NAD27_Indiana_West = 26774;

        /** _more_          */
        public static final int NAD27_BLM_15N_feet = 26775;

        /** _more_          */
        public static final int NAD27_Iowa_North = 26775;

        /** _more_          */
        public static final int NAD27_BLM_16N_feet = 26776;

        /** _more_          */
        public static final int NAD27_Iowa_South = 26776;

        /** _more_          */
        public static final int NAD27_BLM_17N_feet = 26777;

        /** _more_          */
        public static final int NAD27_Kansas_North = 26777;

        /** _more_          */
        public static final int NAD27_Kansas_South = 26778;

        /** _more_          */
        public static final int NAD27_Kentucky_North = 26779;

        /** _more_          */
        public static final int NAD27_Kentucky_South = 26780;

        /** _more_          */
        public static final int NAD27_Louisiana_North = 26781;

        /** _more_          */
        public static final int NAD27_Louisiana_South = 26782;

        /** _more_          */
        public static final int NAD27_Maine_East = 26783;

        /** _more_          */
        public static final int NAD27_Maine_West = 26784;

        /** _more_          */
        public static final int NAD27_Maryland = 26785;

        /** _more_          */
        public static final int NAD27_Massachusetts = 26786;

        /** _more_          */
        public static final int NAD27_Massachusetts_Is = 26787;

        /** _more_          */
        public static final int NAD27_Michigan_North = 26788;

        /** _more_          */
        public static final int NAD27_Michigan_Central = 26789;

        /** _more_          */
        public static final int NAD27_Michigan_South = 26790;

        /** _more_          */
        public static final int NAD27_Minnesota_North = 26791;

        /** _more_          */
        public static final int NAD27_Minnesota_Cent = 26792;

        /** _more_          */
        public static final int NAD27_Minnesota_South = 26793;

        /** _more_          */
        public static final int NAD27_Mississippi_East = 26794;

        /** _more_          */
        public static final int NAD27_Mississippi_West = 26795;

        /** _more_          */
        public static final int NAD27_Missouri_East = 26796;

        /** _more_          */
        public static final int NAD27_Missouri_Central = 26797;

        /** _more_          */
        public static final int NAD27_Missouri_West = 26798;

        /** _more_          */
        public static final int NAD_Michigan_Michigan_East = 26801;

        /** _more_          */
        public static final int NAD_Michigan_Michigan_Old_Central = 26802;

        /** _more_          */
        public static final int NAD_Michigan_Michigan_West = 26803;

        /** _more_          */
        public static final int NAD83_UTM_zone_3N = 26903;

        /** _more_          */
        public static final int NAD83_UTM_zone_4N = 26904;

        /** _more_          */
        public static final int NAD83_UTM_zone_5N = 26905;

        /** _more_          */
        public static final int NAD83_UTM_zone_6N = 26906;

        /** _more_          */
        public static final int NAD83_UTM_zone_7N = 26907;

        /** _more_          */
        public static final int NAD83_UTM_zone_8N = 26908;

        /** _more_          */
        public static final int NAD83_UTM_zone_9N = 26909;

        /** _more_          */
        public static final int NAD83_UTM_zone_10N = 26910;

        /** _more_          */
        public static final int NAD83_UTM_zone_11N = 26911;

        /** _more_          */
        public static final int NAD83_UTM_zone_12N = 26912;

        /** _more_          */
        public static final int NAD83_UTM_zone_13N = 26913;

        /** _more_          */
        public static final int NAD83_UTM_zone_14N = 26914;

        /** _more_          */
        public static final int NAD83_UTM_zone_15N = 26915;

        /** _more_          */
        public static final int NAD83_UTM_zone_16N = 26916;

        /** _more_          */
        public static final int NAD83_UTM_zone_17N = 26917;

        /** _more_          */
        public static final int NAD83_UTM_zone_18N = 26918;

        /** _more_          */
        public static final int NAD83_UTM_zone_19N = 26919;

        /** _more_          */
        public static final int NAD83_UTM_zone_20N = 26920;

        /** _more_          */
        public static final int NAD83_UTM_zone_21N = 26921;

        /** _more_          */
        public static final int NAD83_UTM_zone_22N = 26922;

        /** _more_          */
        public static final int NAD83_UTM_zone_23N = 26923;

        /** _more_          */
        public static final int NAD83_Alabama_East = 26929;

        /** _more_          */
        public static final int NAD83_Alabama_West = 26930;

        /** _more_          */
        public static final int NAD83_Alaska_zone_1 = 26931;

        /** _more_          */
        public static final int NAD83_Alaska_zone_2 = 26932;

        /** _more_          */
        public static final int NAD83_Alaska_zone_3 = 26933;

        /** _more_          */
        public static final int NAD83_Alaska_zone_4 = 26934;

        /** _more_          */
        public static final int NAD83_Alaska_zone_5 = 26935;

        /** _more_          */
        public static final int NAD83_Alaska_zone_6 = 26936;

        /** _more_          */
        public static final int NAD83_Alaska_zone_7 = 26937;

        /** _more_          */
        public static final int NAD83_Alaska_zone_8 = 26938;

        /** _more_          */
        public static final int NAD83_Alaska_zone_9 = 26939;

        /** _more_          */
        public static final int NAD83_Alaska_zone_10 = 26940;

        /** _more_          */
        public static final int NAD83_California_1 = 26941;

        /** _more_          */
        public static final int NAD83_California_2 = 26942;

        /** _more_          */
        public static final int NAD83_California_3 = 26943;

        /** _more_          */
        public static final int NAD83_California_4 = 26944;

        /** _more_          */
        public static final int NAD83_California_5 = 26945;

        /** _more_          */
        public static final int NAD83_California_6 = 26946;

        /** _more_          */
        public static final int NAD83_Arizona_East = 26948;

        /** _more_          */
        public static final int NAD83_Arizona_Central = 26949;

        /** _more_          */
        public static final int NAD83_Arizona_West = 26950;

        /** _more_          */
        public static final int NAD83_Arkansas_North = 26951;

        /** _more_          */
        public static final int NAD83_Arkansas_South = 26952;

        /** _more_          */
        public static final int NAD83_Colorado_North = 26953;

        /** _more_          */
        public static final int NAD83_Colorado_Central = 26954;

        /** _more_          */
        public static final int NAD83_Colorado_South = 26955;

        /** _more_          */
        public static final int NAD83_Connecticut = 26956;

        /** _more_          */
        public static final int NAD83_Delaware = 26957;

        /** _more_          */
        public static final int NAD83_Florida_East = 26958;

        /** _more_          */
        public static final int NAD83_Florida_West = 26959;

        /** _more_          */
        public static final int NAD83_Florida_North = 26960;

        /** _more_          */
        public static final int NAD83_Hawaii_zone_1 = 26961;

        /** _more_          */
        public static final int NAD83_Hawaii_zone_2 = 26962;

        /** _more_          */
        public static final int NAD83_Hawaii_zone_3 = 26963;

        /** _more_          */
        public static final int NAD83_Hawaii_zone_4 = 26964;

        /** _more_          */
        public static final int NAD83_Hawaii_zone_5 = 26965;

        /** _more_          */
        public static final int NAD83_Georgia_East = 26966;

        /** _more_          */
        public static final int NAD83_Georgia_West = 26967;

        /** _more_          */
        public static final int NAD83_Idaho_East = 26968;

        /** _more_          */
        public static final int NAD83_Idaho_Central = 26969;

        /** _more_          */
        public static final int NAD83_Idaho_West = 26970;

        /** _more_          */
        public static final int NAD83_Illinois_East = 26971;

        /** _more_          */
        public static final int NAD83_Illinois_West = 26972;

        /** _more_          */
        public static final int NAD83_Indiana_East = 26973;

        /** _more_          */
        public static final int NAD83_Indiana_West = 26974;

        /** _more_          */
        public static final int NAD83_Iowa_North = 26975;

        /** _more_          */
        public static final int NAD83_Iowa_South = 26976;

        /** _more_          */
        public static final int NAD83_Kansas_North = 26977;

        /** _more_          */
        public static final int NAD83_Kansas_South = 26978;

        /** _more_          */
        public static final int NAD83_Kentucky_North = 26979;

        /** _more_          */
        public static final int NAD83_Kentucky_South = 26980;

        /** _more_          */
        public static final int NAD83_Louisiana_North = 26981;

        /** _more_          */
        public static final int NAD83_Louisiana_South = 26982;

        /** _more_          */
        public static final int NAD83_Maine_East = 26983;

        /** _more_          */
        public static final int NAD83_Maine_West = 26984;

        /** _more_          */
        public static final int NAD83_Maryland = 26985;

        /** _more_          */
        public static final int NAD83_Massachusetts = 26986;

        /** _more_          */
        public static final int NAD83_Massachusetts_Is = 26987;

        /** _more_          */
        public static final int NAD83_Michigan_North = 26988;

        /** _more_          */
        public static final int NAD83_Michigan_Central = 26989;

        /** _more_          */
        public static final int NAD83_Michigan_South = 26990;

        /** _more_          */
        public static final int NAD83_Minnesota_North = 26991;

        /** _more_          */
        public static final int NAD83_Minnesota_Cent = 26992;

        /** _more_          */
        public static final int NAD83_Minnesota_South = 26993;

        /** _more_          */
        public static final int NAD83_Mississippi_East = 26994;

        /** _more_          */
        public static final int NAD83_Mississippi_West = 26995;

        /** _more_          */
        public static final int NAD83_Missouri_East = 26996;

        /** _more_          */
        public static final int NAD83_Missouri_Central = 26997;

        /** _more_          */
        public static final int NAD83_Missouri_West = 26998;

        /** _more_          */
        public static final int Nahrwan_1967_UTM_38N = 27038;

        /** _more_          */
        public static final int Nahrwan_1967_UTM_39N = 27039;

        /** _more_          */
        public static final int Nahrwan_1967_UTM_40N = 27040;

        /** _more_          */
        public static final int Naparima_UTM_20N = 27120;

        /** _more_          */
        public static final int GD49_NZ_Map_Grid = 27200;

        /** _more_          */
        public static final int GD49_North_Island_Grid = 27291;

        /** _more_          */
        public static final int GD49_South_Island_Grid = 27292;

        /** _more_          */
        public static final int Datum_73_UTM_zone_29N = 27429;

        /** _more_          */
        public static final int ATF_Nord_de_Guerre = 27500;

        /** _more_          */
        public static final int NTF_France_I = 27581;

        /** _more_          */
        public static final int NTF_France_II = 27582;

        /** _more_          */
        public static final int NTF_France_III = 27583;

        /** _more_          */
        public static final int NTF_Nord_France = 27591;

        /** _more_          */
        public static final int NTF_Centre_France = 27592;

        /** _more_          */
        public static final int NTF_Sud_France = 27593;

        /** _more_          */
        public static final int British_National_Grid = 27700;

        /** _more_          */
        public static final int Point_Noire_UTM_32S = 28232;

        /** _more_          */
        public static final int GDA94_MGA_zone_48 = 28348;

        /** _more_          */
        public static final int GDA94_MGA_zone_49 = 28349;

        /** _more_          */
        public static final int GDA94_MGA_zone_50 = 28350;

        /** _more_          */
        public static final int GDA94_MGA_zone_51 = 28351;

        /** _more_          */
        public static final int GDA94_MGA_zone_52 = 28352;

        /** _more_          */
        public static final int GDA94_MGA_zone_53 = 28353;

        /** _more_          */
        public static final int GDA94_MGA_zone_54 = 28354;

        /** _more_          */
        public static final int GDA94_MGA_zone_55 = 28355;

        /** _more_          */
        public static final int GDA94_MGA_zone_56 = 28356;

        /** _more_          */
        public static final int GDA94_MGA_zone_57 = 28357;

        /** _more_          */
        public static final int GDA94_MGA_zone_58 = 28358;

        /** _more_          */
        public static final int Pulkovo_Gauss_zone_4 = 28404;

        /** _more_          */
        public static final int Pulkovo_Gauss_zone_5 = 28405;

        /** _more_          */
        public static final int Pulkovo_Gauss_zone_6 = 28406;

        /** _more_          */
        public static final int Pulkovo_Gauss_zone_7 = 28407;

        /** _more_          */
        public static final int Pulkovo_Gauss_zone_8 = 28408;

        /** _more_          */
        public static final int Pulkovo_Gauss_zone_9 = 28409;

        /** _more_          */
        public static final int Pulkovo_Gauss_zone_10 = 28410;

        /** _more_          */
        public static final int Pulkovo_Gauss_zone_11 = 28411;

        /** _more_          */
        public static final int Pulkovo_Gauss_zone_12 = 28412;

        /** _more_          */
        public static final int Pulkovo_Gauss_zone_13 = 28413;

        /** _more_          */
        public static final int Pulkovo_Gauss_zone_14 = 28414;

        /** _more_          */
        public static final int Pulkovo_Gauss_zone_15 = 28415;

        /** _more_          */
        public static final int Pulkovo_Gauss_zone_16 = 28416;

        /** _more_          */
        public static final int Pulkovo_Gauss_zone_17 = 28417;

        /** _more_          */
        public static final int Pulkovo_Gauss_zone_18 = 28418;

        /** _more_          */
        public static final int Pulkovo_Gauss_zone_19 = 28419;

        /** _more_          */
        public static final int Pulkovo_Gauss_zone_20 = 28420;

        /** _more_          */
        public static final int Pulkovo_Gauss_zone_21 = 28421;

        /** _more_          */
        public static final int Pulkovo_Gauss_zone_22 = 28422;

        /** _more_          */
        public static final int Pulkovo_Gauss_zone_23 = 28423;

        /** _more_          */
        public static final int Pulkovo_Gauss_zone_24 = 28424;

        /** _more_          */
        public static final int Pulkovo_Gauss_zone_25 = 28425;

        /** _more_          */
        public static final int Pulkovo_Gauss_zone_26 = 28426;

        /** _more_          */
        public static final int Pulkovo_Gauss_zone_27 = 28427;

        /** _more_          */
        public static final int Pulkovo_Gauss_zone_28 = 28428;

        /** _more_          */
        public static final int Pulkovo_Gauss_zone_29 = 28429;

        /** _more_          */
        public static final int Pulkovo_Gauss_zone_30 = 28430;

        /** _more_          */
        public static final int Pulkovo_Gauss_zone_31 = 28431;

        /** _more_          */
        public static final int Pulkovo_Gauss_zone_32 = 28432;

        /** _more_          */
        public static final int Pulkovo_Gauss_4N = 28464;

        /** _more_          */
        public static final int Pulkovo_Gauss_5N = 28465;

        /** _more_          */
        public static final int Pulkovo_Gauss_6N = 28466;

        /** _more_          */
        public static final int Pulkovo_Gauss_7N = 28467;

        /** _more_          */
        public static final int Pulkovo_Gauss_8N = 28468;

        /** _more_          */
        public static final int Pulkovo_Gauss_9N = 28469;

        /** _more_          */
        public static final int Pulkovo_Gauss_10N = 28470;

        /** _more_          */
        public static final int Pulkovo_Gauss_11N = 28471;

        /** _more_          */
        public static final int Pulkovo_Gauss_12N = 28472;

        /** _more_          */
        public static final int Pulkovo_Gauss_13N = 28473;

        /** _more_          */
        public static final int Pulkovo_Gauss_14N = 28474;

        /** _more_          */
        public static final int Pulkovo_Gauss_15N = 28475;

        /** _more_          */
        public static final int Pulkovo_Gauss_16N = 28476;

        /** _more_          */
        public static final int Pulkovo_Gauss_17N = 28477;

        /** _more_          */
        public static final int Pulkovo_Gauss_18N = 28478;

        /** _more_          */
        public static final int Pulkovo_Gauss_19N = 28479;

        /** _more_          */
        public static final int Pulkovo_Gauss_20N = 28480;

        /** _more_          */
        public static final int Pulkovo_Gauss_21N = 28481;

        /** _more_          */
        public static final int Pulkovo_Gauss_22N = 28482;

        /** _more_          */
        public static final int Pulkovo_Gauss_23N = 28483;

        /** _more_          */
        public static final int Pulkovo_Gauss_24N = 28484;

        /** _more_          */
        public static final int Pulkovo_Gauss_25N = 28485;

        /** _more_          */
        public static final int Pulkovo_Gauss_26N = 28486;

        /** _more_          */
        public static final int Pulkovo_Gauss_27N = 28487;

        /** _more_          */
        public static final int Pulkovo_Gauss_28N = 28488;

        /** _more_          */
        public static final int Pulkovo_Gauss_29N = 28489;

        /** _more_          */
        public static final int Pulkovo_Gauss_30N = 28490;

        /** _more_          */
        public static final int Pulkovo_Gauss_31N = 28491;

        /** _more_          */
        public static final int Pulkovo_Gauss_32N = 28492;

        /** _more_          */
        public static final int Qatar_National_Grid = 28600;

        /** _more_          */
        public static final int RD_Netherlands_Old = 28991;

        /** _more_          */
        public static final int RD_Netherlands_New = 28992;

        /** _more_          */
        public static final int SAD69_UTM_zone_18N = 29118;

        /** _more_          */
        public static final int SAD69_UTM_zone_19N = 29119;

        /** _more_          */
        public static final int SAD69_UTM_zone_20N = 29120;

        /** _more_          */
        public static final int SAD69_UTM_zone_21N = 29121;

        /** _more_          */
        public static final int SAD69_UTM_zone_22N = 29122;

        /** _more_          */
        public static final int SAD69_UTM_zone_17S = 29177;

        /** _more_          */
        public static final int SAD69_UTM_zone_18S = 29178;

        /** _more_          */
        public static final int SAD69_UTM_zone_19S = 29179;

        /** _more_          */
        public static final int SAD69_UTM_zone_20S = 29180;

        /** _more_          */
        public static final int SAD69_UTM_zone_21S = 29181;

        /** _more_          */
        public static final int SAD69_UTM_zone_22S = 29182;

        /** _more_          */
        public static final int SAD69_UTM_zone_23S = 29183;

        /** _more_          */
        public static final int SAD69_UTM_zone_24S = 29184;

        /** _more_          */
        public static final int SAD69_UTM_zone_25S = 29185;

        /** _more_          */
        public static final int Sapper_Hill_UTM_20S = 29220;

        /** _more_          */
        public static final int Sapper_Hill_UTM_21S = 29221;

        /** _more_          */
        public static final int Schwarzeck_UTM_33S = 29333;

        /** _more_          */
        public static final int Sudan_UTM_zone_35N = 29635;

        /** _more_          */
        public static final int Sudan_UTM_zone_36N = 29636;

        /** _more_          */
        public static final int Tananarive_Laborde = 29700;

        /** _more_          */
        public static final int Tananarive_UTM_38S = 29738;

        /** _more_          */
        public static final int Tananarive_UTM_39S = 29739;

        /** _more_          */
        public static final int Timbalai_1948_Borneo = 29800;

        /** _more_          */
        public static final int Timbalai_1948_UTM_49N = 29849;

        /** _more_          */
        public static final int Timbalai_1948_UTM_50N = 29850;

        /** _more_          */
        public static final int TM65_Irish_Nat_Grid = 29900;

        /** _more_          */
        public static final int Trinidad_1903_Trinidad = 30200;

        /** _more_          */
        public static final int TC_1948_UTM_zone_39N = 30339;

        /** _more_          */
        public static final int TC_1948_UTM_zone_40N = 30340;

        /** _more_          */
        public static final int Voirol_N_Algerie_ancien = 30491;

        /** _more_          */
        public static final int Voirol_S_Algerie_ancien = 30492;

        /** _more_          */
        public static final int Voirol_Unifie_N_Algerie = 30591;

        /** _more_          */
        public static final int Voirol_Unifie_S_Algerie = 30592;

        /** _more_          */
        public static final int Bern_1938_Swiss_New = 30600;

        /** _more_          */
        public static final int Nord_Sahara_UTM_29N = 30729;

        /** _more_          */
        public static final int Nord_Sahara_UTM_30N = 30730;

        /** _more_          */
        public static final int Nord_Sahara_UTM_31N = 30731;

        /** _more_          */
        public static final int Nord_Sahara_UTM_32N = 30732;

        /** _more_          */
        public static final int Yoff_UTM_zone_28N = 31028;

        /** _more_          */
        public static final int Zanderij_UTM_zone_21N = 31121;

        /** _more_          */
        public static final int MGI_Austria_West = 31291;

        /** _more_          */
        public static final int MGI_Austria_Central = 31292;

        /** _more_          */
        public static final int MGI_Austria_East = 31293;

        /** _more_          */
        public static final int Belge_Lambert_72 = 31300;

        /** _more_          */
        public static final int DHDN_Germany_zone_1 = 31491;

        /** _more_          */
        public static final int DHDN_Germany_zone_2 = 31492;

        /** _more_          */
        public static final int DHDN_Germany_zone_3 = 31493;

        /** _more_          */
        public static final int DHDN_Germany_zone_4 = 31494;

        /** _more_          */
        public static final int DHDN_Germany_zone_5 = 31495;

        /** _more_          */
        public static final int NAD27_Montana_North = 32001;

        /** _more_          */
        public static final int NAD27_Montana_Central = 32002;

        /** _more_          */
        public static final int NAD27_Montana_South = 32003;

        /** _more_          */
        public static final int NAD27_Nebraska_North = 32005;

        /** _more_          */
        public static final int NAD27_Nebraska_South = 32006;

        /** _more_          */
        public static final int NAD27_Nevada_East = 32007;

        /** _more_          */
        public static final int NAD27_Nevada_Central = 32008;

        /** _more_          */
        public static final int NAD27_Nevada_West = 32009;

        /** _more_          */
        public static final int NAD27_New_Hampshire = 32010;

        /** _more_          */
        public static final int NAD27_New_Jersey = 32011;

        /** _more_          */
        public static final int NAD27_New_Mexico_East = 32012;

        /** _more_          */
        public static final int NAD27_New_Mexico_Cent = 32013;

        /** _more_          */
        public static final int NAD27_New_Mexico_West = 32014;

        /** _more_          */
        public static final int NAD27_New_York_East = 32015;

        /** _more_          */
        public static final int NAD27_New_York_Central = 32016;

        /** _more_          */
        public static final int NAD27_New_York_West = 32017;

        /** _more_          */
        public static final int NAD27_New_York_Long_Is = 32018;

        /** _more_          */
        public static final int NAD27_North_Carolina = 32019;

        /** _more_          */
        public static final int NAD27_North_Dakota_N = 32020;

        /** _more_          */
        public static final int NAD27_North_Dakota_S = 32021;

        /** _more_          */
        public static final int NAD27_Ohio_North = 32022;

        /** _more_          */
        public static final int NAD27_Ohio_South = 32023;

        /** _more_          */
        public static final int NAD27_Oklahoma_North = 32024;

        /** _more_          */
        public static final int NAD27_Oklahoma_South = 32025;

        /** _more_          */
        public static final int NAD27_Oregon_North = 32026;

        /** _more_          */
        public static final int NAD27_Oregon_South = 32027;

        /** _more_          */
        public static final int NAD27_Pennsylvania_N = 32028;

        /** _more_          */
        public static final int NAD27_Pennsylvania_S = 32029;

        /** _more_          */
        public static final int NAD27_Rhode_Island = 32030;

        /** _more_          */
        public static final int NAD27_South_Carolina_N = 32031;

        /** _more_          */
        public static final int NAD27_South_Carolina_S = 32033;

        /** _more_          */
        public static final int NAD27_South_Dakota_N = 32034;

        /** _more_          */
        public static final int NAD27_South_Dakota_S = 32035;

        /** _more_          */
        public static final int NAD27_Tennessee = 32036;

        /** _more_          */
        public static final int NAD27_Texas_North = 32037;

        /** _more_          */
        public static final int NAD27_Texas_North_Cen = 32038;

        /** _more_          */
        public static final int NAD27_Texas_Central = 32039;

        /** _more_          */
        public static final int NAD27_Texas_South_Cen = 32040;

        /** _more_          */
        public static final int NAD27_Texas_South = 32041;

        /** _more_          */
        public static final int NAD27_Utah_North = 32042;

        /** _more_          */
        public static final int NAD27_Utah_Central = 32043;

        /** _more_          */
        public static final int NAD27_Utah_South = 32044;

        /** _more_          */
        public static final int NAD27_Vermont = 32045;

        /** _more_          */
        public static final int NAD27_Virginia_North = 32046;

        /** _more_          */
        public static final int NAD27_Virginia_South = 32047;

        /** _more_          */
        public static final int NAD27_Washington_North = 32048;

        /** _more_          */
        public static final int NAD27_Washington_South = 32049;

        /** _more_          */
        public static final int NAD27_West_Virginia_N = 32050;

        /** _more_          */
        public static final int NAD27_West_Virginia_S = 32051;

        /** _more_          */
        public static final int NAD27_Wisconsin_North = 32052;

        /** _more_          */
        public static final int NAD27_Wisconsin_Cen = 32053;

        /** _more_          */
        public static final int NAD27_Wisconsin_South = 32054;

        /** _more_          */
        public static final int NAD27_Wyoming_East = 32055;

        /** _more_          */
        public static final int NAD27_Wyoming_E_Cen = 32056;

        /** _more_          */
        public static final int NAD27_Wyoming_W_Cen = 32057;

        /** _more_          */
        public static final int NAD27_Wyoming_West = 32058;

        /** _more_          */
        public static final int NAD27_Puerto_Rico = 32059;

        /** _more_          */
        public static final int NAD27_St_Croix = 32060;

        /** _more_          */
        public static final int NAD83_Montana = 32100;

        /** _more_          */
        public static final int NAD83_Nebraska = 32104;

        /** _more_          */
        public static final int NAD83_Nevada_East = 32107;

        /** _more_          */
        public static final int NAD83_Nevada_Central = 32108;

        /** _more_          */
        public static final int NAD83_Nevada_West = 32109;

        /** _more_          */
        public static final int NAD83_New_Hampshire = 32110;

        /** _more_          */
        public static final int NAD83_New_Jersey = 32111;

        /** _more_          */
        public static final int NAD83_New_Mexico_East = 32112;

        /** _more_          */
        public static final int NAD83_New_Mexico_Cent = 32113;

        /** _more_          */
        public static final int NAD83_New_Mexico_West = 32114;

        /** _more_          */
        public static final int NAD83_New_York_East = 32115;

        /** _more_          */
        public static final int NAD83_New_York_Central = 32116;

        /** _more_          */
        public static final int NAD83_New_York_West = 32117;

        /** _more_          */
        public static final int NAD83_New_York_Long_Is = 32118;

        /** _more_          */
        public static final int NAD83_North_Carolina = 32119;

        /** _more_          */
        public static final int NAD83_North_Dakota_N = 32120;

        /** _more_          */
        public static final int NAD83_North_Dakota_S = 32121;

        /** _more_          */
        public static final int NAD83_Ohio_North = 32122;

        /** _more_          */
        public static final int NAD83_Ohio_South = 32123;

        /** _more_          */
        public static final int NAD83_Oklahoma_North = 32124;

        /** _more_          */
        public static final int NAD83_Oklahoma_South = 32125;

        /** _more_          */
        public static final int NAD83_Oregon_North = 32126;

        /** _more_          */
        public static final int NAD83_Oregon_South = 32127;

        /** _more_          */
        public static final int NAD83_Pennsylvania_N = 32128;

        /** _more_          */
        public static final int NAD83_Pennsylvania_S = 32129;

        /** _more_          */
        public static final int NAD83_Rhode_Island = 32130;

        /** _more_          */
        public static final int NAD83_South_Carolina = 32133;

        /** _more_          */
        public static final int NAD83_South_Dakota_N = 32134;

        /** _more_          */
        public static final int NAD83_South_Dakota_S = 32135;

        /** _more_          */
        public static final int NAD83_Tennessee = 32136;

        /** _more_          */
        public static final int NAD83_Texas_North = 32137;

        /** _more_          */
        public static final int NAD83_Texas_North_Cen = 32138;

        /** _more_          */
        public static final int NAD83_Texas_Central = 32139;

        /** _more_          */
        public static final int NAD83_Texas_South_Cen = 32140;

        /** _more_          */
        public static final int NAD83_Texas_South = 32141;

        /** _more_          */
        public static final int NAD83_Utah_North = 32142;

        /** _more_          */
        public static final int NAD83_Utah_Central = 32143;

        /** _more_          */
        public static final int NAD83_Utah_South = 32144;

        /** _more_          */
        public static final int NAD83_Vermont = 32145;

        /** _more_          */
        public static final int NAD83_Virginia_North = 32146;

        /** _more_          */
        public static final int NAD83_Virginia_South = 32147;

        /** _more_          */
        public static final int NAD83_Washington_North = 32148;

        /** _more_          */
        public static final int NAD83_Washington_South = 32149;

        /** _more_          */
        public static final int NAD83_West_Virginia_N = 32150;

        /** _more_          */
        public static final int NAD83_West_Virginia_S = 32151;

        /** _more_          */
        public static final int NAD83_Wisconsin_North = 32152;

        /** _more_          */
        public static final int NAD83_Wisconsin_Cen = 32153;

        /** _more_          */
        public static final int NAD83_Wisconsin_South = 32154;

        /** _more_          */
        public static final int NAD83_Wyoming_East = 32155;

        /** _more_          */
        public static final int NAD83_Wyoming_E_Cen = 32156;

        /** _more_          */
        public static final int NAD83_Wyoming_W_Cen = 32157;

        /** _more_          */
        public static final int NAD83_Wyoming_West = 32158;

        /** _more_          */
        public static final int NAD83_Puerto_Rico_Virgin_Is = 32161;

        /** _more_          */
        public static final int WGS72_UTM_zone_1N = 32201;

        /** _more_          */
        public static final int WGS72_UTM_zone_2N = 32202;

        /** _more_          */
        public static final int WGS72_UTM_zone_3N = 32203;

        /** _more_          */
        public static final int WGS72_UTM_zone_4N = 32204;

        /** _more_          */
        public static final int WGS72_UTM_zone_5N = 32205;

        /** _more_          */
        public static final int WGS72_UTM_zone_6N = 32206;

        /** _more_          */
        public static final int WGS72_UTM_zone_7N = 32207;

        /** _more_          */
        public static final int WGS72_UTM_zone_8N = 32208;

        /** _more_          */
        public static final int WGS72_UTM_zone_9N = 32209;

        /** _more_          */
        public static final int WGS72_UTM_zone_10N = 32210;

        /** _more_          */
        public static final int WGS72_UTM_zone_11N = 32211;

        /** _more_          */
        public static final int WGS72_UTM_zone_12N = 32212;

        /** _more_          */
        public static final int WGS72_UTM_zone_13N = 32213;

        /** _more_          */
        public static final int WGS72_UTM_zone_14N = 32214;

        /** _more_          */
        public static final int WGS72_UTM_zone_15N = 32215;

        /** _more_          */
        public static final int WGS72_UTM_zone_16N = 32216;

        /** _more_          */
        public static final int WGS72_UTM_zone_17N = 32217;

        /** _more_          */
        public static final int WGS72_UTM_zone_18N = 32218;

        /** _more_          */
        public static final int WGS72_UTM_zone_19N = 32219;

        /** _more_          */
        public static final int WGS72_UTM_zone_20N = 32220;

        /** _more_          */
        public static final int WGS72_UTM_zone_21N = 32221;

        /** _more_          */
        public static final int WGS72_UTM_zone_22N = 32222;

        /** _more_          */
        public static final int WGS72_UTM_zone_23N = 32223;

        /** _more_          */
        public static final int WGS72_UTM_zone_24N = 32224;

        /** _more_          */
        public static final int WGS72_UTM_zone_25N = 32225;

        /** _more_          */
        public static final int WGS72_UTM_zone_26N = 32226;

        /** _more_          */
        public static final int WGS72_UTM_zone_27N = 32227;

        /** _more_          */
        public static final int WGS72_UTM_zone_28N = 32228;

        /** _more_          */
        public static final int WGS72_UTM_zone_29N = 32229;

        /** _more_          */
        public static final int WGS72_UTM_zone_30N = 32230;

        /** _more_          */
        public static final int WGS72_UTM_zone_31N = 32231;

        /** _more_          */
        public static final int WGS72_UTM_zone_32N = 32232;

        /** _more_          */
        public static final int WGS72_UTM_zone_33N = 32233;

        /** _more_          */
        public static final int WGS72_UTM_zone_34N = 32234;

        /** _more_          */
        public static final int WGS72_UTM_zone_35N = 32235;

        /** _more_          */
        public static final int WGS72_UTM_zone_36N = 32236;

        /** _more_          */
        public static final int WGS72_UTM_zone_37N = 32237;

        /** _more_          */
        public static final int WGS72_UTM_zone_38N = 32238;

        /** _more_          */
        public static final int WGS72_UTM_zone_39N = 32239;

        /** _more_          */
        public static final int WGS72_UTM_zone_40N = 32240;

        /** _more_          */
        public static final int WGS72_UTM_zone_41N = 32241;

        /** _more_          */
        public static final int WGS72_UTM_zone_42N = 32242;

        /** _more_          */
        public static final int WGS72_UTM_zone_43N = 32243;

        /** _more_          */
        public static final int WGS72_UTM_zone_44N = 32244;

        /** _more_          */
        public static final int WGS72_UTM_zone_45N = 32245;

        /** _more_          */
        public static final int WGS72_UTM_zone_46N = 32246;

        /** _more_          */
        public static final int WGS72_UTM_zone_47N = 32247;

        /** _more_          */
        public static final int WGS72_UTM_zone_48N = 32248;

        /** _more_          */
        public static final int WGS72_UTM_zone_49N = 32249;

        /** _more_          */
        public static final int WGS72_UTM_zone_50N = 32250;

        /** _more_          */
        public static final int WGS72_UTM_zone_51N = 32251;

        /** _more_          */
        public static final int WGS72_UTM_zone_52N = 32252;

        /** _more_          */
        public static final int WGS72_UTM_zone_53N = 32253;

        /** _more_          */
        public static final int WGS72_UTM_zone_54N = 32254;

        /** _more_          */
        public static final int WGS72_UTM_zone_55N = 32255;

        /** _more_          */
        public static final int WGS72_UTM_zone_56N = 32256;

        /** _more_          */
        public static final int WGS72_UTM_zone_57N = 32257;

        /** _more_          */
        public static final int WGS72_UTM_zone_58N = 32258;

        /** _more_          */
        public static final int WGS72_UTM_zone_59N = 32259;

        /** _more_          */
        public static final int WGS72_UTM_zone_60N = 32260;

        /** _more_          */
        public static final int WGS72_UTM_zone_1S = 32301;

        /** _more_          */
        public static final int WGS72_UTM_zone_2S = 32302;

        /** _more_          */
        public static final int WGS72_UTM_zone_3S = 32303;

        /** _more_          */
        public static final int WGS72_UTM_zone_4S = 32304;

        /** _more_          */
        public static final int WGS72_UTM_zone_5S = 32305;

        /** _more_          */
        public static final int WGS72_UTM_zone_6S = 32306;

        /** _more_          */
        public static final int WGS72_UTM_zone_7S = 32307;

        /** _more_          */
        public static final int WGS72_UTM_zone_8S = 32308;

        /** _more_          */
        public static final int WGS72_UTM_zone_9S = 32309;

        /** _more_          */
        public static final int WGS72_UTM_zone_10S = 32310;

        /** _more_          */
        public static final int WGS72_UTM_zone_11S = 32311;

        /** _more_          */
        public static final int WGS72_UTM_zone_12S = 32312;

        /** _more_          */
        public static final int WGS72_UTM_zone_13S = 32313;

        /** _more_          */
        public static final int WGS72_UTM_zone_14S = 32314;

        /** _more_          */
        public static final int WGS72_UTM_zone_15S = 32315;

        /** _more_          */
        public static final int WGS72_UTM_zone_16S = 32316;

        /** _more_          */
        public static final int WGS72_UTM_zone_17S = 32317;

        /** _more_          */
        public static final int WGS72_UTM_zone_18S = 32318;

        /** _more_          */
        public static final int WGS72_UTM_zone_19S = 32319;

        /** _more_          */
        public static final int WGS72_UTM_zone_20S = 32320;

        /** _more_          */
        public static final int WGS72_UTM_zone_21S = 32321;

        /** _more_          */
        public static final int WGS72_UTM_zone_22S = 32322;

        /** _more_          */
        public static final int WGS72_UTM_zone_23S = 32323;

        /** _more_          */
        public static final int WGS72_UTM_zone_24S = 32324;

        /** _more_          */
        public static final int WGS72_UTM_zone_25S = 32325;

        /** _more_          */
        public static final int WGS72_UTM_zone_26S = 32326;

        /** _more_          */
        public static final int WGS72_UTM_zone_27S = 32327;

        /** _more_          */
        public static final int WGS72_UTM_zone_28S = 32328;

        /** _more_          */
        public static final int WGS72_UTM_zone_29S = 32329;

        /** _more_          */
        public static final int WGS72_UTM_zone_30S = 32330;

        /** _more_          */
        public static final int WGS72_UTM_zone_31S = 32331;

        /** _more_          */
        public static final int WGS72_UTM_zone_32S = 32332;

        /** _more_          */
        public static final int WGS72_UTM_zone_33S = 32333;

        /** _more_          */
        public static final int WGS72_UTM_zone_34S = 32334;

        /** _more_          */
        public static final int WGS72_UTM_zone_35S = 32335;

        /** _more_          */
        public static final int WGS72_UTM_zone_36S = 32336;

        /** _more_          */
        public static final int WGS72_UTM_zone_37S = 32337;

        /** _more_          */
        public static final int WGS72_UTM_zone_38S = 32338;

        /** _more_          */
        public static final int WGS72_UTM_zone_39S = 32339;

        /** _more_          */
        public static final int WGS72_UTM_zone_40S = 32340;

        /** _more_          */
        public static final int WGS72_UTM_zone_41S = 32341;

        /** _more_          */
        public static final int WGS72_UTM_zone_42S = 32342;

        /** _more_          */
        public static final int WGS72_UTM_zone_43S = 32343;

        /** _more_          */
        public static final int WGS72_UTM_zone_44S = 32344;

        /** _more_          */
        public static final int WGS72_UTM_zone_45S = 32345;

        /** _more_          */
        public static final int WGS72_UTM_zone_46S = 32346;

        /** _more_          */
        public static final int WGS72_UTM_zone_47S = 32347;

        /** _more_          */
        public static final int WGS72_UTM_zone_48S = 32348;

        /** _more_          */
        public static final int WGS72_UTM_zone_49S = 32349;

        /** _more_          */
        public static final int WGS72_UTM_zone_50S = 32350;

        /** _more_          */
        public static final int WGS72_UTM_zone_51S = 32351;

        /** _more_          */
        public static final int WGS72_UTM_zone_52S = 32352;

        /** _more_          */
        public static final int WGS72_UTM_zone_53S = 32353;

        /** _more_          */
        public static final int WGS72_UTM_zone_54S = 32354;

        /** _more_          */
        public static final int WGS72_UTM_zone_55S = 32355;

        /** _more_          */
        public static final int WGS72_UTM_zone_56S = 32356;

        /** _more_          */
        public static final int WGS72_UTM_zone_57S = 32357;

        /** _more_          */
        public static final int WGS72_UTM_zone_58S = 32358;

        /** _more_          */
        public static final int WGS72_UTM_zone_59S = 32359;

        /** _more_          */
        public static final int WGS72_UTM_zone_60S = 32360;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_1N = 32401;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_2N = 32402;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_3N = 32403;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_4N = 32404;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_5N = 32405;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_6N = 32406;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_7N = 32407;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_8N = 32408;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_9N = 32409;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_10N = 32410;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_11N = 32411;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_12N = 32412;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_13N = 32413;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_14N = 32414;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_15N = 32415;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_16N = 32416;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_17N = 32417;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_18N = 32418;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_19N = 32419;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_20N = 32420;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_21N = 32421;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_22N = 32422;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_23N = 32423;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_24N = 32424;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_25N = 32425;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_26N = 32426;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_27N = 32427;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_28N = 32428;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_29N = 32429;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_30N = 32430;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_31N = 32431;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_32N = 32432;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_33N = 32433;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_34N = 32434;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_35N = 32435;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_36N = 32436;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_37N = 32437;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_38N = 32438;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_39N = 32439;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_40N = 32440;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_41N = 32441;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_42N = 32442;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_43N = 32443;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_44N = 32444;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_45N = 32445;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_46N = 32446;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_47N = 32447;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_48N = 32448;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_49N = 32449;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_50N = 32450;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_51N = 32451;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_52N = 32452;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_53N = 32453;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_54N = 32454;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_55N = 32455;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_56N = 32456;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_57N = 32457;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_58N = 32458;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_59N = 32459;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_60N = 32460;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_1S = 32501;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_2S = 32502;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_3S = 32503;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_4S = 32504;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_5S = 32505;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_6S = 32506;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_7S = 32507;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_8S = 32508;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_9S = 32509;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_10S = 32510;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_11S = 32511;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_12S = 32512;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_13S = 32513;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_14S = 32514;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_15S = 32515;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_16S = 32516;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_17S = 32517;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_18S = 32518;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_19S = 32519;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_20S = 32520;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_21S = 32521;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_22S = 32522;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_23S = 32523;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_24S = 32524;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_25S = 32525;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_26S = 32526;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_27S = 32527;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_28S = 32528;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_29S = 32529;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_30S = 32530;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_31S = 32531;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_32S = 32532;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_33S = 32533;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_34S = 32534;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_35S = 32535;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_36S = 32536;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_37S = 32537;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_38S = 32538;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_39S = 32539;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_40S = 32540;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_41S = 32541;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_42S = 32542;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_43S = 32543;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_44S = 32544;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_45S = 32545;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_46S = 32546;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_47S = 32547;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_48S = 32548;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_49S = 32549;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_50S = 32550;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_51S = 32551;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_52S = 32552;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_53S = 32553;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_54S = 32554;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_55S = 32555;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_56S = 32556;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_57S = 32557;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_58S = 32558;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_59S = 32559;

        /** _more_          */
        public static final int WGS72BE_UTM_zone_60S = 32560;

        /** _more_          */
        public static final int WGS84_UTM_zone_1N = 32601;

        /** _more_          */
        public static final int WGS84_UTM_zone_2N = 32602;

        /** _more_          */
        public static final int WGS84_UTM_zone_3N = 32603;

        /** _more_          */
        public static final int WGS84_UTM_zone_4N = 32604;

        /** _more_          */
        public static final int WGS84_UTM_zone_5N = 32605;

        /** _more_          */
        public static final int WGS84_UTM_zone_6N = 32606;

        /** _more_          */
        public static final int WGS84_UTM_zone_7N = 32607;

        /** _more_          */
        public static final int WGS84_UTM_zone_8N = 32608;

        /** _more_          */
        public static final int WGS84_UTM_zone_9N = 32609;

        /** _more_          */
        public static final int WGS84_UTM_zone_10N = 32610;

        /** _more_          */
        public static final int WGS84_UTM_zone_11N = 32611;

        /** _more_          */
        public static final int WGS84_UTM_zone_12N = 32612;

        /** _more_          */
        public static final int WGS84_UTM_zone_13N = 32613;

        /** _more_          */
        public static final int WGS84_UTM_zone_14N = 32614;

        /** _more_          */
        public static final int WGS84_UTM_zone_15N = 32615;

        /** _more_          */
        public static final int WGS84_UTM_zone_16N = 32616;

        /** _more_          */
        public static final int WGS84_UTM_zone_17N = 32617;

        /** _more_          */
        public static final int WGS84_UTM_zone_18N = 32618;

        /** _more_          */
        public static final int WGS84_UTM_zone_19N = 32619;

        /** _more_          */
        public static final int WGS84_UTM_zone_20N = 32620;

        /** _more_          */
        public static final int WGS84_UTM_zone_21N = 32621;

        /** _more_          */
        public static final int WGS84_UTM_zone_22N = 32622;

        /** _more_          */
        public static final int WGS84_UTM_zone_23N = 32623;

        /** _more_          */
        public static final int WGS84_UTM_zone_24N = 32624;

        /** _more_          */
        public static final int WGS84_UTM_zone_25N = 32625;

        /** _more_          */
        public static final int WGS84_UTM_zone_26N = 32626;

        /** _more_          */
        public static final int WGS84_UTM_zone_27N = 32627;

        /** _more_          */
        public static final int WGS84_UTM_zone_28N = 32628;

        /** _more_          */
        public static final int WGS84_UTM_zone_29N = 32629;

        /** _more_          */
        public static final int WGS84_UTM_zone_30N = 32630;

        /** _more_          */
        public static final int WGS84_UTM_zone_31N = 32631;

        /** _more_          */
        public static final int WGS84_UTM_zone_32N = 32632;

        /** _more_          */
        public static final int WGS84_UTM_zone_33N = 32633;

        /** _more_          */
        public static final int WGS84_UTM_zone_34N = 32634;

        /** _more_          */
        public static final int WGS84_UTM_zone_35N = 32635;

        /** _more_          */
        public static final int WGS84_UTM_zone_36N = 32636;

        /** _more_          */
        public static final int WGS84_UTM_zone_37N = 32637;

        /** _more_          */
        public static final int WGS84_UTM_zone_38N = 32638;

        /** _more_          */
        public static final int WGS84_UTM_zone_39N = 32639;

        /** _more_          */
        public static final int WGS84_UTM_zone_40N = 32640;

        /** _more_          */
        public static final int WGS84_UTM_zone_41N = 32641;

        /** _more_          */
        public static final int WGS84_UTM_zone_42N = 32642;

        /** _more_          */
        public static final int WGS84_UTM_zone_43N = 32643;

        /** _more_          */
        public static final int WGS84_UTM_zone_44N = 32644;

        /** _more_          */
        public static final int WGS84_UTM_zone_45N = 32645;

        /** _more_          */
        public static final int WGS84_UTM_zone_46N = 32646;

        /** _more_          */
        public static final int WGS84_UTM_zone_47N = 32647;

        /** _more_          */
        public static final int WGS84_UTM_zone_48N = 32648;

        /** _more_          */
        public static final int WGS84_UTM_zone_49N = 32649;

        /** _more_          */
        public static final int WGS84_UTM_zone_50N = 32650;

        /** _more_          */
        public static final int WGS84_UTM_zone_51N = 32651;

        /** _more_          */
        public static final int WGS84_UTM_zone_52N = 32652;

        /** _more_          */
        public static final int WGS84_UTM_zone_53N = 32653;

        /** _more_          */
        public static final int WGS84_UTM_zone_54N = 32654;

        /** _more_          */
        public static final int WGS84_UTM_zone_55N = 32655;

        /** _more_          */
        public static final int WGS84_UTM_zone_56N = 32656;

        /** _more_          */
        public static final int WGS84_UTM_zone_57N = 32657;

        /** _more_          */
        public static final int WGS84_UTM_zone_58N = 32658;

        /** _more_          */
        public static final int WGS84_UTM_zone_59N = 32659;

        /** _more_          */
        public static final int WGS84_UTM_zone_60N = 32660;

        /** _more_          */
        public static final int WGS84_UTM_zone_1S = 32701;

        /** _more_          */
        public static final int WGS84_UTM_zone_2S = 32702;

        /** _more_          */
        public static final int WGS84_UTM_zone_3S = 32703;

        /** _more_          */
        public static final int WGS84_UTM_zone_4S = 32704;

        /** _more_          */
        public static final int WGS84_UTM_zone_5S = 32705;

        /** _more_          */
        public static final int WGS84_UTM_zone_6S = 32706;

        /** _more_          */
        public static final int WGS84_UTM_zone_7S = 32707;

        /** _more_          */
        public static final int WGS84_UTM_zone_8S = 32708;

        /** _more_          */
        public static final int WGS84_UTM_zone_9S = 32709;

        /** _more_          */
        public static final int WGS84_UTM_zone_10S = 32710;

        /** _more_          */
        public static final int WGS84_UTM_zone_11S = 32711;

        /** _more_          */
        public static final int WGS84_UTM_zone_12S = 32712;

        /** _more_          */
        public static final int WGS84_UTM_zone_13S = 32713;

        /** _more_          */
        public static final int WGS84_UTM_zone_14S = 32714;

        /** _more_          */
        public static final int WGS84_UTM_zone_15S = 32715;

        /** _more_          */
        public static final int WGS84_UTM_zone_16S = 32716;

        /** _more_          */
        public static final int WGS84_UTM_zone_17S = 32717;

        /** _more_          */
        public static final int WGS84_UTM_zone_18S = 32718;

        /** _more_          */
        public static final int WGS84_UTM_zone_19S = 32719;

        /** _more_          */
        public static final int WGS84_UTM_zone_20S = 32720;

        /** _more_          */
        public static final int WGS84_UTM_zone_21S = 32721;

        /** _more_          */
        public static final int WGS84_UTM_zone_22S = 32722;

        /** _more_          */
        public static final int WGS84_UTM_zone_23S = 32723;

        /** _more_          */
        public static final int WGS84_UTM_zone_24S = 32724;

        /** _more_          */
        public static final int WGS84_UTM_zone_25S = 32725;

        /** _more_          */
        public static final int WGS84_UTM_zone_26S = 32726;

        /** _more_          */
        public static final int WGS84_UTM_zone_27S = 32727;

        /** _more_          */
        public static final int WGS84_UTM_zone_28S = 32728;

        /** _more_          */
        public static final int WGS84_UTM_zone_29S = 32729;

        /** _more_          */
        public static final int WGS84_UTM_zone_30S = 32730;

        /** _more_          */
        public static final int WGS84_UTM_zone_31S = 32731;

        /** _more_          */
        public static final int WGS84_UTM_zone_32S = 32732;

        /** _more_          */
        public static final int WGS84_UTM_zone_33S = 32733;

        /** _more_          */
        public static final int WGS84_UTM_zone_34S = 32734;

        /** _more_          */
        public static final int WGS84_UTM_zone_35S = 32735;

        /** _more_          */
        public static final int WGS84_UTM_zone_36S = 32736;

        /** _more_          */
        public static final int WGS84_UTM_zone_37S = 32737;

        /** _more_          */
        public static final int WGS84_UTM_zone_38S = 32738;

        /** _more_          */
        public static final int WGS84_UTM_zone_39S = 32739;

        /** _more_          */
        public static final int WGS84_UTM_zone_40S = 32740;

        /** _more_          */
        public static final int WGS84_UTM_zone_41S = 32741;

        /** _more_          */
        public static final int WGS84_UTM_zone_42S = 32742;

        /** _more_          */
        public static final int WGS84_UTM_zone_43S = 32743;

        /** _more_          */
        public static final int WGS84_UTM_zone_44S = 32744;

        /** _more_          */
        public static final int WGS84_UTM_zone_45S = 32745;

        /** _more_          */
        public static final int WGS84_UTM_zone_46S = 32746;

        /** _more_          */
        public static final int WGS84_UTM_zone_47S = 32747;

        /** _more_          */
        public static final int WGS84_UTM_zone_48S = 32748;

        /** _more_          */
        public static final int WGS84_UTM_zone_49S = 32749;

        /** _more_          */
        public static final int WGS84_UTM_zone_50S = 32750;

        /** _more_          */
        public static final int WGS84_UTM_zone_51S = 32751;

        /** _more_          */
        public static final int WGS84_UTM_zone_52S = 32752;

        /** _more_          */
        public static final int WGS84_UTM_zone_53S = 32753;

        /** _more_          */
        public static final int WGS84_UTM_zone_54S = 32754;

        /** _more_          */
        public static final int WGS84_UTM_zone_55S = 32755;

        /** _more_          */
        public static final int WGS84_UTM_zone_56S = 32756;

        /** _more_          */
        public static final int WGS84_UTM_zone_57S = 32757;

        /** _more_          */
        public static final int WGS84_UTM_zone_58S = 32758;

        /** _more_          */
        public static final int WGS84_UTM_zone_59S = 32759;

        /** _more_          */
        public static final int WGS84_UTM_zone_60S = 32760;


        /** _more_          */
        public static final int values[] = {
            Adindan_UTM_zone_37N, Adindan_UTM_zone_38N, AGD66_AMG_zone_48,
            AGD66_AMG_zone_49, AGD66_AMG_zone_50, AGD66_AMG_zone_51,
            AGD66_AMG_zone_52, AGD66_AMG_zone_53, AGD66_AMG_zone_54,
            AGD66_AMG_zone_55, AGD66_AMG_zone_56, AGD66_AMG_zone_57,
            AGD66_AMG_zone_58, AGD84_AMG_zone_48, AGD84_AMG_zone_49,
            AGD84_AMG_zone_50, AGD84_AMG_zone_51, AGD84_AMG_zone_52,
            AGD84_AMG_zone_53, AGD84_AMG_zone_54, AGD84_AMG_zone_55,
            AGD84_AMG_zone_56, AGD84_AMG_zone_57, AGD84_AMG_zone_58,
            Ain_el_Abd_UTM_zone_37N, Ain_el_Abd_UTM_zone_38N,
            Ain_el_Abd_UTM_zone_39N, Ain_el_Abd_Bahrain_Grid,
            Afgooye_UTM_zone_38N, Afgooye_UTM_zone_39N, Lisbon_Portugese_Grid,
            Aratu_UTM_zone_22S, Aratu_UTM_zone_23S, Aratu_UTM_zone_24S,
            Arc_1950_Lo13, Arc_1950_Lo15, Arc_1950_Lo17, Arc_1950_Lo19,
            Arc_1950_Lo21, Arc_1950_Lo23, Arc_1950_Lo25, Arc_1950_Lo27,
            Arc_1950_Lo29, Arc_1950_Lo31, Arc_1950_Lo33, Arc_1950_Lo35,
            Batavia_NEIEZ, Batavia_UTM_zone_48S, Batavia_UTM_zone_49S,
            Batavia_UTM_zone_50S, Beijing_Gauss_zone_13,
            Beijing_Gauss_zone_14, Beijing_Gauss_zone_15,
            Beijing_Gauss_zone_16, Beijing_Gauss_zone_17,
            Beijing_Gauss_zone_18, Beijing_Gauss_zone_19,
            Beijing_Gauss_zone_20, Beijing_Gauss_zone_21,
            Beijing_Gauss_zone_22, Beijing_Gauss_zone_23, Beijing_Gauss_13N,
            Beijing_Gauss_14N, Beijing_Gauss_15N, Beijing_Gauss_16N,
            Beijing_Gauss_17N, Beijing_Gauss_18N, Beijing_Gauss_19N,
            Beijing_Gauss_20N, Beijing_Gauss_21N, Beijing_Gauss_22N,
            Beijing_Gauss_23N, Belge_Lambert_50, Bern_1898_Swiss_Old,
            Bogota_UTM_zone_17N, Bogota_UTM_zone_18N, Bogota_Colombia_3W,
            Bogota_Colombia_Bogota, Bogota_Colombia_3E, Bogota_Colombia_6E,
            Camacupa_UTM_32S, Camacupa_UTM_33S, C_Inchauspe_Argentina_1,
            C_Inchauspe_Argentina_2, C_Inchauspe_Argentina_3,
            C_Inchauspe_Argentina_4, C_Inchauspe_Argentina_5,
            C_Inchauspe_Argentina_6, C_Inchauspe_Argentina_7,
            Carthage_UTM_zone_32N, Carthage_Nord_Tunisie,
            Carthage_Sud_Tunisie, Corrego_Alegre_UTM_23S,
            Corrego_Alegre_UTM_24S, Douala_UTM_zone_32N, Egypt_1907_Red_Belt,
            Egypt_1907_Purple_Belt, Egypt_1907_Ext_Purple, ED50_UTM_zone_28N,
            ED50_UTM_zone_29N, ED50_UTM_zone_30N, ED50_UTM_zone_31N,
            ED50_UTM_zone_32N, ED50_UTM_zone_33N, ED50_UTM_zone_34N,
            ED50_UTM_zone_35N, ED50_UTM_zone_36N, ED50_UTM_zone_37N,
            ED50_UTM_zone_38N, Fahud_UTM_zone_39N, Fahud_UTM_zone_40N,
            Garoua_UTM_zone_33N, ID74_UTM_zone_46N, ID74_UTM_zone_47N,
            ID74_UTM_zone_48N, ID74_UTM_zone_49N, ID74_UTM_zone_50N,
            ID74_UTM_zone_51N, ID74_UTM_zone_52N, ID74_UTM_zone_53N,
            ID74_UTM_zone_46S, ID74_UTM_zone_47S, ID74_UTM_zone_48S,
            ID74_UTM_zone_49S, ID74_UTM_zone_50S, ID74_UTM_zone_51S,
            ID74_UTM_zone_52S, ID74_UTM_zone_53S, ID74_UTM_zone_54S,
            Indian_1954_UTM_47N, Indian_1954_UTM_48N, Indian_1975_UTM_47N,
            Indian_1975_UTM_48N, Jamaica_1875_Old_Grid, JAD69_Jamaica_Grid,
            Kalianpur_India_0, Kalianpur_India_I, Kalianpur_India_IIa,
            Kalianpur_India_IIIa, Kalianpur_India_IVa, Kalianpur_India_IIb,
            Kalianpur_India_IIIb, Kalianpur_India_IVb, Kertau_Singapore_Grid,
            Kertau_UTM_zone_47N, Kertau_UTM_zone_48N, La_Canoa_UTM_zone_20N,
            La_Canoa_UTM_zone_21N, PSAD56_UTM_zone_18N, PSAD56_UTM_zone_19N,
            PSAD56_UTM_zone_20N, PSAD56_UTM_zone_21N, PSAD56_UTM_zone_17S,
            PSAD56_UTM_zone_18S, PSAD56_UTM_zone_19S, PSAD56_UTM_zone_20S,
            PSAD56_Peru_west_zone, PSAD56_Peru_central, PSAD56_Peru_east_zone,
            Leigon_Ghana_Grid, Lome_UTM_zone_31N, Luzon_Philippines_I,
            Luzon_Philippines_II, Luzon_Philippines_III, Luzon_Philippines_IV,
            Luzon_Philippines_V, Makassar_NEIEZ, Malongo_1987_UTM_32S,
            Merchich_Nord_Maroc, Merchich_Sud_Maroc, Merchich_Sahara,
            Massawa_UTM_zone_37N, Minna_UTM_zone_31N, Minna_UTM_zone_32N,
            Minna_Nigeria_West, Minna_Nigeria_Mid_Belt, Minna_Nigeria_East,
            Mhast_UTM_zone_32S, Monte_Mario_Italy_1, Monte_Mario_Italy_2,
            M_poraloko_UTM_32N, M_poraloko_UTM_32S, NAD27_UTM_zone_3N,
            NAD27_UTM_zone_4N, NAD27_UTM_zone_5N, NAD27_UTM_zone_6N,
            NAD27_UTM_zone_7N, NAD27_UTM_zone_8N, NAD27_UTM_zone_9N,
            NAD27_UTM_zone_10N, NAD27_UTM_zone_11N, NAD27_UTM_zone_12N,
            NAD27_UTM_zone_13N, NAD27_UTM_zone_14N, NAD27_UTM_zone_15N,
            NAD27_UTM_zone_16N, NAD27_UTM_zone_17N, NAD27_UTM_zone_18N,
            NAD27_UTM_zone_19N, NAD27_UTM_zone_20N, NAD27_UTM_zone_21N,
            NAD27_UTM_zone_22N, NAD27_Alabama_East, NAD27_Alabama_West,
            NAD27_Alaska_zone_1, NAD27_Alaska_zone_2, NAD27_Alaska_zone_3,
            NAD27_Alaska_zone_4, NAD27_Alaska_zone_5, NAD27_Alaska_zone_6,
            NAD27_Alaska_zone_7, NAD27_Alaska_zone_8, NAD27_Alaska_zone_9,
            NAD27_Alaska_zone_10, NAD27_California_I, NAD27_California_II,
            NAD27_California_III, NAD27_California_IV, NAD27_California_V,
            NAD27_California_VI, NAD27_California_VII, NAD27_Arizona_East,
            NAD27_Arizona_Central, NAD27_Arizona_West, NAD27_Arkansas_North,
            NAD27_Arkansas_South, NAD27_Colorado_North,
            NAD27_Colorado_Central, NAD27_Colorado_South, NAD27_Connecticut,
            NAD27_Delaware, NAD27_Florida_East, NAD27_Florida_West,
            NAD27_Florida_North, NAD27_Hawaii_zone_1, NAD27_Hawaii_zone_2,
            NAD27_Hawaii_zone_3, NAD27_Hawaii_zone_4, NAD27_Hawaii_zone_5,
            NAD27_Georgia_East, NAD27_Georgia_West, NAD27_Idaho_East,
            NAD27_Idaho_Central, NAD27_Idaho_West, NAD27_Illinois_East,
            NAD27_Illinois_West, NAD27_Indiana_East, NAD27_BLM_14N_feet,
            NAD27_Indiana_West, NAD27_BLM_15N_feet, NAD27_Iowa_North,
            NAD27_BLM_16N_feet, NAD27_Iowa_South, NAD27_BLM_17N_feet,
            NAD27_Kansas_North, NAD27_Kansas_South, NAD27_Kentucky_North,
            NAD27_Kentucky_South, NAD27_Louisiana_North,
            NAD27_Louisiana_South, NAD27_Maine_East, NAD27_Maine_West,
            NAD27_Maryland, NAD27_Massachusetts, NAD27_Massachusetts_Is,
            NAD27_Michigan_North, NAD27_Michigan_Central,
            NAD27_Michigan_South, NAD27_Minnesota_North, NAD27_Minnesota_Cent,
            NAD27_Minnesota_South, NAD27_Mississippi_East,
            NAD27_Mississippi_West, NAD27_Missouri_East,
            NAD27_Missouri_Central, NAD27_Missouri_West,
            NAD_Michigan_Michigan_East, NAD_Michigan_Michigan_Old_Central,
            NAD_Michigan_Michigan_West, NAD83_UTM_zone_3N, NAD83_UTM_zone_4N,
            NAD83_UTM_zone_5N, NAD83_UTM_zone_6N, NAD83_UTM_zone_7N,
            NAD83_UTM_zone_8N, NAD83_UTM_zone_9N, NAD83_UTM_zone_10N,
            NAD83_UTM_zone_11N, NAD83_UTM_zone_12N, NAD83_UTM_zone_13N,
            NAD83_UTM_zone_14N, NAD83_UTM_zone_15N, NAD83_UTM_zone_16N,
            NAD83_UTM_zone_17N, NAD83_UTM_zone_18N, NAD83_UTM_zone_19N,
            NAD83_UTM_zone_20N, NAD83_UTM_zone_21N, NAD83_UTM_zone_22N,
            NAD83_UTM_zone_23N, NAD83_Alabama_East, NAD83_Alabama_West,
            NAD83_Alaska_zone_1, NAD83_Alaska_zone_2, NAD83_Alaska_zone_3,
            NAD83_Alaska_zone_4, NAD83_Alaska_zone_5, NAD83_Alaska_zone_6,
            NAD83_Alaska_zone_7, NAD83_Alaska_zone_8, NAD83_Alaska_zone_9,
            NAD83_Alaska_zone_10, NAD83_California_1, NAD83_California_2,
            NAD83_California_3, NAD83_California_4, NAD83_California_5,
            NAD83_California_6, NAD83_Arizona_East, NAD83_Arizona_Central,
            NAD83_Arizona_West, NAD83_Arkansas_North, NAD83_Arkansas_South,
            NAD83_Colorado_North, NAD83_Colorado_Central,
            NAD83_Colorado_South, NAD83_Connecticut, NAD83_Delaware,
            NAD83_Florida_East, NAD83_Florida_West, NAD83_Florida_North,
            NAD83_Hawaii_zone_1, NAD83_Hawaii_zone_2, NAD83_Hawaii_zone_3,
            NAD83_Hawaii_zone_4, NAD83_Hawaii_zone_5, NAD83_Georgia_East,
            NAD83_Georgia_West, NAD83_Idaho_East, NAD83_Idaho_Central,
            NAD83_Idaho_West, NAD83_Illinois_East, NAD83_Illinois_West,
            NAD83_Indiana_East, NAD83_Indiana_West, NAD83_Iowa_North,
            NAD83_Iowa_South, NAD83_Kansas_North, NAD83_Kansas_South,
            NAD83_Kentucky_North, NAD83_Kentucky_South, NAD83_Louisiana_North,
            NAD83_Louisiana_South, NAD83_Maine_East, NAD83_Maine_West,
            NAD83_Maryland, NAD83_Massachusetts, NAD83_Massachusetts_Is,
            NAD83_Michigan_North, NAD83_Michigan_Central,
            NAD83_Michigan_South, NAD83_Minnesota_North, NAD83_Minnesota_Cent,
            NAD83_Minnesota_South, NAD83_Mississippi_East,
            NAD83_Mississippi_West, NAD83_Missouri_East,
            NAD83_Missouri_Central, NAD83_Missouri_West, Nahrwan_1967_UTM_38N,
            Nahrwan_1967_UTM_39N, Nahrwan_1967_UTM_40N, Naparima_UTM_20N,
            GD49_NZ_Map_Grid, GD49_North_Island_Grid, GD49_South_Island_Grid,
            Datum_73_UTM_zone_29N, ATF_Nord_de_Guerre, NTF_France_I,
            NTF_France_II, NTF_France_III, NTF_Nord_France, NTF_Centre_France,
            NTF_Sud_France, British_National_Grid, Point_Noire_UTM_32S,
            GDA94_MGA_zone_48, GDA94_MGA_zone_49, GDA94_MGA_zone_50,
            GDA94_MGA_zone_51, GDA94_MGA_zone_52, GDA94_MGA_zone_53,
            GDA94_MGA_zone_54, GDA94_MGA_zone_55, GDA94_MGA_zone_56,
            GDA94_MGA_zone_57, GDA94_MGA_zone_58, Pulkovo_Gauss_zone_4,
            Pulkovo_Gauss_zone_5, Pulkovo_Gauss_zone_6, Pulkovo_Gauss_zone_7,
            Pulkovo_Gauss_zone_8, Pulkovo_Gauss_zone_9, Pulkovo_Gauss_zone_10,
            Pulkovo_Gauss_zone_11, Pulkovo_Gauss_zone_12,
            Pulkovo_Gauss_zone_13, Pulkovo_Gauss_zone_14,
            Pulkovo_Gauss_zone_15, Pulkovo_Gauss_zone_16,
            Pulkovo_Gauss_zone_17, Pulkovo_Gauss_zone_18,
            Pulkovo_Gauss_zone_19, Pulkovo_Gauss_zone_20,
            Pulkovo_Gauss_zone_21, Pulkovo_Gauss_zone_22,
            Pulkovo_Gauss_zone_23, Pulkovo_Gauss_zone_24,
            Pulkovo_Gauss_zone_25, Pulkovo_Gauss_zone_26,
            Pulkovo_Gauss_zone_27, Pulkovo_Gauss_zone_28,
            Pulkovo_Gauss_zone_29, Pulkovo_Gauss_zone_30,
            Pulkovo_Gauss_zone_31, Pulkovo_Gauss_zone_32, Pulkovo_Gauss_4N,
            Pulkovo_Gauss_5N, Pulkovo_Gauss_6N, Pulkovo_Gauss_7N,
            Pulkovo_Gauss_8N, Pulkovo_Gauss_9N, Pulkovo_Gauss_10N,
            Pulkovo_Gauss_11N, Pulkovo_Gauss_12N, Pulkovo_Gauss_13N,
            Pulkovo_Gauss_14N, Pulkovo_Gauss_15N, Pulkovo_Gauss_16N,
            Pulkovo_Gauss_17N, Pulkovo_Gauss_18N, Pulkovo_Gauss_19N,
            Pulkovo_Gauss_20N, Pulkovo_Gauss_21N, Pulkovo_Gauss_22N,
            Pulkovo_Gauss_23N, Pulkovo_Gauss_24N, Pulkovo_Gauss_25N,
            Pulkovo_Gauss_26N, Pulkovo_Gauss_27N, Pulkovo_Gauss_28N,
            Pulkovo_Gauss_29N, Pulkovo_Gauss_30N, Pulkovo_Gauss_31N,
            Pulkovo_Gauss_32N, Qatar_National_Grid, RD_Netherlands_Old,
            RD_Netherlands_New, SAD69_UTM_zone_18N, SAD69_UTM_zone_19N,
            SAD69_UTM_zone_20N, SAD69_UTM_zone_21N, SAD69_UTM_zone_22N,
            SAD69_UTM_zone_17S, SAD69_UTM_zone_18S, SAD69_UTM_zone_19S,
            SAD69_UTM_zone_20S, SAD69_UTM_zone_21S, SAD69_UTM_zone_22S,
            SAD69_UTM_zone_23S, SAD69_UTM_zone_24S, SAD69_UTM_zone_25S,
            Sapper_Hill_UTM_20S, Sapper_Hill_UTM_21S, Schwarzeck_UTM_33S,
            Sudan_UTM_zone_35N, Sudan_UTM_zone_36N, Tananarive_Laborde,
            Tananarive_UTM_38S, Tananarive_UTM_39S, Timbalai_1948_Borneo,
            Timbalai_1948_UTM_49N, Timbalai_1948_UTM_50N, TM65_Irish_Nat_Grid,
            Trinidad_1903_Trinidad, TC_1948_UTM_zone_39N,
            TC_1948_UTM_zone_40N, Voirol_N_Algerie_ancien,
            Voirol_S_Algerie_ancien, Voirol_Unifie_N_Algerie,
            Voirol_Unifie_S_Algerie, Bern_1938_Swiss_New, Nord_Sahara_UTM_29N,
            Nord_Sahara_UTM_30N, Nord_Sahara_UTM_31N, Nord_Sahara_UTM_32N,
            Yoff_UTM_zone_28N, Zanderij_UTM_zone_21N, MGI_Austria_West,
            MGI_Austria_Central, MGI_Austria_East, Belge_Lambert_72,
            DHDN_Germany_zone_1, DHDN_Germany_zone_2, DHDN_Germany_zone_3,
            DHDN_Germany_zone_4, DHDN_Germany_zone_5, NAD27_Montana_North,
            NAD27_Montana_Central, NAD27_Montana_South, NAD27_Nebraska_North,
            NAD27_Nebraska_South, NAD27_Nevada_East, NAD27_Nevada_Central,
            NAD27_Nevada_West, NAD27_New_Hampshire, NAD27_New_Jersey,
            NAD27_New_Mexico_East, NAD27_New_Mexico_Cent,
            NAD27_New_Mexico_West, NAD27_New_York_East,
            NAD27_New_York_Central, NAD27_New_York_West,
            NAD27_New_York_Long_Is, NAD27_North_Carolina,
            NAD27_North_Dakota_N, NAD27_North_Dakota_S, NAD27_Ohio_North,
            NAD27_Ohio_South, NAD27_Oklahoma_North, NAD27_Oklahoma_South,
            NAD27_Oregon_North, NAD27_Oregon_South, NAD27_Pennsylvania_N,
            NAD27_Pennsylvania_S, NAD27_Rhode_Island, NAD27_South_Carolina_N,
            NAD27_South_Carolina_S, NAD27_South_Dakota_N,
            NAD27_South_Dakota_S, NAD27_Tennessee, NAD27_Texas_North,
            NAD27_Texas_North_Cen, NAD27_Texas_Central, NAD27_Texas_South_Cen,
            NAD27_Texas_South, NAD27_Utah_North, NAD27_Utah_Central,
            NAD27_Utah_South, NAD27_Vermont, NAD27_Virginia_North,
            NAD27_Virginia_South, NAD27_Washington_North,
            NAD27_Washington_South, NAD27_West_Virginia_N,
            NAD27_West_Virginia_S, NAD27_Wisconsin_North, NAD27_Wisconsin_Cen,
            NAD27_Wisconsin_South, NAD27_Wyoming_East, NAD27_Wyoming_E_Cen,
            NAD27_Wyoming_W_Cen, NAD27_Wyoming_West, NAD27_Puerto_Rico,
            NAD27_St_Croix, NAD83_Montana, NAD83_Nebraska, NAD83_Nevada_East,
            NAD83_Nevada_Central, NAD83_Nevada_West, NAD83_New_Hampshire,
            NAD83_New_Jersey, NAD83_New_Mexico_East, NAD83_New_Mexico_Cent,
            NAD83_New_Mexico_West, NAD83_New_York_East,
            NAD83_New_York_Central, NAD83_New_York_West,
            NAD83_New_York_Long_Is, NAD83_North_Carolina,
            NAD83_North_Dakota_N, NAD83_North_Dakota_S, NAD83_Ohio_North,
            NAD83_Ohio_South, NAD83_Oklahoma_North, NAD83_Oklahoma_South,
            NAD83_Oregon_North, NAD83_Oregon_South, NAD83_Pennsylvania_N,
            NAD83_Pennsylvania_S, NAD83_Rhode_Island, NAD83_South_Carolina,
            NAD83_South_Dakota_N, NAD83_South_Dakota_S, NAD83_Tennessee,
            NAD83_Texas_North, NAD83_Texas_North_Cen, NAD83_Texas_Central,
            NAD83_Texas_South_Cen, NAD83_Texas_South, NAD83_Utah_North,
            NAD83_Utah_Central, NAD83_Utah_South, NAD83_Vermont,
            NAD83_Virginia_North, NAD83_Virginia_South,
            NAD83_Washington_North, NAD83_Washington_South,
            NAD83_West_Virginia_N, NAD83_West_Virginia_S,
            NAD83_Wisconsin_North, NAD83_Wisconsin_Cen, NAD83_Wisconsin_South,
            NAD83_Wyoming_East, NAD83_Wyoming_E_Cen, NAD83_Wyoming_W_Cen,
            NAD83_Wyoming_West, NAD83_Puerto_Rico_Virgin_Is,
            WGS72_UTM_zone_1N, WGS72_UTM_zone_2N, WGS72_UTM_zone_3N,
            WGS72_UTM_zone_4N, WGS72_UTM_zone_5N, WGS72_UTM_zone_6N,
            WGS72_UTM_zone_7N, WGS72_UTM_zone_8N, WGS72_UTM_zone_9N,
            WGS72_UTM_zone_10N, WGS72_UTM_zone_11N, WGS72_UTM_zone_12N,
            WGS72_UTM_zone_13N, WGS72_UTM_zone_14N, WGS72_UTM_zone_15N,
            WGS72_UTM_zone_16N, WGS72_UTM_zone_17N, WGS72_UTM_zone_18N,
            WGS72_UTM_zone_19N, WGS72_UTM_zone_20N, WGS72_UTM_zone_21N,
            WGS72_UTM_zone_22N, WGS72_UTM_zone_23N, WGS72_UTM_zone_24N,
            WGS72_UTM_zone_25N, WGS72_UTM_zone_26N, WGS72_UTM_zone_27N,
            WGS72_UTM_zone_28N, WGS72_UTM_zone_29N, WGS72_UTM_zone_30N,
            WGS72_UTM_zone_31N, WGS72_UTM_zone_32N, WGS72_UTM_zone_33N,
            WGS72_UTM_zone_34N, WGS72_UTM_zone_35N, WGS72_UTM_zone_36N,
            WGS72_UTM_zone_37N, WGS72_UTM_zone_38N, WGS72_UTM_zone_39N,
            WGS72_UTM_zone_40N, WGS72_UTM_zone_41N, WGS72_UTM_zone_42N,
            WGS72_UTM_zone_43N, WGS72_UTM_zone_44N, WGS72_UTM_zone_45N,
            WGS72_UTM_zone_46N, WGS72_UTM_zone_47N, WGS72_UTM_zone_48N,
            WGS72_UTM_zone_49N, WGS72_UTM_zone_50N, WGS72_UTM_zone_51N,
            WGS72_UTM_zone_52N, WGS72_UTM_zone_53N, WGS72_UTM_zone_54N,
            WGS72_UTM_zone_55N, WGS72_UTM_zone_56N, WGS72_UTM_zone_57N,
            WGS72_UTM_zone_58N, WGS72_UTM_zone_59N, WGS72_UTM_zone_60N,
            WGS72_UTM_zone_1S, WGS72_UTM_zone_2S, WGS72_UTM_zone_3S,
            WGS72_UTM_zone_4S, WGS72_UTM_zone_5S, WGS72_UTM_zone_6S,
            WGS72_UTM_zone_7S, WGS72_UTM_zone_8S, WGS72_UTM_zone_9S,
            WGS72_UTM_zone_10S, WGS72_UTM_zone_11S, WGS72_UTM_zone_12S,
            WGS72_UTM_zone_13S, WGS72_UTM_zone_14S, WGS72_UTM_zone_15S,
            WGS72_UTM_zone_16S, WGS72_UTM_zone_17S, WGS72_UTM_zone_18S,
            WGS72_UTM_zone_19S, WGS72_UTM_zone_20S, WGS72_UTM_zone_21S,
            WGS72_UTM_zone_22S, WGS72_UTM_zone_23S, WGS72_UTM_zone_24S,
            WGS72_UTM_zone_25S, WGS72_UTM_zone_26S, WGS72_UTM_zone_27S,
            WGS72_UTM_zone_28S, WGS72_UTM_zone_29S, WGS72_UTM_zone_30S,
            WGS72_UTM_zone_31S, WGS72_UTM_zone_32S, WGS72_UTM_zone_33S,
            WGS72_UTM_zone_34S, WGS72_UTM_zone_35S, WGS72_UTM_zone_36S,
            WGS72_UTM_zone_37S, WGS72_UTM_zone_38S, WGS72_UTM_zone_39S,
            WGS72_UTM_zone_40S, WGS72_UTM_zone_41S, WGS72_UTM_zone_42S,
            WGS72_UTM_zone_43S, WGS72_UTM_zone_44S, WGS72_UTM_zone_45S,
            WGS72_UTM_zone_46S, WGS72_UTM_zone_47S, WGS72_UTM_zone_48S,
            WGS72_UTM_zone_49S, WGS72_UTM_zone_50S, WGS72_UTM_zone_51S,
            WGS72_UTM_zone_52S, WGS72_UTM_zone_53S, WGS72_UTM_zone_54S,
            WGS72_UTM_zone_55S, WGS72_UTM_zone_56S, WGS72_UTM_zone_57S,
            WGS72_UTM_zone_58S, WGS72_UTM_zone_59S, WGS72_UTM_zone_60S,
            WGS72BE_UTM_zone_1N, WGS72BE_UTM_zone_2N, WGS72BE_UTM_zone_3N,
            WGS72BE_UTM_zone_4N, WGS72BE_UTM_zone_5N, WGS72BE_UTM_zone_6N,
            WGS72BE_UTM_zone_7N, WGS72BE_UTM_zone_8N, WGS72BE_UTM_zone_9N,
            WGS72BE_UTM_zone_10N, WGS72BE_UTM_zone_11N, WGS72BE_UTM_zone_12N,
            WGS72BE_UTM_zone_13N, WGS72BE_UTM_zone_14N, WGS72BE_UTM_zone_15N,
            WGS72BE_UTM_zone_16N, WGS72BE_UTM_zone_17N, WGS72BE_UTM_zone_18N,
            WGS72BE_UTM_zone_19N, WGS72BE_UTM_zone_20N, WGS72BE_UTM_zone_21N,
            WGS72BE_UTM_zone_22N, WGS72BE_UTM_zone_23N, WGS72BE_UTM_zone_24N,
            WGS72BE_UTM_zone_25N, WGS72BE_UTM_zone_26N, WGS72BE_UTM_zone_27N,
            WGS72BE_UTM_zone_28N, WGS72BE_UTM_zone_29N, WGS72BE_UTM_zone_30N,
            WGS72BE_UTM_zone_31N, WGS72BE_UTM_zone_32N, WGS72BE_UTM_zone_33N,
            WGS72BE_UTM_zone_34N, WGS72BE_UTM_zone_35N, WGS72BE_UTM_zone_36N,
            WGS72BE_UTM_zone_37N, WGS72BE_UTM_zone_38N, WGS72BE_UTM_zone_39N,
            WGS72BE_UTM_zone_40N, WGS72BE_UTM_zone_41N, WGS72BE_UTM_zone_42N,
            WGS72BE_UTM_zone_43N, WGS72BE_UTM_zone_44N, WGS72BE_UTM_zone_45N,
            WGS72BE_UTM_zone_46N, WGS72BE_UTM_zone_47N, WGS72BE_UTM_zone_48N,
            WGS72BE_UTM_zone_49N, WGS72BE_UTM_zone_50N, WGS72BE_UTM_zone_51N,
            WGS72BE_UTM_zone_52N, WGS72BE_UTM_zone_53N, WGS72BE_UTM_zone_54N,
            WGS72BE_UTM_zone_55N, WGS72BE_UTM_zone_56N, WGS72BE_UTM_zone_57N,
            WGS72BE_UTM_zone_58N, WGS72BE_UTM_zone_59N, WGS72BE_UTM_zone_60N,
            WGS72BE_UTM_zone_1S, WGS72BE_UTM_zone_2S, WGS72BE_UTM_zone_3S,
            WGS72BE_UTM_zone_4S, WGS72BE_UTM_zone_5S, WGS72BE_UTM_zone_6S,
            WGS72BE_UTM_zone_7S, WGS72BE_UTM_zone_8S, WGS72BE_UTM_zone_9S,
            WGS72BE_UTM_zone_10S, WGS72BE_UTM_zone_11S, WGS72BE_UTM_zone_12S,
            WGS72BE_UTM_zone_13S, WGS72BE_UTM_zone_14S, WGS72BE_UTM_zone_15S,
            WGS72BE_UTM_zone_16S, WGS72BE_UTM_zone_17S, WGS72BE_UTM_zone_18S,
            WGS72BE_UTM_zone_19S, WGS72BE_UTM_zone_20S, WGS72BE_UTM_zone_21S,
            WGS72BE_UTM_zone_22S, WGS72BE_UTM_zone_23S, WGS72BE_UTM_zone_24S,
            WGS72BE_UTM_zone_25S, WGS72BE_UTM_zone_26S, WGS72BE_UTM_zone_27S,
            WGS72BE_UTM_zone_28S, WGS72BE_UTM_zone_29S, WGS72BE_UTM_zone_30S,
            WGS72BE_UTM_zone_31S, WGS72BE_UTM_zone_32S, WGS72BE_UTM_zone_33S,
            WGS72BE_UTM_zone_34S, WGS72BE_UTM_zone_35S, WGS72BE_UTM_zone_36S,
            WGS72BE_UTM_zone_37S, WGS72BE_UTM_zone_38S, WGS72BE_UTM_zone_39S,
            WGS72BE_UTM_zone_40S, WGS72BE_UTM_zone_41S, WGS72BE_UTM_zone_42S,
            WGS72BE_UTM_zone_43S, WGS72BE_UTM_zone_44S, WGS72BE_UTM_zone_45S,
            WGS72BE_UTM_zone_46S, WGS72BE_UTM_zone_47S, WGS72BE_UTM_zone_48S,
            WGS72BE_UTM_zone_49S, WGS72BE_UTM_zone_50S, WGS72BE_UTM_zone_51S,
            WGS72BE_UTM_zone_52S, WGS72BE_UTM_zone_53S, WGS72BE_UTM_zone_54S,
            WGS72BE_UTM_zone_55S, WGS72BE_UTM_zone_56S, WGS72BE_UTM_zone_57S,
            WGS72BE_UTM_zone_58S, WGS72BE_UTM_zone_59S, WGS72BE_UTM_zone_60S,
            WGS84_UTM_zone_1N, WGS84_UTM_zone_2N, WGS84_UTM_zone_3N,
            WGS84_UTM_zone_4N, WGS84_UTM_zone_5N, WGS84_UTM_zone_6N,
            WGS84_UTM_zone_7N, WGS84_UTM_zone_8N, WGS84_UTM_zone_9N,
            WGS84_UTM_zone_10N, WGS84_UTM_zone_11N, WGS84_UTM_zone_12N,
            WGS84_UTM_zone_13N, WGS84_UTM_zone_14N, WGS84_UTM_zone_15N,
            WGS84_UTM_zone_16N, WGS84_UTM_zone_17N, WGS84_UTM_zone_18N,
            WGS84_UTM_zone_19N, WGS84_UTM_zone_20N, WGS84_UTM_zone_21N,
            WGS84_UTM_zone_22N, WGS84_UTM_zone_23N, WGS84_UTM_zone_24N,
            WGS84_UTM_zone_25N, WGS84_UTM_zone_26N, WGS84_UTM_zone_27N,
            WGS84_UTM_zone_28N, WGS84_UTM_zone_29N, WGS84_UTM_zone_30N,
            WGS84_UTM_zone_31N, WGS84_UTM_zone_32N, WGS84_UTM_zone_33N,
            WGS84_UTM_zone_34N, WGS84_UTM_zone_35N, WGS84_UTM_zone_36N,
            WGS84_UTM_zone_37N, WGS84_UTM_zone_38N, WGS84_UTM_zone_39N,
            WGS84_UTM_zone_40N, WGS84_UTM_zone_41N, WGS84_UTM_zone_42N,
            WGS84_UTM_zone_43N, WGS84_UTM_zone_44N, WGS84_UTM_zone_45N,
            WGS84_UTM_zone_46N, WGS84_UTM_zone_47N, WGS84_UTM_zone_48N,
            WGS84_UTM_zone_49N, WGS84_UTM_zone_50N, WGS84_UTM_zone_51N,
            WGS84_UTM_zone_52N, WGS84_UTM_zone_53N, WGS84_UTM_zone_54N,
            WGS84_UTM_zone_55N, WGS84_UTM_zone_56N, WGS84_UTM_zone_57N,
            WGS84_UTM_zone_58N, WGS84_UTM_zone_59N, WGS84_UTM_zone_60N,
            WGS84_UTM_zone_1S, WGS84_UTM_zone_2S, WGS84_UTM_zone_3S,
            WGS84_UTM_zone_4S, WGS84_UTM_zone_5S, WGS84_UTM_zone_6S,
            WGS84_UTM_zone_7S, WGS84_UTM_zone_8S, WGS84_UTM_zone_9S,
            WGS84_UTM_zone_10S, WGS84_UTM_zone_11S, WGS84_UTM_zone_12S,
            WGS84_UTM_zone_13S, WGS84_UTM_zone_14S, WGS84_UTM_zone_15S,
            WGS84_UTM_zone_16S, WGS84_UTM_zone_17S, WGS84_UTM_zone_18S,
            WGS84_UTM_zone_19S, WGS84_UTM_zone_20S, WGS84_UTM_zone_21S,
            WGS84_UTM_zone_22S, WGS84_UTM_zone_23S, WGS84_UTM_zone_24S,
            WGS84_UTM_zone_25S, WGS84_UTM_zone_26S, WGS84_UTM_zone_27S,
            WGS84_UTM_zone_28S, WGS84_UTM_zone_29S, WGS84_UTM_zone_30S,
            WGS84_UTM_zone_31S, WGS84_UTM_zone_32S, WGS84_UTM_zone_33S,
            WGS84_UTM_zone_34S, WGS84_UTM_zone_35S, WGS84_UTM_zone_36S,
            WGS84_UTM_zone_37S, WGS84_UTM_zone_38S, WGS84_UTM_zone_39S,
            WGS84_UTM_zone_40S, WGS84_UTM_zone_41S, WGS84_UTM_zone_42S,
            WGS84_UTM_zone_43S, WGS84_UTM_zone_44S, WGS84_UTM_zone_45S,
            WGS84_UTM_zone_46S, WGS84_UTM_zone_47S, WGS84_UTM_zone_48S,
            WGS84_UTM_zone_49S, WGS84_UTM_zone_50S, WGS84_UTM_zone_51S,
            WGS84_UTM_zone_52S, WGS84_UTM_zone_53S, WGS84_UTM_zone_54S,
            WGS84_UTM_zone_55S, WGS84_UTM_zone_56S, WGS84_UTM_zone_57S,
            WGS84_UTM_zone_58S, WGS84_UTM_zone_59S, WGS84_UTM_zone_60S
        };

        /** _more_          */
        public static final String names[] = {
            "PCS_Adindan_UTM_zone_37N", "PCS_Adindan_UTM_zone_38N",
            "PCS_AGD66_AMG_zone_48", "PCS_AGD66_AMG_zone_49",
            "PCS_AGD66_AMG_zone_50", "PCS_AGD66_AMG_zone_51",
            "PCS_AGD66_AMG_zone_52", "PCS_AGD66_AMG_zone_53",
            "PCS_AGD66_AMG_zone_54", "PCS_AGD66_AMG_zone_55",
            "PCS_AGD66_AMG_zone_56", "PCS_AGD66_AMG_zone_57",
            "PCS_AGD66_AMG_zone_58", "PCS_AGD84_AMG_zone_48",
            "PCS_AGD84_AMG_zone_49", "PCS_AGD84_AMG_zone_50",
            "PCS_AGD84_AMG_zone_51", "PCS_AGD84_AMG_zone_52",
            "PCS_AGD84_AMG_zone_53", "PCS_AGD84_AMG_zone_54",
            "PCS_AGD84_AMG_zone_55", "PCS_AGD84_AMG_zone_56",
            "PCS_AGD84_AMG_zone_57", "PCS_AGD84_AMG_zone_58",
            "PCS_Ain_el_Abd_UTM_zone_37N", "PCS_Ain_el_Abd_UTM_zone_38N",
            "PCS_Ain_el_Abd_UTM_zone_39N", "PCS_Ain_el_Abd_Bahrain_Grid",
            "PCS_Afgooye_UTM_zone_38N", "PCS_Afgooye_UTM_zone_39N",
            "PCS_Lisbon_Portugese_Grid", "PCS_Aratu_UTM_zone_22S",
            "PCS_Aratu_UTM_zone_23S", "PCS_Aratu_UTM_zone_24S",
            "PCS_Arc_1950_Lo13", "PCS_Arc_1950_Lo15", "PCS_Arc_1950_Lo17",
            "PCS_Arc_1950_Lo19", "PCS_Arc_1950_Lo21", "PCS_Arc_1950_Lo23",
            "PCS_Arc_1950_Lo25", "PCS_Arc_1950_Lo27", "PCS_Arc_1950_Lo29",
            "PCS_Arc_1950_Lo31", "PCS_Arc_1950_Lo33", "PCS_Arc_1950_Lo35",
            "PCS_Batavia_NEIEZ", "PCS_Batavia_UTM_zone_48S",
            "PCS_Batavia_UTM_zone_49S", "PCS_Batavia_UTM_zone_50S",
            "PCS_Beijing_Gauss_zone_13", "PCS_Beijing_Gauss_zone_14",
            "PCS_Beijing_Gauss_zone_15", "PCS_Beijing_Gauss_zone_16",
            "PCS_Beijing_Gauss_zone_17", "PCS_Beijing_Gauss_zone_18",
            "PCS_Beijing_Gauss_zone_19", "PCS_Beijing_Gauss_zone_20",
            "PCS_Beijing_Gauss_zone_21", "PCS_Beijing_Gauss_zone_22",
            "PCS_Beijing_Gauss_zone_23", "PCS_Beijing_Gauss_13N",
            "PCS_Beijing_Gauss_14N", "PCS_Beijing_Gauss_15N",
            "PCS_Beijing_Gauss_16N", "PCS_Beijing_Gauss_17N",
            "PCS_Beijing_Gauss_18N", "PCS_Beijing_Gauss_19N",
            "PCS_Beijing_Gauss_20N", "PCS_Beijing_Gauss_21N",
            "PCS_Beijing_Gauss_22N", "PCS_Beijing_Gauss_23N",
            "PCS_Belge_Lambert_50", "PCS_Bern_1898_Swiss_Old",
            "PCS_Bogota_UTM_zone_17N", "PCS_Bogota_UTM_zone_18N",
            "PCS_Bogota_Colombia_3W", "PCS_Bogota_Colombia_Bogota",
            "PCS_Bogota_Colombia_3E", "PCS_Bogota_Colombia_6E",
            "PCS_Camacupa_UTM_32S", "PCS_Camacupa_UTM_33S",
            "PCS_C_Inchauspe_Argentina_1", "PCS_C_Inchauspe_Argentina_2",
            "PCS_C_Inchauspe_Argentina_3", "PCS_C_Inchauspe_Argentina_4",
            "PCS_C_Inchauspe_Argentina_5", "PCS_C_Inchauspe_Argentina_6",
            "PCS_C_Inchauspe_Argentina_7", "PCS_Carthage_UTM_zone_32N",
            "PCS_Carthage_Nord_Tunisie", "PCS_Carthage_Sud_Tunisie",
            "PCS_Corrego_Alegre_UTM_23S", "PCS_Corrego_Alegre_UTM_24S",
            "PCS_Douala_UTM_zone_32N", "PCS_Egypt_1907_Red_Belt",
            "PCS_Egypt_1907_Purple_Belt", "PCS_Egypt_1907_Ext_Purple",
            "PCS_ED50_UTM_zone_28N", "PCS_ED50_UTM_zone_29N",
            "PCS_ED50_UTM_zone_30N", "PCS_ED50_UTM_zone_31N",
            "PCS_ED50_UTM_zone_32N", "PCS_ED50_UTM_zone_33N",
            "PCS_ED50_UTM_zone_34N", "PCS_ED50_UTM_zone_35N",
            "PCS_ED50_UTM_zone_36N", "PCS_ED50_UTM_zone_37N",
            "PCS_ED50_UTM_zone_38N", "PCS_Fahud_UTM_zone_39N",
            "PCS_Fahud_UTM_zone_40N", "PCS_Garoua_UTM_zone_33N",
            "PCS_ID74_UTM_zone_46N", "PCS_ID74_UTM_zone_47N",
            "PCS_ID74_UTM_zone_48N", "PCS_ID74_UTM_zone_49N",
            "PCS_ID74_UTM_zone_50N", "PCS_ID74_UTM_zone_51N",
            "PCS_ID74_UTM_zone_52N", "PCS_ID74_UTM_zone_53N",
            "PCS_ID74_UTM_zone_46S", "PCS_ID74_UTM_zone_47S",
            "PCS_ID74_UTM_zone_48S", "PCS_ID74_UTM_zone_49S",
            "PCS_ID74_UTM_zone_50S", "PCS_ID74_UTM_zone_51S",
            "PCS_ID74_UTM_zone_52S", "PCS_ID74_UTM_zone_53S",
            "PCS_ID74_UTM_zone_54S", "PCS_Indian_1954_UTM_47N",
            "PCS_Indian_1954_UTM_48N", "PCS_Indian_1975_UTM_47N",
            "PCS_Indian_1975_UTM_48N", "PCS_Jamaica_1875_Old_Grid",
            "PCS_JAD69_Jamaica_Grid", "PCS_Kalianpur_India_0",
            "PCS_Kalianpur_India_I", "PCS_Kalianpur_India_IIa",
            "PCS_Kalianpur_India_IIIa", "PCS_Kalianpur_India_IVa",
            "PCS_Kalianpur_India_IIb", "PCS_Kalianpur_India_IIIb",
            "PCS_Kalianpur_India_IVb", "PCS_Kertau_Singapore_Grid",
            "PCS_Kertau_UTM_zone_47N", "PCS_Kertau_UTM_zone_48N",
            "PCS_La_Canoa_UTM_zone_20N", "PCS_La_Canoa_UTM_zone_21N",
            "PCS_PSAD56_UTM_zone_18N", "PCS_PSAD56_UTM_zone_19N",
            "PCS_PSAD56_UTM_zone_20N", "PCS_PSAD56_UTM_zone_21N",
            "PCS_PSAD56_UTM_zone_17S", "PCS_PSAD56_UTM_zone_18S",
            "PCS_PSAD56_UTM_zone_19S", "PCS_PSAD56_UTM_zone_20S",
            "PCS_PSAD56_Peru_west_zone", "PCS_PSAD56_Peru_central",
            "PCS_PSAD56_Peru_east_zone", "PCS_Leigon_Ghana_Grid",
            "PCS_Lome_UTM_zone_31N", "PCS_Luzon_Philippines_I",
            "PCS_Luzon_Philippines_II", "PCS_Luzon_Philippines_III",
            "PCS_Luzon_Philippines_IV", "PCS_Luzon_Philippines_V",
            "PCS_Makassar_NEIEZ", "PCS_Malongo_1987_UTM_32S",
            "PCS_Merchich_Nord_Maroc", "PCS_Merchich_Sud_Maroc",
            "PCS_Merchich_Sahara", "PCS_Massawa_UTM_zone_37N",
            "PCS_Minna_UTM_zone_31N", "PCS_Minna_UTM_zone_32N",
            "PCS_Minna_Nigeria_West", "PCS_Minna_Nigeria_Mid_Belt",
            "PCS_Minna_Nigeria_East", "PCS_Mhast_UTM_zone_32S",
            "PCS_Monte_Mario_Italy_1", "PCS_Monte_Mario_Italy_2",
            "PCS_M_poraloko_UTM_32N", "PCS_M_poraloko_UTM_32S",
            "PCS_NAD27_UTM_zone_3N", "PCS_NAD27_UTM_zone_4N",
            "PCS_NAD27_UTM_zone_5N", "PCS_NAD27_UTM_zone_6N",
            "PCS_NAD27_UTM_zone_7N", "PCS_NAD27_UTM_zone_8N",
            "PCS_NAD27_UTM_zone_9N", "PCS_NAD27_UTM_zone_10N",
            "PCS_NAD27_UTM_zone_11N", "PCS_NAD27_UTM_zone_12N",
            "PCS_NAD27_UTM_zone_13N", "PCS_NAD27_UTM_zone_14N",
            "PCS_NAD27_UTM_zone_15N", "PCS_NAD27_UTM_zone_16N",
            "PCS_NAD27_UTM_zone_17N", "PCS_NAD27_UTM_zone_18N",
            "PCS_NAD27_UTM_zone_19N", "PCS_NAD27_UTM_zone_20N",
            "PCS_NAD27_UTM_zone_21N", "PCS_NAD27_UTM_zone_22N",
            "PCS_NAD27_Alabama_East", "PCS_NAD27_Alabama_West",
            "PCS_NAD27_Alaska_zone_1", "PCS_NAD27_Alaska_zone_2",
            "PCS_NAD27_Alaska_zone_3", "PCS_NAD27_Alaska_zone_4",
            "PCS_NAD27_Alaska_zone_5", "PCS_NAD27_Alaska_zone_6",
            "PCS_NAD27_Alaska_zone_7", "PCS_NAD27_Alaska_zone_8",
            "PCS_NAD27_Alaska_zone_9", "PCS_NAD27_Alaska_zone_10",
            "PCS_NAD27_California_I", "PCS_NAD27_California_II",
            "PCS_NAD27_California_III", "PCS_NAD27_California_IV",
            "PCS_NAD27_California_V", "PCS_NAD27_California_VI",
            "PCS_NAD27_California_VII", "PCS_NAD27_Arizona_East",
            "PCS_NAD27_Arizona_Central", "PCS_NAD27_Arizona_West",
            "PCS_NAD27_Arkansas_North", "PCS_NAD27_Arkansas_South",
            "PCS_NAD27_Colorado_North", "PCS_NAD27_Colorado_Central",
            "PCS_NAD27_Colorado_South", "PCS_NAD27_Connecticut",
            "PCS_NAD27_Delaware", "PCS_NAD27_Florida_East",
            "PCS_NAD27_Florida_West", "PCS_NAD27_Florida_North",
            "PCS_NAD27_Hawaii_zone_1", "PCS_NAD27_Hawaii_zone_2",
            "PCS_NAD27_Hawaii_zone_3", "PCS_NAD27_Hawaii_zone_4",
            "PCS_NAD27_Hawaii_zone_5", "PCS_NAD27_Georgia_East",
            "PCS_NAD27_Georgia_West", "PCS_NAD27_Idaho_East",
            "PCS_NAD27_Idaho_Central", "PCS_NAD27_Idaho_West",
            "PCS_NAD27_Illinois_East", "PCS_NAD27_Illinois_West",
            "PCS_NAD27_Indiana_East", "PCS_NAD27_BLM_14N_feet",
            "PCS_NAD27_Indiana_West", "PCS_NAD27_BLM_15N_feet",
            "PCS_NAD27_Iowa_North", "PCS_NAD27_BLM_16N_feet",
            "PCS_NAD27_Iowa_South", "PCS_NAD27_BLM_17N_feet",
            "PCS_NAD27_Kansas_North", "PCS_NAD27_Kansas_South",
            "PCS_NAD27_Kentucky_North", "PCS_NAD27_Kentucky_South",
            "PCS_NAD27_Louisiana_North", "PCS_NAD27_Louisiana_South",
            "PCS_NAD27_Maine_East", "PCS_NAD27_Maine_West",
            "PCS_NAD27_Maryland", "PCS_NAD27_Massachusetts",
            "PCS_NAD27_Massachusetts_Is", "PCS_NAD27_Michigan_North",
            "PCS_NAD27_Michigan_Central", "PCS_NAD27_Michigan_South",
            "PCS_NAD27_Minnesota_North", "PCS_NAD27_Minnesota_Cent",
            "PCS_NAD27_Minnesota_South", "PCS_NAD27_Mississippi_East",
            "PCS_NAD27_Mississippi_West", "PCS_NAD27_Missouri_East",
            "PCS_NAD27_Missouri_Central", "PCS_NAD27_Missouri_West",
            "PCS_NAD_Michigan_Michigan_East",
            "PCS_NAD_Michigan_Michigan_Old_Central",
            "PCS_NAD_Michigan_Michigan_West", "PCS_NAD83_UTM_zone_3N",
            "PCS_NAD83_UTM_zone_4N", "PCS_NAD83_UTM_zone_5N",
            "PCS_NAD83_UTM_zone_6N", "PCS_NAD83_UTM_zone_7N",
            "PCS_NAD83_UTM_zone_8N", "PCS_NAD83_UTM_zone_9N",
            "PCS_NAD83_UTM_zone_10N", "PCS_NAD83_UTM_zone_11N",
            "PCS_NAD83_UTM_zone_12N", "PCS_NAD83_UTM_zone_13N",
            "PCS_NAD83_UTM_zone_14N", "PCS_NAD83_UTM_zone_15N",
            "PCS_NAD83_UTM_zone_16N", "PCS_NAD83_UTM_zone_17N",
            "PCS_NAD83_UTM_zone_18N", "PCS_NAD83_UTM_zone_19N",
            "PCS_NAD83_UTM_zone_20N", "PCS_NAD83_UTM_zone_21N",
            "PCS_NAD83_UTM_zone_22N", "PCS_NAD83_UTM_zone_23N",
            "PCS_NAD83_Alabama_East", "PCS_NAD83_Alabama_West",
            "PCS_NAD83_Alaska_zone_1", "PCS_NAD83_Alaska_zone_2",
            "PCS_NAD83_Alaska_zone_3", "PCS_NAD83_Alaska_zone_4",
            "PCS_NAD83_Alaska_zone_5", "PCS_NAD83_Alaska_zone_6",
            "PCS_NAD83_Alaska_zone_7", "PCS_NAD83_Alaska_zone_8",
            "PCS_NAD83_Alaska_zone_9", "PCS_NAD83_Alaska_zone_10",
            "PCS_NAD83_California_1", "PCS_NAD83_California_2",
            "PCS_NAD83_California_3", "PCS_NAD83_California_4",
            "PCS_NAD83_California_5", "PCS_NAD83_California_6",
            "PCS_NAD83_Arizona_East", "PCS_NAD83_Arizona_Central",
            "PCS_NAD83_Arizona_West", "PCS_NAD83_Arkansas_North",
            "PCS_NAD83_Arkansas_South", "PCS_NAD83_Colorado_North",
            "PCS_NAD83_Colorado_Central", "PCS_NAD83_Colorado_South",
            "PCS_NAD83_Connecticut", "PCS_NAD83_Delaware",
            "PCS_NAD83_Florida_East", "PCS_NAD83_Florida_West",
            "PCS_NAD83_Florida_North", "PCS_NAD83_Hawaii_zone_1",
            "PCS_NAD83_Hawaii_zone_2", "PCS_NAD83_Hawaii_zone_3",
            "PCS_NAD83_Hawaii_zone_4", "PCS_NAD83_Hawaii_zone_5",
            "PCS_NAD83_Georgia_East", "PCS_NAD83_Georgia_West",
            "PCS_NAD83_Idaho_East", "PCS_NAD83_Idaho_Central",
            "PCS_NAD83_Idaho_West", "PCS_NAD83_Illinois_East",
            "PCS_NAD83_Illinois_West", "PCS_NAD83_Indiana_East",
            "PCS_NAD83_Indiana_West", "PCS_NAD83_Iowa_North",
            "PCS_NAD83_Iowa_South", "PCS_NAD83_Kansas_North",
            "PCS_NAD83_Kansas_South", "PCS_NAD83_Kentucky_North",
            "PCS_NAD83_Kentucky_South", "PCS_NAD83_Louisiana_North",
            "PCS_NAD83_Louisiana_South", "PCS_NAD83_Maine_East",
            "PCS_NAD83_Maine_West", "PCS_NAD83_Maryland",
            "PCS_NAD83_Massachusetts", "PCS_NAD83_Massachusetts_Is",
            "PCS_NAD83_Michigan_North", "PCS_NAD83_Michigan_Central",
            "PCS_NAD83_Michigan_South", "PCS_NAD83_Minnesota_North",
            "PCS_NAD83_Minnesota_Cent", "PCS_NAD83_Minnesota_South",
            "PCS_NAD83_Mississippi_East", "PCS_NAD83_Mississippi_West",
            "PCS_NAD83_Missouri_East", "PCS_NAD83_Missouri_Central",
            "PCS_NAD83_Missouri_West", "PCS_Nahrwan_1967_UTM_38N",
            "PCS_Nahrwan_1967_UTM_39N", "PCS_Nahrwan_1967_UTM_40N",
            "PCS_Naparima_UTM_20N", "PCS_GD49_NZ_Map_Grid",
            "PCS_GD49_North_Island_Grid", "PCS_GD49_South_Island_Grid",
            "PCS_Datum_73_UTM_zone_29N", "PCS_ATF_Nord_de_Guerre",
            "PCS_NTF_France_I", "PCS_NTF_France_II", "PCS_NTF_France_III",
            "PCS_NTF_Nord_France", "PCS_NTF_Centre_France",
            "PCS_NTF_Sud_France", "PCS_British_National_Grid",
            "PCS_Point_Noire_UTM_32S", "PCS_GDA94_MGA_zone_48",
            "PCS_GDA94_MGA_zone_49", "PCS_GDA94_MGA_zone_50",
            "PCS_GDA94_MGA_zone_51", "PCS_GDA94_MGA_zone_52",
            "PCS_GDA94_MGA_zone_53", "PCS_GDA94_MGA_zone_54",
            "PCS_GDA94_MGA_zone_55", "PCS_GDA94_MGA_zone_56",
            "PCS_GDA94_MGA_zone_57", "PCS_GDA94_MGA_zone_58",
            "PCS_Pulkovo_Gauss_zone_4", "PCS_Pulkovo_Gauss_zone_5",
            "PCS_Pulkovo_Gauss_zone_6", "PCS_Pulkovo_Gauss_zone_7",
            "PCS_Pulkovo_Gauss_zone_8", "PCS_Pulkovo_Gauss_zone_9",
            "PCS_Pulkovo_Gauss_zone_10", "PCS_Pulkovo_Gauss_zone_11",
            "PCS_Pulkovo_Gauss_zone_12", "PCS_Pulkovo_Gauss_zone_13",
            "PCS_Pulkovo_Gauss_zone_14", "PCS_Pulkovo_Gauss_zone_15",
            "PCS_Pulkovo_Gauss_zone_16", "PCS_Pulkovo_Gauss_zone_17",
            "PCS_Pulkovo_Gauss_zone_18", "PCS_Pulkovo_Gauss_zone_19",
            "PCS_Pulkovo_Gauss_zone_20", "PCS_Pulkovo_Gauss_zone_21",
            "PCS_Pulkovo_Gauss_zone_22", "PCS_Pulkovo_Gauss_zone_23",
            "PCS_Pulkovo_Gauss_zone_24", "PCS_Pulkovo_Gauss_zone_25",
            "PCS_Pulkovo_Gauss_zone_26", "PCS_Pulkovo_Gauss_zone_27",
            "PCS_Pulkovo_Gauss_zone_28", "PCS_Pulkovo_Gauss_zone_29",
            "PCS_Pulkovo_Gauss_zone_30", "PCS_Pulkovo_Gauss_zone_31",
            "PCS_Pulkovo_Gauss_zone_32", "PCS_Pulkovo_Gauss_4N",
            "PCS_Pulkovo_Gauss_5N", "PCS_Pulkovo_Gauss_6N",
            "PCS_Pulkovo_Gauss_7N", "PCS_Pulkovo_Gauss_8N",
            "PCS_Pulkovo_Gauss_9N", "PCS_Pulkovo_Gauss_10N",
            "PCS_Pulkovo_Gauss_11N", "PCS_Pulkovo_Gauss_12N",
            "PCS_Pulkovo_Gauss_13N", "PCS_Pulkovo_Gauss_14N",
            "PCS_Pulkovo_Gauss_15N", "PCS_Pulkovo_Gauss_16N",
            "PCS_Pulkovo_Gauss_17N", "PCS_Pulkovo_Gauss_18N",
            "PCS_Pulkovo_Gauss_19N", "PCS_Pulkovo_Gauss_20N",
            "PCS_Pulkovo_Gauss_21N", "PCS_Pulkovo_Gauss_22N",
            "PCS_Pulkovo_Gauss_23N", "PCS_Pulkovo_Gauss_24N",
            "PCS_Pulkovo_Gauss_25N", "PCS_Pulkovo_Gauss_26N",
            "PCS_Pulkovo_Gauss_27N", "PCS_Pulkovo_Gauss_28N",
            "PCS_Pulkovo_Gauss_29N", "PCS_Pulkovo_Gauss_30N",
            "PCS_Pulkovo_Gauss_31N", "PCS_Pulkovo_Gauss_32N",
            "PCS_Qatar_National_Grid", "PCS_RD_Netherlands_Old",
            "PCS_RD_Netherlands_New", "PCS_SAD69_UTM_zone_18N",
            "PCS_SAD69_UTM_zone_19N", "PCS_SAD69_UTM_zone_20N",
            "PCS_SAD69_UTM_zone_21N", "PCS_SAD69_UTM_zone_22N",
            "PCS_SAD69_UTM_zone_17S", "PCS_SAD69_UTM_zone_18S",
            "PCS_SAD69_UTM_zone_19S", "PCS_SAD69_UTM_zone_20S",
            "PCS_SAD69_UTM_zone_21S", "PCS_SAD69_UTM_zone_22S",
            "PCS_SAD69_UTM_zone_23S", "PCS_SAD69_UTM_zone_24S",
            "PCS_SAD69_UTM_zone_25S", "PCS_Sapper_Hill_UTM_20S",
            "PCS_Sapper_Hill_UTM_21S", "PCS_Schwarzeck_UTM_33S",
            "PCS_Sudan_UTM_zone_35N", "PCS_Sudan_UTM_zone_36N",
            "PCS_Tananarive_Laborde", "PCS_Tananarive_UTM_38S",
            "PCS_Tananarive_UTM_39S", "PCS_Timbalai_1948_Borneo",
            "PCS_Timbalai_1948_UTM_49N", "PCS_Timbalai_1948_UTM_50N",
            "PCS_TM65_Irish_Nat_Grid", "PCS_Trinidad_1903_Trinidad",
            "PCS_TC_1948_UTM_zone_39N", "PCS_TC_1948_UTM_zone_40N",
            "PCS_Voirol_N_Algerie_ancien", "PCS_Voirol_S_Algerie_ancien",
            "PCS_Voirol_Unifie_N_Algerie", "PCS_Voirol_Unifie_S_Algerie",
            "PCS_Bern_1938_Swiss_New", "PCS_Nord_Sahara_UTM_29N",
            "PCS_Nord_Sahara_UTM_30N", "PCS_Nord_Sahara_UTM_31N",
            "PCS_Nord_Sahara_UTM_32N", "PCS_Yoff_UTM_zone_28N",
            "PCS_Zanderij_UTM_zone_21N", "PCS_MGI_Austria_West",
            "PCS_MGI_Austria_Central", "PCS_MGI_Austria_East",
            "PCS_Belge_Lambert_72", "PCS_DHDN_Germany_zone_1",
            "PCS_DHDN_Germany_zone_2", "PCS_DHDN_Germany_zone_3",
            "PCS_DHDN_Germany_zone_4", "PCS_DHDN_Germany_zone_5",
            "PCS_NAD27_Montana_North", "PCS_NAD27_Montana_Central",
            "PCS_NAD27_Montana_South", "PCS_NAD27_Nebraska_North",
            "PCS_NAD27_Nebraska_South", "PCS_NAD27_Nevada_East",
            "PCS_NAD27_Nevada_Central", "PCS_NAD27_Nevada_West",
            "PCS_NAD27_New_Hampshire", "PCS_NAD27_New_Jersey",
            "PCS_NAD27_New_Mexico_East", "PCS_NAD27_New_Mexico_Cent",
            "PCS_NAD27_New_Mexico_West", "PCS_NAD27_New_York_East",
            "PCS_NAD27_New_York_Central", "PCS_NAD27_New_York_West",
            "PCS_NAD27_New_York_Long_Is", "PCS_NAD27_North_Carolina",
            "PCS_NAD27_North_Dakota_N", "PCS_NAD27_North_Dakota_S",
            "PCS_NAD27_Ohio_North", "PCS_NAD27_Ohio_South",
            "PCS_NAD27_Oklahoma_North", "PCS_NAD27_Oklahoma_South",
            "PCS_NAD27_Oregon_North", "PCS_NAD27_Oregon_South",
            "PCS_NAD27_Pennsylvania_N", "PCS_NAD27_Pennsylvania_S",
            "PCS_NAD27_Rhode_Island", "PCS_NAD27_South_Carolina_N",
            "PCS_NAD27_South_Carolina_S", "PCS_NAD27_South_Dakota_N",
            "PCS_NAD27_South_Dakota_S", "PCS_NAD27_Tennessee",
            "PCS_NAD27_Texas_North", "PCS_NAD27_Texas_North_Cen",
            "PCS_NAD27_Texas_Central", "PCS_NAD27_Texas_South_Cen",
            "PCS_NAD27_Texas_South", "PCS_NAD27_Utah_North",
            "PCS_NAD27_Utah_Central", "PCS_NAD27_Utah_South",
            "PCS_NAD27_Vermont", "PCS_NAD27_Virginia_North",
            "PCS_NAD27_Virginia_South", "PCS_NAD27_Washington_North",
            "PCS_NAD27_Washington_South", "PCS_NAD27_West_Virginia_N",
            "PCS_NAD27_West_Virginia_S", "PCS_NAD27_Wisconsin_North",
            "PCS_NAD27_Wisconsin_Cen", "PCS_NAD27_Wisconsin_South",
            "PCS_NAD27_Wyoming_East", "PCS_NAD27_Wyoming_E_Cen",
            "PCS_NAD27_Wyoming_W_Cen", "PCS_NAD27_Wyoming_West",
            "PCS_NAD27_Puerto_Rico", "PCS_NAD27_St_Croix",
            "PCS_NAD83_Montana", "PCS_NAD83_Nebraska",
            "PCS_NAD83_Nevada_East", "PCS_NAD83_Nevada_Central",
            "PCS_NAD83_Nevada_West", "PCS_NAD83_New_Hampshire",
            "PCS_NAD83_New_Jersey", "PCS_NAD83_New_Mexico_East",
            "PCS_NAD83_New_Mexico_Cent", "PCS_NAD83_New_Mexico_West",
            "PCS_NAD83_New_York_East", "PCS_NAD83_New_York_Central",
            "PCS_NAD83_New_York_West", "PCS_NAD83_New_York_Long_Is",
            "PCS_NAD83_North_Carolina", "PCS_NAD83_North_Dakota_N",
            "PCS_NAD83_North_Dakota_S", "PCS_NAD83_Ohio_North",
            "PCS_NAD83_Ohio_South", "PCS_NAD83_Oklahoma_North",
            "PCS_NAD83_Oklahoma_South", "PCS_NAD83_Oregon_North",
            "PCS_NAD83_Oregon_South", "PCS_NAD83_Pennsylvania_N",
            "PCS_NAD83_Pennsylvania_S", "PCS_NAD83_Rhode_Island",
            "PCS_NAD83_South_Carolina", "PCS_NAD83_South_Dakota_N",
            "PCS_NAD83_South_Dakota_S", "PCS_NAD83_Tennessee",
            "PCS_NAD83_Texas_North", "PCS_NAD83_Texas_North_Cen",
            "PCS_NAD83_Texas_Central", "PCS_NAD83_Texas_South_Cen",
            "PCS_NAD83_Texas_South", "PCS_NAD83_Utah_North",
            "PCS_NAD83_Utah_Central", "PCS_NAD83_Utah_South",
            "PCS_NAD83_Vermont", "PCS_NAD83_Virginia_North",
            "PCS_NAD83_Virginia_South", "PCS_NAD83_Washington_North",
            "PCS_NAD83_Washington_South", "PCS_NAD83_West_Virginia_N",
            "PCS_NAD83_West_Virginia_S", "PCS_NAD83_Wisconsin_North",
            "PCS_NAD83_Wisconsin_Cen", "PCS_NAD83_Wisconsin_South",
            "PCS_NAD83_Wyoming_East", "PCS_NAD83_Wyoming_E_Cen",
            "PCS_NAD83_Wyoming_W_Cen", "PCS_NAD83_Wyoming_West",
            "PCS_NAD83_Puerto_Rico_Virgin_Is", "PCS_WGS72_UTM_zone_1N",
            "PCS_WGS72_UTM_zone_2N", "PCS_WGS72_UTM_zone_3N",
            "PCS_WGS72_UTM_zone_4N", "PCS_WGS72_UTM_zone_5N",
            "PCS_WGS72_UTM_zone_6N", "PCS_WGS72_UTM_zone_7N",
            "PCS_WGS72_UTM_zone_8N", "PCS_WGS72_UTM_zone_9N",
            "PCS_WGS72_UTM_zone_10N", "PCS_WGS72_UTM_zone_11N",
            "PCS_WGS72_UTM_zone_12N", "PCS_WGS72_UTM_zone_13N",
            "PCS_WGS72_UTM_zone_14N", "PCS_WGS72_UTM_zone_15N",
            "PCS_WGS72_UTM_zone_16N", "PCS_WGS72_UTM_zone_17N",
            "PCS_WGS72_UTM_zone_18N", "PCS_WGS72_UTM_zone_19N",
            "PCS_WGS72_UTM_zone_20N", "PCS_WGS72_UTM_zone_21N",
            "PCS_WGS72_UTM_zone_22N", "PCS_WGS72_UTM_zone_23N",
            "PCS_WGS72_UTM_zone_24N", "PCS_WGS72_UTM_zone_25N",
            "PCS_WGS72_UTM_zone_26N", "PCS_WGS72_UTM_zone_27N",
            "PCS_WGS72_UTM_zone_28N", "PCS_WGS72_UTM_zone_29N",
            "PCS_WGS72_UTM_zone_30N", "PCS_WGS72_UTM_zone_31N",
            "PCS_WGS72_UTM_zone_32N", "PCS_WGS72_UTM_zone_33N",
            "PCS_WGS72_UTM_zone_34N", "PCS_WGS72_UTM_zone_35N",
            "PCS_WGS72_UTM_zone_36N", "PCS_WGS72_UTM_zone_37N",
            "PCS_WGS72_UTM_zone_38N", "PCS_WGS72_UTM_zone_39N",
            "PCS_WGS72_UTM_zone_40N", "PCS_WGS72_UTM_zone_41N",
            "PCS_WGS72_UTM_zone_42N", "PCS_WGS72_UTM_zone_43N",
            "PCS_WGS72_UTM_zone_44N", "PCS_WGS72_UTM_zone_45N",
            "PCS_WGS72_UTM_zone_46N", "PCS_WGS72_UTM_zone_47N",
            "PCS_WGS72_UTM_zone_48N", "PCS_WGS72_UTM_zone_49N",
            "PCS_WGS72_UTM_zone_50N", "PCS_WGS72_UTM_zone_51N",
            "PCS_WGS72_UTM_zone_52N", "PCS_WGS72_UTM_zone_53N",
            "PCS_WGS72_UTM_zone_54N", "PCS_WGS72_UTM_zone_55N",
            "PCS_WGS72_UTM_zone_56N", "PCS_WGS72_UTM_zone_57N",
            "PCS_WGS72_UTM_zone_58N", "PCS_WGS72_UTM_zone_59N",
            "PCS_WGS72_UTM_zone_60N", "PCS_WGS72_UTM_zone_1S",
            "PCS_WGS72_UTM_zone_2S", "PCS_WGS72_UTM_zone_3S",
            "PCS_WGS72_UTM_zone_4S", "PCS_WGS72_UTM_zone_5S",
            "PCS_WGS72_UTM_zone_6S", "PCS_WGS72_UTM_zone_7S",
            "PCS_WGS72_UTM_zone_8S", "PCS_WGS72_UTM_zone_9S",
            "PCS_WGS72_UTM_zone_10S", "PCS_WGS72_UTM_zone_11S",
            "PCS_WGS72_UTM_zone_12S", "PCS_WGS72_UTM_zone_13S",
            "PCS_WGS72_UTM_zone_14S", "PCS_WGS72_UTM_zone_15S",
            "PCS_WGS72_UTM_zone_16S", "PCS_WGS72_UTM_zone_17S",
            "PCS_WGS72_UTM_zone_18S", "PCS_WGS72_UTM_zone_19S",
            "PCS_WGS72_UTM_zone_20S", "PCS_WGS72_UTM_zone_21S",
            "PCS_WGS72_UTM_zone_22S", "PCS_WGS72_UTM_zone_23S",
            "PCS_WGS72_UTM_zone_24S", "PCS_WGS72_UTM_zone_25S",
            "PCS_WGS72_UTM_zone_26S", "PCS_WGS72_UTM_zone_27S",
            "PCS_WGS72_UTM_zone_28S", "PCS_WGS72_UTM_zone_29S",
            "PCS_WGS72_UTM_zone_30S", "PCS_WGS72_UTM_zone_31S",
            "PCS_WGS72_UTM_zone_32S", "PCS_WGS72_UTM_zone_33S",
            "PCS_WGS72_UTM_zone_34S", "PCS_WGS72_UTM_zone_35S",
            "PCS_WGS72_UTM_zone_36S", "PCS_WGS72_UTM_zone_37S",
            "PCS_WGS72_UTM_zone_38S", "PCS_WGS72_UTM_zone_39S",
            "PCS_WGS72_UTM_zone_40S", "PCS_WGS72_UTM_zone_41S",
            "PCS_WGS72_UTM_zone_42S", "PCS_WGS72_UTM_zone_43S",
            "PCS_WGS72_UTM_zone_44S", "PCS_WGS72_UTM_zone_45S",
            "PCS_WGS72_UTM_zone_46S", "PCS_WGS72_UTM_zone_47S",
            "PCS_WGS72_UTM_zone_48S", "PCS_WGS72_UTM_zone_49S",
            "PCS_WGS72_UTM_zone_50S", "PCS_WGS72_UTM_zone_51S",
            "PCS_WGS72_UTM_zone_52S", "PCS_WGS72_UTM_zone_53S",
            "PCS_WGS72_UTM_zone_54S", "PCS_WGS72_UTM_zone_55S",
            "PCS_WGS72_UTM_zone_56S", "PCS_WGS72_UTM_zone_57S",
            "PCS_WGS72_UTM_zone_58S", "PCS_WGS72_UTM_zone_59S",
            "PCS_WGS72_UTM_zone_60S", "PCS_WGS72BE_UTM_zone_1N",
            "PCS_WGS72BE_UTM_zone_2N", "PCS_WGS72BE_UTM_zone_3N",
            "PCS_WGS72BE_UTM_zone_4N", "PCS_WGS72BE_UTM_zone_5N",
            "PCS_WGS72BE_UTM_zone_6N", "PCS_WGS72BE_UTM_zone_7N",
            "PCS_WGS72BE_UTM_zone_8N", "PCS_WGS72BE_UTM_zone_9N",
            "PCS_WGS72BE_UTM_zone_10N", "PCS_WGS72BE_UTM_zone_11N",
            "PCS_WGS72BE_UTM_zone_12N", "PCS_WGS72BE_UTM_zone_13N",
            "PCS_WGS72BE_UTM_zone_14N", "PCS_WGS72BE_UTM_zone_15N",
            "PCS_WGS72BE_UTM_zone_16N", "PCS_WGS72BE_UTM_zone_17N",
            "PCS_WGS72BE_UTM_zone_18N", "PCS_WGS72BE_UTM_zone_19N",
            "PCS_WGS72BE_UTM_zone_20N", "PCS_WGS72BE_UTM_zone_21N",
            "PCS_WGS72BE_UTM_zone_22N", "PCS_WGS72BE_UTM_zone_23N",
            "PCS_WGS72BE_UTM_zone_24N", "PCS_WGS72BE_UTM_zone_25N",
            "PCS_WGS72BE_UTM_zone_26N", "PCS_WGS72BE_UTM_zone_27N",
            "PCS_WGS72BE_UTM_zone_28N", "PCS_WGS72BE_UTM_zone_29N",
            "PCS_WGS72BE_UTM_zone_30N", "PCS_WGS72BE_UTM_zone_31N",
            "PCS_WGS72BE_UTM_zone_32N", "PCS_WGS72BE_UTM_zone_33N",
            "PCS_WGS72BE_UTM_zone_34N", "PCS_WGS72BE_UTM_zone_35N",
            "PCS_WGS72BE_UTM_zone_36N", "PCS_WGS72BE_UTM_zone_37N",
            "PCS_WGS72BE_UTM_zone_38N", "PCS_WGS72BE_UTM_zone_39N",
            "PCS_WGS72BE_UTM_zone_40N", "PCS_WGS72BE_UTM_zone_41N",
            "PCS_WGS72BE_UTM_zone_42N", "PCS_WGS72BE_UTM_zone_43N",
            "PCS_WGS72BE_UTM_zone_44N", "PCS_WGS72BE_UTM_zone_45N",
            "PCS_WGS72BE_UTM_zone_46N", "PCS_WGS72BE_UTM_zone_47N",
            "PCS_WGS72BE_UTM_zone_48N", "PCS_WGS72BE_UTM_zone_49N",
            "PCS_WGS72BE_UTM_zone_50N", "PCS_WGS72BE_UTM_zone_51N",
            "PCS_WGS72BE_UTM_zone_52N", "PCS_WGS72BE_UTM_zone_53N",
            "PCS_WGS72BE_UTM_zone_54N", "PCS_WGS72BE_UTM_zone_55N",
            "PCS_WGS72BE_UTM_zone_56N", "PCS_WGS72BE_UTM_zone_57N",
            "PCS_WGS72BE_UTM_zone_58N", "PCS_WGS72BE_UTM_zone_59N",
            "PCS_WGS72BE_UTM_zone_60N", "PCS_WGS72BE_UTM_zone_1S",
            "PCS_WGS72BE_UTM_zone_2S", "PCS_WGS72BE_UTM_zone_3S",
            "PCS_WGS72BE_UTM_zone_4S", "PCS_WGS72BE_UTM_zone_5S",
            "PCS_WGS72BE_UTM_zone_6S", "PCS_WGS72BE_UTM_zone_7S",
            "PCS_WGS72BE_UTM_zone_8S", "PCS_WGS72BE_UTM_zone_9S",
            "PCS_WGS72BE_UTM_zone_10S", "PCS_WGS72BE_UTM_zone_11S",
            "PCS_WGS72BE_UTM_zone_12S", "PCS_WGS72BE_UTM_zone_13S",
            "PCS_WGS72BE_UTM_zone_14S", "PCS_WGS72BE_UTM_zone_15S",
            "PCS_WGS72BE_UTM_zone_16S", "PCS_WGS72BE_UTM_zone_17S",
            "PCS_WGS72BE_UTM_zone_18S", "PCS_WGS72BE_UTM_zone_19S",
            "PCS_WGS72BE_UTM_zone_20S", "PCS_WGS72BE_UTM_zone_21S",
            "PCS_WGS72BE_UTM_zone_22S", "PCS_WGS72BE_UTM_zone_23S",
            "PCS_WGS72BE_UTM_zone_24S", "PCS_WGS72BE_UTM_zone_25S",
            "PCS_WGS72BE_UTM_zone_26S", "PCS_WGS72BE_UTM_zone_27S",
            "PCS_WGS72BE_UTM_zone_28S", "PCS_WGS72BE_UTM_zone_29S",
            "PCS_WGS72BE_UTM_zone_30S", "PCS_WGS72BE_UTM_zone_31S",
            "PCS_WGS72BE_UTM_zone_32S", "PCS_WGS72BE_UTM_zone_33S",
            "PCS_WGS72BE_UTM_zone_34S", "PCS_WGS72BE_UTM_zone_35S",
            "PCS_WGS72BE_UTM_zone_36S", "PCS_WGS72BE_UTM_zone_37S",
            "PCS_WGS72BE_UTM_zone_38S", "PCS_WGS72BE_UTM_zone_39S",
            "PCS_WGS72BE_UTM_zone_40S", "PCS_WGS72BE_UTM_zone_41S",
            "PCS_WGS72BE_UTM_zone_42S", "PCS_WGS72BE_UTM_zone_43S",
            "PCS_WGS72BE_UTM_zone_44S", "PCS_WGS72BE_UTM_zone_45S",
            "PCS_WGS72BE_UTM_zone_46S", "PCS_WGS72BE_UTM_zone_47S",
            "PCS_WGS72BE_UTM_zone_48S", "PCS_WGS72BE_UTM_zone_49S",
            "PCS_WGS72BE_UTM_zone_50S", "PCS_WGS72BE_UTM_zone_51S",
            "PCS_WGS72BE_UTM_zone_52S", "PCS_WGS72BE_UTM_zone_53S",
            "PCS_WGS72BE_UTM_zone_54S", "PCS_WGS72BE_UTM_zone_55S",
            "PCS_WGS72BE_UTM_zone_56S", "PCS_WGS72BE_UTM_zone_57S",
            "PCS_WGS72BE_UTM_zone_58S", "PCS_WGS72BE_UTM_zone_59S",
            "PCS_WGS72BE_UTM_zone_60S", "PCS_WGS84_UTM_zone_1N",
            "PCS_WGS84_UTM_zone_2N", "PCS_WGS84_UTM_zone_3N",
            "PCS_WGS84_UTM_zone_4N", "PCS_WGS84_UTM_zone_5N",
            "PCS_WGS84_UTM_zone_6N", "PCS_WGS84_UTM_zone_7N",
            "PCS_WGS84_UTM_zone_8N", "PCS_WGS84_UTM_zone_9N",
            "PCS_WGS84_UTM_zone_10N", "PCS_WGS84_UTM_zone_11N",
            "PCS_WGS84_UTM_zone_12N", "PCS_WGS84_UTM_zone_13N",
            "PCS_WGS84_UTM_zone_14N", "PCS_WGS84_UTM_zone_15N",
            "PCS_WGS84_UTM_zone_16N", "PCS_WGS84_UTM_zone_17N",
            "PCS_WGS84_UTM_zone_18N", "PCS_WGS84_UTM_zone_19N",
            "PCS_WGS84_UTM_zone_20N", "PCS_WGS84_UTM_zone_21N",
            "PCS_WGS84_UTM_zone_22N", "PCS_WGS84_UTM_zone_23N",
            "PCS_WGS84_UTM_zone_24N", "PCS_WGS84_UTM_zone_25N",
            "PCS_WGS84_UTM_zone_26N", "PCS_WGS84_UTM_zone_27N",
            "PCS_WGS84_UTM_zone_28N", "PCS_WGS84_UTM_zone_29N",
            "PCS_WGS84_UTM_zone_30N", "PCS_WGS84_UTM_zone_31N",
            "PCS_WGS84_UTM_zone_32N", "PCS_WGS84_UTM_zone_33N",
            "PCS_WGS84_UTM_zone_34N", "PCS_WGS84_UTM_zone_35N",
            "PCS_WGS84_UTM_zone_36N", "PCS_WGS84_UTM_zone_37N",
            "PCS_WGS84_UTM_zone_38N", "PCS_WGS84_UTM_zone_39N",
            "PCS_WGS84_UTM_zone_40N", "PCS_WGS84_UTM_zone_41N",
            "PCS_WGS84_UTM_zone_42N", "PCS_WGS84_UTM_zone_43N",
            "PCS_WGS84_UTM_zone_44N", "PCS_WGS84_UTM_zone_45N",
            "PCS_WGS84_UTM_zone_46N", "PCS_WGS84_UTM_zone_47N",
            "PCS_WGS84_UTM_zone_48N", "PCS_WGS84_UTM_zone_49N",
            "PCS_WGS84_UTM_zone_50N", "PCS_WGS84_UTM_zone_51N",
            "PCS_WGS84_UTM_zone_52N", "PCS_WGS84_UTM_zone_53N",
            "PCS_WGS84_UTM_zone_54N", "PCS_WGS84_UTM_zone_55N",
            "PCS_WGS84_UTM_zone_56N", "PCS_WGS84_UTM_zone_57N",
            "PCS_WGS84_UTM_zone_58N", "PCS_WGS84_UTM_zone_59N",
            "PCS_WGS84_UTM_zone_60N", "PCS_WGS84_UTM_zone_1S",
            "PCS_WGS84_UTM_zone_2S", "PCS_WGS84_UTM_zone_3S",
            "PCS_WGS84_UTM_zone_4S", "PCS_WGS84_UTM_zone_5S",
            "PCS_WGS84_UTM_zone_6S", "PCS_WGS84_UTM_zone_7S",
            "PCS_WGS84_UTM_zone_8S", "PCS_WGS84_UTM_zone_9S",
            "PCS_WGS84_UTM_zone_10S", "PCS_WGS84_UTM_zone_11S",
            "PCS_WGS84_UTM_zone_12S", "PCS_WGS84_UTM_zone_13S",
            "PCS_WGS84_UTM_zone_14S", "PCS_WGS84_UTM_zone_15S",
            "PCS_WGS84_UTM_zone_16S", "PCS_WGS84_UTM_zone_17S",
            "PCS_WGS84_UTM_zone_18S", "PCS_WGS84_UTM_zone_19S",
            "PCS_WGS84_UTM_zone_20S", "PCS_WGS84_UTM_zone_21S",
            "PCS_WGS84_UTM_zone_22S", "PCS_WGS84_UTM_zone_23S",
            "PCS_WGS84_UTM_zone_24S", "PCS_WGS84_UTM_zone_25S",
            "PCS_WGS84_UTM_zone_26S", "PCS_WGS84_UTM_zone_27S",
            "PCS_WGS84_UTM_zone_28S", "PCS_WGS84_UTM_zone_29S",
            "PCS_WGS84_UTM_zone_30S", "PCS_WGS84_UTM_zone_31S",
            "PCS_WGS84_UTM_zone_32S", "PCS_WGS84_UTM_zone_33S",
            "PCS_WGS84_UTM_zone_34S", "PCS_WGS84_UTM_zone_35S",
            "PCS_WGS84_UTM_zone_36S", "PCS_WGS84_UTM_zone_37S",
            "PCS_WGS84_UTM_zone_38S", "PCS_WGS84_UTM_zone_39S",
            "PCS_WGS84_UTM_zone_40S", "PCS_WGS84_UTM_zone_41S",
            "PCS_WGS84_UTM_zone_42S", "PCS_WGS84_UTM_zone_43S",
            "PCS_WGS84_UTM_zone_44S", "PCS_WGS84_UTM_zone_45S",
            "PCS_WGS84_UTM_zone_46S", "PCS_WGS84_UTM_zone_47S",
            "PCS_WGS84_UTM_zone_48S", "PCS_WGS84_UTM_zone_49S",
            "PCS_WGS84_UTM_zone_50S", "PCS_WGS84_UTM_zone_51S",
            "PCS_WGS84_UTM_zone_52S", "PCS_WGS84_UTM_zone_53S",
            "PCS_WGS84_UTM_zone_54S", "PCS_WGS84_UTM_zone_55S",
            "PCS_WGS84_UTM_zone_56S", "PCS_WGS84_UTM_zone_57S",
            "PCS_WGS84_UTM_zone_58S", "PCS_WGS84_UTM_zone_59S",
            "PCS_WGS84_UTM_zone_60S"
        };

        /**
         * _more_
         *
         * @param value _more_
         *
         * @return _more_
         */
        public static String getName(int value) {
            for (int i = 0; i < values.length; i++) {
                if (values[i] == value) {
                    return names[i];
                }
            }
            return null;
        }
    }



    /**
     *  @author IDV development team
     */

    public static class EpsgPm {

        /** _more_          */
        public static final int Greenwich = 8901;

        /** _more_          */
        public static final int Lisbon = 8902;

        /** _more_          */
        public static final int Paris = 8903;

        /** _more_          */
        public static final int Bogota = 8904;

        /** _more_          */
        public static final int Madrid = 8905;

        /** _more_          */
        public static final int Rome = 8906;

        /** _more_          */
        public static final int Bern = 8907;

        /** _more_          */
        public static final int Jakarta = 8908;

        /** _more_          */
        public static final int Ferro = 8909;

        /** _more_          */
        public static final int Brussels = 8910;

        /** _more_          */
        public static final int Stockholm = 8911;


        /** _more_          */
        public static final int values[] = {
            Greenwich, Lisbon, Paris, Bogota, Madrid, Rome, Bern, Jakarta,
            Ferro, Brussels, Stockholm
        };

        /** _more_          */
        public static final String names[] = {
            "PM_Greenwich", "PM_Lisbon", "PM_Paris", "PM_Bogota", "PM_Madrid",
            "PM_Rome", "PM_Bern", "PM_Jakarta", "PM_Ferro", "PM_Brussels",
            "PM_Stockholm"
        };

        /**
         * _more_
         *
         * @param value _more_
         *
         * @return _more_
         */
        public static String getName(int value) {
            for (int i = 0; i < values.length; i++) {
                if (values[i] == value) {
                    return names[i];
                }
            }
            return null;
        }
    }



    /**
     *  @author IDV development team
     */

    public static class EpsgProj {

        /** _more_          */
        public static final int Alabama_CS27_East = 10101;

        /** _more_          */
        public static final int Alabama_CS27_West = 10102;

        /** _more_          */
        public static final int Alabama_CS83_East = 10131;

        /** _more_          */
        public static final int Alabama_CS83_West = 10132;

        /** _more_          */
        public static final int Arizona_Coordinate_System_east = 10201;

        /** _more_          */
        public static final int Arizona_Coordinate_System_Central = 10202;

        /** _more_          */
        public static final int Arizona_Coordinate_System_west = 10203;

        /** _more_          */
        public static final int Arizona_CS83_east = 10231;

        /** _more_          */
        public static final int Arizona_CS83_Central = 10232;

        /** _more_          */
        public static final int Arizona_CS83_west = 10233;

        /** _more_          */
        public static final int Arkansas_CS27_North = 10301;

        /** _more_          */
        public static final int Arkansas_CS27_South = 10302;

        /** _more_          */
        public static final int Arkansas_CS83_North = 10331;

        /** _more_          */
        public static final int Arkansas_CS83_South = 10332;

        /** _more_          */
        public static final int California_CS27_I = 10401;

        /** _more_          */
        public static final int California_CS27_II = 10402;

        /** _more_          */
        public static final int California_CS27_III = 10403;

        /** _more_          */
        public static final int California_CS27_IV = 10404;

        /** _more_          */
        public static final int California_CS27_V = 10405;

        /** _more_          */
        public static final int California_CS27_VI = 10406;

        /** _more_          */
        public static final int California_CS27_VII = 10407;

        /** _more_          */
        public static final int California_CS83_1 = 10431;

        /** _more_          */
        public static final int California_CS83_2 = 10432;

        /** _more_          */
        public static final int California_CS83_3 = 10433;

        /** _more_          */
        public static final int California_CS83_4 = 10434;

        /** _more_          */
        public static final int California_CS83_5 = 10435;

        /** _more_          */
        public static final int California_CS83_6 = 10436;

        /** _more_          */
        public static final int Colorado_CS27_North = 10501;

        /** _more_          */
        public static final int Colorado_CS27_Central = 10502;

        /** _more_          */
        public static final int Colorado_CS27_South = 10503;

        /** _more_          */
        public static final int Colorado_CS83_North = 10531;

        /** _more_          */
        public static final int Colorado_CS83_Central = 10532;

        /** _more_          */
        public static final int Colorado_CS83_South = 10533;

        /** _more_          */
        public static final int Connecticut_CS27 = 10600;

        /** _more_          */
        public static final int Connecticut_CS83 = 10630;

        /** _more_          */
        public static final int Delaware_CS27 = 10700;

        /** _more_          */
        public static final int Delaware_CS83 = 10730;

        /** _more_          */
        public static final int Florida_CS27_East = 10901;

        /** _more_          */
        public static final int Florida_CS27_West = 10902;

        /** _more_          */
        public static final int Florida_CS27_North = 10903;

        /** _more_          */
        public static final int Florida_CS83_East = 10931;

        /** _more_          */
        public static final int Florida_CS83_West = 10932;

        /** _more_          */
        public static final int Florida_CS83_North = 10933;

        /** _more_          */
        public static final int Georgia_CS27_East = 11001;

        /** _more_          */
        public static final int Georgia_CS27_West = 11002;

        /** _more_          */
        public static final int Georgia_CS83_East = 11031;

        /** _more_          */
        public static final int Georgia_CS83_West = 11032;

        /** _more_          */
        public static final int Idaho_CS27_East = 11101;

        /** _more_          */
        public static final int Idaho_CS27_Central = 11102;

        /** _more_          */
        public static final int Idaho_CS27_West = 11103;

        /** _more_          */
        public static final int Idaho_CS83_East = 11131;

        /** _more_          */
        public static final int Idaho_CS83_Central = 11132;

        /** _more_          */
        public static final int Idaho_CS83_West = 11133;

        /** _more_          */
        public static final int Illinois_CS27_East = 11201;

        /** _more_          */
        public static final int Illinois_CS27_West = 11202;

        /** _more_          */
        public static final int Illinois_CS83_East = 11231;

        /** _more_          */
        public static final int Illinois_CS83_West = 11232;

        /** _more_          */
        public static final int Indiana_CS27_East = 11301;

        /** _more_          */
        public static final int Indiana_CS27_West = 11302;

        /** _more_          */
        public static final int Indiana_CS83_East = 11331;

        /** _more_          */
        public static final int Indiana_CS83_West = 11332;

        /** _more_          */
        public static final int Iowa_CS27_North = 11401;

        /** _more_          */
        public static final int Iowa_CS27_South = 11402;

        /** _more_          */
        public static final int Iowa_CS83_North = 11431;

        /** _more_          */
        public static final int Iowa_CS83_South = 11432;

        /** _more_          */
        public static final int Kansas_CS27_North = 11501;

        /** _more_          */
        public static final int Kansas_CS27_South = 11502;

        /** _more_          */
        public static final int Kansas_CS83_North = 11531;

        /** _more_          */
        public static final int Kansas_CS83_South = 11532;

        /** _more_          */
        public static final int Kentucky_CS27_North = 11601;

        /** _more_          */
        public static final int Kentucky_CS27_South = 11602;

        /** _more_          */
        public static final int Kentucky_CS83_North = 11631;

        /** _more_          */
        public static final int Kentucky_CS83_South = 11632;

        /** _more_          */
        public static final int Louisiana_CS27_North = 11701;

        /** _more_          */
        public static final int Louisiana_CS27_South = 11702;

        /** _more_          */
        public static final int Louisiana_CS83_North = 11731;

        /** _more_          */
        public static final int Louisiana_CS83_South = 11732;

        /** _more_          */
        public static final int Maine_CS27_East = 11801;

        /** _more_          */
        public static final int Maine_CS27_West = 11802;

        /** _more_          */
        public static final int Maine_CS83_East = 11831;

        /** _more_          */
        public static final int Maine_CS83_West = 11832;

        /** _more_          */
        public static final int Maryland_CS27 = 11900;

        /** _more_          */
        public static final int Maryland_CS83 = 11930;

        /** _more_          */
        public static final int Massachusetts_CS27_Mainland = 12001;

        /** _more_          */
        public static final int Massachusetts_CS27_Island = 12002;

        /** _more_          */
        public static final int Massachusetts_CS83_Mainland = 12031;

        /** _more_          */
        public static final int Massachusetts_CS83_Island = 12032;

        /** _more_          */
        public static final int Michigan_State_Plane_East = 12101;

        /** _more_          */
        public static final int Michigan_State_Plane_Old_Central = 12102;

        /** _more_          */
        public static final int Michigan_State_Plane_West = 12103;

        /** _more_          */
        public static final int Michigan_CS27_North = 12111;

        /** _more_          */
        public static final int Michigan_CS27_Central = 12112;

        /** _more_          */
        public static final int Michigan_CS27_South = 12113;

        /** _more_          */
        public static final int Michigan_CS83_North = 12141;

        /** _more_          */
        public static final int Michigan_CS83_Central = 12142;

        /** _more_          */
        public static final int Michigan_CS83_South = 12143;

        /** _more_          */
        public static final int Minnesota_CS27_North = 12201;

        /** _more_          */
        public static final int Minnesota_CS27_Central = 12202;

        /** _more_          */
        public static final int Minnesota_CS27_South = 12203;

        /** _more_          */
        public static final int Minnesota_CS83_North = 12231;

        /** _more_          */
        public static final int Minnesota_CS83_Central = 12232;

        /** _more_          */
        public static final int Minnesota_CS83_South = 12233;

        /** _more_          */
        public static final int Mississippi_CS27_East = 12301;

        /** _more_          */
        public static final int Mississippi_CS27_West = 12302;

        /** _more_          */
        public static final int Mississippi_CS83_East = 12331;

        /** _more_          */
        public static final int Mississippi_CS83_West = 12332;

        /** _more_          */
        public static final int Missouri_CS27_East = 12401;

        /** _more_          */
        public static final int Missouri_CS27_Central = 12402;

        /** _more_          */
        public static final int Missouri_CS27_West = 12403;

        /** _more_          */
        public static final int Missouri_CS83_East = 12431;

        /** _more_          */
        public static final int Missouri_CS83_Central = 12432;

        /** _more_          */
        public static final int Missouri_CS83_West = 12433;

        /** _more_          */
        public static final int Montana_CS27_North = 12501;

        /** _more_          */
        public static final int Montana_CS27_Central = 12502;

        /** _more_          */
        public static final int Montana_CS27_South = 12503;

        /** _more_          */
        public static final int Montana_CS83 = 12530;

        /** _more_          */
        public static final int Nebraska_CS27_North = 12601;

        /** _more_          */
        public static final int Nebraska_CS27_South = 12602;

        /** _more_          */
        public static final int Nebraska_CS83 = 12630;

        /** _more_          */
        public static final int Nevada_CS27_East = 12701;

        /** _more_          */
        public static final int Nevada_CS27_Central = 12702;

        /** _more_          */
        public static final int Nevada_CS27_West = 12703;

        /** _more_          */
        public static final int Nevada_CS83_East = 12731;

        /** _more_          */
        public static final int Nevada_CS83_Central = 12732;

        /** _more_          */
        public static final int Nevada_CS83_West = 12733;

        /** _more_          */
        public static final int New_Hampshire_CS27 = 12800;

        /** _more_          */
        public static final int New_Hampshire_CS83 = 12830;

        /** _more_          */
        public static final int New_Jersey_CS27 = 12900;

        /** _more_          */
        public static final int New_Jersey_CS83 = 12930;

        /** _more_          */
        public static final int New_Mexico_CS27_East = 13001;

        /** _more_          */
        public static final int New_Mexico_CS27_Central = 13002;

        /** _more_          */
        public static final int New_Mexico_CS27_West = 13003;

        /** _more_          */
        public static final int New_Mexico_CS83_East = 13031;

        /** _more_          */
        public static final int New_Mexico_CS83_Central = 13032;

        /** _more_          */
        public static final int New_Mexico_CS83_West = 13033;

        /** _more_          */
        public static final int New_York_CS27_East = 13101;

        /** _more_          */
        public static final int New_York_CS27_Central = 13102;

        /** _more_          */
        public static final int New_York_CS27_West = 13103;

        /** _more_          */
        public static final int New_York_CS27_Long_Island = 13104;

        /** _more_          */
        public static final int New_York_CS83_East = 13131;

        /** _more_          */
        public static final int New_York_CS83_Central = 13132;

        /** _more_          */
        public static final int New_York_CS83_West = 13133;

        /** _more_          */
        public static final int New_York_CS83_Long_Island = 13134;

        /** _more_          */
        public static final int North_Carolina_CS27 = 13200;

        /** _more_          */
        public static final int North_Carolina_CS83 = 13230;

        /** _more_          */
        public static final int North_Dakota_CS27_North = 13301;

        /** _more_          */
        public static final int North_Dakota_CS27_South = 13302;

        /** _more_          */
        public static final int North_Dakota_CS83_North = 13331;

        /** _more_          */
        public static final int North_Dakota_CS83_South = 13332;

        /** _more_          */
        public static final int Ohio_CS27_North = 13401;

        /** _more_          */
        public static final int Ohio_CS27_South = 13402;

        /** _more_          */
        public static final int Ohio_CS83_North = 13431;

        /** _more_          */
        public static final int Ohio_CS83_South = 13432;

        /** _more_          */
        public static final int Oklahoma_CS27_North = 13501;

        /** _more_          */
        public static final int Oklahoma_CS27_South = 13502;

        /** _more_          */
        public static final int Oklahoma_CS83_North = 13531;

        /** _more_          */
        public static final int Oklahoma_CS83_South = 13532;

        /** _more_          */
        public static final int Oregon_CS27_North = 13601;

        /** _more_          */
        public static final int Oregon_CS27_South = 13602;

        /** _more_          */
        public static final int Oregon_CS83_North = 13631;

        /** _more_          */
        public static final int Oregon_CS83_South = 13632;

        /** _more_          */
        public static final int Pennsylvania_CS27_North = 13701;

        /** _more_          */
        public static final int Pennsylvania_CS27_South = 13702;

        /** _more_          */
        public static final int Pennsylvania_CS83_North = 13731;

        /** _more_          */
        public static final int Pennsylvania_CS83_South = 13732;

        /** _more_          */
        public static final int Rhode_Island_CS27 = 13800;

        /** _more_          */
        public static final int Rhode_Island_CS83 = 13830;

        /** _more_          */
        public static final int South_Carolina_CS27_North = 13901;

        /** _more_          */
        public static final int South_Carolina_CS27_South = 13902;

        /** _more_          */
        public static final int South_Carolina_CS83 = 13930;

        /** _more_          */
        public static final int South_Dakota_CS27_North = 14001;

        /** _more_          */
        public static final int South_Dakota_CS27_South = 14002;

        /** _more_          */
        public static final int South_Dakota_CS83_North = 14031;

        /** _more_          */
        public static final int South_Dakota_CS83_South = 14032;

        /** _more_          */
        public static final int Tennessee_CS27 = 14100;

        /** _more_          */
        public static final int Tennessee_CS83 = 14130;

        /** _more_          */
        public static final int Texas_CS27_North = 14201;

        /** _more_          */
        public static final int Texas_CS27_North_Central = 14202;

        /** _more_          */
        public static final int Texas_CS27_Central = 14203;

        /** _more_          */
        public static final int Texas_CS27_South_Central = 14204;

        /** _more_          */
        public static final int Texas_CS27_South = 14205;

        /** _more_          */
        public static final int Texas_CS83_North = 14231;

        /** _more_          */
        public static final int Texas_CS83_North_Central = 14232;

        /** _more_          */
        public static final int Texas_CS83_Central = 14233;

        /** _more_          */
        public static final int Texas_CS83_South_Central = 14234;

        /** _more_          */
        public static final int Texas_CS83_South = 14235;

        /** _more_          */
        public static final int Utah_CS27_North = 14301;

        /** _more_          */
        public static final int Utah_CS27_Central = 14302;

        /** _more_          */
        public static final int Utah_CS27_South = 14303;

        /** _more_          */
        public static final int Utah_CS83_North = 14331;

        /** _more_          */
        public static final int Utah_CS83_Central = 14332;

        /** _more_          */
        public static final int Utah_CS83_South = 14333;

        /** _more_          */
        public static final int Vermont_CS27 = 14400;

        /** _more_          */
        public static final int Vermont_CS83 = 14430;

        /** _more_          */
        public static final int Virginia_CS27_North = 14501;

        /** _more_          */
        public static final int Virginia_CS27_South = 14502;

        /** _more_          */
        public static final int Virginia_CS83_North = 14531;

        /** _more_          */
        public static final int Virginia_CS83_South = 14532;

        /** _more_          */
        public static final int Washington_CS27_North = 14601;

        /** _more_          */
        public static final int Washington_CS27_South = 14602;

        /** _more_          */
        public static final int Washington_CS83_North = 14631;

        /** _more_          */
        public static final int Washington_CS83_South = 14632;

        /** _more_          */
        public static final int West_Virginia_CS27_North = 14701;

        /** _more_          */
        public static final int West_Virginia_CS27_South = 14702;

        /** _more_          */
        public static final int West_Virginia_CS83_North = 14731;

        /** _more_          */
        public static final int West_Virginia_CS83_South = 14732;

        /** _more_          */
        public static final int Wisconsin_CS27_North = 14801;

        /** _more_          */
        public static final int Wisconsin_CS27_Central = 14802;

        /** _more_          */
        public static final int Wisconsin_CS27_South = 14803;

        /** _more_          */
        public static final int Wisconsin_CS83_North = 14831;

        /** _more_          */
        public static final int Wisconsin_CS83_Central = 14832;

        /** _more_          */
        public static final int Wisconsin_CS83_South = 14833;

        /** _more_          */
        public static final int Wyoming_CS27_East = 14901;

        /** _more_          */
        public static final int Wyoming_CS27_East_Central = 14902;

        /** _more_          */
        public static final int Wyoming_CS27_West_Central = 14903;

        /** _more_          */
        public static final int Wyoming_CS27_West = 14904;

        /** _more_          */
        public static final int Wyoming_CS83_East = 14931;

        /** _more_          */
        public static final int Wyoming_CS83_East_Central = 14932;

        /** _more_          */
        public static final int Wyoming_CS83_West_Central = 14933;

        /** _more_          */
        public static final int Wyoming_CS83_West = 14934;

        /** _more_          */
        public static final int Alaska_CS27_1 = 15001;

        /** _more_          */
        public static final int Alaska_CS27_2 = 15002;

        /** _more_          */
        public static final int Alaska_CS27_3 = 15003;

        /** _more_          */
        public static final int Alaska_CS27_4 = 15004;

        /** _more_          */
        public static final int Alaska_CS27_5 = 15005;

        /** _more_          */
        public static final int Alaska_CS27_6 = 15006;

        /** _more_          */
        public static final int Alaska_CS27_7 = 15007;

        /** _more_          */
        public static final int Alaska_CS27_8 = 15008;

        /** _more_          */
        public static final int Alaska_CS27_9 = 15009;

        /** _more_          */
        public static final int Alaska_CS27_10 = 15010;

        /** _more_          */
        public static final int Alaska_CS83_1 = 15031;

        /** _more_          */
        public static final int Alaska_CS83_2 = 15032;

        /** _more_          */
        public static final int Alaska_CS83_3 = 15033;

        /** _more_          */
        public static final int Alaska_CS83_4 = 15034;

        /** _more_          */
        public static final int Alaska_CS83_5 = 15035;

        /** _more_          */
        public static final int Alaska_CS83_6 = 15036;

        /** _more_          */
        public static final int Alaska_CS83_7 = 15037;

        /** _more_          */
        public static final int Alaska_CS83_8 = 15038;

        /** _more_          */
        public static final int Alaska_CS83_9 = 15039;

        /** _more_          */
        public static final int Alaska_CS83_10 = 15040;

        /** _more_          */
        public static final int Hawaii_CS27_1 = 15101;

        /** _more_          */
        public static final int Hawaii_CS27_2 = 15102;

        /** _more_          */
        public static final int Hawaii_CS27_3 = 15103;

        /** _more_          */
        public static final int Hawaii_CS27_4 = 15104;

        /** _more_          */
        public static final int Hawaii_CS27_5 = 15105;

        /** _more_          */
        public static final int Hawaii_CS83_1 = 15131;

        /** _more_          */
        public static final int Hawaii_CS83_2 = 15132;

        /** _more_          */
        public static final int Hawaii_CS83_3 = 15133;

        /** _more_          */
        public static final int Hawaii_CS83_4 = 15134;

        /** _more_          */
        public static final int Hawaii_CS83_5 = 15135;

        /** _more_          */
        public static final int Puerto_Rico_CS27 = 15201;

        /** _more_          */
        public static final int St_Croix = 15202;

        /** _more_          */
        public static final int Puerto_Rico_Virgin_Is = 15230;

        /** _more_          */
        public static final int BLM_14N_feet = 15914;

        /** _more_          */
        public static final int BLM_15N_feet = 15915;

        /** _more_          */
        public static final int BLM_16N_feet = 15916;

        /** _more_          */
        public static final int BLM_17N_feet = 15917;

        /** _more_          */
        public static final int Map_Grid_of_Australia_48 = 17348;

        /** _more_          */
        public static final int Map_Grid_of_Australia_49 = 17349;

        /** _more_          */
        public static final int Map_Grid_of_Australia_50 = 17350;

        /** _more_          */
        public static final int Map_Grid_of_Australia_51 = 17351;

        /** _more_          */
        public static final int Map_Grid_of_Australia_52 = 17352;

        /** _more_          */
        public static final int Map_Grid_of_Australia_53 = 17353;

        /** _more_          */
        public static final int Map_Grid_of_Australia_54 = 17354;

        /** _more_          */
        public static final int Map_Grid_of_Australia_55 = 17355;

        /** _more_          */
        public static final int Map_Grid_of_Australia_56 = 17356;

        /** _more_          */
        public static final int Map_Grid_of_Australia_57 = 17357;

        /** _more_          */
        public static final int Map_Grid_of_Australia_58 = 17358;

        /** _more_          */
        public static final int Australian_Map_Grid_48 = 17448;

        /** _more_          */
        public static final int Australian_Map_Grid_49 = 17449;

        /** _more_          */
        public static final int Australian_Map_Grid_50 = 17450;

        /** _more_          */
        public static final int Australian_Map_Grid_51 = 17451;

        /** _more_          */
        public static final int Australian_Map_Grid_52 = 17452;

        /** _more_          */
        public static final int Australian_Map_Grid_53 = 17453;

        /** _more_          */
        public static final int Australian_Map_Grid_54 = 17454;

        /** _more_          */
        public static final int Australian_Map_Grid_55 = 17455;

        /** _more_          */
        public static final int Australian_Map_Grid_56 = 17456;

        /** _more_          */
        public static final int Australian_Map_Grid_57 = 17457;

        /** _more_          */
        public static final int Australian_Map_Grid_58 = 17458;

        /** _more_          */
        public static final int Argentina_1 = 18031;

        /** _more_          */
        public static final int Argentina_2 = 18032;

        /** _more_          */
        public static final int Argentina_3 = 18033;

        /** _more_          */
        public static final int Argentina_4 = 18034;

        /** _more_          */
        public static final int Argentina_5 = 18035;

        /** _more_          */
        public static final int Argentina_6 = 18036;

        /** _more_          */
        public static final int Argentina_7 = 18037;

        /** _more_          */
        public static final int Colombia_3W = 18051;

        /** _more_          */
        public static final int Colombia_Bogota = 18052;

        /** _more_          */
        public static final int Colombia_3E = 18053;

        /** _more_          */
        public static final int Colombia_6E = 18054;

        /** _more_          */
        public static final int Egypt_Red_Belt = 18072;

        /** _more_          */
        public static final int Egypt_Purple_Belt = 18073;

        /** _more_          */
        public static final int Extended_Purple_Belt = 18074;

        /** _more_          */
        public static final int New_Zealand_North_Island_Nat_Grid = 18141;

        /** _more_          */
        public static final int New_Zealand_South_Island_Nat_Grid = 18142;

        /** _more_          */
        public static final int Bahrain_Grid = 19900;

        /** _more_          */
        public static final int Netherlands_E_Indies_Equatorial = 19905;

        /** _more_          */
        public static final int RSO_Borneo = 19912;


        /** _more_          */
        public static final int values[] = {
            Alabama_CS27_East, Alabama_CS27_West, Alabama_CS83_East,
            Alabama_CS83_West, Arizona_Coordinate_System_east,
            Arizona_Coordinate_System_Central, Arizona_Coordinate_System_west,
            Arizona_CS83_east, Arizona_CS83_Central, Arizona_CS83_west,
            Arkansas_CS27_North, Arkansas_CS27_South, Arkansas_CS83_North,
            Arkansas_CS83_South, California_CS27_I, California_CS27_II,
            California_CS27_III, California_CS27_IV, California_CS27_V,
            California_CS27_VI, California_CS27_VII, California_CS83_1,
            California_CS83_2, California_CS83_3, California_CS83_4,
            California_CS83_5, California_CS83_6, Colorado_CS27_North,
            Colorado_CS27_Central, Colorado_CS27_South, Colorado_CS83_North,
            Colorado_CS83_Central, Colorado_CS83_South, Connecticut_CS27,
            Connecticut_CS83, Delaware_CS27, Delaware_CS83, Florida_CS27_East,
            Florida_CS27_West, Florida_CS27_North, Florida_CS83_East,
            Florida_CS83_West, Florida_CS83_North, Georgia_CS27_East,
            Georgia_CS27_West, Georgia_CS83_East, Georgia_CS83_West,
            Idaho_CS27_East, Idaho_CS27_Central, Idaho_CS27_West,
            Idaho_CS83_East, Idaho_CS83_Central, Idaho_CS83_West,
            Illinois_CS27_East, Illinois_CS27_West, Illinois_CS83_East,
            Illinois_CS83_West, Indiana_CS27_East, Indiana_CS27_West,
            Indiana_CS83_East, Indiana_CS83_West, Iowa_CS27_North,
            Iowa_CS27_South, Iowa_CS83_North, Iowa_CS83_South,
            Kansas_CS27_North, Kansas_CS27_South, Kansas_CS83_North,
            Kansas_CS83_South, Kentucky_CS27_North, Kentucky_CS27_South,
            Kentucky_CS83_North, Kentucky_CS83_South, Louisiana_CS27_North,
            Louisiana_CS27_South, Louisiana_CS83_North, Louisiana_CS83_South,
            Maine_CS27_East, Maine_CS27_West, Maine_CS83_East,
            Maine_CS83_West, Maryland_CS27, Maryland_CS83,
            Massachusetts_CS27_Mainland, Massachusetts_CS27_Island,
            Massachusetts_CS83_Mainland, Massachusetts_CS83_Island,
            Michigan_State_Plane_East, Michigan_State_Plane_Old_Central,
            Michigan_State_Plane_West, Michigan_CS27_North,
            Michigan_CS27_Central, Michigan_CS27_South, Michigan_CS83_North,
            Michigan_CS83_Central, Michigan_CS83_South, Minnesota_CS27_North,
            Minnesota_CS27_Central, Minnesota_CS27_South,
            Minnesota_CS83_North, Minnesota_CS83_Central,
            Minnesota_CS83_South, Mississippi_CS27_East,
            Mississippi_CS27_West, Mississippi_CS83_East,
            Mississippi_CS83_West, Missouri_CS27_East, Missouri_CS27_Central,
            Missouri_CS27_West, Missouri_CS83_East, Missouri_CS83_Central,
            Missouri_CS83_West, Montana_CS27_North, Montana_CS27_Central,
            Montana_CS27_South, Montana_CS83, Nebraska_CS27_North,
            Nebraska_CS27_South, Nebraska_CS83, Nevada_CS27_East,
            Nevada_CS27_Central, Nevada_CS27_West, Nevada_CS83_East,
            Nevada_CS83_Central, Nevada_CS83_West, New_Hampshire_CS27,
            New_Hampshire_CS83, New_Jersey_CS27, New_Jersey_CS83,
            New_Mexico_CS27_East, New_Mexico_CS27_Central,
            New_Mexico_CS27_West, New_Mexico_CS83_East,
            New_Mexico_CS83_Central, New_Mexico_CS83_West, New_York_CS27_East,
            New_York_CS27_Central, New_York_CS27_West,
            New_York_CS27_Long_Island, New_York_CS83_East,
            New_York_CS83_Central, New_York_CS83_West,
            New_York_CS83_Long_Island, North_Carolina_CS27,
            North_Carolina_CS83, North_Dakota_CS27_North,
            North_Dakota_CS27_South, North_Dakota_CS83_North,
            North_Dakota_CS83_South, Ohio_CS27_North, Ohio_CS27_South,
            Ohio_CS83_North, Ohio_CS83_South, Oklahoma_CS27_North,
            Oklahoma_CS27_South, Oklahoma_CS83_North, Oklahoma_CS83_South,
            Oregon_CS27_North, Oregon_CS27_South, Oregon_CS83_North,
            Oregon_CS83_South, Pennsylvania_CS27_North,
            Pennsylvania_CS27_South, Pennsylvania_CS83_North,
            Pennsylvania_CS83_South, Rhode_Island_CS27, Rhode_Island_CS83,
            South_Carolina_CS27_North, South_Carolina_CS27_South,
            South_Carolina_CS83, South_Dakota_CS27_North,
            South_Dakota_CS27_South, South_Dakota_CS83_North,
            South_Dakota_CS83_South, Tennessee_CS27, Tennessee_CS83,
            Texas_CS27_North, Texas_CS27_North_Central, Texas_CS27_Central,
            Texas_CS27_South_Central, Texas_CS27_South, Texas_CS83_North,
            Texas_CS83_North_Central, Texas_CS83_Central,
            Texas_CS83_South_Central, Texas_CS83_South, Utah_CS27_North,
            Utah_CS27_Central, Utah_CS27_South, Utah_CS83_North,
            Utah_CS83_Central, Utah_CS83_South, Vermont_CS27, Vermont_CS83,
            Virginia_CS27_North, Virginia_CS27_South, Virginia_CS83_North,
            Virginia_CS83_South, Washington_CS27_North, Washington_CS27_South,
            Washington_CS83_North, Washington_CS83_South,
            West_Virginia_CS27_North, West_Virginia_CS27_South,
            West_Virginia_CS83_North, West_Virginia_CS83_South,
            Wisconsin_CS27_North, Wisconsin_CS27_Central,
            Wisconsin_CS27_South, Wisconsin_CS83_North,
            Wisconsin_CS83_Central, Wisconsin_CS83_South, Wyoming_CS27_East,
            Wyoming_CS27_East_Central, Wyoming_CS27_West_Central,
            Wyoming_CS27_West, Wyoming_CS83_East, Wyoming_CS83_East_Central,
            Wyoming_CS83_West_Central, Wyoming_CS83_West, Alaska_CS27_1,
            Alaska_CS27_2, Alaska_CS27_3, Alaska_CS27_4, Alaska_CS27_5,
            Alaska_CS27_6, Alaska_CS27_7, Alaska_CS27_8, Alaska_CS27_9,
            Alaska_CS27_10, Alaska_CS83_1, Alaska_CS83_2, Alaska_CS83_3,
            Alaska_CS83_4, Alaska_CS83_5, Alaska_CS83_6, Alaska_CS83_7,
            Alaska_CS83_8, Alaska_CS83_9, Alaska_CS83_10, Hawaii_CS27_1,
            Hawaii_CS27_2, Hawaii_CS27_3, Hawaii_CS27_4, Hawaii_CS27_5,
            Hawaii_CS83_1, Hawaii_CS83_2, Hawaii_CS83_3, Hawaii_CS83_4,
            Hawaii_CS83_5, Puerto_Rico_CS27, St_Croix, Puerto_Rico_Virgin_Is,
            BLM_14N_feet, BLM_15N_feet, BLM_16N_feet, BLM_17N_feet,
            Map_Grid_of_Australia_48, Map_Grid_of_Australia_49,
            Map_Grid_of_Australia_50, Map_Grid_of_Australia_51,
            Map_Grid_of_Australia_52, Map_Grid_of_Australia_53,
            Map_Grid_of_Australia_54, Map_Grid_of_Australia_55,
            Map_Grid_of_Australia_56, Map_Grid_of_Australia_57,
            Map_Grid_of_Australia_58, Australian_Map_Grid_48,
            Australian_Map_Grid_49, Australian_Map_Grid_50,
            Australian_Map_Grid_51, Australian_Map_Grid_52,
            Australian_Map_Grid_53, Australian_Map_Grid_54,
            Australian_Map_Grid_55, Australian_Map_Grid_56,
            Australian_Map_Grid_57, Australian_Map_Grid_58, Argentina_1,
            Argentina_2, Argentina_3, Argentina_4, Argentina_5, Argentina_6,
            Argentina_7, Colombia_3W, Colombia_Bogota, Colombia_3E,
            Colombia_6E, Egypt_Red_Belt, Egypt_Purple_Belt,
            Extended_Purple_Belt, New_Zealand_North_Island_Nat_Grid,
            New_Zealand_South_Island_Nat_Grid, Bahrain_Grid,
            Netherlands_E_Indies_Equatorial, RSO_Borneo
        };

        /** _more_          */
        public static final String names[] = {
            "Proj_Alabama_CS27_East", "Proj_Alabama_CS27_West",
            "Proj_Alabama_CS83_East", "Proj_Alabama_CS83_West",
            "Proj_Arizona_Coordinate_System_east",
            "Proj_Arizona_Coordinate_System_Central",
            "Proj_Arizona_Coordinate_System_west", "Proj_Arizona_CS83_east",
            "Proj_Arizona_CS83_Central", "Proj_Arizona_CS83_west",
            "Proj_Arkansas_CS27_North", "Proj_Arkansas_CS27_South",
            "Proj_Arkansas_CS83_North", "Proj_Arkansas_CS83_South",
            "Proj_California_CS27_I", "Proj_California_CS27_II",
            "Proj_California_CS27_III", "Proj_California_CS27_IV",
            "Proj_California_CS27_V", "Proj_California_CS27_VI",
            "Proj_California_CS27_VII", "Proj_California_CS83_1",
            "Proj_California_CS83_2", "Proj_California_CS83_3",
            "Proj_California_CS83_4", "Proj_California_CS83_5",
            "Proj_California_CS83_6", "Proj_Colorado_CS27_North",
            "Proj_Colorado_CS27_Central", "Proj_Colorado_CS27_South",
            "Proj_Colorado_CS83_North", "Proj_Colorado_CS83_Central",
            "Proj_Colorado_CS83_South", "Proj_Connecticut_CS27",
            "Proj_Connecticut_CS83", "Proj_Delaware_CS27",
            "Proj_Delaware_CS83", "Proj_Florida_CS27_East",
            "Proj_Florida_CS27_West", "Proj_Florida_CS27_North",
            "Proj_Florida_CS83_East", "Proj_Florida_CS83_West",
            "Proj_Florida_CS83_North", "Proj_Georgia_CS27_East",
            "Proj_Georgia_CS27_West", "Proj_Georgia_CS83_East",
            "Proj_Georgia_CS83_West", "Proj_Idaho_CS27_East",
            "Proj_Idaho_CS27_Central", "Proj_Idaho_CS27_West",
            "Proj_Idaho_CS83_East", "Proj_Idaho_CS83_Central",
            "Proj_Idaho_CS83_West", "Proj_Illinois_CS27_East",
            "Proj_Illinois_CS27_West", "Proj_Illinois_CS83_East",
            "Proj_Illinois_CS83_West", "Proj_Indiana_CS27_East",
            "Proj_Indiana_CS27_West", "Proj_Indiana_CS83_East",
            "Proj_Indiana_CS83_West", "Proj_Iowa_CS27_North",
            "Proj_Iowa_CS27_South", "Proj_Iowa_CS83_North",
            "Proj_Iowa_CS83_South", "Proj_Kansas_CS27_North",
            "Proj_Kansas_CS27_South", "Proj_Kansas_CS83_North",
            "Proj_Kansas_CS83_South", "Proj_Kentucky_CS27_North",
            "Proj_Kentucky_CS27_South", "Proj_Kentucky_CS83_North",
            "Proj_Kentucky_CS83_South", "Proj_Louisiana_CS27_North",
            "Proj_Louisiana_CS27_South", "Proj_Louisiana_CS83_North",
            "Proj_Louisiana_CS83_South", "Proj_Maine_CS27_East",
            "Proj_Maine_CS27_West", "Proj_Maine_CS83_East",
            "Proj_Maine_CS83_West", "Proj_Maryland_CS27",
            "Proj_Maryland_CS83", "Proj_Massachusetts_CS27_Mainland",
            "Proj_Massachusetts_CS27_Island",
            "Proj_Massachusetts_CS83_Mainland",
            "Proj_Massachusetts_CS83_Island",
            "Proj_Michigan_State_Plane_East",
            "Proj_Michigan_State_Plane_Old_Central",
            "Proj_Michigan_State_Plane_West", "Proj_Michigan_CS27_North",
            "Proj_Michigan_CS27_Central", "Proj_Michigan_CS27_South",
            "Proj_Michigan_CS83_North", "Proj_Michigan_CS83_Central",
            "Proj_Michigan_CS83_South", "Proj_Minnesota_CS27_North",
            "Proj_Minnesota_CS27_Central", "Proj_Minnesota_CS27_South",
            "Proj_Minnesota_CS83_North", "Proj_Minnesota_CS83_Central",
            "Proj_Minnesota_CS83_South", "Proj_Mississippi_CS27_East",
            "Proj_Mississippi_CS27_West", "Proj_Mississippi_CS83_East",
            "Proj_Mississippi_CS83_West", "Proj_Missouri_CS27_East",
            "Proj_Missouri_CS27_Central", "Proj_Missouri_CS27_West",
            "Proj_Missouri_CS83_East", "Proj_Missouri_CS83_Central",
            "Proj_Missouri_CS83_West", "Proj_Montana_CS27_North",
            "Proj_Montana_CS27_Central", "Proj_Montana_CS27_South",
            "Proj_Montana_CS83", "Proj_Nebraska_CS27_North",
            "Proj_Nebraska_CS27_South", "Proj_Nebraska_CS83",
            "Proj_Nevada_CS27_East", "Proj_Nevada_CS27_Central",
            "Proj_Nevada_CS27_West", "Proj_Nevada_CS83_East",
            "Proj_Nevada_CS83_Central", "Proj_Nevada_CS83_West",
            "Proj_New_Hampshire_CS27", "Proj_New_Hampshire_CS83",
            "Proj_New_Jersey_CS27", "Proj_New_Jersey_CS83",
            "Proj_New_Mexico_CS27_East", "Proj_New_Mexico_CS27_Central",
            "Proj_New_Mexico_CS27_West", "Proj_New_Mexico_CS83_East",
            "Proj_New_Mexico_CS83_Central", "Proj_New_Mexico_CS83_West",
            "Proj_New_York_CS27_East", "Proj_New_York_CS27_Central",
            "Proj_New_York_CS27_West", "Proj_New_York_CS27_Long_Island",
            "Proj_New_York_CS83_East", "Proj_New_York_CS83_Central",
            "Proj_New_York_CS83_West", "Proj_New_York_CS83_Long_Island",
            "Proj_North_Carolina_CS27", "Proj_North_Carolina_CS83",
            "Proj_North_Dakota_CS27_North", "Proj_North_Dakota_CS27_South",
            "Proj_North_Dakota_CS83_North", "Proj_North_Dakota_CS83_South",
            "Proj_Ohio_CS27_North", "Proj_Ohio_CS27_South",
            "Proj_Ohio_CS83_North", "Proj_Ohio_CS83_South",
            "Proj_Oklahoma_CS27_North", "Proj_Oklahoma_CS27_South",
            "Proj_Oklahoma_CS83_North", "Proj_Oklahoma_CS83_South",
            "Proj_Oregon_CS27_North", "Proj_Oregon_CS27_South",
            "Proj_Oregon_CS83_North", "Proj_Oregon_CS83_South",
            "Proj_Pennsylvania_CS27_North", "Proj_Pennsylvania_CS27_South",
            "Proj_Pennsylvania_CS83_North", "Proj_Pennsylvania_CS83_South",
            "Proj_Rhode_Island_CS27", "Proj_Rhode_Island_CS83",
            "Proj_South_Carolina_CS27_North",
            "Proj_South_Carolina_CS27_South", "Proj_South_Carolina_CS83",
            "Proj_South_Dakota_CS27_North", "Proj_South_Dakota_CS27_South",
            "Proj_South_Dakota_CS83_North", "Proj_South_Dakota_CS83_South",
            "Proj_Tennessee_CS27", "Proj_Tennessee_CS83",
            "Proj_Texas_CS27_North", "Proj_Texas_CS27_North_Central",
            "Proj_Texas_CS27_Central", "Proj_Texas_CS27_South_Central",
            "Proj_Texas_CS27_South", "Proj_Texas_CS83_North",
            "Proj_Texas_CS83_North_Central", "Proj_Texas_CS83_Central",
            "Proj_Texas_CS83_South_Central", "Proj_Texas_CS83_South",
            "Proj_Utah_CS27_North", "Proj_Utah_CS27_Central",
            "Proj_Utah_CS27_South", "Proj_Utah_CS83_North",
            "Proj_Utah_CS83_Central", "Proj_Utah_CS83_South",
            "Proj_Vermont_CS27", "Proj_Vermont_CS83",
            "Proj_Virginia_CS27_North", "Proj_Virginia_CS27_South",
            "Proj_Virginia_CS83_North", "Proj_Virginia_CS83_South",
            "Proj_Washington_CS27_North", "Proj_Washington_CS27_South",
            "Proj_Washington_CS83_North", "Proj_Washington_CS83_South",
            "Proj_West_Virginia_CS27_North", "Proj_West_Virginia_CS27_South",
            "Proj_West_Virginia_CS83_North", "Proj_West_Virginia_CS83_South",
            "Proj_Wisconsin_CS27_North", "Proj_Wisconsin_CS27_Central",
            "Proj_Wisconsin_CS27_South", "Proj_Wisconsin_CS83_North",
            "Proj_Wisconsin_CS83_Central", "Proj_Wisconsin_CS83_South",
            "Proj_Wyoming_CS27_East", "Proj_Wyoming_CS27_East_Central",
            "Proj_Wyoming_CS27_West_Central", "Proj_Wyoming_CS27_West",
            "Proj_Wyoming_CS83_East", "Proj_Wyoming_CS83_East_Central",
            "Proj_Wyoming_CS83_West_Central", "Proj_Wyoming_CS83_West",
            "Proj_Alaska_CS27_1", "Proj_Alaska_CS27_2", "Proj_Alaska_CS27_3",
            "Proj_Alaska_CS27_4", "Proj_Alaska_CS27_5", "Proj_Alaska_CS27_6",
            "Proj_Alaska_CS27_7", "Proj_Alaska_CS27_8", "Proj_Alaska_CS27_9",
            "Proj_Alaska_CS27_10", "Proj_Alaska_CS83_1", "Proj_Alaska_CS83_2",
            "Proj_Alaska_CS83_3", "Proj_Alaska_CS83_4", "Proj_Alaska_CS83_5",
            "Proj_Alaska_CS83_6", "Proj_Alaska_CS83_7", "Proj_Alaska_CS83_8",
            "Proj_Alaska_CS83_9", "Proj_Alaska_CS83_10", "Proj_Hawaii_CS27_1",
            "Proj_Hawaii_CS27_2", "Proj_Hawaii_CS27_3", "Proj_Hawaii_CS27_4",
            "Proj_Hawaii_CS27_5", "Proj_Hawaii_CS83_1", "Proj_Hawaii_CS83_2",
            "Proj_Hawaii_CS83_3", "Proj_Hawaii_CS83_4", "Proj_Hawaii_CS83_5",
            "Proj_Puerto_Rico_CS27", "Proj_St_Croix",
            "Proj_Puerto_Rico_Virgin_Is", "Proj_BLM_14N_feet",
            "Proj_BLM_15N_feet", "Proj_BLM_16N_feet", "Proj_BLM_17N_feet",
            "Proj_Map_Grid_of_Australia_48", "Proj_Map_Grid_of_Australia_49",
            "Proj_Map_Grid_of_Australia_50", "Proj_Map_Grid_of_Australia_51",
            "Proj_Map_Grid_of_Australia_52", "Proj_Map_Grid_of_Australia_53",
            "Proj_Map_Grid_of_Australia_54", "Proj_Map_Grid_of_Australia_55",
            "Proj_Map_Grid_of_Australia_56", "Proj_Map_Grid_of_Australia_57",
            "Proj_Map_Grid_of_Australia_58", "Proj_Australian_Map_Grid_48",
            "Proj_Australian_Map_Grid_49", "Proj_Australian_Map_Grid_50",
            "Proj_Australian_Map_Grid_51", "Proj_Australian_Map_Grid_52",
            "Proj_Australian_Map_Grid_53", "Proj_Australian_Map_Grid_54",
            "Proj_Australian_Map_Grid_55", "Proj_Australian_Map_Grid_56",
            "Proj_Australian_Map_Grid_57", "Proj_Australian_Map_Grid_58",
            "Proj_Argentina_1", "Proj_Argentina_2", "Proj_Argentina_3",
            "Proj_Argentina_4", "Proj_Argentina_5", "Proj_Argentina_6",
            "Proj_Argentina_7", "Proj_Colombia_3W", "Proj_Colombia_Bogota",
            "Proj_Colombia_3E", "Proj_Colombia_6E", "Proj_Egypt_Red_Belt",
            "Proj_Egypt_Purple_Belt", "Proj_Extended_Purple_Belt",
            "Proj_New_Zealand_North_Island_Nat_Grid",
            "Proj_New_Zealand_South_Island_Nat_Grid", "Proj_Bahrain_Grid",
            "Proj_Netherlands_E_Indies_Equatorial", "Proj_RSO_Borneo"
        };

        /**
         * _more_
         *
         * @param value _more_
         *
         * @return _more_
         */
        public static String getName(int value) {
            for (int i = 0; i < values.length; i++) {
                if (values[i] == value) {
                    return names[i];
                }
            }
            return null;
        }
    }



    /**
     *  @author IDV development team
     */

    public static class EpsgUnit {

        /** _more_          */
        public static final int Meter = 9001;

        /** _more_          */
        public static final int Foot = 9002;

        /** _more_          */
        public static final int Foot_US_Survey = 9003;

        /** _more_          */
        public static final int Foot_Modified_American = 9004;

        /** _more_          */
        public static final int Foot_Clarke = 9005;

        /** _more_          */
        public static final int Foot_Indian = 9006;

        /** _more_          */
        public static final int Link = 9007;

        /** _more_          */
        public static final int Link_Benoit = 9008;

        /** _more_          */
        public static final int Link_Sears = 9009;

        /** _more_          */
        public static final int Chain_Benoit = 9010;

        /** _more_          */
        public static final int Chain_Sears = 9011;

        /** _more_          */
        public static final int Yard_Sears = 9012;

        /** _more_          */
        public static final int Yard_Indian = 9013;

        /** _more_          */
        public static final int Fathom = 9014;

        /** _more_          */
        public static final int Mile_International_Nautical = 9015;

        /** _more_          */
        public static final int Radian = 9101;

        /** _more_          */
        public static final int Degree = 9102;

        /** _more_          */
        public static final int Arc_Minute = 9103;

        /** _more_          */
        public static final int Arc_Second = 9104;

        /** _more_          */
        public static final int Grad = 9105;

        /** _more_          */
        public static final int Gon = 9106;

        /** _more_          */
        public static final int DMS = 9107;

        /** _more_          */
        public static final int DMS_Hemisphere = 9108;


        /** _more_          */
        public static final int values[] = {
            Meter, Foot, Foot_US_Survey, Foot_Modified_American, Foot_Clarke,
            Foot_Indian, Link, Link_Benoit, Link_Sears, Chain_Benoit,
            Chain_Sears, Yard_Sears, Yard_Indian, Fathom,
            Mile_International_Nautical, Radian, Degree, Arc_Minute,
            Arc_Second, Grad, Gon, DMS, DMS_Hemisphere
        };

        /** _more_          */
        public static final String names[] = {
            "Linear_Meter", "Linear_Foot", "Linear_Foot_US_Survey",
            "Linear_Foot_Modified_American", "Linear_Foot_Clarke",
            "Linear_Foot_Indian", "Linear_Link", "Linear_Link_Benoit",
            "Linear_Link_Sears", "Linear_Chain_Benoit", "Linear_Chain_Sears",
            "Linear_Yard_Sears", "Linear_Yard_Indian", "Linear_Fathom",
            "Linear_Mile_International_Nautical", "Angular_Radian",
            "Angular_Degree", "Angular_Arc_Minute", "Angular_Arc_Second",
            "Angular_Grad", "Angular_Gon", "Angular_DMS",
            "Angular_DMS_Hemisphere"
        };

        /**
         * _more_
         *
         * @param value _more_
         *
         * @return _more_
         */
        public static String getName(int value) {
            for (int i = 0; i < values.length; i++) {
                if (values[i] == value) {
                    return names[i];
                }
            }
            return null;
        }
    }



    /**
     *  @author IDV development team
     */

    public static class EpsgVertcs {

        /** _more_          */
        public static final int Airy_1830_ellipsoid = 5001;

        /** _more_          */
        public static final int Airy_Modified_1849_ellipsoid = 5002;

        /** _more_          */
        public static final int ANS_ellipsoid = 5003;

        /** _more_          */
        public static final int Bessel_1841_ellipsoid = 5004;

        /** _more_          */
        public static final int Bessel_Modified_ellipsoid = 5005;

        /** _more_          */
        public static final int Bessel_Namibia_ellipsoid = 5006;

        /** _more_          */
        public static final int Clarke_1858_ellipsoid = 5007;

        /** _more_          */
        public static final int Clarke_1866_ellipsoid = 5008;

        /** _more_          */
        public static final int Clarke_1880_Benoit_ellipsoid = 5010;

        /** _more_          */
        public static final int Clarke_1880_IGN_ellipsoid = 5011;

        /** _more_          */
        public static final int Clarke_1880_RGS_ellipsoid = 5012;

        /** _more_          */
        public static final int Clarke_1880_Arc_ellipsoid = 5013;

        /** _more_          */
        public static final int Clarke_1880_SGA_1922_ellipsoid = 5014;

        /** _more_          */
        public static final int Everest_1830_1937_Adjustment_ellipsoid = 5015;

        /** _more_          */
        public static final int Everest_1830_1967_Definition_ellipsoid = 5016;

        /** _more_          */
        public static final int Everest_1830_1975_Definition_ellipsoid = 5017;

        /** _more_          */
        public static final int Everest_1830_Modified_ellipsoid = 5018;

        /** _more_          */
        public static final int GRS_1980_ellipsoid = 5019;

        /** _more_          */
        public static final int Helmert_1906_ellipsoid = 5020;

        /** _more_          */
        public static final int INS_ellipsoid = 5021;

        /** _more_          */
        public static final int International_1924_ellipsoid = 5022;

        /** _more_          */
        public static final int International_1967_ellipsoid = 5023;

        /** _more_          */
        public static final int Krassowsky_1940_ellipsoid = 5024;

        /** _more_          */
        public static final int NWL_9D_ellipsoid = 5025;

        /** _more_          */
        public static final int NWL_10D_ellipsoid = 5026;

        /** _more_          */
        public static final int Plessis_1817_ellipsoid = 5027;

        /** _more_          */
        public static final int Struve_1860_ellipsoid = 5028;

        /** _more_          */
        public static final int War_Office_ellipsoid = 5029;

        /** _more_          */
        public static final int WGS_84_ellipsoid = 5030;

        /** _more_          */
        public static final int GEM_10C_ellipsoid = 5031;

        /** _more_          */
        public static final int OSU86F_ellipsoid = 5032;

        /** _more_          */
        public static final int OSU91A_ellipsoid = 5033;

        /** _more_          */
        public static final int Newlyn = 5101;

        /** _more_          */
        public static final int North_American_Vertical_Datum_1929 = 5102;

        /** _more_          */
        public static final int North_American_Vertical_Datum_1988 = 5103;

        /** _more_          */
        public static final int Yellow_Sea_1956 = 5104;

        /** _more_          */
        public static final int Baltic_Sea = 5105;

        /** _more_          */
        public static final int Caspian_Sea = 5106;


        /** _more_          */
        public static final int values[] = {
            Airy_1830_ellipsoid, Airy_Modified_1849_ellipsoid, ANS_ellipsoid,
            Bessel_1841_ellipsoid, Bessel_Modified_ellipsoid,
            Bessel_Namibia_ellipsoid, Clarke_1858_ellipsoid,
            Clarke_1866_ellipsoid, Clarke_1880_Benoit_ellipsoid,
            Clarke_1880_IGN_ellipsoid, Clarke_1880_RGS_ellipsoid,
            Clarke_1880_Arc_ellipsoid, Clarke_1880_SGA_1922_ellipsoid,
            Everest_1830_1937_Adjustment_ellipsoid,
            Everest_1830_1967_Definition_ellipsoid,
            Everest_1830_1975_Definition_ellipsoid,
            Everest_1830_Modified_ellipsoid, GRS_1980_ellipsoid,
            Helmert_1906_ellipsoid, INS_ellipsoid,
            International_1924_ellipsoid, International_1967_ellipsoid,
            Krassowsky_1940_ellipsoid, NWL_9D_ellipsoid, NWL_10D_ellipsoid,
            Plessis_1817_ellipsoid, Struve_1860_ellipsoid,
            War_Office_ellipsoid, WGS_84_ellipsoid, GEM_10C_ellipsoid,
            OSU86F_ellipsoid, OSU91A_ellipsoid, Newlyn,
            North_American_Vertical_Datum_1929,
            North_American_Vertical_Datum_1988, Yellow_Sea_1956, Baltic_Sea,
            Caspian_Sea
        };

        /** _more_          */
        public static final String names[] = {
            "VertCS_Airy_1830_ellipsoid",
            "VertCS_Airy_Modified_1849_ellipsoid", "VertCS_ANS_ellipsoid",
            "VertCS_Bessel_1841_ellipsoid",
            "VertCS_Bessel_Modified_ellipsoid",
            "VertCS_Bessel_Namibia_ellipsoid", "VertCS_Clarke_1858_ellipsoid",
            "VertCS_Clarke_1866_ellipsoid",
            "VertCS_Clarke_1880_Benoit_ellipsoid",
            "VertCS_Clarke_1880_IGN_ellipsoid",
            "VertCS_Clarke_1880_RGS_ellipsoid",
            "VertCS_Clarke_1880_Arc_ellipsoid",
            "VertCS_Clarke_1880_SGA_1922_ellipsoid",
            "VertCS_Everest_1830_1937_Adjustment_ellipsoid",
            "VertCS_Everest_1830_1967_Definition_ellipsoid",
            "VertCS_Everest_1830_1975_Definition_ellipsoid",
            "VertCS_Everest_1830_Modified_ellipsoid",
            "VertCS_GRS_1980_ellipsoid", "VertCS_Helmert_1906_ellipsoid",
            "VertCS_INS_ellipsoid", "VertCS_International_1924_ellipsoid",
            "VertCS_International_1967_ellipsoid",
            "VertCS_Krassowsky_1940_ellipsoid", "VertCS_NWL_9D_ellipsoid",
            "VertCS_NWL_10D_ellipsoid", "VertCS_Plessis_1817_ellipsoid",
            "VertCS_Struve_1860_ellipsoid", "VertCS_War_Office_ellipsoid",
            "VertCS_WGS_84_ellipsoid", "VertCS_GEM_10C_ellipsoid",
            "VertCS_OSU86F_ellipsoid", "VertCS_OSU91A_ellipsoid",
            "VertCS_Newlyn", "VertCS_North_American_Vertical_Datum_1929",
            "VertCS_North_American_Vertical_Datum_1988",
            "VertCS_Yellow_Sea_1956", "VertCS_Baltic_Sea",
            "VertCS_Caspian_Sea"
        };

        /**
         * _more_
         *
         * @param value _more_
         *
         * @return _more_
         */
        public static String getName(int value) {
            for (int i = 0; i < values.length; i++) {
                if (values[i] == value) {
                    return names[i];
                }
            }
            return null;
        }
    }



    /**
     *  @author IDV development team
     */

    public static class GeoCtrans {

        /** _more_          */
        public static final int TransverseMercator = 1;

        /** _more_          */
        public static final int TransvMercator_Modified_Alaska = 2;

        /** _more_          */
        public static final int ObliqueMercator = 3;

        /** _more_          */
        public static final int ObliqueMercator_Laborde = 4;

        /** _more_          */
        public static final int ObliqueMercator_Rosenmund = 5;

        /** _more_          */
        public static final int ObliqueMercator_Spherical = 6;

        /** _more_          */
        public static final int Mercator = 7;

        /** _more_          */
        public static final int LambertConfConic_2SP = 8;

        /** _more_          */
        public static final int LambertConfConic = 8;

        /** _more_          */
        public static final int LambertConfConic_1SP = 9;

        /** _more_          */
        public static final int LambertConfConic_Helmert = 9;

        /** _more_          */
        public static final int LambertAzimEqualArea = 10;

        /** _more_          */
        public static final int AlbersEqualArea = 11;

        /** _more_          */
        public static final int AzimuthalEquidistant = 12;

        /** _more_          */
        public static final int EquidistantConic = 13;

        /** _more_          */
        public static final int Stereographic = 14;

        /** _more_          */
        public static final int PolarStereographic = 15;

        /** _more_          */
        public static final int ObliqueStereographic = 16;

        /** _more_          */
        public static final int Equirectangular = 17;

        /** _more_          */
        public static final int CassiniSoldner = 18;

        /** _more_          */
        public static final int Gnomonic = 19;

        /** _more_          */
        public static final int MillerCylindrical = 20;

        /** _more_          */
        public static final int Orthographic = 21;

        /** _more_          */
        public static final int Polyconic = 22;

        /** _more_          */
        public static final int Robinson = 23;

        /** _more_          */
        public static final int Sinusoidal = 24;

        /** _more_          */
        public static final int VanDerGrinten = 25;

        /** _more_          */
        public static final int NewZealandMapGrid = 26;

        /** _more_          */
        public static final int TransvMercator_SouthOriented = 27;

        /** _more_          */
        public static final int SouthOrientedGaussConformal = 27;

        /** _more_          */
        public static final int AlaskaConformal = 2;

        /** _more_          */
        public static final int TransvEquidistCylindrical = 18;

        /** _more_          */
        public static final int ObliqueMercator_Hotine = 3;

        /** _more_          */
        public static final int SwissObliqueCylindrical = 5;

        /** _more_          */
        public static final int GaussBoaga = 1;

        /** _more_          */
        public static final int GaussKruger = 1;


        /** _more_          */
        public static final int values[] = {
            TransverseMercator, TransvMercator_Modified_Alaska,
            ObliqueMercator, ObliqueMercator_Laborde,
            ObliqueMercator_Rosenmund, ObliqueMercator_Spherical, Mercator,
            LambertConfConic_2SP, LambertConfConic, LambertConfConic_1SP,
            LambertConfConic_Helmert, LambertAzimEqualArea, AlbersEqualArea,
            AzimuthalEquidistant, EquidistantConic, Stereographic,
            PolarStereographic, ObliqueStereographic, Equirectangular,
            CassiniSoldner, Gnomonic, MillerCylindrical, Orthographic,
            Polyconic, Robinson, Sinusoidal, VanDerGrinten, NewZealandMapGrid,
            TransvMercator_SouthOriented, SouthOrientedGaussConformal,
            AlaskaConformal, TransvEquidistCylindrical,
            ObliqueMercator_Hotine, SwissObliqueCylindrical, GaussBoaga,
            GaussKruger
        };

        /** _more_          */
        public static final String names[] = {
            "CT_TransverseMercator", "CT_TransvMercator_Modified_Alaska",
            "CT_ObliqueMercator", "CT_ObliqueMercator_Laborde",
            "CT_ObliqueMercator_Rosenmund", "CT_ObliqueMercator_Spherical",
            "CT_Mercator", "CT_LambertConfConic_2SP", "CT_LambertConfConic",
            "CT_LambertConfConic_1SP", "CT_LambertConfConic_Helmert",
            "CT_LambertAzimEqualArea", "CT_AlbersEqualArea",
            "CT_AzimuthalEquidistant", "CT_EquidistantConic",
            "CT_Stereographic", "CT_PolarStereographic",
            "CT_ObliqueStereographic", "CT_Equirectangular",
            "CT_CassiniSoldner", "CT_Gnomonic", "CT_MillerCylindrical",
            "CT_Orthographic", "CT_Polyconic", "CT_Robinson", "CT_Sinusoidal",
            "CT_VanDerGrinten", "CT_NewZealandMapGrid",
            "CT_TransvMercator_SouthOriented",
            "CT_SouthOrientedGaussConformal", "CT_AlaskaConformal",
            "CT_TransvEquidistCylindrical", "CT_ObliqueMercator_Hotine",
            "CT_SwissObliqueCylindrical", "CT_GaussBoaga", "CT_GaussKruger"
        };

        /**
         * _more_
         *
         * @param value _more_
         *
         * @return _more_
         */
        public static String getName(int value) {
            for (int i = 0; i < values.length; i++) {
                if (values[i] == value) {
                    return names[i];
                }
            }
            return null;
        }
    }



    /**
     *  @author IDV development team
     */

    public static class Geokey {

        /** _more_          */
        public static final int GTModelTypeGeoKey = 1024;

        /** _more_          */
        public static final int GTRasterTypeGeoKey = 1025;

        /** _more_          */
        public static final int GTCitationGeoKey = 1026;

        /** _more_          */
        public static final int GeographicTypeGeoKey = 2048;

        /** _more_          */
        public static final int GeogCitationGeoKey = 2049;

        /** _more_          */
        public static final int GeogGeodeticDatumGeoKey = 2050;

        /** _more_          */
        public static final int GeogPrimeMeridianGeoKey = 2051;

        /** _more_          */
        public static final int GeogLinearUnitsGeoKey = 2052;

        /** _more_          */
        public static final int GeogLinearUnitSizeGeoKey = 2053;

        /** _more_          */
        public static final int GeogAngularUnitsGeoKey = 2054;

        /** _more_          */
        public static final int GeogAngularUnitSizeGeoKey = 2055;

        /** _more_          */
        public static final int GeogEllipsoidGeoKey = 2056;

        /** _more_          */
        public static final int GeogSemiMajorAxisGeoKey = 2057;

        /** _more_          */
        public static final int GeogSemiMinorAxisGeoKey = 2058;

        /** _more_          */
        public static final int GeogInvFlatteningGeoKey = 2059;

        /** _more_          */
        public static final int GeogAzimuthUnitsGeoKey = 2060;

        /** _more_          */
        public static final int GeogPrimeMeridianLongGeoKey = 2061;

        /** _more_          */
        public static final int ProjectedCSTypeGeoKey = 3072;

        /** _more_          */
        public static final int PCSCitationGeoKey = 3073;

        /** _more_          */
        public static final int ProjectionGeoKey = 3074;

        /** _more_          */
        public static final int ProjCoordTransGeoKey = 3075;

        /** _more_          */
        public static final int ProjLinearUnitsGeoKey = 3076;

        /** _more_          */
        public static final int ProjLinearUnitSizeGeoKey = 3077;

        /** _more_          */
        public static final int ProjStdParallel1GeoKey = 3078;

        /** _more_          */
        public static final int ProjStdParallelGeoKey = 3078;

        /** _more_          */
        public static final int ProjStdParallel2GeoKey = 3079;

        /** _more_          */
        public static final int ProjNatOriginLongGeoKey = 3080;

        /** _more_          */
        public static final int ProjOriginLongGeoKey = 3080;

        /** _more_          */
        public static final int ProjNatOriginLatGeoKey = 3081;

        /** _more_          */
        public static final int ProjOriginLatGeoKey = 3081;

        /** _more_          */
        public static final int ProjFalseEastingGeoKey = 3082;

        /** _more_          */
        public static final int ProjFalseNorthingGeoKey = 3083;

        /** _more_          */
        public static final int ProjFalseOriginLongGeoKey = 3084;

        /** _more_          */
        public static final int ProjFalseOriginLatGeoKey = 3085;

        /** _more_          */
        public static final int ProjFalseOriginEastingGeoKey = 3086;

        /** _more_          */
        public static final int ProjFalseOriginNorthingGeoKey = 3087;

        /** _more_          */
        public static final int ProjCenterLongGeoKey = 3088;

        /** _more_          */
        public static final int ProjCenterLatGeoKey = 3089;

        /** _more_          */
        public static final int ProjCenterEastingGeoKey = 3090;

        /** _more_          */
        public static final int ProjCenterNorthingGeoKey = 3091;

        /** _more_          */
        public static final int ProjScaleAtNatOriginGeoKey = 3092;

        /** _more_          */
        public static final int ProjScaleAtOriginGeoKey = 3092;

        /** _more_          */
        public static final int ProjScaleAtCenterGeoKey = 3093;

        /** _more_          */
        public static final int ProjAzimuthAngleGeoKey = 3094;

        /** _more_          */
        public static final int ProjStraightVertPoleLongGeoKey = 3095;

        /** _more_          */
        public static final int VerticalCSTypeGeoKey = 4096;

        /** _more_          */
        public static final int VerticalCitationGeoKey = 4097;

        /** _more_          */
        public static final int VerticalDatumGeoKey = 4098;

        /** _more_          */
        public static final int VerticalUnitsGeoKey = 4099;


        /** _more_          */
        public static final int values[] = {
            GTModelTypeGeoKey, GTRasterTypeGeoKey, GTCitationGeoKey,
            GeographicTypeGeoKey, GeogCitationGeoKey, GeogGeodeticDatumGeoKey,
            GeogPrimeMeridianGeoKey, GeogLinearUnitsGeoKey,
            GeogLinearUnitSizeGeoKey, GeogAngularUnitsGeoKey,
            GeogAngularUnitSizeGeoKey, GeogEllipsoidGeoKey,
            GeogSemiMajorAxisGeoKey, GeogSemiMinorAxisGeoKey,
            GeogInvFlatteningGeoKey, GeogAzimuthUnitsGeoKey,
            GeogPrimeMeridianLongGeoKey, ProjectedCSTypeGeoKey,
            PCSCitationGeoKey, ProjectionGeoKey, ProjCoordTransGeoKey,
            ProjLinearUnitsGeoKey, ProjLinearUnitSizeGeoKey,
            ProjStdParallel1GeoKey, ProjStdParallelGeoKey,
            ProjStdParallel2GeoKey, ProjNatOriginLongGeoKey,
            ProjOriginLongGeoKey, ProjNatOriginLatGeoKey, ProjOriginLatGeoKey,
            ProjFalseEastingGeoKey, ProjFalseNorthingGeoKey,
            ProjFalseOriginLongGeoKey, ProjFalseOriginLatGeoKey,
            ProjFalseOriginEastingGeoKey, ProjFalseOriginNorthingGeoKey,
            ProjCenterLongGeoKey, ProjCenterLatGeoKey,
            ProjCenterEastingGeoKey, ProjCenterNorthingGeoKey,
            ProjScaleAtNatOriginGeoKey, ProjScaleAtOriginGeoKey,
            ProjScaleAtCenterGeoKey, ProjAzimuthAngleGeoKey,
            ProjStraightVertPoleLongGeoKey, VerticalCSTypeGeoKey,
            VerticalCitationGeoKey, VerticalDatumGeoKey, VerticalUnitsGeoKey
        };

        /** _more_          */
        public static final String names[] = {
            "GTModelTypeGeoKey", "GTRasterTypeGeoKey", "GTCitationGeoKey",
            "GeographicTypeGeoKey", "GeogCitationGeoKey",
            "GeogGeodeticDatumGeoKey", "GeogPrimeMeridianGeoKey",
            "GeogLinearUnitsGeoKey", "GeogLinearUnitSizeGeoKey",
            "GeogAngularUnitsGeoKey", "GeogAngularUnitSizeGeoKey",
            "GeogEllipsoidGeoKey", "GeogSemiMajorAxisGeoKey",
            "GeogSemiMinorAxisGeoKey", "GeogInvFlatteningGeoKey",
            "GeogAzimuthUnitsGeoKey", "GeogPrimeMeridianLongGeoKey",
            "ProjectedCSTypeGeoKey", "PCSCitationGeoKey", "ProjectionGeoKey",
            "ProjCoordTransGeoKey", "ProjLinearUnitsGeoKey",
            "ProjLinearUnitSizeGeoKey", "ProjStdParallel1GeoKey",
            "ProjStdParallelGeoKey", "ProjStdParallel2GeoKey",
            "ProjNatOriginLongGeoKey", "ProjOriginLongGeoKey",
            "ProjNatOriginLatGeoKey", "ProjOriginLatGeoKey",
            "ProjFalseEastingGeoKey", "ProjFalseNorthingGeoKey",
            "ProjFalseOriginLongGeoKey", "ProjFalseOriginLatGeoKey",
            "ProjFalseOriginEastingGeoKey", "ProjFalseOriginNorthingGeoKey",
            "ProjCenterLongGeoKey", "ProjCenterLatGeoKey",
            "ProjCenterEastingGeoKey", "ProjCenterNorthingGeoKey",
            "ProjScaleAtNatOriginGeoKey", "ProjScaleAtOriginGeoKey",
            "ProjScaleAtCenterGeoKey", "ProjAzimuthAngleGeoKey",
            "ProjStraightVertPoleLongGeoKey", "VerticalCSTypeGeoKey",
            "VerticalCitationGeoKey", "VerticalDatumGeoKey",
            "VerticalUnitsGeoKey"
        };

        /**
         * _more_
         *
         * @param value _more_
         *
         * @return _more_
         */
        public static String getName(int value) {
            for (int i = 0; i < values.length; i++) {
                if (values[i] == value) {
                    return names[i];
                }
            }
            return null;
        }
    }



    /**
     *  @author IDV development team
     */

    public static class ModelType {

        /** _more_          */
        public static final int Projected = 1;

        /** _more_          */
        public static final int Geographic = 2;

        /** _more_          */
        public static final int Geocentric = 3;

        /** _more_          */
        public static final int Undefined = 0;

        /** _more_          */
        public static final int UserDefined = 32767;


        /** _more_          */
        public static final int values[] = { Projected, Geographic,
                                             Geocentric, Undefined,
                                             UserDefined };

        /** _more_          */
        public static final String names[] = { "Projected", "Geographic",
                                               "Geocentric", "Undefined",
                                               "UserDefined" };

        /**
         * _more_
         *
         * @param value _more_
         *
         * @return _more_
         */
        public static String getName(int value) {
            for (int i = 0; i < values.length; i++) {
                if (values[i] == value) {
                    return names[i];
                }
            }
            return null;
        }
    }



}


