/**
 * $Id: ExceptionLogger.java,v 1.90 2005/09/14 09:31:06 oxelson Exp $
 *
 * Copyright 1997-2005 Unidata Program Center/University Corporation for
 * Atmospheric Research, P.O. Box 3000, Boulder, CO 80307,
 * support@unidata.ucar.edu.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or (at
 * your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */


package ucar.unidata.plaza.error;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;

public class ExceptionLogger {

    /**
     * Logs any native exceptions to the tomcat logs dir with stack trace 
     *
     * @param message - is a String that contains the message describing the error that is to be logged
     * @param ip - is a String that contains the remote user's IP address
     */
    public void logException (String message, String ip) throws IOException {
       String logPath = "/opt/tomcat/logs";
       Date d = new Date();
       FileWriter eLog = new FileWriter(new File(logPath, "ROOT_exception.log"), true);
       eLog.write(ip  + " - " + DateFormat.getDateInstance().format(d) + " " + DateFormat.getTimeInstance().format(d) + " " + message);
       eLog.close();
    }


    /**
     * Gets the stack trace for logging exceptions 
     *
     * @param t - is the throwable error
     */
    public static String getStackTrace (Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw, true);
        t.printStackTrace(pw);
        pw.flush();
        sw.flush();
        return sw.toString();
    } 

}
