/* 
 * Copyright (C) ITC 2005 - International Institute for Geo-Information Science and Earth Observation
 * 
 * Author: Jan Hendrikse 
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or (at
 * your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
*/
package org.itc.idv.math;

import Jama.Matrix;

@SuppressWarnings("serial")
public class ColumnVector extends Matrix {
    
    public ColumnVector(Matrix mat) {
        this(mat.getRowDimension());
        for (int i = 0; i < getRowDimension(); i++) {
            set(i, mat.get(i, 0));
        }
    }
    
    public ColumnVector(double[] V, int n) {
        this(n);
        for (int i = 0; i < n; i++) {
            set(i, V[i]);
        }
    }

    public ColumnVector(int n) {
        super(n, 1);
    }
    
    public double get(int i) {
        return get(i, 0);
    }
    
    public void set(int i, double val) {
        set(i, 0, val);
    }
    
    public double dotProduct(ColumnVector ColVec) {
        return transpose().times(ColVec).get(0, 0);
    }
    
    public double length() {
        return Math.sqrt(dotProduct(this));
    }
}
