/* 
 * Copyright (C) ITC 2005 - International Institute for Geo-Information Science and Earth Observation
 *    
 * Author: Willem Nieuwenhuis
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or (at
 * your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 */
package org.itc.idv.math;

/**
 * <p>
 * List of algorithms with the same signature
 * </p>
 * <p>
 * Concept discussed between Jan Hendrikse, Willem Nieuwenhuis and Wim Koolhoven on 23-08-05.
 * </p>
 * @author Wim Koolhoven
 */
public interface AlgorithmOnList extends AlgorithmN {

    /**
     * @return the number of parameters. This is the maximum of all the algorithms
     */
    int getNrParams();
    /**
     * returns the Name of the parameter. 
     * All {@link Algorithm}s are supposed to use the same names 
     * @param paramNr starts counting at 0
     * @return the Name of parameter {@code paramNr}
     * @throws IndexOutOfBoundsException when {@code paramNr} is negative or larger or equal to {#getNrParams()}
     */
    String getParamName(int paramNr) throws IndexOutOfBoundsException;
    /**
     * may return a Description of the parameter. Intended to give the end user more information.
     * All {@link Algorithm}s are supposed to use the same description 
     * @param paramNr starts counting at 0
     * @return the Name of parameter {@code paramNr}
     * @throws IndexOutOfBoundsException when {@code paramNr} is negative or larger or equal to {#getNrParams()}
     */
    String getParamDescription(int paramNr) throws IndexOutOfBoundsException;
    /**
     * @return the number of {@link Algorithm}s
     */
    int getNrAlgorithms();
    /**
     * returns the requested Algorithm
     * @param index
     * @return the Algorithm
     */
    Algorithm getAlgorithm(int index);
}
