/* 
 * Copyright (C) ITC 2005 - International Institute for Geo-Information Science and Earth Observation
 *    
 * Author: Willem Nieuwenhuis 
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or (at
 * your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 */
package org.itc.idv.math;

/**
 * <p>
 * Describe a list of algorithms using the params as inputs and returning a list of doubles
 * </p>
 * @author Willem Nieuwenhuis
 */
public interface AlgorithmN {

	/**
	 * Calculates the results of the AlgorithmN for the values in params.
	 * @return the result
	 * @throws RuntimeException 
	 */
	double[] calculate(double[] params);

}