/* 
 * Copyright (C) ITC 2005 - International Institute for Geo-Information Science and Earth Observation
 * 
 * Author: Wim Koolhoven 
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or (at
 * your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
*/
package org.itc.idv.math;

/**
 * Convenience class to implement {@link Algorithm}.
 *
 * @author Wim Koolhoven
 */
public abstract class AbstractAlgorithm implements Algorithm {

    private final String name;
    private final String description;
    private final String[] paramNames;
    private final String[] paramDescr;

    /**
     * To set name and description.
     * @param name the Algorithm name, to be returned by {@link #getName}
     * @param description the Algorithm description, to be returned by {@link #getDescription}
     */
    protected AbstractAlgorithm(final String name, 
            final String description) {
        this(name, description, null, null);
    }
    
    /**
     * To specify name, description, param names and descriptions.
     * {@link #getNrParams} is based on {@code paramNames}. 
     * @param name the Algorithm name, to be returned by {@link #getName}
     * @param description the Algorithm description, to be returned by {@link #getDescription}
     * @param paramNames the parameter Names, to be returned by {@link #getParamName}
     * @param paramDescr the paramerer Descriptions, to be returned by {@link #getParamDescription}
     */
    protected AbstractAlgorithm(final String name, 
            final String description,
            final String[] paramNames,
            final String[] paramDescr) {
        this.name = name;
        this.description = description;
        this.paramNames = paramNames;
        this.paramDescr = paramDescr;
    }
    
    public String getName() {
        return name;
    }

    public String getDescription() {
        return description;
    }

    public String getDocURL() {
        return null;
    }

    public String getVersion() {
        return null;
    }
    
    public int getNrParams() {
        return paramNames.length;
    }

    public String getParamName(int paramNr) {
        return paramNames[paramNr];
    }

    public String getParamDescription(int paramNr) {
        return paramDescr[paramNr];
    }
}
