/*
 * Decompiled with CFR 0.152.
 */
package ucar.netcdf;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.util.Date;
import java.util.Random;

public class RandomAccessFile
implements DataInput,
DataOutput {
    public static final int READ = 1;
    public static final int WRITE = 2;
    public static final int CREATE = 4;
    protected static final int defaultBufferSize = 4096;
    protected java.io.RandomAccessFile file;
    protected long filePosition;
    protected byte[] buffer;
    protected long bufferStart;
    protected long dataEnd;
    protected int dataSize;
    protected boolean endOfFile;
    protected int mode;
    boolean bufferModified = false;

    protected RandomAccessFile(int bufferSize) {
        this.bufferStart = 0L;
        this.dataEnd = 0L;
        this.dataSize = 0;
        this.filePosition = 0L;
        this.buffer = new byte[bufferSize];
        this.endOfFile = false;
    }

    public RandomAccessFile(String filename, int mode) throws IOException {
        this(filename, mode, 4096);
    }

    public RandomAccessFile(String filename, String modeString) throws IOException {
        this(filename, modeString, 4096);
    }

    public RandomAccessFile(String filename, String modeString, int bufferSize) throws IOException {
        this(filename, modeString.equals("r") ? 1 : (modeString.equals("rw") ? 3 : 0), bufferSize);
    }

    public RandomAccessFile(File file, String modeString) throws IOException {
        this(file.getPath(), modeString);
    }

    public RandomAccessFile(String filename, int mode, int bufferSize) throws FileNotFoundException, IOException {
        this.mode = mode;
        mode |= 1;
        if ((this.mode & 4) > 0) {
            this.mode |= 2;
        }
        File checkfile = new File(filename);
        if ((this.mode & 2) > 0 && !checkfile.exists()) {
            mode |= 4;
        }
        if ((this.mode & 4) > 0 && checkfile.exists() && !checkfile.delete()) {
            throw new IOException("Failed to delete " + filename);
        }
        if (this.mode == 1 && !new File(filename).exists()) {
            throw new FileNotFoundException(filename);
        }
        String modeString = (this.mode & 2) > 0 ? "rw" : "r";
        this.file = new java.io.RandomAccessFile(filename, modeString);
        this.bufferStart = 0L;
        this.dataEnd = 0L;
        this.dataSize = 0;
        this.filePosition = 0L;
        this.buffer = new byte[bufferSize];
        this.endOfFile = false;
    }

    public void close() throws IOException {
        if ((this.mode | 2) > 0 && this.bufferModified) {
            this.file.seek(this.bufferStart);
            this.file.write(this.buffer, 0, this.dataSize);
        }
        this.file.close();
    }

    public void seek(long pos) throws IOException {
        if (pos >= this.bufferStart && pos < this.dataEnd) {
            this.filePosition = pos;
            return;
        }
        if (this.bufferModified) {
            this.flush();
        }
        this.bufferStart = pos;
        this.filePosition = pos;
        this.dataSize = this.read_(pos, this.buffer, 0, this.buffer.length);
        if (this.dataSize < 0) {
            this.dataSize = 0;
            this.endOfFile = true;
        } else {
            this.endOfFile = false;
        }
        this.dataEnd = this.bufferStart + (long)this.dataSize;
    }

    public long getFilePointer() throws IOException {
        return this.filePosition;
    }

    public long length() throws IOException {
        long fileLength = this.file.length();
        if (fileLength < this.dataEnd) {
            return this.dataEnd;
        }
        return fileLength;
    }

    public FileDescriptor getFD() throws IOException {
        return this.file.getFD();
    }

    public void flush() throws IOException {
        if (this.bufferModified) {
            this.file.seek(this.bufferStart);
            this.file.write(this.buffer, 0, this.dataSize);
            this.bufferModified = false;
        }
    }

    public final int read() throws IOException {
        if (this.filePosition < this.dataEnd) {
            return this.buffer[(int)(this.filePosition++ - this.bufferStart)] & 0xFF;
        }
        if (this.endOfFile) {
            return -1;
        }
        this.seek(this.filePosition);
        return this.read();
    }

    private int readBytes(byte[] b, int off, int len) throws IOException {
        if (this.endOfFile) {
            return -1;
        }
        int bytesAvailable = (int)(this.dataEnd - this.filePosition);
        if (bytesAvailable < 1) {
            this.seek(this.filePosition);
            return this.readBytes(b, off, len);
        }
        int copyLength = bytesAvailable >= len ? len : bytesAvailable;
        System.arraycopy(this.buffer, (int)(this.filePosition - this.bufferStart), b, off, copyLength);
        this.filePosition += (long)copyLength;
        if (copyLength < len) {
            int extraCopy = len - copyLength;
            if (extraCopy > this.buffer.length) {
                extraCopy = this.read_(this.filePosition, b, off + copyLength, len - copyLength);
            } else {
                this.seek(this.filePosition);
                if (!this.endOfFile) {
                    extraCopy = extraCopy > this.dataSize ? this.dataSize : extraCopy;
                    System.arraycopy(this.buffer, 0, b, off + copyLength, extraCopy);
                } else {
                    extraCopy = -1;
                }
            }
            if (extraCopy > 0) {
                this.filePosition += (long)extraCopy;
                return copyLength + extraCopy;
            }
        }
        return copyLength;
    }

    protected int read_(long pos, byte[] b, int offset, int len) throws IOException {
        this.file.seek(pos);
        int n = this.file.read(b, offset, len);
        return n;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.readBytes(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        return this.readBytes(b, 0, b.length);
    }

    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public final void readFully(byte[] b, int off, int len) throws IOException {
        int count;
        for (int n = 0; n < len; n += count) {
            count = this.read(b, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    public int skipBytes(int n) throws IOException {
        this.seek(this.getFilePointer() + (long)n);
        return n;
    }

    public final void unread() {
        --this.filePosition;
    }

    public final void write(int b) throws IOException {
        if (this.filePosition < this.dataEnd) {
            this.buffer[(int)(this.filePosition++ - this.bufferStart)] = (byte)b;
            this.bufferModified = true;
        } else if (this.dataSize != this.buffer.length) {
            this.buffer[(int)(this.filePosition++ - this.bufferStart)] = (byte)b;
            this.bufferModified = true;
            ++this.dataSize;
            ++this.dataEnd;
        } else {
            this.seek(this.filePosition);
            this.write(b);
        }
    }

    public final void writeBytes(byte[] b, int off, int len) throws IOException {
        if (len < this.buffer.length) {
            long myDataEnd;
            int spaceInBuffer = 0;
            int copyLength = 0;
            if (this.filePosition >= this.bufferStart) {
                spaceInBuffer = (int)(this.bufferStart + (long)this.buffer.length - this.filePosition);
            }
            if (spaceInBuffer > 0) {
                copyLength = spaceInBuffer > len ? len : spaceInBuffer;
                System.arraycopy(b, off, this.buffer, (int)(this.filePosition - this.bufferStart), copyLength);
                this.bufferModified = true;
                myDataEnd = this.filePosition + (long)copyLength;
                this.dataEnd = myDataEnd > this.dataEnd ? myDataEnd : this.dataEnd;
                this.dataSize = (int)(this.dataEnd - this.bufferStart);
                this.filePosition += (long)copyLength;
            }
            if (copyLength < len) {
                this.seek(this.filePosition);
                System.arraycopy(b, off + copyLength, this.buffer, (int)(this.filePosition - this.bufferStart), len - copyLength);
                this.bufferModified = true;
                myDataEnd = this.filePosition + (long)(len - copyLength);
                this.dataEnd = myDataEnd > this.dataEnd ? myDataEnd : this.dataEnd;
                this.dataSize = (int)(this.dataEnd - this.bufferStart);
                this.filePosition += (long)(len - copyLength);
            }
        } else {
            if (this.bufferModified) {
                this.flush();
                this.dataSize = 0;
                this.bufferStart = this.dataEnd = (long)0;
                this.file.seek(this.filePosition);
            }
            this.file.write(b, off, len);
            this.filePosition += (long)len;
        }
    }

    public void write(byte[] b) throws IOException {
        this.writeBytes(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.writeBytes(b, off, len);
    }

    public final boolean readBoolean() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    public final byte readByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    public final int readUnsignedByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    public final short readShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    public final int readUnsignedShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 8) + (ch2 << 0);
    }

    public final char readChar() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    public final int readInt() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read()) | (ch3 = this.read()) | (ch4 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public final long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final String readLine() throws IOException {
        int c;
        StringBuffer input = new StringBuffer();
        while ((c = this.read()) != -1 && c != 10) {
            input.append((char)c);
        }
        if (c == -1 && input.length() == 0) {
            return null;
        }
        return input.toString();
    }

    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public final void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    public final void writeByte(int v) throws IOException {
        this.write(v);
    }

    public final void writeShort(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public final void writeChar(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public final void writeInt(int v) throws IOException {
        this.write(v >>> 24 & 0xFF);
        this.write(v >>> 16 & 0xFF);
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public final void writeLong(long v) throws IOException {
        this.write((int)(v >>> 56) & 0xFF);
        this.write((int)(v >>> 48) & 0xFF);
        this.write((int)(v >>> 40) & 0xFF);
        this.write((int)(v >>> 32) & 0xFF);
        this.write((int)(v >>> 24) & 0xFF);
        this.write((int)(v >>> 16) & 0xFF);
        this.write((int)(v >>> 8) & 0xFF);
        this.write((int)(v >>> 0) & 0xFF);
    }

    public final void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public final void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public final void writeBytes(String s2) throws IOException {
        int len = s2.length();
        for (int i = 0; i < len; ++i) {
            this.write((byte)s2.charAt(i));
        }
    }

    public final void writeBytes(char[] b, int off, int len) throws IOException {
        for (int i = off; i < len; ++i) {
            this.write((byte)b[i]);
        }
    }

    public final void writeChars(String s2) throws IOException {
        int len = s2.length();
        for (int i = 0; i < len; ++i) {
            char v = s2.charAt(i);
            this.write(v >>> 8 & 0xFF);
            this.write(v >>> 0 & 0xFF);
        }
    }

    public final void writeUTF(String str) throws IOException {
        char c;
        int i;
        int strlen = str.length();
        int utflen = 0;
        for (i = 0; i < strlen; ++i) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException();
        }
        this.write(utflen >>> 8 & 0xFF);
        this.write(utflen >>> 0 & 0xFF);
        for (i = 0; i < strlen; ++i) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                this.write(c);
                continue;
            }
            if (c > '\u07ff') {
                this.write(0xE0 | c >> 12 & 0xF);
                this.write(0x80 | c >> 6 & 0x3F);
                this.write(0x80 | c >> 0 & 0x3F);
                continue;
            }
            this.write(0xC0 | c >> 6 & 0x1F);
            this.write(0x80 | c >> 0 & 0x3F);
        }
    }

    public String toString() {
        return "fp=" + this.filePosition + ", bs=" + this.bufferStart + ", de=" + this.dataEnd + ", ds=" + this.dataSize + ", bl=" + this.buffer.length + ", m=" + this.mode + ", bm=" + this.bufferModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testBytes(String filename, int bufferSize) {
        System.out.println("\nTesting byte operations...");
        int newFileSize = (int)((double)bufferSize * 4.5);
        try {
            RandomAccessFile outFile = new RandomAccessFile(filename, 6, bufferSize);
            try {
                Random random = new Random(0L);
                byte b = 0;
                for (int i = 0; i < newFileSize; ++i) {
                    b = (byte)(random.nextInt() % 256);
                    outFile.writeByte(b);
                }
            }
            finally {
                outFile.close();
            }
            if (new File(filename).length() == (long)newFileSize) {
                System.out.println(". File size correct (" + newFileSize + ").");
            } else {
                System.out.println("X New file size incorrect (should be " + newFileSize + ", but is " + new File(filename).length() + ").");
            }
            RandomAccessFile inoutFile = new RandomAccessFile(filename, 3, bufferSize);
            boolean verified = true;
            int byteNo = 0;
            try {
                Random random = new Random(0L);
                byte b = 0;
                for (byteNo = 0; byteNo < newFileSize; ++byteNo) {
                    b = (byte)(random.nextInt() % 256);
                    byte currentByte = inoutFile.readByte();
                    if (currentByte != b) {
                        verified = false;
                    }
                    if (currentByte < 128) continue;
                    inoutFile.seek(inoutFile.getFilePointer() - 1L);
                    inoutFile.writeByte(0);
                }
                boolean foundEOF = false;
                try {
                    inoutFile.readByte();
                }
                catch (EOFException e) {
                    foundEOF = true;
                }
                if (foundEOF) {
                    System.err.println(". EOF found correctly");
                } else {
                    System.err.println("X No EOF found.");
                }
            }
            catch (EOFException e) {
                e.printStackTrace();
                System.err.println("    At byte " + byteNo);
            }
            finally {
                inoutFile.close();
            }
            if (verified) {
                System.out.println(". Read/Write verified");
            } else {
                System.out.println("X Read/Write verification failed");
            }
            RandomAccessFile inFile = new RandomAccessFile(filename, 1, bufferSize);
            verified = true;
            byteNo = 0;
            try {
                Random random = new Random(0L);
                byte b = 0;
                for (byteNo = 0; byteNo < newFileSize; ++byteNo) {
                    b = (byte)(random.nextInt() % 256);
                    byte currentByte = inFile.readByte();
                    if (currentByte >= 128) {
                        currentByte = 0;
                    }
                    if (currentByte == b) continue;
                    verified = false;
                }
            }
            catch (EOFException e) {
                e.printStackTrace();
                System.err.println("    At byte " + byteNo);
            }
            finally {
                inFile.close();
            }
            if (verified) {
                System.out.println(". Update verified");
            } else {
                System.out.println("X Update verification failed");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void testBlocks(String filename) {
        System.err.println("\nTesting block operations...");
        int bufferSize = 10;
        byte[] data = new byte[256];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)(i % 256);
        }
        try {
            int j;
            int index;
            int i;
            int blockSize;
            RandomAccessFile outFile = new RandomAccessFile(filename, 6, bufferSize);
            for (int i2 = 0; i2 < data.length; i2 += blockSize) {
                blockSize = i2 < data.length / 2 ? 3 : 13;
                blockSize = i2 + blockSize >= data.length ? data.length - i2 : blockSize;
                outFile.write(data, i2, blockSize);
            }
            outFile.close();
            if (new File(filename).length() != (long)data.length) {
                System.out.println("X New file size incorrect (should be " + data.length + ", but is " + new File(filename).length() + ").");
            } else {
                System.out.println(". File size correct (" + data.length + ").");
            }
            RandomAccessFile inFile = new RandomAccessFile(filename, 1, bufferSize);
            boolean verified = true;
            int firstFailure = 256;
            Random random = new Random(0L);
            byte[] block = new byte[(int)((double)bufferSize * 0.5)];
            for (i = 0; i < 100; ++i) {
                index = Math.abs(random.nextInt()) % (data.length - block.length);
                inFile.seek(index);
                inFile.read(block);
                for (j = 0; j < block.length; ++j) {
                    if (block[j] == data[index + j]) continue;
                    verified = false;
                    if (index + j >= firstFailure) continue;
                    firstFailure = index + j;
                }
            }
            if (verified) {
                System.err.println(". Reading small blocks verified.");
            } else {
                System.err.println("X Reading small blocks failed (byte " + firstFailure + ").");
            }
            verified = true;
            random = new Random(0L);
            block = new byte[(int)((double)bufferSize * 1.5)];
            for (i = 0; i < 100; ++i) {
                index = Math.abs(random.nextInt()) % (data.length - block.length);
                inFile.seek(index);
                inFile.read(block);
                for (j = 0; j < block.length; ++j) {
                    if (block[j] == data[j + index]) continue;
                    verified = false;
                }
            }
            if (verified) {
                System.err.println(". Reading large blocks verified.");
            } else {
                System.err.println("X Reading large blocks failed.");
            }
            inFile.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void benchmark(String filename, int bufferSize) {
        System.out.println("\nBenchmarking...");
        long time = new Date().getTime();
        try {
            RandomAccessFile inFile = new RandomAccessFile(filename, 1, bufferSize);
            RandomAccessFile outFile = new RandomAccessFile("temp.data", 6, bufferSize);
            try {
                while (true) {
                    outFile.writeByte(inFile.readByte());
                }
            }
            catch (EOFException e) {
                inFile.close();
                outFile.close();
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    inFile.close();
                    outFile.close();
                }
            }
            System.out.println(". RandomAccessFile elapsed time=" + (new Date().getTime() - time));
            time = new Date().getTime();
            java.io.RandomAccessFile inFile2 = new java.io.RandomAccessFile(filename, "r");
            java.io.RandomAccessFile outFile2 = new java.io.RandomAccessFile("temp.data", "rw");
            try {
                while (true) {
                    outFile2.writeByte(inFile2.readByte());
                }
            }
            catch (EOFException e) {
                inFile2.close();
                outFile2.close();
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    inFile2.close();
                    outFile2.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(". java.io.RandomAccessFile elapsed time=" + (new Date().getTime() - time));
    }

    public static void main(String[] argv) {
        int defaultPageSize = 4096;
        String filename = null;
        int bufferSize = 0;
        boolean test = true;
        boolean benchmark = true;
        if (argv.length < 1) {
            System.err.println("Usage: RandomAccessFile <filename> [buffer.length] [benchmark | test]");
            System.exit(-1);
        } else if (argv.length < 2) {
            filename = argv[0];
            bufferSize = defaultPageSize;
        } else if (argv.length < 3) {
            filename = argv[0];
            bufferSize = Integer.parseInt(argv[1]);
        } else {
            filename = argv[0];
            bufferSize = Integer.parseInt(argv[1]);
            if (argv[2].equals("benchmark")) {
                test = false;
            } else if (argv[2].equals("test")) {
                benchmark = false;
            }
        }
        System.out.println("\nRandomAccessFile\n========================");
        System.out.println("filename=" + filename + ", bufferSize=" + bufferSize);
        System.out.println("totalMemory=" + Runtime.getRuntime().totalMemory() / 1000L + "k" + " freeMemory=" + Runtime.getRuntime().freeMemory() / 1000L + "k");
        if (test) {
            RandomAccessFile.testBytes("temp.data", bufferSize);
            RandomAccessFile.testBlocks("temp.data");
        }
        if (benchmark) {
            RandomAccessFile.benchmark(filename, bufferSize);
        }
        System.out.println("\nEND");
    }
}

