/*
 * Decompiled with CFR 0.152.
 */
package ucar.netcdf;

import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import ucar.netcdf.RandomAccessFile;

public class HTTPRandomAccessFile
extends RandomAccessFile {
    private long total_length = 0L;
    private HTTPConnection conn;
    private String path;
    private NVPair[] form = null;
    private NVPair[] header = new NVPair[2];

    public HTTPRandomAccessFile(URL url) throws IOException {
        this(url, 4096);
    }

    public HTTPRandomAccessFile(URL url, int bufferSize) throws IOException {
        super(bufferSize);
        this.file = null;
        this.path = url.getFile();
        this.conn = new HTTPConnection(url);
        try {
            HTTPResponse test = this.conn.Head(this.path);
            if (test.getStatusCode() == 404) {
                throw new FileNotFoundException(test.getReasonLine());
            }
            if (test.getStatusCode() >= 300) {
                throw new IOException(test.getReasonLine());
            }
            this.total_length = test.getHeaderAsInt("Content-Length");
        }
        catch (ModuleException me) {
            me.printStackTrace();
            throw new IOException();
        }
        this.header[0] = new NVPair("User-Agent", "HTTPnetCDF;");
    }

    protected int read_(long pos, byte[] buff, int off, int len) throws IOException {
        long end = pos + (long)len - 1L;
        if (end >= this.total_length) {
            end = this.total_length - 1L;
        }
        byte[] data = null;
        this.header[1] = new NVPair("Range", "bytes=" + pos + "-" + end);
        try {
            HTTPResponse res = this.conn.Get(this.path, this.form, this.header);
            if (res.getStatusCode() >= 300) {
                System.out.println(new String(res.getData()));
                throw new IOException(res.getReasonLine());
            }
            data = res.getData();
        }
        catch (ModuleException me) {
            me.printStackTrace();
            throw new IOException(me.getMessage());
        }
        int reslen = Math.min(len, data.length);
        System.arraycopy(data, 0, buff, off, reslen);
        return reslen;
    }

    public long length() throws IOException {
        long fileLength = this.total_length;
        if (fileLength < this.dataEnd) {
            return this.dataEnd;
        }
        return fileLength;
    }

    public void close() {
    }

    public FileDescriptor getFD() {
        return null;
    }
}

