/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2.table;

import com.google.common.base.MoreObjects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Grib2TablesId {
    public final int center;
    public final int subCenter;
    public final int masterVersion;
    public final int localVersion;
    public final int genProcessId;

    public Grib2TablesId(int center, int subCenter, int masterVersion, int localVersion, int genProcessId) {
        this.center = center;
        this.subCenter = subCenter;
        this.masterVersion = masterVersion;
        this.localVersion = localVersion;
        this.genProcessId = genProcessId;
    }

    boolean match(Grib2TablesId id) {
        if (id.center != this.center) {
            return false;
        }
        if (this.subCenter != -1 && id.subCenter != this.subCenter) {
            return false;
        }
        if (this.masterVersion != -1 && id.masterVersion != this.masterVersion) {
            return false;
        }
        if (this.localVersion != -1 && id.localVersion != this.localVersion) {
            return false;
        }
        return this.genProcessId == -1 || id.genProcessId == this.genProcessId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Grib2TablesId that = (Grib2TablesId)o;
        if (this.center != that.center) {
            return false;
        }
        if (this.genProcessId != that.genProcessId) {
            return false;
        }
        if (this.localVersion != that.localVersion) {
            return false;
        }
        if (this.masterVersion != that.masterVersion) {
            return false;
        }
        return this.subCenter == that.subCenter;
    }

    public int hashCode() {
        int result = this.center;
        result = 31 * result + this.subCenter;
        result = 31 * result + this.masterVersion;
        result = 31 * result + this.localVersion;
        result = 31 * result + this.genProcessId;
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("center", this.center).add("subCenter", this.subCenter).add("masterVersion", this.masterVersion).add("localVersion", this.localVersion).add("genProcessId", this.genProcessId).toString();
    }

    public static enum Type {
        wmo,
        cfsr,
        gempak,
        gsd,
        kma,
        ncep,
        ndfd,
        mrms,
        nwsDev,
        eccodes;

    }
}

