/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Formatter;
import java.util.zip.Deflater;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.DataType;
import ucar.nc2.grib.GribNumbers;

public class GribData {
    private static Logger logger = LoggerFactory.getLogger(GribData.class);
    private static InterpolationMethod useInterpolationMethod = InterpolationMethod.linear;

    public static InterpolationMethod getInterpolationMethod() {
        return useInterpolationMethod;
    }

    public static void setInterpolationMethod(InterpolationMethod interpolationMethod) {
        useInterpolationMethod = interpolationMethod;
    }

    public static void calcScaleOffset(Bean bean1, Formatter f) {
        float[] data;
        try {
            data = bean1.readData();
        }
        catch (IOException e) {
            f.format("IOException %s", e.getMessage());
            return;
        }
        int npoints = data.length;
        int nbits = bean1.getNBits();
        int width = (2 << nbits - 1) - 2;
        int missing_value = (2 << nbits - 1) - 1;
        f.format(" nbits = %d%n", nbits);
        f.format(" npoints = %d%n", npoints);
        f.format(" width = %d (0x%s) %n", width, Long.toHexString(width));
        f.format(" scale = %g %n", bean1.getScale());
        f.format(" resolution = %g %n", bean1.getScale() / 2.0);
        f.format(" range = %f %n%n", bean1.getMaximum() - bean1.getMinimum());
        float dataMin = Float.MAX_VALUE;
        float dataMax = -3.4028235E38f;
        for (float fd : data) {
            if (Float.isNaN(fd)) continue;
            dataMin = Math.min(dataMin, fd);
            dataMax = Math.max(dataMax, fd);
        }
        f.format("           actual    computed%n", new Object[0]);
        f.format(" dataMin = %8f %8f%n", Float.valueOf(dataMin), bean1.getMinimum());
        f.format(" dataMax = %8f %8f%n", Float.valueOf(dataMax), bean1.getMaximum());
        f.format(" actual range = %f%n", Float.valueOf(dataMax - dataMin));
        double scale_factor = (dataMax - dataMin) / (float)width;
        double add_offset = dataMin;
        f.format(" scale_factor = %g%n", scale_factor);
        f.format(" add_offset = %g%n", add_offset);
        ByteBuffer bb = ByteBuffer.allocate(4 * npoints);
        IntBuffer intBuffer = bb.asIntBuffer();
        double diffMax = -1.7976931348623157E308;
        double diffTotal = 0.0;
        double diffTotal2 = 0.0;
        for (float fd : data) {
            if (Float.isNaN(fd)) {
                intBuffer.put(missing_value);
                continue;
            }
            int packed_data = (int)Math.round(((double)fd - add_offset) / scale_factor);
            double unpacked_data = (double)packed_data * scale_factor + add_offset;
            double diff = Math.abs((double)fd - unpacked_data);
            if (diff > scale_factor / 2.0) {
                f.format("***   org=%g, packed_data=%d unpacked=%g diff = %g%n", Float.valueOf(fd), packed_data, unpacked_data, diff);
            }
            diffMax = Math.max(diffMax, diff);
            diffTotal += diff;
            diffTotal2 += diff * diff;
            intBuffer.put(packed_data);
        }
        f.format("%n max_diff = %g%n", diffMax);
        f.format(" avg_diff = %g%n", diffTotal / (double)data.length);
        double mean = diffTotal / (double)npoints;
        double var = diffTotal2 / (double)npoints - mean * mean;
        f.format(" std_diff = %g%n", Math.sqrt(var));
        f.format("%nCompression%n", new Object[0]);
        f.format(" number of values = %d%n", npoints);
        f.format(" uncompressed as floats = %d%n", npoints * 4);
        int packedBitsLen = npoints * nbits / 8;
        f.format(" uncompressed packed bits = %d%n", packedBitsLen);
        f.format(" grib data length = %d%n", bean1.getDataLength());
        f.format(" grib msg length = %d%n", bean1.getMsgLength());
        byte[] bdata = GribData.convertToBytes(data);
        byte[] scaledData = bb.array();
        f.format("%ndeflate (float)%n", new Object[0]);
        Deflater deflater = new Deflater();
        deflater.setInput(bdata);
        deflater.finish();
        int compressedSize = deflater.deflate(new byte[10 * npoints]);
        deflater.end();
        f.format(" compressedSize = %d%n", compressedSize);
        f.format(" ratio floats / size = %f%n", Float.valueOf((float)(npoints * 4) / (float)compressedSize));
        f.format(" ratio packed bits / size = %f%n", Float.valueOf((float)packedBitsLen / (float)compressedSize));
        f.format(" ratio size / grib = %f%n", Float.valueOf((float)compressedSize / (float)bean1.getMsgLength()));
        f.format("%ndeflate (scaled ints)%n", new Object[0]);
        deflater = new Deflater();
        deflater.setInput(scaledData);
        deflater.finish();
        compressedSize = deflater.deflate(new byte[10 * npoints]);
        deflater.end();
        f.format(" compressedSize = %d%n", compressedSize);
        f.format(" ratio floats / size = %f%n", Float.valueOf((float)(npoints * 4) / (float)compressedSize));
        f.format(" ratio packed bits / size = %f%n", Float.valueOf((float)packedBitsLen / (float)compressedSize));
        f.format(" ratio size / grib = %f%n", Float.valueOf((float)compressedSize / (float)bean1.getMsgLength()));
    }

    @Nullable
    public static byte[] compressScaled(Bean bean) throws IOException {
        float[] data = bean.readData();
        int npoints = data.length;
        int nbits = bean.getNBits();
        int width = (2 << nbits - 1) - 2;
        int missing_value = (2 << nbits - 1) - 1;
        float dataMin = Float.MAX_VALUE;
        float dataMax = -3.4028235E38f;
        for (float fd : data) {
            if (Float.isNaN(fd)) continue;
            dataMin = Math.min(dataMin, fd);
            dataMax = Math.max(dataMax, fd);
        }
        double scale_factor = (dataMax - dataMin) / (float)width;
        double add_offset = dataMin;
        ByteBuffer bb = ByteBuffer.allocate(4 * npoints + 24);
        bb.putDouble(scale_factor);
        bb.putDouble(add_offset);
        bb.putInt(nbits);
        bb.putInt(npoints);
        for (float fd : data) {
            if (Float.isNaN(fd)) {
                bb.putInt(missing_value);
                continue;
            }
            int packed_data = (int)Math.round(((double)fd - add_offset) / scale_factor);
            bb.putInt(packed_data);
        }
        return null;
    }

    public static float[] uncompressScaled(byte[] bdata) {
        throw new UnsupportedOperationException("bzip2 compression no longer supported.");
    }

    public static byte[] convertToBytes(float[] data) {
        ByteBuffer bb = ByteBuffer.allocate(data.length * 4);
        for (float val : data) {
            bb.putFloat(val);
        }
        return bb.array();
    }

    public static byte[] convertToBytes(int[] data) {
        ByteBuffer bb = ByteBuffer.allocate(data.length * 4);
        for (int val : data) {
            bb.putInt(val);
        }
        return bb.array();
    }

    public static double entropy(byte[] data) {
        int[] p = new int[256];
        for (byte b : data) {
            short s2;
            short s3 = s2 = DataType.unsignedByteToShort(b);
            p[s3] = p[s3] + 1;
        }
        double n = data.length;
        double iln2 = 1.0 / Math.log(2.0);
        double sum = 0.0;
        for (int i = 0; i < 256; ++i) {
            if (p[i] == 0) continue;
            double prob = (double)p[i] / n;
            sum += Math.log(prob) * prob * iln2;
        }
        return sum == 0.0 ? 0.0 : -sum;
    }

    public static double entropy(int nbits, int[] data) {
        if (data == null) {
            return 0.0;
        }
        int n = (int)Math.pow(2.0, nbits);
        int[] p = new int[n];
        int count = 0;
        for (int b : data) {
            if (b < 0 || b > n - 1) {
                logger.warn("BAD {} at index {}; max={}", b, count, n - 1);
            } else {
                int n2 = b;
                p[n2] = p[n2] + 1;
            }
            ++count;
        }
        double len = data.length;
        double iln2 = 1.0 / Math.log(2.0);
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            if (p[i] == 0) continue;
            double prob = (double)p[i] / len;
            sum += Math.log(prob) * prob * iln2;
        }
        return sum == 0.0 ? 0.0 : -sum;
    }

    public static class Info {
        public int bitmapLength;
        public long msgLength;
        public long dataLength;
        public int ndataPoints;
        public int nPoints;
        public float referenceValue;
        public int binaryScaleFactor;
        public int decimalScaleFactor;
        public int numberOfBits;
        public int originalType;
        public int flag;
        private float DD;
        private float EE;
        private int missing_value;
        private boolean init;

        public boolean isGridPointData() {
            return !GribNumbers.testGribBitIsSet(this.flag, 1);
        }

        public boolean isSimplePacking() {
            return !GribNumbers.testGribBitIsSet(this.flag, 2);
        }

        public boolean hasFloatingPointValues() {
            return !GribNumbers.testGribBitIsSet(this.flag, 3);
        }

        public boolean hasOctet14() {
            return GribNumbers.testGribBitIsSet(this.flag, 4);
        }

        public String getGridPointS() {
            return this.isGridPointData() ? "Grid-point" : "Spherical harmonic coefficients";
        }

        public String getPackingS() {
            return this.isSimplePacking() ? "simple" : "Complex / second order";
        }

        public String getDataTypeS() {
            return this.hasFloatingPointValues() ? "float" : "int";
        }

        public float convert(int val) {
            if (!this.init) {
                this.DD = (float)Math.pow(10.0, this.decimalScaleFactor);
                this.EE = (float)Math.pow(2.0, this.binaryScaleFactor);
                this.missing_value = (2 << this.numberOfBits - 1) - 1;
                this.init = true;
            }
            if (val == this.missing_value) {
                return Float.NaN;
            }
            return (this.referenceValue + (float)val * this.EE) / this.DD;
        }
    }

    public static interface Bean {
        public float[] readData() throws IOException;

        public int getNBits();

        public long getDataLength();

        public long getMsgLength();

        public int getBinScale();

        public int getDecScale();

        public double getMinimum();

        public double getMaximum();

        public double getScale();
    }

    public static enum InterpolationMethod {
        none,
        cubic,
        linear;

    }
}

