/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.point;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import ucar.ma2.ArrayStructure;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dods.DODSNetcdfFile;
import ucar.nc2.dt.DataIterator;
import ucar.nc2.dt.DataIteratorAdapter;
import ucar.nc2.dt.PointObsDataset;
import ucar.nc2.dt.StationImpl;
import ucar.nc2.dt.TypedDataset;
import ucar.nc2.dt.TypedDatasetFactoryIF;
import ucar.nc2.dt.point.PointObsDatasetImpl;
import ucar.nc2.dt.point.PointObsDatatypeImpl;
import ucar.nc2.dt.point.StationObsDatasetImpl;
import ucar.nc2.dt.point.StationObsDatatypeImpl;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;

public class DapperDataset
extends PointObsDatasetImpl
implements TypedDatasetFactoryIF {
    private static final String ID = "_id";
    protected DODSNetcdfFile dodsFile;
    protected Variable latVar;
    protected Variable lonVar;
    protected Variable altVar;
    protected Variable timeVar;
    protected StructureDS innerSequence;
    protected StructureDS outerSequence;
    protected boolean isProfile = false;
    protected boolean fatal = false;
    private StructureMembers.Member latMember;
    private StructureMembers.Member lonMember;
    private StructureMembers.Member innerMember;
    private StructureMembers.Member altMember;
    private StructureMembers.Member timeMember;

    public static boolean isValidFile(NetcdfFile ds) {
        String conv = ds.findAttValueIgnoreCase(null, "Conventions", null);
        if (conv == null) {
            return false;
        }
        StringTokenizer stoke = new StringTokenizer(conv, ",");
        while (stoke.hasMoreTokens()) {
            String toke = stoke.nextToken().trim();
            if (!toke.equalsIgnoreCase("epic-insitu-1.0")) continue;
            return true;
        }
        return false;
    }

    public static PointObsDataset factory(NetcdfDataset ds) throws IOException {
        boolean isProfile;
        CoordinateAxis latVar = null;
        CoordinateAxis timeVar = null;
        ImmutableList<CoordinateAxis> axes = ds.getCoordinateAxes();
        for (int i = 0; i < axes.size(); ++i) {
            CoordinateAxis axis = (CoordinateAxis)axes.get(i);
            if (axis.getAxisType() == AxisType.Lat) {
                latVar = axis;
            }
            if (axis.getAxisType() != AxisType.Time) continue;
            timeVar = axis;
        }
        StructureDS outerSequence = DapperDataset.getWrappingParent(ds, latVar);
        boolean bl = isProfile = DapperDataset.getWrappingParent(ds, timeVar) == outerSequence;
        if (isProfile) {
            return new DapperPointDataset(ds);
        }
        return new DapperStationDataset(ds);
    }

    private static StructureDS getWrappingParent(NetcdfDataset ds, Variable v) {
        String name = v.getParentStructure().getFullNameEscaped();
        return (StructureDS)ds.findVariable(name);
    }

    @Override
    public boolean isMine(NetcdfDataset ds) {
        return DapperDataset.isValidFile(ds);
    }

    @Override
    public TypedDataset open(NetcdfDataset ncd, CancelTask task, StringBuilder errlog) throws IOException {
        return new DapperDataset(ncd);
    }

    public DapperDataset() {
    }

    public DapperDataset(NetcdfDataset ds) throws IOException {
        super(ds);
        Variable v;
        int i;
        ImmutableList<CoordinateAxis> axes = ds.getCoordinateAxes();
        for (int i2 = 0; i2 < axes.size(); ++i2) {
            CoordinateAxis axis = (CoordinateAxis)axes.get(i2);
            if (axis.getAxisType() == AxisType.Lat) {
                this.latVar = axis;
            }
            if (axis.getAxisType() == AxisType.Lon) {
                this.lonVar = axis;
            }
            if (axis.getAxisType() == AxisType.Height) {
                this.altVar = axis;
            }
            if (axis.getAxisType() != AxisType.Time) continue;
            this.timeVar = axis;
        }
        if (this.latVar == null) {
            this.parseInfo.append("Missing latitude variable");
            this.fatal = true;
        }
        if (this.lonVar == null) {
            this.parseInfo.append("Missing longitude variable");
            this.fatal = true;
        }
        if (this.altVar == null) {
            this.parseInfo.append("Missing altitude variable");
        }
        if (this.timeVar == null) {
            this.parseInfo.append("Missing time variable");
            this.fatal = true;
        }
        this.outerSequence = DapperDataset.getWrappingParent(ds, this.latVar);
        boolean isProfile = DapperDataset.getWrappingParent(ds, this.timeVar) == this.outerSequence;
        this.innerSequence = isProfile ? DapperDataset.getWrappingParent(ds, this.altVar) : DapperDataset.getWrappingParent(ds, this.timeVar);
        NetcdfFile refFile = ds.getReferencedFile();
        while (this.dodsFile == null) {
            if (refFile instanceof DODSNetcdfFile) {
                this.dodsFile = (DODSNetcdfFile)refFile;
                continue;
            }
            if (refFile instanceof NetcdfDataset) {
                refFile = ((NetcdfDataset)refFile).getReferencedFile();
                continue;
            }
            throw new IllegalArgumentException("Must be a DODSNetcdfFile");
        }
        ImmutableList<Variable> recordMembers = this.outerSequence.getVariables();
        for (i = 0; i < recordMembers.size(); ++i) {
            v = (Variable)recordMembers.get(i);
            this.dataVariables.add(v);
        }
        recordMembers = this.innerSequence.getVariables();
        for (i = 0; i < recordMembers.size(); ++i) {
            v = (Variable)recordMembers.get(i);
            this.dataVariables.add(v);
        }
        this.dataVariables.remove(this.latVar);
        this.dataVariables.remove(this.lonVar);
        this.dataVariables.remove(this.altVar);
        this.dataVariables.remove(this.timeVar);
        this.dataVariables.remove(this.innerSequence);
        this.dataVariables.remove(ds.findVariable(ID));
        this.dataVariables.remove(ds.findVariable("attributes"));
        this.dataVariables.remove(ds.findVariable("variable_attributes"));
        this.setBoundingBox();
        try {
            this.timeUnit = new DateUnit(this.timeVar.getUnitsString());
        }
        catch (Exception e) {
            this.parseInfo.append("Bad time units= " + this.timeVar.getUnitsString());
            this.fatal = true;
        }
        Attribute time_range = this.netcdfDataset.findGlobalAttribute("time_range");
        double time_start = time_range.getNumericValue(0).doubleValue();
        double time_end = time_range.getNumericValue(1).doubleValue();
        this.startDate = this.timeUnit.makeDate(time_start);
        this.endDate = this.timeUnit.makeDate(time_end);
        this.title = ds.findAttValueIgnoreCase(null, "title", "");
        this.desc = ds.findAttValueIgnoreCase(null, "description", "");
    }

    @Override
    protected void setTimeUnits() {
    }

    @Override
    protected void setStartDate() {
    }

    @Override
    protected void setEndDate() {
    }

    @Override
    protected void setBoundingBox() {
        Attribute lon_range = this.netcdfDataset.findGlobalAttribute("lon_range");
        double lon_start = lon_range.getNumericValue(0).doubleValue();
        double lon_end = lon_range.getNumericValue(1).doubleValue();
        Attribute lat_range = this.netcdfDataset.findGlobalAttribute("lat_range");
        double lat_start = lat_range.getNumericValue(0).doubleValue();
        double lat_end = lat_range.getNumericValue(1).doubleValue();
        this.boundingBox = new LatLonRect(new LatLonPointImpl(lat_start, lon_start), new LatLonPointImpl(lat_end, lon_end));
    }

    @Override
    public int getDataCount() {
        return -1;
    }

    @Override
    public List getData(CancelTask cancel) throws IOException {
        String CE = this.outerSequence.getFullName();
        ArrayStructure as = (ArrayStructure)this.dodsFile.readWithCE(this.outerSequence, CE);
        this.extractMembers(as);
        int n = (int)as.getSize();
        ArrayList<SeqPointObs> dataList = new ArrayList<SeqPointObs>(n);
        for (int i = 0; i < n; ++i) {
            dataList.add(new SeqPointObs(i, as.getStructureData(i)));
        }
        return dataList;
    }

    @Override
    public List getData(LatLonRect boundingBox, CancelTask cancel) throws IOException {
        String CE = this.outerSequence.getFullName() + "&" + this.makeBB(boundingBox);
        ArrayStructure as = (ArrayStructure)this.dodsFile.readWithCE(this.outerSequence, CE);
        this.extractMembers(as);
        int n = (int)as.getSize();
        ArrayList<SeqPointObs> dataList = new ArrayList<SeqPointObs>(n);
        for (int i = 0; i < n; ++i) {
            dataList.add(new SeqPointObs(i, as.getStructureData(i)));
        }
        return dataList;
    }

    @Override
    public List getData(LatLonRect boundingBox, Date start, Date end, CancelTask cancel) throws IOException {
        String CE = this.outerSequence.getFullName() + "&" + this.makeBB(boundingBox) + "&" + this.makeTimeRange(start, end);
        ArrayStructure as = (ArrayStructure)this.dodsFile.readWithCE(this.outerSequence, CE);
        this.extractMembers(as);
        int n = (int)as.getSize();
        ArrayList<SeqPointObs> dataList = new ArrayList<SeqPointObs>(n);
        for (int i = 0; i < n; ++i) {
            dataList.add(new SeqPointObs(i, as.getStructureData(i)));
        }
        return dataList;
    }

    private String makeBB(LatLonRect bb) {
        return this.latVar.getFullName() + ">=" + bb.getLowerLeftPoint().getLatitude() + "&" + this.latVar.getFullName() + "<=" + bb.getUpperRightPoint().getLatitude() + "&" + this.lonVar.getFullName() + ">=" + bb.getLowerLeftPoint().getLongitude() + "&" + this.lonVar.getFullName() + "<=" + bb.getUpperRightPoint().getLongitude();
    }

    private String makeTimeRange(Date start, Date end) {
        double startValue = this.timeUnit.makeValue(start);
        double endValue = this.timeUnit.makeValue(end);
        return this.timeVar.getFullName() + ">=" + startValue + "&" + this.timeVar.getFullName() + "<=" + endValue;
    }

    private void extractMembers(ArrayStructure as) {
        StructureMembers members = as.getStructureMembers();
        this.latMember = members.findMember(this.latVar.getShortName());
        this.lonMember = members.findMember(this.lonVar.getShortName());
        this.innerMember = members.findMember(this.innerSequence.getShortName());
        StructureData first = as.getStructureData(0);
        StructureData innerFirst = first.getScalarStructure(this.innerMember);
        StructureMembers innerMembers = innerFirst.getStructureMembers();
        if (this.isProfile) {
            this.timeMember = members.findMember(this.timeVar.getShortName());
            this.altMember = innerMembers.findMember(this.altVar.getShortName());
        } else {
            this.timeMember = innerMembers.findMember(this.timeVar.getShortName());
            this.altMember = members.findMember(this.altVar.getShortName());
        }
    }

    public void readStations(List stations) throws IOException {
        String CE = this.latVar.getShortName() + "," + this.lonVar.getShortName() + "," + this.altVar.getShortName() + "," + ID;
        ArrayStructure as = (ArrayStructure)this.dodsFile.readWithCE(this.outerSequence, CE);
        StructureMembers members = as.getStructureMembers();
        StructureMembers.Member latMember = members.findMember(this.latVar.getShortName());
        StructureMembers.Member lonMember = members.findMember(this.lonVar.getShortName());
        StructureMembers.Member altMember = members.findMember(this.altVar.getShortName());
        StructureMembers.Member idMember = members.findMember(ID);
        int n = (int)as.getSize();
        for (int i = 0; i < n; ++i) {
            StructureData sdata = as.getStructureData(i);
            double lat = sdata.convertScalarDouble(latMember);
            double lon = sdata.convertScalarDouble(lonMember);
            double alt = sdata.convertScalarDouble(altMember);
            int id = sdata.getScalarInt(idMember);
            StationImpl s2 = new StationImpl(Integer.toString(id), "Station" + i, lat, lon, alt);
            stations.add(s2);
        }
    }

    public List readStationData(Station s2, CancelTask cancel) throws IOException {
        String CE = this.outerSequence.getShortName() + "." + this.innerSequence.getShortName() + "&" + this.outerSequence.getShortName() + "." + ID + "=" + s2.getName();
        ArrayStructure as = (ArrayStructure)this.dodsFile.readWithCE(this.outerSequence, CE);
        StructureData outerStructure = as.getStructureData(0);
        ArrayStructure asInner = (ArrayStructure)outerStructure.getArray(this.innerSequence.getShortName());
        StructureMembers innerMembers = asInner.getStructureMembers();
        StructureMembers.Member timeMember = innerMembers.findMember(this.timeVar.getShortName());
        int n = (int)asInner.getSize();
        ArrayList<SeqStationObs> stationData = new ArrayList<SeqStationObs>(n);
        for (int i = 0; i < n; ++i) {
            StructureData sdata = asInner.getStructureData(i);
            double obsTime = sdata.convertScalarDouble(timeMember);
            stationData.add(new SeqStationObs(s2, obsTime, sdata));
        }
        return stationData;
    }

    @Override
    public DataIterator getDataIterator(int bufferSize) throws IOException {
        return new DataIteratorAdapter(this.getData((CancelTask)null).iterator());
    }

    public static void main(String[] args) throws IOException {
        String url = "http://dapper.pmel.noaa.gov/dapper/epic/woce_sl_time_monthly.cdp";
        NetcdfDataset ncd = NetcdfDataset.openDataset(url);
        DapperDataset.factory(ncd);
    }

    private static class DapperStationDataset
    extends StationObsDatasetImpl {
        DapperDataset dd;

        DapperStationDataset(NetcdfDataset ds) throws IOException {
            super(ds);
            this.dd = new DapperDataset(ds);
            this.dd.readStations(this.stations);
        }

        @Override
        public List getData(Station s2, CancelTask cancel) throws IOException {
            return this.dd.readStationData(s2, cancel);
        }

        @Override
        protected void setTimeUnits() {
        }

        @Override
        protected void setStartDate() {
        }

        @Override
        protected void setEndDate() {
        }

        @Override
        protected void setBoundingBox() {
        }

        @Override
        public List getData(CancelTask cancel) throws IOException {
            return this.dd.getData(cancel);
        }

        @Override
        public int getDataCount() {
            return this.dd.getDataCount();
        }

        @Override
        public List getData(LatLonRect boundingBox, CancelTask cancel) throws IOException {
            return this.dd.getData(boundingBox, cancel);
        }

        @Override
        public List getData(LatLonRect boundingBox, Date start, Date end, CancelTask cancel) throws IOException {
            return this.dd.getData(boundingBox, start, end, cancel);
        }

        @Override
        public DataIterator getDataIterator(int bufferSize) throws IOException {
            return this.dd.getDataIterator(bufferSize);
        }
    }

    private static class DapperPointDataset
    extends PointObsDatasetImpl {
        DapperDataset dd;

        DapperPointDataset(NetcdfDataset ds) throws IOException {
            super(ds);
            this.dd = new DapperDataset(ds);
        }

        @Override
        protected void setTimeUnits() {
        }

        @Override
        protected void setStartDate() {
        }

        @Override
        protected void setEndDate() {
        }

        @Override
        protected void setBoundingBox() {
        }

        @Override
        public List getData(CancelTask cancel) throws IOException {
            return this.dd.getData(cancel);
        }

        @Override
        public int getDataCount() {
            return this.dd.getDataCount();
        }

        @Override
        public List getData(LatLonRect boundingBox, CancelTask cancel) throws IOException {
            return this.dd.getData(boundingBox, cancel);
        }

        @Override
        public List getData(LatLonRect boundingBox, Date start, Date end, CancelTask cancel) throws IOException {
            return this.dd.getData(boundingBox, start, end, cancel);
        }

        @Override
        public DataIterator getDataIterator(int bufferSize) throws IOException {
            return this.dd.getDataIterator(bufferSize);
        }
    }

    public class SeqStationObs
    extends StationObsDatatypeImpl {
        protected StructureData sdata;

        public SeqStationObs(Station s2, double obsTime, StructureData sdata) {
            super(s2, obsTime, obsTime);
            this.sdata = sdata;
        }

        @Override
        public Date getNominalTimeAsDate() {
            return DapperDataset.this.timeUnit.makeDate(this.getNominalTime());
        }

        @Override
        public Date getObservationTimeAsDate() {
            return DapperDataset.this.timeUnit.makeDate(this.getObservationTime());
        }

        @Override
        public StructureData getData() throws IOException {
            return this.sdata;
        }
    }

    public class SeqPointObs
    extends PointObsDatatypeImpl {
        protected int recno;
        protected LatLonPointImpl llpt;
        protected StructureData sdata;

        protected SeqPointObs(EarthLocation location, double obsTime, double nomTime, int recno) {
            super(location, obsTime, nomTime);
            this.llpt = null;
            this.recno = recno;
        }

        public SeqPointObs(int recno, StructureData sdata) {
            this.llpt = null;
            this.recno = recno;
            this.sdata = sdata;
            double lat = sdata.convertScalarDouble(DapperDataset.this.latMember);
            double lon = sdata.convertScalarDouble(DapperDataset.this.lonMember);
            StructureData inner = sdata.getScalarStructure(DapperDataset.this.innerMember);
            double alt = 0.0;
            if (DapperDataset.this.isProfile) {
                this.obsTime = sdata.convertScalarDouble(DapperDataset.this.timeMember);
                alt = inner.convertScalarDouble(DapperDataset.this.altMember);
            } else {
                this.obsTime = inner.convertScalarDouble(DapperDataset.this.timeMember);
                alt = sdata.convertScalarDouble(DapperDataset.this.altMember);
            }
            this.nomTime = this.obsTime;
            this.location = EarthLocation.create(lat, lon, alt);
        }

        public LatLonPoint getLatLon() {
            if (this.llpt == null) {
                this.llpt = new LatLonPointImpl(this.location.getLatitude(), this.location.getLongitude());
            }
            return this.llpt;
        }

        @Override
        public Date getNominalTimeAsDate() {
            return DapperDataset.this.timeUnit.makeDate(this.getNominalTime());
        }

        @Override
        public Date getObservationTimeAsDate() {
            return DapperDataset.this.timeUnit.makeDate(this.getObservationTime());
        }

        @Override
        public StructureData getData() throws IOException {
            return this.sdata;
        }
    }
}

