/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog.dl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import thredds.catalog.dl.VocabTranslator;

public class Grib1toDIF
implements VocabTranslator {
    private static Grib1toDIF singleton;
    private Map<String, String> hash = new HashMap<String, String>();
    private int maxLines = 1000;

    public static Grib1toDIF getInstance() throws IOException {
        if (singleton == null) {
            singleton = new Grib1toDIF();
        }
        return singleton;
    }

    private Grib1toDIF() throws IOException {
        String line;
        Class<?> c = this.getClass();
        String resourceName = "/resources/thredds/dl/GRIB-GCMD.csv";
        InputStream ios = c.getResourceAsStream(resourceName);
        if (ios == null) {
            throw new IOException("Cant find resource= " + resourceName);
        }
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios, StandardCharsets.UTF_8));
        for (int count = 0; count < this.maxLines && (line = dataIS.readLine()) != null; ++count) {
            StringTokenizer stoker = new StringTokenizer(line, ",");
            String category = stoker.nextToken().trim();
            String topic = stoker.nextToken().trim();
            String term = stoker.nextToken().trim();
            String var = stoker.nextToken().trim();
            String gribNo = stoker.nextToken().trim();
            String difParam = category + " > " + topic + " > " + term + " > " + var;
            this.hash.put(gribNo, difParam);
        }
        dataIS.close();
    }

    @Override
    public String translate(String fromId) {
        int pos = fromId.lastIndexOf(",");
        String paramNo = fromId.substring(pos + 1).trim();
        return this.hash.get(paramNo);
    }
}

