/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import loci.formats.CoreMetadata;
import loci.formats.DataTools;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.Location;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;
import loci.formats.in.TiffReader;

public class PrairieReader
extends FormatReader {
    private static final int PRAIRIE_TAG_1 = 33628;
    private static final int PRAIRIE_TAG_2 = 33629;
    private static final int PRAIRIE_TAG_3 = 33630;
    private String[] files;
    private TiffReader tiff;
    private String xmlFile;
    private String cfgFile;
    private boolean readXML = false;
    private boolean readCFG = false;

    public PrairieReader() {
        super("Prairie (TIFF)", new String[]{"tif", "tiff", "cfg", "xml"});
    }

    public boolean isThisType(byte[] block) {
        if (block.length < 3) {
            return false;
        }
        if (block.length < 8) {
            return true;
        }
        String s2 = new String(block);
        if (s2.indexOf("xml") != -1 && s2.indexOf("PV") != -1) {
            return true;
        }
        boolean little = block[0] == 73 && block[1] == 73;
        int ifdlocation = DataTools.bytesToInt(block, 4, little);
        if (ifdlocation < 0) {
            return false;
        }
        if (ifdlocation + 1 > block.length) {
            return true;
        }
        int ifdnumber = DataTools.bytesToInt(block, ifdlocation, 2, little);
        for (int i = 0; i < ifdnumber; ++i) {
            if (ifdlocation + 3 + i * 12 > block.length) {
                return false;
            }
            int ifdtag = DataTools.bytesToInt(block, ifdlocation + 2 + i * 12, 2, little);
            if (ifdtag != 33628 && ifdtag != 33629 && ifdtag != 33630) continue;
            return true;
        }
        return false;
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return (id = id.toLowerCase()).endsWith(".cfg") || id.endsWith(".xml") ? 0 : 1;
    }

    public String[] getUsedFiles() {
        FormatTools.assertId(this.currentId, true, 1);
        String[] s2 = new String[this.files.length + 2];
        System.arraycopy(this.files, 0, s2, 0, this.files.length);
        s2[this.files.length] = this.xmlFile;
        s2[this.files.length + 1] = this.cfgFile;
        return s2;
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        this.tiff.setId(this.files[no]);
        return this.tiff.openBytes(0, buf);
    }

    public void close(boolean fileOnly) throws IOException {
        if (fileOnly && this.tiff != null) {
            this.tiff.close(fileOnly);
        } else if (!fileOnly) {
            this.close();
        }
    }

    public boolean isThisType(String name, boolean open) {
        boolean xml;
        RandomAccessStream s2;
        int i;
        if (!super.isThisType(name, open)) {
            return false;
        }
        if (!this.isGroupFiles()) {
            return false;
        }
        Location f = new Location(name);
        f = f.getAbsoluteFile();
        Location parent = f.getParentFile();
        String[] listing = parent.list();
        int xmlCount = 0;
        for (i = 0; i < listing.length; ++i) {
            if (!listing[i].toLowerCase().endsWith(".xml")) continue;
            try {
                s2 = new RandomAccessStream(parent.getAbsolutePath() + File.separator + listing[i]);
                if (s2.readString(512).indexOf("PV") == -1) continue;
                ++xmlCount;
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (xmlCount == 0) {
            listing = Location.getIdMap().keySet().toArray(new String[0]);
            for (i = 0; i < listing.length; ++i) {
                if (!listing[i].toLowerCase().endsWith(".xml")) continue;
                try {
                    s2 = new RandomAccessStream(listing[i]);
                    if (s2.readString(512).indexOf("PV") == -1) continue;
                    ++xmlCount;
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        boolean bl = xml = xmlCount > 0;
        return open ? this.checkBytes(name, 524304) && xml : xml;
    }

    public void close() throws IOException {
        this.files = null;
        if (this.tiff != null) {
            this.tiff.close();
        }
        this.tiff = null;
        this.currentId = null;
        this.readXML = false;
        this.readCFG = false;
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("PrairieReader.initFile(" + id + ")");
        }
        if (this.metadata == null) {
            this.metadata = new Hashtable();
        }
        if (this.core == null) {
            this.core = new CoreMetadata(1);
        }
        if (id.endsWith("xml") || id.endsWith("cfg")) {
            this.status("Parsing XML");
            if (id.endsWith("xml")) {
                super.initFile(id);
                this.tiff = new TiffReader();
                this.xmlFile = id;
                this.readXML = true;
            } else if (id.endsWith("cfg")) {
                this.cfgFile = id;
                this.readCFG = true;
            }
            RandomAccessStream is = new RandomAccessStream(id);
            byte[] b = new byte[(int)is.length()];
            is.read(b);
            is.close();
            String s2 = new String(b);
            Vector<String> elements = new Vector<String>();
            while (s2.length() > 0) {
                int ndx = s2.indexOf("<");
                int val1 = s2.indexOf(">", ndx);
                if (val1 == -1 || val1 <= ndx) continue;
                String sub = s2.substring(ndx + 1, val1);
                s2 = s2.substring(val1 + 1);
                elements.add(sub);
            }
            int zt = 0;
            boolean isZ = false;
            Vector<String> f = new Vector<String>();
            int fileIndex = 1;
            if (id.endsWith(".xml")) {
                this.core.imageCount[0] = 0;
            }
            String pastPrefix = "";
            for (int i = 1; i < elements.size(); ++i) {
                String el = (String)elements.get(i);
                if (el.indexOf(" ") == -1) continue;
                boolean closed = el.endsWith("/");
                String prefix = el.substring(0, el.indexOf(" "));
                if (prefix.equals("File")) {
                    this.core.imageCount[0] = this.core.imageCount[0] + 1;
                }
                if (prefix.equals("Frame")) {
                    ++zt;
                    fileIndex = 1;
                }
                if (!prefix.equals("Key") && !prefix.equals("Frame")) {
                    el = el.substring(el.indexOf(" ") + 1);
                    while (el.indexOf("=") != -1) {
                        int eq = el.indexOf("=");
                        String key = el.substring(0, eq);
                        String value = el.substring(eq + 2, el.indexOf("\"", eq + 2));
                        if (prefix.equals("File")) {
                            this.addMeta(pastPrefix + " " + prefix + " " + fileIndex + " " + key, value);
                            if (key.equals("filename")) {
                                ++fileIndex;
                            }
                        } else {
                            this.addMeta(pastPrefix + " " + prefix + " " + key, value);
                            if (pastPrefix.equals("PVScan") && prefix.equals("Sequence") && key.equals("type")) {
                                isZ = value.equals("ZSeries");
                            }
                        }
                        el = el.substring(el.indexOf("\"", eq + 2) + 1).trim();
                        if (!prefix.equals("File") || !key.equals("filename")) continue;
                        File current = new File(id).getAbsoluteFile();
                        String dir = "";
                        if (current.exists()) {
                            dir = current.getPath();
                            dir = dir.substring(0, dir.lastIndexOf(File.separator) + 1);
                        }
                        f.add(dir + value);
                    }
                } else if (prefix.equals("Key")) {
                    int keyIndex = el.indexOf("key") + 5;
                    int valueIndex = el.indexOf("value") + 7;
                    String key = el.substring(keyIndex, el.indexOf("\"", keyIndex));
                    String value = el.substring(valueIndex, el.indexOf("\"", valueIndex));
                    this.addMeta(key, value);
                    if (key.equals("pixelsPerLine")) {
                        this.core.sizeX[0] = Integer.parseInt(value);
                    } else if (key.equals("linesPerFrame")) {
                        this.core.sizeY[0] = Integer.parseInt(value);
                    }
                }
                if (closed) continue;
                pastPrefix = prefix;
                if (!prefix.equals("Frame")) continue;
                int index = el.indexOf("index") + 7;
                String idx = el.substring(index, el.indexOf("\"", index));
                pastPrefix = pastPrefix + " " + idx;
            }
            if (id.endsWith("xml")) {
                this.files = new String[f.size()];
                f.copyInto(this.files);
                this.tiff.setId(this.files[0]);
                this.status("Populating metadata");
                if (zt == 0) {
                    zt = 1;
                }
                this.core.sizeZ[0] = isZ ? zt : 1;
                this.core.sizeT[0] = isZ ? 1 : zt;
                this.core.sizeC[0] = this.core.imageCount[0] / (this.core.sizeZ[0] * this.core.sizeT[0]);
                this.core.currentOrder[0] = "XYC" + (isZ ? "ZT" : "TZ");
                this.core.pixelType[0] = 3;
                this.core.rgb[0] = false;
                this.core.interleaved[0] = false;
                this.core.littleEndian[0] = this.tiff.isLittleEndian();
                this.core.indexed[0] = this.tiff.isIndexed();
                this.core.falseColor[0] = false;
                String px = (String)this.getMeta("micronsPerPixel_XAxis");
                String py = (String)this.getMeta("micronsPerPixel_YAxis");
                float pixSizeX = px == null ? 0.0f : Float.parseFloat(px);
                float pixSizeY = py == null ? 0.0f : Float.parseFloat(py);
                MetadataStore store = this.getMetadataStore();
                FormatTools.populatePixels(store, this);
                store.setDimensions(new Float(pixSizeX), new Float(pixSizeY), null, null, null, null);
                for (int i = 0; i < this.core.sizeC[0]; ++i) {
                    String gain = (String)this.getMeta("pmtGain_" + i);
                    String offset = (String)this.getMeta("pmtOffset_" + i);
                    store.setLogicalChannel(i, null, null, null, null, null, null, null, null, offset == null ? null : new Float(offset), gain == null ? null : new Float(gain), null, null, null, null, null, null, null, null, null, null, null, null, null, null);
                }
                String date = (String)this.getMeta(" PVScan date");
                if (date != null) {
                    SimpleDateFormat parse = new SimpleDateFormat("MM/dd/yyyy h:mm:ss a");
                    Date d = parse.parse(date, new ParsePosition(0));
                    SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                    date = fmt.format(d);
                }
                store.setImage(this.currentId, date, null, null);
                String laserPower = (String)this.getMeta("laserPower_0");
                store.setLaser(null, null, null, null, null, null, laserPower == null ? null : new Float(laserPower), null, null, null, null);
            }
            if (!this.readXML || !this.readCFG) {
                File file = new File(id).getAbsoluteFile();
                File parent = file.getParentFile();
                String[] listing = file.exists() ? parent.list() : Location.getIdMap().keySet().toArray(new String[0]);
                for (int i = 0; i < listing.length; ++i) {
                    String path = listing[i].toLowerCase();
                    if ((this.readXML || !path.endsWith(".xml")) && (!this.readXML || !path.endsWith(".cfg"))) continue;
                    String dir = "";
                    if (file.exists() && !(dir = parent.getPath()).endsWith(File.separator)) {
                        dir = dir + File.separator;
                    }
                    this.initFile(dir + listing[i]);
                }
            }
        } else {
            this.status("Finding XML file");
            Location f = new Location(id);
            f = f.getAbsoluteFile();
            Location parent = f.getParentFile();
            String[] listing = parent.list();
            for (int i = 0; i < listing.length; ++i) {
                String path = listing[i].toLowerCase();
                if (!path.endsWith(".xml") && !path.endsWith(".cfg")) continue;
                this.initFile(new Location(path).getAbsolutePath());
            }
        }
        if (this.currentId == null) {
            this.currentId = id;
        }
    }
}

