/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.LogTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;
import loci.formats.ReflectException;
import loci.formats.ReflectedUniverse;

public class PCIReader
extends FormatReader {
    private static final String NO_POI_MSG = "Jakarta POI is required to read SimplePCI files. Please obtain poi-loci.jar from http://loci.wisc.edu/ome/formats.html";
    private static boolean noPOI = false;
    private static ReflectedUniverse r = PCIReader.createReflectedUniverse();
    private Hashtable imageDirectories;
    private Hashtable imageFiles;
    private String currentParent;

    private static ReflectedUniverse createReflectedUniverse() {
        block2: {
            r = null;
            try {
                r = new ReflectedUniverse();
                r.exec("import org.apache.poi.poifs.filesystem.POIFSFileSystem");
                r.exec("import org.apache.poi.poifs.filesystem.DirectoryEntry");
                r.exec("import org.apache.poi.poifs.filesystem.DocumentEntry");
                r.exec("import org.apache.poi.poifs.filesystem.DocumentInputStream");
                r.exec("import java.util.Iterator");
            }
            catch (ReflectException exc) {
                noPOI = true;
                if (!debug) break block2;
                LogTools.trace(exc);
            }
        }
        return r;
    }

    public PCIReader() {
        super("Simple-PCI (Compix)", "cxd");
    }

    public boolean isThisType(byte[] block) {
        return block[0] == 208 && block[1] == 207 && block[2] == 17 && block[3] == 224;
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (noPOI) {
            throw new FormatException(NO_POI_MSG);
        }
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length);
        Integer ii = new Integer(no);
        Object directory = this.imageDirectories.get(ii);
        String name = (String)this.imageFiles.get(ii);
        try {
            r.setVar("dir", directory);
            r.setVar("entryName", name);
            r.exec("document = dir.getEntry(entryName)");
            r.exec("dis = new DocumentInputStream(document)");
            r.exec("numBytes = dis.available()");
            r.setVar("data", buf);
            r.exec("dis.read(data)");
        }
        catch (ReflectException e) {
            throw new FormatException(NO_POI_MSG, e);
        }
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("PCIReader.initFile(" + id + ")");
        }
        if (noPOI) {
            throw new FormatException(NO_POI_MSG);
        }
        super.initFile(id);
        this.imageDirectories = new Hashtable();
        this.imageFiles = new Hashtable();
        try {
            this.in = new RandomAccessStream(id);
            r.setVar("fis", this.in);
            r.exec("fs = new POIFSFileSystem(fis)");
            r.exec("dir = fs.getRoot()");
            this.parseDir(0, r.getVar("dir"));
            this.core.sizeZ[0] = this.core.imageCount[0];
            this.core.sizeT[0] = 1;
            this.core.rgb[0] = this.core.sizeC[0] > 1;
            this.core.interleaved[0] = false;
            this.core.currentOrder[0] = "XYCZT";
            this.core.littleEndian[0] = true;
            this.core.indexed[0] = false;
            this.core.falseColor[0] = false;
            this.core.metadataComplete[0] = true;
            MetadataStore store = this.getMetadataStore();
            FormatTools.populatePixels(store, this);
            store.setImage(this.currentId, null, null, null);
            for (int i = 0; i < this.core.sizeC[0]; ++i) {
                store.setLogicalChannel(i, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
            }
        }
        catch (ReflectException exc) {
            noPOI = true;
        }
    }

    private void parseDir(int depth, Object dir) throws IOException, FormatException, ReflectException {
        r.setVar("dir", dir);
        r.exec("dirName = dir.getName()");
        r.setVar("depth", depth);
        r.exec("iter = dir.getEntries()");
        Iterator iter = (Iterator)r.getVar("iter");
        while (iter.hasNext()) {
            r.setVar("entry", iter.next());
            r.exec("isInstance = entry.isDirectoryEntry()");
            r.exec("isDocument = entry.isDocumentEntry()");
            boolean isInstance = (Boolean)r.getVar("isInstance");
            boolean isDocument = (Boolean)r.getVar("isDocument");
            r.setVar("dir", dir);
            r.exec("dirName = dir.getName()");
            if (isInstance) {
                if (debug) {
                    this.print(depth, (String)r.getVar("dirName"));
                }
                if (((String)r.getVar("dirName")).trim().startsWith("Field")) {
                    this.currentParent = ((String)r.getVar("dirName")).trim();
                }
                this.parseDir(depth + 1, r.getVar("entry"));
                continue;
            }
            if (!isDocument) continue;
            r.exec("entryName = entry.getName()");
            if (debug) {
                this.print(depth + 1, (String)r.getVar("entryName"));
            }
            r.exec("dis = new DocumentInputStream(entry)");
            r.exec("numBytes = dis.available()");
            int numBytes = (Integer)r.getVar("numBytes");
            byte[] data = new byte[numBytes];
            r.setVar("data", data);
            r.exec("dis.read(data)");
            String entryName = (String)r.getVar("entryName");
            String dirName = (String)r.getVar("dirName");
            RandomAccessStream s2 = new RandomAccessStream(data);
            s2.order(true);
            if (entryName.equals("Field Count")) {
                this.core.imageCount[0] = s2.readInt();
            } else if (entryName.equals("File Has Image")) {
                if (s2.readShort() == 0) {
                    throw new FormatException("This file does not contain image data.");
                }
            } else if (entryName.equals("Comments")) {
                String comments = new String(data).trim();
                StringTokenizer st = new StringTokenizer(comments, "\n");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken().trim();
                    if (token.indexOf("=") == -1) continue;
                    int idx = token.indexOf("=");
                    String key = token.substring(0, idx).trim();
                    String value = token.substring(idx + 1).trim();
                    this.addMeta(key, value);
                }
            } else if (entryName.startsWith("Bitmap")) {
                int space = this.currentParent.indexOf(" ") + 1;
                int num = Integer.parseInt(this.currentParent.substring(space)) - 1;
                Integer ii = new Integer(num);
                this.imageDirectories.put(ii, r.getVar("dir"));
                this.imageFiles.put(ii, entryName);
                if (this.core.sizeX[0] != 0 && this.core.sizeY[0] != 0) {
                    this.core.sizeC[0] = data.length / (this.core.sizeX[0] * this.core.sizeY[0] * FormatTools.getBytesPerPixel(this.core.pixelType[0]));
                }
            } else if (entryName.indexOf("Image_Depth") != -1) {
                s2.order(false);
                int bits = (int)(s2.readLong() & 0x1F00L) >> 8;
                while (bits % 8 != 0) {
                    ++bits;
                }
                switch (bits) {
                    case 8: {
                        this.core.pixelType[0] = 1;
                        break;
                    }
                    case 16: {
                        this.core.pixelType[0] = 3;
                        break;
                    }
                    case 32: {
                        this.core.pixelType[0] = 5;
                        break;
                    }
                    default: {
                        throw new FormatException("Unsupported bits per pixel : " + bits);
                    }
                }
                s2.order(true);
            } else if (entryName.indexOf("Image_Height") != -1) {
                s2.order(false);
                this.core.sizeY[0] = (int)((s2.readLong() & 0x1F00L) >> 8) * 64;
                s2.order(true);
            } else if (entryName.indexOf("Image_Width") != -1) {
                s2.order(false);
                this.core.sizeX[0] = (int)((s2.readLong() & 0x1F00L) >> 8) * 64;
                s2.order(true);
            } else if (entryName.indexOf("Time_From_Start") != -1 || entryName.indexOf("Event_Marker") != -1 || entryName.indexOf("Time_From_Last") != -1) {
                // empty if block
            }
            s2.close();
            data = null;
            r.exec("dis.close()");
        }
    }

    private void print(int depth, String s2) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < depth; ++i) {
            sb.append("  ");
        }
        sb.append(s2);
        this.debug(sb.toString());
    }
}

