/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Vector;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.Location;
import loci.formats.LogTools;
import loci.formats.MetadataRetrieve;
import loci.formats.MetadataStore;
import loci.formats.MetadataTools;
import loci.formats.RandomAccessStream;
import loci.formats.ReflectException;
import loci.formats.ReflectedUniverse;
import loci.formats.codec.Base64Codec;
import loci.formats.codec.CBZip2InputStream;

public class OMEXMLReader
extends FormatReader {
    private static final String NO_OME_JAVA_MSG = "The Java OME-XML library is required to read OME-XML files. Please obtain ome-java.jar from http://loci.wisc.edu/ome/formats.html";
    private static boolean noOME;
    protected int[] bpp;
    protected Vector[] offsets;
    protected String[] compression;

    public OMEXMLReader() {
        super("OME-XML", "ome");
    }

    public boolean isThisType(byte[] block) {
        return new String(block, 0, 5).equals("<?xml");
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length);
        this.in.seek(((Integer)this.offsets[this.series].get(no)).intValue());
        byte[] b = no < this.getImageCount() - 1 ? new byte[(Integer)this.offsets[this.series].get(no + 1) - (Integer)this.offsets[this.series].get(no)] : new byte[(int)(this.in.length() - (long)((Integer)this.offsets[this.series].get(no)).intValue())];
        this.in.read(b);
        String data = new String(b);
        b = null;
        int dataStart = data.indexOf(">") + 1;
        String pix = data.substring(dataStart);
        if (pix.indexOf("<") > 0) {
            pix = pix.substring(0, pix.indexOf("<"));
        }
        data = null;
        Base64Codec e = new Base64Codec();
        byte[] pixels = e.base64Decode(pix);
        pix = null;
        if (this.compression[this.series].equals("bzip2")) {
            byte[] tempPixels = pixels;
            pixels = new byte[tempPixels.length - 2];
            System.arraycopy(tempPixels, 2, pixels, 0, pixels.length);
            ByteArrayInputStream bais = new ByteArrayInputStream(pixels);
            CBZip2InputStream bzip = new CBZip2InputStream(bais);
            pixels = new byte[this.core.sizeX[this.series] * this.core.sizeY[this.series] * this.bpp[this.series]];
            for (int i = 0; i < pixels.length; ++i) {
                pixels[i] = (byte)bzip.read();
            }
            tempPixels = null;
            bais.close();
            bais = null;
            bzip = null;
        } else if (this.compression[this.series].equals("zlib")) {
            try {
                Inflater decompressor = new Inflater();
                decompressor.setInput(pixels, 0, pixels.length);
                pixels = new byte[this.core.sizeX[this.series] * this.core.sizeY[this.series] * this.bpp[this.series]];
                decompressor.inflate(pixels);
                decompressor.end();
            }
            catch (DataFormatException dfe) {
                throw new FormatException("Error uncompressing zlib data.");
            }
        }
        buf = pixels;
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        MetadataRetrieve omexmlMeta;
        MetadataStore store;
        block43: {
            boolean found;
            int i;
            if (debug) {
                this.debug("OMEXMLReader.initFile(" + id + ")");
            }
            if (noOME) {
                throw new FormatException(NO_OME_JAVA_MSG);
            }
            super.initFile(id);
            this.in = new RandomAccessStream(id);
            ReflectedUniverse r = new ReflectedUniverse();
            try {
                r.exec("import loci.formats.ome.OMEXMLMetadata");
                r.exec("import org.openmicroscopy.xml.OMENode");
                r.exec("omexmlMeta = new OMEXMLMetadata()");
            }
            catch (ReflectException exc) {
                throw new FormatException(exc);
            }
            r.setVar("ome", null);
            try {
                File f = new File(Location.getMappedId(id));
                f = f.getAbsoluteFile();
                String path = f.getPath().toLowerCase();
                if (f.exists() && path.endsWith(".ome")) {
                    r.setVar("f", f);
                    r.exec("ome = new OMENode(f)");
                } else {
                    byte[] b = new byte[(int)this.in.length()];
                    long oldFp = this.in.getFilePointer();
                    this.in.seek(0L);
                    this.in.read(b);
                    this.in.seek(oldFp);
                    r.setVar("s", new String(b));
                    r.exec("ome = new OMENode(s)");
                    b = null;
                }
            }
            catch (ReflectException exc) {
                throw new FormatException(exc);
            }
            try {
                r.exec("omexmlMeta.setRoot(ome)");
            }
            catch (ReflectException exc) {
                throw new FormatException(exc);
            }
            this.status("Determining endianness");
            this.in.skipBytes(200);
            int numDatasets = 0;
            Vector<Boolean> endianness = new Vector<Boolean>();
            Vector<Long> bigEndianPos = new Vector<Long>();
            byte[] buf = new byte[1];
            while (this.in.getFilePointer() < this.in.length()) {
                buf = new byte[8192];
                boolean found2 = false;
                while (!found2) {
                    if (this.in.getFilePointer() < this.in.length()) {
                        int read = this.in.read(buf, 9, 8183);
                        String test = new String(buf);
                        int ndx = test.indexOf("BigEndian");
                        if (ndx == -1) continue;
                        found2 = true;
                        String endian = test.substring(ndx + 11).trim();
                        if (endian.startsWith("\"")) {
                            endian = endian.substring(1);
                        }
                        endianness.add(new Boolean(!endian.toLowerCase().startsWith("t")));
                        bigEndianPos.add(new Long(this.in.getFilePointer() - (long)read - 9L + (long)ndx));
                        ++numDatasets;
                        continue;
                    }
                    if (numDatasets == 0) {
                        throw new FormatException("Pixel data not found.");
                    }
                    found2 = true;
                }
            }
            this.offsets = new Vector[numDatasets];
            for (i = 0; i < numDatasets; ++i) {
                this.offsets[i] = new Vector();
            }
            this.status("Finding image offsets");
            for (i = 0; i < numDatasets; ++i) {
                this.in.seek((Long)bigEndianPos.get(i));
                found = false;
                buf = new byte[8192];
                this.in.read(buf, 0, 14);
                while (!found) {
                    if (this.in.getFilePointer() < this.in.length()) {
                        int numRead = this.in.read(buf, 14, 8178);
                        String test = new String(buf);
                        int ndx = test.indexOf("<Bin");
                        if (ndx == -1) {
                            byte[] b = buf;
                            System.arraycopy(b, 8177, buf, 0, 14);
                        } else {
                            while (ndx == -1 || ndx == test.indexOf("<Bin:External") || ndx == test.indexOf("<Bin:BinaryFile")) {
                                ndx = test.indexOf("<Bin", ndx + 1);
                            }
                            found = true;
                            this.offsets[i].add(new Integer((int)this.in.getFilePointer() - ((numRead += 14) - ndx)));
                        }
                        test = null;
                        continue;
                    }
                    throw new FormatException("Pixel data not found");
                }
            }
            this.in.seek(0L);
            for (i = 0; i < numDatasets; ++i) {
                if (i == 0) {
                    buf = new byte[((Integer)this.offsets[i].get(0)).intValue()];
                } else {
                    found = false;
                    buf = new byte[8192];
                    this.in.read(buf, 0, 14);
                    while (!found) {
                        if (this.in.getFilePointer() < this.in.length()) {
                            this.in.read(buf, 14, 8178);
                            String test = new String(buf);
                            int ndx = test.indexOf("<Image ");
                            if (ndx == -1) {
                                byte[] b = buf;
                                System.arraycopy(b, 8177, buf, 0, 14);
                                b = null;
                            } else {
                                found = true;
                                this.in.seek(this.in.getFilePointer() - (long)(8192 - ndx));
                            }
                            test = null;
                            continue;
                        }
                        throw new FormatException("Pixel data not found");
                    }
                    int bufSize = (int)((Long)this.offsets[i].get(0) - this.in.getFilePointer());
                    buf = new byte[bufSize];
                }
                this.in.read(buf);
            }
            buf = null;
            this.status("Populating metadata");
            this.core = new CoreMetadata(numDatasets);
            this.bpp = new int[numDatasets];
            this.compression = new String[numDatasets];
            int oldSeries = this.getSeries();
            try {
                r.exec("omexmlMeta.setRoot(ome)");
            }
            catch (ReflectException exc) {
                throw new FormatException(exc);
            }
            for (int i2 = 0; i2 < numDatasets; ++i2) {
                this.setSeries(i2);
                this.core.littleEndian[i2] = (Boolean)endianness.get(i2);
                Integer w = null;
                Integer h2 = null;
                Integer t = null;
                Integer z = null;
                Integer c = null;
                String pixType = null;
                try {
                    r.setVar("ndx", i2);
                    w = (Integer)r.exec("omexmlMeta.getSizeX(ndx)");
                    h2 = (Integer)r.exec("omexmlMeta.getSizeY(ndx)");
                    t = (Integer)r.exec("omexmlMeta.getSizeT(ndx)");
                    z = (Integer)r.exec("omexmlMeta.getSizeZ(ndx)");
                    c = (Integer)r.exec("omexmlMeta.getSizeC(ndx)");
                    pixType = (String)r.exec("omexmlMeta.getPixelType(ndx)");
                    this.core.currentOrder[i2] = (String)r.exec("omexmlMeta.getDimensionOrder(ndx)");
                }
                catch (ReflectException exc) {
                    throw new FormatException(exc);
                }
                this.core.sizeX[i2] = w;
                this.core.sizeY[i2] = h2;
                this.core.sizeT[i2] = t;
                this.core.sizeZ[i2] = z;
                this.core.sizeC[i2] = c;
                this.core.rgb[i2] = false;
                this.core.interleaved[i2] = false;
                this.core.indexed[i2] = false;
                this.core.falseColor[i2] = false;
                String type = pixType.toLowerCase();
                if (type.endsWith("16")) {
                    this.bpp[i2] = 2;
                    this.core.pixelType[i2] = 3;
                } else if (type.endsWith("32")) {
                    this.bpp[i2] = 4;
                    this.core.pixelType[i2] = 5;
                } else if (type.equals("float")) {
                    this.bpp[i2] = 4;
                    this.core.pixelType[i2] = 6;
                } else {
                    this.bpp[i2] = 1;
                    this.core.pixelType[i2] = 1;
                }
                int expected = this.core.sizeX[i2] * this.core.sizeY[i2] * this.bpp[i2];
                this.in.seek(((Integer)this.offsets[i2].get(0)).intValue());
                buf = new byte[256];
                this.in.read(buf);
                String data = new String(buf);
                int compressionStart = data.indexOf("Compression") + 13;
                int compressionEnd = data.indexOf("\"", compressionStart);
                this.compression[i2] = compressionStart != -1 && compressionEnd != -1 ? data.substring(compressionStart, compressionEnd) : "none";
                this.in.seek(((Integer)this.offsets[i2].get(0)).intValue());
                int planes = this.core.sizeZ[i2] * this.core.sizeC[i2] * this.core.sizeT[i2];
                this.searchForData(expected /= 2, planes);
                this.core.imageCount[i2] = this.offsets[i2].size();
                if (this.core.imageCount[i2] < planes) {
                    this.in.seek(((Integer)this.offsets[i2].get(0)).intValue());
                    this.searchForData(0, planes);
                    this.core.imageCount[i2] = this.offsets[i2].size();
                }
                buf = null;
            }
            this.setSeries(oldSeries);
            Arrays.fill(this.core.orderCertain, true);
            store = this.getMetadataStore();
            omexmlMeta = null;
            try {
                omexmlMeta = (MetadataRetrieve)r.getVar("omexmlMeta");
            }
            catch (ReflectException e) {
                if (!debug) break block43;
                LogTools.trace(e);
            }
        }
        String xml = MetadataTools.getOMEXML(omexmlMeta);
        MetadataTools.convertMetadata(xml, store);
    }

    private void searchForData(int safe, int numPlanes) throws IOException {
        int iteration = 0;
        boolean found = false;
        if (this.offsets[this.series].size() > 1) {
            Object zeroth = this.offsets[this.series].get(0);
            this.offsets[this.series].clear();
            this.offsets[this.series].add(zeroth);
        }
        this.in.skipBytes(1);
        while (this.in.getFilePointer() + (long)safe < this.in.length() && this.offsets[this.series].size() < numPlanes) {
            this.in.skipBytes(safe);
            found = false;
            byte[] buf = new byte[8192];
            while (!found) {
                if (this.in.getFilePointer() < this.in.length()) {
                    int numRead = this.in.read(buf, 20, buf.length - 20);
                    String test = new String(buf);
                    int ndx = test.indexOf("<Bin");
                    while (ndx != -1) {
                        found = true;
                        if (numRead == buf.length - 20) {
                            numRead = buf.length;
                        }
                        this.offsets[this.series].add(new Integer((int)this.in.getFilePointer() - (numRead - ndx)));
                        ndx = test.indexOf("<Bin", ndx + 1);
                    }
                    test = null;
                    continue;
                }
                found = true;
            }
            buf = null;
            ++iteration;
        }
    }

    static {
        block2: {
            noOME = false;
            try {
                Class.forName("org.openmicroscopy.xml.OMENode");
            }
            catch (Throwable t) {
                noOME = true;
                if (!debug) break block2;
                LogTools.trace(t);
            }
        }
    }
}

