/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.StringTokenizer;
import loci.formats.CoreMetadata;
import loci.formats.DataTools;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.Location;
import loci.formats.RandomAccessStream;
import loci.formats.TiffIFDEntry;
import loci.formats.TiffRational;
import loci.formats.TiffTools;
import loci.formats.UnknownTagException;
import loci.formats.in.BaseTiffReader;

public class MetamorphReader
extends BaseTiffReader {
    private static final int METAMORPH_ID = 33628;
    private static final int UIC1TAG = 33628;
    private static final int UIC2TAG = 33629;
    private static final int UIC3TAG = 33630;
    private static final int UIC4TAG = 33631;
    private String imageName;
    private String imageCreationDate;
    private long[] emWavelength;
    private int mmPlanes;
    private MetamorphReader r;
    private String[][] stks;

    public MetamorphReader() {
        super("Metamorph STK", new String[]{"stk", "nd"});
    }

    public boolean isThisType(byte[] block) {
        if (block.length < 3) {
            return false;
        }
        if (block[0] != 73) {
            return false;
        }
        if (block[1] != 73) {
            return false;
        }
        if (block[2] != 42) {
            return false;
        }
        if (block.length < 8) {
            return true;
        }
        int ifdlocation = DataTools.bytesToInt(block, 4, true);
        if (ifdlocation + 1 > block.length) {
            return true;
        }
        int ifdnumber = DataTools.bytesToInt(block, ifdlocation, 2, true);
        for (int i = 0; i < ifdnumber; ++i) {
            if (ifdlocation + 3 + i * 12 > block.length) {
                return true;
            }
            int ifdtag = DataTools.bytesToInt(block, ifdlocation + 2 + i * 12, 2, true);
            if (ifdtag != 33628) continue;
            return true;
        }
        return false;
    }

    public void close() throws IOException {
        super.close();
        if (this.r != null) {
            this.r.close();
        }
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        if (id.toLowerCase().endsWith(".nd")) {
            return 0;
        }
        Location l = new Location(id).getAbsoluteFile();
        String[] files = l.getParentFile().list();
        for (int i = 0; i < files.length; ++i) {
            String s2 = files[i].toLowerCase();
            if (!s2.endsWith(".nd") || !id.startsWith(files[i].substring(0, s2.lastIndexOf(".")))) continue;
            return 1;
        }
        return 2;
    }

    public String[] getUsedFiles() {
        return this.stks == null ? super.getUsedFiles() : this.stks[this.series];
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.stks == null || this.stks[this.series].length == 1) {
            return super.openBytes(no, buf);
        }
        int[] coords = FormatTools.getZCTCoords(this, no % this.core.sizeZ[this.series]);
        int ndx = no / this.core.sizeZ[this.series];
        String file = this.stks[this.series][ndx];
        if (this.r == null) {
            this.r = new MetamorphReader();
        }
        this.r.setId(file);
        return this.r.openBytes(coords[0], buf);
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (id.toLowerCase().endsWith(".nd")) {
            if (this.currentId != null) {
                String[] s2 = this.getUsedFiles();
                for (int i = 0; i < s2.length; ++i) {
                    if (!id.equals(s2[i])) continue;
                    return;
                }
            }
            this.close();
            this.currentId = id;
            this.metadata = new Hashtable();
            this.core = new CoreMetadata(1);
            Arrays.fill(this.core.orderCertain, true);
            this.getMetadataStore().createRoot();
            String stkFile = id.substring(0, id.lastIndexOf("."));
            Location parent = new Location(id).getAbsoluteFile().getParentFile();
            String[] dirList = parent.list();
            for (int i = 0; i < dirList.length; ++i) {
                String s3 = dirList[i].toLowerCase();
                if (!s3.endsWith(".stk") || dirList[i].indexOf(stkFile.substring(stkFile.lastIndexOf(File.separator) + 1) + "_w") == -1) continue;
                stkFile = new Location(parent.getPath(), dirList[i]).getAbsolutePath();
                break;
            }
            super.initFile(stkFile);
        } else {
            super.initFile(id);
        }
        Location ndfile = null;
        if (id.toLowerCase().endsWith(".nd")) {
            ndfile = new Location(id);
        }
        if (ndfile != null && ndfile.exists() && (this.fileGroupOption(id) == 0 || this.isGroupFiles())) {
            RandomAccessStream ndStream = new RandomAccessStream(ndfile.getAbsolutePath());
            String line = ndStream.readLine().trim();
            while (!line.equals("\"EndFile\"")) {
                String key = line.substring(1, line.indexOf(",") - 1).trim();
                String value = line.substring(line.indexOf(",") + 1).trim();
                this.addMeta(key, value);
                line = ndStream.readLine().trim();
            }
            String z = (String)this.getMeta("NZSteps");
            String c = (String)this.getMeta("NWavelengths");
            String t = (String)this.getMeta("NTimePoints");
            int zc = this.core.sizeZ[0];
            int cc = this.core.sizeC[0];
            int tc = this.core.sizeT[0];
            if (z != null) {
                zc = Integer.parseInt(z);
            }
            if (c != null) {
                cc = Integer.parseInt(c);
            }
            if (t != null) {
                tc = Integer.parseInt(t);
            }
            int numFiles = cc * tc;
            boolean[] hasZ = new boolean[cc];
            int seriesCount = 1;
            for (int i = 0; i < cc; ++i) {
                hasZ[i] = ((String)this.getMeta("WaveDoZ" + (i + 1))).equals("TRUE");
                if (i <= 0 || hasZ[i] == hasZ[i - 1]) continue;
                seriesCount = 2;
            }
            int channelsInFirstSeries = cc;
            if (seriesCount == 2) {
                channelsInFirstSeries = 0;
                for (int i = 0; i < cc; ++i) {
                    if (!hasZ[i]) continue;
                    ++channelsInFirstSeries;
                }
            }
            this.stks = new String[seriesCount][];
            if (seriesCount == 1) {
                this.stks[0] = new String[numFiles];
            } else {
                this.stks[0] = new String[channelsInFirstSeries * tc];
                this.stks[1] = new String[(cc - channelsInFirstSeries) * tc];
            }
            String prefix = ndfile.getPath();
            prefix = prefix.substring(prefix.lastIndexOf(File.separator) + 1, prefix.lastIndexOf("."));
            int[] pt = new int[seriesCount];
            for (int i = 0; i < tc; ++i) {
                for (int j = 0; j < cc; ++j) {
                    int seriesNdx;
                    String chName = (String)this.getMeta("WaveName" + (j + 1));
                    chName = chName.substring(1, chName.length() - 1);
                    int n = seriesNdx = seriesCount == 1 ? 0 : (hasZ[j] ? 0 : 1);
                    int n2 = pt[n];
                    pt[n] = n2 + 1;
                    this.stks[seriesNdx][n2] = prefix + "_w" + (j + 1) + chName + "_t" + (i + 1) + ".STK";
                }
            }
            ndfile = ndfile.getAbsoluteFile();
            for (int s4 = 0; s4 < this.stks.length; ++s4) {
                for (int f = 0; f < this.stks[s4].length; ++f) {
                    Location l = new Location(ndfile.getParent(), this.stks[s4][f]);
                    if (!l.exists()) {
                        if (this.stks[s4][f].indexOf("%") != -1) {
                            this.stks[s4][f] = this.stks[s4][f].replaceAll("%", "-");
                            l = new Location(ndfile.getParent(), this.stks[s4][f]);
                            if (!l.exists()) {
                                this.stks[s4][f] = this.stks[s4][f].substring(0, this.stks[s4][f].lastIndexOf(".")) + ".TIF";
                                l = new Location(ndfile.getParent(), this.stks[s4][f]);
                                if (!l.exists()) {
                                    this.stks = null;
                                    return;
                                }
                            }
                        }
                        if (!l.exists()) {
                            this.stks[s4][f] = this.stks[s4][f].substring(0, this.stks[s4][f].lastIndexOf(".")) + ".TIF";
                            l = new Location(ndfile.getParent(), this.stks[s4][f]);
                            if (!l.exists()) {
                                this.stks = null;
                                return;
                            }
                        }
                    }
                    this.stks[s4][f] = l.getAbsolutePath();
                }
            }
            this.core.sizeZ[0] = zc;
            this.core.sizeC[0] = cc;
            this.core.sizeT[0] = tc;
            this.core.imageCount[0] = zc * tc * cc;
            this.core.currentOrder[0] = "XYZCT";
            if (this.stks.length > 1) {
                CoreMetadata newCore = new CoreMetadata(this.stks.length);
                for (int i = 0; i < this.stks.length; ++i) {
                    newCore.sizeX[i] = this.core.sizeX[0];
                    newCore.sizeY[i] = this.core.sizeY[0];
                    newCore.sizeZ[i] = this.core.sizeZ[0];
                    newCore.sizeC[i] = this.core.sizeC[0];
                    newCore.sizeT[i] = this.core.sizeT[0];
                    newCore.pixelType[i] = this.core.pixelType[0];
                    newCore.imageCount[i] = this.core.imageCount[0];
                    newCore.currentOrder[i] = this.core.currentOrder[0];
                    newCore.rgb[i] = this.core.rgb[0];
                    newCore.littleEndian[i] = this.core.littleEndian[0];
                    newCore.interleaved[i] = this.core.interleaved[0];
                    newCore.orderCertain[i] = true;
                }
                newCore.sizeC[0] = this.stks[0].length / newCore.sizeT[0];
                newCore.sizeC[1] = this.stks[1].length / newCore.sizeT[1];
                newCore.sizeZ[1] = 1;
                newCore.imageCount[0] = newCore.sizeC[0] * newCore.sizeT[0] * newCore.sizeZ[0];
                newCore.imageCount[1] = newCore.sizeC[1] * newCore.sizeT[1];
                this.core = newCore;
            }
        }
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        block28: {
            block27: {
                super.initStandardMetadata();
                try {
                    int planes;
                    TiffIFDEntry uic1tagEntry = TiffTools.getFirstIFDEntry(this.in, 33628);
                    TiffIFDEntry uic2tagEntry = TiffTools.getFirstIFDEntry(this.in, 33629);
                    TiffIFDEntry uic4tagEntry = TiffTools.getFirstIFDEntry(this.in, 33631);
                    this.mmPlanes = planes = uic4tagEntry.getValueCount();
                    this.parseUIC2Tags(uic2tagEntry.getValueOffset());
                    this.parseUIC4Tags(uic4tagEntry.getValueOffset());
                    this.parseUIC1Tags(uic1tagEntry.getValueOffset(), uic1tagEntry.getValueCount());
                    this.in.seek(uic4tagEntry.getValueOffset());
                    long[] uic2 = TiffTools.getIFDLongArray(this.ifds[0], 33629, true);
                    this.core.imageCount[0] = uic2.length;
                    long[] uic3 = TiffTools.getIFDLongArray(this.ifds[0], 33630, true);
                    for (int i = 0; i < uic3.length; ++i) {
                        this.in.seek(uic3[i]);
                        this.put("Wavelength [" + MetamorphReader.intFormatMax(i, this.mmPlanes) + "]", this.in.readLong() / this.in.readLong());
                    }
                    Hashtable[] tempIFDs = new Hashtable[this.core.imageCount[0]];
                    long[] oldOffsets = TiffTools.getIFDLongArray(this.ifds[0], 273, true);
                    long[] stripByteCounts = TiffTools.getIFDLongArray(this.ifds[0], 279, true);
                    int stripsPerImage = oldOffsets.length;
                    int check = TiffTools.getIFDIntValue(this.ifds[0], 262);
                    if (check == 3) {
                        TiffTools.putIFDValue(this.ifds[0], 262, 1);
                    }
                    this.emWavelength = TiffTools.getIFDLongArray(this.ifds[0], 33630, true);
                    int pointer = 0;
                    for (int i = 0; i < this.core.imageCount[0]; ++i) {
                        Hashtable<Integer, Object> temp = new Hashtable<Integer, Object>();
                        temp.put(new Integer(0), this.ifds[0].get(new Integer(0)));
                        temp.put(new Integer(256), this.ifds[0].get(new Integer(256)));
                        temp.put(new Integer(257), this.ifds[0].get(new Integer(257)));
                        temp.put(new Integer(258), this.ifds[0].get(new Integer(258)));
                        temp.put(new Integer(259), this.ifds[0].get(new Integer(259)));
                        temp.put(new Integer(262), this.ifds[0].get(new Integer(262)));
                        temp.put(new Integer(279), this.ifds[0].get(new Integer(279)));
                        temp.put(new Integer(278), this.ifds[0].get(new Integer(278)));
                        temp.put(new Integer(282), this.ifds[0].get(new Integer(282)));
                        temp.put(new Integer(283), this.ifds[0].get(new Integer(283)));
                        temp.put(new Integer(296), this.ifds[0].get(new Integer(296)));
                        temp.put(new Integer(317), this.ifds[0].get(new Integer(317)));
                        long planeOffset = (long)i * (oldOffsets[stripsPerImage - 1] + stripByteCounts[stripsPerImage - 1] - oldOffsets[0]);
                        long[] newOffsets = new long[oldOffsets.length];
                        newOffsets[0] = planeOffset + oldOffsets[0];
                        for (int j = 1; j < newOffsets.length; ++j) {
                            newOffsets[j] = newOffsets[j - 1] + stripByteCounts[0];
                        }
                        temp.put(new Integer(273), newOffsets);
                        tempIFDs[pointer] = temp;
                        ++pointer;
                    }
                    this.ifds = tempIFDs;
                }
                catch (UnknownTagException exc) {
                    this.trace(exc);
                }
                catch (NullPointerException exc) {
                    this.trace(exc);
                }
                catch (IOException exc) {
                    this.trace(exc);
                }
                catch (FormatException exc) {
                    this.trace(exc);
                }
                try {
                    super.initStandardMetadata();
                }
                catch (FormatException exc) {
                    if (debug) {
                        this.trace(exc);
                    }
                }
                catch (IOException exc) {
                    if (!debug) break block27;
                    this.trace(exc);
                }
            }
            String descr = (String)this.getMeta("Comment");
            if (descr != null) {
                StringTokenizer st = new StringTokenizer(descr, "\n");
                StringBuffer sb = new StringBuffer();
                boolean first = true;
                while (st.hasMoreTokens()) {
                    String line = st.nextToken();
                    int colon = line.indexOf(": ");
                    if (colon < 0) {
                        if (line.trim().length() > 0) {
                            sb.append(line);
                            if (!line.endsWith(".")) {
                                sb.append(".");
                            }
                            sb.append("  ");
                        }
                        first = false;
                        continue;
                    }
                    if (first) {
                        int dot = line.lastIndexOf(".", colon);
                        if (dot >= 0) {
                            String s2 = line.substring(0, dot + 1);
                            sb.append(s2);
                            if (!s2.endsWith(".")) {
                                sb.append(".");
                            }
                            sb.append("  ");
                        }
                        line = line.substring(dot + 1);
                        colon -= dot + 1;
                        first = false;
                    }
                    String key = line.substring(0, colon);
                    String value = line.substring(colon + 2);
                    this.put(key, value);
                }
                descr = sb.toString().trim();
                if (descr.equals("")) {
                    this.metadata.remove("Comment");
                } else {
                    this.put("Comment", descr);
                }
            }
            try {
                if (this.core.sizeZ[0] == 0) {
                    this.core.sizeZ[0] = TiffTools.getIFDLongArray(this.ifds[0], 33629, true).length;
                }
                if (this.core.sizeT[0] == 0) {
                    this.core.sizeT[0] = this.getImageCount() / this.core.sizeZ[0];
                }
            }
            catch (FormatException exc) {
                if (!debug) break block28;
                this.trace(exc);
            }
        }
    }

    protected String getImageName() {
        if (this.imageName == null) {
            return super.getImageName();
        }
        return this.imageName;
    }

    protected String getImageCreationDate() {
        if (this.imageCreationDate == null) {
            return super.getImageCreationDate();
        }
        return this.imageCreationDate;
    }

    Integer getEmWave(int i) {
        if (this.emWavelength == null || this.emWavelength[i] == 0L) {
            return null;
        }
        return new Integer((int)this.emWavelength[i]);
    }

    void parseUIC2Tags(long uic2offset) throws IOException {
        long saveLoc = this.in.getFilePointer();
        this.in.seek(uic2offset);
        for (int i = 0; i < this.mmPlanes; ++i) {
            String iAsString = MetamorphReader.intFormatMax(i, this.mmPlanes);
            int num = this.in.readInt();
            int den = this.in.readInt();
            double zDistance = (double)num / (double)den;
            this.put("zDistance[" + iAsString + "]", zDistance);
            int cDate = this.in.readInt();
            this.put("creationDate[" + iAsString + "]", MetamorphReader.decodeDate(cDate));
            int cTime = this.in.readInt();
            this.put("creationTime[" + iAsString + "]", MetamorphReader.decodeTime(cTime));
            this.in.skip(8L);
        }
        this.in.seek(saveLoc);
    }

    private void parseUIC4Tags(long uic4offset) throws IOException {
        long saveLoc = this.in.getFilePointer();
        this.in.seek(uic4offset);
        boolean end = false;
        block8: while (!end) {
            short id = this.in.readShort();
            switch (id) {
                case 0: {
                    end = true;
                    continue block8;
                }
                case 28: {
                    this.readStagePositions();
                    continue block8;
                }
                case 29: {
                    this.readCameraChipOffsets();
                    continue block8;
                }
                case 37: {
                    this.readStageLabels();
                    continue block8;
                }
                case 40: {
                    this.readAbsoluteZ();
                    continue block8;
                }
                case 41: {
                    this.readAbsoluteZValid();
                    continue block8;
                }
            }
        }
        this.in.seek(saveLoc);
    }

    void readStagePositions() throws IOException {
        for (int i = 0; i < this.mmPlanes; ++i) {
            int nx = this.in.readInt();
            int dx = this.in.readInt();
            int ny = this.in.readInt();
            int dy = this.in.readInt();
            double xPosition = dx == 0 ? Double.NaN : (double)nx / (double)dx;
            double yPosition = dy == 0 ? Double.NaN : (double)ny / (double)dy;
            String iAsString = MetamorphReader.intFormatMax(i, this.mmPlanes);
            this.put("stageX[" + iAsString + "]", xPosition);
            this.put("stageY[" + iAsString + "]", yPosition);
        }
    }

    void readCameraChipOffsets() throws IOException {
        for (int i = 0; i < this.mmPlanes; ++i) {
            String iAsString = MetamorphReader.intFormatMax(i, this.mmPlanes);
            int nx = this.in.readInt();
            int dx = this.in.readInt();
            int ny = this.in.readInt();
            int dy = this.in.readInt();
            double cameraXChipOffset = dx == 0 ? Double.NaN : (double)nx / (double)dx;
            double cameraYChipOffset = dy == 0 ? Double.NaN : (double)ny / (double)dy;
            this.put("cameraXChipOffset[" + iAsString + "]", cameraXChipOffset);
            this.put("cameraYChipOffset[" + iAsString + "]", cameraYChipOffset);
        }
    }

    void readStageLabels() throws IOException {
        for (int i = 0; i < this.mmPlanes; ++i) {
            String iAsString = MetamorphReader.intFormatMax(i, this.mmPlanes);
            int strlen = this.in.readInt();
            byte[] curlabel = new byte[strlen];
            this.in.read(curlabel);
            this.put("stageLabel[" + iAsString + "]", new String(curlabel));
        }
    }

    void readAbsoluteZ() throws IOException {
        for (int i = 0; i < this.mmPlanes; ++i) {
            int nz = this.in.readInt();
            int dz = this.in.readInt();
            double absoluteZ = dz == 0 ? Double.NaN : (double)nz / (double)dz;
            this.put("absoluteZ[" + MetamorphReader.intFormatMax(i, this.mmPlanes) + "]", absoluteZ);
        }
    }

    void readAbsoluteZValid() throws IOException {
        for (int i = 0; i < this.mmPlanes; ++i) {
            this.put("absoluteZValid[" + MetamorphReader.intFormatMax(i, this.mmPlanes) + "]", this.in.readInt());
        }
    }

    private void parseUIC1Tags(long uic1offset, int uic1count) throws IOException {
        long saveLoc = this.in.getFilePointer();
        this.in.seek(uic1offset);
        block50: for (int i = 0; i < uic1count; ++i) {
            int currentID = this.in.readInt();
            int valOrOffset = this.in.readInt();
            switch (currentID) {
                case 1: {
                    this.put("MinScale", valOrOffset);
                    continue block50;
                }
                case 2: {
                    this.put("MaxScale", valOrOffset);
                    continue block50;
                }
                case 3: {
                    int calib = valOrOffset;
                    String calibration = calib != 0 ? "on" : "off";
                    this.put("Spatial Calibration", calibration);
                    continue block50;
                }
                case 4: {
                    long lastOffset = this.in.getFilePointer();
                    this.in.seek(valOrOffset);
                    int num = this.in.readInt();
                    int denom = this.in.readInt();
                    this.put("XCalibration", new TiffRational(num, denom));
                    this.in.seek(lastOffset);
                    continue block50;
                }
                case 5: {
                    long lastOffset = this.in.getFilePointer();
                    this.in.seek(valOrOffset);
                    int num = this.in.readInt();
                    int denom = this.in.readInt();
                    this.put("YCalibration", new TiffRational(num, denom));
                    this.in.seek(lastOffset);
                    continue block50;
                }
                case 6: {
                    long lastOffset = this.in.getFilePointer();
                    this.in.seek(valOrOffset);
                    int num = this.in.readInt();
                    byte[] toread = new byte[num];
                    this.in.read(toread);
                    this.put("CalibrationUnits", new String(toread));
                    this.in.seek(lastOffset);
                    continue block50;
                }
                case 7: {
                    long lastOffset = this.in.getFilePointer();
                    this.in.seek(valOrOffset);
                    int num = this.in.readInt();
                    byte[] toread = new byte[num];
                    this.in.read(toread);
                    String name = new String(toread);
                    this.put("Name", name);
                    this.imageName = name;
                    this.in.seek(lastOffset);
                    continue block50;
                }
                case 8: {
                    int thresh = valOrOffset;
                    String threshState = "off";
                    if (thresh == 1) {
                        threshState = "inside";
                    } else if (thresh == 2) {
                        threshState = "outside";
                    }
                    this.put("ThreshState", threshState);
                    continue block50;
                }
                case 9: {
                    this.put("ThreshStateRed", valOrOffset);
                    continue block50;
                }
                case 11: {
                    this.put("ThreshStateGreen", valOrOffset);
                    continue block50;
                }
                case 12: {
                    this.put("ThreshStateBlue", valOrOffset);
                    continue block50;
                }
                case 13: {
                    this.put("ThreshStateLo", valOrOffset);
                    continue block50;
                }
                case 14: {
                    this.put("ThreshStateHi", valOrOffset);
                    continue block50;
                }
                case 15: {
                    int zoom = valOrOffset;
                    this.put("Zoom", zoom);
                    continue block50;
                }
                case 16: {
                    long lastOffset = this.in.getFilePointer();
                    this.in.seek(valOrOffset);
                    String thedate = MetamorphReader.decodeDate(this.in.readInt());
                    String thetime = MetamorphReader.decodeTime(this.in.readInt());
                    this.put("DateTime", thedate + " " + thetime);
                    this.imageCreationDate = thedate + " " + thetime;
                    this.in.seek(lastOffset);
                    continue block50;
                }
                case 17: {
                    long lastOffset = this.in.getFilePointer();
                    this.in.seek(valOrOffset);
                    String thedate = MetamorphReader.decodeDate(this.in.readInt());
                    String thetime = MetamorphReader.decodeTime(this.in.readInt());
                    this.put("LastSavedTime", thedate + " " + thetime);
                    this.in.seek(lastOffset);
                    continue block50;
                }
                case 18: {
                    this.put("currentBuffer", valOrOffset);
                    continue block50;
                }
                case 19: {
                    this.put("grayFit", valOrOffset);
                    continue block50;
                }
                case 20: {
                    this.put("grayPointCount", valOrOffset);
                    continue block50;
                }
                case 21: {
                    long lastOffset = this.in.getFilePointer();
                    this.in.seek(valOrOffset);
                    int num = this.in.readInt();
                    int denom = this.in.readInt();
                    this.put("grayX", new TiffRational(num, denom));
                    this.in.seek(lastOffset);
                    continue block50;
                }
                case 22: {
                    long lastOffset = this.in.getFilePointer();
                    this.in.seek(valOrOffset);
                    int num = this.in.readInt();
                    int denom = this.in.readInt();
                    this.put("gray", new TiffRational(num, denom));
                    this.in.seek(lastOffset);
                    continue block50;
                }
                case 23: {
                    long lastOffset = this.in.getFilePointer();
                    this.in.seek(valOrOffset);
                    int num = this.in.readInt();
                    int denom = this.in.readInt();
                    this.put("grayMin", new TiffRational(num, denom));
                    this.in.seek(lastOffset);
                    continue block50;
                }
                case 24: {
                    long lastOffset = this.in.getFilePointer();
                    this.in.seek(valOrOffset);
                    int num = this.in.readInt();
                    int denom = this.in.readInt();
                    this.put("grayMax", new TiffRational(num, denom));
                    this.in.seek(lastOffset);
                    continue block50;
                }
                case 25: {
                    long lastOffset = this.in.getFilePointer();
                    this.in.seek(valOrOffset);
                    int num = this.in.readInt();
                    byte[] toread = new byte[num];
                    this.in.read(toread);
                    this.put("grayUnitName", new String(toread));
                    this.in.seek(lastOffset);
                    continue block50;
                }
                case 26: {
                    String standLUT;
                    long lastOffset = this.in.getFilePointer();
                    this.in.seek(valOrOffset);
                    int standardLUT = this.in.readInt();
                    this.in.seek(lastOffset);
                    switch (standardLUT) {
                        case 0: {
                            standLUT = "monochrome";
                            break;
                        }
                        case 1: {
                            standLUT = "pseudocolor";
                            break;
                        }
                        case 2: {
                            standLUT = "Red";
                            break;
                        }
                        case 3: {
                            standLUT = "Green";
                            break;
                        }
                        case 4: {
                            standLUT = "Blue";
                            break;
                        }
                        case 5: {
                            standLUT = "user-defined";
                            break;
                        }
                        default: {
                            standLUT = "monochrome";
                        }
                    }
                    this.put("StandardLUT", standLUT);
                    continue block50;
                }
                case 27: {
                    this.put("Wavelength", valOrOffset);
                    continue block50;
                }
                case 30: {
                    this.put("OverlayMask", valOrOffset);
                    continue block50;
                }
                case 31: {
                    this.put("OverlayCompress", valOrOffset);
                    continue block50;
                }
                case 32: {
                    this.put("Overlay", valOrOffset);
                    continue block50;
                }
                case 33: {
                    this.put("SpecialOverlayMask", valOrOffset);
                    continue block50;
                }
                case 34: {
                    this.put("SpecialOverlayCompress", this.in.readInt());
                    continue block50;
                }
                case 35: {
                    this.put("SpecialOverlay", valOrOffset);
                    continue block50;
                }
                case 36: {
                    this.put("ImageProperty", valOrOffset);
                    continue block50;
                }
                case 38: {
                    long lastOffset = this.in.getFilePointer();
                    this.in.seek(valOrOffset);
                    int num = this.in.readInt();
                    int denom = this.in.readInt();
                    this.put("AutoScaleLoInfo", new TiffRational(num, denom));
                    this.in.seek(lastOffset);
                    continue block50;
                }
                case 39: {
                    long lastOffset = this.in.getFilePointer();
                    this.in.seek(valOrOffset);
                    int num = this.in.readInt();
                    int denom = this.in.readInt();
                    this.put("AutoScaleHiInfo", new TiffRational(num, denom));
                    this.in.seek(lastOffset);
                    continue block50;
                }
                case 42: {
                    this.put("Gamma", valOrOffset);
                    continue block50;
                }
                case 43: {
                    this.put("GammaRed", valOrOffset);
                    continue block50;
                }
                case 44: {
                    this.put("GammaGreen", valOrOffset);
                    continue block50;
                }
                case 45: {
                    this.put("GammaBlue", valOrOffset);
                    continue block50;
                }
                case 46: {
                    long lastOffset = this.in.getFilePointer();
                    this.in.seek(valOrOffset);
                    int xBin = this.in.readInt();
                    int yBin = this.in.readInt();
                    this.put("CameraBin", new String("(" + xBin + "," + yBin + ")"));
                    this.in.seek(lastOffset);
                    continue block50;
                }
            }
        }
        this.in.seek(saveLoc);
    }

    public static String decodeDate(int julian) {
        long a;
        long z = julian + 1;
        if (z < 2299161L) {
            a = z;
        } else {
            long alpha = (long)(((double)z - 1867216.25) / 36524.25);
            a = z + 1L + alpha - alpha / 4L;
        }
        long b = a > 1721423L ? a + 1524L : a + 1158L;
        long c = (long)(((double)b - 122.1) / 365.25);
        long d = (long)(365.25 * (double)c);
        long e = (long)((double)(b - d) / 30.6001);
        short day = (short)(b - d - (long)(30.6001 * (double)e));
        short month = (short)((double)e < 13.5 ? e - 1L : e - 13L);
        short year = (short)((double)month > 2.5 ? c - 4716L : c - 4715L);
        return day + "/" + month + "/" + year;
    }

    public static String decodeTime(int millis) {
        int ms = millis % 1000;
        millis -= ms;
        int seconds = (millis /= 1000) % 60;
        millis -= seconds;
        int minutes = (millis /= 60) % 60;
        millis -= minutes;
        int hours = millis /= 60;
        return MetamorphReader.intFormat(hours, 2) + ":" + MetamorphReader.intFormat(minutes, 2) + ":" + MetamorphReader.intFormat(seconds, 2) + "." + MetamorphReader.intFormat(ms, 3);
    }

    public static String intFormat(int myint, int digits) {
        String formatstring = "0";
        while (formatstring.length() < digits) {
            formatstring = formatstring + "0";
        }
        DecimalFormat df = new DecimalFormat(formatstring);
        return df.format(myint);
    }

    public static String intFormatMax(int myint, int maxint) {
        return MetamorphReader.intFormat(myint, new Integer(maxint).toString().length());
    }
}

