/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import loci.formats.CoreMetadata;
import loci.formats.DataTools;
import loci.formats.DummyMetadata;
import loci.formats.FormatException;
import loci.formats.FormatHandler;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageTools;
import loci.formats.IndexedColorModel;
import loci.formats.Location;
import loci.formats.MetadataStore;
import loci.formats.MetadataTools;
import loci.formats.RandomAccessStream;

public abstract class FormatReader
extends FormatHandler
implements IFormatReader {
    protected static final int THUMBNAIL_DIMENSION = 128;
    protected RandomAccessStream in;
    protected Hashtable metadata;
    protected int series = 0;
    protected CoreMetadata core;
    protected boolean normalizeData;
    protected boolean filterMetadata;
    protected boolean collectMetadata = true;
    protected boolean saveOriginalMetadata = false;
    protected boolean group = true;
    protected MetadataStore metadataStore = new DummyMetadata();

    public FormatReader(String format, String suffix) {
        super(format, suffix);
    }

    public FormatReader(String format, String[] suffixes) {
        super(format, suffixes);
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (this.currentId != null) {
            String[] s2 = this.getUsedFiles();
            for (int i = 0; i < s2.length; ++i) {
                if (!id.equals(s2[i])) continue;
                return;
            }
        }
        this.series = 0;
        this.close();
        this.currentId = id;
        this.metadata = new Hashtable();
        this.core = new CoreMetadata(1);
        Arrays.fill(this.core.orderCertain, true);
        this.getMetadataStore().createRoot();
    }

    protected boolean checkBytes(String name, int maxLen) {
        try {
            RandomAccessStream ras = new RandomAccessStream(name);
            long len = ras.length();
            byte[] buf = new byte[len < (long)maxLen ? (int)len : maxLen];
            ras.readFully(buf);
            ras.close();
            return this.isThisType(buf);
        }
        catch (IOException exc) {
            return false;
        }
    }

    protected boolean isUsedFile(String file) {
        String[] usedFiles = this.getUsedFiles();
        for (int i = 0; i < usedFiles.length; ++i) {
            if (!usedFiles[i].equals(file) && !usedFiles[i].equals(new Location(file).getAbsolutePath())) continue;
            return true;
        }
        return false;
    }

    protected void addMeta(String key, Object value) {
        MetadataStore store;
        if (key == null || value == null || !this.collectMetadata) {
            return;
        }
        if (this.filterMetadata) {
            if (key.length() == 0) {
                return;
            }
            String val = value.toString();
            if (val.length() == 0) {
                return;
            }
            if (key.charAt(0) < ' ') {
                return;
            }
            if (val.charAt(0) < ' ') {
                return;
            }
            if (!key.matches(".*[a-zA-Z].*")) {
                return;
            }
        }
        if (this.saveOriginalMetadata && MetadataTools.isOMEXMLMetadata(store = this.getMetadataStore())) {
            MetadataTools.populateOriginalMetadata(store, key, value.toString());
        }
        this.metadata.put(key, value);
    }

    protected Object getMeta(String key) {
        return this.metadata.get(key);
    }

    public int getImageCount() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core.imageCount[this.series];
    }

    public boolean isRGB() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core.rgb[this.series];
    }

    public int getSizeX() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core.sizeX[this.series];
    }

    public int getSizeY() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core.sizeY[this.series];
    }

    public int getSizeZ() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core.sizeZ[this.series];
    }

    public int getSizeC() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core.sizeC[this.series];
    }

    public int getSizeT() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core.sizeT[this.series];
    }

    public int getPixelType() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core.pixelType[this.series];
    }

    public int getEffectiveSizeC() {
        return this.getImageCount() / (this.getSizeZ() * this.getSizeT());
    }

    public int getRGBChannelCount() {
        return this.getSizeC() / this.getEffectiveSizeC();
    }

    public boolean isIndexed() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core.indexed[this.series];
    }

    public boolean isFalseColor() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core.falseColor[this.series];
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        return null;
    }

    public short[][] get16BitLookupTable() throws FormatException, IOException {
        return null;
    }

    public int[] getChannelDimLengths() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.core.cLengths[this.series] == null) {
            this.core.cLengths[this.series] = new int[]{this.core.sizeC[this.series]};
        }
        return this.core.cLengths[this.series];
    }

    public String[] getChannelDimTypes() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.core.cTypes[this.series] == null) {
            this.core.cTypes[this.series] = new String[]{"Channel"};
        }
        return this.core.cTypes[this.series];
    }

    public int getThumbSizeX() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.core.thumbSizeX[this.series] == 0) {
            int sx = this.getSizeX();
            int sy = this.getSizeY();
            this.core.thumbSizeX[this.series] = sx > sy ? 128 : sx * 128 / sy;
        }
        return this.core.thumbSizeX[this.series];
    }

    public int getThumbSizeY() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.core.thumbSizeY[this.series] == 0) {
            int sx = this.getSizeX();
            int sy = this.getSizeY();
            this.core.thumbSizeY[this.series] = sy > sx ? 128 : sy * 128 / sx;
        }
        return this.core.thumbSizeY[this.series];
    }

    public boolean isLittleEndian() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core.littleEndian[this.series];
    }

    public String getDimensionOrder() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core.currentOrder[this.series];
    }

    public boolean isOrderCertain() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core.orderCertain[this.series];
    }

    public boolean isInterleaved() {
        return this.isInterleaved(0);
    }

    public boolean isInterleaved(int subC) {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core.interleaved[this.series];
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        byte[] buf = new byte[this.getSizeX() * this.getSizeY() * this.getRGBChannelCount() * FormatTools.getBytesPerPixel(this.getPixelType())];
        return this.openBytes(no, buf);
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        byte[] buf = this.openBytes(no);
        if (this.getPixelType() == 6) {
            float[] f = (float[])DataTools.makeDataArray(buf, 4, true, this.isLittleEndian());
            if (this.normalizeData) {
                f = DataTools.normalizeFloats(f);
            }
            return ImageTools.makeImage(f, this.core.sizeX[this.series], this.core.sizeY[this.series], this.getRGBChannelCount(), true);
        }
        BufferedImage b = ImageTools.makeImage(buf, this.core.sizeX[this.series], this.core.sizeY[this.series], this.isIndexed() ? 1 : this.getRGBChannelCount(), this.core.interleaved[0], FormatTools.getBytesPerPixel(this.core.pixelType[this.series]), this.core.littleEndian[this.series]);
        if (this.isIndexed()) {
            Object table;
            IndexedColorModel model = null;
            if (this.core.pixelType[this.series] == 1 || this.core.pixelType[this.series] == 0) {
                table = this.get8BitLookupTable();
                model = new IndexedColorModel(8, table[0].length, (byte[][])table);
            } else if (this.core.pixelType[this.series] == 3 || this.core.pixelType[this.series] == 2) {
                table = this.get16BitLookupTable();
                model = new IndexedColorModel(16, table[0].length, (short[][])table);
            }
            if (model != null) {
                WritableRaster raster = Raster.createWritableRaster(b.getSampleModel(), b.getData().getDataBuffer(), null);
                b = new BufferedImage(model, raster, false, null);
            }
        }
        return b;
    }

    public BufferedImage openThumbImage(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return ImageTools.scale(this.openImage(no), this.getThumbSizeX(), this.getThumbSizeY(), false);
    }

    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        BufferedImage img = this.openThumbImage(no);
        byte[][] bytes = ImageTools.getPixelBytes(img, this.core.littleEndian[this.series]);
        if (bytes.length == 1) {
            return bytes[0];
        }
        byte[] rtn = new byte[this.getRGBChannelCount() * bytes[0].length];
        for (int i = 0; i < this.getRGBChannelCount(); ++i) {
            System.arraycopy(bytes[i], 0, rtn, bytes[0].length * i, bytes[i].length);
        }
        return rtn;
    }

    public void close(boolean fileOnly) throws IOException {
        if (fileOnly) {
            if (this.in != null) {
                this.in.close();
            }
        } else {
            this.close();
        }
    }

    public int getSeriesCount() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core.sizeX.length;
    }

    public void setSeries(int no) {
        if (no < 0 || no >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Invalid series: " + no);
        }
        this.series = no;
    }

    public int getSeries() {
        return this.series;
    }

    public void setGroupFiles(boolean groupFiles) {
        FormatTools.assertId(this.currentId, false, 1);
        this.group = groupFiles;
    }

    public boolean isGroupFiles() {
        return this.group;
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 2;
    }

    public boolean isMetadataComplete() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core.metadataComplete[this.series];
    }

    public void setNormalized(boolean normalize) {
        FormatTools.assertId(this.currentId, false, 1);
        this.normalizeData = normalize;
    }

    public boolean isNormalized() {
        return this.normalizeData;
    }

    public void setMetadataCollected(boolean collect) {
        FormatTools.assertId(this.currentId, false, 1);
        this.collectMetadata = collect;
    }

    public boolean isMetadataCollected() {
        return this.collectMetadata;
    }

    public void setOriginalMetadataPopulated(boolean populate) {
        FormatTools.assertId(this.currentId, false, 1);
        this.saveOriginalMetadata = populate;
    }

    public boolean isOriginalMetadataPopulated() {
        return this.saveOriginalMetadata;
    }

    public String[] getUsedFiles() {
        FormatTools.assertId(this.currentId, true, 1);
        return new String[]{this.currentId};
    }

    public String getCurrentFile() {
        return this.currentId == null ? "" : this.currentId;
    }

    public int getIndex(int z, int c, int t) {
        FormatTools.assertId(this.currentId, true, 1);
        return FormatTools.getIndex(this, z, c, t);
    }

    public int[] getZCTCoords(int index) {
        FormatTools.assertId(this.currentId, true, 1);
        return FormatTools.getZCTCoords(this, index);
    }

    public Object getMetadataValue(String field) {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getMeta(field);
    }

    public Hashtable getMetadata() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.metadata;
    }

    public CoreMetadata getCoreMetadata() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core;
    }

    public void setMetadataFiltered(boolean filter) {
        FormatTools.assertId(this.currentId, false, 1);
        this.filterMetadata = filter;
    }

    public boolean isMetadataFiltered() {
        return this.filterMetadata;
    }

    public void setMetadataStore(MetadataStore store) {
        FormatTools.assertId(this.currentId, false, 1);
        if (store == null) {
            throw new IllegalArgumentException("Metadata object is null");
        }
        this.metadataStore = store;
    }

    public MetadataStore getMetadataStore() {
        return this.metadataStore;
    }

    public Object getMetadataStoreRoot() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getMetadataStore().getRoot();
    }

    public void setId(String id, boolean force) throws FormatException, IOException {
        if (!id.equals(this.currentId) || force) {
            this.initFile(id);
        }
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        this.in = null;
        this.currentId = null;
    }

    public int getImageCount(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getImageCount();
    }

    public boolean isRGB(String id) throws FormatException, IOException {
        return this.getRGBChannelCount(id) > 1;
    }

    public int getSizeX(String id) throws FormatException, IOException {
        this.setId(id);
        return this.core.sizeX[this.series];
    }

    public int getSizeY(String id) throws FormatException, IOException {
        this.setId(id);
        return this.core.sizeY[this.series];
    }

    public int getSizeZ(String id) throws FormatException, IOException {
        this.setId(id);
        return this.core.sizeZ[this.series];
    }

    public int getSizeC(String id) throws FormatException, IOException {
        this.setId(id);
        return this.core.sizeC[this.series];
    }

    public int getSizeT(String id) throws FormatException, IOException {
        this.setId(id);
        return this.core.sizeT[this.series];
    }

    public int getPixelType(String id) throws FormatException, IOException {
        this.setId(id);
        return this.core.pixelType[this.series];
    }

    public int getEffectiveSizeC(String id) throws FormatException, IOException {
        return this.getImageCount(id) / (this.getSizeZ(id) * this.getSizeT(id));
    }

    public int getRGBChannelCount(String id) throws FormatException, IOException {
        return this.getSizeC(id) / this.getEffectiveSizeC(id);
    }

    public int[] getChannelDimLengths(String id) throws FormatException, IOException {
        this.setId(id);
        if (this.core.cLengths[this.series] == null) {
            this.core.cLengths[this.series] = new int[]{this.core.sizeC[this.series]};
        }
        return this.core.cLengths[this.series];
    }

    public String[] getChannelDimTypes(String id) throws FormatException, IOException {
        this.setId(id);
        if (this.core.cTypes[this.series] == null) {
            this.core.cTypes[this.series] = new String[]{"Channel"};
        }
        return this.core.cTypes[this.series];
    }

    public int getThumbSizeX(String id) throws FormatException, IOException {
        int sy;
        int sx = this.getSizeX(id);
        return sx > (sy = this.getSizeY(id)) ? 128 : sx * 128 / sy;
    }

    public int getThumbSizeY(String id) throws FormatException, IOException {
        int sx = this.getSizeX(id);
        int sy = this.getSizeY(id);
        return sy > sx ? 128 : sy * 128 / sx;
    }

    public boolean isLittleEndian(String id) throws FormatException, IOException {
        this.setId(id);
        return this.isLittleEndian();
    }

    public String getDimensionOrder(String id) throws FormatException, IOException {
        this.setId(id);
        return this.core.currentOrder[this.series];
    }

    public boolean isOrderCertain(String id) throws FormatException, IOException {
        this.setId(id);
        return this.core.orderCertain[this.series];
    }

    public boolean isInterleaved(String id) throws FormatException, IOException {
        return this.isInterleaved(id, 0);
    }

    public boolean isInterleaved(String id, int subC) throws FormatException, IOException {
        this.setId(id);
        return this.isInterleaved(subC);
    }

    public BufferedImage openImage(String id, int no) throws FormatException, IOException {
        this.setId(id);
        return this.openImage(no);
    }

    public byte[] openBytes(String id, int no) throws FormatException, IOException {
        this.setId(id);
        return this.openBytes(no);
    }

    public byte[] openBytes(String id, int no, byte[] buf) throws FormatException, IOException {
        return this.openBytes(id, no);
    }

    public BufferedImage openThumbImage(String id, int no) throws FormatException, IOException {
        return ImageTools.scale(this.openImage(id, no), this.getThumbSizeX(id), this.getThumbSizeY(id), false);
    }

    public byte[] openThumbBytes(String id, int no) throws FormatException, IOException {
        BufferedImage img = this.openThumbImage(id, no);
        byte[][] bytes = ImageTools.getBytes(img);
        if (bytes.length == 1) {
            return bytes[0];
        }
        byte[] rtn = new byte[this.getRGBChannelCount(id) * bytes[0].length];
        for (int i = 0; i < this.getRGBChannelCount(id); ++i) {
            System.arraycopy(bytes[i], 0, rtn, bytes[0].length * i, bytes[i].length);
        }
        return rtn;
    }

    public int getSeriesCount(String id) throws FormatException, IOException {
        this.setId(id);
        return 1;
    }

    public void setSeries(String id, int no) throws FormatException, IOException {
        if (no < 0 || no >= this.getSeriesCount(id)) {
            throw new FormatException("Invalid series: " + no);
        }
        this.series = no;
    }

    public int getSeries(String id) throws FormatException, IOException {
        this.setId(id);
        return this.series;
    }

    public String[] getUsedFiles(String id) throws FormatException, IOException {
        this.setId(id);
        return new String[]{id};
    }

    public int getIndex(String id, int z, int c, int t) throws FormatException, IOException {
        this.setId(id);
        return FormatTools.getIndex(this, z, c, t);
    }

    public int[] getZCTCoords(String id, int index) throws FormatException, IOException {
        this.setId(id);
        return FormatTools.getZCTCoords(this, index);
    }

    public Object getMetadataValue(String id, String field) throws FormatException, IOException {
        this.setId(id);
        return this.getMeta(field);
    }

    public Hashtable getMetadata(String id) throws FormatException, IOException {
        this.setId(id);
        return this.metadata;
    }

    public CoreMetadata getCoreMetadata(String id) throws FormatException, IOException {
        this.setId(id);
        return this.core;
    }

    public MetadataStore getMetadataStore(String id) throws FormatException, IOException {
        this.setId(id);
        return this.metadataStore;
    }

    public Object getMetadataStoreRoot(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getMetadataStore().getRoot();
    }
}

