/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;

public class ThreadPool {
    private static final String DEFAULT_PREFIX = ThreadPool.class.toString();
    private final ThreadPoolExecutor exec;
    private final Collection<Future<?>> bagOfFutures = new ConcurrentLinkedQueue();
    private final Object mutex = new Object();
    private static final int PROCESSORS = Runtime.getRuntime().availableProcessors() + 1;
    private final String prefix;

    public ThreadPool() throws Exception {
        this(DEFAULT_PREFIX, 0, PROCESSORS);
    }

    public ThreadPool(String prefix) throws Exception {
        this(prefix, 0, PROCESSORS);
    }

    public ThreadPool(int max) throws Exception {
        this(DEFAULT_PREFIX, 0, max);
    }

    public ThreadPool(int min, int max) throws Exception {
        this(DEFAULT_PREFIX, min, max);
    }

    public ThreadPool(String prefix, int min, int max) throws Exception {
        this.prefix = prefix;
        this.exec = (ThreadPoolExecutor)Executors.newFixedThreadPool(max);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTaskCount() {
        Object object = this.mutex;
        synchronized (object) {
            for (Future<?> f : this.bagOfFutures) {
                if (!f.isDone()) continue;
                this.bagOfFutures.remove(f);
            }
            return this.bagOfFutures.size();
        }
    }

    public void remove(Runnable r) {
        this.exec.remove(r);
    }

    public boolean isTerminated() {
        return this.exec.isTerminated();
    }

    public void printPool() {
        System.err.println("Busy Tasks:");
        for (Future<?> f : this.bagOfFutures) {
            if (f.isDone()) continue;
            System.out.println(f.toString());
        }
        System.err.println("Completed Tasks:");
        for (Future<?> f : this.bagOfFutures) {
            if (!f.isDone()) continue;
            System.out.println(f.toString());
        }
    }

    public void queue(Runnable r) {
        Future<?> submit = this.exec.submit(r);
        this.bagOfFutures.add(submit);
        for (Future<?> f : this.bagOfFutures) {
            if (!f.isDone()) continue;
            this.bagOfFutures.remove(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForTasks() {
        Object object = this.mutex;
        synchronized (object) {
            for (Future<?> f : this.bagOfFutures) {
                try {
                    f.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException executionException) {}
            }
            this.bagOfFutures.clear();
        }
        return true;
    }

    public void setThreadMaximum(int num) throws Exception {
        this.exec.setCorePoolSize(num);
    }

    public void stopThreads() {
        this.exec.shutdown();
    }
}

