/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import Jama.LUDecomposition;
import Jama.Matrix;
import java.util.Arrays;
import visad.util.Interpolator;

public class CubicInterpolator
implements Interpolator {
    private LUDecomposition solver;
    private double[][] solution = null;
    private double x0 = 0.0;
    private double x1 = 0.0;
    private double x2 = 0.0;
    private double x0_last = 0.0;
    private double x0_save;
    private float[] values0 = null;
    private float[] values1 = null;
    private float[] values2 = null;
    private float[] values0_last = null;
    private float[] values0_save = null;
    private int numSpatialPts = 1;
    private boolean[] needed = null;
    private boolean[] computed = null;

    public CubicInterpolator(int numSpatialPts) {
        this.numSpatialPts = numSpatialPts;
        this.solution = new double[4][numSpatialPts];
        this.needed = new boolean[numSpatialPts];
        this.computed = new boolean[numSpatialPts];
        Arrays.fill(this.needed, false);
        Arrays.fill(this.computed, false);
    }

    private void buildSolver() {
        double x0_p3 = this.x0 * this.x0 * this.x0;
        double x1_p3 = this.x1 * this.x1 * this.x1;
        double x0_p2 = this.x0 * this.x0;
        double x1_p2 = this.x1 * this.x1;
        Matrix coeffs = new Matrix(new double[][]{{x0_p3, x0_p2, this.x0, 1.0}, {x1_p3, x1_p2, this.x1, 1.0}, {3.0 * x0_p2, 2.0 * this.x0, 1.0, 0.0}, {3.0 * x1_p2, 2.0 * this.x1, 1.0, 0.0}}, 4, 4);
        this.solver = new LUDecomposition(coeffs);
    }

    @Override
    public void interpolate(double xt, float[] interpValues) {
        Arrays.fill(interpValues, Float.NaN);
        for (int k = 0; k < this.numSpatialPts; ++k) {
            if (!this.computed[k]) continue;
            interpValues[k] = (float)CubicInterpolator.cubic_poly(xt, this.solution[0][k], this.solution[1][k], this.solution[2][k], this.solution[3][k]);
        }
    }

    @Override
    public void next(double x0, double x1, double x2, float[] values0, float[] values1, float[] values2) {
        this.x0 = x0;
        this.x1 = x1;
        this.x2 = x2;
        this.values0 = values0;
        this.values1 = values1;
        this.values2 = values2;
        this.x0_last = this.x0_save;
        this.x0_save = x0;
        this.values0_last = this.values0_save;
        this.values0_save = values0;
        Arrays.fill(this.computed, false);
        this.buildSolver();
    }

    @Override
    public void update(boolean[] needed) {
        Arrays.fill(this.needed, false);
        for (int k = 0; k < this.numSpatialPts; ++k) {
            if (!needed[k] || this.computed[k]) continue;
            this.needed[k] = true;
        }
        this.getSolution();
    }

    private void getSolution() {
        for (int k = 0; k < this.numSpatialPts; ++k) {
            if (!this.needed[k]) continue;
            double D1_1 = Double.NaN;
            double D1_0 = Double.NaN;
            double y0 = this.values0[k];
            double y1 = this.values1[k];
            D1_0 = this.values0_last == null ? (double)(this.values1[k] - this.values0[k]) / (this.x1 - this.x0) : (double)(this.values1[k] - this.values0_last[k]) / (this.x1 - this.x0_last);
            D1_1 = (double)(this.values2[k] - this.values0[k]) / (this.x2 - this.x0);
            double[] sol = this.getSolution(y0, y1, D1_0, D1_1);
            this.solution[0][k] = sol[0];
            this.solution[1][k] = sol[1];
            this.solution[2][k] = sol[2];
            this.solution[3][k] = sol[3];
            this.computed[k] = true;
        }
    }

    private double[] getSolution(double y0, double y1, double D1_0, double D1_1) {
        Matrix constants = new Matrix(new double[][]{{y0}, {y1}, {D1_0}, {D1_1}}, 4, 1);
        double[][] solution = this.solver.solve(constants).getArray();
        return new double[]{solution[0][0], solution[1][0], solution[2][0], solution[3][0]};
    }

    public static double cubic_poly_D1(double x, double a, double b, double c) {
        return 3.0 * a * x * x + 2.0 * b * x + c;
    }

    public static double cubic_poly(double x, double a, double b, double c, double d) {
        return a * x * x * x + b * x * x + c * x + d;
    }
}

