/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;
import visad.util.ColorChangeEvent;
import visad.util.ColorChangeListener;
import visad.util.ColorMap;
import visad.util.ColorWidget;

public class ColorPreview
extends JPanel
implements ColorChangeListener {
    private ColorMap map;
    private int height = 15;
    private float updateLeft;
    private float updateRight;

    ColorPreview(ColorWidget widget) {
        this(widget, 15);
    }

    public ColorPreview(ColorWidget widget, int height) {
        this(widget.getColorMap(), height);
    }

    ColorPreview(ColorMap map) {
        this(map, 15);
    }

    public ColorPreview(ColorMap map, int height) {
        this.map = map;
        this.height = height;
        map.addColorChangeListener(this);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, this.height);
    }

    @Override
    public void paint(Graphics g) {
        this.updateLeft = 0.0f;
        this.updateRight = 1.0f;
        this.update(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Graphics g) {
        float fWidth;
        Color[] c;
        int num;
        int rightIndex;
        int leftIndex;
        ColorPreview colorPreview = this;
        synchronized (colorPreview) {
            leftIndex = (int)Math.floor(this.updateLeft * (float)this.getBounds().width);
            rightIndex = (int)Math.floor(this.updateRight * (float)this.getBounds().width);
            this.updateLeft = 1.0f;
            this.updateRight = 0.0f;
        }
        if (leftIndex > rightIndex) {
            int tmp = leftIndex;
            leftIndex = rightIndex;
            rightIndex = tmp;
        }
        if (leftIndex < 0) {
            leftIndex = 0;
        }
        if (leftIndex >= this.getBounds().width) {
            leftIndex = this.getBounds().width - 1;
        }
        if (rightIndex < 0) {
            rightIndex = 0;
        }
        if (rightIndex >= this.getBounds().width) {
            rightIndex = this.getBounds().width - 1;
        }
        if ((num = rightIndex - leftIndex + 1) > (c = this.map.getColors((float)leftIndex / (fWidth = (float)this.getBounds().width), (float)rightIndex / fWidth, num)).length) {
            num = c.length;
        }
        for (int i = 0; i < num; ++i) {
            g.setColor(c[i]);
            g.drawLine(i + leftIndex, 0, i + leftIndex, this.getBounds().height - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void colorChanged(ColorChangeEvent e) {
        ColorPreview colorPreview = this;
        synchronized (colorPreview) {
            if (e.getStart() < this.updateLeft) {
                this.updateLeft = e.getStart();
            }
            if (e.getEnd() > this.updateRight) {
                this.updateRight = e.getEnd();
            }
        }
        this.validate();
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = this.map.getPreferredSize();
        return new Dimension(d.width, this.height);
    }

    public void setMap(ColorMap newMap) {
        this.map.removeColorChangeListener(this);
        newMap.addColorChangeListener(this);
        this.map = newMap;
    }
}

