/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import java.rmi.RemoteException;
import visad.Control;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.GraphicsModeControl;
import visad.VisADException;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.util.Util;

public class GraphicsModeControlJ3D
extends GraphicsModeControl {
    static final int[] LINE_PATTERN = new int[]{0, 1, 2, 3};
    private float lineWidth = 1.0f;
    private float pointSize = 1.0f;
    private int lineStyle = 0;
    private int colorMode;
    private boolean pointMode = false;
    private boolean textureEnable = true;
    private boolean scaleEnable = false;
    private int transparencyMode = 0;
    private int projectionPolicy = 1;
    private boolean anti_alias_flag = false;
    private int polygonMode = 2;
    private float polygonOffset = Float.NaN;
    private float polygonOffsetFactor = 0.0f;
    private boolean missingTransparent = true;
    private int curvedSize = 10;
    private boolean adjustProjectionSeam = true;
    private int texture3DMode = 0;
    private boolean cacheAppearances = false;
    private boolean mergeGeometries = false;
    private boolean depthBufferEnable = true;
    private boolean autoDepthOffsetEnable = false;
    private float depthOffsetInc = -2.0f;
    private int maxNumWithOffset = 6;

    public GraphicsModeControlJ3D(DisplayImpl d) {
        super(d);
        DisplayRendererJ3D displayRenderer = (DisplayRendererJ3D)this.getDisplayRenderer();
        if (displayRenderer != null && displayRenderer.getMode2D()) {
            this.projectionPolicy = 0;
            displayRenderer.getView().setProjectionPolicy(this.projectionPolicy);
        }
    }

    @Override
    public boolean getMode2D() {
        return this.getDisplayRenderer().getMode2D();
    }

    @Override
    public float getLineWidth() {
        return this.lineWidth;
    }

    @Override
    public void setLineWidth(float width) throws VisADException, RemoteException {
        if (width < 1.0f) {
            width = 1.0f;
        }
        if (Util.isApproximatelyEqual(this.lineWidth, width)) {
            return;
        }
        this.lineWidth = width;
        DisplayRendererJ3D dr = (DisplayRendererJ3D)this.getDisplayRenderer();
        dr.setLineWidth(width);
        this.changeControl(true);
        this.getDisplay().reDisplayAll();
    }

    @Override
    public void setLineWidth(float width, boolean noChange) {
        if (width < 1.0f) {
            width = 1.0f;
        }
        this.lineWidth = width;
    }

    @Override
    public float getPointSize() {
        return this.pointSize;
    }

    @Override
    public void setPointSize(float size) throws VisADException, RemoteException {
        if (size < 1.0f) {
            size = 1.0f;
        }
        if (Util.isApproximatelyEqual(size, this.pointSize)) {
            return;
        }
        this.pointSize = size;
        this.changeControl(true);
        this.getDisplay().reDisplayAll();
    }

    @Override
    public void setPointSize(float size, boolean noChange) {
        if (size < 1.0f) {
            size = 1.0f;
        }
        this.pointSize = size;
    }

    @Override
    public int getLineStyle() {
        return this.lineStyle;
    }

    @Override
    public void setLineStyle(int style) throws VisADException, RemoteException {
        if (style == this.lineStyle) {
            return;
        }
        if (style != 0 && style != 1 && style != 2 && style != 3) {
            style = 0;
        }
        this.lineStyle = style;
        this.changeControl(true);
        this.getDisplay().reDisplayAll();
    }

    @Override
    public void setLineStyle(int style, boolean noChange) {
        if (style != 0 && style != 1 && style != 2 && style != 3) {
            style = 0;
        }
        this.lineStyle = style;
    }

    @Override
    public int getColorMode() {
        return this.colorMode;
    }

    @Override
    public void setColorMode(int mode) throws VisADException, RemoteException {
        if (mode != 0 && mode != 1) {
            mode = 0;
        }
        if (mode == this.colorMode) {
            return;
        }
        this.colorMode = mode;
        this.changeControl(true);
        this.getDisplay().reDisplayAll();
    }

    @Override
    public boolean getPointMode() {
        return this.pointMode;
    }

    @Override
    public void setPointMode(boolean mode) throws VisADException, RemoteException {
        if (mode == this.pointMode) {
            return;
        }
        this.pointMode = mode;
        this.changeControl(true);
        this.getDisplay().reDisplayAll();
    }

    @Override
    public void setTextureEnable(boolean enable) throws VisADException, RemoteException {
        if (enable == this.textureEnable) {
            return;
        }
        this.textureEnable = enable;
        this.changeControl(true);
        this.getDisplay().reDisplayAll();
    }

    @Override
    public boolean getTextureEnable() {
        return this.textureEnable;
    }

    @Override
    public void setScaleEnable(boolean enable) throws VisADException, RemoteException {
        if (enable == this.scaleEnable) {
            return;
        }
        this.scaleEnable = enable;
        this.getDisplayRenderer().setScaleOn(enable);
        this.changeControl(true);
    }

    @Override
    public boolean getScaleEnable() {
        return this.scaleEnable;
    }

    @Override
    public int getTransparencyMode() {
        return this.transparencyMode;
    }

    @Override
    public void setTransparencyMode(int mode) throws VisADException, RemoteException {
        if (mode == this.transparencyMode) {
            return;
        }
        if (mode != 3 && mode != 2 && mode != 4 && mode != 0 && mode != 1) {
            throw new DisplayException("GraphicsModeControlJ3D.setTransparencyMode: bad mode");
        }
        this.transparencyMode = mode;
        this.changeControl(true);
        this.getDisplay().reDisplayAll();
    }

    @Override
    public void setProjectionPolicy(int policy) throws VisADException, RemoteException {
        if (policy == this.projectionPolicy) {
            return;
        }
        if (policy == 0 || policy == 1) {
            this.projectionPolicy = policy;
            DisplayRendererJ3D displayRenderer = (DisplayRendererJ3D)this.getDisplayRenderer();
            if (displayRenderer != null) {
                displayRenderer.getView().setProjectionPolicy(this.projectionPolicy);
            }
        } else {
            throw new DisplayException("GraphicsModeControlJ3D.setProjectionPolicy: bad policy");
        }
        this.changeControl(true);
        this.getDisplay().reDisplayAll();
    }

    @Override
    public int getProjectionPolicy() {
        return this.projectionPolicy;
    }

    public void setSceneAntialiasingEnable(boolean flag) throws VisADException, RemoteException {
        if (flag == this.anti_alias_flag) {
            return;
        }
        this.anti_alias_flag = flag;
        DisplayRendererJ3D displayRenderer = (DisplayRendererJ3D)this.getDisplayRenderer();
        if (displayRenderer != null) {
            displayRenderer.getView().setSceneAntialiasingEnable(this.anti_alias_flag);
        }
        this.changeControl(true);
        this.getDisplay().reDisplayAll();
    }

    public boolean getSceneAntialiasingEnable() {
        return this.anti_alias_flag;
    }

    @Override
    public void setPolygonMode(int mode) throws VisADException, RemoteException {
        if (mode == this.polygonMode) {
            return;
        }
        if (mode != 2 && mode != 1 && mode != 0) {
            throw new DisplayException("GraphicsModeControlJ3D.setPolygonMode: bad mode");
        }
        this.polygonMode = mode;
        this.changeControl(true);
        this.getDisplay().reDisplayAll();
    }

    @Override
    public void setPolygonMode(int mode, boolean noChange) throws VisADException, RemoteException {
        if (mode == this.polygonMode) {
            return;
        }
        if (mode == 2 || mode == 1 || mode == 0) {
            this.polygonMode = mode;
        }
    }

    @Override
    public int getPolygonMode() {
        return this.polygonMode;
    }

    @Override
    public void setPolygonOffset(float polygonOffset) throws VisADException, RemoteException {
        if (Float.isNaN(polygonOffset)) {
            return;
        }
        if (Util.isApproximatelyEqual(this.polygonOffset, polygonOffset)) {
            return;
        }
        this.polygonOffset = polygonOffset;
        this.changeControl(true);
        this.getDisplay().reDisplayAll();
    }

    @Override
    public void setPolygonOffset(float polygonOffset, boolean noChange) {
        this.polygonOffset = polygonOffset;
    }

    @Override
    public float getPolygonOffset() {
        return this.polygonOffset;
    }

    @Override
    public void setPolygonOffsetFactor(float polygonOffsetFactor) throws VisADException, RemoteException {
        if (Float.isNaN(polygonOffsetFactor)) {
            return;
        }
        if (Util.isApproximatelyEqual(this.polygonOffsetFactor, polygonOffsetFactor)) {
            return;
        }
        this.polygonOffsetFactor = polygonOffsetFactor;
        this.changeControl(true);
        this.getDisplay().reDisplayAll();
    }

    @Override
    public void setPolygonOffsetFactor(float polygonOffsetFactor, boolean noChange) {
        this.polygonOffsetFactor = polygonOffsetFactor;
    }

    @Override
    public float getPolygonOffsetFactor() {
        return this.polygonOffsetFactor;
    }

    public void setDepthBufferEnable(boolean enable) throws VisADException, RemoteException {
        this.depthBufferEnable = enable;
        this.changeControl(true);
        this.getDisplay().reDisplayAll();
    }

    public void setDepthBufferEnable(boolean enable, boolean noChange) {
        this.depthBufferEnable = enable;
    }

    public boolean getDepthBufferEnable() {
        return this.depthBufferEnable;
    }

    public void setAutoDepthOffsetEnable(boolean enable) throws VisADException, RemoteException {
        this.autoDepthOffsetEnable = enable;
        ((DisplayImplJ3D)this.getDisplay()).resetDepthBufferOffsets();
        this.changeControl(true);
        this.getDisplay().reDisplayAll();
    }

    public void setAutoDepthOffsetEnable(boolean enable, boolean noChange) throws VisADException, RemoteException {
        this.autoDepthOffsetEnable = enable;
    }

    public boolean getAutoDepthOffsetEnable() {
        return this.autoDepthOffsetEnable;
    }

    public void setNumRenderersWithDepthOffset(int numWith, boolean noChange) throws VisADException, RemoteException {
        this.maxNumWithOffset = numWith;
        if (!noChange) {
            ((DisplayImplJ3D)this.getDisplay()).resetDepthBufferOffsets();
            this.changeControl(true);
            this.getDisplay().reDisplayAll();
        }
    }

    public int getNumRenderersWithDepthOffset() {
        return this.maxNumWithOffset;
    }

    public void setDepthOffsetIncrement(float inc, boolean noChange) throws VisADException, RemoteException {
        this.depthOffsetInc = inc;
        if (!noChange) {
            ((DisplayImplJ3D)this.getDisplay()).resetDepthBufferOffsets();
            this.changeControl(true);
            this.getDisplay().reDisplayAll();
        }
    }

    public float getDepthOffsetIncrement() {
        return this.depthOffsetInc;
    }

    @Override
    public boolean getMissingTransparent() {
        return this.missingTransparent;
    }

    @Override
    public void setMissingTransparent(boolean missing) {
        this.missingTransparent = missing;
    }

    @Override
    public int getCurvedSize() {
        return this.curvedSize;
    }

    @Override
    public void setCurvedSize(int curved_size) {
        this.curvedSize = curved_size;
    }

    @Override
    public boolean getAdjustProjectionSeam() {
        return this.adjustProjectionSeam;
    }

    @Override
    public void setAdjustProjectionSeam(boolean adjust) throws VisADException, RemoteException {
        if (this.adjustProjectionSeam == adjust) {
            return;
        }
        this.adjustProjectionSeam = adjust;
        this.changeControl(true);
        this.getDisplay().reDisplayAll();
    }

    @Override
    public void setTexture3DMode(int mode) throws VisADException, RemoteException {
        if (this.texture3DMode == mode) {
            return;
        }
        this.texture3DMode = mode;
        this.changeControl(true);
        this.getDisplay().reDisplayAll();
    }

    @Override
    public int getTexture3DMode() {
        return this.texture3DMode;
    }

    @Override
    public void setCacheAppearances(boolean cache) {
        this.cacheAppearances = cache;
    }

    @Override
    public boolean getCacheAppearances() {
        return this.cacheAppearances;
    }

    @Override
    public void setMergeGeometries(boolean merge) {
        this.mergeGeometries = merge;
    }

    @Override
    public boolean getMergeGeometries() {
        return this.mergeGeometries;
    }

    @Override
    public Object clone() {
        GraphicsModeControlJ3D mode = new GraphicsModeControlJ3D(this.getDisplay());
        mode.lineWidth = this.lineWidth;
        mode.pointSize = this.pointSize;
        mode.pointMode = this.pointMode;
        mode.textureEnable = this.textureEnable;
        mode.scaleEnable = this.scaleEnable;
        mode.transparencyMode = this.transparencyMode;
        mode.projectionPolicy = this.projectionPolicy;
        mode.missingTransparent = this.missingTransparent;
        mode.polygonMode = this.polygonMode;
        mode.polygonOffset = this.polygonOffset;
        mode.polygonOffsetFactor = this.polygonOffsetFactor;
        mode.curvedSize = this.curvedSize;
        mode.lineStyle = this.lineStyle;
        mode.anti_alias_flag = this.anti_alias_flag;
        mode.adjustProjectionSeam = this.adjustProjectionSeam;
        mode.texture3DMode = this.texture3DMode;
        mode.cacheAppearances = this.cacheAppearances;
        mode.mergeGeometries = this.mergeGeometries;
        mode.depthBufferEnable = this.depthBufferEnable;
        mode.autoDepthOffsetEnable = this.autoDepthOffsetEnable;
        mode.depthOffsetInc = this.depthOffsetInc;
        mode.maxNumWithOffset = this.maxNumWithOffset;
        return mode;
    }

    @Override
    public void syncControl(Control rmt) throws VisADException {
        if (rmt == null) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with null Control object");
        }
        if (!(rmt instanceof GraphicsModeControlJ3D)) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with " + rmt.getClass().getName());
        }
        GraphicsModeControlJ3D rmtCtl = (GraphicsModeControlJ3D)rmt;
        boolean changed = false;
        boolean redisplay = false;
        if (!Util.isApproximatelyEqual(this.lineWidth, rmtCtl.lineWidth)) {
            changed = true;
            redisplay = true;
            this.lineWidth = rmtCtl.lineWidth;
        }
        if (!Util.isApproximatelyEqual(this.pointSize, rmtCtl.pointSize)) {
            changed = true;
            redisplay = true;
            this.pointSize = rmtCtl.pointSize;
        }
        if (this.pointMode != rmtCtl.pointMode) {
            changed = true;
            redisplay = true;
            this.pointMode = rmtCtl.pointMode;
        }
        if (this.textureEnable != rmtCtl.textureEnable) {
            changed = true;
            redisplay = true;
            this.textureEnable = rmtCtl.textureEnable;
        }
        if (this.scaleEnable != rmtCtl.scaleEnable) {
            changed = true;
            this.getDisplayRenderer().setScaleOn(this.scaleEnable);
            this.scaleEnable = rmtCtl.scaleEnable;
        }
        if (this.transparencyMode != rmtCtl.transparencyMode) {
            changed = true;
            redisplay = true;
            this.transparencyMode = rmtCtl.transparencyMode;
        }
        if (this.adjustProjectionSeam != rmtCtl.adjustProjectionSeam) {
            changed = true;
            redisplay = true;
            this.adjustProjectionSeam = rmtCtl.adjustProjectionSeam;
        }
        if (this.texture3DMode != rmtCtl.texture3DMode) {
            changed = true;
            redisplay = true;
            this.texture3DMode = rmtCtl.texture3DMode;
        }
        if (this.cacheAppearances != rmtCtl.cacheAppearances) {
            changed = true;
            this.cacheAppearances = rmtCtl.cacheAppearances;
        }
        if (this.mergeGeometries != rmtCtl.mergeGeometries) {
            changed = true;
            this.mergeGeometries = rmtCtl.mergeGeometries;
        }
        if (this.projectionPolicy != rmtCtl.projectionPolicy) {
            changed = true;
            redisplay = true;
            this.projectionPolicy = rmtCtl.projectionPolicy;
            DisplayRendererJ3D displayRenderer = (DisplayRendererJ3D)this.getDisplayRenderer();
            if (displayRenderer != null) {
                displayRenderer.getView().setProjectionPolicy(this.projectionPolicy);
            }
        }
        if (this.polygonMode != rmtCtl.polygonMode) {
            changed = true;
            this.polygonMode = rmtCtl.polygonMode;
        }
        if (this.missingTransparent != rmtCtl.missingTransparent) {
            changed = true;
            this.missingTransparent = rmtCtl.missingTransparent;
        }
        if (this.curvedSize != rmtCtl.curvedSize) {
            changed = true;
            this.curvedSize = rmtCtl.curvedSize;
        }
        if (!Util.isApproximatelyEqual(this.polygonOffset, rmtCtl.polygonOffset)) {
            changed = true;
            this.polygonOffset = rmtCtl.polygonOffset;
        }
        if (!Util.isApproximatelyEqual(this.polygonOffsetFactor, rmtCtl.polygonOffsetFactor)) {
            changed = true;
            this.polygonOffsetFactor = rmtCtl.polygonOffsetFactor;
        }
        if (this.autoDepthOffsetEnable != rmtCtl.autoDepthOffsetEnable) {
            changed = true;
            this.autoDepthOffsetEnable = rmtCtl.autoDepthOffsetEnable;
        }
        if (!Util.isApproximatelyEqual(this.maxNumWithOffset, rmtCtl.maxNumWithOffset)) {
            changed = true;
            this.maxNumWithOffset = rmtCtl.maxNumWithOffset;
        }
        if (!Util.isApproximatelyEqual(this.depthOffsetInc, rmtCtl.depthOffsetInc)) {
            changed = true;
            this.depthOffsetInc = rmtCtl.depthOffsetInc;
        }
        if (this.anti_alias_flag != rmtCtl.anti_alias_flag) {
            changed = true;
            this.anti_alias_flag = rmtCtl.anti_alias_flag;
        }
        if (this.colorMode != rmtCtl.colorMode) {
            changed = true;
            this.colorMode = rmtCtl.colorMode;
        }
        if (this.lineStyle != rmtCtl.lineStyle) {
            changed = true;
            this.lineStyle = rmtCtl.lineStyle;
        }
        if (changed) {
            try {
                this.changeControl(true);
            }
            catch (RemoteException re) {
                throw new VisADException("Could not indicate that control changed: " + re.getMessage());
            }
        }
        if (redisplay) {
            this.getDisplay().reDisplayAll();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        GraphicsModeControlJ3D gmc = (GraphicsModeControlJ3D)o;
        boolean changed = false;
        if (!Util.isApproximatelyEqual(this.lineWidth, gmc.lineWidth)) {
            return false;
        }
        if (!Util.isApproximatelyEqual(this.pointSize, gmc.pointSize)) {
            return false;
        }
        if (this.pointMode != gmc.pointMode) {
            return false;
        }
        if (this.textureEnable != gmc.textureEnable) {
            return false;
        }
        if (this.scaleEnable != gmc.scaleEnable) {
            return false;
        }
        if (this.transparencyMode != gmc.transparencyMode) {
            return false;
        }
        if (this.projectionPolicy != gmc.projectionPolicy) {
            return false;
        }
        if (this.polygonMode != gmc.polygonMode) {
            return false;
        }
        if (this.missingTransparent != gmc.missingTransparent) {
            return false;
        }
        if (this.curvedSize != gmc.curvedSize) {
            return false;
        }
        if (this.anti_alias_flag != gmc.anti_alias_flag) {
            return false;
        }
        if (this.colorMode != this.colorMode) {
            return false;
        }
        if (this.lineStyle != this.lineStyle) {
            return false;
        }
        if (!Util.isApproximatelyEqual(this.polygonOffset, gmc.polygonOffset)) {
            return false;
        }
        if (!Util.isApproximatelyEqual(this.polygonOffsetFactor, gmc.polygonOffsetFactor)) {
            return false;
        }
        if (this.autoDepthOffsetEnable != gmc.autoDepthOffsetEnable) {
            return false;
        }
        if (!Util.isApproximatelyEqual(this.maxNumWithOffset, gmc.maxNumWithOffset)) {
            return false;
        }
        if (!Util.isApproximatelyEqual(this.depthOffsetInc, gmc.depthOffsetInc)) {
            return false;
        }
        if (this.adjustProjectionSeam != gmc.adjustProjectionSeam) {
            return false;
        }
        if (this.texture3DMode != gmc.texture3DMode) {
            return false;
        }
        if (this.cacheAppearances != gmc.cacheAppearances) {
            return false;
        }
        return this.mergeGeometries == gmc.mergeGeometries;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer("GraphicsModeControlJ3D[");
        buf.append("lw ");
        buf.append(this.lineWidth);
        buf.append(",ps ");
        buf.append(this.pointSize);
        buf.append(this.pointMode ? "pm" : "!pm");
        buf.append(this.textureEnable ? "te" : "!te");
        buf.append(this.scaleEnable ? "se" : "!se");
        buf.append(this.missingTransparent ? "mt" : "!mt");
        buf.append(",tm ");
        buf.append(this.transparencyMode);
        buf.append(",pp ");
        buf.append(this.projectionPolicy);
        buf.append(",pm ");
        buf.append(this.polygonMode);
        buf.append(",cm ");
        buf.append(this.colorMode);
        buf.append(",cs ");
        buf.append(this.curvedSize);
        buf.append(",po ");
        buf.append(this.polygonOffset);
        buf.append(",pof ");
        buf.append(this.polygonOffsetFactor);
        buf.append(this.adjustProjectionSeam ? "as" : "!as");
        buf.append(",t3dm ");
        buf.append(this.texture3DMode);
        buf.append(",ca ");
        buf.append(this.cacheAppearances);
        buf.append(",mg ");
        buf.append(this.mergeGeometries);
        buf.append(']');
        return buf.toString();
    }
}

