/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import com.sun.j3d.utils.applet.MainFrame;
import java.applet.Applet;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Vector;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.IndexedTriangleStripArray;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.PointArray;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Screen3D;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.TriangleStripArray;
import visad.DataRenderer;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayRenderer;
import visad.GraphicsModeControl;
import visad.MouseBehavior;
import visad.ProjectionControl;
import visad.RemoteDisplay;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADIndexedTriangleStripArray;
import visad.VisADLineArray;
import visad.VisADLineStripArray;
import visad.VisADPointArray;
import visad.VisADQuadArray;
import visad.VisADTriangleArray;
import visad.VisADTriangleStripArray;
import visad.java3d.DefaultDisplayRendererJ3D;
import visad.java3d.DisplayAppletJ3D;
import visad.java3d.DisplayPanelJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.GraphicsModeControlJ3D;
import visad.java3d.MouseBehaviorJ3D;
import visad.java3d.ProjectionControlJ3D;
import visad.java3d.TransformOnlyDisplayRendererJ3D;
import visad.java3d.UniverseBuilderJ3D;
import visad.java3d.VisADCanvasJ3D;

public class DisplayImplJ3D
extends DisplayImpl {
    public static final float BACK2D = -0.01f;
    public static final int PARALLEL_PROJECTION = 0;
    public static final int PERSPECTIVE_PROJECTION = 1;
    public static final int POLYGON_FILL = 2;
    public static final int POLYGON_LINE = 1;
    public static final int POLYGON_POINT = 0;
    public static final int NICEST = 1;
    public static final int FASTEST = 0;
    public static final int UNKNOWN = 0;
    public static final int JPANEL = 1;
    public static final int OFFSCREEN = 2;
    public static final int APPLETFRAME = 3;
    public static final int TRANSFORM_ONLY = 4;
    public static final String PROP_GEOMETRY_BY_REF = "visad.java3d.geometryByRef";
    public static final boolean GEOMETRY_BY_REF = Boolean.parseBoolean(System.getProperty("visad.java3d.geometryByRef", "true"));
    public static final String PROP_TEXTURE_NPOT = "visad.java3d.textureNpot";
    public static final boolean TEXTURE_NPOT = Boolean.parseBoolean(System.getProperty("visad.java3d.textureNpot", "false"));
    public static final String NO_ERASE_BACKGROUND = "visad.java3d.noerasebackground";
    private DisplayAppletJ3D applet = null;
    private ProjectionControlJ3D projection = null;
    private GraphicsModeControlJ3D mode = null;
    private int apiValue = 0;
    private UniverseBuilderJ3D universe = null;

    public DisplayImplJ3D(String name) throws VisADException, RemoteException {
        this(name, null, 1, null);
    }

    public DisplayImplJ3D(String name, DisplayRendererJ3D renderer) throws VisADException, RemoteException {
        this(name, renderer, 1, null);
    }

    public DisplayImplJ3D(String name, int api) throws VisADException, RemoteException {
        this(name, null, api, null);
    }

    public DisplayImplJ3D(String name, GraphicsConfiguration config) throws VisADException, RemoteException {
        this(name, null, 1, config);
    }

    public DisplayImplJ3D(String name, DisplayRendererJ3D renderer, int api) throws VisADException, RemoteException {
        this(name, renderer, api, null);
    }

    public DisplayImplJ3D(String name, DisplayRendererJ3D renderer, GraphicsConfiguration config) throws VisADException, RemoteException {
        this(name, renderer, 1, config);
    }

    public DisplayImplJ3D(String name, int api, GraphicsConfiguration config) throws VisADException, RemoteException {
        this(name, null, api, config);
    }

    public DisplayImplJ3D(String name, DisplayRendererJ3D renderer, int api, GraphicsConfiguration config) throws VisADException, RemoteException {
        this(name, renderer, api, config, null);
    }

    public DisplayImplJ3D(String name, DisplayRendererJ3D renderer, int api, GraphicsConfiguration config, VisADCanvasJ3D c) throws VisADException, RemoteException {
        super(name, (DisplayRenderer)renderer);
        this.initialize(api, config, c);
    }

    public DisplayImplJ3D(String name, int width, int height) throws VisADException, RemoteException {
        this(name, null, width, height);
    }

    public DisplayImplJ3D(String name, DisplayRendererJ3D renderer, int width, int height) throws VisADException, RemoteException {
        this(name, renderer, width, height, null);
    }

    public DisplayImplJ3D(String name, DisplayRendererJ3D renderer, int width, int height, VisADCanvasJ3D c) throws VisADException, RemoteException {
        super(name, (DisplayRenderer)renderer);
        this.initialize(2, null, width, height, c);
    }

    public DisplayImplJ3D(RemoteDisplay rmtDpy) throws VisADException, RemoteException {
        this(rmtDpy, null, rmtDpy.getDisplayAPI(), null);
    }

    public DisplayImplJ3D(RemoteDisplay rmtDpy, DisplayRendererJ3D renderer) throws VisADException, RemoteException {
        this(rmtDpy, renderer, rmtDpy.getDisplayAPI(), null);
    }

    public DisplayImplJ3D(RemoteDisplay rmtDpy, int api) throws VisADException, RemoteException {
        this(rmtDpy, null, api, null);
    }

    public DisplayImplJ3D(RemoteDisplay rmtDpy, GraphicsConfiguration config) throws VisADException, RemoteException {
        this(rmtDpy, null, rmtDpy.getDisplayAPI(), config);
    }

    public DisplayImplJ3D(RemoteDisplay rmtDpy, DisplayRendererJ3D renderer, int api) throws VisADException, RemoteException {
        this(rmtDpy, renderer, api, null);
    }

    public DisplayImplJ3D(RemoteDisplay rmtDpy, DisplayRendererJ3D renderer, GraphicsConfiguration config) throws VisADException, RemoteException {
        this(rmtDpy, renderer, rmtDpy.getDisplayAPI(), config);
    }

    public DisplayImplJ3D(RemoteDisplay rmtDpy, int api, GraphicsConfiguration config) throws VisADException, RemoteException {
        this(rmtDpy, null, api, config);
    }

    public DisplayImplJ3D(RemoteDisplay rmtDpy, DisplayRendererJ3D renderer, int api, GraphicsConfiguration config) throws VisADException, RemoteException {
        this(rmtDpy, renderer, api, config, null);
    }

    public DisplayImplJ3D(RemoteDisplay rmtDpy, DisplayRendererJ3D renderer, int api, GraphicsConfiguration config, VisADCanvasJ3D c) throws VisADException, RemoteException {
        super(rmtDpy, (DisplayRenderer)(renderer == null && api == 4 ? new TransformOnlyDisplayRendererJ3D() : renderer));
        this.initialize(api, config, c);
        this.syncRemoteData(rmtDpy);
    }

    private void initialize(int api, GraphicsConfiguration config) throws VisADException, RemoteException {
        this.initialize(api, config, -1, -1, null);
    }

    private void initialize(int api, GraphicsConfiguration config, VisADCanvasJ3D c) throws VisADException, RemoteException {
        this.initialize(api, config, -1, -1, c);
    }

    private void initialize(int api, GraphicsConfiguration config, int width, int height) throws VisADException, RemoteException {
        this.initialize(api, config, width, height, null);
    }

    private void initialize(int api, GraphicsConfiguration config, int width, int height, VisADCanvasJ3D c) throws VisADException, RemoteException {
        this.projection = new ProjectionControlJ3D(this);
        this.addControl(this.projection);
        if (api == 3) {
            this.applet = new DisplayAppletJ3D(this, config);
            MainFrame component = new MainFrame((Applet)this.applet, 256, 256);
            this.setComponent((Component)component);
            this.apiValue = api;
        } else if (api == 1) {
            DisplayPanelJ3D component = new DisplayPanelJ3D(this, config, c);
            this.setComponent(component);
            this.apiValue = api;
        } else if (api == 4) {
            if (!(this.getDisplayRenderer() instanceof TransformOnlyDisplayRendererJ3D)) {
                throw new DisplayException("must be TransformOnlyDisplayRendererJ3D for api = TRANSFORM_ONLY");
            }
            this.setComponent(null);
            this.apiValue = api;
        } else if (api == 2) {
            DisplayRendererJ3D renderer = (DisplayRendererJ3D)this.getDisplayRenderer();
            VisADCanvasJ3D canvas = c != null ? c : new VisADCanvasJ3D(renderer, width, height);
            this.universe = new UniverseBuilderJ3D(canvas);
            BranchGroup scene = renderer.createSceneGraph(this.universe.view, this.universe.vpTrans, canvas);
            this.universe.addBranchGraph(scene);
            this.setComponent(null);
            this.apiValue = api;
        } else {
            throw new DisplayException("DisplayImplJ3D: bad graphics API " + api);
        }
        if (api != 4) {
            this.projection.setAspect(new double[]{1.0, 1.0, 1.0});
            ((DisplayRendererJ3D)this.getDisplayRenderer()).getCanvas().setDisplay();
        }
        this.mode = new GraphicsModeControlJ3D(this);
        this.addControl(this.mode);
    }

    @Override
    protected DisplayRenderer getDefaultDisplayRenderer() {
        return new DefaultDisplayRendererJ3D();
    }

    public void setScreenAspect(double height, double width) {
        DisplayRendererJ3D dr = (DisplayRendererJ3D)this.getDisplayRenderer();
        Screen3D screen = dr.getCanvas().getScreen3D();
        screen.setPhysicalScreenHeight(height);
        screen.setPhysicalScreenWidth(width);
    }

    @Override
    public ProjectionControl getProjectionControl() {
        return this.projection;
    }

    @Override
    public GraphicsModeControl getGraphicsModeControl() {
        return this.mode;
    }

    public DisplayAppletJ3D getApplet() {
        return this.applet;
    }

    @Override
    public int getAPI() throws VisADException {
        return this.apiValue;
    }

    private void setGeometryCapabilities(GeometryArray array) {
        array.setCapability(2);
        array.setCapability(0);
        array.setCapability(8);
        array.setCapability(17);
        array.setCapability(4);
        array.setCapability(6);
    }

    public GeometryArray makeGeometry(VisADGeometryArray vga) throws VisADException {
        if (vga == null) {
            return null;
        }
        boolean mode2d = this.getDisplayRenderer().getMode2D();
        int vertexFormat = DisplayImplJ3D.makeFormat(vga);
        if (vga instanceof VisADIndexedTriangleStripArray) {
            VisADIndexedTriangleStripArray vgb = (VisADIndexedTriangleStripArray)vga;
            if (vga.vertexCount == 0) {
                return null;
            }
            IndexedTriangleStripArray array = new IndexedTriangleStripArray(vga.vertexCount, vertexFormat, vgb.indexCount, vgb.stripVertexCounts);
            this.setGeometryCapabilities((GeometryArray)array);
            this.basicGeometry(vga, (GeometryArray)array, mode2d);
            if (vga.coordinates != null) {
                array.setCoordinateIndices(0, vgb.indices);
            }
            if (vga.colors != null) {
                array.setColorIndices(0, vgb.indices);
            }
            if (vga.normals != null) {
                array.setNormalIndices(0, vgb.indices);
            }
            if (vga.texCoords != null) {
                array.setTextureCoordinateIndices(0, vgb.indices);
            }
            return array;
        }
        if (vga instanceof VisADTriangleStripArray) {
            VisADTriangleStripArray vgb = (VisADTriangleStripArray)vga;
            if (vga.vertexCount == 0) {
                return null;
            }
            TriangleStripArray array = new TriangleStripArray(vga.vertexCount, vertexFormat, vgb.stripVertexCounts);
            this.setGeometryCapabilities((GeometryArray)array);
            this.basicGeometry(vga, (GeometryArray)array, mode2d);
            return array;
        }
        if (vga instanceof VisADLineArray) {
            if (vga.vertexCount == 0) {
                return null;
            }
            LineArray array = new LineArray(vga.vertexCount, vertexFormat);
            this.setGeometryCapabilities((GeometryArray)array);
            this.basicGeometry(vga, (GeometryArray)array, false);
            return array;
        }
        if (vga instanceof VisADLineStripArray) {
            if (vga.vertexCount == 0) {
                return null;
            }
            VisADLineStripArray vgb = (VisADLineStripArray)vga;
            LineStripArray array = new LineStripArray(vga.vertexCount, vertexFormat, vgb.stripVertexCounts);
            this.setGeometryCapabilities((GeometryArray)array);
            this.basicGeometry(vga, (GeometryArray)array, false);
            return array;
        }
        if (vga instanceof VisADPointArray) {
            if (vga.vertexCount == 0) {
                return null;
            }
            PointArray array = new PointArray(vga.vertexCount, vertexFormat);
            this.setGeometryCapabilities((GeometryArray)array);
            this.basicGeometry(vga, (GeometryArray)array, false);
            return array;
        }
        if (vga instanceof VisADTriangleArray) {
            if (vga.vertexCount == 0) {
                return null;
            }
            TriangleArray array = new TriangleArray(vga.vertexCount, vertexFormat);
            this.setGeometryCapabilities((GeometryArray)array);
            this.basicGeometry(vga, (GeometryArray)array, mode2d);
            return array;
        }
        if (vga instanceof VisADQuadArray) {
            if (vga.vertexCount == 0) {
                return null;
            }
            QuadArray array = new QuadArray(vga.vertexCount, vertexFormat);
            this.setGeometryCapabilities((GeometryArray)array);
            this.basicGeometry(vga, (GeometryArray)array, mode2d);
            return array;
        }
        throw new DisplayException("DisplayImplJ3D.makeGeometry");
    }

    private void basicGeometry(VisADGeometryArray vga, GeometryArray array, boolean mode2d) {
        if (mode2d) {
            if (vga.coordinates != null) {
                int len = vga.coordinates.length;
                float[] coords = new float[len];
                System.arraycopy(vga.coordinates, 0, coords, 0, len);
                for (int i = 2; i < len; i += 3) {
                    coords[i] = -0.01f;
                }
                if (GEOMETRY_BY_REF) {
                    array.setCoordRefFloat(coords);
                } else {
                    array.setCoordinates(0, coords);
                }
            }
        } else if (vga.coordinates != null) {
            if (GEOMETRY_BY_REF) {
                array.setCoordRefFloat(vga.coordinates);
            } else {
                array.setCoordinates(0, vga.coordinates);
            }
        }
        if (vga.colors != null) {
            if (GEOMETRY_BY_REF) {
                array.setColorRefByte(vga.colors);
            } else {
                array.setColors(0, vga.colors);
            }
        }
        if (vga.normals != null) {
            if (GEOMETRY_BY_REF) {
                array.setNormalRefFloat(vga.normals);
            } else {
                array.setNormals(0, vga.normals);
            }
        }
        if (vga.texCoords != null) {
            if (GEOMETRY_BY_REF) {
                array.setTexCoordRefFloat(0, vga.texCoords);
            } else {
                array.setTextureCoordinates(0, vga.texCoords);
            }
        }
    }

    private static int makeFormat(VisADGeometryArray vga) {
        int format = 0;
        if (vga.coordinates != null) {
            format |= 1;
        }
        if (vga.colors != null) {
            format = vga.colors.length == 3 * vga.vertexCount ? (format |= 4) : (format |= 0xC);
        }
        if (vga.normals != null) {
            format |= 2;
        }
        if (vga.texCoords != null) {
            format = vga.texCoords.length == 2 * vga.vertexCount ? (format |= 0x20) : (format |= 0x40);
        }
        if (GEOMETRY_BY_REF) {
            format |= 0x80;
        }
        return format;
    }

    public void destroyUniverse() {
        if (this.universe != null) {
            this.universe.destroy();
        }
        this.universe = null;
    }

    @Override
    public void destroy() throws VisADException, RemoteException {
        MouseBehavior mouse;
        if (this.isDestroyed()) {
            return;
        }
        ((DisplayRendererJ3D)this.getDisplayRenderer()).destroy();
        if (this.apiValue == 2) {
            this.destroyUniverse();
        }
        if ((mouse = this.getMouseBehavior()) != null && mouse instanceof MouseBehaviorJ3D) {
            ((MouseBehaviorJ3D)mouse).destroy();
        }
        super.destroy();
        this.applet = null;
        this.projection = null;
        this.mode = null;
    }

    float getOffsetDepthMinimum(float depthOffsetMax) {
        Vector rendVec = this.getRendererVector();
        Iterator iter = rendVec.iterator();
        float offsetMin = depthOffsetMax;
        while (iter.hasNext()) {
            DataRenderer rend = (DataRenderer)iter.next();
            if (!rend.hasPolygonOffset() || !(rend.getPolygonOffset() < offsetMin)) continue;
            offsetMin = rend.getPolygonOffset();
        }
        return offsetMin;
    }

    int getNumRenderersWithZoffset() {
        Vector rendVec = this.getRendererVector();
        Iterator iter = rendVec.iterator();
        int num = 0;
        while (iter.hasNext()) {
            DataRenderer rend = (DataRenderer)iter.next();
            if (!rend.hasPolygonOffset()) continue;
            ++num;
        }
        return num;
    }

    @Override
    public void setDepthBufferOffset(DataRenderer renderer, GraphicsModeControl mode) {
        GraphicsModeControlJ3D mode3d = (GraphicsModeControlJ3D)mode;
        if (mode3d.getAutoDepthOffsetEnable()) {
            float depthOffsetInc = mode3d.getDepthOffsetIncrement();
            int numLayers = mode3d.getNumRenderersWithDepthOffset();
            float maxDepthOffset = (float)numLayers * -depthOffsetInc;
            if (!renderer.hasPolygonOffset()) {
                int cnt = this.getNumRenderersWithZoffset();
                if (cnt < numLayers) {
                    renderer.setPolygonOffset(this.getOffsetDepthMinimum(maxDepthOffset) + depthOffsetInc);
                    renderer.setPolygonOffsetFactor(0.0f);
                    renderer.setHasPolygonOffset(true);
                } else {
                    renderer.setPolygonOffset(0.0f);
                    renderer.setPolygonOffsetFactor(0.0f);
                    renderer.setHasPolygonOffset(false);
                }
            }
            mode3d.setPolygonOffset(renderer.getPolygonOffset(), false);
            mode3d.setPolygonOffsetFactor(renderer.getPolygonOffsetFactor(), false);
        }
    }

    public void resetDepthBufferOffsets() {
        Vector rendVec = this.getRendererVector();
        for (DataRenderer rend : rendVec) {
            if (!rend.hasPolygonOffset()) continue;
            rend.setHasPolygonOffset(false);
            rend.setPolygonOffset(0.0f);
            rend.setPolygonOffsetFactor(0.0f);
        }
    }

    static {
        if (Boolean.parseBoolean(System.getProperty(NO_ERASE_BACKGROUND, "false"))) {
            System.setProperty("sun.awt.noerasebackground", "true");
            UniverseBuilderJ3D.setMinimumFrameCycleTime(20L);
        }
    }
}

