/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Group;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.AnimationControl;
import visad.ContourControl;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.Integer3DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.VisADException;
import visad.collab.CollabUtil;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.RendererJ3D;
import visad.java3d.ShadowTypeJ3D;

public class DefaultRendererJ3D
extends RendererJ3D {
    DataDisplayLink link = null;

    @Override
    public void setLinks(DataDisplayLink[] links, DisplayImpl d) throws VisADException {
        if (links == null || links.length != 1) {
            throw new DisplayException("DefaultRendererJ3D.setLinks: must be exactly one DataDisplayLink");
        }
        super.setLinks(links, d);
        this.link = links[0];
    }

    @Override
    public BranchGroup doTransform() throws VisADException, RemoteException {
        Data data;
        if (this.link == null) {
            return null;
        }
        BranchGroup branch = new BranchGroup();
        branch.setCapability(17);
        branch.setCapability(12);
        branch.setCapability(14);
        ShadowTypeJ3D type = (ShadowTypeJ3D)this.link.getShadow();
        boolean isAnimation = false;
        Vector scalarMaps = this.link.getSelectedMapVector();
        for (int kk = 0; kk < scalarMaps.size(); ++kk) {
            ScalarMap scalarMap = (ScalarMap)scalarMaps.elementAt(kk);
            if (!scalarMap.getDisplayScalar().equals(Display.Animation)) continue;
            isAnimation = true;
        }
        if (isAnimation) {
            this.setBranchEarly(branch);
        }
        int valueArrayLength = this.getDisplay().getValueArrayLength();
        float[] valueArray = new float[valueArrayLength];
        for (int i = 0; i < valueArrayLength; ++i) {
            valueArray[i] = Float.NaN;
        }
        try {
            data = this.link.getData();
        }
        catch (RemoteException re) {
            if (CollabUtil.isDisconnectException(re)) {
                this.getDisplay().connectionFailed(this, this.link);
                this.removeLink(this.link);
                return null;
            }
            throw re;
        }
        if (data == null) {
            branch = null;
            this.addException(new DisplayException("Data is null: DefaultRendererJ3D.doTransform"));
        } else {
            boolean post_process;
            this.link.start_time = System.currentTimeMillis();
            this.link.time_flag = false;
            type.preProcess();
            try {
                post_process = type.doTransform(branch, data, valueArray, this.link.getDefaultValues(), this);
            }
            catch (RemoteException re) {
                if (CollabUtil.isDisconnectException(re)) {
                    this.getDisplay().connectionFailed(this, this.link);
                    this.removeLink(this.link);
                    return null;
                }
                throw re;
            }
            if (post_process) {
                type.postProcess(branch);
            }
        }
        this.link.clearData();
        return branch;
    }

    @Override
    public void addSwitch(DisplayRendererJ3D displayRenderer, BranchGroup branch) {
        displayRenderer.addSceneGraphComponent((Group)branch);
    }

    @Override
    public DataDisplayLink getLink() {
        return this.link;
    }

    @Override
    public void clearScene() {
        this.link = null;
        super.clearScene();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return new DefaultRendererJ3D();
    }

    public static void main(String[] args) throws VisADException, RemoteException, IOException {
        int size;
        String test = "new";
        if (args.length > 0 && !(test = args[0]).equals("default")) {
            System.out.println("args: 'default' for Default logic, None for Animation");
            System.exit(0);
        }
        int nr = size = 160;
        int nc = size;
        int nz = size;
        double ang = Math.PI * 2 / (double)nr;
        RealType[] types = new RealType[]{RealType.Latitude, RealType.Longitude, RealType.Altitude};
        RealTupleType earth_location = new RealTupleType(types);
        RealType radiance = RealType.getRealType("radiance", null, null);
        RealType index = RealType.getRealType("index", null, null);
        FunctionType image_type = new FunctionType(earth_location, radiance);
        Integer3DSet image_domain_set = new Integer3DSet((MathType)RealTupleType.SpatialCartesian3DTuple, nr, nc, nz);
        FunctionType field_type = new FunctionType(index, image_type);
        Integer1DSet field_domain_set = new Integer1DSet((MathType)index, 6);
        FieldImpl field = new FieldImpl(field_type, field_domain_set);
        FlatField image = null;
        for (int tt = 0; tt < field_domain_set.getLength(); ++tt) {
            float[][] values = new float[1][nr * nc * nz];
            for (int kk = 0; kk < nz; ++kk) {
                for (int jj = 0; jj < nc; ++jj) {
                    for (int ii = 0; ii < nr; ++ii) {
                        int idx = kk * nr * nc + jj * nr + ii;
                        values[0][idx] = (float)(tt + 1) * (2.0f * (float)Math.sin(2.0 * ang * (double)ii) + 2.0f * (float)Math.sin(2.0 * ang * (double)jj)) + (float)kk;
                    }
                }
            }
            image = new FlatField(image_type, image_domain_set);
            image.setSamples(values);
            field.setSample(tt, (Data)image, false);
        }
        DisplayImplJ3D dpys = new DisplayImplJ3D("AnimationRendererJ3D Test");
        JFrame jframe = new JFrame("AnimationRendererTest");
        jframe.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        jframe.setContentPane((JPanel)dpys.getComponent());
        jframe.pack();
        jframe.setVisible(true);
        ScalarMap xmap = new ScalarMap(RealType.Longitude, Display.XAxis);
        dpys.addMap(xmap);
        ScalarMap ymap = new ScalarMap(RealType.Latitude, Display.YAxis);
        dpys.addMap(ymap);
        ScalarMap zmap = new ScalarMap(RealType.Altitude, Display.ZAxis);
        dpys.addMap(zmap);
        ScalarMap rgbaMap = new ScalarMap(radiance, Display.RGBA);
        dpys.addMap(rgbaMap);
        ScalarMap amap = new ScalarMap(index, Display.Animation);
        dpys.addMap(amap);
        ScalarMap map1contour = new ScalarMap(radiance, Display.IsoContour);
        dpys.addMap(map1contour);
        ContourControl ctr_cntrl = (ContourControl)map1contour.getControl();
        ctr_cntrl.setSurfaceValue(24.0f);
        AnimationControl acontrol = (AnimationControl)((Object)amap.getControl());
        acontrol.setStep(500);
        DataReferenceImpl ref = new DataReferenceImpl("field_ref");
        if (test.equals("default")) {
            ref.setData(image);
        } else {
            ref.setData(field);
        }
        dpys.addReference(ref);
    }
}

