/*
 * Decompiled with CFR 0.152.
 */
package visad.install;

import java.awt.BorderLayout;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import visad.install.ProgressMonitor;
import visad.install.Util;
import visad.util.CmdlineGenericConsumer;
import visad.util.CmdlineParser;

public class TestUtil
extends CmdlineGenericConsumer {
    private File fromFile;
    private File toFile;
    private String suffix;
    private boolean trackProgress;

    public TestUtil(String[] args) {
        CmdlineParser cmdline = new CmdlineParser(this);
        if (!cmdline.processArgs(args)) {
            System.err.println("Exiting...");
            System.exit(1);
        }
        ProgressMonitor mon = null;
        if (this.trackProgress) {
            JFrame win = new JFrame("Frame-o-licious");
            mon = new ProgressMonitor();
            win.getContentPane().add(this.buildProgress("Copying " + this.fromFile + " to " + this.toFile, mon));
            win.pack();
            win.setVisible(true);
        }
        MakeCopy cp = new MakeCopy(mon, this.fromFile, this.toFile, this.suffix);
        cp.start();
        while (cp.isAlive()) {
            try {
                cp.join();
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
        if (!cp.getResult()) {
            System.err.println("Copy failed!");
            System.exit(1);
        }
        System.out.println("Copied \"" + this.fromFile + "\" to \"" + this.toFile + "\"");
        System.exit(0);
    }

    private JPanel buildProgress(String label, ProgressMonitor mon) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add("North", new JLabel(label));
        panel.add("South", mon);
        return panel;
    }

    @Override
    public int checkKeyword(String mainName, int thisArg, String[] args) {
        if (this.fromFile == null) {
            this.fromFile = new File(args[thisArg]);
            if (!this.fromFile.exists()) {
                System.err.println(mainName + ": File \"" + this.fromFile + "\" does not exist");
                return -1;
            }
            return 1;
        }
        if (this.toFile == null) {
            this.toFile = new File(args[thisArg]);
            return 1;
        }
        return super.checkKeyword(mainName, thisArg, args);
    }

    @Override
    public int checkOption(String mainName, char ch, String arg) {
        if (ch == 'p') {
            this.trackProgress = true;
            return 1;
        }
        if (ch == 's') {
            this.suffix = arg;
            return 2;
        }
        return super.checkOption(mainName, ch, arg);
    }

    @Override
    public boolean finalizeArgs(String mainName) {
        if (this.fromFile == null || this.toFile == null) {
            System.err.println(mainName + ": Please specify two file names!");
            return false;
        }
        return true;
    }

    @Override
    public void initializeArgs() {
        this.toFile = null;
        this.fromFile = null;
        this.suffix = null;
        this.trackProgress = false;
    }

    @Override
    public String keywordUsage() {
        return " fromFile toFile";
    }

    @Override
    public String optionUsage() {
        return " [-p(rogressBar)]";
    }

    public static final void main(String[] args) {
        new TestUtil(args);
    }

    public class MakeCopy
    extends Thread {
        private ProgressMonitor mon;
        private File fromFile;
        private File toFile;
        private String suffix;
        private boolean result;

        MakeCopy(ProgressMonitor mon, File fromFile, File toFile, String suffix) {
            this.mon = mon;
            this.fromFile = fromFile;
            this.toFile = toFile;
            this.suffix = suffix;
            this.result = false;
        }

        @Override
        public void run() {
            if (this.fromFile.isDirectory()) {
                this.result = Util.copyDirectory(this.mon, this.fromFile, this.toFile, this.suffix);
            } else {
                this.result = Util.copyJar(this.mon, this.fromFile, this.toFile, this.suffix);
                if (!this.result) {
                    this.result = Util.copyFile(this.mon, this.fromFile, this.toFile, this.suffix);
                }
            }
            System.err.println("Result was " + this.result);
        }

        boolean getResult() {
            return this.result;
        }
    }
}

