/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.util.Arrays;
import visad.Display;
import visad.FlatField;
import visad.RealTupleType;

public class TrajectoryParams {
    public static final int LINE = 0;
    public static final int RIBBON = 1;
    public static final int CYLINDER = 2;
    public static final int DEFORM_RIBBON = 3;
    public static final int POINT = 4;
    public static final int TRACER = 5;
    public static final int TRACER_POINT = 6;
    double trajVisibilityTimeWindow = 86400.0;
    double trajRefreshInterval = 86400.0;
    int numIntrpPts = 6;
    int startSkip = 2;
    SmoothParams smoothParams = SmoothParams.LIGHT;
    boolean forward = true;
    int direction = 1;
    float markerSize = 1.0f;
    boolean markerEnabled = false;
    boolean manualIntrpPts = false;
    boolean autoSizeMarker = true;
    boolean cachingEnabled = true;
    boolean terrainFollowEnabled = true;
    boolean trcrStreamingEnabled = false;
    boolean saveTracerLocations = false;
    boolean trajDoIntrp = true;
    int trajForm = 0;
    float cylWidth = 1.4E-4f;
    float ribbonWidthFac = 1.0f;
    int zStart = 0;
    int zStartSkip = 4;
    float[][] startPoints = null;
    RealTupleType startType = Display.DisplaySpatialCartesianTuple;
    FlatField terrain = null;
    Method method = Method.HySplit;
    InterpolationMethod interpMethod = InterpolationMethod.Cubic;
    double timeStepScaleFactor = 1.0;
    boolean conserveColor = false;
    public static final int ARROW = 7;
    public static final int SPHERE = 8;
    public static final int DOT = 9;
    int tracerType = 9;

    public TrajectoryParams() {
    }

    public TrajectoryParams(TrajectoryParams params) {
        this.trajVisibilityTimeWindow = params.getTrajVisibilityTimeWindow();
        this.trajRefreshInterval = params.getTrajRefreshInterval();
        this.numIntrpPts = params.getNumIntrpPts();
        this.startSkip = params.getStartSkip();
        this.smoothParams = params.getSmoothParams();
        this.forward = params.getDirectionFlag();
        this.direction = params.getDirection();
        this.markerSize = params.getMarkerSize();
        this.markerEnabled = params.getMarkerEnabled();
        this.manualIntrpPts = params.getManualIntrpPts();
        this.startPoints = params.getStartPoints();
        this.startType = params.getStartType();
        this.autoSizeMarker = params.getAutoSizeMarker();
        this.cachingEnabled = params.getCachingEnabled();
        this.trajForm = params.getTrajectoryForm();
        this.cylWidth = params.getCylinderWidth();
        this.ribbonWidthFac = params.getRibbonWidthFactor();
        this.zStart = params.getZStartIndex();
        this.zStartSkip = params.getZStartSkip();
        this.terrain = params.getTerrain();
        this.terrainFollowEnabled = params.getTerrainFollowing();
        this.method = params.getMethod();
        this.interpMethod = params.getInterpolationMethod();
        this.trcrStreamingEnabled = params.getTracerStreamingEnabled();
        this.saveTracerLocations = params.getSaveTracerLocations();
        this.timeStepScaleFactor = params.getTimeStepScaleFactor();
        this.trajDoIntrp = params.getTrajDoIntrp();
        this.conserveColor = params.getConserveColor();
        this.tracerType = params.getTracerType();
    }

    public TrajectoryParams(double trajVisibilityTimeWindow, double trajRefreshInterval, int numIntrpPts, int startSkip, SmoothParams smoothParams) {
        this.trajVisibilityTimeWindow = trajVisibilityTimeWindow;
        this.trajRefreshInterval = trajRefreshInterval;
        this.numIntrpPts = numIntrpPts;
        this.startSkip = startSkip;
        this.smoothParams = smoothParams;
    }

    public TrajectoryParams(double trajVisibilityTimeWindow, int numIntrpPts, int startSkip, SmoothParams smoothParams) {
        this.trajVisibilityTimeWindow = trajVisibilityTimeWindow;
        this.trajRefreshInterval = trajVisibilityTimeWindow;
        this.numIntrpPts = numIntrpPts;
        this.startSkip = startSkip;
        this.smoothParams = smoothParams;
    }

    public TrajectoryParams(double trajVisibilityTimeWindow, int numIntrpPts, int startSkip) {
        this(trajVisibilityTimeWindow, numIntrpPts, startSkip, SmoothParams.MEDIUM);
    }

    public TrajectoryParams(double trajVisibilityTimeWindow, double trajRefreshInterval) {
        this.trajVisibilityTimeWindow = trajVisibilityTimeWindow;
        this.trajRefreshInterval = trajRefreshInterval;
    }

    public TrajectoryParams(double trajVisibilityTimeWindow) {
        this.trajVisibilityTimeWindow = trajVisibilityTimeWindow;
        this.trajRefreshInterval = trajVisibilityTimeWindow;
    }

    public TrajectoryParams(double trajVisibilityTimeWindow, double trajRefreshInterval, int startSkip) {
        this.trajVisibilityTimeWindow = trajVisibilityTimeWindow;
        this.trajRefreshInterval = trajRefreshInterval;
        this.startSkip = startSkip;
    }

    public TrajectoryParams(double trajVisibilityTimeWindow, int startSkip) {
        this.trajVisibilityTimeWindow = trajVisibilityTimeWindow;
        this.trajRefreshInterval = trajVisibilityTimeWindow;
        this.startSkip = startSkip;
    }

    public void setTrajVisibilityTimeWindow(double trajVisibilityTimeWindow) {
        this.trajVisibilityTimeWindow = trajVisibilityTimeWindow;
    }

    public void setTrajRefreshInterval(double trajRefreshInterval) {
        this.trajRefreshInterval = trajRefreshInterval;
    }

    public void setDirectionFlag(boolean forward) {
        this.forward = forward;
        this.direction = forward ? 1 : -1;
    }

    public boolean getDirectionFlag() {
        return this.forward;
    }

    public void setNumIntrpPts(int numIntrpPts) {
        this.numIntrpPts = numIntrpPts;
        this.manualIntrpPts = true;
    }

    public void setStartSkip(int skip) {
        this.startSkip = skip;
    }

    public void setZStartSkip(int skip) {
        this.zStartSkip = skip;
    }

    public void setZStartIndex(int idx) {
        this.zStart = idx;
    }

    public void setManualIntrpPts(boolean isManual) {
        this.manualIntrpPts = isManual;
    }

    public boolean getManualIntrpPts() {
        return this.manualIntrpPts;
    }

    public void setMarkerSize(float size) {
        this.markerSize = size;
    }

    public void setMarkerEnabled(boolean yesno) {
        this.markerEnabled = yesno;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public void setInterpolationMethod(InterpolationMethod m) {
        this.interpMethod = m;
    }

    public void setCachingEnabled(boolean yesno) {
        this.cachingEnabled = yesno;
    }

    public void setTrajectoryForm(int form) {
        this.trajForm = form;
    }

    public void setCylinderWidth(float width) {
        this.cylWidth = width;
    }

    public void setTerrainFollowing(boolean yesno) {
        this.terrainFollowEnabled = yesno;
    }

    public void setRibbonWidthFactor(float fac) {
        this.ribbonWidthFac = fac;
    }

    public double getTrajVisibilityTimeWindow() {
        return this.trajVisibilityTimeWindow;
    }

    public double getTrajRefreshInterval() {
        return this.trajRefreshInterval;
    }

    public int getNumIntrpPts() {
        return this.numIntrpPts;
    }

    public int getStartSkip() {
        return this.startSkip;
    }

    public int getZStartSkip() {
        return this.zStartSkip;
    }

    public int getZStartIndex() {
        return this.zStart;
    }

    public SmoothParams getSmoothParams() {
        return this.smoothParams;
    }

    public int getTrajectoryForm() {
        return this.trajForm;
    }

    public float getCylinderWidth() {
        return this.cylWidth;
    }

    public float getRibbonWidthFactor() {
        return this.ribbonWidthFac;
    }

    public int getDirection() {
        return this.direction;
    }

    public float getMarkerSize() {
        return this.markerSize;
    }

    public boolean getMarkerEnabled() {
        return this.markerEnabled;
    }

    public boolean getTerrainFollowing() {
        return this.terrainFollowEnabled;
    }

    public Method getMethod() {
        return this.method;
    }

    public InterpolationMethod getInterpolationMethod() {
        return this.interpMethod;
    }

    public void setStartPoints(float[][] startPts) {
        this.startPoints = startPts;
        this.startType = Display.DisplaySpatialCartesianTuple;
    }

    public void setStartPoints(RealTupleType startType, float[][] startPts) {
        this.startType = startType;
        this.startPoints = startPts;
    }

    public float[][] getStartPoints() {
        return this.startPoints;
    }

    public void setTerrain(FlatField terrain) {
        this.terrain = terrain;
    }

    public FlatField getTerrain() {
        return this.terrain;
    }

    public RealTupleType getStartType() {
        return this.startType;
    }

    public boolean getAutoSizeMarker() {
        return this.autoSizeMarker;
    }

    public void setAutoSizeMarker(boolean autoSizeMarker) {
        this.autoSizeMarker = autoSizeMarker;
    }

    public boolean getCachingEnabled() {
        return this.cachingEnabled;
    }

    public boolean getTracerStreamingEnabled() {
        return this.trcrStreamingEnabled;
    }

    public void setTracerStreamingEnabled(boolean yesno) {
        this.trcrStreamingEnabled = yesno;
    }

    public boolean getSaveTracerLocations() {
        return this.saveTracerLocations;
    }

    public void setSaveTracerLocations(boolean yesno) {
        this.saveTracerLocations = yesno;
    }

    public double getTimeStepScaleFactor() {
        return this.timeStepScaleFactor;
    }

    public void setTimeStepScaleFactor(double fac) {
        this.timeStepScaleFactor = fac;
    }

    public boolean getTrajDoIntrp() {
        return this.trajDoIntrp;
    }

    public void setTrajDoIntrp(boolean yesno) {
        this.trajDoIntrp = yesno;
    }

    public boolean getConserveColor() {
        return this.conserveColor;
    }

    public void setConserveColor(boolean yesno) {
        this.conserveColor = yesno;
    }

    public void setTracerType(int type) {
        this.tracerType = type;
    }

    public int getTracerType() {
        return this.tracerType;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TrajectoryParams)) {
            return false;
        }
        TrajectoryParams trajParams = (TrajectoryParams)obj;
        if (this.trajVisibilityTimeWindow != trajParams.trajVisibilityTimeWindow) {
            return false;
        }
        if (this.trajRefreshInterval != trajParams.trajRefreshInterval) {
            return false;
        }
        if (this.numIntrpPts != trajParams.numIntrpPts) {
            return false;
        }
        if (this.startSkip != trajParams.startSkip) {
            return false;
        }
        if (this.zStart != trajParams.zStart) {
            return false;
        }
        if (this.zStartSkip != trajParams.zStartSkip) {
            return false;
        }
        if (this.smoothParams != trajParams.smoothParams) {
            return false;
        }
        if (this.trajForm != trajParams.trajForm) {
            return false;
        }
        if (this.forward != trajParams.forward) {
            return false;
        }
        if (this.direction != trajParams.direction) {
            return false;
        }
        if (this.markerEnabled != trajParams.markerEnabled) {
            return false;
        }
        if (this.cylWidth != trajParams.cylWidth) {
            return false;
        }
        if (this.markerSize != trajParams.markerSize) {
            return false;
        }
        if (this.ribbonWidthFac != trajParams.ribbonWidthFac) {
            return false;
        }
        if (this.terrainFollowEnabled != trajParams.terrainFollowEnabled) {
            return false;
        }
        if (this.method != trajParams.method) {
            return false;
        }
        if (this.interpMethod != trajParams.interpMethod) {
            return false;
        }
        if (this.trcrStreamingEnabled != trajParams.trcrStreamingEnabled) {
            return false;
        }
        if (this.saveTracerLocations != trajParams.saveTracerLocations) {
            return false;
        }
        if (this.timeStepScaleFactor != trajParams.timeStepScaleFactor) {
            return false;
        }
        if (this.trajDoIntrp != trajParams.trajDoIntrp) {
            return false;
        }
        if (this.conserveColor != trajParams.conserveColor) {
            return false;
        }
        if (this.tracerType != trajParams.tracerType) {
            return false;
        }
        if (this.startPoints != null) {
            if (trajParams.startPoints == null) {
                return false;
            }
            if (this.startPoints[0] != null && trajParams.startPoints[0] != null ? !Arrays.equals(this.startPoints[0], trajParams.startPoints[0]) : (this.startPoints[1] != null && trajParams.startPoints[1] != null ? !Arrays.equals(this.startPoints[1], trajParams.startPoints[1]) : this.startPoints[2] != null && trajParams.startPoints[2] != null && !Arrays.equals(this.startPoints[2], trajParams.startPoints[2]))) {
                return false;
            }
        } else if (trajParams.startPoints != null) {
            return false;
        }
        return true;
    }

    public String toString() {
        String str = "trajVisibilityTimeWindow: " + this.trajVisibilityTimeWindow + "\ntrajRefreshInterval: " + this.trajRefreshInterval + "\nnumIntrpPts: " + this.numIntrpPts + "\nstartSkip: " + this.startSkip + "\nzStart: " + this.zStart + "\nzStartSkip: " + this.zStartSkip + "\nsmoothParams: " + (Object)((Object)this.smoothParams) + "\ntrajForm: " + this.trajForm + "\nforward: " + this.forward + "\ndirection: " + this.direction + "\nmarkerEnabled: " + this.markerEnabled + "\ncylWidth: " + this.cylWidth + "\nribbonWidthFac: " + this.ribbonWidthFac + "\nterrainFollowEnabled: " + this.terrainFollowEnabled + "\nmethod: " + (Object)((Object)this.method) + "\ninterpMethod: " + (Object)((Object)this.interpMethod) + "\ntrcrStreamingEnabled: " + this.trcrStreamingEnabled + "\nsaveTracerLocations: " + this.saveTracerLocations + "\ntimeStepScaleFactor: " + this.timeStepScaleFactor + "\ntrajDoIntrp: " + this.trajDoIntrp + "\ntracerType: " + this.tracerType + "\nconserveColor: " + this.conserveColor;
        return str;
    }

    public static enum InterpolationMethod {
        Cubic,
        Linear,
        None;

    }

    public static enum Method {
        HySplit,
        RK4,
        Euler;

    }

    public static enum SmoothParams {
        LIGHT(0.05f, 0.9f, 0.05f),
        MEDIUM(0.15f, 0.7f, 0.15f),
        HEAVY(0.25f, 0.5f, 0.25f),
        NONE(0.0f, 1.0f, 0.0f);

        public float w0;
        public float w1;
        public float w2;

        private SmoothParams(float w0, float w1, float w2) {
            this.w0 = w0;
            this.w1 = w1;
            this.w2 = w2;
        }
    }
}

