/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.StringTokenizer;
import visad.Control;
import visad.DisplayImpl;
import visad.VisADException;
import visad.browser.Convert;
import visad.util.Util;

public class RangeControl
extends Control {
    private boolean initialized = false;
    private double RangeLow = Double.NaN;
    private double RangeHi = Double.NaN;

    public RangeControl(DisplayImpl d) {
        super(d);
    }

    public void initializeRange(float[] range) throws VisADException, RemoteException {
        this.initializeRange(new double[]{range[0], range[1]});
    }

    public void initializeRange(double[] range) throws VisADException, RemoteException {
        this.changeRange(range, this.initialized);
    }

    public void setRange(float[] range) throws VisADException, RemoteException {
        this.setRange(new double[]{range[0], range[1]});
    }

    public void setRange(double[] range) throws VisADException, RemoteException {
        if (this.RangeLow != this.RangeLow || !Util.isApproximatelyEqual(this.RangeLow, range[0]) || this.RangeHi != this.RangeHi || !Util.isApproximatelyEqual(this.RangeHi, range[1])) {
            this.changeRange(range, true);
        }
    }

    private void changeRange(double[] range, boolean notify) throws VisADException, RemoteException {
        this.RangeLow = range[0];
        this.RangeHi = range[1];
        boolean bl = this.initialized = this.RangeLow == this.RangeLow && this.RangeHi == this.RangeHi;
        if (notify) {
            this.changeControl(true);
        }
    }

    public float[] getRange() {
        float[] range = new float[]{(float)this.RangeLow, (float)this.RangeHi};
        return range;
    }

    public double[] getDoubleRange() {
        double[] range = new double[]{this.RangeLow, this.RangeHi};
        return range;
    }

    @Override
    public String getSaveString() {
        return this.RangeLow + " " + this.RangeHi;
    }

    @Override
    public void setSaveString(String save) throws VisADException, RemoteException {
        if (save == null) {
            throw new VisADException("Invalid save string");
        }
        StringTokenizer st = new StringTokenizer(save);
        if (st.countTokens() < 2) {
            throw new VisADException("Invalid save string");
        }
        double[] r = new double[2];
        for (int i = 0; i < 2; ++i) {
            r[i] = Convert.getDouble(st.nextToken());
        }
        this.initializeRange(r);
    }

    @Override
    public void syncControl(Control rmt) throws VisADException {
        if (rmt == null) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with null Control object");
        }
        if (!(rmt instanceof RangeControl)) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with " + rmt.getClass().getName());
        }
        RangeControl rc = (RangeControl)rmt;
        boolean changed = false;
        if (!Util.isApproximatelyEqual(this.RangeLow, rc.RangeLow)) {
            changed = true;
            this.RangeLow = rc.RangeLow;
        }
        if (!Util.isApproximatelyEqual(this.RangeHi, rc.RangeHi)) {
            changed = true;
            this.RangeHi = rc.RangeHi;
        }
        boolean bl = this.initialized = this.RangeLow == this.RangeLow && this.RangeHi == this.RangeHi;
        if (changed) {
            try {
                this.changeControl(true);
            }
            catch (RemoteException re) {
                throw new VisADException("Could not indicate that control changed: " + re.getMessage());
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        RangeControl rc = (RangeControl)o;
        if (!Util.isApproximatelyEqual(this.RangeLow, rc.RangeLow)) {
            return false;
        }
        return Util.isApproximatelyEqual(this.RangeHi, rc.RangeHi);
    }

    @Override
    public String toString() {
        return "RangeControl[" + this.RangeLow + "," + this.RangeHi + "]";
    }
}

