/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import visad.BaseUnit;
import visad.DerivedUnit;
import visad.LogarithmicUnit;
import visad.PromiscuousUnit;
import visad.SI;
import visad.ScaledUnit;
import visad.Unit;
import visad.UnitException;

public final class OffsetUnit
extends Unit
implements Serializable {
    private static final long serialVersionUID = 1L;
    final Unit underUnit;
    final double offset;
    private static SimpleDateFormat dateFormat;
    private static double offsetUnitOrigin;
    private static Unit millisecond;

    public OffsetUnit(double offset) {
        this(offset, "");
    }

    public OffsetUnit(double offset, String identifier) {
        super(identifier);
        this.offset = offset;
        this.underUnit = new ScaledUnit(1.0);
    }

    public OffsetUnit(double offset, Unit unit) {
        this(offset, unit, null);
    }

    public OffsetUnit(double offset, Unit unit, String identifier) {
        super(identifier != null ? identifier : (offset == 0.0 ? unit.getIdentifier() : null));
        this.offset = offset;
        this.underUnit = unit;
    }

    static Unit getInstance(double offset, Unit unit) {
        return offset == 0.0 ? unit : new OffsetUnit(offset, unit);
    }

    @Override
    public boolean isDimensionless() {
        return this.underUnit.isDimensionless();
    }

    protected boolean isTime() {
        return SI.second.isConvertible(this.underUnit);
    }

    @Override
    protected Unit protectedClone(String identifier) {
        return new OffsetUnit(0.0, this, identifier);
    }

    @Override
    public Unit scale(double amount) throws UnitException {
        return OffsetUnit.getInstance(this.offset / amount, this.underUnit.scale(amount));
    }

    @Override
    public Unit shift(double offset) throws UnitException {
        return OffsetUnit.getInstance(offset + this.offset, this.underUnit);
    }

    @Override
    public Unit log(double base) throws UnitException {
        return LogarithmicUnit.getInstance(base, this);
    }

    @Override
    public Unit pow(int power) throws UnitException {
        return this.underUnit.pow(power);
    }

    @Override
    public Unit pow(double power) throws UnitException {
        return this.underUnit.pow(power);
    }

    @Override
    public Unit root(int root) throws IllegalArgumentException, UnitException {
        return this.underUnit.root(root);
    }

    @Override
    public String getDefinition() {
        String definition;
        String scaledString = this.underUnit.toString();
        if (scaledString.indexOf(32) != -1) {
            scaledString = "(" + scaledString + ")";
        }
        if (!this.isTime()) {
            definition = scaledString + " @ " + this.offset;
        } else {
            try {
                definition = scaledString + " since " + dateFormat.format(new Date((long)(millisecond.toThis(this.offset, this.underUnit) + offsetUnitOrigin)));
            }
            catch (UnitException e) {
                definition = e.toString();
            }
        }
        return definition;
    }

    @Override
    public Unit multiply(Unit that) throws UnitException {
        return that.multiply(this.underUnit);
    }

    @Override
    public Unit divide(Unit that) throws UnitException {
        return that.divideInto(this.underUnit);
    }

    @Override
    protected Unit divideInto(Unit that) throws UnitException {
        return that.divide(this.underUnit);
    }

    @Override
    public double[] toThis(double[] values, Unit that) throws UnitException {
        return this.toThis(values, that, true);
    }

    @Override
    public float[] toThis(float[] values, Unit that) throws UnitException {
        return this.toThis(values, that, true);
    }

    @Override
    public double[] toThis(double[] values, Unit that, boolean copy) throws UnitException {
        double[] newValues;
        if (this.equals(that) || that instanceof PromiscuousUnit) {
            newValues = copy ? (double[])values.clone() : values;
        } else {
            newValues = that.toThat(values, this.underUnit, copy);
            for (int i = 0; i < newValues.length; ++i) {
                if (newValues[i] != newValues[i]) continue;
                int n = i;
                newValues[n] = newValues[n] - this.offset;
            }
        }
        return newValues;
    }

    @Override
    public float[] toThis(float[] values, Unit that, boolean copy) throws UnitException {
        float[] newValues;
        if (this.equals(that) || that instanceof PromiscuousUnit) {
            newValues = copy ? (float[])values.clone() : values;
        } else {
            newValues = that.toThat(values, this.underUnit, copy);
            for (int i = 0; i < newValues.length; ++i) {
                if (newValues[i] != newValues[i]) continue;
                int n = i;
                newValues[n] = (float)((double)newValues[n] - this.offset);
            }
        }
        return newValues;
    }

    @Override
    public double[] toThat(double[] values, Unit that) throws UnitException {
        return this.toThat(values, that, true);
    }

    @Override
    public float[] toThat(float[] values, Unit that) throws UnitException {
        return this.toThat(values, that, true);
    }

    @Override
    public double[] toThat(double[] values, Unit that, boolean copy) throws UnitException {
        double[] newValues;
        double[] dArray = newValues = copy ? (double[])values.clone() : values;
        if (!this.equals(that) && !(that instanceof PromiscuousUnit)) {
            for (int i = 0; i < newValues.length; ++i) {
                if (newValues[i] != newValues[i]) continue;
                int n = i;
                newValues[n] = newValues[n] + this.offset;
            }
            newValues = that.toThis(newValues, this.underUnit, copy);
        }
        return newValues;
    }

    @Override
    public float[] toThat(float[] values, Unit that, boolean copy) throws UnitException {
        float[] newValues;
        float[] fArray = newValues = copy ? (float[])values.clone() : values;
        if (!this.equals(that) && !(that instanceof PromiscuousUnit)) {
            for (int i = 0; i < newValues.length; ++i) {
                if (newValues[i] != newValues[i]) continue;
                int n = i;
                newValues[n] = (float)((double)newValues[n] + this.offset);
            }
            newValues = that.toThis(newValues, this.underUnit, copy);
        }
        return newValues;
    }

    @Override
    public Unit getAbsoluteUnit() {
        return this.underUnit.getAbsoluteUnit();
    }

    @Override
    public boolean isConvertible(Unit unit) {
        return this.underUnit.isConvertible(unit);
    }

    private static void myAssert(boolean assertion) {
        if (!assertion) {
            throw new AssertionError();
        }
    }

    private static void myAssert(Unit have, Unit expect) {
        if (!have.equals(expect)) {
            throw new AssertionError((Object)(have.toString() + " != " + expect));
        }
    }

    private static void myAssert(double have, double expect) {
        if (have != expect) {
            throw new AssertionError((Object)("" + have + " != " + expect));
        }
    }

    private static void myAssert(double[] have, double[] expect) {
        if (!Arrays.equals(have, expect)) {
            throw new AssertionError((Object)("" + have + " != " + expect));
        }
    }

    public static void main(String[] args) throws UnitException {
        BaseUnit degK = SI.kelvin;
        OffsetUnit degC = new OffsetUnit(273.15, degK);
        ScaledUnit degR = new ScaledUnit(0.5555555555555556, degK);
        OffsetUnit degF = new OffsetUnit(459.67, degR);
        OffsetUnit.myAssert(degC, degC);
        OffsetUnit.myAssert(!((Unit)degC).equals(degK));
        OffsetUnit.myAssert(!((Unit)degC).equals(degF));
        OffsetUnit.myAssert(((Unit)degC).isConvertible(degC));
        OffsetUnit.myAssert(((Unit)degC).isConvertible(degK));
        OffsetUnit.myAssert(((Unit)degC).isConvertible(degF));
        OffsetUnit.myAssert(degF, degF);
        OffsetUnit.myAssert(degF.toThis(0.0, (Unit)degC), degC.toThat(0.0, (Unit)degF));
        OffsetUnit.myAssert(degC.toThis(32.0, (Unit)degF), degF.toThat(32.0, (Unit)degC));
        OffsetUnit.myAssert(degC.toThis(degF.toThis(0.0, (Unit)degC), (Unit)degF), 0.0);
        OffsetUnit.myAssert(degC.toThat(degF.toThat(32.0, (Unit)degC), (Unit)degF), 32.0);
        double[] values = new double[]{0.0, 100.0};
        OffsetUnit.myAssert(((Unit)degF).toThis(values, (Unit)degC), ((Unit)degC).toThat(values, (Unit)degF));
        OffsetUnit.myAssert(((Unit)degC).toThis(((Unit)degF).toThis(values, (Unit)degC), (Unit)degF), values);
        values = new double[]{32.0, 212.0};
        OffsetUnit.myAssert(((Unit)degC).toThis(values, (Unit)degF), ((Unit)degF).toThat(values, (Unit)degC));
        OffsetUnit.myAssert(((Unit)degF).pow(2), degR.pow(2));
        OffsetUnit.myAssert(((Unit)degF).multiply(degC), ((Unit)degC).multiply(degF));
        OffsetUnit.myAssert(((Unit)degF).multiply(degC), degR.multiply(degK));
        OffsetUnit.myAssert(((Unit)degF).divide(degC), degR.divide(degK));
        OffsetUnit.myAssert(((Unit)degC).divide(degF), degK.divide(degR));
        System.out.println("Done");
    }

    @Override
    public boolean equals(Unit unit) {
        if (this == unit) {
            return true;
        }
        if (this.offset == 0.0) {
            return this.underUnit.equals(unit);
        }
        if (!(unit instanceof OffsetUnit)) {
            return false;
        }
        OffsetUnit that = (OffsetUnit)unit;
        return this.offset == that.offset && this.underUnit.equals(that.underUnit);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.offset == 0.0 ? this.underUnit.hashCode() : this.underUnit.hashCode() ^ Double.valueOf(this.offset).hashCode();
        }
        return this.hashCode;
    }

    @Override
    public DerivedUnit getDerivedUnit() {
        return this.underUnit.getDerivedUnit();
    }

    static {
        try {
            dateFormat = (SimpleDateFormat)DateFormat.getDateInstance(3, Locale.US);
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            dateFormat.applyPattern("yyyy-MM-dd HH:mm:ss.SSS 'UTC'");
            GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            calendar.clear();
            calendar.set(2001, 0, 1, 0, 0, 0);
            offsetUnitOrigin = calendar.getTime().getTime();
            millisecond = SI.second.scale(0.001).clone("ms");
        }
        catch (Exception e) {
            System.err.println("OffsetUnit.<clinit>: Couldn't initialize class: " + e);
            System.exit(1);
        }
    }
}

