/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataImpl;
import visad.Field;
import visad.Function;
import visad.FunctionType;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.SingletonSet;
import visad.Unit;
import visad.VisADException;

public abstract class FunctionImpl
extends DataImpl
implements Function {
    public FunctionImpl(FunctionType type) {
        super(type);
    }

    @Override
    public int getDomainDimension() {
        return ((FunctionType)this.Type).getDomain().getDimension();
    }

    @Override
    public Unit[] getDomainUnits() {
        return ((FunctionType)this.Type).getDomain().getDefaultUnits();
    }

    @Override
    public CoordinateSystem getDomainCoordinateSystem() {
        return ((FunctionType)this.Type).getDomain().getCoordinateSystem();
    }

    @Override
    public Data evaluate(Real domain) throws VisADException, RemoteException {
        if (domain == null) {
            return ((FunctionType)this.getType()).getRange().missingData();
        }
        CoordinateSystem domainCoordinateSystem = this.getDomainCoordinateSystem();
        RealTuple domainPoint = domainCoordinateSystem == null ? new RealTuple(new Real[]{domain}) : new RealTuple(new RealTupleType((RealType)domain.getType(), domainCoordinateSystem, null), new Real[]{domain}, null);
        return this.evaluate(domainPoint, 101, 202);
    }

    @Override
    public Data evaluate(Real domain, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        if (domain == null) {
            return ((FunctionType)this.getType()).getRange().missingData();
        }
        CoordinateSystem domainCoordinateSystem = this.getDomainCoordinateSystem();
        RealTuple domainPoint = domainCoordinateSystem == null ? new RealTuple(new Real[]{domain}) : new RealTuple(new RealTupleType((RealType)domain.getType(), domainCoordinateSystem, null), new Real[]{domain}, null);
        return this.evaluate(domainPoint, sampling_mode, error_mode);
    }

    @Override
    public Data evaluate(RealTuple domain) throws VisADException, RemoteException {
        if (domain == null) {
            return ((FunctionType)this.getType()).getRange().missingData();
        }
        return this.evaluate(domain, 101, 202);
    }

    @Override
    public Data evaluate(RealTuple domain, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        if (domain == null) {
            return ((FunctionType)this.getType()).getRange().missingData();
        }
        Field field = this.resample(new SingletonSet(domain, domain.getCoordinateSystem(), domain.getTupleUnits(), domain.getErrors()), sampling_mode, error_mode);
        return field.getSample(0);
    }

    @Override
    public Field resample(Set set) throws VisADException, RemoteException {
        return this.resample(set, 101, 202);
    }

    @Override
    public abstract Field resample(Set var1, int var2, int var3) throws VisADException, RemoteException;

    @Override
    public abstract Data derivative(RealTuple var1, RealType[] var2, MathType[] var3, int var4) throws VisADException, RemoteException;

    @Override
    public abstract Data derivative(int var1) throws VisADException, RemoteException;

    @Override
    public abstract Data derivative(MathType[] var1, int var2) throws VisADException, RemoteException;

    @Override
    public abstract Function derivative(RealType var1, int var2) throws VisADException, RemoteException;

    @Override
    public abstract Function derivative(RealType var1, MathType var2, int var3) throws VisADException, RemoteException;

    public Data __getitem__(Real domain) throws VisADException, RemoteException {
        return this.evaluate(domain);
    }

    public Data __getitem__(RealTuple domain) throws VisADException, RemoteException {
        return this.evaluate(domain);
    }
}

