/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import loci.formats.DataTools;
import loci.formats.FormatException;
import loci.formats.RandomAccessStream;
import loci.formats.TiffTools;
import loci.formats.in.BaseTiffReader;

public class NikonReader
extends BaseTiffReader {
    private static final int BLOCK_CHECK_LEN = 16384;
    private static final int EXIF_IFD_POINTER = 34665;
    private static final int TIFF_EPS_STANDARD = 37398;
    private static final int CFA_REPEAT_DIM = 33421;
    private static final int EXPOSURE_TIME = 33434;
    private static final int APERTURE = 33437;
    private static final int EXPOSURE_PROGRAM = 34850;
    private static final int DATE_TIME_DIGITIZED = 36867;
    private static final int DATE_TIME_ORIGINAL = 36868;
    private static final int EXPOSURE_BIAS_VALUE = 37380;
    private static final int MAX_APERTURE_VALUE = 37381;
    private static final int METERING_MODE = 37383;
    private static final int LIGHT_SOURCE = 37384;
    private static final int FLASH = 37385;
    private static final int FOCAL_LENGTH = 37386;
    private static final int SENSING_METHOD = 37399;
    private static final int MAKER_NOTE = 37500;
    private static final int USER_COMMENT = 37510;
    private static final int SUBSEC_TIME = 37520;
    private static final int SUBSEC_TIME_ORIGINAL = 37521;
    private static final int SUBSEC_TIME_DIGITIZED = 37522;
    private static final int COLOR_SPACE = 40961;
    private static final int FILE_SOURCE = 41728;
    private static final int SCENE_TYPE = 41729;
    private static final int CFA_PATTERN = 41730;
    private static final int CUSTOM_RENDERED = 41985;
    private static final int EXPOSURE_MODE = 41986;
    private static final int WHITE_BALANCE = 41987;
    private static final int DIGITAL_ZOOM_RATIO = 41988;
    private static final int FOCAL_LENGTH_35MM_FILM = 41989;
    private static final int SCENE_CAPTURE_TYPE = 41990;
    private static final int GAIN_CONTROL = 41991;
    private static final int CONTRAST = 41992;
    private static final int SATURATION = 41993;
    private static final int SHARPNESS = 41994;
    private static final int SUBJECT_DISTANCE_RANGE = 41996;
    private static final int FIRMWARE_VERSION = 1;
    private static final int ISO = 2;
    private static final int QUALITY = 4;
    private static final int MAKER_WHITE_BALANCE = 5;
    private static final int SHARPENING = 6;
    private static final int FOCUS_MODE = 7;
    private static final int FLASH_SETTING = 8;
    private static final int FLASH_MODE = 9;
    private static final int WHITE_BALANCE_FINE = 11;
    private static final int WHITE_BALANCE_RGB_COEFFS = 12;
    private static final int FLASH_COMPENSATION = 18;
    private static final int TONE_COMPENSATION = 129;
    private static final int LENS_TYPE = 131;
    private static final int LENS = 132;
    private static final int FLASH_USED = 135;
    private static final int CURVE = 140;
    private static final int COLOR_MODE = 141;
    private static final int LIGHT_TYPE = 144;
    private static final int HUE = 146;
    private static final int CAPTURE_EDITOR_DATA = 3585;
    protected int makerNoteOffset;
    protected Hashtable original;

    public NikonReader() {
        super("Nikon NEF (TIFF)", new String[]{"nef", "tif", "tiff"});
    }

    public boolean isThisType(byte[] block) {
        if (block.length < 3) {
            return false;
        }
        if (block.length < 8) {
            return true;
        }
        boolean little = block[0] == 73 && block[1] == 73;
        int ifdlocation = DataTools.bytesToInt(block, 4, little);
        if (ifdlocation < 0 || ifdlocation + 1 > block.length) {
            return false;
        }
        int ifdnumber = DataTools.bytesToInt(block, ifdlocation, 2, little);
        for (int i = 0; i < ifdnumber; ++i) {
            if (ifdlocation + 3 + i * 12 > block.length) {
                return false;
            }
            int ifdtag = DataTools.bytesToInt(block, ifdlocation + 2 + i * 12, 2, little);
            if (ifdtag != 37398) continue;
            return true;
        }
        return false;
    }

    public boolean isThisType(String name, boolean open) {
        String lname = name.toLowerCase();
        if (lname.endsWith(".nef")) {
            return true;
        }
        if (!lname.endsWith(".tif") && !lname.endsWith(".tiff")) {
            return false;
        }
        return open ? this.checkBytes(name, 16384) : true;
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        block18: {
            int tag;
            Integer key;
            super.initStandardMetadata();
            try {
                short[] version = (short[])TiffTools.getIFDValue(this.original, 37398);
                String v = "";
                for (int i = 0; i < version.length; ++i) {
                    v = v + version[i];
                }
                this.addMeta("Version", v);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            this.core.littleEndian[0] = true;
            try {
                this.core.littleEndian[0] = TiffTools.isLittleEndian(this.ifds[0]);
            }
            catch (FormatException f) {
                // empty catch block
            }
            try {
                Hashtable exifIFD;
                int exif = TiffTools.getIFDIntValue(this.original, 34665);
                if (exif != -1 && (exifIFD = TiffTools.getIFD(this.in, 0L, exif)) != null) {
                    Enumeration e = exifIFD.keys();
                    while (e.hasMoreElements()) {
                        key = (Integer)e.nextElement();
                        tag = key;
                        if (tag == 41730) {
                            byte[] cfa = (byte[])exifIFD.get(key);
                            int[] colorMap = new int[cfa.length];
                            for (int i = 0; i < cfa.length; ++i) {
                                colorMap[i] = cfa[i];
                            }
                            this.addMeta(this.getTagName(tag), colorMap);
                            continue;
                        }
                        this.addMeta(this.getTagName(tag), exifIFD.get(key));
                    }
                }
            }
            catch (IOException io) {
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            byte[] offsets = (byte[])this.getMeta("Offset to maker note");
            if (offsets != null) {
                this.makerNoteOffset = offsets[0];
            }
            try {
                if ((long)this.makerNoteOffset >= this.in.length() || this.makerNoteOffset == 0) {
                    return;
                }
                Hashtable makerNote = TiffTools.getIFD(this.in, 0L, this.makerNoteOffset);
                if (makerNote != null) {
                    Enumeration e = makerNote.keys();
                    while (e.hasMoreElements()) {
                        key = (Integer)e.nextElement();
                        tag = key;
                        if (!makerNote.containsKey(key)) continue;
                        this.addMeta(this.getTagName(tag), makerNote.get(key));
                    }
                }
            }
            catch (IOException exc) {
                if (!debug) break block18;
                this.trace(exc);
            }
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("NikonReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        if (this.in.readShort() == 18761) {
            this.in.order(true);
        }
        this.ifds = TiffTools.getIFDs(this.in);
        if (this.ifds == null) {
            throw new FormatException("No IFDs found");
        }
        int offset = 0;
        try {
            offset = TiffTools.getIFDIntValue(this.ifds[0], 330, false, 0);
        }
        catch (FormatException exc) {
            if (debug) {
                this.trace(exc);
            }
            long[] array = TiffTools.getIFDLongArray(this.ifds[0], 330, false);
            offset = (int)array[array.length - 1];
        }
        Hashtable realImage = TiffTools.getIFD(this.in, 1L, offset);
        this.original = this.ifds[0];
        this.ifds[0] = realImage;
        this.core.imageCount[0] = 1;
        Object pattern = this.getMeta("CFA pattern");
        if (pattern != null) {
            realImage.put(new Integer(320), this.getMeta("CFA pattern"));
        }
    }

    private String getTagName(int tag) {
        switch (tag) {
            case 33421: {
                return "CFA Repeat Dimensions";
            }
            case 33434: {
                return "Exposure Time";
            }
            case 33437: {
                return "Aperture";
            }
            case 34850: {
                return "Exposure Program";
            }
            case 36867: {
                return "Date/Time Digitized";
            }
            case 36868: {
                return "Date/Time Original";
            }
            case 37380: {
                return "Exposure Bias Value";
            }
            case 37381: {
                return "Max Aperture Value";
            }
            case 37383: {
                return "Metering Mode";
            }
            case 37384: {
                return "Light Source";
            }
            case 37385: {
                return "Flash Enabled?";
            }
            case 37386: {
                return "Focal length of lens";
            }
            case 37399: {
                return "Sensing Method";
            }
            case 37500: {
                return "Offset to maker note";
            }
            case 37510: {
                return "User comment";
            }
            case 37520: {
                return "Subsec. Sampling for Date/Time field";
            }
            case 37521: {
                return "Subsec. Sampling for original date";
            }
            case 37522: {
                return "Subsec. Sampling for digitized date";
            }
            case 40961: {
                return "Color space";
            }
            case 41728: {
                return "File source";
            }
            case 41729: {
                return "Scene type";
            }
            case 41730: {
                return "CFA pattern";
            }
            case 41985: {
                return "Custom Rendered?";
            }
            case 41986: {
                return "Exposure mode";
            }
            case 41987: {
                return "White Balance";
            }
            case 41988: {
                return "Digital Zoom Ratio";
            }
            case 41989: {
                return "Focal Length of 35mm lens";
            }
            case 41990: {
                return "Scene Capture Type";
            }
            case 41991: {
                return "Gain Control";
            }
            case 41992: {
                return "Contrast";
            }
            case 41993: {
                return "Saturation";
            }
            case 41994: {
                return "Sharpness";
            }
            case 41996: {
                return "Subject Distance Range";
            }
            case 1: {
                return "Firmware version";
            }
            case 2: {
                return "ISO";
            }
            case 4: {
                return "Quality";
            }
            case 5: {
                return "White Balance (Maker)";
            }
            case 6: {
                return "Sharpening";
            }
            case 7: {
                return "Focus Mode";
            }
            case 8: {
                return "Flash Setting";
            }
            case 9: {
                return "Flash Mode";
            }
            case 11: {
                return "White Balance Fine";
            }
            case 12: {
                return "White Balance (RGB coefficients)";
            }
            case 18: {
                return "Flash compensation";
            }
            case 129: {
                return "Tone compensation";
            }
            case 131: {
                return "Lens type";
            }
            case 132: {
                return "Lens";
            }
            case 135: {
                return "Flash used?";
            }
            case 140: {
                return "Curve";
            }
            case 141: {
                return "Color mode";
            }
            case 144: {
                return "Light type";
            }
            case 146: {
                return "Hue";
            }
            case 3585: {
                return "Capture Editor Data";
            }
        }
        return "" + tag;
    }
}

