/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas.adde;

import edu.wisc.ssec.mcidas.adde.AddeURLConnection;
import edu.wisc.ssec.mcidas.adde.AddeURLException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public class DataSetInfo {
    private int status = 0;
    private char[] data;
    private Hashtable descriptorTable;
    private boolean debug = false;
    private List<String> descriptorList;
    private List<String> commentList;

    public DataSetInfo(String request) throws AddeURLException {
        BufferedReader reader;
        URLConnection urlc;
        this.debug = this.debug || request.indexOf("debug=true") >= 0;
        try {
            URL url = new URL(request);
            urlc = url.openConnection();
            reader = new BufferedReader(new InputStreamReader(urlc.getInputStream()));
        }
        catch (AddeURLException ae) {
            this.status = -1;
            throw new AddeURLException("No datasets found", ae);
        }
        catch (Exception e) {
            this.status = -1;
            throw new AddeURLException("Error opening connection", e);
        }
        int numBytes = ((AddeURLConnection)urlc).getInitialRecordSize();
        if (this.debug) {
            System.out.println("DataSetInfo: numBytes = " + numBytes);
        }
        if (numBytes == 0) {
            this.status = -1;
            throw new AddeURLException("No datasets found");
        }
        this.data = new char[numBytes];
        try {
            int numRead;
            for (int start = 0; start < numBytes; start += numRead) {
                numRead = reader.read(this.data, start, numBytes - start);
                if (!this.debug) continue;
                System.out.println("bytes read = " + numRead);
            }
        }
        catch (IOException e) {
            this.status = -1;
            throw new AddeURLException("Error reading dataset info", e);
        }
        int numNames = this.data.length / 80;
        this.descriptorTable = new Hashtable(numNames);
        this.descriptorList = new ArrayList<String>(numNames);
        this.commentList = new ArrayList<String>(numNames);
        if (this.debug) {
            System.out.println("Number of descriptors = " + numNames);
        }
        for (int i = 0; i < numNames; ++i) {
            String temp = new String(this.data, i * 80, 80);
            if (this.debug) {
                System.out.println("Parsing: >" + temp + "<");
            }
            if (temp.trim().isEmpty()) continue;
            String descriptor = temp.substring(0, 12).trim();
            if (this.debug) {
                System.out.println("Descriptor = " + descriptor);
            }
            String comment = descriptor;
            int pos = temp.indexOf(34);
            if (this.debug) {
                System.out.println("Found quote at " + pos);
            }
            if (pos >= 23 && (comment = temp.substring(pos + 1).trim()).isEmpty()) {
                comment = descriptor;
            }
            if (this.debug) {
                System.out.println("Comment = " + comment);
            }
            this.descriptorTable.put(comment, descriptor);
            this.descriptorList.add(descriptor);
            this.commentList.add(comment);
        }
    }

    public List<String> getDescriptorList() {
        return this.descriptorList;
    }

    public List<String> getCommentList() {
        return this.commentList;
    }

    public char[] getData() throws AddeURLException {
        if (this.status < 0) {
            throw new AddeURLException("No data available");
        }
        return this.data;
    }

    public Hashtable getDescriptionTable() throws AddeURLException {
        if (this.status < 0) {
            throw new AddeURLException("No data available");
        }
        return this.descriptorTable;
    }

    public String[] getDescriptors() throws AddeURLException {
        if (this.status < 0) {
            throw new AddeURLException("No data available");
        }
        Object[] list = new String[this.descriptorTable.size()];
        Enumeration elements = this.descriptorTable.elements();
        int i = 0;
        while (elements.hasMoreElements()) {
            list[i] = (String)elements.nextElement();
            ++i;
        }
        Arrays.sort(list);
        return list;
    }

    public String toString() {
        if (this.status < 0) {
            return new String("No data Available");
        }
        String header = new String("Name         NumPos   Content\n------------ ------   --------------------------------------\n");
        StringBuffer buf = new StringBuffer(header);
        for (int i = 0; i < this.data.length / 80; ++i) {
            StringBuffer sb = new StringBuffer("                                          ");
            String line = new String(this.data, i * 80, 80);
            sb.insert(0, line.substring(0, 12));
            int brange = 0;
            int erange = 0;
            try {
                brange = Integer.parseInt(line.substring(12, 18).trim());
            }
            catch (NumberFormatException ne) {
                brange = 0;
            }
            try {
                erange = Integer.parseInt(line.substring(18, 23).trim());
            }
            catch (NumberFormatException ne) {
                erange = 0;
            }
            if (erange == 0) {
                erange = brange;
            }
            int numPos = erange - brange + 1;
            int insertPos = 17;
            if (numPos >= 10 && numPos < 100) {
                insertPos = 16;
            } else if (numPos >= 100 && numPos < 1000) {
                insertPos = 15;
            } else if (numPos > 1000) {
                insertPos = 14;
            }
            sb.insert(insertPos, String.valueOf(numPos));
            int pos = line.indexOf(34);
            if (pos >= 23) {
                sb.insert(22, line.substring(pos + 1));
            }
            buf.append(sb.toString().trim());
            buf.append("\n");
        }
        return buf.toString();
    }

    public static void main(String[] args) throws Exception {
        System.out.println("\nDataset Names:\n");
        String request = args.length == 0 ? "adde://adde.unidata.ucar.edu/datasetinfo?group=blizzard&type=image" : args[0];
        DataSetInfo dsinfo = new DataSetInfo(request);
        System.out.println(dsinfo.toString());
        String[] descriptors = dsinfo.getDescriptors();
        System.out.println("Sorted list of Descriptors:");
        for (int i = 0; i < descriptors.length; ++i) {
            System.out.println(descriptors[i]);
        }
    }

    static {
        try {
            String handlers = System.getProperty("java.protocol.handler.pkgs");
            String newProperty = null;
            if (handlers == null) {
                newProperty = "edu.wisc.ssec.mcidas";
            } else if (handlers.indexOf("edu.wisc.ssec.mcidas") < 0) {
                newProperty = "edu.wisc.ssec.mcidas | " + handlers;
            }
            if (newProperty != null) {
                System.setProperty("java.protocol.handler.pkgs", newProperty);
            }
        }
        catch (Exception e) {
            System.out.println("Unable to set System Property: java.protocol.handler.pkgs");
        }
    }
}

