/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.AREAnav;
import edu.wisc.ssec.mcidas.McIDASUtil;

public final class GOESnav
extends AREAnav {
    private boolean isEastPositive = true;
    private int navday;
    private int lintot;
    private double deglin;
    private int ieltot;
    private double degele;
    private double spinra;
    private int ietimy;
    private int ietimh;
    private double semima;
    private double oeccen;
    private double orbinc;
    private double perhel;
    private double asnode;
    private double nopcln;
    private double declin;
    private double rascen;
    private double piclin;
    private double prerat;
    private double predir;
    private double pitch;
    private double yaw;
    private double roll;
    private double skew;
    private int iajust;
    private int ibtcon;
    private int negbet;
    private int iseang;
    private double scan1;
    private double time1;
    private double scan2;
    private double time2;
    private double emega;
    private double ab;
    private double asq;
    private double bsq;
    private double r;
    private double rsq;
    private double rdpdg;
    private int numsen;
    private double totlin;
    private double radlin;
    private double totele;
    private double radele;
    private double picele;
    private double cpitch;
    private double cyaw;
    private double croll;
    private double pskew;
    private double rfact;
    private double roasin;
    private double tmpscl;
    private double b11;
    private double b12;
    private double b13;
    private double b21;
    private double b22;
    private double b23;
    private double b31;
    private double b32;
    private double b33;
    private double gamma;
    private double gamdot;
    private double rotm11;
    private double rotm13;
    private double rotm21;
    private double rotm23;
    private double rotm31;
    private double rotm33;
    private double pictim;
    private double xref;
    private int iold = 0;
    private double tdife;
    private double xmmc;
    private double epsiln;
    private double srome2;
    private double pz;
    private double py;
    private double px;
    private double qz;
    private double qy;
    private double qx;

    public GOESnav(int[] iarr) throws IllegalArgumentException {
        if (iarr[0] != 1196377427) {
            throw new IllegalArgumentException("Invalid navigation type" + iarr[0]);
        }
        int jday = iarr[1];
        int jtime = iarr[2];
        this.navday = jday % 100000;
        if (iarr[6] <= 0 && iarr[7] <= 0 && iarr[8] <= 0 && iarr[9] <= 0 && iarr[10] <= 0 && iarr[11] <= 0) {
            throw new IllegalArgumentException("Invalid orbital parameters");
        }
        this.ietimy = this.icon1(iarr[4]);
        this.ietimh = 100 * (iarr[5] / 100) + Math.round(0.6f * (float)(iarr[5] % 100));
        this.semima = (double)iarr[6] / 100.0;
        this.oeccen = (double)iarr[7] / 1000000.0;
        this.orbinc = (double)iarr[8] / 1000.0;
        double xmeana = (double)iarr[9] / 1000.0;
        this.perhel = (double)iarr[10] / 1000.0;
        this.asnode = (double)iarr[11] / 1000.0;
        if (iarr[4] == 0) {
            throw new IllegalArgumentException("Invalid orbit type");
        }
        this.epoch(this.ietimy, this.ietimh, this.semima, this.oeccen, xmeana);
        this.declin = McIDASUtil.mcPackedIntegerToDouble(iarr[12]);
        this.rascen = McIDASUtil.mcPackedIntegerToDouble(iarr[13]);
        this.piclin = iarr[14];
        if (iarr[14] >= 1000000) {
            this.piclin /= 10000.0;
        }
        if (iarr[12] == 0 && iarr[13] == 0 && iarr[14] == 0) {
            throw new IllegalArgumentException("Invalid ascension/declination parameters");
        }
        if (iarr[15] == 0) {
            throw new IllegalArgumentException("Invalid spin period");
        }
        this.spinra = (double)iarr[15] / 1000.0;
        if (iarr[15] != 0 && this.spinra < 300.0) {
            this.spinra = 60000.0 / this.spinra;
        }
        this.deglin = McIDASUtil.mcPackedIntegerToDouble(iarr[16]);
        this.lintot = iarr[17];
        this.degele = McIDASUtil.mcPackedIntegerToDouble(iarr[18]);
        this.ieltot = iarr[19];
        this.pitch = McIDASUtil.mcPackedIntegerToDouble(iarr[20]);
        this.yaw = McIDASUtil.mcPackedIntegerToDouble(iarr[21]);
        this.roll = McIDASUtil.mcPackedIntegerToDouble(iarr[22]);
        this.skew = (double)iarr[28] / 100000.0;
        if (iarr[28] == -2139062144) {
            this.skew = 0.0;
        }
        this.iajust = iarr[24];
        this.iseang = iarr[27];
        this.ibtcon = 6289920;
        this.negbet = 3144960;
        this.emega = 0.26251617;
        this.ab = 4.054685122E7;
        this.asq = 4.068383348E7;
        this.bsq = 4.041033018E7;
        this.r = 6371.221;
        this.rsq = this.r * this.r;
        this.rdpdg = 0.01745329252;
        this.numsen = this.lintot / 100000 % 100;
        if (this.numsen < 1) {
            this.numsen = 1;
        }
        this.totlin = this.numsen * (this.lintot % 100000);
        this.radlin = this.rdpdg * this.deglin / (this.totlin - 1.0);
        this.totele = this.ieltot;
        this.radele = this.rdpdg * this.degele / (this.totele - 1.0);
        this.picele = (1.0 + this.totele) / 2.0;
        this.cpitch = this.rdpdg * this.pitch;
        this.cyaw = this.rdpdg * this.yaw;
        this.croll = this.rdpdg * this.roll;
        this.pskew = Math.atan2(this.skew, this.radlin / this.radele);
        double stp = Math.sin(this.cpitch);
        double ctp = Math.cos(this.cpitch);
        double sty = Math.sin(this.cyaw - this.pskew);
        double cty = Math.cos(this.cyaw - this.pskew);
        double str = Math.sin(this.croll);
        double ctr = Math.cos(this.croll);
        this.rotm11 = ctr * ctp;
        this.rotm13 = sty * str * ctp + cty * stp;
        this.rotm21 = -str;
        this.rotm23 = sty * ctr;
        this.rotm31 = -ctr * stp;
        this.rotm33 = cty * ctp - sty * str * stp;
        this.rfact = Math.pow(this.rotm31, 2.0) + Math.pow(this.rotm33, 2.0);
        this.roasin = Math.atan2(this.rotm31, this.rotm33);
        this.tmpscl = this.spinra / 3600000.0;
        double dec = this.declin * this.rdpdg;
        double sindec = Math.sin(dec);
        double cosdec = Math.cos(dec);
        double ras = this.rascen * this.rdpdg;
        double sinras = Math.sin(ras);
        double cosras = Math.cos(ras);
        this.b11 = -sinras;
        this.b12 = cosras;
        this.b13 = 0.0;
        this.b21 = -sindec * cosras;
        this.b22 = -sindec * sinras;
        this.b23 = cosdec;
        this.b31 = cosdec * cosras;
        this.b32 = cosdec * sinras;
        this.b33 = sindec;
        double raha = McIDASUtil.timdif(74001, 0, this.navday, 0) * 1.00273791 / 4.0 + 100.26467;
        double rac = raha % 360.0;
        if (rac < 0.0) {
            rac += 360.0;
        }
        this.xref = rac * this.rdpdg;
        this.pictim = McIDASUtil.mcPackedIntegerToDouble(jtime);
        this.gamma = (double)iarr[38] / 100.0;
        this.gamdot = (double)iarr[39] / 100.0;
        int iss = jday / 100000;
        if ((iss > 25 || iss == 12) && iarr[30] > 0) {
            this.scan1 = iarr[30];
            this.time1 = McIDASUtil.mcPackedIntegerToDouble(iarr[31]);
            this.scan2 = iarr[34];
            this.time2 = McIDASUtil.mcPackedIntegerToDouble(iarr[35]);
        } else {
            this.scan1 = 1.0;
            this.time1 = McIDASUtil.mcPackedIntegerToDouble(jtime);
            this.scan2 = this.lintot % 100000;
            this.time2 = this.time1 + this.scan2 * this.tmpscl;
        }
        this.iold = 0;
    }

    @Override
    public float[][] toLatLon(float[][] linele) {
        int number = linele[0].length;
        float[][] latlon = new float[2][number];
        float[][] imglinele = this.areaCoordToImageCoord(linele);
        for (int point = 0; point < number; ++point) {
            double xlin = imglinele[1][point];
            double xele = imglinele[0][point];
            int ilin = Math.round((float)xlin);
            double parlin = (ilin - 1) / this.numsen + 1;
            double framet = this.tmpscl * parlin;
            double samtim = framet + this.pictim;
            double[] xyz = this.satvec(samtim);
            double ylin = (xlin - this.piclin) * this.radlin;
            double yele = (xele - this.picele + this.gamma + this.gamdot * samtim) * this.radele;
            double xcor = this.b11 * xyz[0] + this.b12 * xyz[1] + this.b13 * xyz[2];
            double ycor = this.b21 * xyz[0] + this.b22 * xyz[1] + this.b23 * xyz[2];
            double rot = Math.atan2(ycor, xcor) + Math.PI;
            double coslin = Math.cos(ylin);
            double sinlin = Math.sin(ylin);
            double sinele = Math.sin(yele -= rot);
            double cosele = Math.cos(yele);
            double eli = this.rotm11 * coslin - this.rotm13 * sinlin;
            double emi = this.rotm21 * coslin - this.rotm23 * sinlin;
            double eni = this.rotm31 * coslin - this.rotm33 * sinlin;
            double temp = eli;
            eli = cosele * eli + sinele * emi;
            emi = -sinele * temp + cosele * emi;
            double elo = this.b11 * eli + this.b21 * emi + this.b31 * eni;
            double emo = this.b12 * eli + this.b22 * emi + this.b32 * eni;
            double eno = this.b13 * eli + this.b23 * emi + this.b33 * eni;
            double basq = this.bsq / this.asq;
            double onemsq = 1.0 - basq;
            double aq = basq + onemsq * Math.pow(eno, 2.0);
            double bq = 2.0 * ((elo * xyz[0] + emo * xyz[1]) * basq + eno * xyz[2]);
            double cq = (Math.pow(xyz[0], 2.0) + Math.pow(xyz[1], 2.0)) * basq + Math.pow(xyz[2], 2.0) - this.bsq;
            double rad = Math.pow(bq, 2.0) - 4.0 * aq * cq;
            if (rad < 1.0) {
                latlon[0][point] = Float.NaN;
                latlon[1][point] = Float.NaN;
                continue;
            }
            double s = -(bq + Math.sqrt(rad)) / (2.0 * aq);
            double x = xyz[0] + elo * s;
            double y = xyz[1] + emo * s;
            double z = xyz[2] + eno * s;
            double ct = Math.cos(this.emega * samtim + this.xref);
            double st = Math.sin(this.emega * samtim + this.xref);
            double x1 = ct * x + st * y;
            double y1 = -st * x + ct * y;
            double[] ll = this.nxyzll(x1, y1, z);
            latlon[0][point] = (float)ll[0];
            latlon[1][point] = this.isEastPositive ? (float)(-ll[1]) : (float)ll[1];
        }
        return latlon;
    }

    @Override
    public double[][] toLatLon(double[][] linele) {
        int number = linele[0].length;
        double[][] latlon = new double[2][number];
        double[][] imglinele = this.areaCoordToImageCoord(linele);
        for (int point = 0; point < number; ++point) {
            double xlin = imglinele[1][point];
            double xele = imglinele[0][point];
            int ilin = Math.round((float)xlin);
            double parlin = (ilin - 1) / this.numsen + 1;
            double framet = this.tmpscl * parlin;
            double samtim = framet + this.pictim;
            double[] xyz = this.satvec(samtim);
            double ylin = (xlin - this.piclin) * this.radlin;
            double yele = (xele - this.picele + this.gamma + this.gamdot * samtim) * this.radele;
            double xcor = this.b11 * xyz[0] + this.b12 * xyz[1] + this.b13 * xyz[2];
            double ycor = this.b21 * xyz[0] + this.b22 * xyz[1] + this.b23 * xyz[2];
            double rot = Math.atan2(ycor, xcor) + Math.PI;
            double coslin = Math.cos(ylin);
            double sinlin = Math.sin(ylin);
            double sinele = Math.sin(yele -= rot);
            double cosele = Math.cos(yele);
            double eli = this.rotm11 * coslin - this.rotm13 * sinlin;
            double emi = this.rotm21 * coslin - this.rotm23 * sinlin;
            double eni = this.rotm31 * coslin - this.rotm33 * sinlin;
            double temp = eli;
            eli = cosele * eli + sinele * emi;
            emi = -sinele * temp + cosele * emi;
            double elo = this.b11 * eli + this.b21 * emi + this.b31 * eni;
            double emo = this.b12 * eli + this.b22 * emi + this.b32 * eni;
            double eno = this.b13 * eli + this.b23 * emi + this.b33 * eni;
            double basq = this.bsq / this.asq;
            double onemsq = 1.0 - basq;
            double aq = basq + onemsq * Math.pow(eno, 2.0);
            double bq = 2.0 * ((elo * xyz[0] + emo * xyz[1]) * basq + eno * xyz[2]);
            double cq = (Math.pow(xyz[0], 2.0) + Math.pow(xyz[1], 2.0)) * basq + Math.pow(xyz[2], 2.0) - this.bsq;
            double rad = Math.pow(bq, 2.0) - 4.0 * aq * cq;
            if (rad < 1.0) {
                latlon[0][point] = Double.NaN;
                latlon[1][point] = Double.NaN;
                continue;
            }
            double s = -(bq + Math.sqrt(rad)) / (2.0 * aq);
            double x = xyz[0] + elo * s;
            double y = xyz[1] + emo * s;
            double z = xyz[2] + eno * s;
            double ct = Math.cos(this.emega * samtim + this.xref);
            double st = Math.sin(this.emega * samtim + this.xref);
            double x1 = ct * x + st * y;
            double y1 = -st * x + ct * y;
            double[] ll = this.nxyzll(x1, y1, z);
            latlon[0][point] = ll[0];
            latlon[1][point] = this.isEastPositive ? -ll[1] : ll[1];
        }
        return latlon;
    }

    @Override
    public float[][] toLinEle(float[][] latlon) {
        double[] xyzsat = new double[3];
        int number = latlon[0].length;
        float[][] linele = new float[2][number];
        for (int point = 0; point < number; ++point) {
            double xpar = latlon[0][point];
            double ypar = this.isEastPositive ? (double)(-latlon[1][point]) : (double)latlon[1][point];
            double xlin = Double.NaN;
            double xele = Double.NaN;
            if (Math.abs(xpar) <= 90.0) {
                double ctst;
                double umv;
                double x3;
                double vcses3;
                double vcste3;
                double vcste2;
                double vcste1;
                double st;
                double ct;
                double oldlin = 910.0;
                double orbtim = -99999.0;
                double zsat = 0.0;
                double ysat = 0.0;
                double xsat = 0.0;
                double z = 0.0;
                double y = 0.0;
                double x = 0.0;
                double znorm = 0.0;
                double xht = 0.0;
                double[] xyz = this.nllxyz(xpar, ypar);
                double x1 = xyz[0];
                double y1 = xyz[1];
                z = xyz[2];
                double samtim = this.time1;
                for (int i = 0; i < 2; ++i) {
                    if (Math.abs(samtim - orbtim) >= 5.0E-4) {
                        xyzsat = this.satvec(samtim);
                        xsat = xyzsat[0];
                        ysat = xyzsat[1];
                        zsat = xyzsat[2];
                        orbtim = samtim;
                        xht = Math.sqrt(Math.pow(xyzsat[0], 2.0) + Math.pow(xyzsat[1], 2.0) + Math.pow(xyzsat[2], 2.0));
                    }
                    ct = Math.cos(this.emega * samtim + this.xref);
                    st = Math.sin(this.emega * samtim + this.xref);
                    x = ct * x1 - st * y1;
                    y = st * x1 + ct * y1;
                    vcste1 = x - xsat;
                    vcste2 = y - ysat;
                    vcste3 = z - zsat;
                    vcses3 = this.b31 * vcste1 + this.b32 * vcste2 + this.b33 * vcste3;
                    znorm = Math.sqrt(Math.pow(vcste1, 2.0) + Math.pow(vcste2, 2.0) + Math.pow(vcste3, 2.0));
                    x3 = vcses3 / znorm;
                    umv = Math.atan2(x3, Math.sqrt(this.rfact - Math.pow(x3, 2.0))) - this.roasin;
                    xlin = this.piclin - umv / this.radlin;
                    if (i != 0) continue;
                    samtim = this.time2;
                    oldlin = xlin;
                }
                double scnnum = ((oldlin + xlin) / 2.0 - 1.0) / (double)this.numsen;
                double scnfrc = (scnnum - this.scan1) / (this.scan2 - this.scan1);
                xlin = oldlin + scnfrc * (xlin - oldlin);
                samtim = this.time1 + this.tmpscl * (scnnum - this.scan1);
                xyzsat = this.satvec(samtim);
                xsat = xyzsat[0];
                double cosa = x * xsat + y * (ysat = xyzsat[1]) + z * (zsat = xyzsat[2]);
                if (cosa >= (ctst = 1.0E-4 * this.r * xht + this.rsq)) {
                    double xsats1 = this.b11 * xsat + this.b12 * ysat + this.b13 * zsat;
                    double ysats2 = this.b21 * xsat + this.b22 * ysat + this.b23 * zsat;
                    ct = Math.cos(this.emega * samtim + this.xref);
                    st = Math.sin(this.emega * samtim + this.xref);
                    x = ct * x1 - st * y1;
                    y = st * x1 + ct * y1;
                    vcste1 = x - xsat;
                    vcste2 = y - ysat;
                    vcste3 = z - zsat;
                    double vcses1 = this.b11 * vcste1 + this.b12 * vcste2 + this.b13 * vcste3;
                    double vcses2 = this.b21 * vcste1 + this.b22 * vcste2 + this.b23 * vcste3;
                    vcses3 = this.b31 * vcste1 + this.b32 * vcste2 + this.b33 * vcste3;
                    double xnorm = Math.sqrt(Math.pow(znorm, 2.0) - Math.pow(vcses3, 2.0));
                    double ynorm = Math.sqrt(Math.pow(xsats1, 2.0) + Math.pow(ysats2, 2.0));
                    znorm = Math.sqrt(Math.pow(vcste1, 2.0) + Math.pow(vcste2, 2.0) + Math.pow(vcste3, 2.0));
                    x3 = vcses3 / znorm;
                    umv = Math.atan2(x3, Math.sqrt(this.rfact - Math.pow(x3, 2.0))) - this.roasin;
                    double slin = Math.sin(umv);
                    double clin = Math.cos(umv);
                    double u = this.rotm11 * clin + this.rotm13 * slin;
                    double v = this.rotm21 * clin + this.rotm23 * slin;
                    xele = this.picele + Math.asin((xsats1 * vcses2 - ysats2 * vcses1) / (xnorm * ynorm)) / this.radele;
                    xele += Math.atan2(v, u) / this.radele;
                    xele = xele - this.gamma - this.gamdot * samtim;
                }
            }
            linele[1][point] = (float)xlin;
            linele[0][point] = (float)xele;
        }
        return this.imageCoordToAreaCoord(linele, linele);
    }

    @Override
    public double[][] toLinEle(double[][] latlon) {
        double[] xyzsat = new double[3];
        int number = latlon[0].length;
        double[][] linele = new double[2][number];
        for (int point = 0; point < number; ++point) {
            double xpar = latlon[0][point];
            double ypar = this.isEastPositive ? -latlon[1][point] : latlon[1][point];
            double xlin = Double.NaN;
            double xele = Double.NaN;
            if (Math.abs(xpar) <= 90.0) {
                double ctst;
                double umv;
                double x3;
                double vcses3;
                double vcste3;
                double vcste2;
                double vcste1;
                double st;
                double ct;
                double oldlin = 910.0;
                double orbtim = -99999.0;
                double zsat = 0.0;
                double ysat = 0.0;
                double xsat = 0.0;
                double z = 0.0;
                double y = 0.0;
                double x = 0.0;
                double znorm = 0.0;
                double xht = 0.0;
                double[] xyz = this.nllxyz(xpar, ypar);
                double x1 = xyz[0];
                double y1 = xyz[1];
                z = xyz[2];
                double xdum = 0.0;
                double samtim = this.time1;
                for (int i = 0; i < 2; ++i) {
                    if (Math.abs(samtim - orbtim) >= 5.0E-4) {
                        xyzsat = this.satvec(samtim);
                        xsat = xyzsat[0];
                        ysat = xyzsat[1];
                        zsat = xyzsat[2];
                        orbtim = samtim;
                        xht = Math.sqrt(Math.pow(xyzsat[0], 2.0) + Math.pow(xyzsat[1], 2.0) + Math.pow(xyzsat[2], 2.0));
                    }
                    ct = Math.cos(this.emega * samtim + this.xref);
                    st = Math.sin(this.emega * samtim + this.xref);
                    x = ct * x1 - st * y1;
                    y = st * x1 + ct * y1;
                    vcste1 = x - xsat;
                    vcste2 = y - ysat;
                    vcste3 = z - zsat;
                    vcses3 = this.b31 * vcste1 + this.b32 * vcste2 + this.b33 * vcste3;
                    znorm = Math.sqrt(Math.pow(vcste1, 2.0) + Math.pow(vcste2, 2.0) + Math.pow(vcste3, 2.0));
                    x3 = vcses3 / znorm;
                    umv = Math.atan2(x3, Math.sqrt(this.rfact - Math.pow(x3, 2.0))) - this.roasin;
                    xlin = this.piclin - umv / this.radlin;
                    double parlin = (xlin - 1.0) / (double)this.numsen;
                    if (i != 0) continue;
                    samtim = this.time2;
                    oldlin = xlin;
                }
                double scnnum = ((oldlin + xlin) / 2.0 - 1.0) / (double)this.numsen;
                double scnfrc = (scnnum - this.scan1) / (this.scan2 - this.scan1);
                xlin = oldlin + scnfrc * (xlin - oldlin);
                samtim = this.time1 + this.tmpscl * (scnnum - this.scan1);
                xyzsat = this.satvec(samtim);
                xsat = xyzsat[0];
                double cosa = x * xsat + y * (ysat = xyzsat[1]) + z * (zsat = xyzsat[2]);
                if (cosa >= (ctst = 1.0E-4 * this.r * xht + this.rsq)) {
                    double xsats1 = this.b11 * xsat + this.b12 * ysat + this.b13 * zsat;
                    double ysats2 = this.b21 * xsat + this.b22 * ysat + this.b23 * zsat;
                    ct = Math.cos(this.emega * samtim + this.xref);
                    st = Math.sin(this.emega * samtim + this.xref);
                    x = ct * x1 - st * y1;
                    y = st * x1 + ct * y1;
                    vcste1 = x - xsat;
                    vcste2 = y - ysat;
                    vcste3 = z - zsat;
                    double vcses1 = this.b11 * vcste1 + this.b12 * vcste2 + this.b13 * vcste3;
                    double vcses2 = this.b21 * vcste1 + this.b22 * vcste2 + this.b23 * vcste3;
                    vcses3 = this.b31 * vcste1 + this.b32 * vcste2 + this.b33 * vcste3;
                    double xnorm = Math.sqrt(Math.pow(znorm, 2.0) - Math.pow(vcses3, 2.0));
                    double ynorm = Math.sqrt(Math.pow(xsats1, 2.0) + Math.pow(ysats2, 2.0));
                    znorm = Math.sqrt(Math.pow(vcste1, 2.0) + Math.pow(vcste2, 2.0) + Math.pow(vcste3, 2.0));
                    x3 = vcses3 / znorm;
                    umv = Math.atan2(x3, Math.sqrt(this.rfact - Math.pow(x3, 2.0))) - this.roasin;
                    double slin = Math.sin(umv);
                    double clin = Math.cos(umv);
                    double u = this.rotm11 * clin + this.rotm13 * slin;
                    double v = this.rotm21 * clin + this.rotm23 * slin;
                    xele = this.picele + Math.asin((xsats1 * vcses2 - ysats2 * vcses1) / (xnorm * ynorm)) / this.radele;
                    xele += Math.atan2(v, u) / this.radele;
                    xele = xele - this.gamma - this.gamdot * samtim;
                }
            }
            linele[1][point] = xlin;
            linele[0][point] = xele;
        }
        return this.imageCoordToAreaCoord(linele, linele);
    }

    private int icon1(int yymmdd) {
        int[] num = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
        int year = yymmdd / 10000 % 100;
        int month = yymmdd / 100 % 100;
        int day = yymmdd % 100;
        if (month < 0 || month > 12) {
            month = 1;
        }
        int julday = day + num[month - 1];
        if (year % 4 == 0 && month > 2) {
            ++julday;
        }
        return 1000 * year + julday;
    }

    private void epoch(int ietimy, int ietimh, double semima, double oeccen, double xmeana) {
        double RDPDG = Math.PI / 180;
        double RE2 = 6378.388;
        double GRACON = 0.07436574;
        double axmmc = GRACON * Math.pow(Math.sqrt(RE2 / semima), 3.0);
        double xmanom = RDPDG * xmeana;
        double time = (xmanom - oeccen * Math.sin(xmanom)) / (60.0 * axmmc);
        double time1 = McIDASUtil.mcPackedIntegerToDouble(ietimh);
        time = time1 - time;
        int iday = 0;
        if (time > 48.0) {
            time -= 48.0;
            iday = 2;
        } else if (time > 24.0) {
            time -= 24.0;
            iday = 1;
        } else if (time < -24.0) {
            time += 48.0;
            iday = -2;
        } else if (time < 0.0) {
            time += 24.0;
            iday = -1;
        }
        this.ietimh = McIDASUtil.mcDoubleToPackedInteger(time);
        if (iday != 0) {
            int jyear = ietimy / 1000 % 100;
            jyear += 1000;
            int jday = ietimy % 1000;
            if ((jday += iday) < 1) {
                jday = this.leapyr(--jyear) + jday;
            } else {
                int jtot = this.leapyr(jyear);
                if (jday > jtot) {
                    ++jyear;
                    jday += jtot;
                }
            }
            this.ietimy = 1000 * (jyear %= 100) + jday;
        }
    }

    private int leapyr(int iy) {
        return 366 - (iy % 4 + 3) / 4;
    }

    private double[] nllxyz(double xlat, double xlon) {
        double ylat = this.rdpdg * xlat;
        ylat = Math.atan2(this.bsq * Math.sin(ylat), this.asq * Math.cos(ylat));
        double ylon = -this.rdpdg * xlon;
        double snlt = Math.sin(ylat);
        double cslt = Math.cos(ylat);
        double csln = Math.cos(ylon);
        double snln = Math.sin(ylon);
        double tnlt = Math.pow(snlt / cslt, 2.0);
        double r = this.ab * Math.sqrt((1.0 + tnlt) / (this.bsq + this.asq * tnlt));
        double x = r * cslt * csln;
        double y = r * cslt * snln;
        double z = r * snlt;
        return new double[]{x, y, z};
    }

    private double[] nxyzll(double x, double y, double z) {
        double xlat = Double.NaN;
        double xlon = Double.NaN;
        if (x != 0.0 && y != 0.0 && z != 0.0) {
            double a = Math.atan(z / Math.sqrt(x * x + y * y));
            xlat = Math.atan2(this.asq * Math.sin(a), this.bsq * Math.cos(a)) / this.rdpdg;
            xlon = -Math.atan2(y, x) / this.rdpdg;
        }
        return new double[]{xlat, xlon};
    }

    private double[] satvec(double samtim) {
        double xmanom;
        if (this.iold != 1) {
            this.iold = 1;
            double rdpdg = Math.PI / 180;
            double re = 6378.388;
            double gracon = 0.07436574;
            double sha = 100.26467;
            sha = rdpdg * sha;
            int irayd = 74001;
            int irahms = 0;
            double o = rdpdg * this.orbinc;
            double p = rdpdg * this.perhel;
            double a = rdpdg * this.asnode;
            double so = Math.sin(o);
            double co = Math.cos(o);
            double sp = Math.sin(p) * this.semima;
            double cp = Math.cos(p) * this.semima;
            double sa = Math.sin(a);
            double ca = Math.cos(a);
            this.px = cp * ca - sp * sa * co;
            this.py = cp * sa + sp * ca * co;
            this.pz = sp * so;
            this.qx = -sp * ca - cp * sa * co;
            this.qy = -sp * sa + cp * ca * co;
            this.qz = cp * so;
            this.srome2 = Math.sqrt(1.0 - this.oeccen) * Math.sqrt(1.0 + this.oeccen);
            this.xmmc = gracon * re * Math.sqrt(re / this.semima) / this.semima;
            int iey = this.ietimy / 1000 % 100;
            int ied = this.ietimy % 1000;
            int iefac = (iey - 1) / 4 + 1;
            double de = 365 * (iey - 1) + iefac + ied - 1;
            double te = 1440.0 * de + 60.0 * McIDASUtil.mcPackedIntegerToDouble(this.ietimh);
            int iray = irayd / 1000;
            int irad = irayd % 1000;
            int irafac = (iray - 1) / 4 + 1;
            double dra = 365 * (iray - 1) + irafac + irad - 1;
            double tra = 1440.0 * dra + 60.0 * McIDASUtil.mcPackedIntegerToDouble(irahms);
            int inavy = this.navday / 1000 % 100;
            int inavd = this.navday % 1000;
            int infac = (inavy - 1) / 4 + 1;
            double dnav = 365 * (inavy - 1) + infac + inavd - 1;
            this.tdife = dnav * 1440.0 - te;
            double tdifra = dnav * 1440.0 - tra;
            this.epsiln = 1.0E-8;
        }
        double timsam = samtim * 60.0;
        double diftim = this.tdife + timsam;
        double ecanm1 = xmanom = this.xmmc * diftim;
        double ecanom = 0.0;
        int i = 0;
        for (i = 0; i < 20 && !(Math.abs((ecanom = xmanom + this.oeccen * Math.sin(ecanm1)) - ecanm1) < this.epsiln); ++i) {
            ecanm1 = ecanom;
        }
        double xomega = Math.cos(ecanom) - this.oeccen;
        double yomega = this.srome2 * Math.sin(ecanom);
        double z = xomega * this.pz + yomega * this.qz;
        double y = xomega * this.py + yomega * this.qy;
        double x = xomega * this.px + yomega * this.qx;
        return new double[]{x, y, z};
    }

    @Override
    public double[] getSubpoint() {
        double samtim = this.time1;
        double[] xyzsat = this.satvec(samtim);
        double ct = Math.cos(this.emega * samtim + this.xref);
        double st = Math.sin(this.emega * samtim + this.xref);
        double x = xyzsat[0];
        double y = xyzsat[1];
        double z = xyzsat[2];
        double x1 = ct * x + st * y;
        double y1 = -st * x + ct * y;
        double[] ll = this.nxyzll(x1, y1, z);
        double ssp_lat = ll[0];
        double ssp_lon = this.isEastPositive ? -ll[1] : ll[1];
        return new double[]{ssp_lat, ssp_lon};
    }
}

