/*
 * Decompiled with CFR 0.152.
 */
package dods.dap.Server;

import dods.dap.BaseType;
import dods.dap.Server.AbstractClause;
import dods.dap.Server.BTFunction;
import dods.dap.Server.Clause;
import dods.dap.Server.SDODSException;
import dods.dap.Server.SubClause;
import java.util.Iterator;
import java.util.List;

public class BTFunctionClause
extends AbstractClause
implements SubClause {
    protected Clause parent;
    protected BTFunction function;
    protected BaseType value;

    protected BTFunctionClause(BTFunction function, List children) throws SDODSException {
        function.checkArgs(children);
        this.function = function;
        this.children = children;
        this.constant = true;
        for (SubClause current : children) {
            current.setParent(this);
            if (current.isConstant()) continue;
            this.constant = false;
        }
        this.value = function.getReturnType(children);
        if (this.constant) {
            this.evaluate();
        }
    }

    public Clause getParent() {
        return this.parent;
    }

    public BaseType getValue() {
        return this.value;
    }

    public BaseType evaluate() throws SDODSException {
        if (!this.constant || !this.defined) {
            this.value = this.function.evaluate(this.children);
            this.defined = true;
        }
        return this.value;
    }

    public void setParent(Clause parent) {
        this.parent = parent;
    }

    public BTFunction getFunction() {
        return this.function;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.function.getName());
        buf.append("(");
        Iterator it = this.children.iterator();
        if (it.hasNext()) {
            buf.append(it.next().toString());
        }
        while (it.hasNext()) {
            buf.append(",");
            buf.append(it.next().toString());
        }
        buf.append(")");
        return buf.toString();
    }
}

