/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.quantities;

import java.rmi.RemoteException;
import ucar.visad.Util;
import ucar.visad.VisADMath;
import ucar.visad.quantities.CommonUnits;
import ucar.visad.quantities.MolecularWeightOfDryAir;
import ucar.visad.quantities.MolecularWeightOfWater;
import ucar.visad.quantities.SaturationVaporPressure;
import ucar.visad.quantities.ScalarQuantity;
import visad.CommonUnit;
import visad.Data;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.TypeException;
import visad.UnitException;
import visad.VisADException;

public class WaterVaporMixingRatio
extends ScalarQuantity {
    private static WaterVaporMixingRatio INSTANCE;
    private static Real gasConstantRatio;

    private WaterVaporMixingRatio() throws VisADException {
        this("WaterVaporMixingRatio");
    }

    protected WaterVaporMixingRatio(String name) throws VisADException {
        super(name, CommonUnits.GRAMS_PER_KILOGRAM, (Set)null);
    }

    public static RealType getRealType() throws VisADException {
        return (RealType)WaterVaporMixingRatio.getRealTupleType().getComponent(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RealTupleType getRealTupleType() throws VisADException {
        if (INSTANCE != null) return INSTANCE.realTupleType();
        Class<WaterVaporMixingRatio> clazz = WaterVaporMixingRatio.class;
        synchronized (WaterVaporMixingRatio.class) {
            if (INSTANCE != null) return INSTANCE.realTupleType();
            INSTANCE = new WaterVaporMixingRatio();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE.realTupleType();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Real getGasConstantRatio() throws VisADException {
        if (gasConstantRatio != null) return gasConstantRatio;
        Class<WaterVaporMixingRatio> clazz = WaterVaporMixingRatio.class;
        synchronized (WaterVaporMixingRatio.class) {
            if (gasConstantRatio != null) return gasConstantRatio;
            try {
                gasConstantRatio = new Real(RealType.getRealType("WaterVaporMixingRatioGasConstantRatio", CommonUnit.dimensionless, null), ((Real)VisADMath.divide(MolecularWeightOfWater.newReal(), MolecularWeightOfDryAir.newReal())).getValue(CommonUnit.dimensionless));
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return gasConstantRatio;
        }
    }

    public static Data create(Data pressure, Data temperature) throws TypeException, VisADException, UnitException, RemoteException {
        Data saturationVaporPressure = SaturationVaporPressure.create(temperature);
        return Util.clone(VisADMath.multiply(WaterVaporMixingRatio.getGasConstantRatio(), VisADMath.divide(saturationVaporPressure, VisADMath.subtract(pressure, saturationVaporPressure))), WaterVaporMixingRatio.getRealType());
    }

    public static Data create(Data specificHumidity) throws TypeException, VisADException, UnitException, RemoteException {
        return Util.clone(VisADMath.divide(specificHumidity, VisADMath.subtract(new Real(1.0), specificHumidity)), WaterVaporMixingRatio.getRealType());
    }
}

