/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.quantities;

import java.rmi.RemoteException;
import ucar.visad.Util;
import ucar.visad.VisADMath;
import ucar.visad.quantities.AirTemperature;
import ucar.visad.quantities.Temperature;
import ucar.visad.quantities.WaterVaporMixingRatio;
import visad.CommonUnit;
import visad.Data;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.TypeException;
import visad.UnimplementedException;
import visad.VisADException;

public class VirtualTemperature
extends AirTemperature {
    private static VirtualTemperature INSTANCE;
    private static Real constantA;
    private static Real constantB;

    private VirtualTemperature() throws VisADException {
        this("VirtualTemperature");
    }

    protected VirtualTemperature(String name) throws VisADException {
        super(name);
    }

    public static RealType getRealType() throws VisADException {
        return (RealType)VirtualTemperature.getRealTupleType().getComponent(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RealTupleType getRealTupleType() throws VisADException {
        if (INSTANCE != null) return INSTANCE.realTupleType();
        Class<VirtualTemperature> clazz = VirtualTemperature.class;
        synchronized (VirtualTemperature.class) {
            if (INSTANCE != null) return INSTANCE.realTupleType();
            INSTANCE = new VirtualTemperature();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE.realTupleType();
        }
    }

    public static Data createFromDewPoint(Data pressure, Data temperature, Data dewPoint) throws TypeException, UnimplementedException, VisADException, RemoteException {
        return VirtualTemperature.createFromMixingRatio(temperature, WaterVaporMixingRatio.create(pressure, dewPoint));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Data createFromMixingRatio(Data temperature, Data mixingRatio) throws TypeException, UnimplementedException, VisADException, RemoteException {
        Util.vetType(Temperature.getRealType(), temperature);
        Util.vetType(WaterVaporMixingRatio.getRealType(), mixingRatio);
        if (constantA != null) return Util.clone(VisADMath.multiply(temperature, VisADMath.add(constantA, VisADMath.multiply(constantB, mixingRatio))), VirtualTemperature.getRealType());
        Class<VirtualTemperature> clazz = VirtualTemperature.class;
        synchronized (VirtualTemperature.class) {
            if (constantA != null) return Util.clone(VisADMath.multiply(temperature, VisADMath.add(constantA, VisADMath.multiply(constantB, mixingRatio))), VirtualTemperature.getRealType());
            constantA = new Real(RealType.getRealType("VirtualTemperatureConstantA", CommonUnit.dimensionless, null), 1.0);
            constantB = new Real(RealType.getRealType("VirtualTemperatureConstantB", CommonUnit.dimensionless, null), 0.61);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return Util.clone(VisADMath.multiply(temperature, VisADMath.add(constantA, VisADMath.multiply(constantB, mixingRatio))), VirtualTemperature.getRealType());
        }
    }
}

