/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.quantities;

import ucar.visad.quantities.Quantity;
import visad.CoordinateSystem;
import visad.DoubleSet;
import visad.FloatSet;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.TypeException;
import visad.Unit;
import visad.VisADException;

public abstract class ScalarQuantity
extends Quantity {
    protected ScalarQuantity(String name, Unit unit, Set set) throws VisADException {
        this(ScalarQuantity.getRealType(name, unit, set));
    }

    protected static RealType getRealType(String name, Unit unit) throws TypeException, VisADException {
        return ScalarQuantity.getRealType(name, unit, null);
    }

    protected static RealType getRealType(String name, Unit unit, Set set) throws TypeException, VisADException {
        RealType realType = RealType.getRealTypeByName(name);
        if (realType == null) {
            realType = RealType.getRealType(name, unit, set);
        } else {
            Unit oldUnit = realType.getDefaultUnit();
            if (!Unit.canConvert(oldUnit, unit)) {
                throw new TypeException("\"" + name + "\" RealType already exists with incompatible unit: " + oldUnit + ", " + unit + ")");
            }
            Set oldSet = realType.getDefaultSet();
            if (set != null && (set instanceof DoubleSet && !(oldSet instanceof DoubleSet) || set instanceof FloatSet && !(oldSet instanceof DoubleSet) && !(oldSet instanceof FloatSet))) {
                throw new TypeException("\"" + name + "\" RealType already exists with incompatible set: " + oldSet + ", " + set + ")");
            }
        }
        return realType;
    }

    protected ScalarQuantity(RealType realType) throws VisADException {
        this(realType, null);
    }

    protected ScalarQuantity(RealType realType, CoordinateSystem defaultCS) throws VisADException {
        this(realType, defaultCS, (Set)null);
    }

    protected ScalarQuantity(RealType realType, CoordinateSystem defaultCS, Set defaultSet) throws VisADException {
        this(new RealTupleType(realType, defaultCS, defaultSet));
    }

    protected ScalarQuantity(RealTupleType realTupleType) {
        super(realTupleType);
    }

    protected final RealType realType() throws VisADException {
        return (RealType)this.realTupleType().getComponent(0);
    }
}

