/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.quantities;

import java.rmi.RemoteException;
import ucar.visad.Util;
import ucar.visad.VisADMath;
import ucar.visad.quantities.AirTemperature;
import ucar.visad.quantities.CommonUnits;
import ucar.visad.quantities.Pressure;
import ucar.visad.quantities.Temperature;
import visad.CommonUnit;
import visad.Data;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.SI;
import visad.TypeException;
import visad.UnimplementedException;
import visad.UnitException;
import visad.VisADException;

public class SaturationVaporPressure
extends Pressure {
    protected static Real two;
    private static SaturationVaporPressure INSTANCE;
    private static Real eSat0;
    private static Real temperatureMultiplier;
    private static Real temperatureConstant1;
    private static Real temperatureConstant2;
    private static Real temperatureConstantDifference;
    private static Real constantProduct;
    private static RealType temperatureDerivativeRealType;

    private SaturationVaporPressure() throws VisADException {
        this("SaturationVaporPressure");
    }

    protected SaturationVaporPressure(String name) throws VisADException {
        super(name);
    }

    public static RealType getRealType() throws VisADException {
        return (RealType)SaturationVaporPressure.getRealTupleType().getComponent(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RealTupleType getRealTupleType() throws VisADException {
        if (INSTANCE != null) return INSTANCE.realTupleType();
        Class<SaturationVaporPressure> clazz = SaturationVaporPressure.class;
        synchronized (SaturationVaporPressure.class) {
            if (INSTANCE != null) return INSTANCE.realTupleType();
            INSTANCE = new SaturationVaporPressure();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE.realTupleType();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RealType getTemperatureDerivativeRealType() throws VisADException {
        if (temperatureDerivativeRealType != null) return temperatureDerivativeRealType;
        Class<SaturationVaporPressure> clazz = SaturationVaporPressure.class;
        synchronized (SaturationVaporPressure.class) {
            if (temperatureDerivativeRealType != null) return temperatureDerivativeRealType;
            temperatureDerivativeRealType = RealType.getRealType("TemperatureDerivativeOfSaturationVaporPressure", SaturationVaporPressure.getRealType().getDefaultUnit().divide(SI.kelvin), null);
            // ** MonitorExit[var0] (shouldn't be in output)
            return temperatureDerivativeRealType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Real getConstantProduct() throws VisADException {
        if (constantProduct != null) return constantProduct;
        Class<SaturationVaporPressure> clazz = SaturationVaporPressure.class;
        synchronized (SaturationVaporPressure.class) {
            if (constantProduct != null) return constantProduct;
            try {
                constantProduct = (Real)SaturationVaporPressure.getTemperatureMultiplier().multiply(SaturationVaporPressure.getTemperatureConstant1());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return constantProduct;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Real getTemperatureConstant2() throws VisADException {
        if (temperatureConstant2 != null) return temperatureConstant2;
        Class<SaturationVaporPressure> clazz = SaturationVaporPressure.class;
        synchronized (SaturationVaporPressure.class) {
            if (temperatureConstant2 != null) return temperatureConstant2;
            temperatureConstant2 = new Real(Temperature.getRealType(), 29.66, SI.kelvin);
            // ** MonitorExit[var0] (shouldn't be in output)
            return temperatureConstant2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Real getTemperatureMultiplier() throws VisADException {
        if (temperatureMultiplier != null) return temperatureMultiplier;
        Class<SaturationVaporPressure> clazz = SaturationVaporPressure.class;
        synchronized (SaturationVaporPressure.class) {
            if (temperatureMultiplier != null) return temperatureMultiplier;
            temperatureMultiplier = new Real(RealType.getRealType("SaturationVaporPressureTemperatureMultiplier", CommonUnit.dimensionless, null), 17.67);
            // ** MonitorExit[var0] (shouldn't be in output)
            return temperatureMultiplier;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Real getESat0() throws VisADException {
        if (eSat0 != null) return eSat0;
        Class<SaturationVaporPressure> clazz = SaturationVaporPressure.class;
        synchronized (SaturationVaporPressure.class) {
            if (eSat0 != null) return eSat0;
            eSat0 = new Real(SaturationVaporPressure.getRealType(), 611.2, CommonUnits.PASCAL);
            // ** MonitorExit[var0] (shouldn't be in output)
            return eSat0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Real getTemperatureConstant1() throws VisADException {
        if (temperatureConstant1 != null) return temperatureConstant1;
        Class<SaturationVaporPressure> clazz = SaturationVaporPressure.class;
        synchronized (SaturationVaporPressure.class) {
            if (temperatureConstant1 != null) return temperatureConstant1;
            temperatureConstant1 = new Real(Temperature.getRealType(), 273.16, SI.kelvin);
            // ** MonitorExit[var0] (shouldn't be in output)
            return temperatureConstant1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Real getTemperatureConstantDifference() throws VisADException {
        if (temperatureConstantDifference != null) return temperatureConstant1;
        Class<SaturationVaporPressure> clazz = SaturationVaporPressure.class;
        synchronized (SaturationVaporPressure.class) {
            try {
                if (temperatureConstantDifference != null) return temperatureConstant1;
                temperatureConstantDifference = (Real)VisADMath.subtract(SaturationVaporPressure.getTemperatureConstant1(), SaturationVaporPressure.getTemperatureConstant2());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return temperatureConstant1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Real getTwo() throws VisADException {
        if (two != null) return two;
        Class<SaturationVaporPressure> clazz = SaturationVaporPressure.class;
        synchronized (SaturationVaporPressure.class) {
            if (two != null) return two;
            two = new Real(RealType.getRealType("SaturationVaporPressureTwo", CommonUnit.dimensionless, null), 2.0);
            // ** MonitorExit[var0] (shouldn't be in output)
            return two;
        }
    }

    public static Data create(Data temperature) throws TypeException, UnitException, UnimplementedException, VisADException, RemoteException {
        Util.vetType(Temperature.getRealType(), temperature);
        return Util.clone(VisADMath.multiply(SaturationVaporPressure.getESat0(), VisADMath.exp(VisADMath.multiply(SaturationVaporPressure.getTemperatureMultiplier(), VisADMath.divide(VisADMath.subtract(temperature, SaturationVaporPressure.getTemperatureConstant1()), VisADMath.subtract(temperature, SaturationVaporPressure.getTemperatureConstant2()))))), SaturationVaporPressure.getRealType());
    }

    public static Data temperatureDerivative(Data temperature) throws TypeException, UnitException, UnimplementedException, VisADException, RemoteException {
        Real tempDiff = (Real)VisADMath.subtract(temperature, SaturationVaporPressure.getTemperatureConstant2());
        return Util.clone(VisADMath.multiply(VisADMath.multiply(SaturationVaporPressure.getTemperatureMultiplier(), SaturationVaporPressure.create(temperature)), VisADMath.divide(SaturationVaporPressure.getTemperatureConstantDifference(), VisADMath.multiply(tempDiff, (Data)tempDiff))), SaturationVaporPressure.getTemperatureDerivativeRealType());
    }

    public static Data createTemperature(Data eSat, RealType outputType) throws TypeException, UnitException, VisADException, RemoteException {
        Util.vetType(SaturationVaporPressure.getRealType(), eSat);
        if (outputType == null) {
            outputType = AirTemperature.getRealType();
        }
        Data log = VisADMath.log(VisADMath.divide(eSat, SaturationVaporPressure.getESat0()));
        return Util.clone(VisADMath.divide(VisADMath.subtract(VisADMath.multiply(SaturationVaporPressure.getTemperatureConstant2(), log), SaturationVaporPressure.getConstantProduct()), VisADMath.subtract(log, SaturationVaporPressure.getTemperatureMultiplier())), outputType);
    }

    public static Data createTemperature(Data eSat) throws TypeException, UnitException, VisADException, RemoteException {
        return SaturationVaporPressure.createTemperature(eSat, null);
    }
}

