/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.quantities;

import java.rmi.RemoteException;
import ucar.visad.Util;
import ucar.visad.VisADMath;
import ucar.visad.quantities.AirPressure;
import ucar.visad.quantities.AirTemperature;
import ucar.visad.quantities.CommonUnits;
import ucar.visad.quantities.WaterVaporMixingRatio;
import visad.CommonUnit;
import visad.Data;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.SI;
import visad.TypeException;
import visad.Unit;
import visad.VisADException;

public final class SaturationPointTemperature
extends AirTemperature {
    private static SaturationPointTemperature INSTANCE;
    private static Real numerator;
    private static Real logTCoeff;
    private static Real t0;
    private static Real p0;
    private static Real denomConst;
    private static Real tempConst;

    private SaturationPointTemperature() throws VisADException {
        super("SaturationPointTemperature");
    }

    public static RealType getRealType() throws VisADException {
        return (RealType)SaturationPointTemperature.getRealTupleType().getComponent(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RealTupleType getRealTupleType() throws VisADException {
        if (INSTANCE != null) return INSTANCE.realTupleType();
        Class<SaturationPointTemperature> clazz = SaturationPointTemperature.class;
        synchronized (SaturationPointTemperature.class) {
            if (INSTANCE != null) return INSTANCE.realTupleType();
            INSTANCE = new SaturationPointTemperature();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE.realTupleType();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static Real getNumerator() throws VisADException {
        if (numerator != null) return numerator;
        Class<SaturationPointTemperature> clazz = SaturationPointTemperature.class;
        synchronized (SaturationPointTemperature.class) {
            if (numerator != null) return numerator;
            numerator = new Real(RealType.getRealType("SaturationPointTemperatureNumerator", (Unit)SI.kelvin, null), 2840.0);
            // ** MonitorExit[var0] (shouldn't be in output)
            return numerator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static Real getLogTCoeff() throws VisADException {
        if (logTCoeff != null) return logTCoeff;
        Class<SaturationPointTemperature> clazz = SaturationPointTemperature.class;
        synchronized (SaturationPointTemperature.class) {
            if (logTCoeff != null) return logTCoeff;
            logTCoeff = new Real(RealType.getRealType("SaturationPointTemperatureLogTCoef", CommonUnit.dimensionless, null), 3.5);
            // ** MonitorExit[var0] (shouldn't be in output)
            return logTCoeff;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static Real getP0() throws VisADException {
        if (p0 != null) return p0;
        Class<SaturationPointTemperature> clazz = SaturationPointTemperature.class;
        synchronized (SaturationPointTemperature.class) {
            if (p0 != null) return p0;
            p0 = new Real(RealType.getRealType("SaturationPointTemperatureP0", CommonUnits.PASCAL, null), 1000.0);
            // ** MonitorExit[var0] (shouldn't be in output)
            return p0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static Real getT0() throws VisADException {
        if (t0 != null) return t0;
        Class<SaturationPointTemperature> clazz = SaturationPointTemperature.class;
        synchronized (SaturationPointTemperature.class) {
            if (t0 != null) return t0;
            t0 = new Real(RealType.getRealType("SaturationPointTemperatureT0", (Unit)SI.kelvin, null), 1.0);
            // ** MonitorExit[var0] (shouldn't be in output)
            return t0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static Real getDenomConst() throws VisADException {
        if (denomConst != null) return denomConst;
        Class<SaturationPointTemperature> clazz = SaturationPointTemperature.class;
        synchronized (SaturationPointTemperature.class) {
            if (denomConst != null) return denomConst;
            denomConst = new Real(RealType.getRealType("SaturationPointTemperatureDenomConst", CommonUnit.dimensionless, null), 7.108);
            // ** MonitorExit[var0] (shouldn't be in output)
            return denomConst;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static Real getTempConst() throws VisADException {
        if (tempConst != null) return tempConst;
        Class<SaturationPointTemperature> clazz = SaturationPointTemperature.class;
        synchronized (SaturationPointTemperature.class) {
            if (tempConst != null) return tempConst;
            tempConst = new Real(RealType.getRealType("SaturationPointTemperatureTempConst", (Unit)SI.kelvin, null), 55.0);
            // ** MonitorExit[var0] (shouldn't be in output)
            return tempConst;
        }
    }

    public static Data create(Data pressure, Data temperature, Data mixingRatio) throws TypeException, VisADException, RemoteException {
        Util.vetType(AirPressure.getRealType(), pressure);
        Util.vetType(AirTemperature.getRealType(), temperature);
        Util.vetType(WaterVaporMixingRatio.getRealType(), mixingRatio);
        return Util.clone(VisADMath.add(VisADMath.divide(SaturationPointTemperature.getNumerator(), VisADMath.subtract(VisADMath.subtract(VisADMath.multiply(SaturationPointTemperature.getLogTCoeff(), VisADMath.log(VisADMath.divide(temperature, SaturationPointTemperature.getT0()))), VisADMath.log(VisADMath.divide(VisADMath.multiply(mixingRatio, VisADMath.divide(pressure, SaturationPointTemperature.getP0())), VisADMath.add(mixingRatio, (Data)WaterVaporMixingRatio.getGasConstantRatio())))), SaturationPointTemperature.getDenomConst())), (Data)SaturationPointTemperature.getTempConst()), SaturationPointTemperature.getRealType());
    }
}

