/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.quantities;

import java.rmi.RemoteException;
import ucar.visad.Util;
import ucar.visad.VisADMath;
import ucar.visad.quantities.AirPressure;
import ucar.visad.quantities.AirTemperature;
import ucar.visad.quantities.SaturationPointTemperature;
import visad.CommonUnit;
import visad.Data;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.TypeException;
import visad.VisADException;

public final class SaturationPointPressure
extends AirPressure {
    private static SaturationPointPressure INSTANCE;
    private static Real exponent;

    private SaturationPointPressure() throws VisADException {
        super("SaturationPointPressure");
    }

    public static RealType getRealType() throws VisADException {
        return (RealType)SaturationPointPressure.getRealTupleType().getComponent(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RealTupleType getRealTupleType() throws VisADException {
        if (INSTANCE != null) return INSTANCE.realTupleType();
        Class<SaturationPointPressure> clazz = SaturationPointPressure.class;
        synchronized (SaturationPointPressure.class) {
            if (INSTANCE != null) return INSTANCE.realTupleType();
            INSTANCE = new SaturationPointPressure();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE.realTupleType();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static Real getExponent() throws VisADException {
        if (exponent != null) return exponent;
        Class<SaturationPointPressure> clazz = SaturationPointPressure.class;
        synchronized (SaturationPointPressure.class) {
            if (exponent != null) return exponent;
            exponent = new Real(RealType.getRealType("SaturationPointTemperatureExponent", CommonUnit.dimensionless, null), 3.5);
            // ** MonitorExit[var0] (shouldn't be in output)
            return exponent;
        }
    }

    public static Data create(Data pressure, Data temperature, Data saturationPointTemperature) throws TypeException, VisADException, RemoteException {
        Util.vetType(AirPressure.getRealType(), pressure);
        Util.vetType(AirTemperature.getRealType(), temperature);
        Util.vetType(SaturationPointTemperature.getRealType(), saturationPointTemperature);
        return Util.clone(VisADMath.multiply(pressure, VisADMath.pow(VisADMath.divide(saturationPointTemperature, temperature), SaturationPointPressure.getExponent())), SaturationPointPressure.getRealType());
    }
}

