/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.quantities;

import java.rmi.RemoteException;
import ucar.visad.Util;
import ucar.visad.VisADMath;
import ucar.visad.quantities.AirPressure;
import ucar.visad.quantities.AirTemperature;
import ucar.visad.quantities.CommonUnits;
import ucar.visad.quantities.InSituAirTemperature;
import ucar.visad.quantities.Pressure;
import ucar.visad.quantities.SaturationVaporPressure;
import ucar.visad.quantities.WaterVaporMixingRatio;
import visad.Data;
import visad.DataShadow;
import visad.Field;
import visad.Function;
import visad.FunctionImpl;
import visad.FunctionType;
import visad.MathType;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.ShadowType;
import visad.Tuple;
import visad.TypeException;
import visad.UnimplementedException;
import visad.UnitException;
import visad.VisADException;

public final class SaturationMixingRatio
extends WaterVaporMixingRatio {
    private static SaturationMixingRatio INSTANCE;
    private static RealType myRealType;
    private static Function myFunction;

    private SaturationMixingRatio() throws VisADException {
        super("SaturationMixingRatio");
    }

    public static RealType getRealType() throws VisADException {
        return (RealType)SaturationMixingRatio.getRealTupleType().getComponent(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RealTupleType getRealTupleType() throws VisADException {
        if (INSTANCE != null) return INSTANCE.realTupleType();
        Class<SaturationMixingRatio> clazz = SaturationMixingRatio.class;
        synchronized (SaturationMixingRatio.class) {
            if (INSTANCE != null) return INSTANCE.realTupleType();
            INSTANCE = new SaturationMixingRatio();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE.realTupleType();
        }
    }

    public static Data createTemperature(Data pressure, Data rSat) throws TypeException, UnitException, VisADException, RemoteException {
        Util.vetType(Pressure.getRealType(), pressure);
        Util.vetType(SaturationMixingRatio.getRealType(), rSat);
        return SaturationVaporPressure.createTemperature(Util.clone(VisADMath.divide(VisADMath.multiply(rSat, pressure), VisADMath.add(SaturationMixingRatio.getGasConstantRatio(), rSat)), SaturationVaporPressure.getRealType()));
    }

    public static Data create(Data pressure, Data temperature) throws TypeException, UnitException, UnimplementedException, VisADException, RemoteException {
        Util.vetType(InSituAirTemperature.getRealType(), temperature);
        return Util.clone(WaterVaporMixingRatio.create(pressure, temperature), SaturationMixingRatio.getRealType());
    }

    public static Function newFunction() {
        return myFunction;
    }

    static {
        try {
            myRealType = RealType.getRealType("SaturationMixingRatio", CommonUnits.GRAMS_PER_KILOGRAM, null);
            myFunction = new MyFunction();
        }
        catch (Exception e) {
            System.err.println("SaturationMixingRatio.<clinit>: Couldn't initialize class: " + e);
            System.exit(1);
        }
    }

    protected static class MyFunction
    extends FunctionImpl {
        private static Tuple gradient;

        public MyFunction() throws VisADException {
            super(new FunctionType(new RealTupleType(AirPressure.getRealType(), AirTemperature.getRealType()), myRealType));
        }

        @Override
        public Data derivative(int errorMode) {
            return gradient;
        }

        @Override
        public Data derivative(MathType[] partials, int errorMode) {
            return null;
        }

        @Override
        public Data derivative(RealTuple location, RealType[] inputPartials, MathType[] outputPartials, int errorMode) {
            return null;
        }

        @Override
        public Function derivative(RealType inputPartial, int errorMode) {
            return null;
        }

        @Override
        public Function derivative(RealType inputPartial, MathType ouputType, int errorMode) {
            return null;
        }

        @Override
        public Field resample(Set domain, int samplingMode, int errorMode) {
            return null;
        }

        @Override
        public DataShadow computeRanges(ShadowType type, DataShadow shadow) {
            return null;
        }

        @Override
        public Object clone() {
            return this;
        }

        @Override
        public boolean isMissing() {
            return true;
        }

        static {
            try {
                gradient = null;
            }
            catch (Exception e) {
                System.err.println("WaterVaporMixingRatio$MyFunction.<clint>: Couldn't initialize class: " + e);
                System.exit(1);
            }
        }
    }
}

