/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.quantities;

import java.rmi.RemoteException;
import ucar.visad.Util;
import ucar.visad.VisADMath;
import ucar.visad.quantities.CommonUnits;
import ucar.visad.quantities.ScalarQuantity;
import ucar.visad.quantities.WaterVaporMixingRatio;
import visad.Data;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.TypeException;
import visad.UnitException;
import visad.VisADException;

public class RelativeHumidity
extends ScalarQuantity {
    private static RelativeHumidity INSTANCE;
    private static Real gasConstantRatio;

    private RelativeHumidity() throws VisADException {
        this("RelativeHumidity");
    }

    protected RelativeHumidity(String name) throws VisADException {
        super(name, CommonUnits.PERCENT, (Set)null);
    }

    public static RealType getRealType() throws VisADException {
        return (RealType)RelativeHumidity.getRealTupleType().getComponent(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RealTupleType getRealTupleType() throws VisADException {
        if (INSTANCE != null) return INSTANCE.realTupleType();
        Class<RelativeHumidity> clazz = RelativeHumidity.class;
        synchronized (RelativeHumidity.class) {
            if (INSTANCE != null) return INSTANCE.realTupleType();
            INSTANCE = new RelativeHumidity();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE.realTupleType();
        }
    }

    public static Data create(Data mixingRatio, Data pressure, Data temperature) throws TypeException, VisADException, UnitException, RemoteException {
        Data satMixingRatio = WaterVaporMixingRatio.create(pressure, temperature);
        return Util.clone(VisADMath.divide(mixingRatio, satMixingRatio), RelativeHumidity.getRealType(), false, false);
    }
}

