/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.quantities;

import java.rmi.RemoteException;
import ucar.visad.Util;
import ucar.visad.VisADMath;
import ucar.visad.quantities.AirPressure;
import ucar.visad.quantities.AirTemperature;
import ucar.visad.quantities.CommonUnits;
import ucar.visad.quantities.DryAirGasConstant;
import ucar.visad.quantities.Gravity;
import ucar.visad.quantities.LatentHeatOfEvaporation;
import ucar.visad.quantities.MolecularWeightOfDryAir;
import ucar.visad.quantities.MolecularWeightOfWater;
import ucar.visad.quantities.Pressure;
import ucar.visad.quantities.SaturationMixingRatio;
import ucar.visad.quantities.ScalarQuantity;
import ucar.visad.quantities.SpecificHeatCapacityOfDryAirAtConstantPressure;
import ucar.visad.quantities.Temperature;
import visad.CommonUnit;
import visad.Data;
import visad.Real;
import visad.RealType;
import visad.SI;
import visad.TypeException;
import visad.UnitException;
import visad.VisADException;
import visad.data.units.DefaultUnitsDB;

public class PseudoAdiabaticLapseRate
extends ScalarQuantity {
    private static RealType realType;
    protected static Real one;
    protected static Real lOverRSubD;
    protected static Real epsilonL;
    protected static Real epsilonL2OverCSubPRSubD;

    private PseudoAdiabaticLapseRate() throws UnitException, VisADException {
        super(PseudoAdiabaticLapseRate.getRealType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RealType getRealType() throws VisADException {
        if (realType != null) return realType;
        Class<PseudoAdiabaticLapseRate> clazz = PseudoAdiabaticLapseRate.class;
        synchronized (PseudoAdiabaticLapseRate.class) {
            if (realType != null) return realType;
            realType = RealType.getRealType("PseudoAdiabaticLapseRate", SI.kelvin.divide(DefaultUnitsDB.instance().get("gpm")), null);
            // ** MonitorExit[var0] (shouldn't be in output)
            return realType;
        }
    }

    public static Data create(Data pressure, Data temperature) throws TypeException, VisADException, RemoteException {
        Util.vetType(Pressure.getRealType(), pressure);
        Util.vetType(Temperature.getRealType(), temperature);
        Data wSubSOverT = VisADMath.divide(SaturationMixingRatio.create(pressure, temperature), temperature);
        return Util.clone(VisADMath.divide(VisADMath.divide(VisADMath.add(one, VisADMath.multiply(lOverRSubD, wSubSOverT)), VisADMath.add(one, VisADMath.multiply(epsilonL2OverCSubPRSubD, VisADMath.divide(wSubSOverT, temperature)))), SpecificHeatCapacityOfDryAirAtConstantPressure.newReal()), PseudoAdiabaticLapseRate.getRealType());
    }

    public static void main(String[] args) throws Exception {
        Real lapseRate = (Real)VisADMath.multiply(Gravity.newReal(), PseudoAdiabaticLapseRate.create(new Real(AirPressure.getRealType(), 1000.0, CommonUnits.HECTOPASCAL), new Real(AirTemperature.getRealType(), 24.5, CommonUnits.CELSIUS)));
        System.out.println(SI.kelvin.divide(SI.meter.scale(1000.0)).toThis(lapseRate.getValue(), lapseRate.getUnit()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        try {
            if (one != null) return;
            Class<PseudoAdiabaticLapseRate> clazz = PseudoAdiabaticLapseRate.class;
            synchronized (PseudoAdiabaticLapseRate.class) {
                if (one != null) return;
                try {
                    one = new Real(RealType.getRealType("PseudoAdiabaticLapseRateOne", CommonUnit.dimensionless, null), 1.0);
                    lOverRSubD = (Real)LatentHeatOfEvaporation.newReal().divide(DryAirGasConstant.newReal());
                    epsilonL = (Real)MolecularWeightOfWater.newReal().divide(MolecularWeightOfDryAir.newReal()).multiply(LatentHeatOfEvaporation.newReal());
                    epsilonL2OverCSubPRSubD = (Real)MolecularWeightOfWater.newReal().divide(MolecularWeightOfDryAir.newReal()).multiply(lOverRSubD).multiply(LatentHeatOfEvaporation.newReal()).divide(SpecificHeatCapacityOfDryAirAtConstantPressure.newReal());
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                return;
            }
        }
        catch (Exception e) {
            System.err.println("PseudoAdiabaticLapseRate.<clinit>: Couldn't initialize class: " + e);
            System.exit(1);
        }
    }
}

