/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.quantities;

import java.rmi.RemoteException;
import ucar.visad.Util;
import ucar.visad.VisADMath;
import ucar.visad.quantities.AirPressure;
import ucar.visad.quantities.AirTemperature;
import ucar.visad.quantities.CommonUnits;
import ucar.visad.quantities.DryAirGasConstant;
import ucar.visad.quantities.SpecificHeatCapacityOfDryAirAtConstantPressure;
import visad.Data;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.SI;
import visad.TypeException;
import visad.UnimplementedException;
import visad.VisADException;

public class PotentialTemperature
extends AirTemperature {
    private static final PotentialTemperature INSTANCE;
    private static final Real exponent;
    private static final Real referencePressure;

    private PotentialTemperature() throws VisADException {
        this("PotentialTemperature");
    }

    protected PotentialTemperature(String name) throws VisADException {
        super(name, SI.kelvin);
    }

    public static RealType getRealType() throws VisADException {
        return (RealType)PotentialTemperature.getRealTupleType().getComponent(0);
    }

    public static RealTupleType getRealTupleType() throws VisADException {
        return INSTANCE.realTupleType();
    }

    public static Data create(Data pressure, Data temperature) throws TypeException, VisADException, RemoteException {
        Util.vetType(AirPressure.getRealType(), pressure);
        Util.vetType(AirTemperature.getRealType(), temperature);
        return Util.clone(VisADMath.multiply(temperature, PotentialTemperature.factor(pressure)), PotentialTemperature.getRealType());
    }

    protected static final Data factor(Data pressure) throws TypeException, UnimplementedException, VisADException, RemoteException {
        return VisADMath.pow(VisADMath.divide(referencePressure, pressure), exponent);
    }

    public static Data createAirTemperature(Data pressure, Data theta) throws TypeException, VisADException, RemoteException {
        Util.vetType(AirPressure.getRealType(), pressure);
        Util.vetType(PotentialTemperature.getRealType(), theta);
        return Util.clone(VisADMath.divide(theta, PotentialTemperature.factor(pressure)), AirTemperature.getRealType());
    }

    static {
        try {
            exponent = (Real)VisADMath.divide(DryAirGasConstant.newReal(), SpecificHeatCapacityOfDryAirAtConstantPressure.newReal());
            referencePressure = new Real(AirPressure.getRealType(), 1000.0, CommonUnits.MILLIBAR);
            INSTANCE = new PotentialTemperature();
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }
}

