/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.quantities;

import java.rmi.RemoteException;
import java.util.Arrays;
import ucar.visad.quantities.CartesianHorizontalWind;
import ucar.visad.quantities.Direction;
import ucar.visad.quantities.HorizontalWind;
import ucar.visad.quantities.Speed;
import visad.CoordinateSystem;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SI;
import visad.Unit;
import visad.VisADException;

public final class PolarHorizontalWind
extends HorizontalWind {
    private static PolarHorizontalWind INSTANCE;

    private PolarHorizontalWind() throws VisADException {
        super(new RealType[]{PolarHorizontalWind.getSpeedRealType(), PolarHorizontalWind.getDirectionRealType()}, new PolarCoordinateSystem(PolarHorizontalWind.getSpeedRealType().getDefaultUnit(), PolarHorizontalWind.getDirectionRealType().getDefaultUnit()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RealTupleType getRealTupleType() throws VisADException {
        if (INSTANCE != null) return INSTANCE.realTupleType();
        Class<PolarHorizontalWind> clazz = PolarHorizontalWind.class;
        synchronized (PolarHorizontalWind.class) {
            if (INSTANCE != null) return INSTANCE.realTupleType();
            INSTANCE = new PolarHorizontalWind();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE.realTupleType();
        }
    }

    public static RealType getSpeedRealType() throws VisADException {
        return Speed.getRealType();
    }

    public static RealType getDirectionRealType() throws VisADException {
        return Direction.getRealType();
    }

    public static RealTuple newRealTuple(RealTuple uv) throws VisADException, RemoteException {
        RealType spdType = PolarHorizontalWind.getSpeedRealType();
        RealType dirType = PolarHorizontalWind.getDirectionRealType();
        Unit spdUnit = spdType.getDefaultUnit();
        double u = ((Real)uv.getComponent(0)).getValue(spdUnit);
        double v = ((Real)uv.getComponent(1)).getValue(spdUnit);
        double speed = Math.sqrt(u * u + v * v);
        double direction = Math.atan2(-u, -v);
        if (direction < 0.0) {
            direction += Math.PI * 2;
        }
        direction = dirType.getDefaultUnit().toThis(direction, (Unit)SI.radian);
        return new RealTuple(PolarHorizontalWind.getRealTupleType(), new Real[]{new Real(spdType, speed), new Real(dirType, direction)}, null);
    }

    public static final class PolarCoordinateSystem
    extends CoordinateSystem {
        private static final double twoPI = Math.PI * 2;
        private final Unit[] internalUnits = new Unit[]{((RealType)CartesianHorizontalWind.getRealTupleType().getComponent(0)).getDefaultUnit(), SI.radian};

        public PolarCoordinateSystem(Unit speedUnit, Unit directionUnit) throws VisADException {
            this(CartesianHorizontalWind.getRealTupleType(), speedUnit, directionUnit);
        }

        public PolarCoordinateSystem(RealTupleType refType, Unit speedUnit, Unit directionUnit) throws VisADException {
            super(refType, new Unit[]{speedUnit, directionUnit});
        }

        @Override
        public double[][] toReference(double[][] values) throws VisADException {
            values = Unit.convertTuple(values, this.getCoordinateSystemUnits(), this.internalUnits);
            double[] westerlies = values[0];
            double[] southerlies = values[1];
            double[] speeds = values[0];
            double[] directions = values[1];
            int i = values[0].length;
            while (--i >= 0) {
                double speed = -speeds[i];
                double direction = directions[i];
                westerlies[i] = speed * Math.sin(direction);
                southerlies[i] = speed * Math.cos(direction);
            }
            return values;
        }

        @Override
        public float[][] toReference(float[][] values) throws VisADException {
            values = Unit.convertTuple(values, this.getCoordinateSystemUnits(), this.internalUnits);
            float[] westerlies = values[0];
            float[] southerlies = values[1];
            float[] speeds = values[0];
            float[] directions = values[1];
            int i = values[0].length;
            while (--i >= 0) {
                float speed = -speeds[i];
                float direction = directions[i];
                westerlies[i] = speed * (float)Math.sin(direction);
                southerlies[i] = speed * (float)Math.cos(direction);
            }
            return values;
        }

        @Override
        public double[][] fromReference(double[][] values) throws VisADException {
            double[] westerlies = values[0];
            double[] southerlies = values[1];
            double[] speeds = values[0];
            double[] directions = values[1];
            int i = values[0].length;
            while (--i >= 0) {
                double u = westerlies[i];
                double v = southerlies[i];
                speeds[i] = Math.sqrt(u * u + v * v);
                double direction = Math.atan2(-u, -v);
                if (direction < 0.0) {
                    direction += Math.PI * 2;
                }
                directions[i] = direction;
            }
            values = Unit.convertTuple(values, this.internalUnits, this.getCoordinateSystemUnits());
            return values;
        }

        @Override
        public float[][] fromReference(float[][] values) throws VisADException {
            float[] westerlies = values[0];
            float[] southerlies = values[1];
            float[] speeds = values[0];
            float[] directions = values[1];
            int i = values[0].length;
            while (--i >= 0) {
                float u = westerlies[i];
                float v = southerlies[i];
                speeds[i] = (float)Math.sqrt(u * u + v * v);
                double direction = Math.atan2(-u, -v);
                if (direction < 0.0) {
                    direction += Math.PI * 2;
                }
                directions[i] = (float)direction;
            }
            values = Unit.convertTuple(values, this.internalUnits, this.getCoordinateSystemUnits());
            return values;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof PolarCoordinateSystem)) {
                return false;
            }
            PolarCoordinateSystem that = (PolarCoordinateSystem)object;
            return Arrays.equals(this.internalUnits, that.internalUnits);
        }
    }
}

