/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.quantities;

import java.rmi.RemoteException;
import ucar.visad.Util;
import ucar.visad.VisADMath;
import ucar.visad.quantities.Density;
import ucar.visad.quantities.ScalarQuantity;
import visad.Data;
import visad.RealTupleType;
import visad.RealType;
import visad.SI;
import visad.Set;
import visad.TypeException;
import visad.VisADException;

public final class MassicVolume
extends ScalarQuantity {
    private static MassicVolume INSTANCE;

    private MassicVolume() throws VisADException {
        super("MassicVolume", SI.meter.pow(3).divide(SI.kilogram).clone("m3/kg"), (Set)null);
    }

    public static RealType getRealType() throws VisADException {
        return (RealType)MassicVolume.getRealTupleType().getComponent(0);
    }

    public static synchronized RealTupleType getRealTupleType() throws VisADException {
        if (INSTANCE == null) {
            INSTANCE = new MassicVolume();
        }
        return INSTANCE.realTupleType();
    }

    public static Data createFromDensity(Data density) throws TypeException, VisADException, RemoteException {
        Util.vetType(Density.getRealType(), density);
        return Util.clone(VisADMath.invert(density), MassicVolume.getRealType());
    }
}

