/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.quantities;

import java.rmi.RemoteException;
import java.util.Arrays;
import ucar.unidata.geoloc.Bearing;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.visad.quantities.CartesianHorizontalWind;
import ucar.visad.quantities.HorizontalWind;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.Data;
import visad.Field;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.GriddedSet;
import visad.IrregularSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.Set;
import visad.SetType;
import visad.SingletonSet;
import visad.Unit;
import visad.VisADException;

public final class GridRelativeHorizontalWind
extends HorizontalWind {
    public static boolean doNewCode = true;

    public GridRelativeHorizontalWind(SampledSet grid) throws VisADException {
        super(new RealType[]{GridRelativeHorizontalWind.xWindType(grid), GridRelativeHorizontalWind.yWindType(grid)});
    }

    public static RealType xWindType(SampledSet grid) throws VisADException {
        return RealType.getRealType(GridRelativeHorizontalWind.xComponentName(grid), DEFAULT_SPEED_UNIT);
    }

    public static RealType yWindType(SampledSet grid) throws VisADException {
        return RealType.getRealType(GridRelativeHorizontalWind.yComponentName(grid), DEFAULT_SPEED_UNIT);
    }

    private static String xComponentName(SampledSet grid) throws VisADException {
        return GridRelativeHorizontalWind.componentName(grid, 0);
    }

    private static String yComponentName(SampledSet grid) throws VisADException {
        return GridRelativeHorizontalWind.componentName(grid, 1);
    }

    private static String componentName(SampledSet grid, int i) throws VisADException {
        if (i < 0 || i >= grid.getDimension()) {
            throw new IllegalArgumentException(grid.toString());
        }
        return ((RealType)((SetType)grid.getType()).getDomain().getComponent(i)).getName() + "_Wind_Component";
    }

    public static Field cartesianHorizontalWind(Field rel) throws VisADException, RemoteException {
        RealTupleType domType = ((FunctionType)rel.getType()).getDomain();
        Field result = null;
        result = RealType.Time.equalsExceptNameButUnits(domType) || RealType.TimeInterval.equalsExceptNameButUnits(domType) ? GridRelativeHorizontalWind.timeSeriesCartesianHorizontalWind(rel) : GridRelativeHorizontalWind.cartesianHorizontalWind((FlatField)rel);
        return result;
    }

    public static Field timeSeriesCartesianHorizontalWind(Field rel) throws VisADException, RemoteException {
        int[] lengths;
        FunctionType outerFuncType = (FunctionType)rel.getType();
        RealTupleType outerDomType = outerFuncType.getDomain();
        if (!RealType.Time.equalsExceptNameButUnits(outerDomType) && RealType.TimeInterval.equalsExceptNameButUnits(outerDomType)) {
            throw new IllegalArgumentException(outerDomType.toString());
        }
        MathType innerFuncType = outerFuncType.getRange();
        if (!(innerFuncType instanceof FunctionType)) {
            throw new IllegalArgumentException(innerFuncType.toString());
        }
        Field innerField = (Field)rel.getSample(0);
        Set innerDom = innerField.getDomainSet();
        if (innerDom instanceof SingletonSet) {
            return rel;
        }
        if (innerDom instanceof GriddedSet && (lengths = ((GriddedSet)innerDom).getLengths())[0] == 1 && lengths[1] == 1) {
            return rel;
        }
        Unit[] rangeUnits = innerField.getDefaultRangeUnits();
        if (rangeUnits == null || rangeUnits[0] == null || rangeUnits[0].isDimensionless()) {
            rangeUnits = CartesianHorizontalWind.getEarthVectorType().getDefaultUnits();
        }
        FunctionType innerType = new FunctionType(((SetType)innerDom.getType()).getDomain(), CartesianHorizontalWind.getEarthVectorType());
        FlatField uvField = new FlatField(innerType, innerDom, (CoordinateSystem)null, (Set[])null, rangeUnits);
        FieldImpl result = new FieldImpl(new FunctionType(outerDomType, uvField.getType()), rel.getDomainSet());
        FlatField rHatField = doNewCode ? GridRelativeHorizontalWind.hatFieldNew(innerDom, 0) : GridRelativeHorizontalWind.hatFieldOld(innerDom, 0);
        FlatField sHatField = doNewCode ? GridRelativeHorizontalWind.hatFieldNew(innerDom, 1) : GridRelativeHorizontalWind.hatFieldOld(innerDom, 1);
        float[][] rHats = rHatField.getFloats(false);
        float[][] sHats = sHatField.getFloats(false);
        float[] us = new float[innerDom.getLength()];
        float[] vs = new float[us.length];
        int n = rel.getLength();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                innerField = (Field)rel.getSample(i);
                Set dom = innerField.getDomainSet();
                if (!innerDom.equals(dom)) {
                    innerDom = dom;
                    rHatField = doNewCode ? GridRelativeHorizontalWind.hatFieldNew(innerDom, 0) : GridRelativeHorizontalWind.hatFieldOld(innerDom, 0);
                    sHatField = doNewCode ? GridRelativeHorizontalWind.hatFieldNew(innerDom, 1) : GridRelativeHorizontalWind.hatFieldOld(innerDom, 1);
                    rHats = rHatField.getFloats(false);
                    sHats = sHatField.getFloats(false);
                }
                uvField = new FlatField(innerType, innerDom, (CoordinateSystem)null, (Set[])null, rangeUnits);
                us = new float[innerDom.getLength()];
                vs = new float[us.length];
            }
            float[][] rsWinds = innerField.getFloats(false);
            float[] rWinds = rsWinds[0];
            float[] sWinds = rsWinds[1];
            for (int j = 0; j < us.length; ++j) {
                us[j] = rWinds[j] * rHats[0][j] + sWinds[j] * sHats[0][j];
                vs[j] = rWinds[j] * rHats[1][j] + sWinds[j] * sHats[1][j];
            }
            uvField.setSamples(new float[][]{us, vs}, false);
            result.setSample(i, (Data)uvField, false);
        }
        return result;
    }

    private static FlatField hatFieldNew(Set grid, int index) throws VisADException, RemoteException {
        CoordinateSystem cs = grid.getCoordinateSystem();
        boolean hasCS = cs != null;
        RealTupleType rtt = hasCS ? cs.getReference() : ((SetType)grid.getType()).getDomain();
        int latI = rtt.getIndex(RealType.Latitude);
        if (latI == -1) {
            throw new IllegalArgumentException(rtt.toString());
        }
        int lonI = rtt.getIndex(RealType.Longitude);
        if (lonI == -1) {
            throw new IllegalArgumentException(rtt.toString());
        }
        if (grid.getManifoldDimension() < 2) {
            throw new IllegalArgumentException(grid.toString());
        }
        int[][] neighbors = grid.getNeighbors(index);
        LatLonPointImpl refPt = new LatLonPointImpl();
        LatLonPointImpl neiPt = new LatLonPointImpl();
        Bearing bearing = null;
        float[] hat1 = new float[2];
        float[] hat2 = new float[2];
        float[][] hat = new float[2][grid.getLength()];
        float[][] refCoords = null;
        float[][] neiCoords = null;
        float[][] domainSamples = grid.getSamples(false);
        float[][] fArray = refCoords = hasCS ? cs.toReference(Set.copyFloats(domainSamples)) : domainSamples;
        if (!hasCS || refCoords == domainSamples || Arrays.equals(refCoords[latI], domainSamples[latI]) && Arrays.equals(refCoords[lonI], domainSamples[lonI])) {
            if (index == 0) {
                Arrays.fill(hat[0], 1.0f);
                Arrays.fill(hat[1], 0.0f);
            } else {
                Arrays.fill(hat[0], 0.0f);
                Arrays.fill(hat[1], 1.0f);
            }
        } else {
            int backOffset = -180;
            boolean foreOffset = false;
            for (int i = 0; i < neighbors.length; ++i) {
                float lonAfter;
                float latAfter;
                float lonBefore;
                float latBefore;
                refPt.set(refCoords[latI][i], refCoords[lonI][i]);
                if (neighbors[i][0] < 0 || neighbors[i][0] >= neighbors.length) {
                    latBefore = Float.NaN;
                    lonBefore = Float.NaN;
                } else {
                    latBefore = refCoords[latI][neighbors[i][0]];
                    lonBefore = refCoords[lonI][neighbors[i][0]];
                }
                if (neighbors[i][1] < 0 || neighbors[i][1] >= neighbors.length) {
                    latAfter = Float.NaN;
                    lonAfter = Float.NaN;
                } else {
                    latAfter = refCoords[latI][neighbors[i][1]];
                    lonAfter = refCoords[lonI][neighbors[i][1]];
                }
                bearing = GridRelativeHorizontalWind.compute(refPt, neiPt, latBefore, lonBefore, backOffset, hat1);
                float d1 = (float)bearing.getDistance();
                bearing = GridRelativeHorizontalWind.compute(refPt, neiPt, latAfter, lonAfter, (float)foreOffset, hat2);
                float d2 = (float)bearing.getDistance();
                boolean bad1 = Double.isNaN(d1);
                boolean bad2 = Double.isNaN(d2);
                if (bad1 && bad2) {
                    hat[0][i] = Float.NaN;
                    hat[1][i] = Float.NaN;
                    continue;
                }
                if (bad1) {
                    hat[0][i] = hat2[0];
                    hat[1][i] = hat2[1];
                    continue;
                }
                if (bad2) {
                    hat[0][i] = hat1[0];
                    hat[1][i] = hat1[1];
                    continue;
                }
                float tot = d1 + d2;
                float c1 = d2 / tot;
                float c2 = d1 / tot;
                float xhat = c1 * hat1[0] + c2 * hat2[0];
                float yhat = c1 * hat1[1] + c2 * hat2[1];
                float mag = (float)Math.sqrt(xhat * xhat + yhat * yhat);
                hat[0][i] = xhat / mag;
                hat[1][i] = yhat / mag;
            }
        }
        FlatField hatField = new FlatField(new FunctionType(((SetType)grid.getType()).getDomain(), new RealTupleType(RealType.getRealType("xHat", CommonUnit.dimensionless), RealType.getRealType("yHat", CommonUnit.dimensionless))), grid);
        hatField.setSamples(hat, false);
        return hatField;
    }

    private static FlatField hatFieldOld(Set grid, int index) throws VisADException, RemoteException {
        CoordinateSystem cs = grid.getCoordinateSystem();
        boolean hasCS = cs != null;
        RealTupleType rtt = hasCS ? cs.getReference() : ((SetType)grid.getType()).getDomain();
        int latI = rtt.getIndex(RealType.Latitude);
        if (latI == -1) {
            throw new IllegalArgumentException(grid.toString());
        }
        int lonI = rtt.getIndex(RealType.Longitude);
        if (lonI == -1) {
            throw new IllegalArgumentException(grid.toString());
        }
        if (grid.getManifoldDimension() < 2) {
            throw new IllegalArgumentException(grid.toString());
        }
        int[][] neighbors = grid.getNeighbors(index);
        LatLonPointImpl refPt = new LatLonPointImpl();
        LatLonPointImpl neiPt = new LatLonPointImpl();
        Bearing bearing = null;
        float[] hat1 = new float[2];
        float[] hat2 = new float[2];
        float[][] hat = new float[2][grid.getLength()];
        for (int i = 0; i < neighbors.length; ++i) {
            float[][] refCoords = grid.indexToValue(new int[]{i});
            if (hasCS) {
                refCoords = cs.toReference(refCoords);
            }
            float[][] neiCoords = grid.indexToValue(neighbors[i]);
            if (hasCS) {
                neiCoords = cs.toReference(neiCoords);
            }
            refPt.set(refCoords[latI][0], refCoords[lonI][0]);
            bearing = GridRelativeHorizontalWind.compute(refPt, neiPt, neiCoords[latI][0], neiCoords[lonI][0], -180.0f, hat1);
            float d1 = (float)bearing.getDistance();
            bearing = GridRelativeHorizontalWind.compute(refPt, neiPt, neiCoords[latI][1], neiCoords[lonI][1], 0.0f, hat2);
            float d2 = (float)bearing.getDistance();
            boolean bad1 = Double.isNaN(d1);
            boolean bad2 = Double.isNaN(d2);
            if (bad1 && bad2) {
                hat[0][i] = Float.NaN;
                hat[1][i] = Float.NaN;
                continue;
            }
            if (bad1) {
                hat[0][i] = hat2[0];
                hat[1][i] = hat2[1];
                continue;
            }
            if (bad2) {
                hat[0][i] = hat1[0];
                hat[1][i] = hat1[1];
                continue;
            }
            float tot = d1 + d2;
            float c1 = d2 / tot;
            float c2 = d1 / tot;
            float xhat = c1 * hat1[0] + c2 * hat2[0];
            float yhat = c1 * hat1[1] + c2 * hat2[1];
            float mag = (float)Math.sqrt(xhat * xhat + yhat * yhat);
            hat[0][i] = xhat / mag;
            hat[1][i] = yhat / mag;
        }
        FlatField hatField = new FlatField(new FunctionType(((SetType)grid.getType()).getDomain(), new RealTupleType(RealType.getRealType("xHat", CommonUnit.dimensionless), RealType.getRealType("yHat", CommonUnit.dimensionless))), grid);
        hatField.setSamples(hat, false);
        return hatField;
    }

    private static Bearing compute(LatLonPointImpl refPt, LatLonPointImpl neiPt, float lat, float lon, float azTerm, float[] hat) {
        neiPt.set(lat, lon);
        Bearing bearing = Bearing.calculateBearing(refPt, neiPt);
        float az = (float)Math.toRadians(bearing.getAngle() + (double)azTerm);
        hat[0] = (float)Math.sin(az);
        hat[1] = (float)Math.cos(az);
        return bearing;
    }

    public static FlatField cartesianHorizontalWind(FlatField rel) throws VisADException, RemoteException {
        int[] lengths;
        FunctionType funcType = (FunctionType)rel.getType();
        MathType rangeType = funcType.getRange();
        if (rel.getRangeDimension() != 2) {
            throw new IllegalArgumentException(rangeType.toString());
        }
        Unit[] units = rel.getDefaultRangeUnits();
        if (!units[0].equals(units[1])) {
            throw new IllegalArgumentException(units.toString());
        }
        SampledSet grid = (SampledSet)rel.getDomainSet();
        if (grid instanceof SingletonSet) {
            return rel;
        }
        if (grid instanceof GriddedSet && (lengths = ((GriddedSet)grid).getLengths())[0] == 1 && lengths[1] == 1) {
            return rel;
        }
        FlatField abs = new FlatField(new FunctionType(funcType.getDomain(), CartesianHorizontalWind.getEarthVectorType()), (Set)grid, (CoordinateSystem[])null, rel.getRangeSets(), units);
        abs.setSamples(GridRelativeHorizontalWind.trueWind(rel.getFloats(), grid), false);
        return abs;
    }

    private static float[][] trueWind(float[][] gridWinds, SampledSet grid) throws VisADException {
        if (grid instanceof IrregularSet) {
            throw new IllegalArgumentException(grid.toString());
        }
        CoordinateSystem cs = grid.getCoordinateSystem();
        boolean hasCS = cs != null;
        RealTupleType rtt = hasCS ? cs.getReference() : ((SetType)grid.getType()).getDomain();
        int latI = rtt.getIndex(RealType.Latitude);
        if (latI == -1) {
            throw new IllegalArgumentException(rtt.toString());
        }
        int lonI = rtt.getIndex(RealType.Longitude);
        if (lonI == -1) {
            throw new IllegalArgumentException(rtt.toString());
        }
        if (grid.getManifoldDimension() < 2) {
            throw new IllegalArgumentException(grid.toString());
        }
        float[] us = new float[grid.getLength()];
        float[] vs = new float[grid.getLength()];
        Arrays.fill(us, 0.0f);
        Arrays.fill(vs, 0.0f);
        GridRelativeHorizontalWind.addComponent(grid, gridWinds, cs, 0, latI, lonI, us, vs);
        GridRelativeHorizontalWind.addComponent(grid, gridWinds, cs, 1, latI, lonI, us, vs);
        return new float[][]{us, vs};
    }

    private static void addComponent(SampledSet grid, float[][] gridWinds, CoordinateSystem cs, int index, int latI, int lonI, float[] us, float[] vs) throws VisADException {
        float[][] crefCoords;
        int[][] neighbors = grid.getNeighbors(index);
        LatLonPointImpl refPt = new LatLonPointImpl();
        LatLonPointImpl neiPt = new LatLonPointImpl();
        Bearing bearing = null;
        float[] uv1 = new float[2];
        float[] uv2 = new float[2];
        boolean hasCS = cs != null;
        float[][] domainSamples = grid.getSamples(false);
        float[][] fArray = crefCoords = hasCS ? cs.toReference(Set.copyFloats(domainSamples)) : domainSamples;
        if (!hasCS || crefCoords == domainSamples || Arrays.equals(crefCoords[latI], domainSamples[latI]) && Arrays.equals(crefCoords[lonI], domainSamples[lonI])) {
            System.arraycopy(gridWinds[0], 0, us, 0, us.length);
            System.arraycopy(gridWinds[1], 0, vs, 0, vs.length);
        } else {
            for (int i = 0; i < neighbors.length; ++i) {
                float[][] refCoords = grid.indexToValue(new int[]{i});
                if (hasCS) {
                    refCoords = cs.toReference(refCoords);
                }
                float[][] neiCoords = grid.indexToValue(neighbors[i]);
                if (hasCS) {
                    neiCoords = cs.toReference(neiCoords);
                }
                refPt.set(refCoords[latI][0], refCoords[lonI][0]);
                bearing = GridRelativeHorizontalWind.compute(refPt, neiPt, neiCoords[latI][0], neiCoords[lonI][0], -180.0f, gridWinds[index][i], uv1);
                float d1 = (float)bearing.getDistance();
                bearing = GridRelativeHorizontalWind.compute(refPt, neiPt, neiCoords[latI][1], neiCoords[lonI][1], 0.0f, gridWinds[index][i], uv2);
                float d2 = (float)bearing.getDistance();
                boolean bad1 = Double.isNaN(d1);
                boolean bad2 = Double.isNaN(d2);
                if (bad1 && bad2) {
                    us[i] = Float.NaN;
                    vs[i] = Float.NaN;
                    continue;
                }
                if (bad1) {
                    int n = i;
                    us[n] = us[n] + uv2[0];
                    int n2 = i;
                    vs[n2] = vs[n2] + uv2[1];
                    continue;
                }
                if (bad2) {
                    int n = i;
                    us[n] = us[n] + uv1[0];
                    int n3 = i;
                    vs[n3] = vs[n3] + uv1[1];
                    continue;
                }
                float tot = d1 + d2;
                float c1 = d2 / tot;
                float c2 = d1 / tot;
                int n = i;
                us[n] = us[n] + (c1 * uv1[0] + c2 * uv2[0]);
                int n4 = i;
                vs[n4] = vs[n4] + (c1 * uv1[1] + c2 * uv2[1]);
            }
        }
    }

    private static Bearing compute(LatLonPointImpl refPt, LatLonPointImpl neiPt, float lat, float lon, float azTerm, float wind, float[] uv) {
        neiPt.set(lat, lon);
        Bearing bearing = Bearing.calculateBearing(refPt, neiPt);
        float az = (float)Math.toRadians(bearing.getAngle() + (double)azTerm);
        float xhat = (float)Math.sin(az);
        float yhat = (float)Math.cos(az);
        uv[0] = xhat * wind;
        uv[1] = yhat * wind;
        return bearing;
    }
}

