/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.quantities;

import java.rmi.RemoteException;
import ucar.visad.Util;
import ucar.visad.quantities.Altitude;
import ucar.visad.quantities.Gravity;
import ucar.visad.quantities.ScalarQuantity;
import visad.CoordinateSystem;
import visad.Data;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SI;
import visad.ScaledUnit;
import visad.SingletonSet;
import visad.TypeException;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;

public final class GeopotentialAltitude
extends ScalarQuantity {
    private static GeopotentialAltitude INSTANCE;
    private static Unit geopotentialMeter;

    private GeopotentialAltitude() throws VisADException {
        super(GeopotentialAltitude.getRealType("GeopotentialAltitude", GeopotentialAltitude.getGeopotentialMeter()), new GeopotentialCoordinateSystem(Gravity.newReal(), Altitude.getRealType(), GeopotentialAltitude.getGeopotentialMeter()));
        try {
            this.realTupleType().setDefaultSet(new SingletonSet(new RealTuple(this.realTupleType(), new Real[]{new Real(this.realType(), 0.0)}, null)));
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Unit getGeopotentialMeter() throws VisADException {
        if (geopotentialMeter != null) return geopotentialMeter;
        Class<GeopotentialAltitude> clazz = GeopotentialAltitude.class;
        synchronized (GeopotentialAltitude.class) {
            try {
                if (geopotentialMeter != null) return geopotentialMeter;
                geopotentialMeter = GeopotentialAltitude.getGeopotentialUnit(SI.meter, Gravity.newReal()).clone("gpm");
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return geopotentialMeter;
        }
    }

    public static RealType getRealType() throws VisADException {
        return (RealType)GeopotentialAltitude.getRealTupleType().getComponent(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RealTupleType getRealTupleType() throws VisADException {
        if (INSTANCE != null) return INSTANCE.realTupleType();
        Class<GeopotentialAltitude> clazz = GeopotentialAltitude.class;
        synchronized (GeopotentialAltitude.class) {
            if (INSTANCE != null) return INSTANCE.realTupleType();
            INSTANCE = new GeopotentialAltitude();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE.realTupleType();
        }
    }

    public static Data fromAltitude(Data altitude) throws VisADException, RemoteException {
        return GeopotentialAltitude.fromAltitude(altitude, Gravity.newReal());
    }

    public static Data fromAltitude(Data altitude, Real gravity) throws VisADException, RemoteException {
        return Util.clone(altitude.multiply(gravity), GeopotentialAltitude.getRealType());
    }

    public static Data toAltitude(Data geopotentialAltitude, Real gravity) throws VisADException, RemoteException {
        return Util.clone(geopotentialAltitude.divide(gravity), Altitude.getRealType());
    }

    public static Data toAltitude(Data geopotentialAltitude) throws VisADException, RemoteException {
        return GeopotentialAltitude.toAltitude(geopotentialAltitude, Gravity.newReal());
    }

    public static double[] toAltitude(double[] geoAlts, Unit geoUnit, Real gravity, double[] altitudes, Unit altUnit) throws VisADException, RemoteException {
        return GeopotentialAltitude.toAltitude(geoAlts, geoUnit, gravity, altitudes, altUnit, true);
    }

    public static double[] toAltitude(double[] geoAlts, Unit geoUnit, Real gravity, double[] altitudes, Unit altUnit, boolean copy) throws VisADException, RemoteException {
        altitudes = geoUnit.toThat(geoAlts, GeopotentialAltitude.getGeopotentialUnit(altUnit, gravity), copy);
        double gVal = gravity.getValue();
        int i = 0;
        while (i < altitudes.length) {
            int n = i++;
            altitudes[n] = altitudes[n] / gVal;
        }
        return altitudes;
    }

    public static float[] toAltitude(float[] geoAlts, Unit geoUnit, Real gravity, float[] altitudes, Unit altUnit) throws VisADException, RemoteException {
        return GeopotentialAltitude.toAltitude(geoAlts, geoUnit, gravity, altitudes, altUnit, true);
    }

    public static float[] toAltitude(float[] geoAlts, Unit geoUnit, Real gravity, float[] altitudes, Unit altUnit, boolean copy) throws VisADException, RemoteException {
        altitudes = geoUnit.toThat(geoAlts, GeopotentialAltitude.getGeopotentialUnit(altUnit, gravity), copy);
        float gVal = (float)gravity.getValue();
        int i = 0;
        while (i < altitudes.length) {
            int n = i++;
            altitudes[n] = altitudes[n] / gVal;
        }
        return altitudes;
    }

    public static double[] toGeopotentialAltitude(double[] altitudes, Unit altUnit, Real gravity, double[] geoAlts, Unit geoUnit) throws VisADException, RemoteException {
        return GeopotentialAltitude.toGeopotentialAltitude(altitudes, altUnit, gravity, geoAlts, geoUnit, true);
    }

    public static double[] toGeopotentialAltitude(double[] altitudes, Unit altUnit, Real gravity, double[] geoAlts, Unit geoUnit, boolean copy) throws VisADException, RemoteException {
        System.arraycopy(geoUnit.toThis(altitudes, GeopotentialAltitude.getGeopotentialUnit(altUnit, gravity), copy), 0, geoAlts, 0, altitudes.length);
        return geoAlts;
    }

    public static float[] toGeopotentialAltitude(float[] altitudes, Unit altUnit, Real gravity, float[] geoAlts, Unit geoUnit) throws VisADException, RemoteException {
        return GeopotentialAltitude.toGeopotentialAltitude(altitudes, altUnit, gravity, geoAlts, geoUnit, true);
    }

    public static float[] toGeopotentialAltitude(float[] altitudes, Unit altUnit, Real gravity, float[] geoAlts, Unit geoUnit, boolean copy) throws VisADException, RemoteException {
        System.arraycopy(geoUnit.toThis(altitudes, GeopotentialAltitude.getGeopotentialUnit(altUnit, gravity)), 0, geoAlts, 0, altitudes.length);
        return geoAlts;
    }

    public static Unit getGeopotentialUnit(Unit altUnit) throws VisADException {
        Unit result = null;
        try {
            result = GeopotentialAltitude.getGeopotentialUnit(altUnit, Gravity.newReal());
        }
        catch (UnitException unitException) {
        }
        catch (TypeException typeException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    public static Unit getGeopotentialUnit(Unit altUnit, Real gravity) throws UnitException, TypeException, RemoteException, VisADException {
        Util.vetType(Gravity.getRealType(), gravity);
        if (!Unit.canConvert(altUnit, SI.meter)) {
            throw new UnitException("Altitude unit (" + altUnit + ") not a unit of length");
        }
        return ScaledUnit.create(gravity.getValue(), altUnit.multiply(gravity.getUnit()));
    }

    public static final class GeopotentialCoordinateSystem
    extends CoordinateSystem {
        private final Real gravity;

        public GeopotentialCoordinateSystem(Real gravity, RealType reference, Unit unit) throws VisADException {
            super(new RealTupleType(reference), new Unit[]{unit});
            this.gravity = gravity;
        }

        @Override
        public double[][] fromReference(double[][] values) throws VisADException {
            try {
                GeopotentialAltitude.toGeopotentialAltitude(values[0], this.getReferenceUnits()[0], this.gravity, values[0], this.getCoordinateSystemUnits()[0]);
            }
            catch (RemoteException e) {
                throw new VisADException("Couldn't access remote data: " + e);
            }
            return values;
        }

        @Override
        public float[][] fromReference(float[][] values) throws VisADException {
            try {
                GeopotentialAltitude.toGeopotentialAltitude(values[0], this.getReferenceUnits()[0], this.gravity, values[0], this.getCoordinateSystemUnits()[0]);
            }
            catch (RemoteException e) {
                throw new VisADException("Couldn't access remote data: " + e);
            }
            return values;
        }

        @Override
        public double[][] toReference(double[][] values) throws VisADException {
            try {
                GeopotentialAltitude.toAltitude(values[0], this.getCoordinateSystemUnits()[0], this.gravity, values[0], this.getReferenceUnits()[0]);
            }
            catch (RemoteException e) {
                throw new VisADException("Couldn't access remote data: " + e);
            }
            return values;
        }

        @Override
        public float[][] toReference(float[][] values) throws VisADException {
            try {
                GeopotentialAltitude.toAltitude(values[0], this.getCoordinateSystemUnits()[0], this.gravity, values[0], this.getReferenceUnits()[0]);
            }
            catch (RemoteException e) {
                throw new VisADException("Couldn't access remote data: " + e);
            }
            return values;
        }

        @Override
        public boolean equals(Object object) {
            boolean equals;
            if (!(object instanceof GeopotentialCoordinateSystem)) {
                equals = false;
            } else {
                GeopotentialCoordinateSystem that = (GeopotentialCoordinateSystem)object;
                equals = this.gravity.equals(that.gravity);
            }
            return equals;
        }
    }
}

