/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.quantities;

import visad.CommonUnit;
import visad.DerivedUnit;
import visad.SI;
import visad.ScaledUnit;
import visad.Unit;
import visad.data.units.Parser;

public class CommonUnits {
    public static final Unit PASCAL;
    public static final Unit HECTOPASCAL;
    public static final Unit MILLIBAR;
    public static final Unit CELSIUS;
    public static final Unit GRAMS_PER_KILOGRAM;
    public static final Unit METERS_PER_SECOND;
    public static final Unit HOUR;
    public static final Unit NAUTICAL_MILE;
    public static final Unit KNOT;
    public static final Unit DEGREE;
    public static final Unit FOOT;
    public static final Unit KILOMETER;
    public static final Unit MILE;
    public static final Unit MILLIMETER;
    public static final Unit PERCENT;

    private CommonUnits() {
    }

    static {
        Unit pascal = null;
        Unit millibar = null;
        Unit celsius = null;
        Unit gPerKg = null;
        Unit metersPerSecond = null;
        Unit nauticalMile = null;
        Unit knot = null;
        Unit hour = null;
        Unit foot = null;
        Unit kilometer = null;
        Unit mile = null;
        Unit millimeter = null;
        Unit percent = null;
        try {
            pascal = SI.kilogram.divide(SI.meter).divide(SI.second.pow(2)).clone("Pa");
            millibar = new ScaledUnit(100.0, (DerivedUnit)pascal).clone("hPa");
            celsius = SI.kelvin.shift(273.15).clone("Cel");
            gPerKg = new ScaledUnit(0.001).clone("g/kg");
            metersPerSecond = SI.meter.divide(SI.second).clone("m/s");
            nauticalMile = new ScaledUnit(1852.0, SI.meter).clone("nmi");
            hour = new ScaledUnit(3600.0, SI.second).clone("h");
            knot = nauticalMile.divide(hour).clone("kt");
            foot = SI.meter.scale(0.30479999999999996).clone("ft");
            kilometer = SI.meter.scale(1000.0).clone("km");
            mile = foot.scale(5280.0).clone("mi");
            millimeter = SI.meter.scale(0.001).clone("mm");
            percent = Parser.parse("%").clone("%");
        }
        catch (Exception e) {
            String reason = e.getMessage();
            System.err.println("Couldn't initialize CommonUnits class" + (reason == null ? "" : ": " + reason));
            e.printStackTrace();
        }
        PASCAL = pascal;
        HECTOPASCAL = millibar;
        MILLIBAR = millibar;
        CELSIUS = celsius;
        GRAMS_PER_KILOGRAM = gPerKg;
        METERS_PER_SECOND = metersPerSecond;
        HOUR = hour;
        NAUTICAL_MILE = nauticalMile;
        KNOT = knot;
        DEGREE = CommonUnit.degree;
        FOOT = foot;
        KILOMETER = kilometer;
        MILE = mile;
        MILLIMETER = millimeter;
        PERCENT = percent;
    }
}

