/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.quantities;

import java.rmi.RemoteException;
import ucar.visad.VisADMath;
import ucar.visad.quantities.Altitude;
import ucar.visad.quantities.CommonUnits;
import ucar.visad.quantities.Pressure;
import ucar.visad.quantities.ScalarQuantity;
import visad.CoordinateSystem;
import visad.Data;
import visad.EmpiricalCoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded1DSet;
import visad.GriddedSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SI;
import visad.SetType;
import visad.SingletonSet;
import visad.Unit;
import visad.VisADException;

public class AirPressure
extends Pressure {
    private static AirPressure INSTANCE;
    private static AirPressureCoordinateSystem standardAtmosphereCS;

    private AirPressure() throws VisADException {
        this("AirPressure");
    }

    protected AirPressure(String name) throws VisADException {
        super(AirPressure.getRealType(name, CommonUnits.HECTOPASCAL), AirPressure.getStandardCoordinateSystem(name));
        try {
            this.realTupleType().setDefaultSet(new SingletonSet(new RealTuple(this.realTupleType(), new Real[]{new Real(this.realType(), 1013.25, CommonUnits.HECTOPASCAL)}, null)));
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AirPressureCoordinateSystem getStandardAtmosphereCS() throws VisADException {
        if (standardAtmosphereCS != null) return standardAtmosphereCS;
        Class<AirPressure> clazz = AirPressure.class;
        synchronized (AirPressure.class) {
            if (standardAtmosphereCS != null) return standardAtmosphereCS;
            standardAtmosphereCS = (AirPressureCoordinateSystem)AirPressure.getStandardCoordinateSystem(AirPressure.getRealType().getName());
            // ** MonitorExit[var0] (shouldn't be in output)
            return standardAtmosphereCS;
        }
    }

    private static CoordinateSystem getStandardCoordinateSystem(String name) throws VisADException {
        StandardAtmosphereCoordinateSystem cs = null;
        try {
            cs = new StandardAtmosphereCoordinateSystem();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return cs;
    }

    public static RealType getRealType() throws VisADException {
        return (RealType)AirPressure.getRealTupleType().getComponent(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RealTupleType getRealTupleType() throws VisADException {
        if (INSTANCE != null) return INSTANCE.realTupleType();
        Class<AirPressure> clazz = AirPressure.class;
        synchronized (AirPressure.class) {
            if (INSTANCE != null) return INSTANCE.realTupleType();
            INSTANCE = new AirPressure();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE.realTupleType();
        }
    }

    public static Data toAltitude(Data pressure) throws VisADException {
        Real altitude = pressure instanceof Real ? new Real(Altitude.getRealType(), AirPressure.getStandardAtmosphereCS().toReference(new double[][]{{((Real)pressure).getValue(AirPressure.getStandardAtmosphereCS().getCoordinateSystemUnits()[0])}})[0][0], AirPressure.getStandardAtmosphereCS().getReferenceUnits()[0]) : null;
        return altitude;
    }

    public static Data fromAltitude(Data altitude) throws VisADException {
        Real pressure = altitude instanceof Real ? new Real(AirPressure.getRealType(), AirPressure.getStandardAtmosphereCS().fromReference(new double[][]{{((Real)altitude).getValue(AirPressure.getStandardAtmosphereCS().getReferenceUnits()[0])}})[0][0], AirPressure.getStandardAtmosphereCS().getCoordinateSystemUnits()[0]) : null;
        return pressure;
    }

    public static class StandardAtmosphereCoordinateSystem
    extends AirPressureCoordinateSystem {
        private static float[] pressures = new float[]{1013.25f, 954.61f, 898.76f, 845.59f, 795.01f, 746.91f, 701.21f, 657.8f, 616.6f, 577.52f, 540.48f, 505.39f, 472.17f, 440.75f, 411.05f, 382.99f, 356.51f, 331.54f, 303.0f, 285.85f, 264.99f, 226.99f, 193.99f, 165.79f, 141.7f, 121.11f, 103.52f, 88.497f, 75.652f, 64.674f, 55.293f, 25.492f, 11.97f, 5.746f, 2.871f, 1.491f, 0.798f, 0.22f, 0.052f, 0.01f};
        private static float[] alts = new float[]{0.0f, 500.0f, 1000.0f, 1500.0f, 2000.0f, 2500.0f, 3000.0f, 3500.0f, 4000.0f, 4500.0f, 5000.0f, 5500.0f, 6000.0f, 6500.0f, 7000.0f, 7500.0f, 8000.0f, 8500.0f, 9000.0f, 9500.0f, 10000.0f, 11000.0f, 12000.0f, 13000.0f, 14000.0f, 15000.0f, 16000.0f, 17000.0f, 18000.0f, 19000.0f, 20000.0f, 25000.0f, 30000.0f, 35000.0f, 40000.0f, 45000.0f, 50000.0f, 60000.0f, 70000.0f, 80000.0f};

        public StandardAtmosphereCoordinateSystem() throws VisADException, RemoteException {
            super(new Gridded1DSet((MathType)ScalarQuantity.getRealType("AirPressure", CommonUnits.HECTOPASCAL), (float[][])new float[][]{pressures}, 40, (CoordinateSystem)null, new Unit[]{CommonUnits.HECTOPASCAL}, (ErrorEstimate[])null), new Gridded1DSet((MathType)Altitude.getRealType(), (float[][])new float[][]{alts}, 40, (CoordinateSystem)null, new Unit[]{SI.meter}, (ErrorEstimate[])null));
        }
    }

    public static class AirPressureCoordinateSystem
    extends CoordinateSystem {
        private final double p0Float;
        private final double p0Double;
        private final EmpiricalCoordinateSystem logPCoordSys;

        public AirPressureCoordinateSystem(Gridded1DSet pressure, Gridded1DSet altitude) throws VisADException, RemoteException {
            super(((SetType)altitude.getType()).getDomain(), pressure.getSetUnits());
            this.p0Double = this.p0Float = (double)pressure.getHi()[0];
            this.logPCoordSys = new EmpiricalCoordinateSystem((GriddedSet)VisADMath.log(VisADMath.divide(pressure, new Real((RealType)((SetType)pressure.getType()).getDomain().getComponent(0), this.p0Double, pressure.getSetUnits()[0]))), altitude);
        }

        @Override
        public double[][] toReference(double[][] pressures) throws VisADException {
            double[] vals = pressures[0];
            int i = vals.length;
            while (--i >= 0) {
                vals[i] = Math.log(vals[i] / this.p0Double);
            }
            return this.logPCoordSys.toReference(pressures);
        }

        @Override
        public double[][] fromReference(double[][] altitudes) throws VisADException {
            altitudes = this.logPCoordSys.fromReference(altitudes);
            double[] vals = altitudes[0];
            int i = vals.length;
            while (--i >= 0) {
                vals[i] = this.p0Double * Math.exp(vals[i]);
            }
            return altitudes;
        }

        @Override
        public float[][] toReference(float[][] pressures) throws VisADException {
            float[] vals = pressures[0];
            int i = vals.length;
            while (--i >= 0) {
                vals[i] = (float)Math.log((double)vals[i] / this.p0Double);
            }
            return this.logPCoordSys.toReference(pressures);
        }

        @Override
        public float[][] fromReference(float[][] altitudes) throws VisADException {
            altitudes = this.logPCoordSys.fromReference(altitudes);
            float[] vals = altitudes[0];
            int i = vals.length;
            while (--i >= 0) {
                vals[i] = (float)(this.p0Double * Math.exp(vals[i]));
            }
            return altitudes;
        }

        @Override
        public boolean equals(Object obj) {
            AirPressureCoordinateSystem that;
            boolean equals = !(obj instanceof AirPressureCoordinateSystem) ? false : this == (that = (AirPressureCoordinateSystem)obj) || this.p0Double == that.p0Double && this.logPCoordSys.equals(that.logPCoordSys);
            return equals;
        }
    }
}

