/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.quantities;

import java.rmi.RemoteException;
import ucar.visad.Util;
import ucar.visad.VisADMath;
import ucar.visad.quantities.Density;
import ucar.visad.quantities.DewPoint;
import ucar.visad.quantities.DryAirGasConstant;
import ucar.visad.quantities.InSituAirTemperature;
import ucar.visad.quantities.Pressure;
import ucar.visad.quantities.Temperature;
import ucar.visad.quantities.VirtualTemperature;
import visad.Data;
import visad.FlatField;
import visad.RealTupleType;
import visad.RealType;
import visad.SI;
import visad.TypeException;
import visad.UnimplementedException;
import visad.VisADException;
import visad.util.DataUtility;

public final class AirDensity
extends Density {
    private static AirDensity INSTANCE;

    private AirDensity() throws VisADException {
        super("AirDensity", SI.kilogram.scale(0.001).divide(SI.meter.pow(3)).clone("g/m3"));
    }

    public static RealType getRealType() throws VisADException {
        return (RealType)AirDensity.getRealTupleType().getComponent(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RealTupleType getRealTupleType() throws VisADException {
        if (INSTANCE != null) return INSTANCE.realTupleType();
        Class<AirDensity> clazz = AirDensity.class;
        synchronized (AirDensity.class) {
            if (INSTANCE != null) return INSTANCE.realTupleType();
            INSTANCE = new AirDensity();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE.realTupleType();
        }
    }

    public static Data create(Data pressure, Data inSituAirTemperature, Data dewPoint) throws TypeException, UnimplementedException, VisADException, RemoteException {
        return AirDensity.create(pressure, VirtualTemperature.createFromDewPoint(pressure, inSituAirTemperature, dewPoint));
    }

    public static Data create(Data pressure, Data temperature) throws TypeException, UnimplementedException, VisADException, RemoteException {
        Util.vetType(Pressure.getRealType(), pressure);
        Util.vetType(Temperature.getRealType(), temperature);
        return Util.clone(VisADMath.divide(pressure, VisADMath.multiply(DryAirGasConstant.newReal(), temperature)), AirDensity.getRealType());
    }

    public static FlatField create(FlatField inputField) throws TypeException, UnimplementedException, VisADException, RemoteException {
        return (FlatField)AirDensity.create(inputField.getDomainSet(), DataUtility.ensureRange(inputField, InSituAirTemperature.getRealType()), DataUtility.ensureRange(inputField, DewPoint.getRealType()));
    }
}

